/*
 * Decompiled with CFR 0.152.
 */
package sun.jkernel;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import sun.jkernel.StandaloneMessageDigest;

public class DigestOutputStream
extends FilterOutputStream {
    private static final String DEFAULT_ALGORITHM = "SHA-1";
    private final boolean debug = false;
    private StandaloneMessageDigest smd = null;
    protected volatile OutputStream out;

    private void initDigest(String string) throws NoSuchAlgorithmException {
        this.smd = StandaloneMessageDigest.getInstance(string);
    }

    public DigestOutputStream(OutputStream outputStream, String string) throws NoSuchAlgorithmException {
        super(outputStream);
        this.initDigest(string);
        this.out = outputStream;
    }

    public DigestOutputStream(OutputStream outputStream) {
        super(outputStream);
        try {
            this.initDigest(DEFAULT_ALGORITHM);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("DigestOutputStream() unknown algorithm");
        }
    }

    public void write(int n) throws IOException {
        super.write(n);
        byte[] byArray = new byte[]{(byte)(n & 0xFF)};
        this.smd.update(byArray, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException("null array in DigestOutputStream.write");
        }
        if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        this.out.write(byArray, n, n2);
        this.smd.update(byArray, n, n2);
    }

    public void close() throws IOException {
        super.close();
    }

    public byte[] getCheckValue() {
        byte[] byArray = this.smd.digest();
        this.smd.reset();
        return byArray;
    }

    public void flush() throws IOException {
        super.flush();
    }
}

