define(['secondsToDate', 'base64', 'getRequest', 'config', 'getMousePos', 'queryUrlParams'], function (secondsToDate, Base64, getRequest, Config, getMousePos, queryUrlParams) {
    'use strict';

    /* 
     * 屏蔽右键菜单 
     * 
     * */
    document.oncontextmenu = function(e) {
        e = e || event;
        e.returnValue = false;
    };

    var filterSelect = { 'INPUT': true, 'TEXTAREA': true };
    /**
     * 屏蔽选中
     * 
     */
    document.onselectstart = function(e) {
        e = e || event;
        var element = e.srcElement;
        if (e) {
            if (filterSelect[element.tagName]) {
                return true;
            }
        }
        return false;
    };

    /**
     * 屏蔽图片拖动
     */
    document.ondragstart = function(e) {
        e = e || event;
        var element = e.srcElement;
        if (e) {
            if (filterSelect[element.tagName]) {
                return true;
            }
        }
        return false;
    };

    var checkIsClient = function () {
        window.isClient = Boolean(window.cefQuery || window.qwebkit);
        return window.cefQuery || window.qwebkit;
    }
    
    return {
        secondsToDate: secondsToDate,
        getRequest: getRequest,
        config: Config,
        getMousePos: getMousePos,
        queryUrlParams: queryUrlParams,
        checkIsClient: checkIsClient
    }
});