define([], function (require, exports, module) {
    'use strict';

	/**
	* 根据毫秒数转换成 yyyy-mm-dd日期格式
	* @param b: 毫秒数	
	*		 seg: 分隔符， 默认'-'
	* @return 返回yyyy-mm-dd日期格式
	*/
    var secondsToDate = function(b, seg, flag) {
        seg = seg ? seg : '-';
        var c = new Date();
        c.setTime(b);//转成时间型

        //拆解格式
        var y = c.getFullYear();
        var m = c.getMonth() + 1;//0-11代表月份,0是一月
        var mstr = m.toString();
        if (mstr.length < 2) {//不足两位加零
            mstr = '0' + mstr;
        }
        var d = c.getDate();
        var dstr = d.toString();//不足两位加零
        if (dstr.length < 2) {
            dstr = '0' + dstr;
        }

        if (flag) {
            var hour = c.getHours(),
                min = c.getMinutes();
            hour = hour < 10 ? ('0' + hour) : hour;
            min = min < 10 ? ('0' + min) : min;
            return y + seg + mstr + seg + dstr + ' ' + hour + ':' + min;
        } else {
            return y + seg + mstr + seg + dstr;
        }
    }

    return secondsToDate;
});