define(['wpsApi', 'utils'], (WpsApi, Utils) => {
    'use strict';
    
    class DataServices{
        constructor() {
            this.servicesArr = {};
        }
        
        add(name, url, dataMap, action) {
            this.servicesArr[name] = new Curd(url, dataMap, action);
        }

        getType() {
            return this.servicesArr;
        }

        get(name) {
            return this.servicesArr[name]
        }
    }

    class Curd {
        constructor (url, dataMap, action) {
            this.action = $.extend(true, {
                query: {},
                create: {},
                update: {},
                remove: {}
            }, action);
            this.params = { url: url, headers: { 'X-Requested-With': 'XMLHttpRequest' } };
            this.dataMap = dataMap;
            this.init();
        }

        init() {
            for (let type in this.action) {
                this[type] = (params, cbObj) => {
                    return this.send(params, type, cbObj);
                };
            }
        }

        /**
         * 请求封装
         * @param {Object} params 数组数据
         * @param {Object} cbObj 回调函数
         * cbObj = {
         *      success: Function[Object]
         *      fail: Function[Object]
         * }
         */
        send(params, type, cbObj) {
            let _params = $.extend(true, {}, this.params, this.action[type], params);

            for (let x in this.dataMap) {
                if (_params.hasOwnProperty(x)) {
                    let reg = new RegExp(':\\b' + x + '\\b');
                    _params.url = _params.url.replace(reg, _params[x]);
                }
            }

            let timeout = 15000;
            let httpHandler = null;
                
            if (Utils.checkIsClient()) {
                _params.headers = $.extend(true, {}, { cookie: 'wps_sid=' + window.WPSSID });
                if (!_params.method || _params.method.toUpperCase() === 'GET') {
                    httpHandler = WpsApi.jsGet(_params.url, _params.data || {}, timeout, _params.headers);
                } else {
                    httpHandler = WpsApi.jsPost(_params.url, _params.data || {}, timeout, _params.headers);
                }
                
                //断网处理
                httpHandler.fail((resp) => {
                    if (resp.msg === 'timeout' && resp.result === 'fail' && resp.msgcode === 400) {
                        if (cbObj !== undefined) cbObj['fail'](resp);
                        throw Error('接口出错了！！！！');
                    }
                });
            } else {
                httpHandler = $.ajax({
                    timeout: 15000,
                    type: _params.method || 'POST',
                    cache: _params.cache,
                    url: _params.url,
                    dataType: _params.dataType || 'json',
                    data: _params.data || {},
                    async: _params.async,   //是否异步调用
                    jsonpCallback: _params.jsonpCallbackName || "",	//自定义的jsonp回调函数名称，默认为jQuery自动生成的随机函数名
                    xhrFields: {
                        'withCredentials': true
                    },
                    headers: _params.headers
                });
                //断网处理
                httpHandler.fail(function (xml, status) {
                    throw Error('接口出错了！！！！');
                    if (cbObj !== undefined) cbObj['fail'](xml, status);
                });
            }

            return httpHandler;
        }
    }

    let ins = new DataServices(),
        startupPrev = 'https://docer.wps.cn/partner.php/api/startup',
        docerPrev = 'https://docer.wps.cn/v3.php',
        cdnPrev = 'https://api.vas.wpscdn.cn/docer/startup',
        vipSrc = 'http://vip.wps.cn',
        accSrc = 'https://account.wps.cn';

    ins.add('user', vipSrc + '/:_method_', { _method_: '@_method_' }, {
        getUserInfo: { method: 'GET', _method_: 'userinfo' },
        getMsgPriviliage: { method: 'GET', _method_: 'pay_config/v1/config/member' }
    });

    ins.add('privilege', ':_method_', { _method_: '@_method_' }, {
        // 特权信息
        privilegeData: { method: 'GET', _method_: '', jsonpCallback: 'privilegeData', dataType: 'jsonp'}
    });

    ins.add('account', accSrc + '/:_method_', { _method_: '@_method_' }, {
        // 认证信息
        identity: { method: 'GET', _method_: 'p/identity' },
        // 生日信息
        birthday: { method: 'GET', _method_: 'api/v3/mine' }
    });
    // http://vipapi.wps.cn/v2/vip_center/dashboard 123.59.33.175:8760
    ins.add('home', ':_method_', {_method_: '@_method_'}, {
        getDashboard: { method: 'GET', _method_: 'http://vipapi.wps.cn/v2/vip_center/dashboard'},
        getLoginSignUrl: { method: 'GET', _method_: 'http://vipapi.wps.cn/v2/vip_center/redirect'},
        getRecommendMbs: {method: 'GET', _method_: 'http://api.vas.wpscdn.cn/docer/startup/v3/recommend/mbs'},
        getSelfCloud: {method: 'GET', _method_: 'http://qing.wps.cn/api/v3/spaces'}
    });

    return ins;
});