define(['dataServices', 'wpsApi'], function (DataServices, WpsApi) {
    
        var modulePath = 'info';
        avalon.templateCache[modulePath] = $('#info_template').html();
        avalon.vmodels.globleVM.content = modulePath;

        var model = avalon.define({
    
            $id: 'infoVM',

            // 用户信息
            userInfo: DATAMODEL.userInfo,

            // 是否需要认证
            need_verify: false,

            // 是否已经点击过修改头像或第三方登录
            hasClickEditPic: false,

            // 是否已经点击过认证
            hasClickVerify: false,

            // 生日
            birthday: '',

            // 购买会员链接
            buyMemberUrl: '',

            // 购买会员文案
            buyMemberBtn: '',

            // 会员状态
            memberState: '',

            // 当窗口小于580时，则为true，添加对应样式
            smallWin: false,

            /**
             * 入口
             */
            init: function () {

                model.getBirthday();
                model.redPoint();
                model.handleMemberState();
                avalon.vmodels.globleVM.sendCollect('首页-展示量');
                model.need_verify = DATAMODEL.need_verify;

                window.onresize = function(){
                    if (document.documentElement.clientHeight < 580) {
                        model.smallWin = true;
                    } else {
                        model.smallWin = false;
                    }
                }
            },

            // 获取生日信息
            getBirthday: function () {
                DataServices.get('account').birthday({data: {}}).done(function(resp) {
                    resp = resp.data;
                    if (resp.result == 'ok') {
                        model.birthday = resp.extends.profile.birth_time;
                    }
                });
            },

            // 姓名和认证位置，红点判断是否显示
            redPoint: function () {
                
                // 第三方登录或未点击修改头像，显示其红点
                model.hasClickEditPic = DATAMODEL.isThirdLoing || localStorage.getItem('hasClickEditPic-'+model.userInfo.userid);
                model.hasClickVerify = localStorage.getItem('hasClickVerify-'+model.userInfo.userid);
            },

            // 修改头像
            editPic: function () {
                model.hasClickEditPic = true;
                localStorage.setItem('hasClickEditPic-'+model.userInfo.userid, true);

                // 同步更新tab状态
                avalon.vmodels.globleVM.redPointCheck();
            },

            // 立即认证
            goVerify: function () {
                model.hasClickVerify = true;
                localStorage.setItem('hasClickVerify-'+model.userInfo.userid, true);

                // 同步更新tab状态
                avalon.vmodels.globleVM.redPointCheck();
            },

            // 会员状态处理
            handleMemberState: function () {
                var vip = model.userInfo.vip,
                    enable = vip.enabled,
                    arr = [],
                    memberName = vip.name;
                avalon.each(enable, function (i, k) {
                    arr.push(k.name)
                });
                model.memberState = arr.join('+');


                if (memberName == '超级会员') {
                    model.buyMemberBtn = '续费会员';
                } else {
                    model.buyMemberBtn = '升级会员'
                }

                if (memberName == '注册用户') {
                    model.memberState = '注册用户';
                    model.buyMemberUrl = 'pc_center&recommendid=20&payconfig=personalcenter_vip&position=info_apply';
                } else {
                    model.buyMemberUrl = 'pc_center&recommendid=40&payconfig=personalcenter_vip&position=info_apply';
                }

                // 企业用户会员状态添加后缀标识
                if (vip.memberid >= 100) {
                    if (enable.length == 0) {
                        model.memberState = '注册用户';
                    }
                    model.memberState += '(企业用户)';
                }
            },

            $skipArray: ['getBirthday']
        });
    
        model.init();
        avalon.scan();
        return model;
    });
    