/*
 * File: cloud.js
 * Project: home
 * File Created: Wednesday, 14th March 2018 11:35:23 am
 * Author: cipo wu (236307533@qq.com)
 * -----
 * Last Modified: Thu Mar 15 2018
 * Modified By: cipo wu
 * -----
 * Copyright WPS
 */
define(['utils'], (Utils) => {
    'use strict';
    let model = avalon.define({
        $id: 'moneyVM',

        htmlStr: $('#money_template').html(),

        data: '',

        /**
         * 格式化URL
         */
        formatSignUrl: function () {
            if (!window.DATAMODEL.userInfo.userid) {
                location.reload();
                return;
            }
            model.signUrl = 'http://vipapi.wps.cn/v2/vip_center/jump?_t=' + (+new Date()) + '&sid=' + window.WPSSID + '&goto=' + encodeURIComponent('http://vipapi.wps.cn/sign/panel');
        },

        // 签到弹出窗
        signUrlFlag: false,
        signUrl: '',
        signAnimationFlag: false,
        recordPos: { x: 0, y: 0 },

        signClose: function () {
            model.signAnimationFlag = false;
            if (model.recordPos.x != 0) {
                $('#signLayout').animate({
                    'left': model.recordPos.x,
                    'top': model.recordPos.y
                }, 1000);
            }
            setTimeout(function () {
                model.signUrlFlag = false;
                $.publish('updateHomeData', [{ homeFlag: true, cloudFlag: false }]);
            }, 800);
        },
        
        signOpen: function (event) {
            if (!window.DATAMODEL.userInfo.userid) {
                location.reload();
                return;
            }
            model.signUrlFlag = true;
            model.signAnimationFlag = true;
            model.recordPos = Utils.getMousePos(event);
            $('#signLayout').css({
                'left': model.recordPos.x,
                'top': model.recordPos.y,
            });
            $('#signLayout').animate({
                'left': '50%',
                'top': '50%'
            }, 800);
        },

        /**
         * 初始化签到弹窗
         */
        signAnimation: () => {
            if (Utils.queryUrlParams('sign') !== '') {
                if (Utils.queryUrlParams('sign') === '1') {
                    model.signUrlFlag = true;
                    model.signAnimationFlag = true;
                } else {
                    model.signUrlFlag = false;
                    model.signAnimationFlag = false;
                }
            }
        },

        init: (val) => {
            model.data = val;
            model.signAnimation();
            console.info('个人主页-钱包区域展示-正常');
        }
    });

    return model;
});