/*
 * File: cloud.js
 * Project: home
 * File Created: Wednesday, 14th March 2018 2:43:48 pm
 * Author: cipo wu (236307533@qq.com)
 * -----
 * Last Modified: Mon Mar 19 2018
 * Modified By: cipo wu
 * -----
 * Copyright WPS
 */
define(['dataServices'], (DataServices) => {
    'use strict';
    let mbytes = 1048576;    // 1M
    let speed = 0;  // 目前加载状态的数值
    let currentMemberSpace = 0; // 当前身份最大空间
    let superMaxSpace = 0;  // 超级会员最大存储空间
    let timerID = 0;

    let clearStatus = () => {
        speed = 0;
        currentMemberSpace = 0;
        superMaxSpace = 0;
        timerID = 0;
    };

    let _getCvasDOM = () => {
        return $("#cloud_canvas")[0] || null;
    };

    let _clearCvas = () => {
        _getCvasDOM().getContext("2d").clearRect(0, 0, _getCvasDOM().width, _getCvasDOM().height);
    };

    let model = avalon.define({
        $id: 'cloudVM',

        htmlStr: $('#cloud_template').html(),

        data: '',   // 所有数据源

        hoverFlag: false,  // hover升级按钮

        toggleUpgradeBtn: (flag) => {
            model.hoverFlag = flag;
            speed = 0;
            if (model.selfCloudData === '') {
                model.maxValue = 0;
            } else {
                if (flag) { // 超级会员空间
                    superMaxSpace = model.toM(model.data[40].user_space);
                    model.maxPercentage2circle(superMaxSpace);
                } else {
                    model.maxPercentage2circle(currentMemberSpace);
                }
            }
            if (_getCvasDOM()) {
                _clearCvas();
                model.drawCircle();
            }
            // console.log(currentMemberSpace, superMaxSpace, model.maxValue);
        },
        
        /**
         * canvas动画
         */
        drawCircle: () => {
            /* if (!window.DATAMODEL.isLogin) {
                // 防止canvas数据未及时返回
                setTimeout(function() {
                    model.drawCircle.apply(model);
                });
                return;
            } */
            if (!_getCvasDOM()) return false;
            let canvas2D = _getCvasDOM().getContext("2d");
            let cvasH = _getCvasDOM().height;
            let cvasW = _getCvasDOM().width;
            if (speed > model.maxValue || speed >= 100) {
                window.cancelAnimationFrame(timerID);
                // canvas2D.closePath(); //路径结束
            } else {
                if (model.maxValue < 1) {
                    speed += 1;
                } else {
                    speed += 0.8;
                }
                _clearCvas();
                /**
                 * 绘制加载的字体
                 */
                (function () {
                    canvas2D.save();
                    canvas2D.fillStyle = "#4a79fe";
                    canvas2D.textBaseline = 'middle';
                    canvas2D.textAlign = 'center';
                    canvas2D.font = "bold 36px 微软雅黑"; //设置字体大小和字体
                    var val = 0;
                    if (model.maxValue == 0) {
                        val = 0;
                    } else if (model.maxValue < 1) {
                        val = 1;
                    } else {
                        val = speed > 100 ? 100 : speed.toFixed(1);
                    }
                    //绘制字体，并且指定位置
                    canvas2D.fillText(val, cvasW / 2, cvasH / 2);
                    canvas2D.font = "bold 18px 微软雅黑";
                    var distance = 0;
                    if (val.toString().length === 2) {
                        distance = 30;
                    } else {
                        if (val.toString().length === 1) {
                            distance = 15;
                        } else {
                            if (val == 100) {
                                distance = 45;
                            } else {
                                distance = 50;
                            }
                        }
                    }
                    canvas2D.fillText("%", cvasW / 2 + distance + 4, cvasH / 2 - 6);
                    canvas2D.stroke(); //执行绘制
                    canvas2D.restore();
                })();

                /**
                 * 绘制 外圈加载条
                 */
                (function () {
                    canvas2D.save();//保存当前环境的状态(save和restore可以保证样式属性只运用于该段canvas元素)
                    canvas2D.lineWidth = 7; //设置线宽
                    canvas2D.lineCap = "round";

                    canvas2D.beginPath(); //灰底色路径开始
                    canvas2D.arc(cvasW / 2, cvasH / 2, 72, 0, 360 * Math.PI / 180, false);
                    canvas2D.strokeStyle = "#eaeaea";
                    canvas2D.stroke();

                    canvas2D.beginPath(); //路径开始
                    canvas2D.arc(cvasW / 2, cvasH / 2, 72, Math.PI * 0.5, Math.PI * 0.5 + speed * Math.PI * 2 / 100, false); //用于绘制圆弧canvas2D.arc(x坐标，y坐标，半径，起始角度，终止角度，顺时针/逆时针)
                    var grd = canvas2D.createLinearGradient(30, 30, 150, 150);
                    //添加颜色断点
                    grd.addColorStop(0, "#52eff5");
                    grd.addColorStop(0.3, "#4a7dfe");
                    grd.addColorStop(0.7, "#4a7dfe");
                    grd.addColorStop(1, "#9b3aff");
                    //应用渐变
                    canvas2D.strokeStyle = grd;
                    canvas2D.stroke(); //绘制
                    canvas2D.restore();//返回之前保存过的路径状态和属性
                })();
                //requestAnimationFrame作用与setTimeInterval一样，不同的是它会根据浏览器的刷新频率自动调整动画的时间间隔。
                timerID = window.requestAnimationFrame(function () {
                    model.drawCircle();
                }, _getCvasDOM());
            }
        },

        selfCloudData: '',  // 云文档自己空间数据

        selfCloudSpacesUsed: 0,   // 已用云文档空间

        selfCloudGroupsCount: 0,    // 已创建团队数目

        maxValue: 0,    // 百分比最大值 用户已用空间 / 总的空间

        preDealData: () => {
            if (!_getCvasDOM().getContext) {
                throw Error('你的浏览器不支持Canvas!');
            } else {
                _clearCvas();
                if (model.selfCloudData !== '') {
                    speed = 0;
                    model.selfCloudGroupsCount = model.selfCloudData.$model.groups ? model.selfCloudData.$model.groups.length : 0;   // 已创建团队数
                    model.selfCloudSpacesUsed = model.toM(model.selfCloudData.$model.used);  // 已用空间（单位MB）
                    if (model.data !== '') {
                        currentMemberSpace = model.toM(model.data[model.memberid].user_space); // 当前身份最大空间
                        superMaxSpace = model.toM(model.data[40].user_space);   // 超级会员最大空间
                    } else {
                        currentMemberSpace = 1024;
                    }
                    model.maxPercentage2circle(currentMemberSpace);   // 圆圈最大值
                    console.log(`当前身份空间：${currentMemberSpace} - 超级会员空间：${superMaxSpace} - 百分比最大多少：${model.maxValue}`);
                    model.drawCircle();
                } else {
                    clearStatus();
                    model.selfCloudData = '';
                    model.selfCloudSpacesUsed = 0;
                    model.maxValue = 0.1;
                    model.drawCircle();
                }
            }
        },

        /**
         * 末尾添加G/ or M/标识
         * @param {Number} val 大小 单位M
         * @param {Boolean} flag 是否添加G or M
         * @param {String} addStr 是否添加末尾字符
         */
        isM2G: (val, flag, addStr) => {
            val = Number(val);
            let Msize = 0;
            let endStr = '';
            if (val > 1024) {
                Msize = window.parseInt(val / 1024);
                endStr = 'G'
            } else {
                Msize = val;
                endStr = 'M';
            }
            return Msize + (flag ? endStr : 0) + addStr;
        },

        /**
         * 转化为M单位
         */
        toM: (val) => {
            return window.parseInt(val / mbytes);
        },

        /**
         * 百分比格式输出
         * @param {Number} val 空间总数
         */
        maxPercentage2circle: (val) => {
            let num = Number((model.selfCloudSpacesUsed / val * 100).toFixed(1));
            model.maxValue = num === 0 ? 0.1 : num;
        },

        userInfo: {},
        memberid: 0,
        init: (val, cloudResult) => {
            clearStatus();
            if (cloudResult !== undefined) model.selfCloudData = cloudResult;   // 云文档自己空间数据
            model.data = val;
            model.userInfo = window.DATAMODEL.userInfo.$model ? window.DATAMODEL.userInfo.$model : window.DATAMODEL.userInfo;
            model.memberid = window.DATAMODEL.userInfo.vip.memberid;    // 用户类型ID
            setTimeout(() => {
                model.preDealData();
            }, 100);
            console.info('个人主页-云文档区域展示-正常');
        }
    });

    /**
     * 初始界面的canvas
     */
    let staticCanvas = () => {
        let initCanvas = $('#cloud_error_canvas')[0];
        let canvas2D = initCanvas.getContext("2d");
        let cvasH = initCanvas.height;
        let cvasW = initCanvas.width;
        canvas2D.save();
        canvas2D.fillStyle = "#4a79fe";
        canvas2D.textBaseline = 'middle';
        canvas2D.textAlign = 'center';
        canvas2D.font = "bold 36px 微软雅黑"; //设置字体大小和字体
        //绘制字体，并且指定位置
        canvas2D.fillText(0, cvasW / 2, cvasH / 2);
        canvas2D.font = "bold 18px 微软雅黑";
        canvas2D.fillText("%", cvasW / 2 + 19, cvasH / 2 - 6);
        canvas2D.stroke(); //执行绘制
        canvas2D.restore();

        canvas2D.save();//保存当前环境的状态(save和restore可以保证样式属性只运用于该段canvas元素)
        canvas2D.lineWidth = 7; //设置线宽
        canvas2D.lineCap = "round";

        canvas2D.beginPath(); //灰底色路径开始
        canvas2D.arc(cvasW / 2, cvasH / 2, 72, 0, 360 * Math.PI / 180, false);
        canvas2D.strokeStyle = "#eaeaea";
        canvas2D.stroke();
        canvas2D.beginPath(); //路径开始
        canvas2D.arc(cvasW / 2, cvasH / 2, 72, Math.PI * 0.5, Math.PI * 0.5, false); //用于绘制圆弧canvas2D.arc(x坐标，y坐标，半径，起始角度，终止角度，顺时针/逆时针)
        var grd = canvas2D.createLinearGradient(30, 30, 150, 150);
        //添加颜色断点
        grd.addColorStop(0, "#52eff5");
        grd.addColorStop(0.3, "#4a7dfe");
        grd.addColorStop(0.7, "#4a7dfe");
        grd.addColorStop(1, "#9b3aff");
        //应用渐变
        canvas2D.strokeStyle = grd;
        canvas2D.stroke(); //绘制
        canvas2D.restore();//返回之前保存过的路径状态和属性
    }
    
    if ($('#cloud_error_canvas').length > 0) {
        staticCanvas();
    }
    
    return model;

});