define([], function() {

    var DomLazyLoad = function() {

        var domLoadedCache = {};

        return {
            add: function(domName, bindObj, successcb) {
                if (domLoadedCache[domName]) {
                    return;
                }

                var targetNode = $('textarea[lazy="' + domName + '"]');

                if (!targetNode.length) {
                    avalon.log('【' + domName + '】节点不存在');
                    return;
                }

                var node = null;

                $('textarea[lazy="' + domName + '"]').replaceWith(function(i, dom) {
                    var parseHtml = $('<div/>').html(dom).text();
                    node = $(parseHtml);
                    domLoadedCache[domName] = true;
                    // avalon.log('【' + domName + '】节点创建完成');
                    return node;
                })

                if (node) {

                    var vmodel = {};

                    switch (typeof bindObj) {
                        case 'string':
                            vmodel = avalon.vmodels[bindObj] || {};
                            break;
                        case 'object':
                            vmodel = bindObj.$id ? bindObj : {};
                            break;
                    }

                    if (vmodel.$id) {
                        avalon.ready(function() {
                            avalon.scan(node[0], vmodel);
                            node = null;
                            // avalon.log('【' + domName + '】节点绑定 ' + vmodel.$id + ' 成功');
                            typeof successcb === 'function' && successcb();
                        })
                    } else {
                        typeof successcb === 'function' && successcb();
                    }
                }

            }
        }
    }()

    return DomLazyLoad;
})
