/**
 *  面板tab
 */

define(['dataServices'], function(DataServices) {
    //缓存面板tab插件
    var componentVM = {};

    avalon.component('ms:panelmenu', {

        // 三种类型 home info security
        focusTab: 'home',
        choiceTab: function (name) {
            if (avalon.vmodels.globleVM.networkFailFlag) {
                location.reload();
                return;
            }
            componentVM.focusTab = name;
            location.href = '#!/' + name;
        },

        // 个人资料是否需要显示红点
        needRedPoint: false,
        // 红点右方提示文案
        remindText: '',
        // 是否需要认证
        need_verify: false,

        // 初始化面板
        initPanel: function () {
            var that = componentVM;
            // 获取认证信息
            DataServices.get('account').identity({data: {}}).done(function(resp) {
                resp = resp.data;
                if (resp.result == 'ok') {
                    that.need_verify = DATAMODEL.need_verify = resp.need_verify;
                    // 红点及其文案判断
                    that.redPointCheck();
                }
            });

            // 记录组件id，个人资料页同步tab红点状态用到
            DATAMODEL.panelmenuId = componentVM.$id;
        },

        // 红点及其文案判断
        redPointCheck: function () {
            // 第三方登录
            DATAMODEL.isThirdLoing = true,
                loginmode = DATAMODEL.userInfo.loginmode;
            // 非第三方登录
            if (loginmode.indexOf('phone') != -1 || loginmode.indexOf('email') != -1) {
                DATAMODEL.isThirdLoing = false;
            }
            // 已点击过头像或者第三方登录自动获取头像
            if (localStorage.getItem('hasClickEditPic-'+DATAMODEL.userInfo.userid) || DATAMODEL.isThirdLoing) {
                
                // 临时屏蔽认证部分逻辑
                componentVM.needRedPoint = false;
                return;


                // 已经认证或者已经点过认证按钮
                if (!componentVM.need_verify || localStorage.getItem('hasClickVerify-'+DATAMODEL.userInfo.userid)) {
                    componentVM.needRedPoint = false;
                } else {
                    componentVM.needRedPoint = true;
                    componentVM.remindText = '仍未实名认证';
                }

            } else {
                componentVM.needRedPoint = true;
                componentVM.remindText = '仍未设置头像';
            }
        },

        $dispose: function() {

        },

        $childReady: function () {

        },

        $ready: function(vm) {
            componentVM = vm;
            vm.onInit(vm);
        },

        $init: function (vm) {},

        $template: $('#panelmenu_template').html()
    });
});