(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["IMKITModule"] = factory();
	else
		root["IMKITModule"] = factory();
})(this, function() {
return webpackJsonpIMKITModule([0],[
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	module.exports = __webpack_require__(1);


/***/ },
/* 1 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _$BaseRoot = __webpack_require__(3);

	__webpack_require__(4);

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	__webpack_require__(210);

	__webpack_require__(213);

	__webpack_require__(214);

	__webpack_require__(235);

	__webpack_require__(242);

	__webpack_require__(243);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Log = _$BaseRoot.Base.Log;
	var Win = _$ChatRoot2.default.Win,
	    Action = _$ChatRoot2.default.Action,
	    Constant = _$ChatRoot2.default.Constant;


	Log.setPrefix('NEW_RECENT');
	Log.setLogLevel(0);

	window.onEventNotify = function (name, response) {
	  try {
	    response = !response || /^\d+$/.test(response) ? response : JSON.parse(response);
	  } catch (e) {}

	  Log.orange('onEventNotify ' + name, response);

	  _$IMSDKRoot2.default.fire && _$IMSDKRoot2.default.fire(name, response, true);
	};

	window.addEventListener('DOMContentLoaded', function () {
	  Win.container = document.getElementById(Constant.EL_ID.CONTAINER);

	  Action.start.action();
	});

/***/ },
/* 2 */,
/* 3 */,
/* 4 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	var _$ConvertRoot = __webpack_require__(202);

	var _$ConvertRoot2 = _interopRequireDefault(_$ConvertRoot);

	var _tribeBoard = __webpack_require__(203);

	var _tribeBoard2 = _interopRequireDefault(_tribeBoard);

	var _carousel = __webpack_require__(204);

	var _carousel2 = _interopRequireDefault(_carousel);

	var _normalMsg = __webpack_require__(205);

	var _normalMsg2 = _interopRequireDefault(_normalMsg);

	var _intelligentReply = __webpack_require__(206);

	var _intelligentReply2 = _interopRequireDefault(_intelligentReply);

	var _dateSplit = __webpack_require__(207);

	var _dateSplit2 = _interopRequireDefault(_dateSplit);

	var _msgReadStatus = __webpack_require__(208);

	var _msgReadStatus2 = _interopRequireDefault(_msgReadStatus);

	var _menuTrigger = __webpack_require__(209);

	var _menuTrigger2 = _interopRequireDefault(_menuTrigger);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Template = _$ChatRoot2.default.Template;

	var BaseTemplate = _$ConvertRoot2.default.Template;

	BaseTemplate.normalMsg = _normalMsg2.default.trim();
	BaseTemplate.msgReadStatus = _msgReadStatus2.default.trim();
	Template.tribeBoard = _tribeBoard2.default.trim();
	Template.carousel = _carousel2.default.trim();
	Template.intelligentReply = _intelligentReply2.default.trim();
	Template.dateSplit = _dateSplit2.default.trim();
	Template.menuTrigger = _menuTrigger2.default.trim();

	exports.default = Template;

/***/ },
/* 5 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$BaseRoot2 = _interopRequireDefault(_$BaseRoot);

	var _actions = __webpack_require__(6);

	var _actions2 = _interopRequireDefault(_actions);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _template = __webpack_require__(154);

	var _template2 = _interopRequireDefault(_template);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _plugins = __webpack_require__(167);

	var _plugins2 = _interopRequireDefault(_plugins);

	var _convert = __webpack_require__(183);

	var _convert2 = _interopRequireDefault(_convert);

	var _event = __webpack_require__(162);

	var _event2 = _interopRequireDefault(_event);

	var _coms = __webpack_require__(200);

	var _coms2 = _interopRequireDefault(_coms);

	__webpack_require__(201);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	//window.addEventListener('DOMContentLoaded', function() {
	//  Win.container = document.getElementById(Constant.EL_ID.CONTAINER);
	//  Action.start.action();
	//});

	var c = {
	  Action: _actions2.default,
	  SDK: _sdk2.default,
	  Template: _template2.default,
	  Win: _window2.default,
	  Plugin: _plugins2.default,
	  Convert: _convert2.default,
	  Event: _event2.default,
	  Constant: _constants2.default,
	  Coms: _coms2.default
	};

	_$BaseRoot2.default.Chat = c;

	exports.default = c;

/***/ },
/* 6 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _getCurrentLoginID = __webpack_require__(7);

	var _getCurrentLoginID2 = _interopRequireDefault(_getCurrentLoginID);

	var _getCurrentConversationID = __webpack_require__(152);

	var _getCurrentConversationID2 = _interopRequireDefault(_getCurrentConversationID);

	var _bindEvents = __webpack_require__(161);

	var _bindEvents2 = _interopRequireDefault(_bindEvents);

	var _conversationChange = __webpack_require__(166);

	var _conversationChange2 = _interopRequireDefault(_conversationChange);

	var _getMsg = __webpack_require__(181);

	var _getMsg2 = _interopRequireDefault(_getMsg);

	var _getOfflineMsg = __webpack_require__(184);

	var _getOfflineMsg2 = _interopRequireDefault(_getOfflineMsg);

	var _getNewMsg = __webpack_require__(185);

	var _getNewMsg2 = _interopRequireDefault(_getNewMsg);

	var _getLocalHistoryMsg = __webpack_require__(186);

	var _getLocalHistoryMsg2 = _interopRequireDefault(_getLocalHistoryMsg);

	var _getRemoteHistoryMsg = __webpack_require__(187);

	var _getRemoteHistoryMsg2 = _interopRequireDefault(_getRemoteHistoryMsg);

	var _receiveMsg = __webpack_require__(188);

	var _receiveMsg2 = _interopRequireDefault(_receiveMsg);

	var _getSentMsg = __webpack_require__(189);

	var _getSentMsg2 = _interopRequireDefault(_getSentMsg);

	var _conversationClose = __webpack_require__(190);

	var _conversationClose2 = _interopRequireDefault(_conversationClose);

	var _netDisconnect = __webpack_require__(191);

	var _netDisconnect2 = _interopRequireDefault(_netDisconnect);

	var _netReconnect = __webpack_require__(192);

	var _netReconnect2 = _interopRequireDefault(_netReconnect);

	var _cacheEvent = __webpack_require__(193);

	var _cacheEvent2 = _interopRequireDefault(_cacheEvent);

	var _enteringStatusChange = __webpack_require__(194);

	var _enteringStatusChange2 = _interopRequireDefault(_enteringStatusChange);

	var _sendMsgStatusChange = __webpack_require__(195);

	var _sendMsgStatusChange2 = _interopRequireDefault(_sendMsgStatusChange);

	var _fireCacheEvent = __webpack_require__(196);

	var _fireCacheEvent2 = _interopRequireDefault(_fireCacheEvent);

	var _getMoreHistoryMsg = __webpack_require__(197);

	var _getMoreHistoryMsg2 = _interopRequireDefault(_getMoreHistoryMsg);

	var _start = __webpack_require__(198);

	var _start2 = _interopRequireDefault(_start);

	var _msgRecall = __webpack_require__(199);

	var _msgRecall2 = _interopRequireDefault(_msgRecall);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	exports.default = {
	  getCurrentLoginID: _getCurrentLoginID2.default,
	  getCurrentConversationID: _getCurrentConversationID2.default,
	  bindEvents: _bindEvents2.default,
	  conversationChange: _conversationChange2.default,
	  getMsg: _getMsg2.default,
	  getOfflineMsg: _getOfflineMsg2.default,
	  getNewMsg: _getNewMsg2.default,
	  getLocalHistoryMsg: _getLocalHistoryMsg2.default,
	  getRemoteHistoryMsg: _getRemoteHistoryMsg2.default,
	  receiveMsg: _receiveMsg2.default,
	  getSentMsg: _getSentMsg2.default,
	  conversationClose: _conversationClose2.default,
	  netDisconnect: _netDisconnect2.default,
	  netReconnect: _netReconnect2.default,
	  enteringStatusChange: _enteringStatusChange2.default,
	  sendMsgStatusChange: _sendMsgStatusChange2.default,
	  fireCacheEvent: _fireCacheEvent2.default,
	  cacheEvent: _cacheEvent2.default,
	  getMoreHistoryMsg: _getMoreHistoryMsg2.default,
	  start: _start2.default,
	  msgRecall: _msgRecall2.default
	}; /**
	    * Created by neitherzhu on 2016/12/5.
	    */

/***/ },
/* 7 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$ConvertRoot = __webpack_require__(8);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _index = __webpack_require__(6);

	var _index2 = _interopRequireDefault(_index);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var getCurrentLoginID = new _$BaseRoot.Base.ActionCreator(); /**
	                                                              * Created by neitherzhu on 2016/12/5.
	                                                              * 获取当前登录的用户
	                                                              */


	getCurrentLoginID.actionType = 'async';
	getCurrentLoginID.doAsync = function () {
	  return _sdk2.default.getCurrentLoginID();
	};

	getCurrentLoginID.after(function (context, data) {
	  _window2.default.loginID = data;
	}).after(function (context, data) {
	  (0, _$ConvertRoot.shareWin)(_window2.default);
	}).after(function (context, data) {
	  _index2.default.bindEvents.action(data);
	});

	getCurrentLoginID.error = function (err) {
	  console.error('Action getCurrentLoginID Error', err);
	};

	exports.default = getCurrentLoginID;

/***/ },
/* 8 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _convert = __webpack_require__(36);

	var _convert2 = _interopRequireDefault(_convert);

	var _callbacks = __webpack_require__(38);

	var _callbacks2 = _interopRequireDefault(_callbacks);

	var _normalMsgFormater = __webpack_require__(39);

	var _normalMsgFormater2 = _interopRequireDefault(_normalMsgFormater);

	var _defaultParse = __webpack_require__(62);

	var _defaultParse2 = _interopRequireDefault(_defaultParse);

	var _systemMsgFormater = __webpack_require__(66);

	var _systemMsgFormater2 = _interopRequireDefault(_systemMsgFormater);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _actions = __webpack_require__(84);

	var _actions2 = _interopRequireDefault(_actions);

	var _plugins = __webpack_require__(104);

	var _plugins2 = _interopRequireDefault(_plugins);

	__webpack_require__(126);

	__webpack_require__(137);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = {
	  Constant: _constants2.default,
	  SDK: _sdk2.default,
	  Template: _template2.default,
	  Convert: _convert2.default,
	  Callbacks: _callbacks2.default,
	  Plugin: _plugins2.default,
	  Action: _actions2.default,
	  MsgFormats: {
	    SingleNormalMsgFormat: _normalMsgFormater2.default,
	    TribeNormalMsgFormat: _normalMsgFormater2.default,
	    SystemFormat: _systemMsgFormater2.default,
	    NormalMsgDefaultParse: _defaultParse2.default
	  },
	  shareWin: function shareWin(w) {
	    _window2.default.sharedWin = w;
	    _plugins2.default.init({ container: _window2.default.sharedWin.container });
	    _actions2.default.start.action();
	  }
	};
	module.exports = exports['default'];

/***/ },
/* 9 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _i18n = __webpack_require__(10);

	var _i18n2 = _interopRequireDefault(_i18n);

	var _sdk = __webpack_require__(11);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _taobao = __webpack_require__(12);

	var _taobao2 = _interopRequireDefault(_taobao);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var SINGLE = 1;
	var TRIBE = 2;
	var DISCUSSION = 3;

	var TYPE = {
	  SINGLE: SINGLE,
	  TRIBE: TRIBE,
	  DISCUSSION: DISCUSSION
	};

	var TaobaoConversationType = 4;

	exports.default = {
	  TEXT_MODE: 'DEFAULT',
	  LANGUAGE: 'CN',
	  TYPE: TYPE,
	  RECALL_LIMIT: 120000,
	  SDK_PREFIX_MAP: {
	    1: _sdk2.default.SINGLE_SDK_PREFIX,
	    2: _sdk2.default.TRIBE_SDK_PREFIX,
	    3: _sdk2.default.TRIBE_SDK_PREFIX
	  },
	  CLS: {
	    // 样式相关
	    // 宝贝详情卡片样式
	    SNAPSHOT: 'item-snapshot-wrap',
	    // 图片加载中样式
	    IMAGE_LOADING: 'imui-msg-img-loading',
	    // 消息状态容器样式
	    MSG_STATUS_CONTAINER: 'imui-msg-status',
	    // 语音加载中样式
	    AUDIO_PLAYING: 'imui-msg-audio-playing',
	    // 语音消息容器
	    AUDIO_WITH_STYLE: 'imui-msg-audio',
	    // 群@消息样式
	    AT_MSG_WITH_STYLE: 'imui-msg-atmsg',
	    // 群@消息已读/全部已读样式
	    COMPLETED_AT_MSG: 'at-msg-done',

	    // 操作相关
	    // 消息容器
	    MSG_CONTAINER: 'J_msg',
	    // 语音
	    AUDIO: 'J_audio',
	    // 图片
	    IMAGE: 'J_imImage',
	    // 群@未已读/未完全已读时,点击打开群@详情
	    OPEN_READ_STATE_COUNT_DETAIL: 'J_openReadStateCountDetail',
	    // 重新加载图片按钮
	    RELOAD_IMAGE: 'J_reloadImage',
	    // 重新加载语音按钮
	    RELOAD_AUDIO: 'J_reloadAudio',
	    // 打开文件设置
	    OPEN_FILE_SETTING: 'J_openFileSetting',
	    // 打开震屏设置
	    OPEN_SHAKE_SETTING: 'J_openShakeSetting',
	    // 预览文件
	    PREVIEW_FILE: 'J_previewFile',
	    // 打开文件夹
	    OPEN_FILE_FOLDER: 'J_openFolder',
	    // 取消上传文件
	    CANCEL_UPLOAD_FILE: 'J_cancelUpload',
	    // 取消下载文件
	    CANCEL_DOWNLOAD_FILE: 'J_cancelDownload',
	    // 下载文件
	    DOWNLOAD_FILE: 'J_downloadFile',
	    // 打开语音转文字设置
	    OPEN_AUDIO_TEXT_SETTING: 'J_goAudioTextSetting',
	    // 发起视频聊天
	    FACE_TIME_TRIGGER: 'J_faceTimeTrigger'
	  },
	  PIC_PROTOCOL: 'pic:',
	  EMOTION_PROTOCOL: 'pic:imemotion',
	  EMOJI_PROTOCOL: 'pic:imemoji',

	  Event: {
	    CONVERSATION_PREFIX: 'im.uiutil.',
	    WINDOW_COVER_CHANGE_SUFFIX: 'onIMWindowCoverChange',
	    // 群@消息变更,自定义事件
	    ON_AT_MSG_STATUS_CHANGE: 'atMsgStatusChange',
	    // 群@消息已读
	    ON_AT_MSG_READ: 'im.tribemsg.onTribeAtMsgReaded',
	    // 语音播放停止
	    ON_AUDIO_STOP: 'im.audioplayer.onAudioStop',
	    // 文件传输状态变更
	    UPDATE_FILE_TRANSFER_INFO: 'im.filetransfer.onUpdateTransferInfo',
	    // 文件信息变更
	    UPDATE_FILE_INFO: 'im.filetransfer.onUpdateCloudFileMeta',
	    // 发送的单聊消息状态变更
	    CHAT_SEND_MSG_STATUS_CHANGE: 'im.singlemsg.onSendMsgStatus',
	    // 发送的群聊/讨论组消息状态变更
	    TRIBE_SEND_MSG_STATUS_CHANGE: 'im.tribemsg.onSendMsgStatus',
	    // 发送消息状态变更
	    SEND_MSG_STATUS_CHANGE: 'sendMsgStatusChange',
	    // 单聊消息状态变更
	    MSG_STATUS_CHANGE: 'msgStatusChange',
	    // 单聊消息已读事件
	    CHAT_MSG_READ: 'im.singlemsg.onFlagMyMsgReaded',

	    SHOW_AUDIO_TEXT_SETTING_CHANGE: 'im.bizutil.onShowAudio2textOptionChange'
	  },
	  FILE_MAX_LEN: 22,
	  SDK: _sdk2.default,
	  TAOBAOSDK: _taobao2.default,
	  I18N: _i18n2.default,
	  TEMP20014_SMALL_MAX_WIDTH: 264,
	  TEMP20014_MIDDLE_MAX_WIDTH: 324,
	  TEMP20014_LARGE_MAX_WIDTH: 396,
	  TaobaoConversationType: TaobaoConversationType
	};
	module.exports = exports['default'];

/***/ },
/* 10 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	/**
	 * Created by neitherzhu on 2016/12/6.
	 * 多语言
	 */
	exports.default = {
	  CN: {
	    YOU: '你',
	    INVITE_IN_TRIBE: '${inviter}把 "${users}" 加入群',
	    INVITE_IN_DISCUSSION: '${inviter}把 "${users}" 加入讨论组',
	    EXIT_TRIBE: '群成员"${user}"退出了群聊',
	    SELF_EXIT_TRIBE: '你退出了群聊"${display}"',
	    EXIT_DISCUSSION: '"${user}"退出了讨论组',
	    SELF_EXIT_DISCUSSION: '你退出了讨论组"${display}"',
	    KICK_OUT_TRIBE: '${manager}将"${user}"移出了群聊',
	    SELF_KICK_OUT_TRIBE: '你将"${user}"移出了群聊',
	    SELF_BE_KICKED_OUT_TRIBE: '你已经被移出了群聊${display}',
	    JOIN_TRIBE: '欢迎新成员"${user}"加入群聊',
	    SELF_JOIN_TRIBE: '欢迎你加入群聊',
	    JOIN_DISCUSSION: '欢迎新成员"${user}"加入讨论组',
	    SELF_JOIN_DISCUSSION: '欢迎你加入讨论组',
	    DISCUSSION_DISPLAY_NAME_CHANGE: '${user} 修改讨论组为"${newDisplay}"',
	    SELF_DISCUSSION_DISPLAY_NAME_CHANGE: '你修改讨论组名称为"${newDisplay}"',
	    TRIBE_DISPLAY_NAME_CHANGE: '${user} 修改群聊名称为"${newDisplay}"',
	    SELF_TRIBE_DISPLAY_NAME_CHANGE: '你修改群聊名称为"${newDisplay}"',
	    REMOVE_MANAGER: '"${user}"被群主"${manager}"取消管理员',
	    SELF_REMOVE_MANAGER: '"${user}"被你取消了管理员',
	    SELF_BE_REMOVED_MANAGER: '你被群主"${manager}"取消了管理员',
	    SET_MANAGER: '"${user}"被群主"${manager}"设为管理员',
	    SELF_SET_MANAGER: '"${user}"被你设为管理员',
	    SELF_BE_SET_MANAGER: '你被群主"${manager}"设为管理员',
	    SENT_SHAKE: '你发送了一个振屏',
	    RECEIVED_SHAKE: '${user}给你发送了一个振屏',
	    SHAKE_FREQUENCY_LIMIT: '使用振屏频率太高，请稍后再试',
	    SHAKE_WHEN_DISABLED: '你已经禁用了振屏功能。点此<a href="javascript:;" class="J_openShakeSetting">设置</a>',
	    SHAKE_WHEN_OFFLINE: '对方离线,你不能给TA发送振屏',
	    SHAKE_WHEN_INVISIBLE: '隐身状态下不能使用振屏功能',
	    FILE_DISABLED: '${filename}已经被自动拒绝接收,你可以<a href="javascript:;" class="J_openFileSetting">点此修改</a>设置',

	    START_CHAT: '你发起了和"${user}"的语音聊天请求',
	    RECEIVED_CHAT: '你收到了"${user}"的语音聊天请求',
	    STOP_CHAT: '你结束和"${user}"的语音聊天',
	    STOPPED_CHAT: '"${user}"结束与你的语音聊天',
	    REFUSE_CHAT: '你拒绝了"${user}"的语音聊天请求',
	    REFUSED_CHAT: '"${user}"拒绝了你的语音聊天请求',
	    STOP_CHAT_OR_VIDEO_FIRST_ERROR: '请先停止你当前的语音或者视频，再重试',
	    CHATTING_OR_VIDEO_ERROR: '${user}正在进行语音或者视频，请稍后再试',
	    STOP_CHAT_FIRST_ERROR: '请先停止你当前的语音聊天，再重试',
	    CHATTING_ERROR: '${user}正在进行语音聊天，请稍后再试',
	    CHAT_CONNECT_ERROR: '连接超时或者对方版本不支持，无法使用语音或视频功能',
	    CHAT_NET_ERROR: '由于网络故障，语音功能中断',
	    CHAT_NO_ANSWER_ERROR: '对方无应答，连接超时请稍候再试',

	    START_VIDEO: '你发起了和"${user}"的视频聊天请求',
	    RECEIVED_VIDEO: '你收到了"${user}"的视频聊天请求',
	    STOP_VIDEO: '你结束和"${user}"的视频聊天',
	    STOPPED_VIDEO: '"${user}"结束与你的视频聊天',
	    REFUSE_VIDEO: '你拒绝了"${user}"的视频聊天请求',
	    REFUSED_VIDEO: '"${user}"拒绝了你的视频聊天请求',
	    VIDEOING_ERROR: '${user}正在进行视频聊天，请稍后再试',

	    ASK_FOR_REMOTE_ASSISTANCE: '"${user}"请求你的远程协助',
	    ASK_FOR_CONTROL: '"${user}"请求控制你的电脑',
	    ASK_TO_REMOTE_ASSISTANCE: '你请求"${user}"的远程协助',
	    ASK_TO_CONTROL: '你请求控制"${user}"的电脑',
	    AGREED_TO_REMOTE_ASSISTANCE: '"${user}"同意了你的远程协助',
	    REFUSED_TO_REMOTE_ASSISTANCE: '"${user}"拒绝了你的远程协助',
	    STOPPED_TO_REMOTE_ASSISTANCE: '"${user}"停止了你的远程协助',
	    AGREED_TO_CONTROL: '${user}"同意了控制你的电脑',
	    AGREE_TO_REMOTE_ASSISTANCE: '你同意了"${user}"的远程协助',
	    REFUSE_TO_REMOTE_ASSISTANCE: '你拒绝了"${user}"的远程协助',
	    STOP_TO_REMOTE_ASSISTANCE: '你结束了"${user}"的远程协助',
	    AGREE_TO_CONTROL: '你同意了控制"${user}"的电脑',
	    NOT_SUPPORT_FOR_REMOTE_ASSISTANCE: '${user}版本不支持，无法建立远程协助',
	    NOT_SUPPORT_TO_REMOTE_ASSISTANCE: '你的版本不支持，无法建立远程协助',
	    STOP_REMOTE_ASSISTANCE_FIRST: '请先停止你当前的远程协助，再尝试',
	    REMOTE_ASSISTING: '${user}已经在进行远程协助了，请稍后再试',
	    REMOTE_ASSISTANCE_NET_ERROR: '由于网络原因导致远程协助中断，请稍后再试',

	    NOT_SUPPORT_MSG: '暂不支持的消息类型',

	    TAOBAO_NOT_SUPPORT_MSG: '当前版本内不支持该消息，请在手机淘宝内查看',

	    AT_MSG_READ: '已读',
	    ALL_AT_MSG_READ: '全部已读',
	    AT_MSG_UNREAD: '未读',
	    ALL_AT_MSG_UNREAD: '全部未读',
	    AT_MSG_READ_UNREAD_COUNT: '${readCount}人已读,${unreadCount}人未读',

	    FILE_OPENED: '已查收',
	    FILE_UNOPENED: '未查收',
	    PREVIEW_FILE: '预览',
	    CANCEL_DOWNLOAD: '取消下载',
	    CANCEL_UPLOAD: '取消上传',
	    DOWNLOAD_FILE: '下载',
	    RE_DOWNLOAD_FILE: '重新下载',
	    OPEN_FOLDER: '打开',

	    RECALL_MSG: '你 撤回了一条消息',

	    MSG_RECALLED: '${user} 撤回了一条消息',

	    CHECK_MAP: '查看地图',

	    DO_WX_ACTION_ERROR: '处理旺action错误',

	    DEGRADE: '您当前使用的版本无法显示该条消息。',
	    SHAKE_WHEN_DO_NOT_DISTURB: '对方处于免打扰状态，无法接受振屏。',
	    AUDIO_TO_TEXT_OLD_TIP: '部分旧版本发送的语音不支持显示文字',
	    AUDIO_TO_TEXT_TIP: '你可在<a href="javascript:;" class="go-audio-text-setting J_goAudioTextSetting">设置</a>中关闭语音显示文字功能',

	    FACE_TIME_NOT_ACCEPT: '视频通话未接听',
	    FACE_TIME_NOT_ACCEPTED: '对方未接听通话',
	    FACE_TIME_FINISH: '通话时长',
	    FACE_TIME_TRIGGER: '发起视频通话'
	  },

	  EN: {}
	};
	module.exports = exports['default'];

/***/ },
/* 11 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	/**
	 * Created by neitherzhu on 2017/1/2.
	 */
	exports.default = {
	  // 单聊接口前缀
	  SINGLE_SDK_PREFIX: 'im.singlemsg.',
	  // 群聊/讨论组接口前缀
	  TRIBE_SDK_PREFIX: 'im.tribemsg.',
	  // 获取模板消息中的链接与表情, 与接口前缀配合使用
	  CONVERT_TEXT_TO_EMOTION_SUFFIX: 'ConvertMsgText2Emotion',
	  // 获取多态卡片消息, 与接口前缀配合使用
	  GET_DYNAMIC_MSG_SUFFIX: 'GetDynamicMsg',
	  // 下载文件
	  DOWNLOAD_CLOUD_FILE: 'im.filetransfer.DownloadCloudFile',
	  // 预览文件
	  PREVIEW_CLOUD_FILE: 'im.filetransfer.PreviewCloudFile',
	  // 根据宝贝链接获取宝贝详情卡片
	  GET_URL_SNAPSHOT: 'im.bizutil.GetUrlSnapshot',
	  // 根据图片地址获取本地图片路径
	  GET_IMAGE_PATH: 'im.bizutil.GetPicturePath',
	  // 根据语音地址获取本地语音路径
	  GET_AUDIO_PATH: 'im.bizutil.GetAudioPath',
	  // 设置群@消息已读
	  SET_AT_MSG_READ_STATE: 'im.tribemsg.SetTribeAtMsgsReaded',
	  // 获取群@消息已读未读状态
	  GET_AT_MSG_READ_STATE: 'im.tribemsg.GetTribeAtMsgUnreadCount',
	  // 播放语音
	  START_AUDIO_PLAYER: 'im.bizutil.PlayAudio',
	  // 停止播放语音
	  STOP_AUDIO_PLAYER: 'im.bizutil.StopAudio',
	  // 查看图片
	  PREVIEW_IMAGE: 'im.uiutil.ViewPicture',
	  // 打开群@详情
	  OPEN_READ_STATE_COUNT_DETAIL: 'im.uiutil.ShowTribeAtMsgUnreadUsers',
	  // 传入url打开url
	  OPEN_URL: 'im.bizutil.DoUrlAction',
	  // 传入旺x协议地址, 主要用在多态卡片消息
	  DO_WX_ACTION: 'im.bizutil.DoWangXAction',
	  // 打开文件设置
	  OPEN_FILE_SETTING: 'im.uiutil.OpenFileSetting',
	  // 打开震屏设置
	  OPEN_SHAKE_SETTING: 'im.uiutil.OpenShakeSetting',

	  // 获取文件传输状态
	  GET_FILE_TRANSFER_INFO: 'im.filetransfer.GetFileTransferInfo',
	  // 取消文件下载
	  CANCEL_DOWNLOAD_CLOUD_FILE: 'im.filetransfer.CancelDownloadCloudFile',
	  // 取消文件上传
	  CANCEL_UPLOAD_CLOUD_FILE: 'im.filetransfer.CancelUploadFile',
	  // 打开本地文件夹
	  OPEN_FOLDER: 'im.filetransfer.OpenFolder',
	  // 删除云盘中的文件
	  DELETE_CLOUD_FILE: 'im.filetransfer.DeleteCloudFile',

	  // 设置单聊消息已读
	  SET_SINGLE_MSG_READ_STATUS: 'im.singlemsg.SetFlagsPeerMsgReaded',
	  // 获取单聊消息已读未读状态
	  GET_SINGLE_MSG_READ_STATUS: 'im.singlemsg.GetFlagsMyMsgReaded',
	  // 获取聊天窗口是否被遮挡
	  IS_CHAT_WINDOW_COVERED: 'im.uiutil.IsChatWindowCovered',
	  // 获取是否需要显示语音转文字
	  GET_AUDIO_SHOW_TEXT_SETTING: 'im.bizutil.GetShowAudio2textOption',
	  // 显示语音转文字系统提示，只需要调用，客户端来判断是否产生这条消息
	  ADD_AUDIO_TEXT_SETTING_TIP_SUFFIX: 'AddAudio2textSettingRemind',
	  // 打开系统设置
	  OPEN_SETTING: 'im.uiutil.OpenSystemSetting',
	  // 发起视频聊天
	  START_FACE_TIME: 'im.bizutil.StartVideoChat'
	};
	module.exports = exports['default'];

/***/ },
/* 12 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = {
	  // 根据图片地址获取本地图片路径
	  GET_IMAGE_PATH: 'im.ampmedia.GetPicture',

	  GET_AUDIO_PATH: 'im.ampmedia.GetAudio'
	};
	module.exports = exports['default'];

/***/ },
/* 13 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	// const NativeInvoke = IMSDK.invoke;
	// const { Log } = Base;
	// // 重写invoke方法,统一打印通过接口获取到的数据
	// IMSDK.invoke = function() {
	//   const args = Array.prototype.slice.call(arguments);
	//
	//   Log.blue('调用：', args[ 0 ], '参数：', args[ 1 ]);
	//   return new Promise(( resolve, reject ) => {
	//     NativeInvoke.apply(NativeInvoke, args).then(data => {
	//       Log.green(args[ 0 ], '返回成功：', data);
	//       resolve(data);
	//     }).catch(err => {
	//       Log.red(args[ 0 ], '返回失败：', err);
	//       reject(err);
	//     });
	//   });
	// };

	exports.default = {
	  /**
	   * 获取多态卡片的详细内容
	   * @param param
	   * @returns {Promise}
	   */
	  getDynamicMsg: function getDynamicMsg(param) {
	    return new Promise(function (resolve, reject) {
	      _$IMSDKRoot2.default.invoke(_constants2.default.SDK_PREFIX_MAP[_window2.default.sharedWin.conversationID.type] + _constants2.default.SDK.GET_DYNAMIC_MSG_SUFFIX, param).then(function (data) {
	        data && data.content ? resolve(data.content) : reject(data && data.errMsg);
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },

	  /**
	   * 传入文本获取是否有表情与链接
	   * @param param
	   * @returns {Promise}
	   */
	  convertMsgToEmotion: function convertMsgToEmotion(param) {
	    return new Promise(function (resolve, reject) {
	      _$IMSDKRoot2.default.invoke(_constants2.default.SDK_PREFIX_MAP[_window2.default.sharedWin.conversationID.type] + _constants2.default.SDK.CONVERT_TEXT_TO_EMOTION_SUFFIX, param).then(function (data) {
	        if (data && data.result && data.result.length) {
	          resolve(data.result);
	        } else {
	          reject(data);
	        }
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },

	  /**
	   * 获取宝贝详情卡片
	   * @param param
	   * @returns {Promise}
	   */
	  getUrlSnapshot: function getUrlSnapshot(param) {
	    return new Promise(function (resolve, reject) {
	      _$IMSDKRoot2.default.invoke(_constants2.default.SDK.GET_URL_SNAPSHOT, param).then(function (data) {
	        if (data.code == 0) {
	          resolve(data.result);
	        } else {
	          reject(data);
	        }
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },

	  /**
	   * 获取图片本地路径
	   * @param param
	   * @returns {Promise}
	   */
	  getImagePath: function getImagePath(param) {
	    var imagePath = '';
	    if (param.cid.type === _constants2.default.TaobaoConversationType) {
	      imagePath = _constants2.default.TAOBAOSDK.GET_IMAGE_PATH;
	    } else {
	      imagePath = _constants2.default.SDK.GET_IMAGE_PATH;
	    }

	    return new Promise(function (resolve, reject) {
	      _$IMSDKRoot2.default.invoke(imagePath, param).then(function (data) {
	        if (data.code == 0) {
	          resolve(data.result);
	        } else {
	          reject(data);
	        }
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },

	  /**
	   * 获取语音本地路径
	   * @param param
	   * @returns {Promise}
	   */
	  getAudioPath: function getAudioPath(param) {
	    var audioPath = '';

	    if (param.cid.type === _constants2.default.TaobaoConversationType) {
	      audioPath = _constants2.default.TAOBAOSDK.GET_AUDIO_PATH;
	    } else {
	      audioPath = _constants2.default.SDK.GET_AUDIO_PATH;
	    }

	    return new Promise(function (resolve, reject) {
	      _$IMSDKRoot2.default.invoke(audioPath, param).then(function (data) {
	        if (data.code == 0) {
	          resolve(data.result);
	        } else {
	          reject(data);
	        }
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },

	  /**
	   * 设置群@消息已读
	   * @param param
	   */
	  setAtMsgReadState: function setAtMsgReadState(param) {
	    return new Promise(function (resolve, reject) {
	      _$IMSDKRoot2.default.invoke(_constants2.default.SDK.SET_AT_MSG_READ_STATE, param).then(function (data) {
	        if (data && data.code == 0) {
	          resolve(data);
	        } else {
	          reject(data);
	        }
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },

	  /**
	   * 获取群@消息已读未读人数
	   * @param param
	   * @returns {Promise}
	   */
	  getAtMsgReadState: function getAtMsgReadState(param) {
	    return new Promise(function (resolve, reject) {
	      _$IMSDKRoot2.default.invoke(_constants2.default.SDK.GET_AT_MSG_READ_STATE, param).then(function (data) {
	        resolve(data.result);
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },

	  /**
	   * 播放语音
	   * @param param
	   */
	  playAudio: function playAudio(param) {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK.START_AUDIO_PLAYER, param);
	  },

	  /**
	   * 停止播放语音
	   */
	  stopAudio: function stopAudio() {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK.STOP_AUDIO_PLAYER);
	  },

	  /**
	   * 图片预览
	   * @param param
	   */
	  previewImage: function previewImage(param) {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK.PREVIEW_IMAGE, param);
	  },

	  /**
	   * 打开已读未读人详情
	   * @param param
	   */
	  openReadStateCountDetail: function openReadStateCountDetail(param) {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK.OPEN_READ_STATE_COUNT_DETAIL, param);
	  },

	  /**
	   * 调用客户端接口打开链接
	   * @param param
	   */
	  openUrl: function openUrl(param) {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK.OPEN_URL, param);
	  },

	  /**
	   * 调用客户端接口处理多态卡片上的action
	   * @param param
	   * @returns {Promise}
	   */
	  doWXAction: function doWXAction(param) {
	    return new Promise(function (resolve, reject) {
	      _$IMSDKRoot2.default.invoke(_constants2.default.SDK.DO_WX_ACTION, param).then(function (data) {
	        if (data && data.code === 0) {
	          resolve(data);
	        } else {
	          reject(data);
	        }
	      }).catch(function (e) {
	        reject(e);
	      });
	    });
	  },

	  /**
	   * 打开文件设置
	   */
	  openFileSetting: function openFileSetting() {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK.OPEN_FILE_SETTING);
	  },

	  /**
	   * 打开震屏设置
	   */
	  openShakeSetting: function openShakeSetting() {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK.OPEN_SHAKE_SETTING);
	  },

	  /**
	   * 获取文件信息
	   * @param param
	   * @returns {Object}
	   */
	  getFileTransferInfo: function getFileTransferInfo(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.GET_FILE_TRANSFER_INFO, param);
	  },

	  /**
	   * 下载文件
	   * @param param
	   * @returns {Object}
	   */
	  downloadCloudFile: function downloadCloudFile(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.DOWNLOAD_CLOUD_FILE, param);
	  },

	  /**
	   * 取消下载文件
	   * @param param
	   * @returns {Object}
	   */
	  cancelDownloadCloudFile: function cancelDownloadCloudFile(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.CANCEL_DOWNLOAD_CLOUD_FILE, param);
	  },

	  /**
	   * 取消上传文件
	   * @param param
	   * @returns {Object}
	   */
	  cancelUploadCloudFile: function cancelUploadCloudFile(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.CANCEL_UPLOAD_CLOUD_FILE, param);
	  },

	  /**
	   * 预览文件
	   * @param param
	   * @returns {Object}
	   */
	  previewCloudFile: function previewCloudFile(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.PREVIEW_CLOUD_FILE, param);
	  },

	  /**
	   * 打开本地文件夹
	   * @param param
	   * @returns {Object}
	   */
	  openFolder: function openFolder(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.OPEN_FOLDER, param);
	  },

	  /**
	   * 删除云盘文件
	   * @param param
	   * @returns {Object}
	   */
	  deleteCloudFile: function deleteCloudFile(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.DELETE_CLOUD_FILE, param);
	  },

	  /**
	   * 获取单聊消息已读状态
	   * @param param
	   */
	  getSingleMsgReadStatus: function getSingleMsgReadStatus(param) {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.GET_SINGLE_MSG_READ_STATUS, param);
	  },

	  /**
	   * 设置单聊消息已读
	   * @param param
	   */
	  setSingleMsgReadStatus: function setSingleMsgReadStatus(param) {
	    return new Promise(function (resolve, reject) {
	      _$IMSDKRoot2.default.invoke(_constants2.default.SDK.SET_SINGLE_MSG_READ_STATUS, param).then(function (data) {
	        if (data && data.code == 0) {
	          resolve(data);
	        } else {
	          reject(data);
	        }
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },

	  /**
	   * 获取当前窗口是否被遮盖
	   * @returns {Object}
	   */
	  isChatWindowCovered: function isChatWindowCovered() {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.IS_CHAT_WINDOW_COVERED);
	  },

	  /**
	   * 获取是否显示语音转文字
	   * @returns
	   */
	  getAudioShowTextSetting: function getAudioShowTextSetting() {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.GET_AUDIO_SHOW_TEXT_SETTING);
	  },

	  /**
	   * 显示语音转文字系统提示
	   * @param {any} param
	   */
	  addAudioTextSettingTip: function addAudioTextSettingTip(param) {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK_PREFIX_MAP[param.type] + _constants2.default.SDK.ADD_AUDIO_TEXT_SETTING_TIP_SUFFIX, param);
	  },

	  /**
	   * 打开系统设置
	   * @param param
	   */
	  openSetting: function openSetting(param) {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK.OPEN_SETTING, param);
	  },

	  /**
	   * 发起视频聊天
	   * @param param
	   */
	  startFaceTime: function startFaceTime(param) {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK.START_FACE_TIME, param);
	  },

	  /**
	   * 获取服务器时间
	   */
	  getServerTime: function getServerTime() {
	    return _$IMSDKRoot2.default.invoke('im.bizutil.GetIMSvrTime');
	  }
	};
	module.exports = exports['default'];

/***/ },
/* 14 */
/***/ function(module, exports) {

	"use strict";

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	/**
	 * Created by neitherzhu on 2017/2/17.
	 */
	exports.default = {
	  sharedWin: null
	};
	module.exports = exports["default"];

/***/ },
/* 15 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _audio = __webpack_require__(16);

	var _audio2 = _interopRequireDefault(_audio);

	var _image = __webpack_require__(17);

	var _image2 = _interopRequireDefault(_image);

	var _link = __webpack_require__(18);

	var _link2 = _interopRequireDefault(_link);

	var _location = __webpack_require__(19);

	var _location2 = _interopRequireDefault(_location);

	var _video = __webpack_require__(20);

	var _video2 = _interopRequireDefault(_video);

	var _card = __webpack_require__(21);

	var _card2 = _interopRequireDefault(_card);

	var _normalMsg = __webpack_require__(22);

	var _normalMsg2 = _interopRequireDefault(_normalMsg);

	var _systemMsg = __webpack_require__(23);

	var _systemMsg2 = _interopRequireDefault(_systemMsg);

	var _errorStatus = __webpack_require__(24);

	var _errorStatus2 = _interopRequireDefault(_errorStatus);

	var _loading = __webpack_require__(25);

	var _loading2 = _interopRequireDefault(_loading);

	var _atMsgReadCount = __webpack_require__(26);

	var _atMsgReadCount2 = _interopRequireDefault(_atMsgReadCount);

	var _anchor_check = __webpack_require__(27);

	var _anchor_check2 = _interopRequireDefault(_anchor_check);

	var _filemsg = __webpack_require__(28);

	var _filemsg2 = _interopRequireDefault(_filemsg);

	var _fileOptions = __webpack_require__(29);

	var _fileOptions2 = _interopRequireDefault(_fileOptions);

	var _msgReadStatus = __webpack_require__(30);

	var _msgReadStatus2 = _interopRequireDefault(_msgReadStatus);

	var _degrade = __webpack_require__(31);

	var _degrade2 = _interopRequireDefault(_degrade);

	var _facetime = __webpack_require__(32);

	var _facetime2 = _interopRequireDefault(_facetime);

	var _taobaoCard = __webpack_require__(33);

	var _taobaoCard2 = _interopRequireDefault(_taobaoCard);

	var _taobaoShare = __webpack_require__(34);

	var _taobaoShare2 = _interopRequireDefault(_taobaoShare);

	var _taobaoFeed = __webpack_require__(35);

	var _taobaoFeed2 = _interopRequireDefault(_taobaoFeed);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = {
	  audio: _audio2.default.trim(),
	  image: _image2.default.trim(),
	  link: _link2.default.trim(),
	  location: _location2.default.trim(),
	  video: _video2.default.trim(),
	  card: _card2.default.trim(),
	  normalMsg: _normalMsg2.default.trim(),
	  systemMsg: _systemMsg2.default.trim(),
	  errorStatus: _errorStatus2.default.trim(),
	  loading: _loading2.default.trim(),
	  atMsgReadCount: _atMsgReadCount2.default.trim(),
	  anchorCheck: _anchor_check2.default.trim(),
	  fileMsg: _filemsg2.default.trim(),
	  fileOperation: _fileOptions2.default.trim(),
	  msgReadStatus: _msgReadStatus2.default.trim(),
	  degrade: _degrade2.default.trim(),
	  facetime: _facetime2.default.trim(),
	  taobaoCard: _taobaoCard2.default.trim(),
	  taobaoFeed: _taobaoFeed2.default.trim(),
	  taobaoShare: _taobaoShare2.default.trim()
	};

	// 手淘消息模板类型

	module.exports = exports['default'];

/***/ },
/* 16 */
/***/ function(module, exports) {

	module.exports = "<div class=\"audio-wrap{@if !text} show-audio-text{@/if}\">\n  <div id=\"J_AUDIO_${msgid}\" data-ignore=\"{@if self || readFlag == 1}1{@/if}\" class=\"imui-msg-audio J_audio\"\n       data-md5=\"${md5}\" data-path=\"${path}\" data-type=\"${type}\">${dur}s\n  </div>\n  {@if text}\n  <div class=\"audio-text\">${text}</div>\n  {@/if}\n</div>\n";

/***/ },
/* 17 */
/***/ function(module, exports) {

	module.exports = "{@if !loading}\n<img src=\"${src}\"\n     id=\"J_Img_${id}\"\n     data-md5=\"${md5}\"\n     data-type=\"${type}\"\n     data-time=\"${msgtime}\"\n     class=\"J_imImage imui-msg-img J_${id}{@if loading} imui-msg-img-loading{@/if}{@if isEmoji} imui-msg-emoji{@/if}{@if isEmotion} emotion-image{@/if}\"/>\n{@else}\n<img data-md5=\"${md5}\"\n     id=\"J_Img_${id}\"\n     data-type=\"${type}\"\n     data-time=\"${msgtime}\"\n     class=\"J_imImage imui-msg-img J_${id}{@if loading} imui-msg-img-loading{@/if}{@if isEmoji} imui-msg-emoji{@/if}{@if isEmotion} emotion-image{@/if}\"/>\n{@/if}\n\n";

/***/ },
/* 18 */
/***/ function(module, exports) {

	module.exports = "{@if style}\n<a class=\"imui-msg-link ${cls}-link J_link_${id}_${md5}\" href=\"${href}\" target=\"_blank\" safeflag=\"${safeflag}\"\n   style=\"${style}\"><i class=\"link-sf\"></i>${href}</a>\n{@else}\n<a class=\"imui-msg-link ${cls}-link J_link_${id}_${md5}\" href=\"${href}\" target=\"_blank\" safeflag=\"${safeflag}\"><i\n  class=\"link-sf\"></i>${href}</a>\n{@/if}\n\n";

/***/ },
/* 19 */
/***/ function(module, exports) {

	module.exports = "<div class=\"imui-msg-location-wrap\">\n  <a class=\"imui-msg-location\" href=\"${url}\" target=\"_blank\"><i class=\"imui-location-icon\"></i>${v}</a>\n</div>\n";

/***/ },
/* 20 */
/***/ function(module, exports) {

	module.exports = "<video src=\"${url}\" data-ignore=\"{@if self || readFlag == 1}1{@/if}\" controls=\"controls\" onplay=\"videoPlay(this)\"/>\n";

/***/ },
/* 21 */
/***/ function(module, exports) {

	module.exports = "<div class=\"imui-msg-card-wrap\">\n  <div class=\"imui-msg-card\">$${html}</div>\n</div>\n";

/***/ },
/* 22 */
/***/ function(module, exports) {

	module.exports = "<div class=\"J_msg imui-msg{@if !self} imui-msg-l{@else} imui-msg-r{@/if}{@if cls} ${cls}{@/if}\" id=\"${msgid}\"\n     data-time=\"${msgtime}\" data-appkey=\"${from.appkey}\" data-nick=\"${from.nick}\">\n  {@if avatar}\n  <div class=\"imui-msg-avatar J_avatar_${appkey}${subNick}{@if !self && !cid.nick} add-at J_addAt{@/if}\"\n       style=\"background-image:url('${avatar}');background-size:cover;\"></div>\n  {@/if}\n  <div class=\"imui-msg-content\">\n    <div class=\"imui-msg-content-inner\">\n      <div class=\"imui-msg-head\">\n        <span class=\"imui-msg-sender J_display_${subNick}{@if !self && !cid.nick} add-at J_addAt{@/if}\"\n              title=\"{@if !isSubNick || !to}{@if from.display}${from.display}{@else}${from.nick}{@/if}{@else}{@if from.display}${from.display}{@else}${from.nick}{@/if} --> {@if to.display}${to.display}{@else}${to.nick}{@/if}{@/if}\">\n            {@if !isSubNick || !to}{@if from.display}${from.display}{@else}${from.nick}{@/if}{@else}{@if from.display}${from.display}{@else}${from.nick}{@/if} --> {@if to.display}${to.display}{@else}${to.nick}{@/if}{@/if}\n        </span>\n        <span class=\"imui-msg-date\">${msgtime | timeFormatter}</span>\n      </div>\n      <div class=\"msg-content-body\">\n        <div class=\"msg-body-html\">$${html}</div>\n        <div class=\"imui-msg-op-wrap\" data-menu=\"${menu}\">\n          <div class=\"imui-msg-status\">\n            {@if isFail}\n              <span class=\"status-icon status-error J_resend\"></span>\n            {@else}\n              {@if self && readFlagText}\n                {@if readflag == 1}\n                  <span class=\"status-read-done\" data-unread=\"0\">${readFlagText}</span>\n                {@/if}\n              {@/if}\n            {@/if}\n          </div>\n          {@if msgstatus === 0 || msgstatus === 1}\n            <div class=\"imui-msg-menu-wrap J_menuWrap\" tabindex=\"0\">\n              {@if isMe}\n                <span class=\"bubble-menu-trigger J_selfBubbleMenuTrigger\"\n                    data-svrtime=\"{@if svrtime && svrtime !== '0'}${svrtime}{@else}${msgtime}{@/if}\"></span>\n              {@else}\n                <span class=\"bubble-menu-trigger J_bubbleMenuTrigger\" data-svrtime=\"${svrtime}\"></span>\n              {@/if}\n            </div>\n          {@/if}\n        </div>\n      </div>\n    </div>\n  </div>\n</div>\n";

/***/ },
/* 23 */
/***/ function(module, exports) {

	module.exports = "<div class=\"J_msg imui-msg-system\" id=\"${msgid}\" data-time=\"${msgtime}\"><span>$${html}</span></div>\n";

/***/ },
/* 24 */
/***/ function(module, exports) {

	module.exports = "<span class=\"status-icon status-error{@if cls} ${cls}{@/if}\" data-id=\"{@if id}${id}{@/if}\"></span>\n";

/***/ },
/* 25 */
/***/ function(module, exports) {

	module.exports = "<span class=\"status-icon status-loading\"></span>\n";

/***/ },
/* 26 */
/***/ function(module, exports) {

	module.exports = "<span class=\"{@if done} status-read-done{@else} status-read-count J_openReadStateCountDetail{@/if}\" data-msgid=\"${id}\">${tpl}</span>\n";

/***/ },
/* 27 */
/***/ function(module, exports) {

	module.exports = "<div class=\"imui-msg-link-box\">\n  <div class=\"warning-text\">\n    {@if isSafe}\n    安全链接，请放心打开\n    {@else}\n    未知链接，请谨慎打开！\n    {@/if}\n  </div>\n  <a href=\"https://www.taobao.com/market/110/school.php\" target=\"_blank\" class=\"link-school\">如何识别可疑链接？</a>\n  <div class=\"warning-actions\">\n    {@each btns as btn}\n    <a href=\"javascript:void(0)\" data-action=\"${btn.action}\" class=\"warning-action J_linkAction\">${btn.text}</a>\n    {@/each}\n  </div>\n\n</div>\n";

/***/ },
/* 28 */
/***/ function(module, exports) {

	module.exports = "<div class=\"file-msg\" id=\"J_file${id}\" data-id=\"${id}\" data-pid=\"${parentId}\" data-type=\"${nodeType}\" data-md5=\"${md5}\"\n     data-name=\"${nodeName}\" data-size=\"${nodeSize}\">\n  <div class=\"file-suffix J_previewFile ${cls}\"\n       data-ignore=\"{@if optionsData && (optionsData.isSelf || optionsData.isRead)}1{@/if}\">${suffix}\n  </div>\n  <div class=\"file-info\">\n    <div class=\"file-name J_previewFile\" title=\"${nodeName}\"\n         data-ignore=\"{@if optionsData && (optionsData.isSelf || optionsData.isRead)}1{@/if}\">${name}\n    </div>\n    <div class=\"file-size\">${size}</div>\n    <div class=\"file-operation\">\n      {@if optionsData}{@include fileOperation, optionsData}{@/if}\n    </div>\n  </div>\n  <div class=\"file-progress{@if !progress} hidden{@/if}\"><i style=\"{@if progress}width:${progress}%{@/if}\"></i></div>\n</div>\n";

/***/ },
/* 29 */
/***/ function(module, exports) {

	module.exports = "{@if status == 0}\n<a href=\"javascript:;\" class=\"preview-file J_previewFile\" data-ignore=\"{@if isSelf || isRead}1{@/if}\">预览</a>\n<a href=\"javascript:;\" class=\"open-folder J_openFolder\" data-path=\"${path}\">打开文件夹</a>\n{@else if status == 1}\n<a href=\"javascript:;\" class=\"cancel-upload J_cancelUpload\">取消上传</a>\n{@else if status == 2}\n<a href=\"javascript:;\" class=\"preview-file J_previewFile\" data-ignore=\"{@if isSelf || isRead}1{@/if}\">预览</a>\n<a href=\"javascript:;\" class=\"cancel-download J_cancelDownload\">取消下载</a>\n{@else if status == 3}\n<a href=\"javascript:;\" class=\"preview-file J_previewFile\" data-ignore=\"{@if isSelf || isRead}1{@/if}\">预览</a>\n<a href=\"javascript:;\" class=\"download-file J_downloadFile\" data-ignore=\"{@if isSelf || isRead}1{@/if}\">下载文件</a>\n{@else if status == 4}\n<a href=\"javascript:;\" class=\"preview-file J_previewFile\" data-ignore=\"{@if isSelf || isRead}1{@/if}\">预览</a>\n<a href=\"javascript:;\" class=\"download-file J_downloadFile\" data-ignore=\"{@if isSelf || isRead}1{@/if}\">重新下载</a>\n{@else if status == 5}\n<a href=\"javascript:;\" class=\"open-folder J_openFolder\" data-path=\"${path}\">打开文件夹</a>\n{@/if}\n";

/***/ },
/* 30 */
/***/ function(module, exports) {

	module.exports = "<span class=\"status-read-done{@if !isread} single-read{@/if}\" data-unread=\"{@if isread}0{@else}1{@/if}\">${tpl}</span>\n";

/***/ },
/* 31 */
/***/ function(module, exports) {

	module.exports = "<div class=\"degrade-msg\" id=\"J_degrade_${id}\">${text}</div>\n";

/***/ },
/* 32 */
/***/ function(module, exports) {

	module.exports = "<div class=\"face-time\">\n  <i class=\"imui-icon imui-icon-shipin\"></i>\n  <span class=\"face-time-result\">${text}</span>\n  {@if trigger}\n  <span class=\"face-time-trigger J_faceTimeTrigger\">${trigger}</span>\n  {@/if}\n</div>\n";

/***/ },
/* 33 */
/***/ function(module, exports) {

	module.exports = "<div class=\"imui-msg-card-wrap imui-msg-card-person\">\n  <div class=\"feed_hd\">\n    <img src=\"${bcHeadUrl}\" class=\"bd_avator\">\n    <div class=\"bd_content\">\n      ${bcNick}\n    </div>\n  </div>\n  <div class=\"feed_ft\">\n    个人名片\n  </div>\n</div>";

/***/ },
/* 34 */
/***/ function(module, exports) {

	module.exports = "<div class=\"imui-msg-card-wrap imui-msg-card-share\" \n     data-sharetype=\"${shareType}\" data-subtype=\"${subType}\" \n     data-attr=\"${attr}\">\n  {@if shareType === 0}\n  <a href=\"${actionUrl}\" target=\"_blank\">\n  <div class=\"card_share\">\n  <div class=\"share_left\">\n    <img src=\"${picUrl}\" class=\"left_image\">\n  </div>\n  <div class=\"share_right\">\n    <div class=\"right_hd\">\n      {@each attribute.tags as tag}\n      {@if tag}\n      <img src=\"${tag}\" class=\"hd_tag\">\n      {@/if}\n      {@/each}\n      $${title}\n    </div>\n    <div class=\"right_bd\">\n      {@if price}\n      <div class=\"bd_price\"> ¥ ${price}</div>\n      {@/if}\n      \n      {@if attribute.buyNum}\n      <div class=\"bd_buynum\"> ${attribute.buyNum} 人付款</div>\n      {@/if}\n    </div>\n  </div>\n  </div>\n  </a>\n  {@else if shareType === 1}\n  <div class=\"card_share\">\n    {@if subType === 0}\n    <a href=\"${actionUrl}\" target=\"_blank\">\n    <div class=\"share_shop\">\n    <div class=\"share_left\">\n      <img src=\"${picUrl}\" class=\"left_image\">\n    </div>\n    <div class=\"share_right\">\n      <div class=\"right_hd\">\n        $${title}\n      </div>\n      {@if rankPicUrl}\n      <img src=\"${rankPicUrl}\" class=\"bd_rankurl\">\n      {@/if}\n    </div>\n    </div>\n\n    </a>\n    {@else if subType === 1}\n    \n    <div class=\"shop_active\">\n      <a href=\"${actionUrl}\" target=\"_blank\">\n      <div class=\"active_hd\">\n        <div class=\"active_hd_left\">\n          <img src=\"${picUrl}\" class=\"left_image\">\n        </div>  \n        <div class=\"active_hd_right\">\n          <div class=\"hd_tlt\">\n            $${title}\n          </div>\n          {@if rankPicUrl}\n            <img src=\"${rankPicUrl}\" class=\"hd_rankurl\">\n          {@/if}\n        </div>\n      </div>\n      </a>\n      <div class=\"active_bd\">\n        <a href=\"${attribute.actUrl}\" target=\"_blank\">\n          <img src=\"${attribute.actPic}\" class=\"bd_actpic\">\n        </a>\n      </div>\n    </div>\n    {@else if subType === 2}\n    <a href=\"${actionUrl}\" target=\"_blank\">\n    <div class=\"shop_active share_active\">\n      <div class=\"active_hd\">\n        <div class=\"active_hd_left\">\n          <img src=\"${picUrl}\" class=\"left_image\">\n        </div>\n        <div class=\"active_hd_right\">\n          <div class=\"hd_tlt\">\n            $${title}\n          </div>\n          {@if rankPicUrl}\n          <img src=\"${rankPicUrl}\" class=\"hd_rankurl\">\n          {@/if}\n        </div>\n      </div>\n      <div class=\"active_bd\">\n        {@each attribute.items as item}\n          <div class=\"bd_items\">\n            <img src=\"${item.pic}\" class=\"items_pic\">\n            <div class=\"items_price\">¥ ${item.price}</div>\n          </div>\n        {@/each}\n      </div>\n    </div>\n    </a>\n  {@/if}\n  </div>\n  {@else if shareType === 101}\n  <a href=\"${actionUrl}\" target=\"_blank\">\n  <div class=\"share_online\">\n    <div class=\"online_hd\">\n      <img src=\"${attribute.hostPic}\" class=\"hd_hostpic\">\n    </div>\n    <div class=\"online_bd\">\n      <div class=\"bd_left\">\n        <img src=\"${picUrl}\" class=\"bd_picurl\">\n      </div>\n      <div class=\"bd_right\">\n        <div class=\"right_tlt\">\n          $${title}\n        </div>\n        <div class=\"right_bd\">\n          $${attribute.hostName}                  \n        </div>\n      </div>\n    </div>\n    \n    <div class=\"online_ft\">\n      $${from}\n    </div>\n  </div>\n  </a>\n  {@else}\n  <a href=\"${actionUrl}\" target=\"_blank\">\n    <div class=\"share_msg\">\n    {@if picUrl}\n    <div class=\"msg_hd\">\n      <img class=\"hd_urlpic\" src=\"${picUrl}\">\n    </div>\n    {@/if}\n    <div class=\"msg_bd\">\n      <div class=\"msg_tlt\">\n        $${title}\n      </div>\n      {@if content}\n      <div class=\"msg_content\">\n        $${content}\n      </div>\n      {@/if}\n    </div>\n    <div class=\"msg_ft\">\n      $${from}\n    </div>\n    </div>\n  </a>\n  {@/if}\n</div>";

/***/ },
/* 35 */
/***/ function(module, exports) {

	module.exports = "<div class=\"imui-msg-card-wrap imui-msg-card-feed\">\n  <div class=\"feed_hd\">\n    ${title}\n  </div>\n  <div class=\"feed_bd\">\n    <a href=\"${actionUrl}\">\n      <img src=\"${picUrl}\" class=\"bd_pic\">\n    </a>\n    <div class=\"bd_content\">\n      ${content}\n    </div>\n  </div>\n</div>";

/***/ },
/* 36 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = {
	  __TypeMap: {},
	  __NameMap: {},
	  __overCallback: [],
	  __injectNormalFormats: [],
	  __injectSystemFormats: [],

	  /**
	   * 普通消息
	   * 在传入的format返回结果之前,
	   * 可以有机会改变返回的结果
	   */
	  injectNormalFormat: function injectNormalFormat(msg, result) {

	    this.__injectNormalFormats.forEach(function (fn) {
	      result && fn && fn.call(null, msg, result);
	    });

	    return result;
	  },

	  /**
	   * 传入普通消息的自定解析回调
	   * @param fn
	   */
	  pushInjectNormalFormat: function pushInjectNormalFormat(fn) {
	    this.__injectNormalFormats.push(fn);
	  },

	  /**
	   * 系统消息
	   * 在传入的format返回结果之前,
	   * 可以有机会改变返回的结果
	   */
	  injectSystemFormat: function injectSystemFormat(msg, result) {
	    this.__injectSystemFormats.forEach(function (fn) {
	      result && fn && fn.call(null, msg, result);
	    });

	    return result;
	  },

	  /**
	   * 传入系统消息的自定解析回调
	   * @param fn
	   */
	  pushInjectSystemFormat: function pushInjectSystemFormat(fn) {
	    this.__injectSystemFormats.push(fn);
	  },

	  /**
	   * 增加消息解析处理器
	   * @param label {String} 消息大类，用来区分是哪种类型的消息，比如群聊或者单聊
	   * @param type {String} 消息小类，消息类型，比如文本消息，系统消息等
	   * @param name {String} 转换函数的名称，方便调用时寻找
	   * @param obj {Object} 转换的Formatter, Tpl, Callback...
	   */
	  add: function add(label, type, name, obj) {
	    // 如果type是数组
	    if (Object.prototype.toString.call(type) === '[object Array]') {
	      var _that = this;

	      type.forEach(function (t) {
	        _that.add(label, t, name, obj);
	      });
	    } else {
	      this.__NameMap[label] || (this.__NameMap[label] = {});
	      this.__NameMap[label][name] || (this.__NameMap[label][name] = []);
	      this.__TypeMap[label] || (this.__TypeMap[label] = {});
	      this.__TypeMap[label][type] = obj;
	      this.__NameMap[label][name].push(type);
	    }
	  },
	  getMsgTypesByName: function getMsgTypesByName(label, name) {
	    return this.__NameMap[label] && this.__NameMap[label][name] || [];
	  },

	  /**
	   * 更新之前定义的解析format, TPL, extra
	   * @param label
	   * @param type
	   * @param name
	   * @param obj
	   */
	  update: function update(label, type, name, obj) {
	    // 如果type是数组
	    if (Object.prototype.toString.call(type) === '[object Array]') {
	      var _that = this;

	      type.forEach(function (t) {
	        _that.update(label, t, name, obj);
	      });
	    } else {
	      if (!this.__TypeMap[label] || !this.__TypeMap[label][type]) return;

	      this.__TypeMap[label][type] = Object.assign(this.__TypeMap[label][type], obj);
	    }
	  },

	  /**
	   * 解析
	   * @param label {String} 消息大类，用来区分是哪种类型的消息，比如群聊或者单聊
	   * @param msg 消息数据
	   * @param key 消息源数据中代表消息小类的字段
	   * @returns 返回一个对象，内部包含了转换后的HTML以及转换时需要调用的回调
	   */
	  convert: function convert(label, msg, key) {

	    !key && (key = 'msgtype');
	    var type = msg[key];
	    var o = this.__TypeMap[label] && this.__TypeMap[label][type];

	    if (!o) return;

	    var formattedMsg = void 0;
	    var tpl = '';

	    try {
	      formattedMsg = o.format && o.format(msg);
	    } catch (e) {
	      console.error('解析消息错误', msg);
	    }

	    if (!formattedMsg) return;

	    if (!formattedMsg.ignore) {
	      tpl = formattedMsg && (0, _$JuicerRoot2.default)(o.Tpl, formattedMsg);
	      formattedMsg.ignore = true;
	    } else {
	      tpl = formattedMsg.html;
	    }

	    if (!tpl) return;

	    return {
	      html: tpl,
	      ignore: formattedMsg.ignore,
	      callback: o.extra && function (callback) {
	        o.extra(callback, tpl, formattedMsg);
	      }
	    };
	  },
	  addOverCallback: function addOverCallback(callback) {
	    this.__overCallback.push(callback);
	  },
	  over: function over() {
	    var args = Array.prototype.slice.call(arguments);
	    this.__overCallback.forEach(function (callback) {
	      try {
	        callback.apply(null, args);
	      } catch (e) {}
	    });
	  }
	}; /**
	    * Created by neitherzhu on 2017/1/1.
	    */

	module.exports = exports['default'];

/***/ },
/* 37 */,
/* 38 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	function _toConsumableArray(arr) {
	  if (Array.isArray(arr)) {
	    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
	      arr2[i] = arr[i];
	    }return arr2;
	  } else {
	    return Array.from(arr);
	  }
	}

	/**
	 * Created by neitherzhu on 2017/1/2.
	 */
	var CALLBACKS = {};

	exports.default = {
	  setCallbacks: function setCallbacks(type, callbacks) {
	    if (!CALLBACKS[type]) {
	      CALLBACKS[type] = [];
	    }

	    if (Object.prototype.toString.call(callbacks) === '[object Array]') {
	      CALLBACKS[type] = [].concat(_toConsumableArray(CALLBACKS[type]), _toConsumableArray(callbacks));
	    } else {
	      CALLBACKS[type].push(callbacks);
	    }
	  },
	  getCallbacks: function getCallbacks(type) {
	    return type ? CALLBACKS[type] : CALLBACKS;
	  }
	};
	module.exports = exports['default'];

/***/ },
/* 39 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (msg) {
	  // 被撤回的消息
	  if (msg.msgstatus === 4) {
	    msg.msgtype = 10000;
	    return _convert2.default.convert('chat', msg, 'msgtype');
	  }

	  if (msg.extinfo && msg.extinfo.syschatmsg) {
	    msg.msgtype = 10001;
	    return _convert2.default.convert('chat', msg, 'msgtype');
	  }

	  var result = (0, _defaultParse2.default)(msg);
	  var h = '';

	  if (!result) return;
	  msg.msgbody.forEach(function (mb) {
	    if (typeof mb.jvale === 'string') {
	      try {
	        mb.jvale && (mb.jvale = JSON.parse(mb.jvale));
	      } catch (e) {
	        mb.jvale = {};
	      }
	    }

	    result.menu = {};

	    switch (mb.type) {
	      case 0:
	        var type0html = '';
	        // 如果有链接
	        if (mb.jvale && mb.jvale.SAFE_URLFLAGS && Object.keys(mb.jvale.SAFE_URLFLAGS).length) {
	          type0html = (0, _link2.default)(mb, msg);
	          result.typeList.push({ type: 'link', extra: mb });
	          result.curType = 'link';
	        }

	        // 如果是群@消息
	        if (msg.tribeat && msg.tribeat.atmsgtype !== 0) {

	          if (type0html) {
	            var tpl = '';
	            var div = document.createElement('div');
	            div.innerHTML = type0html;
	            if (div.firstChild && div.firstChild.tagName) {
	              var cs = div.firstChild.childNodes;

	              [].concat(_toConsumableArray(cs)).forEach(function (c) {
	                if (!c.tagName) {

	                  var t = (0, _atmsg2.default)({ value: c.nodeValue }, msg, true);
	                  tpl += t || c.nodeValue;
	                } else {
	                  tpl += c.outerHTML;
	                }
	              });

	              div.firstChild.innerHTML = tpl;

	              type0html = div.innerHTML;
	            }
	          } else {
	            h = (0, _atmsg2.default)(mb, msg);
	            if (!h) {
	              h = (0, _text2.default)(mb);
	              result.curType = 'text';
	            } else {
	              result.curType = 'atmsg';
	              // 已读过的消息不用再触发
	              if (msg.tribeat.atmsgtype != 0 && (msg.tribeat.msgreaded !== 1 || msg.tribeat.relation2me === 1)) {
	                result.typeList.push({
	                  type: 'atmsg',
	                  extra: {
	                    cid: msg.cid,
	                    msgid: msg.msgid,
	                    userid: msg.fromid,
	                    relation2me: msg.tribeat.relation2me,
	                    atmsgtype: msg.tribeat.atmsgtype
	                  }
	                });
	              }
	            }
	            type0html += h;
	          }
	        }

	        if (!type0html) {
	          result.curType = 'text';
	          type0html = (0, _text2.default)(mb);
	        }
	        result.html += type0html;

	        result.menu.canRecall = result.self ? 1 : 0;
	        result.menu.canForward = 1;
	        break;

	      case 1:
	        mb.msgid = msg.msgid;
	        mb.msgtime = msg.msgtime;
	        result.html += (0, _image2.default)(mb, msg);
	        result.typeList.push({
	          type: 'image',
	          extra: mb
	        });
	        result.curType = 'image';
	        result.menu.canRecall = result.self ? 1 : 0;
	        result.menu.canForward = 1;
	        break;
	      case 2:
	        mb.self = result.self;
	        mb.msgid = msg.msgid;
	        mb.readflag = msg.readflag;
	        result.doNotSetReadStatus = true;
	        result.html += (0, _audio2.default)(mb);
	        result.typeList.push({
	          type: 'audio',
	          extra: mb
	        });
	        result.curType = 'audio';
	        result.menu.canRecall = result.self ? 1 : 0;
	        result.menu.canForward = 1;
	        break;
	      case 3:
	        result.doNotSetReadStatus = true;
	        mb.self = result.self;
	        mb.readflag = result.readflag;
	        result.html = (0, _video2.default)(mb);
	        result.curType = 'video';
	        result.menu.canRecall = result.self ? 1 : 0;
	        result.menu.canForward = 1;
	        break;
	      case 8:
	        result.html += (0, _location2.default)(mb);
	        result.curType = 'location';
	        result.menu.canRecall = result.self ? 1 : 0;
	        result.menu.canForward = 1;
	        break;
	      case 65:
	        mb.msgid = msg.msgid;
	        result.curType = 'template';
	        result.html += (0, _template2.default)(mb, getMsgType(msg.cid), result);
	        if (!result.html) {
	          result = false;
	        }
	        break;
	      case 80:
	        result.html += (0, _t2.default)(mb);
	        result.curType = 'temp80';
	        break;
	      case 112:
	        if (typeof mb.value === 'string') {
	          mb.value = JSON.parse(mb.value);
	        }

	        result.doNotSetReadStatus = true;
	        result.menu.canForward = 1;

	        if (mb.value.opType === 'add') {
	          result.typeList.push({
	            type: 'dynamicMsg',
	            extra: {
	              cid: msg.cid,
	              bizType: mb.value.bizType,
	              bizUuid: mb.value.bizUuid,
	              msgtime: msg.msgtime,
	              id: msg.msgid
	            }
	          });

	          result.cls = 'temp20014-msg';
	          result.curType = 'dynamic';
	        } else {
	          mb.value.originMsgId && (0, _dynamicMsg2.default)({
	            cid: msg.cid,
	            bizType: mb.value.bizType,
	            bizUuid: mb.value.bizUuid,
	            msgtime: msg.msgtime,
	            id: mb.value.originMsgId
	          });

	          result = false;
	        }
	        break;
	      case 113:
	        if (typeof mb.value === 'string') {
	          try {
	            mb.value = JSON.parse(mb.value);
	          } catch (e) {
	            mb.value = '';
	          }
	        }
	        mb.msgid = msg.msgid;
	        mb.isFail = result.isFail;
	        mb.isSelf = result.self;
	        result.curType = 'file';
	        // 大于两秒钟不需要撤回, 对于文件类型则显示为空
	        result.isFileEmptyMenu = (_window2.default.serverTime || +new Date()) - result.msgtime > _constants2.default.RECALL_LIMIT;

	        result.menu.canRecall = result.self ? 1 : 0;
	        result.menu.canForward = 1;

	        if (mb.value) {
	          result.html = (0, _file2.default)(mb, msg);

	          if (!result.html) {
	            result = false;
	            break;
	          }
	          result.doNotSetReadStatus = true;
	          result.cls = 'file-msg-wrap';
	          result.readFlagText = _constants2.default.I18N[_constants2.default.LANGUAGE][result.readflag ? 'FILE_OPENED' : 'FILE_UNOPENED'];
	          if (msg.msgstatus === 3) {
	            result.typeList.push({
	              type: 'file',
	              extra: mb.value && mb.value.fileInfo
	            });
	          }
	        } else {
	          result = false;
	        }

	        break;

	      // 淘宝不支持消息类型
	      case -1:
	        result.curType = 'taobao-degrademsg';
	        // 区分手淘过来消息
	        result.html = _constants2.default.I18N[_constants2.default.LANGUAGE].TAOBAO_NOT_SUPPORT_MSG;
	        break;

	      // 淘宝分享消息类型
	      case -2:
	        result.curType = 'taobao-sharemsg';
	        result.html = (0, _taobaoShare2.default)(mb, msg);
	        break;

	      // 淘宝系统消息
	      case -3:
	        result.curType = 'taobao-sysmsg';
	        try {
	          result.html = JSON.parse(mb.value).content;
	        } catch (e) {
	          result.html = _constants2.default.I18N[_constants2.default.LANGUAGE].TAOBAO_NOT_SUPPORT_MSG;
	        }

	        break;

	      // 淘宝名片消息类型
	      case -4:
	        result.curType = 'taobao-cardmsg';
	        result.html = (0, _taobaoCard2.default)(mb, msg);
	        break;

	      // 淘宝大图消息类型
	      case -5:
	        result.curType = 'taobao-feedmsg';
	        result.html = (0, _taobaoFeed2.default)(mb, msg);
	        break;

	      default:
	        result.curType = 'degrade';
	        // 区分手淘过来消息
	        result.html = _constants2.default.I18N[_constants2.default.LANGUAGE].NOT_SUPPORT_MSG;
	    }
	  });

	  if (result) {
	    // 不是本人，不能撤回消息
	    if (!result.isMe && result.menu) {
	      delete result.menu.canRecall;
	    }
	    result.menu = JSON.stringify(result.menu);
	  }
	  result = _convert2.default.injectNormalFormat(msg, result);

	  return result;
	};

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _link = __webpack_require__(40);

	var _link2 = _interopRequireDefault(_link);

	var _atmsg = __webpack_require__(46);

	var _atmsg2 = _interopRequireDefault(_atmsg);

	var _text = __webpack_require__(47);

	var _text2 = _interopRequireDefault(_text);

	var _image = __webpack_require__(48);

	var _image2 = _interopRequireDefault(_image);

	var _audio = __webpack_require__(49);

	var _audio2 = _interopRequireDefault(_audio);

	var _video = __webpack_require__(50);

	var _video2 = _interopRequireDefault(_video);

	var _location = __webpack_require__(51);

	var _location2 = _interopRequireDefault(_location);

	var _template = __webpack_require__(52);

	var _template2 = _interopRequireDefault(_template);

	var _t = __webpack_require__(58);

	var _t2 = _interopRequireDefault(_t);

	var _file = __webpack_require__(59);

	var _file2 = _interopRequireDefault(_file);

	var _convert = __webpack_require__(36);

	var _convert2 = _interopRequireDefault(_convert);

	var _dynamicMsg = __webpack_require__(61);

	var _dynamicMsg2 = _interopRequireDefault(_dynamicMsg);

	var _defaultParse = __webpack_require__(62);

	var _defaultParse2 = _interopRequireDefault(_defaultParse);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _taobaoCard = __webpack_require__(63);

	var _taobaoCard2 = _interopRequireDefault(_taobaoCard);

	var _taobaoShare = __webpack_require__(64);

	var _taobaoShare2 = _interopRequireDefault(_taobaoShare);

	var _taobaoFeed = __webpack_require__(65);

	var _taobaoFeed2 = _interopRequireDefault(_taobaoFeed);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	function _toConsumableArray(arr) {
	  if (Array.isArray(arr)) {
	    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
	      arr2[i] = arr[i];
	    }return arr2;
	  } else {
	    return Array.from(arr);
	  }
	} /**
	   * Created by neitherzhu on 2017/1/1.
	   */

	function getMsgType(cid) {
	  if (cid.appkey && cid.nick) {
	    return _constants2.default.TYPE.SINGLE;
	  } else if (cid.tribeid) {
	    return _constants2.default.TYPE.TRIBE;
	  }
	}

	;
	module.exports = exports['default'];

/***/ },
/* 40 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _translate = __webpack_require__(41);

	var _translate2 = _interopRequireDefault(_translate);

	var _md = __webpack_require__(42);

	var _md2 = _interopRequireDefault(_md);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var Util = _$BaseRoot.Base.Util; /**
	                                  * Created by neitherzhu on 2017/1/2.
	                                  */

	var RE_BREAK = /\r\n|\n|\r/g;
	var RE_ENCODE = /([.*+?^=!:${}()|[\]\/\\])/g;
	var RE_BLANK = / /g;

	function escapeRegExp(s) {
	  return s.replace(RE_ENCODE, '\\$&'); //$&表示被匹配的字符串
	}

	exports.default = function (mb, msg) {

	  var jv = mb.jvale;
	  var sf = void 0,
	      cls = '',
	      html = '',
	      id = void 0,
	      map = [],
	      turl = void 0,
	      i = 0,
	      reg = void 0,
	      v = mb.value;

	  mb.map = [];

	  var sfs = Object.keys(jv.SAFE_URLFLAGS);

	  // 长的放在前面先匹配,这样可以防止短的是长的一部分时,长的被短的先匹配了
	  sfs.sort(function (a, b) {
	    return b.length - a.length;
	  });

	  sfs.forEach(function (url) {
	    sf = jv.SAFE_URLFLAGS[url]['SAFE_FLAG'];

	    switch (sf) {
	      case 0:
	        cls = 'unknown';
	        break;
	      case 1:
	        cls = 'safe';
	        break;
	      case 2:
	        cls = 'danger';
	        break;
	    }

	    turl = escapeRegExp(url);
	    reg = new RegExp(turl, 'g');
	    v = v.replace(reg, '@@@' + i + '@@@');
	    id = msg ? msg.msgid : Util.guid();

	    map.push({
	      i: i,
	      url: (0, _$JuicerRoot2.default)(_template2.default.link, {
	        id: id,
	        md5: (0, _md2.default)(url),
	        cls: cls,
	        href: url,
	        safeflag: sf
	      })
	    });

	    i++;

	    mb.map.push({ id: id, url: url });
	  });

	  v = Util.htmlEncode(v);
	  v && (v = v.replace(RE_BLANK, '&nbsp;'));

	  map.forEach(function (m) {
	    reg = new RegExp('@@@' + m.i + '@@@', 'g');

	    v = v.replace(reg, m.url);
	  });

	  v && (v = v.replace(RE_BREAK, '<br>'));

	  v = (0, _translate2.default)(mb.jvale, v);

	  return v;
	};

	module.exports = exports['default'];

/***/ },
/* 41 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (param, v) {
	  var sty = '',
	      attr = '',
	      tag_s = '',
	      tag_e = '';
	  var mode = _constants2.default.TEXT_MODE;

	  if (param) {
	    for (var _s in param) {
	      if (_s === 'FONT_SIZE' && mode === DEFAULT) {
	        sty += 'font-size:' + fixFontSize(param[_s]) + 'pt';
	      } else if (_s === 'FONT_BOLD_STYLE') {
	        tag_s = '<b>' + tag_s;
	        tag_e += '</b>';
	      } else if (_s === 'FONT_ITALIC_STYLE') {
	        tag_s = '<i>' + tag_s;
	        tag_e += '</i>';
	      } else if (_s === 'FONT_UNDERLINE_STYLE') {
	        tag_s = '<u>' + tag_s;
	        tag_e += '</u>';
	      } else if (_s === 'FONT_COLOR' && mode === DEFAULT) {
	        attr += ' color="#' + fixColor(param[_s].toString(16)) + '"';
	      } else if (_s === 'FONT_FAMILY' && mode === DEFAULT) {
	        attr += ' face="' + param[_s] + '"';
	      }
	    }
	  }

	  v = tag_s + '<font' + attr + ' style="' + sty + '">' + v + '</font>' + tag_e;

	  return v;
	};

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var s = '000000'; /**
	                   * Created by neitherzhu on 2017/1/2.
	                   */

	var DEFAULT = 'DEFAULT';
	/**
	 * 填充完整十六进制颜色
	 * @param c
	 * @returns {*}
	 */
	function fixColor(c) {

	  /**
	   * 修复消息颜色为白色时, 将颜色加深(安全问题)
	   */
	  var color = parseInt(c, 16);
	  if ((color & 0x000000FF) >= 0xDC && (color >> 8 & 0x000000FF) >= 0xDC && (color >> 16 & 0x000000FF) >= 0xDC) {
	    c = 0x00505050;
	  }

	  if (c.length < 6) {
	    return s.slice(0, 6 - c.length) + c;
	  }

	  return c;
	}

	function fixFontSize(s) {
	  s = parseInt(s);

	  return s >= 9 ? s : 9;
	}

	module.exports = exports['default'];

/***/ },
/* 42 */
/***/ function(module, exports, __webpack_require__) {

	(function(){
	  var crypt = __webpack_require__(43),
	      utf8 = __webpack_require__(44).utf8,
	      isBuffer = __webpack_require__(45),
	      bin = __webpack_require__(44).bin,

	  // The core
	  md5 = function (message, options) {
	    // Convert to byte array
	    if (message.constructor == String)
	      if (options && options.encoding === 'binary')
	        message = bin.stringToBytes(message);
	      else
	        message = utf8.stringToBytes(message);
	    else if (isBuffer(message))
	      message = Array.prototype.slice.call(message, 0);
	    else if (!Array.isArray(message))
	      message = message.toString();
	    // else, assume byte array already

	    var m = crypt.bytesToWords(message),
	        l = message.length * 8,
	        a =  1732584193,
	        b = -271733879,
	        c = -1732584194,
	        d =  271733878;

	    // Swap endian
	    for (var i = 0; i < m.length; i++) {
	      m[i] = ((m[i] <<  8) | (m[i] >>> 24)) & 0x00FF00FF |
	             ((m[i] << 24) | (m[i] >>>  8)) & 0xFF00FF00;
	    }

	    // Padding
	    m[l >>> 5] |= 0x80 << (l % 32);
	    m[(((l + 64) >>> 9) << 4) + 14] = l;

	    // Method shortcuts
	    var FF = md5._ff,
	        GG = md5._gg,
	        HH = md5._hh,
	        II = md5._ii;

	    for (var i = 0; i < m.length; i += 16) {

	      var aa = a,
	          bb = b,
	          cc = c,
	          dd = d;

	      a = FF(a, b, c, d, m[i+ 0],  7, -680876936);
	      d = FF(d, a, b, c, m[i+ 1], 12, -389564586);
	      c = FF(c, d, a, b, m[i+ 2], 17,  606105819);
	      b = FF(b, c, d, a, m[i+ 3], 22, -1044525330);
	      a = FF(a, b, c, d, m[i+ 4],  7, -176418897);
	      d = FF(d, a, b, c, m[i+ 5], 12,  1200080426);
	      c = FF(c, d, a, b, m[i+ 6], 17, -1473231341);
	      b = FF(b, c, d, a, m[i+ 7], 22, -45705983);
	      a = FF(a, b, c, d, m[i+ 8],  7,  1770035416);
	      d = FF(d, a, b, c, m[i+ 9], 12, -1958414417);
	      c = FF(c, d, a, b, m[i+10], 17, -42063);
	      b = FF(b, c, d, a, m[i+11], 22, -1990404162);
	      a = FF(a, b, c, d, m[i+12],  7,  1804603682);
	      d = FF(d, a, b, c, m[i+13], 12, -40341101);
	      c = FF(c, d, a, b, m[i+14], 17, -1502002290);
	      b = FF(b, c, d, a, m[i+15], 22,  1236535329);

	      a = GG(a, b, c, d, m[i+ 1],  5, -165796510);
	      d = GG(d, a, b, c, m[i+ 6],  9, -1069501632);
	      c = GG(c, d, a, b, m[i+11], 14,  643717713);
	      b = GG(b, c, d, a, m[i+ 0], 20, -373897302);
	      a = GG(a, b, c, d, m[i+ 5],  5, -701558691);
	      d = GG(d, a, b, c, m[i+10],  9,  38016083);
	      c = GG(c, d, a, b, m[i+15], 14, -660478335);
	      b = GG(b, c, d, a, m[i+ 4], 20, -405537848);
	      a = GG(a, b, c, d, m[i+ 9],  5,  568446438);
	      d = GG(d, a, b, c, m[i+14],  9, -1019803690);
	      c = GG(c, d, a, b, m[i+ 3], 14, -187363961);
	      b = GG(b, c, d, a, m[i+ 8], 20,  1163531501);
	      a = GG(a, b, c, d, m[i+13],  5, -1444681467);
	      d = GG(d, a, b, c, m[i+ 2],  9, -51403784);
	      c = GG(c, d, a, b, m[i+ 7], 14,  1735328473);
	      b = GG(b, c, d, a, m[i+12], 20, -1926607734);

	      a = HH(a, b, c, d, m[i+ 5],  4, -378558);
	      d = HH(d, a, b, c, m[i+ 8], 11, -2022574463);
	      c = HH(c, d, a, b, m[i+11], 16,  1839030562);
	      b = HH(b, c, d, a, m[i+14], 23, -35309556);
	      a = HH(a, b, c, d, m[i+ 1],  4, -1530992060);
	      d = HH(d, a, b, c, m[i+ 4], 11,  1272893353);
	      c = HH(c, d, a, b, m[i+ 7], 16, -155497632);
	      b = HH(b, c, d, a, m[i+10], 23, -1094730640);
	      a = HH(a, b, c, d, m[i+13],  4,  681279174);
	      d = HH(d, a, b, c, m[i+ 0], 11, -358537222);
	      c = HH(c, d, a, b, m[i+ 3], 16, -722521979);
	      b = HH(b, c, d, a, m[i+ 6], 23,  76029189);
	      a = HH(a, b, c, d, m[i+ 9],  4, -640364487);
	      d = HH(d, a, b, c, m[i+12], 11, -421815835);
	      c = HH(c, d, a, b, m[i+15], 16,  530742520);
	      b = HH(b, c, d, a, m[i+ 2], 23, -995338651);

	      a = II(a, b, c, d, m[i+ 0],  6, -198630844);
	      d = II(d, a, b, c, m[i+ 7], 10,  1126891415);
	      c = II(c, d, a, b, m[i+14], 15, -1416354905);
	      b = II(b, c, d, a, m[i+ 5], 21, -57434055);
	      a = II(a, b, c, d, m[i+12],  6,  1700485571);
	      d = II(d, a, b, c, m[i+ 3], 10, -1894986606);
	      c = II(c, d, a, b, m[i+10], 15, -1051523);
	      b = II(b, c, d, a, m[i+ 1], 21, -2054922799);
	      a = II(a, b, c, d, m[i+ 8],  6,  1873313359);
	      d = II(d, a, b, c, m[i+15], 10, -30611744);
	      c = II(c, d, a, b, m[i+ 6], 15, -1560198380);
	      b = II(b, c, d, a, m[i+13], 21,  1309151649);
	      a = II(a, b, c, d, m[i+ 4],  6, -145523070);
	      d = II(d, a, b, c, m[i+11], 10, -1120210379);
	      c = II(c, d, a, b, m[i+ 2], 15,  718787259);
	      b = II(b, c, d, a, m[i+ 9], 21, -343485551);

	      a = (a + aa) >>> 0;
	      b = (b + bb) >>> 0;
	      c = (c + cc) >>> 0;
	      d = (d + dd) >>> 0;
	    }

	    return crypt.endian([a, b, c, d]);
	  };

	  // Auxiliary functions
	  md5._ff  = function (a, b, c, d, x, s, t) {
	    var n = a + (b & c | ~b & d) + (x >>> 0) + t;
	    return ((n << s) | (n >>> (32 - s))) + b;
	  };
	  md5._gg  = function (a, b, c, d, x, s, t) {
	    var n = a + (b & d | c & ~d) + (x >>> 0) + t;
	    return ((n << s) | (n >>> (32 - s))) + b;
	  };
	  md5._hh  = function (a, b, c, d, x, s, t) {
	    var n = a + (b ^ c ^ d) + (x >>> 0) + t;
	    return ((n << s) | (n >>> (32 - s))) + b;
	  };
	  md5._ii  = function (a, b, c, d, x, s, t) {
	    var n = a + (c ^ (b | ~d)) + (x >>> 0) + t;
	    return ((n << s) | (n >>> (32 - s))) + b;
	  };

	  // Package private blocksize
	  md5._blocksize = 16;
	  md5._digestsize = 16;

	  module.exports = function (message, options) {
	    if (message === undefined || message === null)
	      throw new Error('Illegal argument ' + message);

	    var digestbytes = crypt.wordsToBytes(md5(message, options));
	    return options && options.asBytes ? digestbytes :
	        options && options.asString ? bin.bytesToString(digestbytes) :
	        crypt.bytesToHex(digestbytes);
	  };

	})();


/***/ },
/* 43 */
/***/ function(module, exports) {

	(function() {
	  var base64map
	      = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/',

	  crypt = {
	    // Bit-wise rotation left
	    rotl: function(n, b) {
	      return (n << b) | (n >>> (32 - b));
	    },

	    // Bit-wise rotation right
	    rotr: function(n, b) {
	      return (n << (32 - b)) | (n >>> b);
	    },

	    // Swap big-endian to little-endian and vice versa
	    endian: function(n) {
	      // If number given, swap endian
	      if (n.constructor == Number) {
	        return crypt.rotl(n, 8) & 0x00FF00FF | crypt.rotl(n, 24) & 0xFF00FF00;
	      }

	      // Else, assume array and swap all items
	      for (var i = 0; i < n.length; i++)
	        n[i] = crypt.endian(n[i]);
	      return n;
	    },

	    // Generate an array of any length of random bytes
	    randomBytes: function(n) {
	      for (var bytes = []; n > 0; n--)
	        bytes.push(Math.floor(Math.random() * 256));
	      return bytes;
	    },

	    // Convert a byte array to big-endian 32-bit words
	    bytesToWords: function(bytes) {
	      for (var words = [], i = 0, b = 0; i < bytes.length; i++, b += 8)
	        words[b >>> 5] |= bytes[i] << (24 - b % 32);
	      return words;
	    },

	    // Convert big-endian 32-bit words to a byte array
	    wordsToBytes: function(words) {
	      for (var bytes = [], b = 0; b < words.length * 32; b += 8)
	        bytes.push((words[b >>> 5] >>> (24 - b % 32)) & 0xFF);
	      return bytes;
	    },

	    // Convert a byte array to a hex string
	    bytesToHex: function(bytes) {
	      for (var hex = [], i = 0; i < bytes.length; i++) {
	        hex.push((bytes[i] >>> 4).toString(16));
	        hex.push((bytes[i] & 0xF).toString(16));
	      }
	      return hex.join('');
	    },

	    // Convert a hex string to a byte array
	    hexToBytes: function(hex) {
	      for (var bytes = [], c = 0; c < hex.length; c += 2)
	        bytes.push(parseInt(hex.substr(c, 2), 16));
	      return bytes;
	    },

	    // Convert a byte array to a base-64 string
	    bytesToBase64: function(bytes) {
	      for (var base64 = [], i = 0; i < bytes.length; i += 3) {
	        var triplet = (bytes[i] << 16) | (bytes[i + 1] << 8) | bytes[i + 2];
	        for (var j = 0; j < 4; j++)
	          if (i * 8 + j * 6 <= bytes.length * 8)
	            base64.push(base64map.charAt((triplet >>> 6 * (3 - j)) & 0x3F));
	          else
	            base64.push('=');
	      }
	      return base64.join('');
	    },

	    // Convert a base-64 string to a byte array
	    base64ToBytes: function(base64) {
	      // Remove non-base-64 characters
	      base64 = base64.replace(/[^A-Z0-9+\/]/ig, '');

	      for (var bytes = [], i = 0, imod4 = 0; i < base64.length;
	          imod4 = ++i % 4) {
	        if (imod4 == 0) continue;
	        bytes.push(((base64map.indexOf(base64.charAt(i - 1))
	            & (Math.pow(2, -2 * imod4 + 8) - 1)) << (imod4 * 2))
	            | (base64map.indexOf(base64.charAt(i)) >>> (6 - imod4 * 2)));
	      }
	      return bytes;
	    }
	  };

	  module.exports = crypt;
	})();


/***/ },
/* 44 */
/***/ function(module, exports) {

	var charenc = {
	  // UTF-8 encoding
	  utf8: {
	    // Convert a string to a byte array
	    stringToBytes: function(str) {
	      return charenc.bin.stringToBytes(unescape(encodeURIComponent(str)));
	    },

	    // Convert a byte array to a string
	    bytesToString: function(bytes) {
	      return decodeURIComponent(escape(charenc.bin.bytesToString(bytes)));
	    }
	  },

	  // Binary encoding
	  bin: {
	    // Convert a string to a byte array
	    stringToBytes: function(str) {
	      for (var bytes = [], i = 0; i < str.length; i++)
	        bytes.push(str.charCodeAt(i) & 0xFF);
	      return bytes;
	    },

	    // Convert a byte array to a string
	    bytesToString: function(bytes) {
	      for (var str = [], i = 0; i < bytes.length; i++)
	        str.push(String.fromCharCode(bytes[i]));
	      return str.join('');
	    }
	  }
	};

	module.exports = charenc;


/***/ },
/* 45 */
/***/ function(module, exports) {

	/*!
	 * Determine if an object is a Buffer
	 *
	 * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
	 * @license  MIT
	 */

	// The _isBuffer check is for Safari 5-7 support, because it's missing
	// Object.prototype.constructor. Remove this eventually
	module.exports = function (obj) {
	  return obj != null && (isBuffer(obj) || isSlowBuffer(obj) || !!obj._isBuffer)
	}

	function isBuffer (obj) {
	  return !!obj.constructor && typeof obj.constructor.isBuffer === 'function' && obj.constructor.isBuffer(obj)
	}

	// For Node v0.10 support. Remove this eventually.
	function isSlowBuffer (obj) {
	  return typeof obj.readFloatLE === 'function' && typeof obj.slice === 'function' && isBuffer(obj.slice(0, 0))
	}


/***/ },
/* 46 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _translate = __webpack_require__(41);

	var _translate2 = _interopRequireDefault(_translate);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/1/1.
	 * 解析@消息
	 */
	var Util = _$BaseRoot.Base.Util;

	var RE_AT_ALL = /(@all[\s|\n|\r]*)|(@所有人[\s|\n|\r]*)/g;
	var RE_AT_USER = /@([\w|\(|\)|\:|\u4e00-\u9fa5]+)[\s|\n|\r]*/g;
	var RE_BREAK = /\r\n|\n|\r/g;
	var RE_BLANK = / /g;
	var BLANK_TEST = /[^>]&nbsp;$/;

	exports.default = function (mb, msg, doNotTranslate) {
	  var t = msg.tribeat;
	  var type = t.atmsgtype;
	  var members = t.atmembers;
	  var isAtAll = type === 2 || type === -2;
	  var re = isAtAll ? RE_AT_ALL : RE_AT_USER;
	  var html = '';
	  var users = void 0;
	  var v = Util.htmlEncode(mb.value);

	  v && (v = v.replace(RE_BREAK, '<br>'));
	  v && (v = v.replace(RE_BLANK, '&nbsp;'));

	  if (!BLANK_TEST.test(v)) {
	    v += '&nbsp;';
	  }

	  users = v.match(re);

	  !doNotTranslate && mb.jvale && (v = (0, _translate2.default)(mb.jvale, v));

	  if (!users || !users.length) {
	    html = false;
	  } else {
	    if (isAtAll) {
	      html = v.replace(re, '<span class="imui-msg-atmsg J_atMsg">' + users[0] + ' </span>');
	    } else if (members && members.length) {
	      users.forEach(function (user) {
	        var l = members.length;
	        for (var i = 0; i < l; i++) {
	          if ('@' + members[i].nick === user.trim()) {
	            var r = new RegExp(user.replace('(', '\\(').replace(')', '\\)') + '&nbsp;', 'gi');
	            v = v.replace(r, '<span class="imui-msg-atmsg J_atMsg">' + user + '&nbsp; </span> ');
	            break;
	          }
	        }
	      });
	      html = v;
	    }
	  }

	  return html;
	};

	module.exports = exports['default'];

/***/ },
/* 47 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _translate = __webpack_require__(41);

	var _translate2 = _interopRequireDefault(_translate);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/1/2.
	 */
	var Util = _$BaseRoot.Base.Util;

	var RE_BREAK = /\r\n|\n|\r/g;
	var RE_BLANK = / /g;

	exports.default = function (mb) {
	  var v = Util.htmlEncode(mb.value) || '';

	  v && (v = v.replace(RE_BREAK, '<br>'));
	  v && (v = v.replace(RE_BLANK, '&nbsp;'));

	  return (0, _translate2.default)(mb.jvale, v);
	};

	module.exports = exports['default'];

/***/ },
/* 48 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = function (mb, msg) {

	  var loading = mb.value.indexOf(_constants2.default.PIC_PROTOCOL) !== 0;
	  var isEmotion = mb.value.indexOf(_constants2.default.EMOTION_PROTOCOL) === 0;
	  var isEmoji = isEmotion ? false : mb.value.indexOf(_constants2.default.EMOJI_PROTOCOL) === 0;

	  return (0, _$JuicerRoot2.default)(_template2.default.image, {
	    id: msg.msgid,
	    md5: mb.jvale && mb.jvale.FILEMD5,
	    type: mb.jvale && mb.jvale.TYPE,
	    loading: loading,
	    src: mb.value,
	    isEmoji: isEmoji,
	    isEmotion: isEmotion,
	    msgtime: msg.msgtime
	  });
	}; /**
	    * Created by neitherzhu on 2017/1/2.
	    */

	module.exports = exports['default'];

/***/ },
/* 49 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/1/2.
	 */
	exports.default = function (mb) {

	  return (0, _$JuicerRoot2.default)(_template2.default.audio, {
	    dur: mb.jvale.PLAYTIME,
	    md5: mb.jvale.FILEMD5,
	    type: mb.jvale.TYPE,
	    msgid: mb.msgid,
	    text: mb.jvale.AUDIO_TEXT,
	    self: mb.self,
	    readFlag: mb.readflag
	  });
	};

	module.exports = exports['default'];

/***/ },
/* 50 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/1/2.
	 */
	exports.default = function (mb) {
	  var value = mb.value,
	      url = void 0;
	  if (typeof value === 'string') {
	    try {
	      value = JSON.parse(value);
	    } catch (e) {}
	  }

	  if (value.resource) {
	    url = value.resource;
	  } else {
	    url = value;
	  }

	  return (0, _$JuicerRoot2.default)(_template2.default.video, {
	    url: url,
	    self: mb.self,
	    readFlag: mb.readflag
	  });
	};

	module.exports = exports['default'];

/***/ },
/* 51 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = function (mb) {

	  var v = '',
	      url = '';
	  if (mb.jvale && mb.jvale.NAME) {
	    v = mb.jvale.NAME;
	    url = 'https://m.amap.com/navi/?dest=' + mb.jvale.LONGITUDE + ',' + mb.jvale.LATITUDE + '&destName=' + encodeURIComponent(v) + '&hideRouteIcon=1&key=9b737f5a37b803624c41024081fc32f1';
	  }
	  return v ? (0, _$JuicerRoot2.default)(_template2.default.location, {
	    url: url,
	    v: v,
	    linkText: _constants2.default.I18N[_constants2.default.LANGUAGE].CHECK_MAP
	  }) : _constants2.default.I18N[_constants2.default.LANGUAGE].NOT_SUPPORT_MSG;
	}; /**
	    * Created by neitherzhu on 2017/1/2.
	    */

	module.exports = exports['default'];

/***/ },
/* 52 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	var _temp = __webpack_require__(54);

	var _temp2 = _interopRequireDefault(_temp);

	var _temp3 = __webpack_require__(55);

	var _temp4 = _interopRequireDefault(_temp3);

	var _temp5 = __webpack_require__(57);

	var _temp6 = _interopRequireDefault(_temp5);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/1/2.
	 */
	exports.default = function (mb, msgType, result) {

	  var value = mb.value,
	      tpl = '';

	  try {
	    value = JSON.parse(value);
	  } catch (e) {
	    value = false;
	  }

	  if (!value) return tpl;

	  // h5模板消息
	  if (value.template.id === 20002) {
	    tpl = (0, _temp2.default)(value);
	  }
	  // alist模板消息
	  else if (value.template.id === 20013) {
	      tpl = (0, _temp4.default)(mb, value, msgType);
	    }
	    // 栅格化消息
	    else if (value.template.id === 20014) {
	        tpl = (0, _temp6.default)(value, result);
	      } else {
	        tpl = _util2.default.degrade(value);
	      }

	  return tpl;
	};

	module.exports = exports['default'];

/***/ },
/* 53 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/2/17.
	 */
	var Util = _$BaseRoot.Base.Util;

	var __NOW = new Date();
	__NOW.setHours(0);
	__NOW.setMinutes(0);
	__NOW.setSeconds(0);
	__NOW.setMilliseconds(0);

	var __ONE_DAY_MS = 24 * 60 * 60 * 1000;
	var __TODAY_START_MS = +__NOW;
	var __TDOAY_END_MS = __TODAY_START_MS + __ONE_DAY_MS;
	var __YESTERDAY_START_MS = __TODAY_START_MS - __ONE_DAY_MS;
	var __YESTERDAY_END_MS = __TODAY_START_MS - 1;

	function numberify(n) {
	  return n > 9 ? n : '0' + n;
	}

	Date.prototype.__getFormatTime = function () {
	  return numberify(this.getHours()) + ':' + numberify(this.getMinutes()) + ':' + numberify(this.getSeconds());
	};

	Date.prototype.__getFormatFullDate = function () {
	  return this.getFullYear() + '-' + (this.getMonth() + 1) + '-' + this.getDate() + ' ' + this.__getFormatTime();
	};

	Date.prototype.__getOnlyDate = function () {
	  return this.getFullYear() + '-' + (this.getMonth() + 1) + '-' + this.getDate();
	};

	/**
	 * 格式化日期
	 * @param  {Number} ms 毫秒数
	 * @return {String}
	 */
	Util.dateFormatter = function (ms) {
	  ms = parseInt(ms, 10);

	  return new Date(ms).__getFormatFullDate();
	  //if(ms >= __TODAY_START_MS) {
	  //  return new Date(ms).__getFormatTime();
	  //}else if(ms >= __YESTERDAY_START_MS) {
	  //  return '昨天 ' + (new Date(ms).__getFormatTime());
	  //}else {
	  //  return new Date(ms).__getFormatFullDate();
	  //}
	};

	Util.timeFormatter = function (ms) {
	  ms = parseInt(ms, 10);
	  return new Date(ms).__getFormatTime();
	};

	Util.degrade = function (value) {
	  return value.header && value.header.degrade && value.header.degrade.alternative || _constants2.default.I18N[_constants2.default.LANGUAGE].NOT_SUPPORT_MSG;
	};

	var SIZE_SUFFIX = {
	  0: 'B',
	  1: 'KB',
	  2: 'MB',
	  3: 'GB'
	};

	Util.getFileSize = function (s) {
	  var r = parseInt(s);
	  var c = 0;

	  while (r > 1024) {
	    r = r / 1024;
	    c++;
	  }

	  return r.toFixed(1) + SIZE_SUFFIX[c];
	};

	var isCN = /[\u4e00-\u9fa5]/;

	Util.getStrLen = function (s) {

	  var len = 0;
	  for (var i = 0, l = s.length; i < l; i++) {
	    len += isCN.test(s.charAt[i]) ? 2 : 1;
	  }

	  return len;
	};

	Util.getStrByLen = function (s, maxLen, dur) {
	  dur || (dur = 2);
	  var len = 0;
	  var goLast = false;
	  var l = s.length;
	  var ellipsisLen = 3; // ...的长度
	  var i = 0;
	  var result = '';
	  var lastStr = s.substring(l - dur, l);
	  // 获取最后2个字符的长度
	  var last2StrLen = Util.getStrLen(lastStr);

	  for (; i < l; i++) {
	    len += isCN.test(s.charAt[i]) ? 2 : 1;

	    if (len >= maxLen - last2StrLen - ellipsisLen) {

	      if (len > maxLen - last2StrLen - ellipsisLen) {
	        i--;
	      }

	      // 如果还有更多的字符需要遍历, 则不再遍历
	      if (i < l - 2) {
	        goLast = true;
	      }
	      break;
	    }
	  }

	  if (goLast) {
	    result = s.substring(0, i) + '...' + lastStr;
	  } else {
	    result = s;
	  }

	  return result;
	};

	Util.generatorFileMeta = function (target) {
	  var result = {};

	  result.parentId = target.dataset.pid;
	  result.md5 = target.dataset.md5;
	  result.nodeType = target.dataset.type;
	  result.id = target.id.substring(6);
	  result.nodeName = target.dataset.name;
	  result.nodeSize = target.dataset.size;

	  return result;
	};

	Util.getDuration = function (dur) {
	  dur = parseInt(dur);

	  var s = dur % 60;
	  var m = (dur - s) / 60;
	  var h = parseInt(m / 60);

	  return (h > 0 ? Util.numberify(h) + ':' : '') + Util.numberify(m) + ':' + Util.numberify(s);
	};

	Util.numberify = function (num) {
	  if (num > 9) {
	    return num;
	  }

	  return '0' + num;
	};

	Util.getCid = function (conversation) {
	  if (!conversation) return null;

	  var result = {};

	  if (conversation.type === _constants2.default.TYPE.SINGLE) {
	    result.uid = conversation;
	  } else {
	    result.tid = conversation;
	  }

	  result.type = conversation.type;

	  return result;
	};

	Util.getUidByCid = function (cid) {
	  if (cid.type === _constants2.default.TYPE.SINGLE) {
	    return cid.uid && cid.uid.appkey + cid.uid.nick;
	  } else {
	    return cid.tid && cid.tid.tribeid;
	  }
	};

	exports.default = Util;
	module.exports = exports['default'];

/***/ },
/* 54 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (value) {
	  var tpl = '';

	  if (value.template.data && value.template.data.text) {
	    tpl = (0, _$JuicerRoot2.default)(_template2.default.card, { html: value.template.data.text });
	  } else {
	    tpl = _util2.default.degrade(value);
	  }

	  return tpl;
	};

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/2/24.
	 */
	module.exports = exports['default'];

/***/ },
/* 55 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (mb, value, msgType) {
	  var tpl = '';

	  if (value.template.data && value.template.data.alist) {
	    var t = '',
	        s = '',
	        id = 'J_temp20013_' + mb.msgid,
	        len = value.template.data.alist.length,
	        v = '',
	        isChanged = false,
	        links = [];

	    value.template.data.alist.forEach(function (list, index) {

	      if (!list.label) return;

	      var label = list.label;

	      label = label.replace(RE_BREAK, '<br>');
	      label = label.replace(RE_BLANK, '&nbsp;');

	      t = '';
	      s = '';

	      _sdk2.default.convertMsgToEmotion({
	        value: list.label,
	        type: 0,
	        jvale: '',
	        strDegradeText: '',
	        msgType: msgType
	      }).then(function (data) {
	        var temp = '';
	        var l = void 0;
	        s = '';

	        data.forEach(function (r) {
	          l = r.value;

	          if (r.type === 0) {
	            isChanged = true;
	            r.jvale = JSON.parse(r.jvale);
	            temp += (0, _link2.default)(r, mb);
	            links.push(r);
	          } else if (r.type === 1) {
	            isChanged = true;
	            temp += '<img src="' + l + '"/>';
	          } else {
	            l = l.replace(RE_BREAK, '<br>');
	            l = l.replace(RE_BLANK, '&nbsp;');
	            temp += l;
	          }
	        });

	        s = translateStyle(list);

	        v += genList(list, s, temp);

	        if (len - 1 == index && isChanged) {
	          document.getElementById(id).innerHTML = v;
	          if (links && links.length) {
	            links.forEach(function (link) {
	              (0, _link4.default)(link);
	            });
	          }
	          if (window.CustomEvent && window.dispatchEvent) {
	            // 手动触发resize事件
	            var event = new CustomEvent('resize');
	            window.dispatchEvent(event);
	          }
	        }
	      }).catch(function (err) {});

	      s = translateStyle(list);

	      t = genList(list, s, label);

	      tpl += t;
	    });

	    tpl && (tpl = '<div class="alist-msg-wrap" id="' + id + '">' + tpl + '</div>');
	  } else {
	    tpl = _util2.default.degrade(value);
	  }

	  return tpl;
	};

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _link = __webpack_require__(40);

	var _link2 = _interopRequireDefault(_link);

	var _link3 = __webpack_require__(56);

	var _link4 = _interopRequireDefault(_link3);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/2/24.
	 */
	var RE_BREAK = /\r\n|\n|\r/g;
	var RE_BLANK = / /g;

	function genList(list, style, v) {
	  var t = '';

	  if (list.action && list.action.length) {
	    t = '<a href="#TemplateMsgAction#' + _util2.default.htmlEncode(JSON.stringify(list.action)) + '" style="' + style + '">' + v + '</a>';
	  } else {
	    t = '<span style="' + style + '">' + v + '</span>';
	  }

	  list.br && (t += '<br>');

	  return t;
	}

	function translateStyle(list) {
	  var style = {};
	  var s = '';
	  if (list.attr) {
	    if (typeof list.attr === 'string') {
	      list.attr = list.attr.split('|');
	    }
	    list.attr.forEach(function (a) {
	      a.toUpperCase() === 'B' && (style['font-weight'] = 'bold');
	      a.toUpperCase() === 'U' && (style['text-decoration'] = 'underline');
	      a.toUpperCase() === 'I' && (style['font-style'] = 'italic');
	    });
	  }
	  list.color && (style['color'] = list.color.indexOf('#') === 0 ? list.color : '#' + list.color);
	  list.font && (style['font-family'] = list.font);
	  list.size && (style['font-size'] = list.size + 'pt');

	  for (var k in style) {
	    s += k + ':' + style[k] + ';';
	  }

	  return s;
	}
	module.exports = exports['default'];

/***/ },
/* 56 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (extra, callback) {
	  if (!extra || !extra.map || !extra.map.length) return;

	  extra.map.forEach(function (o) {
	    _sdk2.default.getUrlSnapshot({ url: o.url, msgid: o.id }).then(function (data) {

	      if (callback && !callback(data) || !data.snapshot) return;

	      var html = data.snapshot;
	      var links = document.querySelectorAll('.J_link_' + o.id + '_' + (0, _md2.default)(o.url));

	      [].concat(_toConsumableArray(links)).forEach(function (link) {
	        var next = link.nextSibling;
	        if (next && next.classList && next.classList.contains('item-snapshot-wrap')) return;
	        //let link = document.getElementById('J_link_' + o.id);
	        var div = document.createElement('div');
	        var ssId = 'J_snapshot_' + o.id;

	        //if(document.getElementById(ssId)) return;

	        div.className = _constants2.default.CLS.SNAPSHOT;
	        div.innerHTML = html;
	        div.id = ssId;

	        link.parentNode.insertBefore(div, link.nextSibling);
	      });

	      _window2.default.sharedWin.isBottom && Util.scrollToBottom(_window2.default.sharedWin.container);
	    }).catch(function (err) {});
	  });
	};

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _$BaseRoot = __webpack_require__(3);

	var _md = __webpack_require__(42);

	var _md2 = _interopRequireDefault(_md);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	function _toConsumableArray(arr) {
	  if (Array.isArray(arr)) {
	    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
	      arr2[i] = arr[i];
	    }return arr2;
	  } else {
	    return Array.from(arr);
	  }
	} /**
	   * Created by neitherzhu on 2016/12/6.
	   * 链接消息 可能是宝贝链接,需要去拿下是否有宝贝快照
	   */

	var Util = _$BaseRoot.Base.Util;
	module.exports = exports['default'];

/***/ },
/* 57 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (value, result) {

	  var body = value.template.data.body;
	  var SIZE = value.template.data.pc_width || 'small';

	  if (!CARD_SIZE || CARD_SIZE !== SIZE) {
	    CARD_SIZE = SIZE;
	    getStrMap(CARD_SIZE);
	  }
	  var data = parseData(body);
	  if (!data) return '';
	  var t = translateData(data);

	  t && (t = '<div class="temp20014-wrap ' + SIZE_MAP[CARD_SIZE].cls + (value.template.data.bgl === LUCY_MONEY_BGL ? ' lucy-money' : '') + '">' + t + '</div>');

	  if (!t) {
	    t = _util2.default.degrade(value);
	  } else if (result) {
	    result.cls = 'temp20014-msg';
	    result.curType = 'dynamic';
	  }

	  return t;
	};

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var STYLE_KEY = ['padding', 'display', 'flex-direction', 'justify-content', 'align-items', 'align-self', 'background-color', 'color', 'text-decoration', 'font-size', 'border-radius', 'border-top-color', 'border-top-style']; /**
	                                                                                                                                                                                                                                 * Created by neitherzhu on 2017/2/24.
	                                                                                                                                                                                                                                 */

	var STR_MAP = void 0;
	var PER_WIDTH = void 0;
	var MAX_WIDTH = void 0;
	var CARD_SIZE = void 0;
	var SIZE_MAP = {
	  small: { width: 'TEMP20014_SMALL_MAX_WIDTH', cls: 'small' },
	  middle: { width: 'TEMP20014_MIDDLE_MAX_WIDTH', cls: 'middle' },
	  large: { width: 'TEMP20014_LARGE_MAX_WIDTH', cls: 'large' }
	};
	var DIV_TPL = '<div class="${cls}{@if action} J_tempAction{@/if}" style="${style}" data-action="${action}">$${html}</div>';
	var SPAN_TPL = '<span class="${cls}{@if action} J_tempAction{@/if}" style="${style}" data-action="${action}">$${html}</span>';
	var LUCY_MONEY_BGL = 'drawable://aliwx_hongbao_bubble_left_bg';

	function getStrMap(size) {
	  MAX_WIDTH = _constants2.default[SIZE_MAP[size].width] || 264;
	  PER_WIDTH = MAX_WIDTH / 12;

	  STR_MAP = {
	    f: 'frame',
	    v: 'vector',
	    p: 'padding',
	    cs: 'class',
	    ac: 'action',
	    ds: 'display',
	    fd: 'flex-direction',
	    jc: 'justify-content',
	    ai: 'align-items',
	    ad: 'align-self',
	    fs: 'flex-start',
	    fe: 'flex-end',
	    ct: 'center',
	    st: 'stretch',
	    sb: 'space-between',
	    sa: 'space-around',
	    sv: 'subviews',
	    bc: 'background-color',
	    tc: 'color',
	    /* text-color */
	    td: 'text-decoration',
	    ul: 'underline',
	    lt: 'line-through',
	    ts: 'font-size',
	    /* text-size */
	    xl: (18 / PER_WIDTH).toFixed(2),
	    /* huge */
	    l: (16 / PER_WIDTH).toFixed(2),
	    /* large */
	    m: (14 / PER_WIDTH).toFixed(2),
	    /* medium */
	    s: (12 / PER_WIDTH).toFixed(2),
	    /* small */
	    xs: (10 / PER_WIDTH).toFixed(2),
	    /* mini */
	    ir: 'background-size',
	    /*image-render */
	    al: 'aspect-fill',
	    /* aspect-fill */
	    at: 'aspect-fit',
	    /*aspect-fit */
	    tt: 'title',
	    bs: 'button-style',
	    bb: 'button-blue',
	    bg: 'button-gray',
	    bn: 'button-naked',
	    bt: 'button-theme',
	    lc: 'border-top-color',
	    /* line-color */
	    ls: 'border-top-style',
	    /* line-style */
	    tfs: 'font-size',
	    /* text-font-size */
	    rds: 'border-radius',
	    /* radius */
	    stock: 'solid',
	    dot: 'dotted'
	  };

	  return STR_MAP;
	}

	function isArray(o) {
	  return Object.prototype.toString.call(o) === '[object Array]';
	}

	function isObject(o) {
	  return Object.prototype.toString.call(o) === '[object Object]';
	}

	function getBackgroundSize(s, style) {
	  if (s === 'aspect-fill') {
	    style['background-size'] = 'cover';
	    style['background-position'] = 'center';
	  } else if (s === 'aspect-fit') {
	    style['background-size'] = 'contain';
	    style['background-position'] = 'center';
	  } else if (s === 'fill') {
	    style['background-size'] = '100% 100%';
	  }
	}
	/**
	 * 将原始数据转换成人类认识的key/value
	 * @param data
	 * @returns {*}
	 */
	function parseData(data) {
	  var newValue = void 0;
	  // let SM = getStrMap();

	  if (isObject(data)) {
	    newValue = {};
	    for (var k in data) {
	      var ok = STR_MAP[k] || k;
	      var ov = data[k];
	      newValue[ok] = parseData(ov);
	    }
	  } else if (isArray(data)) {
	    newValue = [];
	    data.forEach(function (item) {
	      newValue.push(parseData(item));
	    });
	  } else {
	    newValue = STR_MAP[data] || data;
	  }

	  return newValue;
	}

	/**
	 * 将转换后的数据解析成html
	 * @param data
	 * @param parent
	 * @returns {string}
	 */
	function translateData(data, parent) {
	  var tpl = '';
	  var style = {};
	  var styleStr = '';
	  var action = '';

	  if (parent) {
	    // 如果父元素是flex布局, 子元素需要设置flex样式
	    if (parent.display === 'flex') {
	      style.flex = '0 0 auto';
	    }
	    // 如果父元素是fix布局, 子元素需要设置position样式
	    else if (parent.display === 'fix') {
	        style.position = 'absolute';
	      }
	  }

	  if (!style.position && data.display === 'fix') {
	    style.position = 'relative';
	  }

	  // 确保字号是数字类型
	  data['font-size'] && (data['font-size'] = Number(data['font-size']));

	  var isLineOne = false; // 是否是单行
	  // 如果有字号跟宽高属性
	  if (data['font-size'] && data['frame']) {
	    // 如果高度是数字
	    if (typeof data.frame[3] === 'number') {
	      // 如果高度除以字号小于2, 则默认认为是单行
	      // 则设置单行的属性
	      if (data.frame[3] / data['font-size'] < 2) {
	        isLineOne = true;
	      }
	    }
	  }

	  // 解析css属性
	  for (var k in data) {
	    if (STYLE_KEY.indexOf(k) > -1) {
	      if (data.class === 'img') {
	        k === 'center' && (k = '100%');
	      }

	      // 需要特殊处理下颜色, 服务端给的是#ff(opacity)ffffff(color)
	      if (k === 'color' || k === 'background-color') {
	        var v = data[k].substring(1);
	        var l = 8 - v.length;
	        var t = '';

	        for (var i = 0; i < l; i++) {
	          t += 'f';
	        }

	        v = t + v;

	        var vs = [];
	        for (var _i = 0; _i < 8; _i += 2) {
	          vs.push(parseInt(v.substring(_i, _i + 2), 16));
	        }

	        data[k] = 'rgba(' + vs[1] + ',' + vs[2] + ',' + vs[3] + ',' + (vs[0] / 255).toFixed(1) + ')';
	      }
	      style[k] = getRealPx(data[k]);
	    }
	  }

	  // 如果有定位跟宽高信息
	  // 设置位置样式与宽高样式
	  if (data.frame) {
	    ['left', 'top', 'width', 'height'].forEach(function (s, index) {
	      if (isLineOne && s === 'height') {
	        if (typeof data.frame[index] === 'number') {
	          style['line-height'] = getRealPx(data.frame[index]);
	        }
	      }
	      style[s] = getRealPx(data.frame[index]);
	    });
	  }

	  if (style.display === 'flex' && style.width && style.height && style.width.indexOf('px') !== -1 && style.height.indexOf('px') !== -1) {
	    if (style['flex-direction'] === 'column') {
	      style['overflow-y'] = 'auto';
	      style['overflow-x'] = 'hidden';
	      style['width'] = parseInt(style['width']) + 5 + 'px';
	    } else {
	      style['overflow-x'] = 'auto';
	      style['overflow-y'] = 'hidden';
	      style['height'] = parseInt(style['height']) + 5 + 'px';
	    }
	  }

	  // 如果是线条
	  // 设置线条样式
	  if (data.vector) {
	    style.left = getRealPx(data.vector[0][0]);
	    style.top = getRealPx(data.vector[0][1]);
	    style.width = getRealPx(data.vector[1][0] - data.vector[0][0]);
	    style.height = '1px';
	    style['border-top-width'] = '1px';
	  }

	  // 如果是box容器
	  if (data.class === 'box') {
	    // 设置默认的flex-direction为column
	    !style['flex-direction'] && (style['flex-direction'] = 'column');
	  }
	  // 如果是img容器
	  else if (data.class === 'img') {
	      // 如果有图片地址, 设置背景图片
	      data.url && (style['background-image'] = 'url(' + data.url + ')');

	      // 设置默认图片剪裁方式为aspect-fill
	      !style['background-size'] && (style['background-size'] = 'aspect-fill');

	      getBackgroundSize(style['background-size'], style);
	    }
	    // 如果是lbl/btn容器
	    else if (data.class === 'lbl' || data.class === 'btn') {
	        // 如果有高度并且没有行高
	        // 则设置行高
	        if (style.height && !style['line-height']) {
	          if (style.height === 'FIT') {
	            style['align-self'] = 'center';
	          } else {
	            style['line-height'] = style.height;
	          }
	        }

	        // 如果宽度为自适应
	        // 则设置文字为居中对齐
	        if (style.width === 'FIT') {
	          style['text-align'] = 'center';
	        }
	      }

	  if (isLineOne || style['height'] && style['line-height']) {
	    style['text-overflow'] = 'ellipsis';
	    style['white-space'] = 'nowrap';
	    style['overflow'] = 'hidden';
	  }

	  // 默认去第一条action
	  if (data.action && data.action.length) {
	    action = data.action[0];
	  }

	  if (action) {
	    style['cursor'] = 'pointer';
	  }

	  if (parent && parent.display === 'flex') {
	    if (style.top) {
	      style['margin-top'] = style.top;
	      delete style.top;
	    }
	    if (style.right) {
	      style['margin-right'] = style.right;
	      delete style.right;
	    }
	    if (style.left) {
	      style['margin-left'] = style.left;
	      delete style.left;
	    }
	    if (style.bottom) {
	      style['margin-bottom'] = style.bottom;
	      delete style.bottom;
	    }
	  }
	  // 将样式转成字符串
	  for (var _k in style) {
	    styleStr += _k + ':' + style[_k] + ';';
	  }

	  // 如果是box容器
	  // 需要处理自容器的样式
	  if (data.class === 'box') {
	    var _t = '';
	    if (data.subviews && data.subviews.length) {
	      data.subviews.forEach(function (item) {
	        _t += translateData(item, data);
	      });
	    }

	    tpl = (0, _$JuicerRoot2.default)(DIV_TPL, {
	      cls: 'temp20014-box',
	      style: styleStr,
	      html: _t,
	      action: action
	    });
	  }
	  // 如果是lbl(label)容器
	  else if (data.class === 'lbl') {

	      tpl = (0, _$JuicerRoot2.default)(SPAN_TPL, {
	        cls: 'temp20014-lbl',
	        style: styleStr,
	        html: data.text,
	        action: action
	      });
	    } else if (data.class === 'img') {
	      tpl = (0, _$JuicerRoot2.default)(DIV_TPL, {
	        cls: 'temp20014-img',
	        style: styleStr,
	        action: action
	      });
	    } else if (data.class === 'line') {
	      tpl = (0, _$JuicerRoot2.default)(DIV_TPL, {
	        cls: 'temp20014-line',
	        style: styleStr,
	        action: action
	      });
	    } else if (data.class === 'btn') {
	      tpl = (0, _$JuicerRoot2.default)(DIV_TPL, {
	        cls: 'temp20014-btn' + (data['button-style'] ? ' ' + data['button-style'] : ''),
	        style: styleStr,
	        html: data.title,
	        action: action
	      });
	    }

	  return tpl;
	}

	function getRealPx(num) {
	  return typeof num === 'number' ? (num * PER_WIDTH).toFixed(0) + 'px' : num;
	}
	module.exports = exports['default'];

/***/ },
/* 58 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	/**
	 * Created by neitherzhu on 2017/1/2.
	 */
	exports.default = function (mb) {
	  return '<a href="' + mb.value + '">' + mb.jvale.NAME + '</a>';
	};

	module.exports = exports['default'];

/***/ },
/* 59 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _template = __webpack_require__(15);

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _getFileOptionData = __webpack_require__(60);

	var _getFileOptionData2 = _interopRequireDefault(_getFileOptionData);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/3/29.
	 */
	var FILE_SUFFIX_CLS_MAP = {
	  PDF: { suffix: 'PDF', cls: 'suffix-red' },
	  AI: { suffix: 'AI', cls: 'suffix-orange' },
	  PAGES: { suffix: 'PGS', cls: 'suffix-orange' },
	  SKETCH: { suffix: 'SKE', cls: 'suffix-orange' },
	  PPTX: { suffix: 'PPT', cls: 'suffix-orange' },
	  PPT: { suffix: 'PPT', cls: 'suffix-orange' },
	  PSD: { suffix: 'PS', cls: 'suffix-blue' },
	  DOC: { suffix: 'DOC', cls: 'suffix-blue' },
	  NUMBERS: { suffix: 'NUM', cls: 'suffix-green' },
	  XLSX: { suffix: 'EXC', cls: 'suffix-green' },
	  MP4: { suffix: 'MP4', cls: 'suffix-green' },
	  TXT: { suffix: 'TXT', cls: 'suffix-gray' },
	  UNKNOWN: { suffix: '', cls: 'suffix-default' },
	  ZIP: { suffix: '', cls: 'suffix-zip' },
	  RAR: { suffix: '', cls: 'suffix-zip' },
	  '7Z': { suffix: '', cls: 'suffix-zip' }
	};

	exports.default = function (mb, msg) {

	  var data = mb.value.fileInfo;
	  var suffixLen = 0;
	  var suffix = '';
	  var moreData = {};

	  moreData.size = _util2.default.getFileSize(data.nodeSize);

	  var s = data.nodeName.split('.');

	  if (s.length <= 1) {
	    Object.assign(moreData, FILE_SUFFIX_CLS_MAP.UNKNOWN);
	  } else {
	    suffix = s.pop();
	    suffixLen = _util2.default.getStrLen(suffix) + 1;
	    Object.assign(moreData, FILE_SUFFIX_CLS_MAP[suffix.toUpperCase()] || FILE_SUFFIX_CLS_MAP.UNKNOWN);
	    suffix = '.' + suffix;
	  }

	  moreData.name = _util2.default.getStrByLen(s.join(''), _constants2.default.FILE_MAX_LEN - suffixLen, 2) + suffix;

	  if (!mb.isFail && mb.value.transferInfo) {
	    data.optionsData = (0, _getFileOptionData2.default)(mb.value.transferInfo);
	    data.optionsData.isSelf = mb.isSelf;
	    data.optionsData.isRead = msg.readflag == 1;
	    data.fileOperation = _template.fileOperation;

	    (mb.value.transferInfo.status == 0 || mb.value.transferInfo.status == 1) && (data.progress = mb.value.transferInfo.progress);
	  }

	  var html = (0, _$JuicerRoot2.default)(_template.fileMsg, Object.assign(moreData, data));
	  return html;
	};

	module.exports = exports['default'];

/***/ },
/* 60 */
/***/ function(module, exports) {

	"use strict";

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	/**
	 * Created by neitherzhu on 2017/3/31.
	 */
	exports.default = function (data) {

	  var result = {};

	  if (!data) return result;

	  // 上传/下载初始化状态
	  if (data.status == 0) {
	    // 上传中
	    if (data.type == 0) {
	      // 显示取消上传
	      result.status = 1;
	    } else {
	      // 显示空
	      result.status = -1;
	    }
	  }
	  // 上传/下载中
	  else if (data.status == 1) {
	      // 上传中
	      if (data.type == 0) {
	        // 显示取消上传
	        result.status = 1;
	      }
	      // 下载中
	      else if (data.type == 1) {
	          // 显示预览 取消下载
	          result.status = 2;
	        }
	    }
	    // 上传/下载 错误
	    else if (data.status == 2) {
	        // 上传中
	        if (data.type == 0) {
	          // 如果有本地路径
	          if (data.filePath) {
	            // 显示打开文件夹
	            result.status = 5;
	            result.path = data.filePath;
	          }
	          // 如果没有本地路径
	          else {
	              // 不显示
	              result.status = -1;
	            }
	        }
	        // 下载中
	        else if (data.type == 1) {
	            // 显示预览 重新下载
	            result.status = 4;
	          }
	      }
	      // 上传/下载 取消
	      else if (data.status == 3) {
	          // 如果是上传
	          if (data.type == 0) {
	            // 如果有本地路径
	            if (data.filePath) {
	              // 显示打开文件夹
	              result.status = 5;
	              result.path = data.filePath;
	            }
	            // 如果没有本地路径
	            else {
	                // 显示空
	                result.status = -1;
	              }
	          }
	          // 如果是下载
	          else {
	              // 显示预览 下载文件
	              result.status = 3;
	            }
	        }
	        // 上传/下载 成功 或者 未知状态
	        else if (data.status == 4 || data.status == 5) {
	            // 如果有本地路径
	            if (data.filePath) {
	              // 显示预览 打开文件夹
	              result.status = 0;
	              result.path = data.filePath;
	            } else {
	              // 显示预览 下载文件
	              result.status = 3;
	            }
	          }

	  return result;
	};

	module.exports = exports["default"];

/***/ },
/* 61 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (extra, callback) {

	  _sdk2.default.getDynamicMsg(extra).then(function (data) {

	    if (!data) return;

	    if (typeof data === 'string') {
	      data = JSON.parse(data);
	    }

	    if (callback && !callback(data)) return;

	    var html = (0, _temp2.default)(data);

	    if (!document.getElementById(extra.id)) return;

	    document.getElementById(extra.id).querySelector('.msg-body-html').innerHTML = html;

	    if (_window2.default.sharedWin && _window2.default.sharedWin.isBottom) {
	      Util.scrollToBottom && Util.scrollToBottom(_window2.default.sharedWin.container);
	    }
	  });
	};

	var _$BaseRoot = __webpack_require__(3);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _temp = __webpack_require__(57);

	var _temp2 = _interopRequireDefault(_temp);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/3/15.
	 */
	var Util = _$BaseRoot.Base.Util;
	;
	module.exports = exports['default'];

/***/ },
/* 62 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var Util = _$BaseRoot.Base.Util; /**
	                                  * Created by neitherzhu on 2017/4/11.
	                                  */

	exports.default = function (msg) {
	  var fromNick = Util.getUid(msg.fromid);
	  var loginUserNick = Util.getUid(_window2.default.sharedWin.loginID);
	  var result = { html: '', loading: false };
	  var activeCid = Util.getUid(msg.cid);
	  var isSelf = loginUserNick === fromNick;
	  var isSingle = _window2.default.sharedWin.conversationID.type === _constants2.default.TYPE.SINGLE;

	  if (!msg.msgbody) return;

	  if (typeof msg.msgbody === 'string') {
	    try {
	      msg.msgbody = JSON.parse(msg.msgbody);
	    } catch (e) {
	      result = false;
	    }
	  }

	  if (!result) return;

	  //if (Object.prototype.toString.call(msg.msgbody) !== '[object Array]') return;

	  // 如果是单聊
	  // 如果当前聊天对象的主账号跟登陆账号的主账号不一样
	  // 则需要考虑子账号查看同个主账号下其他子账号跟买家聊天的场景
	  // 这时候需要把其他子账号发的消息也放到自己发送的这一方
	  if (isSingle) {
	    if (activeCid.split(':')[0] !== loginUserNick.split(':')[0]) {
	      isSelf = loginUserNick.split(':')[0] === fromNick.split(':')[0];
	    }
	    // 是否需要显示 买家-->子账号 这种形式的nick
	    result.isSubNick = !isSelf && Util.getUid(msg.toid) != loginUserNick;
	  }

	  result.isMe = loginUserNick === fromNick;
	  result.self = isSelf;
	  result.msgid = msg.msgid;
	  result.from = msg.fromid;
	  result.msgtime = msg.msgtime;
	  result.to = msg.toid;
	  result.cid = msg.cid;
	  result.type = msg.msgtype;
	  result.typeList = [];
	  result.subNick = fromNick.replace(':', '_');
	  result.avatar = msg.fromid.portrait;
	  result.isFail = msg.msgstatus == 2;
	  msg.svrtime && (result.svrtime = msg.svrtime);
	  result.readflag = msg.readflag;
	  result.msgstatus = msg.msgstatus;
	  result.numberid = msg.numberid;
	  result.msgbody = msg.msgbody;

	  result.readFlagText = _constants2.default.I18N[_constants2.default.LANGUAGE][result.readflag ? 'AT_MSG_READ' : 'AT_MSG_UNREAD'];

	  return result;
	};

	module.exports = exports['default'];

/***/ },
/* 63 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	function _defineProperty(obj, key, value) {
	  if (key in obj) {
	    Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
	  } else {
	    obj[key] = value;
	  }return obj;
	} /**
	   * taobaoCard 个人名片
	   *
	   * @author:   罗嗣(｡･∀･)ﾉﾞ <fangbo.fb@alibaba-inc.com>
	   * @create:   2017-09-18  下午4:19
	   */

	var mockJson = _defineProperty({
	  bcNick: 'ddd',
	  bcHeadUrl: 'https://private-alipayobjects.alipay.com/alipay-rmsdeploy-image/skylark/png/da9775ed-fcb9-4e88-934c-53560999de4e.png'
	}, 'bcNick', 'dddssss');

	exports.default = function (mb, msg) {
	  var json = {};
	  try {
	    json = JSON.parse(mb.value);
	    return (0, _$JuicerRoot2.default)(_template2.default.taobaoCard, Object.assign(json));
	  } catch (err) {
	    return _constants2.default.I18N[_constants2.default.LANGUAGE].TAOBAO_NOT_SUPPORT_MSG;
	  }
	};

	module.exports = exports['default'];

/***/ },
/* 64 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = function (mb, msg) {
	  var json = {};
	  try {
	    json = JSON.parse(mb.value);
	    var attr = JSON.parse(json.attr || "{}");
	    json.attribute = attr;
	    json.shareType = Number(json.shareType);

	    // 宝贝类型
	    if (json.shareType === 0) {
	      json.attribute.tags = json.attribute.tags || [];
	      if (json.attr === '') {
	        json.subType = 0;
	      } else {
	        json.subType = 1;
	      }
	    }
	    // 店铺类型
	    else if (json.shareType === 1) {
	        // 普通店铺类型
	        if (json.attr === '') {
	          json.subType = 0;
	        }
	        // 活动店铺
	        else if (attr.actUrl && attr.actPic) {
	            json.subType = 1;
	          }
	          // 宝贝店铺
	          else if (attr.actUrl === '' && attr.actPic === '' || attr.items && attr.items.length > 0) {
	              json.attribute.items = json.attribute.items || [];
	              json.subType = 2;
	            }
	      }

	    return (0, _$JuicerRoot2.default)(_template2.default.taobaoShare, json);
	  } catch (err) {
	    return _constants2.default.I18N[_constants2.default.LANGUAGE].TAOBAO_NOT_SUPPORT_MSG;
	  }
	}; /**
	    * taobaoShare 淘宝分享
	    *
	    * @author:   罗嗣(｡･∀･)ﾉﾞ <fangbo.fb@alibaba-inc.com>
	    * @create:   2017-09-18  下午4:18
	    */

	module.exports = exports['default'];

/***/ },
/* 65 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var mockJson = {
	  title: 'ddddd',
	  content: 'xxxxx',
	  actionUrl: 'http://www.baidu.com',
	  picUrl: 'https://private-alipayobjects.alipay.com/alipay-rmsdeploy-image/skylark/png/da9775ed-fcb9-4e88-934c-53560999de4e.png'
	}; /**
	    * taobaoFeed 淘宝大图消息
	    *
	    * @author:   罗嗣(｡･∀･)ﾉﾞ <fangbo.fb@alibaba-inc.com>
	    * @create:   2017-09-18  下午4:18
	    */

	exports.default = function (mb, msg) {
	  var json = {};
	  try {
	    json = JSON.parse(mb.value);
	    return (0, _$JuicerRoot2.default)(_template2.default.taobaoFeed, Object.assign(json));
	  } catch (err) {
	    return _constants2.default.I18N[_constants2.default.LANGUAGE].TAOBAO_NOT_SUPPORT_MSG;
	  }
	};

	module.exports = exports['default'];

/***/ },
/* 66 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _shake = __webpack_require__(67);

	var _shake2 = _interopRequireDefault(_shake);

	var _file = __webpack_require__(68);

	var _file2 = _interopRequireDefault(_file);

	var _chat = __webpack_require__(69);

	var _chat2 = _interopRequireDefault(_chat);

	var _video = __webpack_require__(70);

	var _video2 = _interopRequireDefault(_video);

	var _remoteAssistance = __webpack_require__(71);

	var _remoteAssistance2 = _interopRequireDefault(_remoteAssistance);

	var _appSys = __webpack_require__(72);

	var _appSys2 = _interopRequireDefault(_appSys);

	var _msgRecall = __webpack_require__(73);

	var _msgRecall2 = _interopRequireDefault(_msgRecall);

	var _exitTribe = __webpack_require__(74);

	var _exitTribe2 = _interopRequireDefault(_exitTribe);

	var _kickoutTribe = __webpack_require__(75);

	var _kickoutTribe2 = _interopRequireDefault(_kickoutTribe);

	var _joinTribe = __webpack_require__(76);

	var _joinTribe2 = _interopRequireDefault(_joinTribe);

	var _roleChange = __webpack_require__(77);

	var _roleChange2 = _interopRequireDefault(_roleChange);

	var _exitDiscussion = __webpack_require__(78);

	var _exitDiscussion2 = _interopRequireDefault(_exitDiscussion);

	var _joinDiscussion = __webpack_require__(79);

	var _joinDiscussion2 = _interopRequireDefault(_joinDiscussion);

	var _displayNameChange = __webpack_require__(80);

	var _displayNameChange2 = _interopRequireDefault(_displayNameChange);

	var _audio2text = __webpack_require__(81);

	var _audio2text2 = _interopRequireDefault(_audio2text);

	var _defaultSystemMsg = __webpack_require__(82);

	var _defaultSystemMsg2 = _interopRequireDefault(_defaultSystemMsg);

	var _multiJoin = __webpack_require__(83);

	var _multiJoin2 = _interopRequireDefault(_multiJoin);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = {
	  ShakeFormat: _shake2.default,
	  FileFormat: _file2.default,
	  ChatFormat: _chat2.default,
	  VideoFormat: _video2.default,
	  RemoteAssistanceFormat: _remoteAssistance2.default,
	  AppSysFormat: _appSys2.default,
	  MsgRecall: _msgRecall2.default,
	  ExitTribeFormat: _exitTribe2.default,
	  KickOutTribeFormat: _kickoutTribe2.default,
	  JoinTribeFormat: _joinTribe2.default,
	  RoleChangeFormat: _roleChange2.default,
	  ExitDiscussionFormat: _exitDiscussion2.default,
	  JoinDiscussionFormat: _joinDiscussion2.default,
	  DisplayNameChange: _displayNameChange2.default,
	  AudioToTextFormat: _audio2text2.default,
	  DefaultSystemMsg: _defaultSystemMsg2.default,
	  MultiJoin: _multiJoin2.default
	}; /**
	    * Created by neitherzhu on 2016/12/6.
	    * 单聊系统消息的解析Format
	    */

	module.exports = exports['default'];

/***/ },
/* 67 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var Util = _$BaseRoot.Base.Util; /**
	                                  * Created by neitherzhu on 2016/12/6.
	                                  * 震屏
	                                  */

	exports.default = function (msg) {
	  var mb = void 0,
	      t = '',
	      user = void 0;
	  try {
	    mb = JSON.parse(msg.msgbody);
	  } catch (e) {
	    mb = false;
	  }

	  if (!mb) return false;

	  var I18N = _constants2.default.I18N;
	  var LANGUAGE = _constants2.default.LANGUAGE;
	  var isSelf = Util.getUid(msg.cid) != Util.getUid(msg.fromid);

	  if (mb.type == 0) {
	    user = msg.fromid.nick;
	    t = isSelf ? I18N[LANGUAGE].SENT_SHAKE : I18N[LANGUAGE].RECEIVED_SHAKE;
	    t = (0, _$JuicerRoot2.default)(t, { user: user });
	  } else if (mb.type == 1) {
	    t = I18N[LANGUAGE].SHAKE_FREQUENCY_LIMIT;
	  } else if (mb.type == 2) {
	    t = I18N[LANGUAGE].SHAKE_WHEN_DISABLED;
	  } else if (mb.type == 3) {
	    t = I18N[LANGUAGE].SHAKE_WHEN_OFFLINE;
	  } else if (mb.type == 4) {
	    t = I18N[LANGUAGE].SHAKE_WHEN_INVISIBLE;
	  } else if (mb.type == 5) {
	    t = I18N[LANGUAGE].SHAKE_WHEN_DO_NOT_DISTURB;
	  }

	  msg.html = t;

	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 68 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/6.
	 * 文件消息
	 */
	exports.default = function (msg) {
	  var mb = void 0,
	      t = '';
	  try {
	    mb = JSON.parse(msg.msgbody);
	  } catch (e) {
	    mb = false;
	  }

	  if (!mb) return false;

	  var I18N = _constants2.default.I18N;
	  var LANGUAGE = _constants2.default.LANGUAGE;

	  if (mb.sysType == 0) {
	    t = (0, _$JuicerRoot2.default)(I18N[LANGUAGE].FILE_DISABLED, { filename: mb.filename });
	  } else {
	    return false;
	  }

	  msg.html = t;

	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 69 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/6.
	 * 语音系统消息
	 */
	exports.default = function (msg) {
	  var mb = void 0,
	      t = '';
	  try {
	    mb = JSON.parse(msg.msgbody);
	  } catch (e) {
	    mb = false;
	  }

	  if (!mb) return false;

	  var I18N = _constants2.default.I18N;
	  var LANGUAGE = _constants2.default.LANGUAGE;
	  var user = msg.cid.display;

	  switch (mb.type) {
	    case 0:
	      t = I18N[LANGUAGE].START_CHAT;
	      break;
	    case 1:
	      t = I18N[LANGUAGE].RECEIVED_CHAT;
	      break;
	    case 2:
	      t = I18N[LANGUAGE].STOP_CHAT;
	      break;
	    case 3:
	      t = I18N[LANGUAGE].STOPPED_CHAT;
	      break;
	    case 4:
	      t = I18N[LANGUAGE].REFUSE_CHAT;
	      break;
	    case 5:
	      t = I18N[LANGUAGE].REFUSED_CHAT;
	      break;
	    case 6:
	      t = I18N[LANGUAGE].STOP_CHAT_OR_VIDEO_FIRST_ERROR;
	      break;
	    case 7:
	      t = I18N[LANGUAGE].CHATTING_OR_VIDEO_ERROR;
	      break;
	    case 8:
	      t = I18N[LANGUAGE].STOP_CHAT_FIRST_ERROR;
	      break;
	    case 9:
	      t = I18N[LANGUAGE].CHATTING_ERROR;
	      break;
	    case 10:
	      t = I18N[LANGUAGE].CHAT_CONNECT_ERROR;
	      break;
	    case 11:
	      t = I18N[LANGUAGE].CHAT_NET_ERROR;
	      break;
	    case 12:
	      t = I18N[LANGUAGE].CHAT_NO_ANSWER_ERROR;
	      break;
	  }

	  msg.html = (0, _$JuicerRoot2.default)(t, { user: user });

	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 70 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/7.
	 * 视频聊天
	 */
	exports.default = function (msg) {
	  var mb = void 0,
	      t = '';
	  try {
	    mb = JSON.parse(msg.msgbody);
	  } catch (e) {
	    mb = false;
	  }

	  if (!mb) return false;

	  var I18N = _constants2.default.I18N;
	  var LANGUAGE = _constants2.default.LANGUAGE;
	  var user = msg.cid.display;

	  switch (mb.type) {
	    case 0:
	      t = I18N[LANGUAGE].START_VIDEO;
	      break;
	    case 1:
	      t = I18N[LANGUAGE].RECEIVED_VIDEO;
	      break;
	    case 2:
	      t = I18N[LANGUAGE].STOP_VIDEO;
	      break;
	    case 3:
	      t = I18N[LANGUAGE].STOPPED_VIDEO;
	      break;
	    case 4:
	      t = I18N[LANGUAGE].REFUSE_VIDEO;
	      break;
	    case 5:
	      t = I18N[LANGUAGE].REFUSED_VIDEO;
	      break;
	    case 6:
	      t = I18N[LANGUAGE].STOP_CHAT_OR_VIDEO_FIRST_ERROR;
	      break;
	    case 7:
	      t = I18N[LANGUAGE].CHATTING_OR_VIDEO_ERROR;
	      break;
	    case 8:
	      t = I18N[LANGUAGE].STOP_CHAT_FIRST_ERROR;
	      break;
	    case 9:
	      t = I18N[LANGUAGE].VIDEOING_ERROR;
	      break;
	    case 10:
	      t = I18N[LANGUAGE].CHAT_CONNECT_ERROR;
	      break;
	    case 11:
	      t = I18N[LANGUAGE].CHAT_NET_ERROR;
	      break;
	    case 12:
	      t = I18N[LANGUAGE].CHAT_NO_ANSWER_ERROR;
	      break;
	  }

	  msg.html = (0, _$JuicerRoot2.default)(t, { user: user });

	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 71 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/7.
	 */
	exports.default = function (msg) {
	  var mb = void 0,
	      t = '';
	  try {
	    mb = JSON.parse(msg.msgbody);
	  } catch (e) {
	    mb = false;
	  }

	  if (!mb) return false;

	  var I18N = _constants2.default.I18N;
	  var LANGUAGE = _constants2.default.LANGUAGE;
	  var user = msg.cid.display;

	  switch (mb.type) {
	    case 0:
	      t = I18N[LANGUAGE].ASK_FOR_REMOTE_ASSISTANCE;
	      break;
	    case 1:
	      t = I18N[LANGUAGE].ASK_FOR_CONTROL;
	      break;
	    case 2:
	      t = I18N[LANGUAGE].ASK_TO_REMOTE_ASSISTANCE;
	      break;
	    case 3:
	      t = I18N[LANGUAGE].ASK_TO_CONTROL;
	      break;
	    case 4:
	      t = I18N[LANGUAGE].AGREED_TO_REMOTE_ASSISTANCE;
	      break;
	    case 5:
	      t = I18N[LANGUAGE].REFUSED_TO_REMOTE_ASSISTANCE;
	      break;
	    case 6:
	      t = I18N[LANGUAGE].STOPPED_TO_REMOTE_ASSISTANCE;
	      break;
	    case 7:
	      t = I18N[LANGUAGE].AGREED_TO_CONTROL;
	      break;
	    case 8:
	      t = I18N[LANGUAGE].AGREE_TO_REMOTE_ASSISTANCE;
	      break;
	    case 9:
	      t = I18N[LANGUAGE].REFUSE_TO_REMOTE_ASSISTANCE;
	      break;
	    case 10:
	      t = I18N[LANGUAGE].STOP_TO_REMOTE_ASSISTANCE;
	      break;
	    case 11:
	      t = I18N[LANGUAGE].AGREE_TO_CONTROL;
	      break;
	    case 12:
	      t = I18N[LANGUAGE].NOT_SUPPORT_FOR_REMOTE_ASSISTANCE;
	      break;
	    case 13:
	      t = I18N[LANGUAGE].NOT_SUPPORT_TO_REMOTE_ASSISTANCE;
	      break;
	    case 14:
	      t = I18N[LANGUAGE].STOP_REMOTE_ASSISTANCE_FIRST;
	      break;
	    case 15:
	      t = I18N[LANGUAGE].REMOTE_ASSISTING;
	      break;
	    case 16:
	      t = I18N[LANGUAGE].REMOTE_ASSISTANCE_NET_ERROR;
	      break;
	    case 17:
	      t = I18N[LANGUAGE].CHAT_NO_ANSWER_ERROR;
	      break;
	  }

	  msg.html = (0, _$JuicerRoot2.default)(t, { user: user });

	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 72 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	/**
	 * Created by neitherzhu on 2016/12/7.
	 * 应用/APP 系统安全提示
	 */
	exports.default = function (msg) {
	  var mb = void 0,
	      t = '';
	  try {
	    mb = JSON.parse(msg.msgbody);
	  } catch (e) {
	    mb = false;
	  }

	  if (!mb) return false;

	  var value = mb.value;

	  try {
	    value = JSON.parse(value);
	  } catch (e) {
	    value = false;
	  }

	  if (!value) return false;

	  value.length && value.forEach(function (msg) {
	    t += msg.value;
	  });

	  msg.html = t;

	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 73 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _$BaseRoot = __webpack_require__(3);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/2/16.
	 */
	var Util = _$BaseRoot.Base.Util;

	exports.default = function (msg) {
	  var I18N = _constants2.default.I18N;
	  var LANGUAGE = _constants2.default.LANGUAGE;
	  var fromNick = Util.getUid(msg.fromid);
	  var loginUserNick = Util.getUid(_window2.default.sharedWin.loginID);
	  var tpl = '';

	  if (fromNick === loginUserNick) {
	    tpl = I18N[LANGUAGE].RECALL_MSG;
	  } else {
	    tpl = (0, _$JuicerRoot2.default)(I18N[LANGUAGE].MSG_RECALLED, { user: msg.fromid.display });
	  }

	  msg.html = tpl;

	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 74 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _$BaseRoot = __webpack_require__(3);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/6.
	 * 退出群
	 */
	var Util = _$BaseRoot.Base.Util;

	exports.default = function (msg) {
	  var mb = {};
	  try {
	    mb = JSON.parse(msg.msgbody);
	  } catch (e) {
	    mb = false;
	  }

	  if (!mb || !mb.stUID) return false;

	  var I18N = _constants2.default.I18N;
	  var LANGUAGE = _constants2.default.LANGUAGE;
	  var targetUser = Util.getUid(mb.stUID);
	  var isSelf = targetUser && targetUser === Util.getUid(_window2.default.sharedWin.loginID);
	  var user = mb.stUID.display || mb.stUID.strUserID;

	  msg.html = isSelf ? (0, _$JuicerRoot2.default)(I18N[LANGUAGE].SELF_EXIT_TRIBE, { display: mb.stTribeID.display || mb.stTribeID.tribeid }) : (0, _$JuicerRoot2.default)(I18N[LANGUAGE].EXIT_TRIBE, { user: user });

	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 75 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _$BaseRoot = __webpack_require__(3);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/6.
	 * 被踢出群
	 */
	var Util = _$BaseRoot.Base.Util;

	exports.default = function (msg) {
	  var mb = {};
	  try {
	    mb = JSON.parse(msg.msgbody);
	  } catch (e) {
	    mb = false;
	  }

	  if (!mb || !mb.stKickedUID) return false;

	  var I18N = _constants2.default.I18N;
	  var LANGUAGE = _constants2.default.LANGUAGE;
	  var triggerUser = Util.getUid(msg.fromid);
	  var isSelfTrigger = triggerUser && triggerUser === Util.getUid(_window2.default.sharedWin.loginID);
	  var user = mb.stKickedUID.display || mb.stKickedUID.strUserID;

	  if (isSelfTrigger) {
	    msg.html = (0, _$JuicerRoot2.default)(I18N[LANGUAGE].SELF_KICK_OUT_TRIBE, { user: user });
	  } else {
	    var manager = msg.fromid.display ? msg.fromid.display : msg.fromid.nick;
	    var targetUser = Util.getUid(mb.stKickedUID);
	    var isSelfTarget = targetUser && targetUser === Util.getUid(_window2.default.sharedWin.loginID);

	    if (!isSelfTarget) {
	      msg.html = (0, _$JuicerRoot2.default)(I18N[LANGUAGE].KICK_OUT_TRIBE, { manager: manager, user: user });
	    } else {
	      msg.html = (0, _$JuicerRoot2.default)(I18N[LANGUAGE].SELF_BE_KICKED_OUT_TRIBE, { display: msg.cid.display || msg.cid.tribeid });
	    }
	  }

	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 76 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _$BaseRoot = __webpack_require__(3);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/6.
	 * 加入群
	 */
	var Util = _$BaseRoot.Base.Util;

	exports.default = function (msg) {
	  var mb = {};
	  try {
	    mb = JSON.parse(msg.msgbody);
	  } catch (e) {
	    mb = false;
	  }

	  if (!mb || !mb.stUID) return false;

	  var I18N = _constants2.default.I18N;
	  var LANGUAGE = _constants2.default.LANGUAGE;
	  var targetUser = Util.getUid(mb.stUID);
	  var isSelf = targetUser && targetUser === Util.getUid(_window2.default.sharedWin.loginID);

	  if (!isSelf) {
	    var user = mb.stUID.display || mb.stUID.strUserID;

	    msg.html = (0, _$JuicerRoot2.default)(I18N[LANGUAGE].JOIN_TRIBE, { user: user });
	  } else {
	    msg.html = I18N[LANGUAGE].SELF_JOIN_TRIBE;
	  }

	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 77 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _$BaseRoot = __webpack_require__(3);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/6.
	 * 群成员角色变更
	 */
	var Util = _$BaseRoot.Base.Util;

	exports.default = function (msg) {
	  var mb = {},
	      t = '';
	  try {
	    mb = JSON.parse(msg.msgbody);
	  } catch (e) {
	    mb = false;
	  }

	  if (!mb || !mb.stUID) return false;

	  var I18N = _constants2.default.I18N;
	  var LANGUAGE = _constants2.default.LANGUAGE;
	  var triggerUser = Util.getUid(msg.fromid);
	  var isSelfTrigger = triggerUser && triggerUser === Util.getUid(_window2.default.sharedWin.loginID);

	  var manager = msg.fromid.display ? msg.fromid.display : msg.fromid.nick;
	  var user = mb.stKickedUID && mb.stKickedUID.display || mb.stUID && mb.stUID.strUserID || mb.stUID && mb.stUID.display;

	  if (mb.emLevel === 3) {
	    if (isSelfTrigger) {
	      t = I18N[LANGUAGE].SELF_REMOVE_MANAGER;
	    } else {
	      var targetUser = Util.getUid(mb.stKickedUID || mb.stUID);
	      var isSelfTarget = targetUser && targetUser == Util.getUid(_window2.default.sharedWin.loginID);

	      if (isSelfTarget) {
	        t = I18N[LANGUAGE].SELF_BE_REMOVED_MANAGER;
	      } else {
	        t = I18N[LANGUAGE].REMOVE_MANAGER;
	      }
	    }
	  } else if (mb.emLevel === 2) {
	    if (isSelfTrigger) {
	      t = I18N[LANGUAGE].SELF_SET_MANAGER;
	    } else {
	      var _targetUser = Util.getUid(mb.stKickedUID);
	      var _isSelfTarget = _targetUser && _targetUser == Util.getUid(_window2.default.sharedWin.loginID);

	      if (_isSelfTarget) {
	        t = I18N[LANGUAGE].SELF_BE_SET_MANAGER;
	      } else {
	        t = I18N[LANGUAGE].SET_MANAGER;
	      }
	    }
	  } else {
	    return false;
	  }

	  msg.html = (0, _$JuicerRoot2.default)(t, { manager: manager, user: user });
	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 78 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _$BaseRoot = __webpack_require__(3);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/1/24.
	 */
	var Util = _$BaseRoot.Base.Util;

	exports.default = function (msg) {
	  var mb = {};
	  try {
	    mb = JSON.parse(msg.msgbody);
	  } catch (e) {
	    mb = false;
	  }

	  if (!mb || !mb.stUID) return false;

	  var I18N = _constants2.default.I18N;
	  var LANGUAGE = _constants2.default.LANGUAGE;
	  var targetUser = Util.getUid(mb.stUID);
	  var isSelf = targetUser && targetUser === Util.getUid(_window2.default.sharedWin.loginID);
	  var user = mb.stUID.display || mb.stUID.strUserID;

	  msg.html = isSelf ? (0, _$JuicerRoot2.default)(I18N[LANGUAGE].SELF_EXIT_DISCUSSION, { display: mb.stTribeID.display || mb.stTribeID.tribeid }) : (0, _$JuicerRoot2.default)(I18N[LANGUAGE].EXIT_DISCUSSION, { user: user });

	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 79 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _$BaseRoot = __webpack_require__(3);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/1/24.
	 */
	var Util = _$BaseRoot.Base.Util;

	exports.default = function (msg) {
	  var mb = {};
	  try {
	    mb = JSON.parse(msg.msgbody);
	  } catch (e) {
	    mb = false;
	  }

	  if (!mb || !mb.stUID) return false;

	  var I18N = _constants2.default.I18N;
	  var LANGUAGE = _constants2.default.LANGUAGE;
	  var targetUser = Util.getUid(mb.stUID);
	  var isSelf = targetUser && targetUser === Util.getUid(_window2.default.sharedWin.loginID);

	  if (!isSelf) {
	    var user = mb.stUID.display || mb.stUID.strUserID;

	    msg.html = (0, _$JuicerRoot2.default)(I18N[LANGUAGE].JOIN_DISCUSSION, { user: user });
	  } else {
	    msg.html = I18N[LANGUAGE].SELF_JOIN_DISCUSSION;
	  }

	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 80 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/2/6.
	 */
	var Util = _$BaseRoot.Base.Util;

	exports.default = function (msg) {
	  var mb = {};
	  try {
	    mb = JSON.parse(msg.msgbody);
	  } catch (e) {
	    mb = false;
	  }

	  if (!mb || !mb.items) return false;

	  Util.setCidType(msg.cid);

	  var I18N = _constants2.default.I18N;
	  var LANGUAGE = _constants2.default.LANGUAGE;
	  var isTribe = msg.cid.type === _constants2.default.TYPE.TRIBE;
	  var triggerUser = Util.getUid(msg.fromid);
	  var isSelf = triggerUser && triggerUser === Util.getUid(_window2.default.sharedWin.loginID);
	  var NAME = mb.items.NAME;
	  var html = '';

	  if (isTribe) {
	    html = (0, _$JuicerRoot2.default)(isSelf ? I18N[LANGUAGE].SELF_TRIBE_DISPLAY_NAME_CHANGE : I18N[LANGUAGE].TRIBE_DISPLAY_NAME_CHANGE, {
	      user: msg.fromid.display,
	      newDisplay: NAME
	    });
	  } else {
	    html = (0, _$JuicerRoot2.default)(isSelf ? I18N[LANGUAGE].SELF_DISCUSSION_DISPLAY_NAME_CHANGE : I18N[LANGUAGE].DISCUSSION_DISPLAY_NAME_CHANGE, {
	      user: msg.fromid.display,
	      newDisplay: NAME
	    });
	  }

	  msg.html = html;

	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 81 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = function (msg) {
	  if (!msg.audioText) {
	    msg.html = _constants2.default.I18N[_constants2.default.LANGUAGE].AUDIO_TO_TEXT_OLD_TIP;
	  } else {
	    msg.html = _constants2.default.I18N[_constants2.default.LANGUAGE].AUDIO_TO_TEXT_TIP;
	  }
	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 82 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (msg) {
	  var html = '';
	  if (msg && msg.msgbody) {
	    if (typeof msg.msgbody === 'string') {
	      try {
	        msg.msgbody = JSON.parse(msg.msgbody);
	        if (msg.msgbody.length && msg.msgbody[0]) {
	          var msgbody = msg.msgbody[0];

	          // 手淘群消息
	          if (msgbody.type === -3) {
	            html = JSON.parse(msgbody.value).content;
	          } else {
	            html = msgbody.value;
	          }
	        }
	      } catch (e) {}
	    }
	  }
	  msg.html = html;
	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 83 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/4/17.
	 */
	var Util = _$BaseRoot.Base.Util;

	exports.default = function (msg) {
	  var mb = {};
	  try {
	    mb = JSON.parse(msg.msgbody);
	  } catch (e) {
	    mb = false;
	  }

	  if (!mb || !mb.stUIDs) return false;

	  Util.setCidType(msg.cid);

	  var I18N = _constants2.default.I18N;
	  var LANGUAGE = _constants2.default.LANGUAGE;
	  var isTribe = msg.cid.type === _constants2.default.TYPE.TRIBE;
	  var triggerUser = Util.getUid(msg.fromid);
	  var isSelf = triggerUser && triggerUser === Util.getUid(_window2.default.sharedWin.loginID);
	  var inviter = isSelf ? _constants2.default.I18N[_constants2.default.LANGUAGE].YOU : msg.fromid.display || msg.fromid.nick;
	  var users = '';
	  var html = '';
	  var suffix = '';

	  // 超过20个人时, 只显示20个人的名字加...
	  if (mb.stUIDs.length > 20) {
	    suffix = '...';
	    mb.stUIDs = mb.stUIDs.splice(0, 20);
	  }

	  mb.stUIDs.forEach(function (user) {
	    users += (user.display || user.nick) + ',';
	  });

	  users = users.substring(0, users.length - 1);

	  users += suffix;

	  if (isTribe) {
	    html = (0, _$JuicerRoot2.default)(I18N[LANGUAGE].INVITE_IN_TRIBE, { inviter: inviter, users: users });
	  } else {
	    html = (0, _$JuicerRoot2.default)(I18N[LANGUAGE].INVITE_IN_DISCUSSION, { inviter: inviter, users: users });
	  }

	  msg.html = html;

	  return msg;
	};

	module.exports = exports['default'];

/***/ },
/* 84 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _start = __webpack_require__(85);

	var _start2 = _interopRequireDefault(_start);

	var _getAtMsgReadState = __webpack_require__(86);

	var _getAtMsgReadState2 = _interopRequireDefault(_getAtMsgReadState);

	var _setAtMsgReadState = __webpack_require__(88);

	var _setAtMsgReadState2 = _interopRequireDefault(_setAtMsgReadState);

	var _updateATMsgReadCountStatus = __webpack_require__(89);

	var _updateATMsgReadCountStatus2 = _interopRequireDefault(_updateATMsgReadCountStatus);

	var _bindEvents = __webpack_require__(90);

	var _bindEvents2 = _interopRequireDefault(_bindEvents);

	var _cacheEvent = __webpack_require__(97);

	var _cacheEvent2 = _interopRequireDefault(_cacheEvent);

	var _getMsgReadStatus = __webpack_require__(98);

	var _getMsgReadStatus2 = _interopRequireDefault(_getMsgReadStatus);

	var _setMsgReadStatus = __webpack_require__(99);

	var _setMsgReadStatus2 = _interopRequireDefault(_setMsgReadStatus);

	var _updateMsgReadStatus = __webpack_require__(100);

	var _updateMsgReadStatus2 = _interopRequireDefault(_updateMsgReadStatus);

	var _msgReadStatus = __webpack_require__(101);

	var _msgReadStatus2 = _interopRequireDefault(_msgReadStatus);

	var _sendMsgStatusChange = __webpack_require__(102);

	var _sendMsgStatusChange2 = _interopRequireDefault(_sendMsgStatusChange);

	var _getAudioShowTextSetting = __webpack_require__(103);

	var _getAudioShowTextSetting2 = _interopRequireDefault(_getAudioShowTextSetting);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/2/20.
	 */
	exports.default = {
	  start: _start2.default,
	  getAtMsgReadState: _getAtMsgReadState2.default,
	  setAtMsgReadState: _setAtMsgReadState2.default,
	  updateATMsgReadCountStatus: _updateATMsgReadCountStatus2.default,
	  bindEvents: _bindEvents2.default,
	  cacheEvent: _cacheEvent2.default,
	  getMsgReadStatus: _getMsgReadStatus2.default,
	  setMsgReadStatus: _setMsgReadStatus2.default,
	  updateMsgReadStatus: _updateMsgReadStatus2.default,
	  msgReadStatus: _msgReadStatus2.default,
	  sendMsgStatusChange: _sendMsgStatusChange2.default,
	  getAudioShowTextSetting: _getAudioShowTextSetting2.default
	};
	module.exports = exports['default'];

/***/ },
/* 85 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _index = __webpack_require__(84);

	var _index2 = _interopRequireDefault(_index);

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/2/20.
	 */
	var start = new _$BaseRoot.Base.ActionCreator();

	start.doSync = function () {
	  _$JuicerRoot2.default.register('dateFormatter', _util2.default.dateFormatter);
	  _$JuicerRoot2.default.register('timeFormatter', _util2.default.timeFormatter);
	  _index2.default.bindEvents.action();
	  _index2.default.getAudioShowTextSetting.action();
	};

	exports.default = start;
	module.exports = exports['default'];

/***/ },
/* 86 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _event = __webpack_require__(87);

	var _event2 = _interopRequireDefault(_event);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/6.
	 * 获取群@消息已读未读人数
	 */
	var getAtMsgReadState = new _$BaseRoot.Base.ActionCreator();

	getAtMsgReadState.actionType = 'async';
	getAtMsgReadState.doAsync = function (context, cid, list) {

	  if (!list.length) {
	    return new Promise(function (resolve, reject) {
	      reject('list is empty!');
	    });
	  }

	  return _sdk2.default.getAtMsgReadState({
	    tribeid: cid,
	    items: list
	  });
	};

	getAtMsgReadState.after(function (context, data) {
	  _event2.default.emit(_constants2.default.Event.ON_AT_MSG_STATUS_CHANGE, data);
	});

	getAtMsgReadState.error = function (err) {
	  console.error('Action getAtMsgReadState Error', err);
	};

	exports.default = getAtMsgReadState;
	module.exports = exports['default'];

/***/ },
/* 87 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	                                          value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var Event = new _$BaseRoot.Base.Event(); /**
	                                          * Created by neitherzhu on 2017/1/3.
	                                          */
	exports.default = Event;
	module.exports = exports['default'];

/***/ },
/* 88 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var Util = _$BaseRoot.Base.Util,
	    Cache = _$BaseRoot.Base.Cache; /**
	                                    * Created by neitherzhu on 2016/12/6.
	                                    * 设置群@消息已读状态
	                                    */

	var setAtMsgReadState = new _$BaseRoot.Base.ActionCreator();

	setAtMsgReadState.before(function (context, cid, list) {
	  var uid = Util.getUid(cid);
	  var cache = Cache.get(uid);
	  var cacheList = cache.setReadStateList || [];

	  list = cacheList ? cacheList.concat(list || []) : list;

	  if (!list || !list.length) return false;

	  var listToSet = [];
	  var wh = window.innerHeight;
	  var listToCache = [];
	  var el = void 0;
	  var rect = void 0;
	  if (_window2.default.IS_CHAT_WINDOW_COVERED) {
	    listToCache = list;
	  } else {

	    list.forEach(function (msg) {
	      if (!(el = document.getElementById(msg.msgid))) return;

	      rect = el.getBoundingClientRect();

	      // 如果在可视区域内
	      if (rect.top > 0 && rect.bottom <= wh) {
	        listToSet.push({
	          userid: msg.userid,
	          msgid: msg.msgid
	        });
	      } else {
	        listToCache.push(msg);
	      }
	    });
	  }

	  listToCache.length && Cache.set(uid, {
	    setReadStateList: listToCache
	  });

	  listToSet.length && (context.list = listToSet);
	});

	setAtMsgReadState.doSync = function (context, cid, list) {
	  if (context.list && context.list.length) {
	    _sdk2.default.setAtMsgReadState({
	      tribeid: cid,
	      items: context.list
	    }).catch(function () {
	      var uid = Util.getUid(cid);
	      var cache = Cache.get(uid);
	      var cacheList = cache.setReadStateList || [];
	      Cache.set(uid, {
	        setReadStateList: cacheList.concat(context.list)
	      });
	    });
	  }
	};

	setAtMsgReadState.error = function (err) {
	  console.error('Action setAtMsgReadState Error', err);
	};

	exports.default = setAtMsgReadState;
	module.exports = exports['default'];

/***/ },
/* 89 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	function _toConsumableArray(arr) {
	  if (Array.isArray(arr)) {
	    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
	      arr2[i] = arr[i];
	    }return arr2;
	  } else {
	    return Array.from(arr);
	  }
	} /**
	   * Created by neitherzhu on 2016/12/8.
	   * 更新群@消息的未读已读人数
	   */

	var Cache = _$BaseRoot.Base.Cache;

	var updateATMsgReadCountStatus = new _$BaseRoot.Base.ActionCreator();

	updateATMsgReadCountStatus.doSync = function (context, data) {
	  var el = void 0,
	      tpl = '';

	  data.forEach(function (msg) {
	    if (!msg.msgid) return;

	    if (!(el = document.getElementById(msg.msgid))) return;

	    var readCount = msg.readedcount;
	    var unreadCount = msg.unreadcount;
	    // 如果没有已读未读数量, 则移除@消息的样式
	    if (!readCount && !unreadCount) {
	      var n = Cache.get('TO_BE_AT_MSG')[data.msgid];
	      if (!n || n > 1) {
	        Cache.clearInKey('TO_BE_AT_MSG', data.msgid);
	        return [].concat(_toConsumableArray(el.querySelectorAll('.' + _constants2.default.CLS.AT_MSG_WITH_STYLE))).forEach(function (el) {
	          el.classList.remove(_constants2.default.CLS.AT_MSG_WITH_STYLE);
	        });
	      } else {
	        return Cache.set('TO_BE_AT_MSG')[data.msgid] = n + 1;
	      }
	    }

	    Cache.clearInKey('TO_BE_AT_MSG', data.msgid);

	    var only = readCount + unreadCount === 1;
	    var stateEl = el.querySelector('.' + _constants2.default.CLS.MSG_STATUS_CONTAINER);
	    var done = false;

	    // 未读
	    if (readCount === 0) {
	      tpl = _constants2.default.I18N[_constants2.default.LANGUAGE][only ? 'AT_MSG_UNREAD' : 'ALL_AT_MSG_UNREAD'];
	    } else if (unreadCount === 0) {
	      tpl = _constants2.default.I18N[_constants2.default.LANGUAGE][only ? 'AT_MSG_READ' : 'ALL_AT_MSG_READ'];
	      done = true;
	      el.classList.add(_constants2.default.CLS.COMPLETED_AT_MSG);
	    } else {
	      tpl = (0, _$JuicerRoot2.default)(_constants2.default.I18N[_constants2.default.LANGUAGE].AT_MSG_READ_UNREAD_COUNT, {
	        readCount: readCount,
	        unreadCount: unreadCount
	      });
	    }

	    stateEl && (stateEl.innerHTML = (0, _$JuicerRoot2.default)(_template2.default.atMsgReadCount, { id: msg.msgid, tpl: tpl, done: done }));
	  });
	};

	exports.default = updateATMsgReadCountStatus;
	module.exports = exports['default'];

/***/ },
/* 90 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _index = __webpack_require__(84);

	var _index2 = _interopRequireDefault(_index);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _event = __webpack_require__(87);

	var _event2 = _interopRequireDefault(_event);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _coms = __webpack_require__(91);

	var _fileParse = __webpack_require__(96);

	var _fileParse2 = _interopRequireDefault(_fileParse);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	function _toConsumableArray(arr) {
	  if (Array.isArray(arr)) {
	    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
	      arr2[i] = arr[i];
	    }return arr2;
	  } else {
	    return Array.from(arr);
	  }
	} /**
	   * Created by neitherzhu on 2017/2/21.
	   */

	var Util = _$BaseRoot.Base.Util,
	    Cache = _$BaseRoot.Base.Cache;

	var bindEvents = new _$BaseRoot.Base.ActionCreator();

	bindEvents.doSync = function () {
	  var param = Util.getParam(location.search.substring(1));
	  var DLG_NAME = param.dlguniqname || '';
	  var IS_CHAT_WINDOW_COVERED = param.IsChatWindowCovered;

	  _window2.default.IS_CHAT_WINDOW_COVERED = IS_CHAT_WINDOW_COVERED;
	  // 获取服务器时间
	  _sdk2.default.getServerTime().then(function (data) {
	    var n = parseInt(data.result);
	    _window2.default.serverTime = n;
	  });

	  _sdk2.default.isChatWindowCovered().then(function (data) {
	    if (!data || !data.result) return;

	    _$IMSDKRoot2.default.fire(_constants2.default.Event.CONVERSATION_PREFIX + DLG_NAME + _constants2.default.Event.WINDOW_COVER_CHANGE_SUFFIX, {
	      bCovered: data.result.bIsChatWindowCovered
	    });
	  });
	  /**
	   * 更新群@消息已读未读人数
	   */
	  _event2.default.on(_constants2.default.Event.ON_AT_MSG_STATUS_CHANGE, function (data) {
	    _index2.default.updateATMsgReadCountStatus.action(data);
	  });

	  _$IMSDKRoot2.default.on(_constants2.default.Event.SHOW_AUDIO_TEXT_SETTING_CHANGE, function (data) {
	    _window2.default.sharedWin.container.classList[data.show ? 'add' : 'remove']('show-audio-text');
	  });

	  /**
	   * 窗口遮盖变化事件通知
	   */
	  _$IMSDKRoot2.default.on(_constants2.default.Event.CONVERSATION_PREFIX + DLG_NAME + _constants2.default.Event.WINDOW_COVER_CHANGE_SUFFIX, function (data) {
	    _window2.default.IS_CHAT_WINDOW_COVERED = data.bCovered;

	    var conversationID = _window2.default.sharedWin.conversationID;
	    if (!data.bCovered && conversationID) {
	      if (conversationID.type === _constants2.default.TYPE.SINGLE) {
	        _index2.default.setMsgReadStatus.action(conversationID);
	      } else {
	        _index2.default.setAtMsgReadState.action(conversationID);
	      }
	    }
	  });

	  /**
	   * 群@消息已读数量变更
	   */
	  _$IMSDKRoot2.default.on(_constants2.default.Event.ON_AT_MSG_READ, function (data) {
	    if (!data || !data.cid) return;

	    if (Util.getUid(data.cid) === Util.getUid(_window2.default.sharedWin.conversationID)) {
	      _index2.default.getAtMsgReadState.action(data.cid, [{
	        userid: _window2.default.sharedWin.loginID,
	        msgid: data.msgid
	      }]);
	    }
	  });

	  /**
	   * 语音播放停止
	   */
	  _$IMSDKRoot2.default.on(_constants2.default.Event.ON_AUDIO_STOP, function () {
	    [].concat(_toConsumableArray(document.querySelectorAll('.' + _constants2.default.CLS.AUDIO_PLAYING))).forEach(function (el) {
	      el.classList.remove(_constants2.default.CLS.AUDIO_PLAYING);
	    });
	  });

	  /**
	   * 文件传输过程
	   */
	  _$IMSDKRoot2.default.on(_constants2.default.Event.UPDATE_FILE_TRANSFER_INFO, function (data) {
	    if (!data || !data.cid) return;

	    var uid = Util.getUidByCid(data.cid);
	    // 如果不是当前联系对象, 需要缓存
	    if (uid !== Util.getUid(_window2.default.sharedWin.conversationID)) {

	      var unResolveEvents = Cache.get(uid).unResolveEvents;

	      if (unResolveEvents && unResolveEvents.length) {
	        Object.assign(unResolveEvents[0].data, data);
	        return;
	      }

	      data.event = _constants2.default.Event.UPDATE_FILE_TRANSFER_INFO;
	      return _index2.default.cacheEvent.action(uid, data);
	    }

	    (0, _fileParse2.default)(data.id, data.transferInfo);
	  });

	  /**
	   * 文件信息变更
	   */
	  _$IMSDKRoot2.default.on(_constants2.default.Event.UPDATE_FILE_INFO, function (data) {

	    if (!data || !data.cid || !data.id || !data.fileInfo) return;

	    var uid = Util.getUidByCid(data.cid);
	    // 如果不是当前联系对象, 需要缓存
	    if (uid !== Util.getUid(_window2.default.sharedWin.conversationID)) {

	      data.event = _constants2.default.Event.UPDATE_FILE_INFO;
	      return _index2.default.cacheEvent.action(uid, data);
	    }

	    var fileMsg = document.getElementById('J_file' + data.id);
	    var result = data.fileInfo;
	    if (!fileMsg) return;

	    result.id && (fileMsg.id = 'J_file' + result.id);
	    result.parentId && fileMsg.setAttribute('data-pid', result.parentId);
	    result.nodeType && fileMsg.setAttribute('data-type', result.nodeType);
	    result.md5 && fileMsg.setAttribute('data-md5', result.md5);

	    if (result.nodeName) {
	      fileMsg.setAttribute('data-name', result.nodeName);

	      var s = result.nodeName.split('.');
	      var suffix = '';
	      var suffixLen = 0;
	      var name = '';
	      var fileName = fileMsg.querySelector('.file-name');

	      if (!fileName) return;

	      if (s.length > 1) {
	        suffix = '.' + s.pop();
	        suffixLen = Util.getStrLen(suffix);
	      }

	      name = Util.getStrByLen(s.join(''), _constants2.default.FILE_MAX_LEN - suffixLen, 2) + suffix;

	      fileName.title = result.nodeName;
	      fileName.innerText = name;
	    }
	  });

	  // 消息状态变更
	  _$IMSDKRoot2.default.on(_constants2.default.Event.CHAT_SEND_MSG_STATUS_CHANGE + ' ' + _constants2.default.Event.TRIBE_SEND_MSG_STATUS_CHANGE + ' ' + _constants2.default.Event.SEND_MSG_STATUS_CHANGE, function (data) {
	    if (!data || !data.cid || !data.msgid) return;

	    var uid = Util.getUid(data.cid);
	    // 如果不是当前联系对象, 需要缓存
	    if (uid !== Util.getUid(_window2.default.sharedWin.conversationID)) {
	      data.event = _constants2.default.Event.SEND_MSG_STATUS_CHANGE;
	      return _index2.default.cacheEvent.action(uid, data);
	    }

	    _index2.default.sendMsgStatusChange.action(data);
	  });

	  // 单聊消息已读
	  _$IMSDKRoot2.default.on(_constants2.default.Event.CHAT_MSG_READ, function (data) {
	    if (!data || !data.cid || !data.items || !data.items.length) return;

	    var uid = Util.getUid(data.cid);
	    var currentUid = Util.getUid(_window2.default.sharedWin.conversationID);
	    // 如果不是当前联系对象, 需要缓存
	    if (uid !== currentUid) {

	      data.event = _constants2.default.Event.CHAT_MSG_READ;
	      return _index2.default.cacheEvent.action(uid, data);
	    }

	    _index2.default.updateMsgReadStatus.action(data.items);
	  });

	  // 更新消息已读未读状态
	  _event2.default.on(_constants2.default.Event.MSG_STATUS_CHANGE, function (data) {
	    _index2.default.updateMsgReadStatus.action(data);
	  });

	  document.body.addEventListener('click', function (ev) {
	    var target = ev.target;

	    if (!target) return;

	    var targetNode = Util.parents(target, 'J_tempAction') || Util.parents(target, 'J_msg_Syshongbao');

	    if (targetNode) {

	      var absX = ev.screenX - ev.clientX;
	      var basY = ev.screenY - ev.clientY;
	      var actionRect = targetNode.getBoundingClientRect();
	      var boxRect = targetNode.getBoundingClientRect();
	      var actionX = absX + actionRect.left;
	      var actionY = basY + actionRect.top;
	      var boxX = absX + boxRect.left;
	      var boxY = basY + boxRect.top;

	      _sdk2.default.doWXAction({
	        wangxurl: targetNode.getAttribute('data-action'),
	        actionrect: {
	          let: actionX,
	          top: actionY,
	          right: actionX + actionRect.width,
	          bottom: actionY + actionRect.height
	        },
	        cardrect: {
	          left: boxX,
	          top: boxY,
	          right: boxX + boxRect.width,
	          bottom: boxY + boxRect.height
	        }
	      }).catch(function (e) {
	        var errTip = e && e.errMsg || _constants2.default.I18N[_constants2.default.LANGUAGE].DO_WX_ACTION_ERROR;

	        _coms.Toast.show(errTip);
	      });
	    }
	  });
	};

	exports.default = bindEvents;
	module.exports = exports['default'];

/***/ },
/* 91 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _popupOver = __webpack_require__(92);

	var _popupOver2 = _interopRequireDefault(_popupOver);

	var _toast = __webpack_require__(94);

	var _toast2 = _interopRequireDefault(_toast);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/1/23.
	 */
	exports.default = {
	  PopupOver: _popupOver2.default,
	  Toast: _toast2.default
	};
	module.exports = exports['default'];

/***/ },
/* 92 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _createClass = function () {
	  function defineProperties(target, props) {
	    for (var i = 0; i < props.length; i++) {
	      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
	    }
	  }return function (Constructor, protoProps, staticProps) {
	    if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
	  };
	}(); /**
	      * Created by neitherzhu on 2016/12/9.
	      * 窗口内浮层, 负责确定弹出的位置
	      */

	__webpack_require__(93);

	function _classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	}

	var PopupOver = function () {
	  function PopupOver(container, config) {
	    _classCallCheck(this, PopupOver);

	    this.container = container;
	    this.box = null;
	    this.visible = false;
	    this.config = config;

	    return this;
	  }

	  _createClass(PopupOver, [{
	    key: 'calculate',
	    value: function calculate(x, y) {
	      if (!this.box) return {};

	      var newx = x,
	          newy = y;

	      if (!this.config || this.config && newx !== this.config.x || newy !== this.config.y) {
	        var offx = 5,
	            offy = 5;
	        var boxw = this.box.clientWidth,
	            boxh = this.box.clientHeight;
	        var winw = window.innerWidth,
	            winh = window.innerHeight;

	        // 左右都超出, 展示在点击位置的中间
	        if (x + boxw > winw && x < boxw) {
	          newx = (winw - boxw) / 2;
	        } else {
	          newx = x + boxw > winw ? x - boxw - offx : x + offx;
	          newx = Math.min(newx, winw - boxw); // 不能超右边界
	          newx = Math.max(newx, 0); // 不能超左边界
	        }

	        // 上下都超出
	        if (y + boxh > winh && y < boxh) {
	          newy = (winh - boxh) / 2;
	        } else {
	          newy = y + boxh > winh ? y - boxh - offy : y + offy;
	          newy = Math.min(newy, winh - boxh); // 不能超下边界
	          newy = Math.max(newy, 0); // 不能超上边界
	        }
	      }

	      var p1 = x >= 0 ? 'left' : 'right';
	      var p2 = y >= 0 ? 'top' : 'bottom';
	      var result = {};

	      result[p1] = Math.abs(newx) + 'px';
	      result[p2] = Math.abs(newy) + 'px';

	      return result;
	    }
	  }, {
	    key: 'getStyle',
	    value: function getStyle(config) {
	      var x = config.x,
	          y = config.y,
	          visible = config.visible;

	      var style = this.calculate(x, y);
	      var str = '';

	      style.visibility = visible ? 'visible' : 'hidden';
	      style.opacity = visible ? '1' : '0';
	      this.visible = visible;

	      for (var k in style) {
	        str += k + ':' + style[k] + ';';
	      }

	      return str;
	    }
	  }, {
	    key: 'render',
	    value: function render(config) {
	      var cls = config.cls,
	          tpl = config.tpl,
	          html = config.html,
	          parent = config.parent;

	      var style = this.getStyle(config);

	      cls || (cls = '');

	      if (!this.box) {

	        var div = document.createElement('div');

	        tpl && (div.innerHTML = tpl);
	        div.className = 'popup-over ' + cls;

	        this.box = div;

	        (parent || document.body).appendChild(div);
	      }

	      this.box.setAttribute('style', style);
	      html && (this.box.innerHTML = html);
	    }
	  }]);

	  return PopupOver;
	}();

	exports.default = PopupOver;
	module.exports = exports['default'];

/***/ },
/* 93 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ },
/* 94 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _createClass = function () {
	  function defineProperties(target, props) {
	    for (var i = 0; i < props.length; i++) {
	      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
	    }
	  }return function (Constructor, protoProps, staticProps) {
	    if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
	  };
	}(); /**
	      * Created by neitherzhu on 2017/3/3.
	      */

	__webpack_require__(95);

	function _classCallCheck(instance, Constructor) {
	  if (!(instance instanceof Constructor)) {
	    throw new TypeError("Cannot call a class as a function");
	  }
	}

	/**
	 * 消息区域toast
	 */
	var Toast = function () {
	  function Toast(container) {
	    _classCallCheck(this, Toast);

	    this.container = container;
	    this.AUTO_REMOVE_TIME = 2000;

	    return this;
	  }

	  _createClass(Toast, [{
	    key: 'show',
	    value: function show(text, duration) {
	      var _this = this;

	      duration = duration || this.AUTO_REMOVE_TIME;

	      if (this.toast) {
	        clearTimeout(this.removeTimeout);
	        this.toast.querySelector('.J_toastText').innerText = text;
	      } else {
	        var div = document.createElement('div');
	        div.className = 'toast';
	        div.innerHTML = '<span class="J_toastText">' + text + '</span>';
	        this.container.appendChild(div);
	        this.toast = div;
	      }

	      this.removeTimeout = setTimeout(function () {
	        _this.remove();
	      }, duration);
	    }
	  }, {
	    key: 'remove',
	    value: function remove() {
	      if (this.toast) {
	        this.toast.parentNode.removeChild(this.toast);
	        this.toast = null;
	      }
	    }
	  }]);

	  return Toast;
	}();

	exports.default = Toast;
	module.exports = exports['default'];

/***/ },
/* 95 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ },
/* 96 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _template = __webpack_require__(15);

	var _getFileOptionData = __webpack_require__(60);

	var _getFileOptionData2 = _interopRequireDefault(_getFileOptionData);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = function (id, data) {
	  if (!id || !data) return;

	  var fileMsg = document.getElementById('J_file' + id);

	  if (!fileMsg) return;

	  var operationData = (0, _getFileOptionData2.default)(data);

	  // 未开始上传/下载
	  // 上传/下载中
	  if (data.status == 0 || data.status == 1) {

	    var progressEl = fileMsg.querySelector('.file-progress');
	    if (!progressEl) return;

	    var innerProgressEl = progressEl.querySelector('i');
	    if (!innerProgressEl) return;

	    progressEl.classList.remove('hidden');
	    innerProgressEl.style.width = data.progress + '%';

	    // 针对大文件进行动画处理,小文件动画效果不明显
	    if (data.progress > 1 && data.progress < 4) {
	      innerProgressEl.classList.add('animation-width');
	    }
	  }
	  // 上传/下载错误
	  else if (data.status == 2) {
	      var _progressEl = fileMsg.querySelector('.file-progress');
	      _progressEl && _progressEl.classList.add('hidden');
	    }
	    // 上传/下载被取消
	    else if (data.status == 3) {
	        if (data.type == 0) {
	          var msgEl = document.getElementById(id);
	          msgEl && msgEl.parentNode.removeChild(msgEl);
	        } else {
	          var _progressEl2 = fileMsg.querySelector('.file-progress');
	          _progressEl2 && _progressEl2.classList.add('hidden');
	        }
	      }
	      // 上传/下载成功
	      else if (data.status == 4) {
	          var _progressEl3 = fileMsg.querySelector('.file-progress');
	          if (!_progressEl3) return;

	          var _innerProgressEl = _progressEl3.querySelector('i');

	          _progressEl3.classList.add('hidden');

	          //if(data.type == 1) {
	          //  progressEl.classList.add('hidden');
	          //}

	          _innerProgressEl && (_innerProgressEl.style.width = data.progress + '%');
	        }
	        // 未知状态
	        else if (data.status == 5) {
	            var _progressEl4 = fileMsg.querySelector('.file-progress');
	            _progressEl4 && _progressEl4.classList.add('hidden');
	          }

	  if (data.type == 0) {
	    operationData.isSelf = true;
	  }

	  fileMsg.querySelector('.file-operation').innerHTML = (0, _$JuicerRoot2.default)(_template.fileOperation, operationData);
	}; /**
	    * Created by neitherzhu on 2017/3/31.
	    */

	module.exports = exports['default'];

/***/ },
/* 97 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var Cache = _$BaseRoot.Base.Cache; /**
	                                    * Created by neitherzhu on 2016/12/8.
	                                    * 缓存没有触发的事件
	                                    */

	var cacheEvent = new _$BaseRoot.Base.ActionCreator();

	cacheEvent.doSync = function (context, uid, data) {

	  var unResolveEvents = Cache.get(uid).unResolveEvents || [];
	  unResolveEvents.push({
	    event: data.event,
	    data: data
	  });

	  Cache.set(uid, { unResolveEvents: unResolveEvents });
	};

	exports.default = cacheEvent;
	module.exports = exports['default'];

/***/ },
/* 98 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _event = __webpack_require__(87);

	var _event2 = _interopRequireDefault(_event);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/2/15.
	 */
	var getMsgReadStatus = new _$BaseRoot.Base.ActionCreator();

	getMsgReadStatus.actionType = 'async';
	getMsgReadStatus.doAsync = function (context, cid, list) {

	  if (!list.length) {
	    return new Promise(function (resolve, reject) {
	      reject('list is empty!');
	    });
	  }

	  context.list = list;

	  return _sdk2.default.getSingleMsgReadStatus({
	    cid: cid,
	    items: list
	  });
	};

	getMsgReadStatus.after(function (context, data) {
	  data = data.result;
	  var readMap = data && data.length ? {} : null;

	  data.forEach(function (msg) {
	    readMap[msg.msgid] = 1;
	  });

	  context.list.forEach(function (msg) {
	    if (!readMap || !readMap[msg.msgid]) {
	      msg.unread = 1;
	    }
	  });

	  _event2.default.emit(_constants2.default.Event.MSG_STATUS_CHANGE, context.list);
	});

	getMsgReadStatus.error = function (err) {
	  console.error('Action getMsgReadStatus Error', err);
	};

	exports.default = getMsgReadStatus;
	module.exports = exports['default'];

/***/ },
/* 99 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/2/15.
	 */
	var Cache = _$BaseRoot.Base.Cache;

	var setMsgReadState = new _$BaseRoot.Base.ActionCreator();

	setMsgReadState.before(function (context, cid, list) {
	  var uid = _util2.default.getUid(cid);
	  var cache = Cache.get(uid);
	  var cacheList = cache.msgReadStateListToSet || [];

	  list = cacheList ? cacheList.concat(list || []) : list;

	  if (!list || !list.length) return false;

	  var wh = window.innerHeight;
	  var listToSet = [];
	  var listToCache = [];
	  var el = void 0;
	  var rect = void 0;

	  if (_window2.default.IS_CHAT_WINDOW_COVERED) {
	    listToCache = list;
	  } else {
	    list.forEach(function (msg) {
	      if (!(el = document.getElementById(msg.msgid))) return;

	      rect = el.getBoundingClientRect();

	      if (rect.height < wh) {
	        // 如果在可视区域内
	        if (rect.top > 0 && rect.bottom <= wh) {
	          listToSet.push({
	            svrtime: msg.svrtime || '0',
	            msgtime: msg.msgtime,
	            msgid: msg.msgid
	          });
	        } else {
	          listToCache.push(msg);
	        }
	      } else {
	        if (rect.top >= wh - rect.height && rect.top < wh || rect.bottom > 0 && rect.bottom <= rect.height) {
	          listToSet.push({
	            svrtime: msg.svrtime || '0',
	            msgtime: msg.msgtime,
	            msgid: msg.msgid
	          });
	        } else {
	          listToCache.push(msg);
	        }
	      }
	    });
	  }

	  Cache.set(uid, {
	    msgReadStateListToSet: listToCache
	  });

	  listToSet.length && (context.list = listToSet);
	});

	setMsgReadState.doSync = function (context, cid, list) {
	  if (context.list && context.list.length) {
	    _sdk2.default.setSingleMsgReadStatus({
	      cid: cid,
	      items: context.list
	    }).catch(function () {
	      var uid = _util2.default.getUid(cid);
	      var cache = Cache.get(uid);
	      var cacheList = cache.setReadStateList || [];
	      Cache.set(uid, {
	        msgReadStateListToSet: cacheList.concat(context.list)
	      });
	    });
	  }
	};

	setMsgReadState.error = function (err) {
	  console.error('Action setMsgReadState Error', err);
	};

	exports.default = setMsgReadState;
	module.exports = exports['default'];

/***/ },
/* 100 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var Util = _$BaseRoot.Base.Util; /**
	                                  * Created by neitherzhu on 2017/2/15.
	                                  */

	var updateMsgReadStatus = new _$BaseRoot.Base.ActionCreator();

	updateMsgReadStatus.doSync = function (context, data) {
	  var el = void 0,
	      tpl = '';
	  var isSingle = _window2.default.sharedWin.conversationID.type === _constants2.default.TYPE.SINGLE;
	  var isSelf = void 0;
	  var loginNick = Util.getUid(_window2.default.sharedWin.loginID);
	  var fromNick = void 0;
	  var isFile = false;

	  data.forEach(function (msg) {
	    if (!msg.msgid) return;

	    if (!(el = document.getElementById(msg.msgid))) return;

	    if (msg.isSelf) {
	      isSelf = true;
	    } else {
	      fromNick = Util.getUid(msg.fromid || msg.from);

	      if (isSingle) {
	        if (loginNick.split(':')[0] !== Util.getUid(msg.cid).split(':')[0]) {
	          isSelf = loginNick.split(':')[0] == fromNick.split(':')[0];
	        } else {
	          isSelf = loginNick == fromNick;
	        }
	      } else {
	        isSelf = loginNick == fromNick;
	      }
	    }

	    if (!isSelf) return;

	    isFile = el.classList.contains('file-msg-wrap');

	    tpl = !msg.unread ? _constants2.default.I18N[_constants2.default.LANGUAGE][!isFile ? 'AT_MSG_READ' : 'FILE_OPENED'] : _constants2.default.I18N[_constants2.default.LANGUAGE][!isFile ? 'AT_MSG_UNREAD' : 'FILE_UNOPENED'];

	    var stateEl = el.querySelector('.' + _constants2.default.CLS.MSG_STATUS_CONTAINER);

	    if (stateEl) {
	      var readStatus = stateEl.dataset.unread;
	      if (readStatus !== '0') {
	        stateEl.setAttribute('data-unread', msg.unread ? '1' : '0');
	        stateEl.innerHTML = (0, _$JuicerRoot2.default)(_template2.default.msgReadStatus, { tpl: tpl, isread: !msg.unread });
	      }
	    }
	    // stateEl && (stateEl.innerHTML = juicer(Template.msgReadStatus, { tpl: tpl, isread: !msg.unread }));
	  });
	};

	exports.default = updateMsgReadStatus;
	module.exports = exports['default'];

/***/ },
/* 101 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _index = __webpack_require__(84);

	var _index2 = _interopRequireDefault(_index);

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	function _toConsumableArray(arr) {
	  if (Array.isArray(arr)) {
	    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
	      arr2[i] = arr[i];
	    }return arr2;
	  } else {
	    return Array.from(arr);
	  }
	} /**
	   * Created by neitherzhu on 2017/2/15.
	   */

	var msgReadStatus = new _$BaseRoot.Base.ActionCreator();
	msgReadStatus.todoMap = {};
	msgReadStatus.doSync = function (context, cid) {
	  var uid = _util2.default.getUid(cid);
	  var m = this.todoMap[uid];

	  if (!m) return;

	  var toGetList = [];
	  var toSetList = [];
	  var list = [].concat(_toConsumableArray(m.list));
	  var i = 0;

	  list.forEach(function (msg, index) {
	    // 自己发送的消息并且是发送成功的消息
	    if (msg.self) {
	      if (msg.msgstatus === 1 && msg.readflag !== 2) {
	        toGetList.push(msg);
	        m.list.splice(index - i, 1);
	        i++;
	      }
	    } else {
	      if (!msg.doNotSetReadStatus) {
	        toSetList.push(msg);
	        m.list.splice(index - i, 1);
	        i++;
	      }
	    }
	  });

	  toGetList.length && _index2.default.getMsgReadStatus.action(cid, toGetList);
	  toSetList.length && _index2.default.setMsgReadStatus.action(cid, toSetList);

	  delete this.todoMap[uid];
	};

	msgReadStatus.push = function (cid, item) {
	  var uid = _util2.default.getUid(cid);

	  if (!this.todoMap[uid]) {
	    this.todoMap[uid] = {
	      list: [],
	      map: {}
	    };
	  }

	  var m = this.todoMap[uid];

	  if (m.map[item.msgid]) return;

	  m.map[item.msgid] = 1;
	  m.list.push(item);
	};

	exports.default = msgReadStatus;
	module.exports = exports['default'];

/***/ },
/* 102 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var sendMsgStatusChange = new _$BaseRoot.Base.ActionCreator(); /**
	                                                                * Created by neitherzhu on 2017/3/31.
	                                                                */

	sendMsgStatusChange.doSync = function (context, data) {

	  var msgEl = document.getElementById(data.msgid);

	  if (!msgEl) return;

	  // 消息发送成功
	  if (data.code === 0) {
	    var progressEl = msgEl.querySelector('.file-progress');
	    progressEl && progressEl.classList.add('hidden');
	  }
	};

	exports.default = sendMsgStatusChange;
	module.exports = exports['default'];

/***/ },
/* 103 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var getAudioShowTextSetting = new _$BaseRoot.Base.ActionCreator(); /**
	                                                                    * Created by neitherzhu on 2017/5/17.
	                                                                    */

	getAudioShowTextSetting.actionType = 'async';
	getAudioShowTextSetting.doAsync = function (context) {
	  _sdk2.default.getAudioShowTextSetting().then(function (data) {
	    if (!data || !data.result) return;
	    _window2.default.sharedWin.container.classList[data.result.show ? 'add' : 'remove']('show-audio-text');
	  });
	};

	exports.default = getAudioShowTextSetting;
	module.exports = exports['default'];

/***/ },
/* 104 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	                                           value: true
	});

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	__webpack_require__(106);

	__webpack_require__(107);

	__webpack_require__(108);

	__webpack_require__(109);

	__webpack_require__(110);

	__webpack_require__(111);

	__webpack_require__(113);

	__webpack_require__(115);

	__webpack_require__(117);

	__webpack_require__(119);

	__webpack_require__(120);

	__webpack_require__(121);

	__webpack_require__(122);

	__webpack_require__(123);

	__webpack_require__(124);

	__webpack_require__(125);

	function _interopRequireDefault(obj) {
	                                           return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = _createPlugin2.default; /**
	                                           * Created by neitherzhu on 2016/12/7.
	                                           * 插件
	                                           */

	module.exports = exports['default'];

/***/ },
/* 105 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	                                            value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var Plugin = new _$BaseRoot.Base.Plugin(); /**
	                                            * Created by neitherzhu on 2016/12/8.
	                                            * 创建全局插件
	                                            */
	exports.default = Plugin;
	module.exports = exports['default'];

/***/ },
/* 106 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _actions = __webpack_require__(84);

	var _actions2 = _interopRequireDefault(_actions);

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/8.
	 * 点击语音消息
	 */
	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.AUDIO, function (ev) {
	  var target = ev.target;

	  if (!target.classList.contains(_constants2.default.CLS.AUDIO_PLAYING)) {
	    var md5 = target.getAttribute('data-md5');
	    var path = target.getAttribute('data-path');

	    _sdk2.default.playAudio({ filepath: path, fileMD5: md5 });
	    target.classList.add(_constants2.default.CLS.AUDIO_PLAYING);

	    // 暂时只支持单聊
	    if (_window2.default.sharedWin.conversationID.type !== _constants2.default.TYPE.SINGLE) return;

	    var ignore = target.getAttribute('data-ignore') === '1';

	    if (ignore) return;

	    var parent = _util2.default.parents(target, _constants2.default.CLS.MSG_CONTAINER);
	    if (!parent) return;
	    var time = parent.getAttribute('data-time');

	    _actions2.default.setMsgReadStatus.action(_window2.default.sharedWin.conversationID, [{
	      svrtime: time,
	      msgtime: time,
	      msgid: parent.id
	    }]);

	    target.setAttribute('data-ignore', 1);
	  } else {
	    target.classList.remove(_constants2.default.CLS.AUDIO_PLAYING);
	    _sdk2.default.stopAudio();
	  }
	});

/***/ },
/* 107 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	_createPlugin2.default.addEventPlugin('dblclick', _constants2.default.CLS.IMAGE, function (ev) {

	  var target = ev.target;

	  _sdk2.default.previewImage({
	    fileMD5: target.getAttribute('data-md5'),
	    filepath: target.src,
	    cid: _util2.default.getCid(_window2.default.sharedWin.conversationID),
	    time: parseInt(target.getAttribute('data-time'))
	  });
	}); /**
	     * Created by neitherzhu on 2016/12/8.
	     * 点击图片
	     */

/***/ },
/* 108 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _$BaseRoot = __webpack_require__(3);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var Util = _$BaseRoot.Base.Util; /**
	                                  * Created by neitherzhu on 2016/12/8.
	                                  * 点击打开群@消息已读未读人数查看页面
	                                  */

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.OPEN_READ_STATE_COUNT_DETAIL, function (ev) {

	  var parent = Util.parents(ev.target, _constants2.default.CLS.MSG_CONTAINER);

	  parent && _sdk2.default.openReadStateCountDetail({
	    tribeid: _window2.default.sharedWin.conversationID,
	    msgid: parent.id,
	    userid: {
	      appkey: parent.getAttribute('data-appkey'),
	      nick: parent.getAttribute('data-nick')
	    }
	  });
	});

/***/ },
/* 109 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.OPEN_FILE_SETTING, function (ev) {
	  _sdk2.default.openFileSetting();
	}); /**
	     * Created by neitherzhu on 2016/12/8.
	     * 点击打开文件设置
	     */

/***/ },
/* 110 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.OPEN_SHAKE_SETTING, function (ev) {
	  _sdk2.default.openShakeSetting();
	}); /**
	     * Created by neitherzhu on 2016/12/8.
	     * 打开震屏设置
	     */

/***/ },
/* 111 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _image = __webpack_require__(112);

	var _image2 = _interopRequireDefault(_image);

	var _$BaseRoot = __webpack_require__(3);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	function _toConsumableArray(arr) {
	  if (Array.isArray(arr)) {
	    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
	      arr2[i] = arr[i];
	    }return arr2;
	  } else {
	    return Array.from(arr);
	  }
	} /**
	   * Created by neitherzhu on 2016/12/8.
	   * 重新加载图片
	   */

	var Util = _$BaseRoot.Base.Util;

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.RELOAD_IMAGE, function (ev) {
	  var target = ev.target;
	  var parent = Util.parents(target, _constants2.default.CLS.MSG_CONTAINER);

	  if (!parent) return;

	  [].concat(_toConsumableArray(parent.querySelectorAll('img'))).forEach(function (img) {
	    // 如果已经是本地路径了, 则忽略
	    if (img.src.indexOf(_constants2.default.PIC_PROTOCOL) === 0) return;

	    (0, _image2.default)({
	      jvale: {
	        FILEMD5: img.getAttribute('data-md5'),
	        TYPE: img.getAttribute('data-type')
	      },
	      value: img.getAttribute('data-src'),
	      msgid: parent.id,
	      msgtime: parent.getAttribute('data-time')
	    });
	  });

	  parent.querySelector('.' + _constants2.default.CLS.MSG_STATUS_CONTAINER).innerHTML = '';
	});

/***/ },
/* 112 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (extra, callback) {

	  // 已经是本地路径
	  if (extra.value && extra.value.indexOf(_constants2.default.PIC_PROTOCOL) === 0) return;

	  _sdk2.default.getImagePath({
	    fileMD5: extra.jvale && extra.jvale.FILEMD5,
	    fileurl: extra.value,
	    filetype: extra.jvale && extra.jvale.TYPE,
	    cid: _util2.default.getCid(_window2.default.sharedWin.conversationID),
	    time: extra.msgtime
	  }).then(function (data) {
	    if (callback && !callback(data)) return;

	    var msg = document.getElementById(extra.msgid);

	    if (!msg) return;

	    [].concat(_toConsumableArray(msg.querySelectorAll('.J_' + extra.msgid))).forEach(function (img) {
	      img.classList.remove(_constants2.default.CLS.IMAGE_LOADING);
	      img.src = data.filepath;
	      var handler = function handler() {
	        // this.height = this.height;
	        img.removeEventListener('load', handler);
	      };
	      // 固定图片的高度,防止切换联系人时,由于图片加载问题导致滚动条跳动
	      img.addEventListener('load', handler);
	    });
	  }).catch(function (err) {
	    var msg = document.getElementById(extra.msgid);
	    if (!msg) return;

	    [].concat(_toConsumableArray(msg.querySelectorAll('.J_' + extra.jvale.FILEMD5))).forEach(function (img) {
	      img.setAttribute('data-src', extra.value);
	    });

	    msg.querySelector('.' + _constants2.default.CLS.MSG_STATUS_CONTAINER).innerHTML = (0, _$JuicerRoot2.default)(_template2.default.errorStatus, { cls: _constants2.default.CLS.RELOAD_IMAGE });
	  });
	};

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	function _toConsumableArray(arr) {
	  if (Array.isArray(arr)) {
	    for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) {
	      arr2[i] = arr[i];
	    }return arr2;
	  } else {
	    return Array.from(arr);
	  }
	} /**
	   * Created by neitherzhu on 2016/12/6.
	   * 图片消息 获取图片本地路径
	   */

	;
	module.exports = exports['default'];

/***/ },
/* 113 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _audio = __webpack_require__(114);

	var _audio2 = _interopRequireDefault(_audio);

	var _$BaseRoot = __webpack_require__(3);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/9.
	 * 点击重收语音
	 */
	var Util = _$BaseRoot.Base.Util;

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.RELOAD_AUDIO, function (ev) {
	  var target = ev.target;
	  var parent = Util.parents(target, _constants2.default.CLS.MSG_CONTAINER);

	  if (!parent) return;

	  var audio = parent.querySelector('.' + _constants2.default.CLS.AUDIO_WITH_STYLE);

	  (0, _audio2.default)({
	    jvale: {
	      FILEMD5: audio.getAttribute('data-md5'),
	      TYPE: audio.getAttribute('data-type')
	    },
	    value: audio.getAttribute('data-src'),
	    msgid: parent.id
	  });

	  parent.querySelector('.' + _constants2.default.CLS.MSG_STATUS_CONTAINER).innerHTML = '';
	});

/***/ },
/* 114 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (extra, callback) {

	  var audio = document.getElementById('J_AUDIO_' + extra.msgid);

	  if (!audio) return;

	  extra && extra.jvale && extra.jvale.AUDIO_TEXT && _sdk2.default.addAudioTextSettingTip(_window2.default.sharedWin.conversationID);
	  var msg = Util.parents(audio, _constants2.default.CLS.MSG_CONTAINER);

	  //msg.querySelector('.' + Constant.CLS.MSG_STATUS_CONTAINER).innerHTML = Template.loading;

	  _sdk2.default.getAudioPath({
	    fileMD5: extra.jvale.FILEMD5,
	    fileurl: extra.value,
	    filetype: extra.jvale.TYPE,
	    cid: Util.getCid(_window2.default.sharedWin.conversationID)
	  }).then(function (data) {
	    if (callback && !callback(data)) return;

	    audio.setAttribute('data-path', data.filepath);

	    audio.classList.add(_constants2.default.CLS.AUDIO);

	    //msg.querySelector('.' + Constant.CLS.MSG_STATUS_CONTAINER).innerHTML = '';
	  }).catch(function (err) {

	    audio.setAttribute('data-src', extra.value);
	    msg.querySelector('.' + _constants2.default.CLS.MSG_STATUS_CONTAINER).innerHTML = (0, _$JuicerRoot2.default)(_template2.default.errorStatus, { cls: _constants2.default.CLS.RELOAD_AUDIO });
	  });
	};

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _$BaseRoot = __webpack_require__(3);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/6.
	 * 语音消息 获取语音消息本地路径
	 */
	var Util = _$BaseRoot.Base.Util;
	;
	module.exports = exports['default'];

/***/ },
/* 115 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _popupOver = __webpack_require__(92);

	var _popupOver2 = _interopRequireDefault(_popupOver);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	__webpack_require__(116);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var Util = _$BaseRoot.Base.Util; /**
	                                  * Created by neitherzhu on 2016/12/9.
	                                  * 图片工具
	                                  */

	var TOOL_BTN_LIST = [{
	  text: '添加表情',
	  action: 'im.uiutil.AddAsEmotion',
	  cls: 'emot-icon'
	}, {
	  text: '保存图片',
	  action: 'im.uiutil.PicSaveAs',
	  cls: 'save-icon'
	}];

	var POPUP_CLS = 'J_imagePopupOver';

	var ImageToolBox = {

	  __ToolBtnList: TOOL_BTN_LIST,

	  __lastTarget: null,

	  __timer: null,

	  init: function init(context) {
	    if (!context || !context.container) return;

	    this.container = context.container;

	    this.popupOver = new _popupOver2.default(context.container);

	    this.config = {
	      visible: false,
	      x: 0,
	      y: 0,
	      cls: POPUP_CLS,
	      tpl: '',
	      html: '',
	      parent: this.container.parentNode
	    };

	    this.render();

	    this._events();
	  },
	  _events: function _events() {
	    var _this = this;

	    // 窗口滚动隐藏工具条
	    this.container.addEventListener('scroll', function () {
	      if (_this.config.visible) {
	        _this.config.visible = false;
	        _this.render();
	      }
	    });

	    document.body.addEventListener('mousemove', function (ev) {

	      var target = ev.target;

	      if (target === _this.popupOver.box || Util.parents(target, POPUP_CLS) === _this.popupOver.box) {
	        return;
	      }

	      if (target.tagName.toUpperCase() !== 'IMG' || !target.src || target.src.indexOf(_constants2.default.EMOJI_PROTOCOL) === 0 || target.src.indexOf(_constants2.default.EMOTION_PROTOCOL) === 0 || !target.classList.contains(_constants2.default.CLS.IMAGE)) {
	        if (_this.config.visible) {
	          _this.config.visible = false;
	          _this.render();
	        }

	        return;
	      }

	      if (target === _this.__lastTarget && _this._getMoveDistance(ev.clientX, ev.clientY) < 30) {
	        return;
	      }

	      _this.__lastTarget = target;

	      clearTimeout(_this.__timer);

	      _this.__timer = setTimeout(function () {
	        _this.config.x = ev.clientX;
	        _this.config.y = ev.clientY;
	        _this.config.visible = true;
	        _this.render();
	      }, 200);
	    });

	    document.body.addEventListener('mouseleave', function (ev) {
	      clearTimeout(_this.__timer);

	      if (_this.config.visible) {
	        _this.config.visible = false;
	        _this.render();
	      }
	    });
	  },
	  _getMoveDistance: function _getMoveDistance(x, y) {
	    return Math.sqrt(Math.pow(x - this.config.x, 2) + Math.pow(y - this.config.y, 2));
	  },
	  setBtnList: function setBtnList(list) {
	    this.__ToolBtnList = list;
	    // 设置过按钮列表后, 需要将模板设为空
	    // 这样下次再显示的时候才能重新获取列表中的元素
	    this.config.html = '';
	  },
	  getTpl: function getTpl() {
	    var tpl = '';

	    this.__ToolBtnList.forEach(function (item) {
	      tpl += '<li class="' + item.cls + ' J_imageAction" data-action="' + item.action + '" title="' + item.text + '">' + item.text + '</li>';
	    });

	    tpl = '<ul class="image-toolbar">' + tpl + '</ul>';

	    return tpl;
	  },
	  _clickHandler: function _clickHandler(ev) {
	    var target = ev.target;

	    if (target.matches('.J_imageAction')) {
	      var action = target.getAttribute('data-action');
	      var md5 = this.__lastTarget.getAttribute('data-md5');
	      var src = this.__lastTarget.src;
	      var param = {
	        fileMD5: md5,
	        filepath: src,
	        cid: _window2.default.sharedWin.conversationID
	      };

	      _$IMSDKRoot2.default.invoke(action, param);
	    }
	  },
	  render: function render() {
	    var _this2 = this;

	    var hasTpl = !!this.config.html;
	    !hasTpl && (this.config.html = this.getTpl());

	    this.popupOver.render(this.config);

	    if (!this.isEventBinding) {
	      this.isEventBinding = true;
	      this.popupOver.box.addEventListener('click', function (ev) {
	        _this2._clickHandler(ev);
	      });
	    }
	  }
	};

	_createPlugin2.default.addPlugin('imageToolBox', ImageToolBox);

	exports.default = ImageToolBox;
	module.exports = exports['default'];

/***/ },
/* 116 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ },
/* 117 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _popupOver = __webpack_require__(92);

	var _popupOver2 = _interopRequireDefault(_popupOver);

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	__webpack_require__(118);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/14.
	 * 链接工具
	 */
	var TOOL_BTN_LIST = [{
	  text: '打开',
	  action: 'im.bizutil.DoUrlAction',
	  param: { url: '${url}' }
	}, {
	  text: '举报',
	  action: 'im.uiutil.ShowReportCenter',
	  param: { url: '${url}', page: 2 }
	}, {
	  text: '复制',
	  action: 'im.bizutil.CopyText2Clipboard',
	  param: { content: '${url}' }
	}];

	var POPUP_CLS = 'J_linkPopupOver';

	var LinkToolBox = {

	  __ToolBtnList: TOOL_BTN_LIST,

	  __lastTarget: null,

	  __timer: null,

	  __BOX_WIDTH: 250,

	  __BOX_HEIGHT: 81,

	  __OFFSET: 10,

	  init: function init(context) {
	    if (!context || !context.container) return;

	    this.container = context.container;

	    this.popupOver = new _popupOver2.default(context.container);

	    this.config = {
	      visible: false,
	      x: 0,
	      y: 0,
	      cls: POPUP_CLS,
	      tpl: '',
	      html: '',
	      parent: this.container.parentNode
	    };

	    this.windowWidth = window.innerWidth;
	    this.windowHeight = window.innerHeight;

	    this.render();

	    this._events();
	  },
	  _events: function _events() {
	    var _this = this;

	    window.addEventListener('resize', function () {
	      _this.windowWidth = window.innerWidth;
	      _this.windowHeight = window.innerHeight;
	    });

	    this.popupOver.box.addEventListener('click', function (ev) {
	      var target = ev.target;

	      if (target.matches('.J_linkAction')) {
	        var action = target.getAttribute('data-action');
	        var param = _this.__ToolBtnList.filter(function (btn) {
	          return btn.action === action;
	        })[0].param;

	        param = JSON.stringify(param).replace('${url}', _this.url);

	        _$IMSDKRoot2.default.invoke(action, JSON.parse(param));
	        _this.config.visible = false;
	        _this.render();
	      }
	    });

	    // 窗口滚动隐藏工具条
	    this.container.addEventListener('scroll', function () {
	      if (_this.config.visible) {
	        _this.config.visible = false;
	        _this.render();
	      }
	    });

	    this.container.addEventListener('click', function (ev) {
	      var target = ev.target;

	      if (target.tagName.toUpperCase() === 'A' || target.parentNode && (target = target.parentNode) && target.tagName.toUpperCase() === 'A') {
	        ev.preventDefault();

	        var sf = target.getAttribute('safeflag');
	        var u = target.getAttribute('href');

	        if (u === '#' || u === 'javascript:;') return;

	        if (!sf || sf == 1) {
	          if (_this.config.visible) {
	            _this.config.visible = false;
	            _this.render();
	          }
	          return _sdk2.default.openUrl({ url: u });
	        }

	        var left = ev.pageX;
	        var top = ev.pageY;
	        var BOX_WIDTH = _this.__BOX_WIDTH;
	        var BOX_HEIGHT = _this.__BOX_HEIGHT;
	        var OFFSET = _this.__OFFSET;

	        left = _this.windowWidth - left > BOX_WIDTH + OFFSET ? left + OFFSET : left - BOX_WIDTH - OFFSET > 0 ? left - BOX_WIDTH - OFFSET : _this.windowWidth - BOX_WIDTH - OFFSET;
	        top = _this.windowHeight - top > BOX_HEIGHT + OFFSET ? top + OFFSET : top - BOX_HEIGHT - OFFSET > 0 ? top - BOX_HEIGHT - OFFSET : _this.windowHeight - BOX_HEIGHT - OFFSET;

	        _this.url = u;
	        _this.config.x = left;
	        _this.config.y = top;
	        _this.config.visible = true;
	        _this.config.html = _this.getTpl(sf);

	        _this.render();
	      } else {
	        var _sf = target.getAttribute('safeflag');
	        if (!_sf || _sf == 0) {
	          if (_this.config.visible) {
	            _this.config.visible = false;
	            _this.render();
	          }
	        }
	      }
	    });
	  },
	  setBtnList: function setBtnList(list) {
	    this.__ToolBtnList = list;
	    // 设置过按钮列表后, 需要将模板设为空
	    // 这样下次再显示的时候才能重新获取列表中的元素
	    this.config.html = '';
	  },
	  getTpl: function getTpl(sf) {
	    return (0, _$JuicerRoot2.default)(_template2.default.anchorCheck, {
	      isSafe: sf == 1,
	      btns: this.__ToolBtnList
	    });
	  },
	  render: function render() {
	    this.popupOver.render(this.config);
	  }
	};

	_createPlugin2.default.addPlugin('linkToolBox', LinkToolBox);

	exports.default = LinkToolBox;
	module.exports = exports['default'];

/***/ },
/* 118 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ },
/* 119 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.CANCEL_DOWNLOAD_FILE, function (ev) {
	  var target = ev.target;
	  var parent = _util2.default.parents(target, 'file-msg');

	  if (!parent) return;

	  var param = _util2.default.generatorFileMeta(parent);

	  _sdk2.default.cancelDownloadCloudFile(param);
	}); /**
	     * Created by neitherzhu on 2017/3/31.
	     */

/***/ },
/* 120 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.CANCEL_UPLOAD_FILE, function (ev) {
	  var target = ev.target;
	  var parent = _util2.default.parents(target, 'file-msg');

	  if (!parent) return;

	  var param = _util2.default.generatorFileMeta(parent);

	  _sdk2.default.cancelUploadCloudFile(param);
	}); /**
	     * Created by neitherzhu on 2017/3/31.
	     */

/***/ },
/* 121 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _actions = __webpack_require__(84);

	var _actions2 = _interopRequireDefault(_actions);

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.DOWNLOAD_FILE, function (ev) {
	  var target = ev.target;
	  var parent = _util2.default.parents(target, 'file-msg');
	  if (!parent) return;

	  var param = {};

	  param.cid = _util2.default.getCid(_window2.default.sharedWin.conversationID);
	  param.fileInfo = _util2.default.generatorFileMeta(parent);

	  _sdk2.default.downloadCloudFile(param);

	  if (_window2.default.sharedWin.conversationID.type === _constants2.default.TYPE.SINGLE) {
	    var ignore = target.dataset.ignore === '1';

	    if (ignore) return;

	    var msgParent = _util2.default.parents(target, _constants2.default.CLS.MSG_CONTAINER);
	    if (!msgParent) return;
	    var time = msgParent.dataset.time;

	    _actions2.default.setMsgReadStatus.action(_window2.default.sharedWin.conversationID, [{
	      svrtime: time,
	      msgtime: time,
	      msgid: msgParent.id
	    }]);

	    // 点击下载文件会设置已读, 点击预览也会设置已读,
	    // 点击了这2个按钮的任何一个, 都应该把另外一个也设置不发送已读状态的标记
	    var prevBtn = parent.querySelector('.' + _constants2.default.CLS.PREVIEW_FILE);
	    prevBtn && prevBtn.setAttribute('data-ignore', 1);
	    target.setAttribute('data-ignore', 1);
	  }
	}); /**
	     * Created by neitherzhu on 2017/3/31.
	     */

/***/ },
/* 122 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/3/31.
	 */
	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.OPEN_FILE_FOLDER, function (ev) {
	  var target = ev.target;

	  _sdk2.default.openFolder({
	    filePath: target.dataset.path
	  }).then(function (data) {
	    if (data.subcode === 0x01200004) {
	      target.outerHTML = '<a href="javascript:;" class="download-file J_downloadFile" data-ignore="1">下载文件</a>';
	    }
	  }).catch(function (e) {
	    target.outerHTML = '<a href="javascript:;" class="download-file J_downloadFile" data-ignore="1">下载文件</a>';
	  });
	});

/***/ },
/* 123 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _actions = __webpack_require__(84);

	var _actions2 = _interopRequireDefault(_actions);

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.PREVIEW_FILE, function (ev) {
	  var target = ev.target;
	  var parent = _util2.default.parents(target, 'file-msg');
	  if (!parent) return;

	  var msgParent = _util2.default.parents(target, _constants2.default.CLS.MSG_CONTAINER);
	  if (!msgParent) return;
	  var param = {};
	  param.cid = _util2.default.getCid(_window2.default.sharedWin.conversationID);
	  param.fileInfo = _util2.default.generatorFileMeta(parent);
	  param.fileInfo.msginfo = {
	    msgid: msgParent.id
	  };

	  _sdk2.default.previewCloudFile(param);

	  if (_window2.default.sharedWin.conversationID.type === _constants2.default.TYPE.SINGLE) {
	    var ignore = target.dataset.ignore === '1';

	    if (ignore) return;
	    var time = msgParent.dataset.time;

	    _actions2.default.setMsgReadStatus.action(_window2.default.sharedWin.conversationID, [{
	      svrtime: time,
	      msgtime: time,
	      msgid: msgParent.id
	    }]);

	    // 点击下载文件会设置已读, 点击预览也会设置已读,
	    // 点击了这2个按钮的任何一个, 都应该把另外一个也设置不发送已读状态的标记
	    var prevBtn = parent.querySelector('.' + _constants2.default.CLS.DOWNLOAD_FILE);
	    prevBtn && prevBtn.setAttribute('data-ignore', 1);
	    target.setAttribute('data-ignore', 1);
	  }
	}); /**
	     * Created by neitherzhu on 2017/3/31.
	     */

/***/ },
/* 124 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.OPEN_AUDIO_TEXT_SETTING, function (ev) {
	  _sdk2.default.openSetting('im');
	}); /**
	     * Created by neitherzhu on 2016/12/8.
	     * 点击打开语音转文字设置
	     */

/***/ },
/* 125 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _createPlugin = __webpack_require__(105);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/5/26.
	 */
	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.FACE_TIME_TRIGGER, function (ev) {

	  _sdk2.default.startFaceTime(_window2.default.sharedWin.conversationID);
	});

/***/ },
/* 126 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	__webpack_require__(127);

	__webpack_require__(132);

	var _callbacks = __webpack_require__(38);

	var _callbacks2 = _interopRequireDefault(_callbacks);

	var _link = __webpack_require__(56);

	var _link2 = _interopRequireDefault(_link);

	var _image = __webpack_require__(112);

	var _image2 = _interopRequireDefault(_image);

	var _audio = __webpack_require__(114);

	var _audio2 = _interopRequireDefault(_audio);

	var _atmsg = __webpack_require__(135);

	var _atmsg2 = _interopRequireDefault(_atmsg);

	var _dynamicMsg = __webpack_require__(61);

	var _dynamicMsg2 = _interopRequireDefault(_dynamicMsg);

	var _file = __webpack_require__(136);

	var _file2 = _interopRequireDefault(_file);

	function _interopRequireDefault(obj) {
	                                                           return obj && obj.__esModule ? obj : { default: obj };
	}

	_callbacks2.default.setCallbacks('link', _link2.default); /**
	                                                           * Created by neitherzhu on 2017/1/2.
	                                                           */

	_callbacks2.default.setCallbacks('image', _image2.default);
	_callbacks2.default.setCallbacks('audio', _audio2.default);
	_callbacks2.default.setCallbacks('atmsg', _atmsg2.default);
	_callbacks2.default.setCallbacks('dynamicMsg', _dynamicMsg2.default);
	_callbacks2.default.setCallbacks('file', _file2.default);

/***/ },
/* 127 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	__webpack_require__(128);

	__webpack_require__(131);

/***/ },
/* 128 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$BaseRoot = __webpack_require__(3);

	var _convert = __webpack_require__(36);

	var _convert2 = _interopRequireDefault(_convert);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _normalMsgFormater = __webpack_require__(39);

	var _normalMsgFormater2 = _interopRequireDefault(_normalMsgFormater);

	var _callbacks = __webpack_require__(38);

	var _callbacks2 = _interopRequireDefault(_callbacks);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _degrade = __webpack_require__(129);

	var _degrade2 = _interopRequireDefault(_degrade);

	var _facetime = __webpack_require__(130);

	var _facetime2 = _interopRequireDefault(_facetime);

	var _defaultParse = __webpack_require__(62);

	var _defaultParse2 = _interopRequireDefault(_defaultParse);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var Util = _$BaseRoot.Base.Util; /**
	                                  * Created by neitherzhu on 2017/1/2.
	                                  */

	_convert2.default.add('chat', [0, 2, 3, 12, 13, 65648 /*多态卡片*/, 65649 /*文件消息*/, 65536 /*模板消息*/], 'normalMsg', {
	  format: _normalMsgFormater2.default,

	  Tpl: _template2.default.normalMsg,

	  extra: function extra(callback, dom, data) {
	    var defaultCallback = _callbacks2.default.getCallbacks('DEFAULT');
	    defaultCallback && defaultCallback.length && defaultCallback.forEach(function (cb) {
	      cb(data);
	    });

	    if (!data.typeList || !data.typeList.length) {
	      return;
	    }

	    data.typeList.forEach(function (ot) {
	      if (_callbacks2.default.getCallbacks(ot.type)) {
	        _callbacks2.default.getCallbacks(ot.type).forEach(function (cb) {
	          try {
	            cb.call(null, ot.extra, callback);
	          } catch (e) {
	            console.error('in extra error', e);
	          }
	          ;
	        });
	      }
	    });
	  }
	});

	// 自动回复
	_convert2.default.add('chat', 1, 'autoReplyMsg', {
	  extra: function extra(callback, dom, data) {
	    var defaultCallback = _callbacks2.default.getCallbacks('DEFAULT');
	    defaultCallback && defaultCallback.length && defaultCallback.forEach(function (cb) {
	      cb(data);
	    });

	    if (!data.typeList || !data.typeList.length) {
	      return;
	    }

	    data.typeList.forEach(function (ot) {
	      if (_callbacks2.default.getCallbacks(ot.type)) {
	        _callbacks2.default.getCallbacks(ot.type).forEach(function (cb) {
	          try {
	            cb.call(null, ot.extra, callback);
	          } catch (e) {
	            console.error('in extra error', e);
	          }
	          ;
	        });
	      }
	    });
	  },
	  format: function format(msg) {
	    var result = (0, _normalMsgFormater2.default)(msg);
	    // 排除自己的自动回复消息
	    if (Util.getUid(result.from) !== Util.getUid(_window2.default.sharedWin.loginID)) {
	      result.html && (result.html = '<span class="auto-reply-text">[自动回复]</span>' + result.html + '<a href="javascript:;" class="auto-reply-tip J_stopAutoReply">不再提醒</a>');
	    }
	    return result;
	  },

	  Tpl: _template2.default.normalMsg
	});

	_convert2.default.add('chat', 14, 'degradeMsg', {
	  format: _degrade2.default,
	  Tpl: _template2.default.normalMsg
	});

	_convert2.default.add('chat', 16, 'facetime', {
	  format: _facetime2.default,
	  Tpl: _template2.default.normalMsg
	});

	_convert2.default.add('chat', 65602 /*自定义消息*/, 'customMsg', {
	  format: function format(msg) {
	    var result = (0, _defaultParse2.default)(msg);

	    if (!result) return;

	    var ret = '';
	    var bodyHtml = '';
	    // 防止有多条降级消息 跟客户端的逻辑保持一致，只取第一条
	    var mb = msg.msgbody && msg.msgbody.length && msg.msgbody[0];

	    // 对红包消息特定解析
	    try {
	      if (mb.type === 66) {
	        ret = JSON.parse(mb.value);
	        bodyHtml = '<i class="icon-sysmsg-hongbao"></i>$1<span class="u-syshongbao J_msg_Syshongbao" \n                  data-action="https://alimarket.m.taobao.com/markets/qnww/hongbao?ActionExtraParam=wangwang://hongbao/query?hongbaoId=' + ret.internal.hongbao_id + '&hongbaoType=' + ret.internal.hongbaoType + '&sender=' + ret.internal.hongbaoSender + '">\u7EA2\u5305</span>';

	        result.html = ret.header.summary.replace(/(.*)红包/, '' + bodyHtml);
	        return result;
	      }
	    } catch (err) {
	      return false;
	    }

	    return result;
	  },
	  Tpl: _template2.default.systemMsg
	});

/***/ },
/* 129 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _defaultParse = __webpack_require__(62);

	var _defaultParse2 = _interopRequireDefault(_defaultParse);

	var _link = __webpack_require__(40);

	var _link2 = _interopRequireDefault(_link);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/4/5.
	 */
	exports.default = function (msg) {
	  var result = (0, _defaultParse2.default)(msg);
	  if (!result) return;

	  var text = _constants2.default.I18N[_constants2.default.LANGUAGE].DEGRADE;
	  if (msg.msgbody && msg.msgbody.length && msg.msgbody[0].value) {
	    text = msg.msgbody[0].value;

	    if (!msg.msgbody[0].jvale) {
	      var temp = '';
	      var changed = false;
	      _sdk2.default.convertMsgToEmotion({
	        value: text,
	        type: 0,
	        jvale: '',
	        strDegradeText: '',
	        msgType: 14
	      }).then(function (data) {
	        if (data && data.length) {
	          data.forEach(function (m) {
	            if (m.type === 0) {
	              changed = true;
	              m.jvale = JSON.parse(m.jvale);
	              temp += (0, _link2.default)(m, msg);
	            }
	          });

	          if (changed) {
	            var el = document.getElementById('J_degrade_' + msg.msgid);
	            el && (el.innerHTML = temp);
	          }
	        }
	      });
	    }
	  }

	  result.html = (0, _$JuicerRoot2.default)(_template2.default.degrade, { text: text, id: msg.msgid });

	  return result;
	};

	module.exports = exports['default'];

/***/ },
/* 130 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _defaultParse = __webpack_require__(62);

	var _defaultParse2 = _interopRequireDefault(_defaultParse);

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _util = __webpack_require__(53);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = function (msg) {
	  var result = (0, _defaultParse2.default)(msg);

	  if (msg.msgbody) {

	    var data = {};
	    var duration = '';

	    switch (msg.msgbody.type) {
	      case 1:
	        data.text = _constants2.default.I18N[_constants2.default.LANGUAGE].FACE_TIME_NOT_ACCEPT;
	        break;
	      case 2:
	        data.text = _constants2.default.I18N[_constants2.default.LANGUAGE].FACE_TIME_NOT_ACCEPTED;
	        break;
	      case 3:
	        duration = _util2.default.getDuration(msg.msgbody.duration);
	        data.text = _constants2.default.I18N[_constants2.default.LANGUAGE].FACE_TIME_FINISH + ' ' + duration;
	        break;
	    }

	    data.trigger = _constants2.default.I18N[_constants2.default.LANGUAGE].FACE_TIME_TRIGGER;
	    result.html = (0, _$JuicerRoot2.default)(_template2.default.facetime, data);
	  }

	  return result;
	}; /**
	    * Created by neitherzhu on 2017/5/26.
	    */

	module.exports = exports['default'];

/***/ },
/* 131 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _convert = __webpack_require__(36);

	var _convert2 = _interopRequireDefault(_convert);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _shake = __webpack_require__(67);

	var _shake2 = _interopRequireDefault(_shake);

	var _file = __webpack_require__(68);

	var _file2 = _interopRequireDefault(_file);

	var _chat = __webpack_require__(69);

	var _chat2 = _interopRequireDefault(_chat);

	var _video = __webpack_require__(70);

	var _video2 = _interopRequireDefault(_video);

	var _remoteAssistance = __webpack_require__(71);

	var _remoteAssistance2 = _interopRequireDefault(_remoteAssistance);

	var _appSys = __webpack_require__(72);

	var _appSys2 = _interopRequireDefault(_appSys);

	var _msgRecall = __webpack_require__(73);

	var _msgRecall2 = _interopRequireDefault(_msgRecall);

	var _audio2text = __webpack_require__(81);

	var _audio2text2 = _interopRequireDefault(_audio2text);

	var _defaultSystemMsg = __webpack_require__(82);

	var _defaultSystemMsg2 = _interopRequireDefault(_defaultSystemMsg);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	_convert2.default.add('chat', [4, 5, 6, 7, 8, 9, 10002, 10000, 10001], 'systemMsg', {
	  format: function format(msg) {
	    var type = msg.msgtype;
	    var result = void 0;

	    if (type == 4) {
	      // 震屏系统消息
	      result = (0, _shake2.default)(msg);
	    } else if (type === 5) {
	      // 文件系统消息
	      result = (0, _file2.default)(msg);
	    } else if (type === 6) {
	      // 语音聊天系统消息
	      result = (0, _chat2.default)(msg);
	    } else if (type === 7) {
	      // 视频聊天系统消息
	      result = (0, _video2.default)(msg);
	    } else if (type === 8) {
	      // 远程协助系统消息
	      result = (0, _remoteAssistance2.default)(msg);
	    } else if (type === 9) {
	      // 应用系统消息, 比如发送 qq
	      result = (0, _appSys2.default)(msg);
	    } else if (type === 10000) {
	      result = (0, _msgRecall2.default)(msg);
	    } else if (type === 10002) {
	      result = (0, _audio2text2.default)(msg);
	    } else if (type === 10001) {
	      result = (0, _defaultSystemMsg2.default)(msg);
	    }
	    result = _convert2.default.injectSystemFormat(msg, result);

	    return result;
	  },

	  Tpl: _template2.default.systemMsg
	});

	// 需要对语音转文字系统消息做特殊处理，将一条消息拆成2条
	/**
	 * Created by neitherzhu on 2017/1/2.
	 */
	_convert2.default.add('chat', 15, 'audioToTextSystemMsg', {
	  format: function format(msg) {
	    var html = '';
	    msg.msgtype = 10002;
	    msg.omsgid = msg.msgid;
	    msg.msgid = msg.omsgid + '_s1';
	    html += _convert2.default.convert('chat', msg, 'msgtype').html;
	    msg.audioText = 1;
	    delete msg.ignore;
	    msg.msgid = msg.omsgid + '_s2';
	    html += _convert2.default.convert('chat', msg, 'msgtype').html;
	    msg.html = html;
	    msg.msgid = msg.omsgid;
	    delete msg.ignore;
	    return msg;
	  },

	  Tpl: '<div class="J_msg" id="${msgid}" data-time="${msgtime}">$${html}</div>'
	});

/***/ },
/* 132 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	__webpack_require__(133);

	__webpack_require__(134);

/***/ },
/* 133 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _convert = __webpack_require__(36);

	var _convert2 = _interopRequireDefault(_convert);

	var _normalMsgFormater = __webpack_require__(39);

	var _normalMsgFormater2 = _interopRequireDefault(_normalMsgFormater);

	var _callbacks = __webpack_require__(38);

	var _callbacks2 = _interopRequireDefault(_callbacks);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _degrade = __webpack_require__(129);

	var _degrade2 = _interopRequireDefault(_degrade);

	var _defaultParse = __webpack_require__(62);

	var _defaultParse2 = _interopRequireDefault(_defaultParse);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2016/12/6.
	 * 群普通消息解析
	 */
	_convert2.default.add('tribe', [0, 65648 /*多态卡片*/, 65649 /*文件消息*/, 65536 /*模板消息*/], 'normalMsg', {
	  format: _normalMsgFormater2.default,

	  Tpl: _template2.default.normalMsg,

	  extra: function extra(callback, dom, data) {
	    if (!data.typeList || !data.typeList.length) return;

	    data.typeList.forEach(function (ot) {
	      if (_callbacks2.default.getCallbacks(ot.type)) {
	        _callbacks2.default.getCallbacks(ot.type).forEach(function (cb) {
	          try {
	            cb.call(null, ot.extra, callback);
	          } catch (e) {
	            console.error('in extra error', e);
	          }
	          ;
	        });
	      }
	    });
	  }
	});

	_convert2.default.add('tribe', 14, 'degradeMsg', {
	  format: _degrade2.default,
	  Tpl: _template2.default.normalMsg
	});

	_convert2.default.add('tribe', 65602 /*自定义消息*/, 'customMsg', {
	  format: function format(msg) {
	    var result = (0, _defaultParse2.default)(msg);

	    if (!result) return;

	    var ret = '';
	    var bodyHtml = '';
	    // 防止有多条降级消息 跟客户端的逻辑保持一致，只取第一条
	    var mb = msg.msgbody && msg.msgbody.length && msg.msgbody[0];

	    // 对红包消息特定解析
	    try {
	      if (mb.type === 66) {
	        ret = JSON.parse(mb.value);
	        bodyHtml = '<i class="icon-sysmsg-hongbao"></i>$1<span class="u-syshongbao J_msg_Syshongbao" \n                  data-action="https://alimarket.m.taobao.com/markets/qnww/hongbao?ActionExtraParam=wangwang://hongbao/query?hongbaoId=' + ret.internal.hongbao_id + '&hongbaoType=' + ret.internal.hongbaoType + '&sender=' + ret.internal.hongbaoSender + '">\u7EA2\u5305</span>';

	        result.html = ret.header.summary.replace(/(.*)红包/, '' + bodyHtml);
	        return result;
	      }
	    } catch (err) {
	      return false;
	    }

	    return result;
	  },
	  Tpl: _template2.default.systemMsg
	});

/***/ },
/* 134 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _convert = __webpack_require__(36);

	var _convert2 = _interopRequireDefault(_convert);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _exitTribe = __webpack_require__(74);

	var _exitTribe2 = _interopRequireDefault(_exitTribe);

	var _kickoutTribe = __webpack_require__(75);

	var _kickoutTribe2 = _interopRequireDefault(_kickoutTribe);

	var _joinTribe = __webpack_require__(76);

	var _joinTribe2 = _interopRequireDefault(_joinTribe);

	var _roleChange = __webpack_require__(77);

	var _roleChange2 = _interopRequireDefault(_roleChange);

	var _exitDiscussion = __webpack_require__(78);

	var _exitDiscussion2 = _interopRequireDefault(_exitDiscussion);

	var _joinDiscussion = __webpack_require__(79);

	var _joinDiscussion2 = _interopRequireDefault(_joinDiscussion);

	var _displayNameChange = __webpack_require__(80);

	var _displayNameChange2 = _interopRequireDefault(_displayNameChange);

	var _msgRecall = __webpack_require__(73);

	var _msgRecall2 = _interopRequireDefault(_msgRecall);

	var _multiJoin = __webpack_require__(83);

	var _multiJoin2 = _interopRequireDefault(_multiJoin);

	var _audio2text = __webpack_require__(81);

	var _audio2text2 = _interopRequireDefault(_audio2text);

	var _defaultSystemMsg = __webpack_require__(82);

	var _defaultSystemMsg2 = _interopRequireDefault(_defaultSystemMsg);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	_convert2.default.add('tribe', 1, 'ExitTribe', {
	  format: _exitTribe2.default,

	  Tpl: _template2.default.systemMsg
	});

	// 踢出群
	/**
	 * Created by neitherzhu on 2016/12/6.
	 */
	_convert2.default.add('tribe', 2, 'KickOutTribe', {
	  format: _kickoutTribe2.default,

	  Tpl: _template2.default.systemMsg
	});

	// 加入群
	_convert2.default.add('tribe', 3, 'JoinTribe', {
	  format: _joinTribe2.default,

	  Tpl: _template2.default.systemMsg
	});

	// 群角色变更
	_convert2.default.add('tribe', 4, 'RoleChange', {
	  format: _roleChange2.default,

	  Tpl: _template2.default.systemMsg
	});

	// 退出讨论组
	_convert2.default.add('tribe', 5, 'ExitDiscussion', {
	  format: _exitDiscussion2.default,

	  Tpl: _template2.default.systemMsg
	});

	// 加入讨论组
	_convert2.default.add('tribe', 6, 'JoinDiscussion', {
	  format: _joinDiscussion2.default,

	  Tpl: _template2.default.systemMsg
	});

	_convert2.default.add('tribe', 7, 'DisplayNameChange', {
	  format: _displayNameChange2.default,
	  Tpl: _template2.default.systemMsg
	});

	_convert2.default.add('tribe', 8, 'MultJoin', {
	  format: _multiJoin2.default,
	  Tpl: _template2.default.systemMsg
	});

	_convert2.default.add('tribe', 10000, 'MsgRecall', {
	  format: _msgRecall2.default,
	  Tpl: _template2.default.systemMsg
	});

	_convert2.default.add('tribe', 10001, 'DefaultSystemMsg', {
	  format: _defaultSystemMsg2.default,
	  Tpl: _template2.default.systemMsg
	});

	_convert2.default.add('tribe', 10002, 'audioToText', {
	  format: _audio2text2.default,
	  Tpl: _template2.default.systemMsg
	});

	// 需要对语音转文字系统消息做特殊处理，将一条消息拆成2条
	_convert2.default.add('tribe', 15, 'audioToTextSystemMsg', {
	  format: function format(msg) {
	    var html = '';
	    msg.msgtype = 10002;
	    msg.omsgid = msg.msgid;
	    msg.msgid = msg.omsgid + '_s1';
	    html += _convert2.default.convert('chat', msg, 'msgtype').html;
	    msg.audioText = 1;
	    delete msg.ignore;
	    msg.msgid = msg.omsgid + '_s2';
	    html += _convert2.default.convert('chat', msg, 'msgtype').html;
	    msg.html = html;
	    msg.msgid = msg.omsgid;
	    delete msg.ignore;
	    return msg;
	  },

	  Tpl: '<div class="J_msg" id="${msgid}" data-time="${msgtime}">$${html}</div>'
	});

/***/ },
/* 135 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (extra, callback) {

	  // 如果是-1(to be at memebers) -2(to be at all),
	  // 需要缓存消息id, 等消息状态变更事件回来时,再判断是否是真正的@消息
	  // 极限情况下, 会先收到消息发送成功的事件,再获取到新消息,
	  // 导致此条@消息不再去获取已读未读状态
	  // 故改成如果是待确认的, 仍然去获取一次
	  if (extra.atmsgtype < 0) {
	    var d = {};

	    d[extra.msgid] = 1;

	    Cache.set('TO_BE_AT_MSG', d);
	  }

	  // 如果是我@的消息, 放到待获取已读未读人数列表中
	  if (extra.atmsgtype < 0 || extra.relation2me == 1) {
	    cacheToGetRead.push({
	      userid: _window2.default.sharedWin.loginID,
	      msgid: extra.msgid
	    });
	  }
	  // 如果是@我的消息, 放到待设置已读状态列表中
	  else if (extra.relation2me == 2) {
	      cacheToSetRead.push(extra);
	    }

	  clearTimeout(timer);

	  // 防止频繁的发送, 过一段时间后再发送
	  timer = setTimeout(function () {

	    if (cacheToSetRead) {
	      _actions2.default.setAtMsgReadState.action(extra.cid, cacheToSetRead);
	      cacheToSetRead = [];
	    }

	    if (cacheToGetRead.length) {
	      _actions2.default.getAtMsgReadState.spliceAfterOnce(0, 0, function (context, data) {
	        cacheToGetRead = [];

	        if (callback && !callback(data)) return false;
	      });

	      _actions2.default.getAtMsgReadState.action(extra.cid, cacheToGetRead);
	    }
	  }, 30);
	};

	var _$BaseRoot = __webpack_require__(3);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _actions = __webpack_require__(84);

	var _actions2 = _interopRequireDefault(_actions);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	var Cache = _$BaseRoot.Base.Cache; /**
	                                    * Created by neitherzhu on 2016/12/6.
	                                    * 群@消息 处理已读未读
	                                    */

	var cacheToSetRead = [];
	var cacheToGetRead = [];
	var timer = null;

	module.exports = exports['default'];

/***/ },
/* 136 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	exports.default = function (extra, callback) {

	  if (!extra) return;

	  _sdk2.default.getFileTransferInfo(extra).then(function (data) {
	    if (!data || !data.result) return;

	    (0, _fileParse2.default)(extra.id, data.result);
	  });
	};

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _$BaseRoot = __webpack_require__(3);

	var _fileParse = __webpack_require__(96);

	var _fileParse2 = _interopRequireDefault(_fileParse);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	/**
	 * Created by neitherzhu on 2017/3/29.
	 */
	module.exports = exports['default'];

/***/ },
/* 137 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ },
/* 138 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var NativeInvoke = _$IMSDKRoot2.default.invoke;
	var Log = _$BaseRoot.Base.Log;


	if (!_$IMSDKRoot2.default.overwrited) {
	  // 重写invoke方法,统一打印通过接口获取到的数据
	  _$IMSDKRoot2.default.invoke = function () {
	    var args = Array.prototype.slice.call(arguments);

	    Log.blue('调用：', args[0], '参数：', args[1]);
	    return new Promise(function (resolve, reject) {
	      NativeInvoke.apply(NativeInvoke, args).then(function (data) {
	        Log.green(args[0], '返回成功：', data);
	        resolve(data);
	      }).catch(function (err) {
	        Log.red(args[0], '返回失败：', err);
	        reject(err);
	      });
	    });
	  };
	  _$IMSDKRoot2.default.overwrited = true;
	}

	exports.default = {
	  /**
	   * 获取当前登录的ID
	   * @param param
	   * @returns {Promise}
	   */
	  getCurrentLoginID: function getCurrentLoginID(param) {

	    return new Promise(function (resolve, reject) {
	      _$IMSDKRoot2.default.invoke(_constants2.default.SDK.GET_CURRENT_LOGIN_ID, param).then(function (data) {
	        resolve(data.result);
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },


	  /**
	   * 获取当前聊天的对象ID
	   * @param param
	   * @returns {Promise}
	   */
	  getCurrentConversationID: function getCurrentConversationID(param) {

	    return new Promise(function (resolve, reject) {
	      _$IMSDKRoot2.default.invoke(_constants2.default.SDK.GET_CURRENT_CONVERSATION_ID, param).then(function (data) {
	        resolve(data.result);
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },


	  /**
	   * 获取离线消息
	   * @param param
	   * @returns {Promise}
	   */
	  getOfflineMsg: function getOfflineMsg(param) {
	    var suffix = '';
	    if (_window2.default.conversationID.type === _constants2.default.SCENETYPE.TAOBAO) {
	      suffix = _constants2.default.TaobaoSDK.GET_OFFLINE_MSG_SUFFIX;
	    } else {
	      suffix = _constants2.default.SDK.GET_OFFLINE_MSG_SUFFIX;
	    }

	    return new Promise(function (resolve, reject) {
	      _$IMSDKRoot2.default.invoke(_constants2.default.Other.SDK_PREFIX_MAP[_window2.default.conversationID.type] + suffix, param).then(function (data) {
	        resolve(data.result);
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },


	  /**
	   * 获取在线未读消息
	   * @param param
	   * @returns {Promise}
	   */
	  getNewMsg: function getNewMsg(param) {
	    return new Promise(function (resolve, reject) {
	      var suffix = '';
	      if (_window2.default.conversationID.type === _constants2.default.SCENETYPE.TAOBAO) {
	        suffix = _constants2.default.TaobaoSDK.GET_NEW_MSG_SUFFIX;
	      } else {
	        suffix = _constants2.default.SDK.GET_NEW_MSG_SUFFIX;
	      }

	      _$IMSDKRoot2.default.invoke(_constants2.default.Other.SDK_PREFIX_MAP[_window2.default.conversationID.type] + suffix, param).then(function (data) {
	        resolve(data.result);
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },


	  /**
	   * 获取本地历史消息
	   * @param param
	   * @returns {Promise}
	   */
	  getLocalHistoryMsg: function getLocalHistoryMsg(param) {
	    return new Promise(function (resolve, reject) {
	      var suffix = '';
	      if (_window2.default.conversationID.type === _constants2.default.SCENETYPE.TAOBAO) {
	        suffix = _constants2.default.TaobaoSDK.GET_LOCAL_HISTORY_MSG_SUFFIX;
	      } else {
	        suffix = _constants2.default.SDK.GET_LOCAL_HISTORY_MSG_SUFFIX;
	      }

	      _$IMSDKRoot2.default.invoke(_constants2.default.Other.SDK_PREFIX_MAP[_window2.default.conversationID.type] + suffix, param).then(function (data) {
	        resolve(data.result);
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },


	  /**
	   * 获取漫游历史消息
	   * @param param
	   * @returns {Promise}
	   */
	  getRemoteHistoryMsg: function getRemoteHistoryMsg(param) {
	    return new Promise(function (resolve, reject) {
	      var suffix = '';
	      if (_window2.default.conversationID.type === _constants2.default.SCENETYPE.TAOBAO) {
	        suffix = _constants2.default.TaobaoSDK.GET_REMOTE_HISTORY_MSG_SUFFIX;
	      } else {
	        suffix = _constants2.default.SDK.GET_REMOTE_HISTORY_MSG_SUFFIX;
	      }

	      _$IMSDKRoot2.default.invoke(_constants2.default.Other.SDK_PREFIX_MAP[_window2.default.conversationID.type] + suffix, param).then(function (data) {
	        resolve(data.result);
	      }).catch(function (err) {
	        reject(err);
	      });
	    });
	  },


	  /**
	   * 停止接收自动回复消息
	   * @param param
	   */
	  stopAutoReply: function stopAutoReply(param) {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK.STOP_AUTO_REPLY, param);
	  },


	  /**
	   * 重发消息
	   * @param param
	   */
	  resendMsg: function resendMsg(param) {
	    var suffix = '';
	    if (_window2.default.conversationID.type === _constants2.default.SCENETYPE.TAOBAO) {
	      suffix = _constants2.default.TaobaoSDK.RESEND_MSG_SUFFIX;
	    } else {
	      suffix = _constants2.default.SDK.RESEND_MSG_SUFFIX;
	    }

	    _$IMSDKRoot2.default.invoke(_constants2.default.Other.SDK_PREFIX_MAP[_window2.default.conversationID.type] + suffix, param);
	  },


	  /**
	   * 撤回消息
	   * @param param
	   */
	  recallMsg: function recallMsg(param) {
	    _$IMSDKRoot2.default.invoke(_constants2.default.Other.SDK_PREFIX_MAP[_window2.default.conversationID.type] + _constants2.default.SDK.RECALL_MSG_SUFFIX, param);
	  },


	  /**
	   * 获取服务器时间
	   */
	  getServerTime: function getServerTime() {
	    return _$IMSDKRoot2.default.invoke(_constants2.default.SDK.GET_SERVER_TIME);
	  },


	  /**
	   * 停止播放语音
	   */
	  stopAudio: function stopAudio() {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK.STOP_AUDIO_PLAYER);
	  },


	  /**
	   * 复制
	   * @param param
	   */
	  copy: function copy(param) {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK.COPY, param);
	  },


	  /**
	   * 转发消息
	   * @param param
	   */
	  forwardMsg: function forwardMsg(param) {
	    _$IMSDKRoot2.default.invoke(_constants2.default.SDK.MSG_FORWARD, param);
	  }
	};

/***/ },
/* 139 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _event = __webpack_require__(140);

	var _event2 = _interopRequireDefault(_event);

	var _taobao = __webpack_require__(142);

	var _taobao2 = _interopRequireDefault(_taobao);

	var _sdk = __webpack_require__(143);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _taobao3 = __webpack_require__(145);

	var _taobao4 = _interopRequireDefault(_taobao3);

	var _cls = __webpack_require__(146);

	var _cls2 = _interopRequireDefault(_cls);

	var _elid = __webpack_require__(147);

	var _elid2 = _interopRequireDefault(_elid);

	var _i18n = __webpack_require__(148);

	var _i18n2 = _interopRequireDefault(_i18n);

	var _language = __webpack_require__(149);

	var _language2 = _interopRequireDefault(_language);

	var _bubbleMenu = __webpack_require__(150);

	var _bubbleMenu2 = _interopRequireDefault(_bubbleMenu);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var SINGLE = 1;
	var TRIBE = 2;
	var DISCUSSION = 3;
	var TYPE = {
	  SINGLE: SINGLE,
	  TRIBE: TRIBE,
	  DISCUSSION: DISCUSSION
	};

	var SCENETYPE = {
	  'TAOBAO': 4
	};

	exports.default = {
	  LANGUAGE: _language2.default,
	  Event: _event2.default,
	  TaobaoEvent: _taobao2.default,
	  SDK: _sdk2.default,
	  TaobaoSDK: _taobao4.default,
	  CLS: _cls2.default,
	  EL_ID: _elid2.default,
	  I18N: _i18n2.default,
	  SCENETYPE: SCENETYPE,
	  Other: {
	    TYPE: TYPE,
	    fetchMsgCount: 20,
	    SDK_PREFIX_MAP: {
	      1: _sdk2.default.SINGLE_SDK_PREFIX,
	      2: _sdk2.default.TRIBE_SDK_PREFIX,
	      3: _sdk2.default.TRIBE_SDK_PREFIX,
	      4: _taobao4.default.TRIBE_SDK_PREFIX
	    }
	  },
	  RECALL_LIMIT: 120000,
	  BUBBLE_MENU: _bubbleMenu2.default,
	  SCROLL_DELAY: 300
	};

/***/ },
/* 140 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _base = __webpack_require__(141);

	var _base2 = _interopRequireDefault(_base);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	exports.default = Object.assign({
	  // 发送的群聊/讨论组消息状态变更
	  TRIBE_SEND_MSG_STATUS_CHANGE: 'im.tribemsg.onSendMsgStatus',

	  // 收到群聊/讨论组消息
	  TRIBE_RECEIVE_MSG: 'im.tribemsg.onReceiveNewMsg',

	  // 发送群聊/讨论组消息
	  TRIBE_SEND_MSG: 'im.tribemsg.onSendNewMsg'
	}, _base2.default); /**
	                     * 千牛接受消息事件
	                     *
	                     * @author:   罗嗣(｡･∀･)ﾉﾞ <fangbo.fb@alibaba-inc.com>
	                     * @create:   2017-09-09  下午5:56
	                     */

/***/ },
/* 141 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	exports.default = {
	  // 一些事件的前缀
	  CONVERSATION_PREFIX: 'im.uiutil.',
	  // 新增聊天对象 一般与CONVERSATION_PREFIX合并起来组成一个完整的事件
	  CONVERSATION_ADD_SUFFIX: 'onConversationAdd',
	  // 聊天对象变更  一般与CONVERSATION_PREFIX合并起来组成一个完整的事件
	  CONVERSATION_CHANGE_SUFFIX: 'onConversationChange',
	  // 聊天对象关闭  一般与CONVERSATION_PREFIX合并起来组成一个完整的事件
	  CONVERSATION_CLOSE_SUFFIX: 'onConversationClose',
	  // 断网
	  NET_DISCONNECT: 'im.login.onNetDisConnect',
	  // 网络重连
	  NET_RECONNECT: 'im.login.onNetReConnectOK',
	  // 收到单聊消息
	  CHAT_RECEIVE_MSG: 'im.singlemsg.onReceiveNewMsg',
	  // 发送单聊消息
	  CHAT_SEND_MSG: 'im.singlemsg.onSendNewMsg',
	  // 发送的单聊消息状态变更
	  CHAT_SEND_MSG_STATUS_CHANGE: 'im.singlemsg.onSendMsgStatus',

	  // 群/讨论组@消息已读未读状态变更
	  TRIBE_AT_MSG_READ: 'im.tribemsg.onTribeAtMsgReaded',
	  // 输入状态变更
	  INPUT_STATUS_CHANGE: 'im.singlemsg.onPeerInputNotify',
	  // 单聊消息撤回事件
	  CHAT_MSG_RECALLED: 'im.singlemsg.onMsgWithdrawNty',
	  // 群聊/讨论组消息撤回事件
	  TRIBE_MSG_RECALLED: 'im.tribemsg.onMsgWithdrawNty',
	  // 一些自定义事件
	  // 开始变更聊天对象
	  CONVERSATION_CHANGE_START: 'conversationChangeStart',
	  // 聊天对象变更结束
	  CONVERSATION_CHANGE_OVER: 'conversationChangeOver',
	  // 网络错误
	  NET_ERROR: 'netError',
	  // 发送消息状态变更
	  SEND_MSG_STATUS_CHANGE: 'sendMsgStatusChange'
	};

/***/ },
/* 142 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _base = __webpack_require__(141);

	var _base2 = _interopRequireDefault(_base);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	exports.default = Object.assign({
	  // 发送的群聊/讨论组消息状态变更
	  TRIBE_SEND_MSG_STATUS_CHANGE: 'im.amptribemsg.onAMPSendMsgStatus',

	  // 收到群聊/讨论组消息
	  TRIBE_RECEIVE_MSG: 'im.amptribemsg.onReceiveNewMsg',

	  // 发送群聊/讨论组消息
	  TRIBE_SEND_MSG: 'im.amptribemsg.onSendNewMsg'
	}, _base2.default);

/***/ },
/* 143 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _base = __webpack_require__(144);

	var _base2 = _interopRequireDefault(_base);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	exports.default = Object.assign({

	  // 群聊/讨论组相关接口的前缀
	  TRIBE_SDK_PREFIX: 'im.tribemsg.',
	  // 获取离线消息, 一般与单聊/群聊/讨论组相关接口的前缀一起组成完整接口名称使用
	  GET_OFFLINE_MSG_SUFFIX: 'GetOfflineMsg',
	  // 获取实时收到的消息, 一般与单聊/群聊/讨论组相关接口的前缀一起组成完整接口名称使用
	  GET_NEW_MSG_SUFFIX: 'GetNewMsg',
	  // 获取本地DB的历史消息, 一般与单聊/群聊/讨论组相关接口的前缀一起组成完整接口名称使用
	  GET_LOCAL_HISTORY_MSG_SUFFIX: 'GetLocalHisMsg',
	  // 获取服务端漫游的历史消息, 一般与单聊/群聊/讨论组相关接口的前缀一起组成完整接口名称使用
	  GET_REMOTE_HISTORY_MSG_SUFFIX: 'GetRemoteHisMsg',
	  // 消息重发, 一般与单聊/群聊/讨论组相关接口的前缀一起组成完整接口名称使用
	  RESEND_MSG_SUFFIX: 'FastReSendChatMsg'

	}, _base2.default); /**
	                     * sdk 千牛发送消息事件
	                     *
	                     * @author:   罗嗣(｡･∀･)ﾉﾞ <fangbo.fb@alibaba-inc.com>
	                     * @create:   2017-09-09  下午6:01
	                     */

/***/ },
/* 144 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	/**
	 * Created by neitherzhu on 2016/12/6.
	 * SDK接口列表
	 */
	exports.default = {
	  // 单聊消息相关接口的前缀
	  SINGLE_SDK_PREFIX: 'im.singlemsg.',
	  // 获取当前登录用户
	  GET_CURRENT_LOGIN_ID: 'im.login.GetCurrentLoginID',
	  // 获取当前聊天对象
	  GET_CURRENT_CONVERSATION_ID: 'im.uiutil.GetCurrentConversationID',
	  // 停止接收自动回复消息
	  STOP_AUTO_REPLY: 'im.singlemsg.ShieldAutoReply',
	  // 消息撤回
	  RECALL_MSG_SUFFIX: 'DoChatMsgWithdraw',
	  // 获取服务器时间
	  GET_SERVER_TIME: 'im.bizutil.GetIMSvrTime',
	  // 停止播放语音
	  STOP_AUDIO_PLAYER: 'im.bizutil.StopAudio',
	  // 复制
	  COPY: 'im.bizutil.CopyToClipboard',
	  // 转发
	  MSG_FORWARD: 'im.bizutil.ForwardChatMsg'
	};

/***/ },
/* 145 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _base = __webpack_require__(144);

	var _base2 = _interopRequireDefault(_base);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	exports.default = Object.assign({

	  // 群聊/讨论组相关接口的前缀
	  TRIBE_SDK_PREFIX: 'im.amptribemsg.',
	  // 获取离线消息, 一般与单聊/群聊/讨论组相关接口的前缀一起组成完整接口名称使用
	  GET_OFFLINE_MSG_SUFFIX: 'GetOfflineMsg',
	  // 获取实时收到的消息, 一般与单聊/群聊/讨论组相关接口的前缀一起组成完整接口名称使用
	  GET_NEW_MSG_SUFFIX: 'GetNewMsg',
	  // 获取本地DB的历史消息, 一般与单聊/群聊/讨论组相关接口的前缀一起组成完整接口名称使用
	  GET_LOCAL_HISTORY_MSG_SUFFIX: 'GetLocalHisMsg',
	  // 获取服务端漫游的历史消息, 一般与单聊/群聊/讨论组相关接口的前缀一起组成完整接口名称使用
	  GET_REMOTE_HISTORY_MSG_SUFFIX: 'GetRemoteHisMsg',
	  // 消息重发, 一般与单聊/群聊/讨论组相关接口的前缀一起组成完整接口名称使用
	  RESEND_MSG_SUFFIX: 'ReSendChatMsg'

	}, _base2.default); /**
	                     * 淘宝群聊SDK接口
	                     *
	                     * @author:   罗嗣(｡･∀･)ﾉﾞ <fangbo.fb@alibaba-inc.com>
	                     * @create:   2017-09-09  下午5:40
	                     */

/***/ },
/* 146 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	/**
	 * Created by neitherzhu on 2016/12/6.
	 * class列表
	 */
	exports.default = {
	  // 跟样式相关的一些class
	  // 隐藏元素class { display: none!important; }
	  HIDDEN: 'hidden',
	  // 语音正在播放中class
	  AUDIO_PLAYING: 'imui-msg-audio-playing',
	  // 消息状态容器 发送中/接收中/发送错误/已读未读人数
	  MSG_STATUS_CONTAINER: 'imui-msg-status',
	  // 群@消息
	  AT_MSG_WITH_STYLE: 'imui-msg-atmsg',
	  // 全部已读的群@消息样式
	  COMPLETED_AT_MSG: 'at-msg-done',
	  // 消息容器的外层容器
	  MSG_WRAPER: 'msg-outer-body',

	  // 跟一些操作相关的class, 一般用来绑定事件等
	  // 单聊消息容器上
	  MSG_CONTAINER: 'J_msg',
	  // 群@消息
	  AT_MSG: 'J_atMsg',
	  // 消息重发
	  RESEND_BTN: 'J_resend',
	  // 停止接收自动回复
	  STOP_AUTO_REPLY: 'J_stopAutoReply',
	  // 消息区域非自己发送的菜单触发按钮
	  BUBBLE_MENU_TRIGGER: 'J_bubbleMenuTrigger',
	  // 消息区域自己发送的菜单触发按钮
	  SELF_BUBBLE_MENU_TRIGGER: 'J_selfBubbleMenuTrigger',
	  // 消息撤回菜单
	  MSG_RECALL: 'J_recallMsg',
	  // 消息复制菜单
	  BUBBLE_COPY: 'J_bubbleCopy',
	  // 消息转发菜单
	  MSG_FORWARD: 'J_forwardMsg',
	  // 菜单容器
	  MENU_WRAP: 'J_menuWrap'
	};

/***/ },
/* 147 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	/**
	 * Created by neitherzhu on 2016/12/6.
	 * DOM元素ID列表
	 */
	exports.default = {
	  // 消息容器id
	  CONTAINER: 'J_msgWrap',
	  // 输入中状态容器id
	  ENTERING: 'J_entering'
	};

/***/ },
/* 148 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	/**
	 * Created by neitherzhu on 2016/12/6.
	 * 多语言
	 */
	exports.default = {
	  CN: {
	    AT_MSG_READ: '已读',
	    AT_MSG_UNREAD: '未读',
	    NEW_MSG_TIP: '新消息',
	    RECALL_MSG_FAIL: '消息撤回失败',
	    COPY: '复制',
	    RECALL: '撤回',
	    FORWARD: '转发'
	  },

	  EN: {}
	};

/***/ },
/* 149 */
/***/ function(module, exports) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	/**
	 * Created by neitherzhu on 2017/3/3.
	 */
	exports.default = 'CN';

/***/ },
/* 150 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _cls = __webpack_require__(146);

	var _cls2 = _interopRequireDefault(_cls);

	var _i18n = __webpack_require__(148);

	var _i18n2 = _interopRequireDefault(_i18n);

	var _language = __webpack_require__(149);

	var _language2 = _interopRequireDefault(_language);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	exports.default = {
	  DEFAULT: [{
	    cls: _cls2.default.BUBBLE_COPY,
	    text: _i18n2.default[_language2.default].COPY
	  }],

	  CUSTOM: {
	    canRecall: {
	      cls: _cls2.default.MSG_RECALL,
	      text: _i18n2.default[_language2.default].RECALL
	    },

	    canForward: {
	      cls: _cls2.default.MSG_FORWARD,
	      text: _i18n2.default[_language2.default].FORWARD
	    }
	  }
	}; /**
	    * Created by neitherzhu on 2017/3/3.
	    */

/***/ },
/* 151 */
/***/ function(module, exports) {

	"use strict";

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});
	/**
	 * Created by neitherzhu on 2016/12/6.
	 * 缓存窗口的一些信息
	 */
	exports.default = {
	  conversationID: null,
	  loginID: null,
	  container: null,
	  // 聊天窗口滚动条是否在最底部
	  isBottom: true
	};

/***/ },
/* 152 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _index = __webpack_require__(6);

	var _index2 = _interopRequireDefault(_index);

	var _template = __webpack_require__(154);

	var _template2 = _interopRequireDefault(_template);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/5.
	 * 获取当前聊天的对象
	 */
	var getCurrentConversationID = new _$BaseRoot.Base.ActionCreator();

	getCurrentConversationID.actionType = 'async';
	getCurrentConversationID.doAsync = function () {
	  return _sdk2.default.getCurrentConversationID();
	};

	getCurrentConversationID.after(function (context, data) {
	  var spliter = void 0;
	  var defaultParam = _util2.default.getParam(location.search.substring(1));
	  if (defaultParam && defaultParam.param) {
	    var param = JSON.parse(defaultParam.param);
	    var LAST_TIME = param.readmsgtime;
	    var id = _util2.default.guid();
	    if (LAST_TIME) {
	      spliter = {
	        msgid: id,
	        msgtime: LAST_TIME,
	        html: (0, _$JuicerRoot2.default)(_template2.default.historySplit, { id: id })
	      };
	    }
	  }
	  _index2.default.conversationChange.action(data, spliter);
	});

	getCurrentConversationID.error = function (err) {
	  console.error('Action getCurrentConversationID Error', err);
	};

	exports.default = getCurrentConversationID;

/***/ },
/* 153 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
	                                                                                                                                                                                                     * Created by neitherzhu on 2016/12/6.
	                                                                                                                                                                                                     * 增加Util工具函数
	                                                                                                                                                                                                     */


	var Util = _$BaseRoot.Base.Util;
	/**
	 * 滚动到某条消息
	 * @param els
	 * @param msgId
	 */
	Util.scrollToMsg = function (els, msgId) {
	  if (els && els.length) {
	    var t = void 0;
	    els.forEach(function (el) {
	      if (!el.querySelectorAll) return;
	      [].concat(_toConsumableArray(el.querySelectorAll('img'))).forEach(function (img) {
	        img.onload = function () {
	          this.onload = null;
	          clearTimeout(t);
	          // 设置图片高度, 防止切换回来的时候图片跳动
	          //this.height = this.height;

	          t = setTimeout(function () {
	            var el = document.getElementById(msgId);
	            el && el.scrollIntoView();
	          }, 300);
	        };
	      });

	      [].concat(_toConsumableArray(el.querySelectorAll('video'))).forEach(function (video) {
	        video.oncanplay = function () {
	          this.oncanplay = null;
	          clearTimeout(t);
	          // 设置视频高度,防止切换回来的时候视频位置跳动
	          this.height = this.clientHeight;

	          t = setTimeout(function () {
	            var el = document.getElementById(msgId);
	            el && el.scrollIntoView();
	          }, 300);
	        };
	      });
	    });
	  }
	  var el = document.getElementById(msgId);

	  el && el.scrollIntoView();
	};

	exports.default = Util;

/***/ },
/* 154 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _errorStatus = __webpack_require__(155);

	var _errorStatus2 = _interopRequireDefault(_errorStatus);

	var _entering = __webpack_require__(156);

	var _entering2 = _interopRequireDefault(_entering);

	var _menuTrigger = __webpack_require__(157);

	var _menuTrigger2 = _interopRequireDefault(_menuTrigger);

	var _menuList = __webpack_require__(158);

	var _menuList2 = _interopRequireDefault(_menuList);

	var _dateSplit = __webpack_require__(159);

	var _dateSplit2 = _interopRequireDefault(_dateSplit);

	var _historySplit = __webpack_require__(160);

	var _historySplit2 = _interopRequireDefault(_historySplit);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	exports.default = {
	  // 消息错误状态
	  errorStatus: _errorStatus2.default.trim(),
	  // 输入状态
	  entering: _entering2.default.trim(),
	  // 菜单触发按钮
	  menuTrigger: _menuTrigger2.default.trim(),
	  // 菜单列表
	  menuList: _menuList2.default.trim(),
	  // 时间分割线
	  dateSplit: _dateSplit2.default.trim(),
	  // 以上为历史消息分割线
	  historySplit: _historySplit2.default.trim()
	};

/***/ },
/* 155 */
/***/ function(module, exports) {

	module.exports = "<span class=\"status-icon status-error{@if cls} ${cls}{@/if}\" data-id=\"{@if id}${id}{@/if}\"></span>\n";

/***/ },
/* 156 */
/***/ function(module, exports) {

	module.exports = "<div class=\"imui-msg-entering\" id=\"J_entering\"></div>\n";

/***/ },
/* 157 */
/***/ function(module, exports) {

	module.exports = "<div class=\"imui-msg-menu-wrap J_menuWrap\" tabindex=\"0\">\n  <span class=\"bubble-menu-trigger J_selfBubbleMenuTrigger\" data-svrtime=\"${svrtime}\"></span>\n</div>\n";

/***/ },
/* 158 */
/***/ function(module, exports) {

	module.exports = "\n<ul class=\"J_bubbleMenuList bubble-menu-list bml-i${count}\">\n  {@each menus as item}\n  <li class=\"${item.cls}\">${item.text}</li>\n  {@/each}\n</ul>\n\n";

/***/ },
/* 159 */
/***/ function(module, exports) {

	module.exports = "<div class=\"imui-msg-date-split\">${date}</div>\n";

/***/ },
/* 160 */
/***/ function(module, exports) {

	module.exports = "<div class=\"J_msg history-split\" id=\"${id}\"><i></i><span>以上为历史消息</span></div>\n";

/***/ },
/* 161 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _event = __webpack_require__(162);

	var _event2 = _interopRequireDefault(_event);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _actions = __webpack_require__(6);

	var _actions2 = _interopRequireDefault(_actions);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _conversationManager = __webpack_require__(163);

	var _conversationManager2 = _interopRequireDefault(_conversationManager);

	var _toast = __webpack_require__(164);

	var _toast2 = _interopRequireDefault(_toast);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/5.
	 * 绑定需要用到的一些客户端/自定义事件
	 */
	var Log = _$BaseRoot.Base.Log;

	var bindEvents = new _$BaseRoot.Base.ActionCreator();

	bindEvents.before(function () {
	  _$JuicerRoot2.default.register('dateFormatter', _util2.default.dateFormatter);
	});

	bindEvents.doSync = function () {

	  /************ 客户端触发事件 *************/

	  var param = _util2.default.getParam(location.search.substring(1));
	  var DLG_NAME = param.dlguniqname || '';
	  var Tst = new _toast2.default(_window2.default.container);

	  // 增加聊天对象
	  _$IMSDKRoot2.default.on(_constants2.default.Event.CONVERSATION_PREFIX + DLG_NAME + _constants2.default.Event.CONVERSATION_ADD_SUFFIX, function (data) {
	    _conversationManager2.default.clear(_util2.default.getUid(data.cid));

	    if (!_window2.default.LAST_TIMES) {
	      _window2.default.LAST_TIMES = {};
	    }

	    if (data.readmsgtime) {
	      _window2.default.LAST_TIMES[_util2.default.getUid(data.cid)] = parseInt(data.readmsgtime);

	      Log.red('切换聊天对象时的readTIME', data.readmsgtime, _util2.default.dateFormatter(data.readmsgtime));
	    }
	  });

	  // 切换聊天对象
	  _$IMSDKRoot2.default.on(_constants2.default.Event.CONVERSATION_PREFIX + DLG_NAME + _constants2.default.Event.CONVERSATION_CHANGE_SUFFIX, function (data) {
	    _actions2.default.conversationChange.action(data.cid);
	  });

	  // 聊天窗口关闭
	  _$IMSDKRoot2.default.on(_constants2.default.Event.CONVERSATION_PREFIX + DLG_NAME + _constants2.default.Event.CONVERSATION_CLOSE_SUFFIX, function (data) {
	    _actions2.default.conversationClose.action(data);
	  });

	  // 断网
	  _$IMSDKRoot2.default.on(_constants2.default.Event.NET_DISCONNECT, function (data) {
	    _actions2.default.netDisconnect.action(data);
	  });

	  // 网络重连成功
	  _$IMSDKRoot2.default.on(_constants2.default.Event.NET_RECONNECT, function (data) {
	    _actions2.default.netReconnect.action(data);
	  });

	  // 收到消息
	  _$IMSDKRoot2.default.on(_constants2.default.Event.CHAT_RECEIVE_MSG + ' ' + _constants2.default.Event.TRIBE_RECEIVE_MSG + ' ' + _constants2.default.TaobaoEvent.TRIBE_RECEIVE_MSG, function (users) {

	    if (!users && !users.length) return;

	    users.forEach(function (user) {
	      if (_util2.default.getUid(user) !== _util2.default.getUid(_window2.default.conversationID)) return;

	      _actions2.default.receiveMsg.action(user);
	    });
	  });

	  // 发送消息
	  _$IMSDKRoot2.default.on(_constants2.default.Event.CHAT_SEND_MSG + ' ' + _constants2.default.Event.TRIBE_SEND_MSG + ' ' + _constants2.default.TaobaoEvent.TRIBE_SEND_MSG, function (users) {
	    if (!users && !users.length) return;

	    users.forEach(function (user) {
	      if (_util2.default.getUid(user) !== _util2.default.getUid(_window2.default.conversationID)) return;

	      _actions2.default.getSentMsg.action(user);
	    });
	  });

	  // 群@消息已读通知
	  _$IMSDKRoot2.default.on(_constants2.default.Event.TRIBE_AT_MSG_READ, function (data) {
	    if (!data || !data.cid) return;

	    var uid = _util2.default.getUid(data.cid);
	    // 如果不是当前联系对象, 需要缓存
	    if (uid !== _util2.default.getUid(_window2.default.conversationID)) {

	      data.event = _constants2.default.Event.TRIBE_AT_MSG_READ;
	      return _actions2.default.cacheEvent.action(uid, data);
	    }
	  });

	  // 输入状态变更
	  _$IMSDKRoot2.default.on(_constants2.default.Event.INPUT_STATUS_CHANGE, function (data) {
	    if (!data || !data.cid) return;
	    _actions2.default.enteringStatusChange.action(data);
	  });

	  // 消息状态变更
	  _$IMSDKRoot2.default.on(_constants2.default.Event.CHAT_SEND_MSG_STATUS_CHANGE + ' ' + _constants2.default.Event.TRIBE_SEND_MSG_STATUS_CHANGE + ' ' + _constants2.default.TaobaoEvent.TRIBE_SEND_MSG_STATUS_CHANGE + ' ' + _constants2.default.Event.SEND_MSG_STATUS_CHANGE, function (data) {
	    if (!data || !data.cid || !data.msgid) return;

	    _actions2.default.sendMsgStatusChange.action(data);
	  });

	  // 消息撤回
	  _$IMSDKRoot2.default.on(_constants2.default.Event.TRIBE_MSG_RECALLED + ' ' + _constants2.default.Event.CHAT_MSG_RECALLED, function (data) {
	    if (!data || !data.cid) return;

	    var uid = _util2.default.getUid(data.cid);
	    // 如果不是当前联系对象, 需要缓存
	    if (uid !== _util2.default.getUid(_window2.default.conversationID)) {

	      data.event = _constants2.default.Event.CHAT_MSG_RECALLED;
	      return _actions2.default.cacheEvent.action(uid, data);
	    }

	    if (data.code === 0) {
	      _actions2.default.msgRecall.action(data);
	    } else {
	      Tst.show(_constants2.default.I18N[_constants2.default.LANGUAGE].RECALL_MSG_FAIL);
	    }
	  });

	  // IMSDK.on('im.contact.onContactPortraitChange', data => {
	  //     Log.green('onContactPortraitChange',data);
	  // });

	  /************ 自定义事件 *************/

	  // 联系对象切换完后,需要判断是否有缓存的事件需要触发
	  _event2.default.on(_constants2.default.Event.CONVERSATION_CHANGE_OVER, function () {
	    _actions2.default.fireCacheEvent.action();
	  });
	};

	bindEvents.after(function (context, data) {
	  _actions2.default.getCurrentConversationID.action(data);
	});

	bindEvents.error = function (err) {
	  console.error('Action bindEvents Error', err);
	};

	exports.default = bindEvents;

/***/ },
/* 162 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var Event = new _$BaseRoot.Base.Event(); /**
	                                          * Created by neitherzhu on 2016/12/5.
	                                          */
	exports.default = Event;

/***/ },
/* 163 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var Cache = _$BaseRoot.Base.Cache;
	//window.MAX_MINS = 30;
	/**
	 * Created by neitherzhu on 2016/12/19.
	 */

	var MAX_LENGTH = 100;
	//const MIN = 60 * 1000;
	var TIME = 30 * 60 * 1000;
	exports.default = {

	  __CACHE: [],

	  add: function add(uid) {
	    if (this.__CACHE.length >= MAX_LENGTH) {
	      var cache = this.__CACHE.shift();
	      Cache.clear(cache.uid);
	    }
	    this.__CACHE.push({ uid: uid, t: Date.now() });
	  },
	  update: function update(uid) {
	    for (var i = 0, l = this.__CACHE.length; i < l; i++) {
	      if (this.__CACHE[i].uid === uid) {
	        this.__CACHE[i].t = Date.now();
	      }
	    }
	  },
	  clear: function clear(uid) {
	    var _this = this;

	    var idx = 0;
	    var t = Date.now();
	    var s = [];

	    this.__CACHE.forEach(function (o, i) {
	      if (uid && uid === o.uid || t - o.t > TIME) {
	        s.push(i);
	      }
	    });

	    s.forEach(function (index) {
	      _this.__CACHE.splice(index + idx);
	      idx--;
	    });
	  }
	};

/***/ },
/* 164 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Created by neitherzhu on 2017/3/3.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


	__webpack_require__(165);

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	/**
	 * 消息区域toast
	 */
	var Toast = function () {
	  function Toast(container) {
	    _classCallCheck(this, Toast);

	    this.container = container;
	    this.AUTO_REMOVE_TIME = 2000;

	    return this;
	  }

	  _createClass(Toast, [{
	    key: 'show',
	    value: function show(text, duration) {
	      var _this = this;

	      duration = duration || this.AUTO_REMOVE_TIME;

	      if (this.toast) {
	        clearTimeout(this.removeTimeout);
	        this.toast.querySelector('.J_toastText').innerText = text;
	      } else {
	        var div = document.createElement('div');
	        div.className = 'toast';
	        div.innerHTML = '<span class="J_toastText">' + text + '</span>';
	        this.container.appendChild(div);
	        this.toast = div;
	      }

	      this.removeTimeout = setTimeout(function () {
	        _this.remove();
	      }, duration);
	    }
	  }, {
	    key: 'remove',
	    value: function remove() {
	      if (this.toast) {
	        this.toast.parentNode.removeChild(this.toast);
	        this.toast = null;
	      }
	    }
	  }]);

	  return Toast;
	}();

	exports.default = Toast;

/***/ },
/* 165 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ },
/* 166 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _event = __webpack_require__(162);

	var _event2 = _interopRequireDefault(_event);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _plugins = __webpack_require__(167);

	var _plugins2 = _interopRequireDefault(_plugins);

	var _index = __webpack_require__(6);

	var _index2 = _interopRequireDefault(_index);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
	                                                                                                                                                                                                     * Created by neitherzhu on 2016/12/5.
	                                                                                                                                                                                                     * 切换聊天对象
	                                                                                                                                                                                                     */


	var Cache = _$BaseRoot.Base.Cache,
	    Log = _$BaseRoot.Base.Log;


	var conversationChange = new _$BaseRoot.Base.ActionCreator();

	// 设置一些前置任务
	conversationChange.before(function (context, contact, spliter) {
	  context.spliter = spliter;
	  var uid = _util2.default.getUid(contact);
	  var cuid = _util2.default.getUid(_window2.default.conversationID);

	  Log.orange('切换到', contact, uid);
	  Log.orange('切换前', _window2.default.conversationID, cuid);

	  // 如果一样的话 就不需要再触发了
	  if (uid && cuid && uid == cuid) return false;
	  context.contact = _util2.default.setCidType(contact);
	})
	// 停止播放语音
	.before(function (context, contact) {

	  _sdk2.default.stopAudio();
	  [].concat(_toConsumableArray(document.querySelectorAll('.' + _constants2.default.CLS.AUDIO_PLAYING))).forEach(function (el) {
	    el.classList.remove(_constants2.default.CLS.AUDIO_PLAYING);
	  });
	}).before(function () {
	  _util2.default.stopScrollToBottom();
	})
	// 清除正在输入的状态
	.before(function (context, contact) {

	  var enter = document.getElementById(_constants2.default.EL_ID.ENTERING);
	  enter && enter.classList.add(_constants2.default.CLS.HIDDEN);
	})
	// 缓存一些信息
	.before(function (context, contact) {
	  if (!this.contact) return;

	  var uid = _util2.default.getUid(this.contact);
	  var cache = Cache.get(uid);
	  var plugin = _plugins2.default.getPlugin('newMsgTip');

	  var c = {
	    scrollTop: _window2.default.container.scrollTop,
	    isBottom: _window2.default.isBottom,
	    hasNewMsgTip: plugin && plugin.isShow()
	  };

	  var messageManager = cache.messageManager;

	  messageManager && messageManager.save();
	  contact && Cache.set(uid, c);
	}).before(function (context, contact) {
	  if (context.contact) {
	    var scroll = _plugins2.default.getPlugin('scroll');

	    _window2.default.isBottom = Cache.get(_util2.default.getUid(context.contact)).isBottom === false ? false : true;
	    scroll.setBottom(_window2.default.isBottom);
	  }
	})
	// 将开始切换联系对象的事件广播出去
	.before(function (context, contact) {
	  _event2.default.emit(_constants2.default.Event.CONVERSATION_CHANGE_START, contact);
	})
	// 移除新消息提醒
	.before(function (context, contact) {
	  var plugin = _plugins2.default.getPlugin('newMsgTip');
	  plugin && plugin.hide();
	});

	conversationChange.doSync = function (context, contact) {
	  _window2.default.conversationID = context.contact;
	  this.contact = context.contact;
	};

	conversationChange.after(function (context, contact) {
	  if (context.contact) {
	    _index2.default.getMsg.action(context.contact, context.spliter);
	  } else {
	    _window2.default.container.innerHTML = '';
	  }
	});

	conversationChange.error = function (err) {
	  console.error('Action conversationChange Error', err);
	};

	exports.default = conversationChange;

/***/ },
/* 167 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _createPlugin = __webpack_require__(168);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	__webpack_require__(169);

	__webpack_require__(170);

	__webpack_require__(171);

	__webpack_require__(172);

	__webpack_require__(173);

	__webpack_require__(174);

	__webpack_require__(175);

	__webpack_require__(179);

	__webpack_require__(180);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	//import './eventPlugin/videoPlay';

	//import './eventPlugin/audioClick';
	/**
	 * Created by neitherzhu on 2016/12/7.
	 * 插件
	 */
	exports.default = _createPlugin2.default;

/***/ },
/* 168 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var Plugin = new _$BaseRoot.Base.Plugin(); /**
	                                            * Created by neitherzhu on 2016/12/8.
	                                            * 创建全局插件
	                                            */
	exports.default = Plugin;

/***/ },
/* 169 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _createPlugin = __webpack_require__(168);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
	                                                                                                                                                                                                     * Created by neitherzhu on 2016/12/8.
	                                                                                                                                                                                                     * 点击自动回复消息
	                                                                                                                                                                                                     */


	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.STOP_AUTO_REPLY, function (ev) {

	  _sdk2.default.stopAutoReply({ cid: _window2.default.conversationID });

	  // 移除当前屏幕上的"不再回复"按钮
	  [].concat(_toConsumableArray(document.querySelectorAll('.' + _constants2.default.CLS.STOP_AUTO_REPLY))).forEach(function (el) {
	    el.parentNode.removeChild(el);
	  });
	});

/***/ },
/* 170 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$BaseRoot = __webpack_require__(3);

	var _createPlugin = __webpack_require__(168);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/8.
	 * 点击重发消息
	 */
	var Cache = _$BaseRoot.Base.Cache;


	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.RESEND_BTN, function (ev) {

	  var target = ev.target;
	  var parent = _util2.default.parents(target, _constants2.default.CLS.MSG_CONTAINER);
	  var messageManager = Cache.get(_util2.default.getUid(_window2.default.conversationID)).messageManager;

	  parent && _sdk2.default.resendMsg({
	    cid: _window2.default.conversationID,
	    msgid: parent.id
	  });

	  messageManager && messageManager.removeMsg(parent.id);
	  parent.parentNode.removeChild(parent);
	});

/***/ },
/* 171 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _createPlugin = __webpack_require__(168);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _template = __webpack_require__(154);

	var _template2 = _interopRequireDefault(_template);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
	                                                                                                                                                                                                     * Created by neitherzhu on 2017/2/16.
	                                                                                                                                                                                                     */


	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.BUBBLE_MENU_TRIGGER, function (ev) {
	  var target = ev.target;
	  var wrap = _util2.default.parents(target, 'imui-msg-op-wrap');
	  var type = wrap.getAttribute('date-type');
	  var customMenu = wrap.dataset.menu && JSON.parse(wrap.dataset.menu);
	  var menus = [];
	  // 对于文件类型特殊判断， 不需要复制
	  if (type === 'file') {
	    menus = [];
	  } else {
	    menus = [].concat(_toConsumableArray(_constants2.default.BUBBLE_MENU.DEFAULT));
	  }

	  for (var k in customMenu) {
	    if (customMenu[k]) {
	      menus.push(_constants2.default.BUBBLE_MENU.CUSTOM[k]);
	    }
	  }

	  var tpl = (0, _$JuicerRoot2.default)(_template2.default.menuList, { menus: menus, count: menus.length });
	  var dom = _util2.default.createFragment(tpl);

	  target.parentNode.appendChild(dom);

	  target.classList.remove(_constants2.default.CLS.BUBBLE_MENU_TRIGGER);
	});

/***/ },
/* 172 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _createPlugin = __webpack_require__(168);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _$BaseRoot = __webpack_require__(3);

	var _template = __webpack_require__(154);

	var _template2 = _interopRequireDefault(_template);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
	                                                                                                                                                                                                     * Created by neitherzhu on 2017/2/16.
	                                                                                                                                                                                                     */


	var Util = _$BaseRoot.Base.Util;

	// 更新DOM节点

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.SELF_BUBBLE_MENU_TRIGGER, function (ev) {
	  var target = ev.target;
	  var svrTime = target.getAttribute('data-svrtime');

	  if (!svrTime) return;

	  svrTime = parseInt(svrTime);

	  _sdk2.default.getServerTime().then(function (data) {
	    var n = parseInt(data.result);
	    var canNotRecall = n - svrTime > _constants2.default.RECALL_LIMIT;
	    var menuList = target.parentNode.querySelector('.J_bubbleMenuList');
	    var menus = [];

	    var wrap = Util.parents(target, 'imui-msg-op-wrap');
	    var type = wrap.getAttribute('data-type');
	    var customMenu = wrap.dataset.menu && JSON.parse(wrap.dataset.menu);

	    // 对于文件类型特殊判断， 不需要复制
	    if (type === 'file') {
	      menus = [];
	    } else {
	      menus = [].concat(_toConsumableArray(_constants2.default.BUBBLE_MENU.DEFAULT));
	    }

	    for (var k in customMenu) {
	      if (customMenu[k]) {
	        if (k === 'canRecall') {
	          if (_window2.default.conversationID.type == 4) {
	            break;
	          }
	          // 手淘群不支持消息撤回, UI层屏蔽撤回按钮
	          !canNotRecall && menus.push(_constants2.default.BUBBLE_MENU.CUSTOM[k]);
	        } else {
	          menus.push(_constants2.default.BUBBLE_MENU.CUSTOM[k]);
	        }
	      }
	    }

	    menuList && menuList.parentNode.removeChild(menuList);

	    var tpl = (0, _$JuicerRoot2.default)(_template2.default.menuList, { menus: menus, count: menus.length });
	    var dom = Util.createFragment(tpl);

	    target.parentNode.appendChild(dom);

	    if (canNotRecall) {
	      target.style.display = 'none';
	      target.classList.remove(_constants2.default.CLS.SELF_BUBBLE_MENU_TRIGGER);
	    }
	  });
	});

/***/ },
/* 173 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _createPlugin = __webpack_require__(168);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.MSG_RECALL, function (ev) {
	  var target = ev.target;
	  var parent = _util2.default.parents(target, _constants2.default.CLS.MSG_CONTAINER);
	  var menuWrap = _util2.default.parents(target, 'imui-msg-menu-wrap');

	  if (!parent || !menuWrap) return;

	  var trigger = menuWrap.querySelector('.bubble-menu-trigger');
	  var msgid = parent.id;
	  var msgtime = parent.getAttribute('data-time');
	  var svrtime = trigger.getAttribute('data-svrtime');

	  menuWrap.blur();
	  _sdk2.default.recallMsg({
	    cid: _window2.default.conversationID,
	    msgid: msgid,
	    msgtime: msgtime,
	    svrtime: svrtime
	  });
	}); /**
	     * Created by neitherzhu on 2017/2/16.
	     */

/***/ },
/* 174 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _createPlugin = __webpack_require__(168);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _event2 = __webpack_require__(162);

	var _event3 = _interopRequireDefault(_event2);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Buffer = 25; /**
	                  * Created by neitherzhu on 2016/12/8.
	                  * 滚动条管理 滚动加载消息
	                  */


	var Scroll = {

	  __scrollTopLimit: 0, // 滚动到顶部位置为0时,触发获取更多消息的行为

	  __scrollingTimer: null, // 防止频繁触发滚动事件

	  __isBottom: true, // 滚动条是否在底部

	  __switching: false, // 切换中

	  __isScrollBtnShow: false, // 快速滚动到顶部/底部的按钮是否显示

	  __topBtn: null,

	  __bottomBtn: null,

	  __disabled: false,

	  __resizeTimer: null, // 防止频繁触发窗口缩放事件

	  init: function init(context) {

	    if (!context || !context.container) return;

	    this.container = context.container;
	    this.containerHeight = 0;

	    this._event();
	  },

	  _event: function _event() {
	    var _that = this;
	    var scrollHandler = void 0;
	    if (_constants2.default.SCROLL_DELAY !== 0) {
	      scrollHandler = function scrollHandler() {
	        if (_that.__switching || _that.__disabled) return;

	        var st = this.scrollTop;

	        // if (!_that.containerHeight) {
	        //   _that.containerHeight = _that.container.clientHeight;
	        // }
	        _that.containerHeight = _that.container.clientHeight;

	        if (st <= _that.__scrollTopLimit) {
	          _event3.default.emit('SCROLL_REACH_TOP', st);
	        }

	        _that.__isBottom = Math.abs(st + _that.containerHeight - _that.container.scrollHeight) <= Buffer;

	        _event3.default.emit('SCROLLING', { isBottom: _that.__isBottom, scrollTop: st });

	        if (_that.__isBottom) {
	          _event3.default.emit('SCROLL_REACH_BOTTOM', st);
	        }
	      };
	    } else {
	      scrollHandler = function scrollHandler() {
	        if (_that.__switching || _that.__disabled) return;

	        var st = this.scrollTop;

	        clearTimeout(_that.__scrollingTimer);

	        _that.__scrollingTimer = setTimeout(function () {
	          // if (!_that.containerHeight) {
	          //   _that.containerHeight = _that.container.clientHeight;
	          // }
	          _that.containerHeight = _that.container.clientHeight;

	          if (st <= _that.__scrollTopLimit) {
	            _event3.default.emit('SCROLL_REACH_TOP', st);
	          }

	          _that.__isBottom = Math.abs(st + _that.containerHeight - _that.container.scrollHeight) <= Buffer;

	          _event3.default.emit('SCROLLING', { isBottom: _that.__isBottom, scrollTop: st });

	          if (_that.__isBottom) {
	            _event3.default.emit('SCROLL_REACH_BOTTOM', st);
	          }
	        }, parseInt(_constants2.default.SCROLL_DELAY) + 10);
	      };
	    }

	    this.container.addEventListener('scroll', scrollHandler);

	    window.addEventListener('resize', function () {
	      _that.reset();
	    });

	    // 除了自己的消息窗口外, 其他容器的变更都需要重新计算消息容器的高度
	    // 防止消息容器的高度被其他容器改变,导致滚动条及新消息提醒不准确
	    var observerHandler = function observerHandler(mutations) {

	      if (!mutations || !mutations.length) return;

	      mutations.forEach(function (m) {
	        if (!_util2.default.parents(m.target, _constants2.default.CLS.MSG_WRAPER)) {
	          _that.reset();
	        }
	      });

	      //mutations.forEach(m => {
	      //  _that.__isBottom && _that.goBottom();
	      //
	      //  if(m.type === 'childList') {
	      //    [...m.addedNodes].forEach(n => {
	      //      [...n.querySelectorAll('.J_imImage')].forEach(img => {
	      //        img.onload = function() {
	      //          this.onload = this.onerror = null;
	      //          _that.__isBottom && _that.goBottom();
	      //        };
	      //        img.onerror = function() {
	      //          this.onload = this.onerror = null;
	      //          _that.__isBottom && _that.goBottom();
	      //        }
	      //      });
	      //    });
	      //  }
	      //});
	    };

	    var observer = new MutationObserver(observerHandler);

	    observer.observe(document.body, {
	      childList: true,
	      attributes: true,
	      subtree: true
	    });

	    this.container.addEventListener('DOMSubtreeModified', function () {
	      _that.renderScrollBtn();
	    });
	  },

	  disableScroll: function disableScroll() {
	    this.__disabled = true;
	  },

	  enableScroll: function enableScroll() {
	    this.__disabled = false;
	  },

	  setSwitching: function setSwitching(b) {
	    this.__switching = !!b;
	  },

	  reset: function reset() {
	    var _that = this;

	    if (_constants2.default.SCROLL_DELAY !== 0) {
	      clearTimeout(this.__resizeTimer);

	      this.__resizeTimer = setTimeout(function () {
	        //let st = _that.container.scrollTop;
	        _that.containerHeight = _that.container.clientHeight;
	        _that.renderScrollBtn();

	        //Math.abs(st + _that.containerHeight - _that.container.scrollHeight) <= Buffer
	        _that.__isBottom && _that.goBottom();
	      }, 300);
	    } else {
	      _that.containerHeight = _that.container.clientHeight;
	      _that.renderScrollBtn();

	      //Math.abs(st + _that.containerHeight - _that.container.scrollHeight) <= Buffer
	      _that.__isBottom && _that.goBottom();
	    }
	  },

	  setBottom: function setBottom(b) {
	    this.__isBottom = !!b;
	  },


	  renderScrollBtn: function renderScrollBtn() {
	    var _that = this;
	    var isOverY = this._isOverY();

	    if (isOverY !== this.__isScrollBtnShow) {
	      this.__isScrollBtnShow = isOverY;

	      if (!this.__topBtn) {
	        this.__topBtn = document.createElement('div');
	        this.__topBtn.className = 'auto-scroll-btn to-top J_ToTop';
	        this.container.parentNode.appendChild(this.__topBtn);
	        this.__topBtn.addEventListener('click', function () {
	          _that.container.scrollTop = 0;
	        });
	      }

	      if (!this.__bottomBtn) {
	        this.__bottomBtn = document.createElement('div');
	        this.__bottomBtn.className = 'auto-scroll-btn to-end J_ToEnd';
	        this.container.parentNode.appendChild(this.__bottomBtn);
	        this.__bottomBtn.addEventListener('click', function () {
	          _that.goBottom();
	        });
	      }

	      this.__bottomBtn.style.display = isOverY ? 'block' : 'none';
	      this.__topBtn.style.display = isOverY ? 'block' : 'none';
	    }
	  },

	  goBottom: function goBottom() {
	    this.container.scrollTop = this.container.scrollHeight;
	  },

	  _isOverY: function _isOverY() {
	    return this.container.scrollHeight > this.container.clientHeight;
	  }
	};

	_createPlugin2.default.addPlugin('scroll', Scroll);

	exports.default = Scroll;

/***/ },
/* 175 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _popupOver = __webpack_require__(176);

	var _popupOver2 = _interopRequireDefault(_popupOver);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _createPlugin = __webpack_require__(168);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _event = __webpack_require__(162);

	var _event2 = _interopRequireDefault(_event);

	__webpack_require__(178);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/14.
	 * 新消息提醒
	 */
	var NewMsgTip = {

	  __isShow: false,

	  init: function init(context) {
	    if (!context || !context.container) return;

	    this.container = context.container;

	    this.config = {
	      visible: false,
	      x: -5,
	      y: -5,
	      cls: 'imui-msg-new-msg-box J_newMsgTip',
	      tpl: _constants2.default.I18N[_constants2.default.LANGUAGE].NEW_MSG_TIP,
	      parent: document.getElementById(_constants2.default.EL_ID.CONTAINER).parentNode,
	      html: ''
	    };
	    this.popupOver = new _popupOver2.default(context.container, this.config);

	    this.popupOver.render(this.config);
	    this.events();
	  },
	  events: function events() {
	    var _this = this;

	    _event2.default.on('SCROLL_REACH_BOTTOM', function (data) {
	      _this.hide();
	    });

	    _event2.default.on(_constants2.default.Event.CONVERSATION_CHANGE_START, function () {
	      _this.hide();
	    });

	    this.popupOver.box.addEventListener('click', function (ev) {
	      _this.hide();
	      _this.container.scrollTop = _this.container.scrollHeight;
	    });
	  },
	  show: function show() {
	    if (this.isShow()) return;
	    this.__isShow = true;
	    this.config.visible = true;
	    this.popupOver.render(this.config);
	  },
	  hide: function hide() {
	    if (!this.isShow()) return;
	    this.__isShow = false;
	    this.config.visible = false;
	    this.popupOver.render(this.config);
	  },
	  isShow: function isShow() {
	    return this.__isShow;
	  }
	};

	_createPlugin2.default.addPlugin('newMsgTip', NewMsgTip);

	exports.default = NewMsgTip;

/***/ },
/* 176 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Created by neitherzhu on 2016/12/9.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 窗口内浮层, 负责确定弹出的位置
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


	__webpack_require__(177);

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	var PopupOver = function () {
	  function PopupOver(container, config) {
	    _classCallCheck(this, PopupOver);

	    this.container = container;
	    this.box = null;
	    this.visible = false;
	    this.config = config;

	    return this;
	  }

	  _createClass(PopupOver, [{
	    key: 'calculate',
	    value: function calculate(x, y) {
	      if (!this.box) return {};

	      var newx = x,
	          newy = y;

	      if (!this.config || this.config && newx !== this.config.x || newy !== this.config.y) {
	        var offx = 5,
	            offy = 5;
	        var boxw = this.box.clientWidth,
	            boxh = this.box.clientHeight;
	        var winw = window.innerWidth,
	            winh = window.innerHeight;

	        // 左右都超出, 展示在点击位置的中间
	        if (x + boxw > winw && x < boxw) {
	          newx = (winw - boxw) / 2;
	        } else {
	          newx = x + boxw > winw ? x - boxw - offx : x + offx;
	          newx = Math.min(newx, winw - boxw); // 不能超右边界
	          newx = Math.max(newx, 0); // 不能超左边界
	        }

	        // 上下都超出
	        if (y + boxh > winh && y < boxh) {
	          newy = (winh - boxh) / 2;
	        } else {
	          newy = y + boxh > winh ? y - boxh - offy : y + offy;
	          newy = Math.min(newy, winh - boxh); // 不能超下边界
	          newy = Math.max(newy, 0); // 不能超上边界
	        }
	      }

	      var p1 = x >= 0 ? 'left' : 'right';
	      var p2 = y >= 0 ? 'top' : 'bottom';
	      var result = {};

	      result[p1] = Math.abs(newx) + 'px';
	      result[p2] = Math.abs(newy) + 'px';

	      return result;
	    }
	  }, {
	    key: 'getStyle',
	    value: function getStyle(config) {
	      var x = config.x,
	          y = config.y,
	          visible = config.visible;

	      var style = this.calculate(x, y);
	      var str = '';

	      style.visibility = visible ? 'visible' : 'hidden';
	      style.opacity = visible ? '1' : '0';
	      this.visible = visible;

	      for (var k in style) {
	        str += k + ':' + style[k] + ';';
	      }

	      return str;
	    }
	  }, {
	    key: 'render',
	    value: function render(config) {
	      var cls = config.cls,
	          tpl = config.tpl,
	          html = config.html,
	          parent = config.parent;

	      var style = this.getStyle(config);

	      cls || (cls = '');

	      if (!this.box) {

	        var div = document.createElement('div');

	        tpl && (div.innerHTML = tpl);
	        div.className = 'popup-over ' + cls;

	        this.box = div;

	        (parent || document.body).appendChild(div);
	      }

	      this.box.setAttribute('style', style);
	      html && (this.box.innerHTML = html);
	    }
	  }]);

	  return PopupOver;
	}();

	exports.default = PopupOver;

/***/ },
/* 177 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ },
/* 178 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ },
/* 179 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _createPlugin = __webpack_require__(168);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2017/3/3.
	 */
	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.BUBBLE_COPY, function (ev) {

	  var parent = _util2.default.parents(ev.target, 'J_msg');

	  if (!parent) return;

	  var htmlEl = parent.querySelector('.msg-body-html');
	  var menuWrap = parent.querySelector('.imui-msg-menu-wrap');
	  menuWrap && menuWrap.blur();

	  var content = '';

	  if (htmlEl.querySelector('video')) {
	    content = htmlEl.querySelector('video').src;
	  } else {
	    content = htmlEl.innerHTML;
	  }
	  _sdk2.default.copy({ content: content });
	});

/***/ },
/* 180 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _createPlugin = __webpack_require__(168);

	var _createPlugin2 = _interopRequireDefault(_createPlugin);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	_createPlugin2.default.addEventPlugin('click', _constants2.default.CLS.MSG_FORWARD, function (ev) {
	  var target = ev.target;
	  var parent = _util2.default.parents(target, _constants2.default.CLS.MSG_CONTAINER);
	  var menuWrap = _util2.default.parents(target, 'imui-msg-menu-wrap');
	  var isFile = parent && parent.classList.contains('file-msg-wrap');

	  if (!parent || !menuWrap) return;

	  var param = {
	    cid: _util2.default.getCid(_window2.default.conversationID),
	    msgid: parent.id
	  };

	  if (isFile) {
	    var fileMsg = parent.querySelector('.file-msg');
	    var nodeName = fileMsg.dataset.name;
	    var nodeSize = parseInt(fileMsg.dataset.size);
	    var md5 = fileMsg.dataset.md5;
	    var fileMeta = {
	      nodeName: nodeName,
	      nodeSize: nodeSize,
	      md5: md5
	    };

	    if (fileMsg) {
	      param.msgtype = 65649;
	      param.msgbody = [{
	        type: 113,
	        jvale: '',
	        value: JSON.stringify({ fileMeta: fileMeta })
	      }];
	    }
	  }

	  menuWrap.blur();

	  _sdk2.default.forwardMsg(param);
	}); /**
	     * Created by neitherzhu on 2017/5/23.
	     */

/***/ },
/* 181 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _index = __webpack_require__(6);

	var _index2 = _interopRequireDefault(_index);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _plugins = __webpack_require__(167);

	var _plugins2 = _interopRequireDefault(_plugins);

	var _messageManager = __webpack_require__(182);

	var _messageManager2 = _interopRequireDefault(_messageManager);

	var _template = __webpack_require__(154);

	var _template2 = _interopRequireDefault(_template);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/6.
	 * 获取消息
	 */
	var Cache = _$BaseRoot.Base.Cache;

	var getMsg = new _$BaseRoot.Base.ActionCreator();

	getMsg.actionType = 'async';

	getMsg.doAsync = function (context, contact, spliter) {

	  var uid = _util2.default.getUid(contact);
	  var label = _util2.default.getLabel(contact);
	  var cache = Cache.get(uid);
	  var messageManager = cache.messageManager;

	  if (!messageManager) {
	    messageManager = new _messageManager2.default(_window2.default.container, uid, label, spliter);

	    Cache.set(uid, { messageManager: messageManager });
	  }

	  if (!spliter) {
	    if (_window2.default.LAST_TIMES && _window2.default.LAST_TIMES[uid]) {
	      var id = _util2.default.guid();
	      spliter = {
	        msgid: id,
	        msgtime: _window2.default.LAST_TIMES[uid],
	        html: (0, _$JuicerRoot2.default)(_template2.default.historySplit, { id: id })
	      };

	      delete _window2.default.LAST_TIMES[uid];
	    }
	  }

	  spliter && messageManager.setSplit(spliter);

	  messageManager.render();

	  var getOfflineMsgPromise = _index2.default.getOfflineMsg.action(contact);
	  var getNewMsgPromise = _index2.default.getNewMsg.action(contact);

	  return new Promise(function (resolve, reject) {
	    Promise.all([getOfflineMsgPromise, getNewMsgPromise]).then(function () {
	      uid === _util2.default.getUid(_window2.default.conversationID) ? resolve() : reject();
	    }).catch(function (err) {
	      reject(err);
	    });
	  });
	};

	getMsg.after(function () {
	  var cache = Cache.get(_util2.default.getUid(_window2.default.conversationID));
	  var scrollTop = cache.scrollTop;
	  var hasNewMsgTip = cache.hasNewMsgTip;
	  var plugin = _plugins2.default.getPlugin('newMsgTip');

	  scrollTop && (_window2.default.container.scrollTop = scrollTop);
	  hasNewMsgTip && plugin && plugin.show();
	});

	getMsg.error = function (err) {
	  console.error('Action getMsg Error', err);
	};

	exports.default = getMsg;

/***/ },
/* 182 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Created by neitherzhu on 2016/12/6.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 消息上屏管理
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


	var _$BaseRoot = __webpack_require__(3);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _convert = __webpack_require__(183);

	var _convert2 = _interopRequireDefault(_convert);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _template = __webpack_require__(154);

	var _template2 = _interopRequireDefault(_template);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	var Cache = _$BaseRoot.Base.Cache;

	//window.MAX_MSG_LENGTH = 200;

	var MessageManager = function () {
	  function MessageManager(container, contact, label, spliter) {
	    _classCallCheck(this, MessageManager);

	    this.container = container;
	    this.cid = contact;
	    this.label = label;
	    this.MAX_MSG_LENGTH = 200;
	    this.spliter = spliter;

	    if (this.spliter) {

	      this.spliter.credible = true;
	      this.spliter.split = 1;
	    }

	    this.clear();
	  }

	  _createClass(MessageManager, [{
	    key: 'setSplit',
	    value: function setSplit(spliter) {

	      this.spliter = spliter;

	      if (this.spliter) {
	        this.spliter.credible = true;
	        this.spliter.split = 1;
	      }
	    }
	  }, {
	    key: 'clear',
	    value: function clear(msg) {
	      var _this = this;

	      var cache = void 0;
	      var list = void 0;

	      if (msg) {
	        var msgtime = parseInt(msg.msgtime);
	        var msgid = msg.msgid;
	        list = [].concat(_toConsumableArray(this.MsgList));
	        cache = [];

	        list.reverse();

	        for (var i = 0, l = list.length; i < l; i++) {
	          if (parseInt(list[i].msgtime) < msgtime) {
	            break;
	          }
	          if (list[i].msgid !== msgid) {
	            cache.push(list[i]);
	          }
	        }
	      }

	      this.dateCache = '';
	      this.HTML = '';
	      this.isClose = false;
	      // 缓存的消息列表
	      this.MsgList = [];
	      // 缓存的消息id
	      this.MsgIdInCache = {};
	      // 已经上屏的消息id
	      this.MsgIdOnScreen = {};
	      // 消息上屏后需要针对此条消息需要处理的回调
	      this.MsgCallbackList = [];
	      // 未处理完的回调
	      this.UnresolvedCallbackList = [];
	      // 本次插入消息的dom
	      this.TempConvertDOM = null;
	      // 最后一次插消息的条数
	      this.LastInsertMsgLen = 0;
	      // 每次插消息时第一条消息
	      this.firstMsgInHistory = null;
	      // 每次插消息时最后一条消息
	      this.lastMsgInHistory = null;
	      // 解析消息时的上一条消息
	      this.prevMsg = null;
	      this.spliterRendered = false;

	      if (cache && cache.length) {
	        cache.reverse();

	        var msgEl = void 0;
	        var div = document.createElement('div');

	        cache.forEach(function (m) {
	          msgEl = document.getElementById(m.msgid);

	          if (msgEl) {
	            div.innerHTML = m.html;
	            m.html = div.querySelector('.J_msg').outerHTML;
	            //m.html = msgEl.querySelector('.J_msg').outerHTML;
	          }
	          _this.MsgList.push(m);
	          _this.MsgIdInCache[msg.msgid] = 1;
	          _this.MsgIdOnScreen[msg.msgid] = 1;
	        });
	      }

	      this.msgLen = this.MsgList.length;

	      //this.spliter && this.__insert(this.spliter);
	    }
	  }, {
	    key: 'removeMsg',
	    value: function removeMsg(msgid) {
	      delete this.MsgIdInCache[msgid];
	      delete this.MsgIdOnScreen[msgid];
	      var l = this.MsgList.length;

	      for (var i = 0; i < l; i++) {
	        if (this.MsgList[i].msgid === msgid) {
	          this.MsgList.splice(i, 1);
	          break;
	        }
	      }
	    }
	  }, {
	    key: 'getConvertedMsg',
	    value: function getConvertedMsg(msg, credible, ignorePrevMsg, next) {

	      // 如果存在上一条消息
	      // 比较上一条消息的发送方跟当前这条消息的发送方
	      // 如果发送方一样
	      // 并且消息类型一样
	      // 并且消息时间不超过1分钟,
	      // 那么消息需要合并
	      if (!ignorePrevMsg && this.prevMsg && _util2.default.getUid(this.prevMsg.fromid) === _util2.default.getUid(msg.fromid) && this.prevMsg.msgtype === msg.msgtype && parseInt(msg.msgtime) - parseInt(this.prevMsg.msgtime) < 60000) {
	        msg.fold = true;
	      }

	      // 缓存此条消息
	      this.prevMsg = msg;

	      // 开始解析消息
	      var convert = _convert2.default.convert(this.label, msg, 'msgtype');

	      // 如果不存在解析结果
	      // 或者不存在对应的html字符串
	      // 直接返回null
	      if (!convert || !convert.html) return null;

	      if (this.spliter && !this.spliterRendered) {
	        if (msg.msgtime <= this.spliter.msgtime && (!next || next.msgtime > this.spliter.msgtime)) {
	          this.spliterRendered = true;
	          convert.html += this.spliter.html;
	        }
	      }

	      // 如果存在解析后需要执行的回调, 缓存
	      convert.callback && this.MsgCallbackList.push(convert.callback);

	      // 返回解析结果
	      return {
	        msgid: msg.msgid,
	        msgtime: msg.msgtime,
	        credible: credible,
	        html: convert.html
	      };
	    }

	    /**
	     * 往消息队列中插消息
	     * @param msgList 消息列表
	     * @param credible 是否为可信的消息,可信消息会将消息队列遍历一遍将连续的可信消息转成html
	     * @param doNotClear
	     * @returns {MessageManager}
	     */

	  }, {
	    key: 'insert',
	    value: function insert(msgList, credible, doNotClear) {
	      var _this2 = this;

	      if (msgList && msgList.length) {
	        var cache = void 0,
	            html = '',
	            len = msgList.length;
	        var hasCache = false;
	        var dateCache = this.dateCache || '';
	        var date = '';

	        this.firstMsgInHistory = msgList[0];
	        this.lastMsgInHistory = msgList[msgList.length - 1];
	        // 记录当前插入的消息条数,为了与checkAndInsert中的消息条数做对比
	        this.LastInsertMsgLen = msgList.length;

	        msgList.forEach(function (msg, index) {
	          if (_this2.MsgIdOnScreen[msg.msgid]) {
	            hasCache = true;
	            return console.log('已经存在 ' + msg.msgid + ' 消息');
	          }

	          // 缓存所有需要上屏的消息id
	          _this2.MsgIdOnScreen[msg.msgid] = 1;

	          // 解析消息
	          cache = _this2.getConvertedMsg(msg, credible, index === 0 && len > 1, msgList[index + 1]);

	          if (!cache) return;

	          date = new Date(parseInt(msg.msgtime, 10)).__getOnlyDate();
	          if (date !== dateCache) {
	            dateCache = date;
	            html += (0, _$JuicerRoot2.default)(_template2.default.dateSplit, { date: date });
	          }

	          _this2.__insert(cache);
	          html += cache.html;
	        });

	        this.dateCache = dateCache;

	        if (html) {
	          var fragment = document.createDocumentFragment();
	          var div = document.createElement('div');

	          div.innerHTML = html;

	          while (div.childNodes[0]) {
	            fragment.appendChild(div.childNodes[0]);
	          }

	          this.TempConvertDOM = fragment;

	          this.clearCredibleInMsgList(doNotClear);
	        } else {
	          this.TempConvertDOM = null;
	        }
	      } else {
	        this.TempConvertDOM = null;
	      }

	      return this;
	    }
	  }, {
	    key: 'insertBefore',
	    value: function insertBefore(msgList) {
	      var _this3 = this;

	      var cache = void 0;
	      var html = '';
	      var f = document.createDocumentFragment();
	      var div = document.createElement('div');
	      var dateCache = '';
	      var date = '';

	      this.MAX_MSG_LENGTH += _constants2.default.Other.fetchMsgCount;
	      //window.MAX_MSG_LENGTH += Constant.Other.fetchMsgCount;

	      msgList.forEach(function (msg, index) {
	        if (_this3.MsgIdOnScreen[msg.msgid]) {
	          console.log('已经存在 ' + msg.msgid + ' 消息');
	          return;
	        }

	        _this3.MsgIdOnScreen[msg.msgid] = 1;
	        cache = _this3.getConvertedMsg(msg, true, index === 0, msgList[index + 1]);

	        if (!cache) return;

	        date = new Date(parseInt(msg.msgtime, 10)).__getOnlyDate();
	        if (date !== dateCache) {
	          dateCache = date;
	          html += (0, _$JuicerRoot2.default)(_template2.default.dateSplit, { date: date });
	        }

	        html += cache.html;
	      });

	      if (html) {
	        div.innerHTML = html;
	        while (div.childNodes[0]) {
	          f.appendChild(div.childNodes[0]);
	        }
	        this.TempConvertDOM = f;
	        this.HTML = html + this.HTML;
	      } else {
	        this.TempConvertDOM = null;
	      }

	      return this;
	    }

	    /**
	     * 检查消息重复并插入到消息队列中
	     * @param msgList 消息
	     * @param credible 是否设置为可信
	     * @returns {*}
	     */

	  }, {
	    key: 'checkAndInsert',
	    value: function checkAndInsert(msgList, credible /*, isNetReconnected */) {
	      var _this4 = this;

	      var cache = void 0;
	      var len = msgList.length;
	      var changed = false;
	      var isRepeat = false;
	      var firstMsg = msgList[0];
	      var lastMsg = msgList[msgList.length - 1];

	      // if(isNetReconnected) {
	      //   this.HTML = this.container.innerHTML;
	      //   this.MsgList = [];
	      // }
	      // 如果第一条跟最后一条消息已经上过屏了,
	      // 则表示里面的所有消息都上过屏了
	      if (this.LastInsertMsgLen != len || this.firstMsgInHistory && this.firstMsgInHistory.msgid !== firstMsg.msgid || this.lastMsgInHistory && this.lastMsgInHistory.msgid !== lastMsg.msgid) {

	        if (this.MsgList.length && this.MsgList[0].msgtime < firstMsg.msgtime) {
	          console.log('清除所有缓存', this.MsgIdOnScreen);
	          this.clear(lastMsg);
	        }

	        if (this.MsgList.length) {
	          this.spliterRendered = false;
	        }
	        var firstCredibleMsg = this.MsgList.length && this.MsgList[0].credible && this.MsgList[0];

	        // 如果缓存的最后一条消息的时间比新传入的第一条消息还要小,说明没有重合的消息,有丢消息的风险,需要清除后再上屏
	        //if(this.MsgList.length && this.MsgList[this.MsgList.length - 1].msgtime < firstMsg.msgtime
	        //  || (this.firstMsgInHistory && this.lastMsgInHistory && this.firstMsgInHistory.msgtime > firstMsg.msgtime && lastMsg.msgtime > this.firstMsgInHistory.msgtime && this.lastMsgInHistory.msgtime >= lastMsg.msgtime)
	        //) {
	        //  console.log('mustCross', this.MsgIdOnScreen);
	        //  this.clear();
	        //}

	        this.firstMsgInHistory = msgList[0];

	        msgList.forEach(function (msg, index) {

	          // 如果已经上过屏, 则不再处理
	          if (_this4.MsgIdOnScreen[msg.msgid]) {
	            isRepeat = true;
	            // 再次解析,保证extra能够再次执行
	            var _cache = _this4.getConvertedMsg(msg, credible, index === 0 && len > 1, msgList[index + 1]);
	            if (_cache) {
	              _this4.replaceNodeById(msg.msgid, _cache.html);
	            }
	            return;
	          }

	          _this4.MsgIdOnScreen[msg.msgid] = 1;
	          cache = _this4.getConvertedMsg(msg, credible, index === 0 && len > 1, msgList[index + 1]);
	          if (!cache) return;

	          // 如果没有上屏的消息比在缓存列表中可信的消息时间小, 则不再去将消息上屏,因为会导致乱序
	          if (firstCredibleMsg && firstCredibleMsg.msgtime > msg.msgtime) return;

	          changed = true;
	          _this4.__insert(cache);
	        });

	        // 缓存中的html需要更新为目前已经上屏的html
	        // 防止已经更新过的html被再次替换成为更新时的状态
	        //let msgEl;
	        //let div = document.createElement('div');
	        //
	        //this.MsgList.forEach(m => {
	        //  msgEl = document.getElementById(m.msgid);
	        //
	        //  if(msgEl) {
	        //    div.innerHTML = m.html;
	        //    m.html = div.querySelector('.J_msg').outerHTML;
	        //  }
	        //});
	      }

	      this.setCredible(true);

	      this.clearCredibleInMsgList();

	      this.MsgList.length && (this.prevMsg = this.MsgList[this.MsgList.length - 1]);

	      if (!changed) {
	        return changed;
	      }
	      return this;
	    }
	  }, {
	    key: '__insert',
	    value: function __insert(cache) {
	      var _that = this;
	      var len = this.MsgList.length;

	      var __cache = Object.assign({}, cache);

	      // 如果存在消息缓存
	      if (len) {
	        // 如果缓存消息的最后一条消息比要缓存的消息时间小,
	        // 那么直接将要缓存的消息往后放
	        if (this.MsgList[len - 1].msgtime <= cache.msgtime) {
	          this.MsgList.push(cache);
	          this.msgLen++;
	        }
	        // 判断第一条的消息时间是否比要缓存的消息时间大,
	        // 如果大, 那么就将消息往前放,保证消息时间是从小到大的排序
	        else if (this.MsgList[0].msgtime >= cache.msgtime) {
	            this.MsgList.unshift(cache);
	            this.msgLen++;
	          }
	          // 否则, 需要找到缓存消息中某一条比要缓存的消息的时间大的那条
	          // 将缓存消息插到此条消息前
	          else {
	              for (var i = 0; i < len; i++) {
	                if (_that.MsgList[i].msgtime >= cache.msgtime) {
	                  _that.MsgList.splice(i, 0, cache);
	                  this.msgLen++;
	                  break;
	                }
	              }
	            }
	      } else {
	        this.MsgList.push(cache);
	        this.msgLen++;
	      }

	      this.MsgIdInCache[cache.msgid] = 1;
	    }
	  }, {
	    key: 'clearCredibleInMsgList',
	    value: function clearCredibleInMsgList(force, needSpliter) {
	      var _that = this;
	      var div = document.createElement('div');
	      var len = this.MsgList.length;
	      var html = '';
	      var prevHtml = '';
	      var cache = void 0;
	      var i = 0;
	      var dateCache = this.dateCache || '';
	      var date = '';
	      var dateHtml = '';

	      // 遍历消息缓存
	      // 当非强制转换时,碰到不是可信的消息则停止
	      for (; i < len; i++) {
	        cache = _that.MsgList[i];

	        if (!force && !cache.credible) {
	          break;
	        } else {

	          dateHtml = '';
	          date = new Date(parseInt(cache.msgtime, 10)).__getOnlyDate();
	          if (date !== dateCache) {
	            dateCache = date;
	            dateHtml = (0, _$JuicerRoot2.default)(_template2.default.dateSplit, { date: date });
	            this.dateCache = dateCache;
	          }

	          var h = cache.html;

	          if (needSpliter && this.spliter && !this.spliterRendered) {
	            var next = _that.MsgList[i + 1];
	            if (cache.msgtime < this.spliter.msgtime && (!next || next.msgtime > this.spliter.msgtime)) {
	              h += this.spliter.html;
	            }
	          }

	          html += prevHtml;
	          prevHtml = dateHtml + h;
	          !force && delete this.MsgIdInCache[cache.msgid];
	        }
	      }
	      // 如果不是强制的临时转换
	      if (!force && i) {
	        // 留一条可信的在列表中
	        i--;
	        this.MsgList.splice(0, i);
	        this.MsgList.length && (this.MsgIdInCache[this.MsgList[0].msgid] = 1);
	        this.HTML += html;
	      }
	      force && (html += prevHtml);

	      return html;
	    }

	    //getFirstRealMsg(key) {
	    //  let found = false;
	    //  let firstMsg;
	    //  let i = 0;
	    //
	    //  while(this.MsgList[i] && !found) {
	    //    if(!this.MsgList[i].split && this.MsgList[i][key]) {
	    //      found = true;
	    //      firstMsg = this.MsgList[i];
	    //      break;
	    //    }else {
	    //      i++;
	    //    }
	    //  }
	    //
	    //
	    //  return firstMsg;
	    //}

	    /**
	     * 运行转换成DOM时需要运行的一些callback
	     * 当callback的回调返回时如果不是当前联系人了,仍然需要存下来
	     */

	  }, {
	    key: 'runExtra',
	    value: function runExtra() {
	      var _that = this;
	      var cid = this.cid;

	      this.MsgCallbackList = this.MsgCallbackList.concat(this.UnresolvedCallbackList);
	      this.UnresolvedCallbackList = [];

	      this.MsgCallbackList.forEach(function (callback) {
	        callback(function () {
	          if (_util2.default.getUid(_window2.default.conversationID) !== cid) {
	            _that.UnresolvedCallbackList.push(callback);
	            return false;
	          }
	          return true;
	        });
	      });

	      this.MsgCallbackList = [];
	    }
	  }, {
	    key: 'setCredible',
	    value: function setCredible(credible) {
	      this.MsgList.forEach(function (cache) {
	        cache.credible != credible && (cache.credible = credible);
	      });

	      return this;
	    }

	    /**
	     * 获取最后一次convertToDOM获得的DOM
	     * @returns {null|DocumentFragment|*}
	     */

	  }, {
	    key: 'getTempConvertDOM',
	    value: function getTempConvertDOM() {
	      return this.TempConvertDOM;
	    }
	  }, {
	    key: 'clearCache',
	    value: function clearCache() {
	      var msgList = [].concat(_toConsumableArray(this.MsgList));
	      var html = this.HTML;
	      //this.spliter = null;
	      this.clear();
	      this.backToList(msgList, html);
	    }
	  }, {
	    key: 'backToList',
	    value: function backToList(list, html) {
	      var _this5 = this;

	      var i = list.length;
	      var msgList = [].concat(_toConsumableArray(list));
	      var item = void 0;

	      this.isClose = true;
	      if (i > 20) {
	        msgList = list.splice(list.length - 20, list.length - 1);
	      } else {
	        //msgList = [];
	        //i = 0;
	        var div = document.createElement('div');
	        div.innerHTML = html;

	        var el = div.lastChild;

	        while (el) {
	          if (i >= 20 || !el) {
	            break;
	          }

	          if (el.classList && el.id && !el.classList.contains('history-split')) {
	            item = {
	              msgid: el.id,
	              msgtime: el.getAttribute('data-time'),
	              credible: false,
	              html: el.outerHTML
	            };

	            msgList.unshift(item);
	            i++;
	          }
	          div.removeChild(el);
	          el = div.lastChild;
	        }
	      }

	      msgList.forEach(function (msg, index) {
	        _this5.MsgIdInCache[msg.msgid] = 1;
	        _this5.MsgIdOnScreen[msg.msgid] = 1;
	      });

	      this.MsgList = msgList;
	    }
	  }, {
	    key: 'save',
	    value: function save() {
	      //if(this.isClose) return;
	      var con = this.container;
	      this.spliterRendered = false;
	      var msgList = this.MsgList;
	      var m = void 0;

	      // 遍历还在缓存中的消息id
	      for (var id in this.MsgIdInCache) {
	        m = document.getElementById(id);

	        if (m && m.previousElementSibling && m.previousElementSibling.classList.contains('imui-msg-date-split')) {
	          con.removeChild(m.previousElementSibling);
	        }

	        if (!m) continue;

	        // 找到在缓存, 重新获取缓存中的消息的html, 以防消息有什么变动
	        for (var i = 0, l = msgList.length; i < l; i++) {
	          if (msgList[i].msgid === id) {
	            msgList[i].html = m.outerHTML;
	            break;
	          }
	        }
	        // 移除消息元素
	        con.removeChild(m);
	      }

	      this.prevMsg = null;
	      if (!this.isClose) {
	        // 缓存已上屏的消息html
	        this.HTML = this.container.innerHTML;
	      }
	    }
	  }, {
	    key: 'render',
	    value: function render() {
	      this.isClose = false;
	      this.container.innerHTML = this.HTML + this.clearCredibleInMsgList(1, 1);
	      this.runExtra();
	      var h = [].concat(_toConsumableArray(this.container.querySelectorAll('.history-split')));
	      h.pop();

	      h.forEach(function (el) {
	        el.parentNode.removeChild(el);
	      });
	    }

	    /**
	     * 插到container的后面
	     * @param f
	     */

	  }, {
	    key: 'append',
	    value: function append(f) {
	      this.container.appendChild(f);
	      this.runExtra();

	      if (this.msgLen > this.MAX_MSG_LENGTH) {
	        //if(this.msgLen > window.MAX_MSG_LENGTH) {
	        var i = this.msgLen - this.MAX_MSG_LENGTH;
	        //let i = this.msgLen - window.MAX_MSG_LENGTH;
	        var el = this.container.firstChild;

	        while (el) {
	          if (i <= 0) break;
	          this.container.removeChild(el);
	          i--;

	          el = this.container.firstChild;
	        }

	        el = this.container.firstChild;
	        var msgid = el.id;
	        var msgtime = el.getAttribute('data-time');
	        var cache = Cache.get(this.cid);

	        cache.FirstMsg && Cache.set(this.cid, {
	          FirstMsg: { msgid: msgid, msgtime: msgtime }
	        });

	        this.msgLen = this.MAX_MSG_LENGTH;
	        //this.msgLen = window.MAX_MSG_LENGTH;
	      }
	    }

	    /**
	     * 插到container的最前面
	     * @param f
	     */

	  }, {
	    key: 'prepend',
	    value: function prepend(f) {
	      this.container.insertBefore(f, this.container.firstChild);
	      this.runExtra();
	    }
	  }, {
	    key: 'renderOver',
	    value: function renderOver() {
	      _convert2.default.over(_window2.default.conversationID);
	    }
	  }, {
	    key: 'replaceNodeById',
	    value: function replaceNodeById(id, html) {
	      var _temp = document.createElement('div');
	      _temp.innerHTML = html;
	      var _msgNode = _temp.getElementsByClassName('J_msg') && _temp.getElementsByClassName('J_msg')[0];
	      var _node = document.getElementById(id);

	      if (_node && _msgNode) {
	        _node.outerHTML = _msgNode.outerHTML;
	      }
	    }
	  }]);

	  return MessageManager;
	}();

	exports.default = MessageManager;

/***/ },
/* 183 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _$ConvertRoot = __webpack_require__(8);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	// import CUM from '../coms/conversationUsersManager';

	_$ConvertRoot.Callbacks.setCallbacks('DEFAULT', function (data) {
	  if (!data || !data.cid) return;

	  // CUM.setCidUser(Util.getUid(data.cid), Util.getUid(data.from));

	  if (data.readflag === 1 || data.isFail) return;

	  _util2.default.setCidType(data.cid);

	  if (data.cid.type !== _constants2.default.Other.TYPE.SINGLE) return;

	  if (!data.svrtime) return;

	  _$ConvertRoot.Action.msgReadStatus.push(data.cid, data);
	}); /**
	     * Created by neitherzhu on 2016/12/6.
	     * 消息解析器
	     */


	_$ConvertRoot.Convert.addOverCallback(function (cid) {
	  _$ConvertRoot.Action.msgReadStatus.action(cid);
	});

	exports.default = _$ConvertRoot.Convert;

/***/ },
/* 184 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _plugins = __webpack_require__(167);

	var _plugins2 = _interopRequireDefault(_plugins);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Cache = _$BaseRoot.Base.Cache; /**
	                                    * Created by neitherzhu on 2016/12/6.
	                                    * 获取离线消息
	                                    */

	var getOfflineMsg = new _$BaseRoot.Base.ActionCreator();

	getOfflineMsg.actionType = 'async';

	getOfflineMsg.doAsync = function (context, contact) {
	  var uid = _util2.default.getUid(contact);
	  var cache = Cache.get(uid);
	  var messageManager = cache.messageManager;

	  context.messageManager = messageManager;
	  return new Promise(function (resolve, reject) {
	    _sdk2.default.getOfflineMsg(contact).then(function (data) {

	      if (!data || !data.length) return resolve();

	      messageManager.insert(data, false);

	      if (uid !== _util2.default.getUid(_window2.default.conversationID)) return reject('not current conversation');

	      var els = [],
	          tempDom = messageManager.getTempConvertDOM();

	      if (!tempDom) return resolve();

	      for (var i = 0, l = tempDom.childNodes.length; i < l; i++) {
	        els.push(tempDom.childNodes[i]);
	      }

	      messageManager.append(tempDom);
	      resolve({ list: data, els: els });
	    }).catch(function (err) {
	      reject(err);
	    });
	  });
	};

	getOfflineMsg.after(function (context, data) {

	  _window2.default.isBottom && _util2.default.scrollToBottom(_window2.default.container, data ? data.els : null);

	  context.messageManager.renderOver();

	  if (!data) return;
	  var plugin = _plugins2.default.getPlugin('newMsgTip');
	  plugin && plugin[_window2.default.isBottom ? 'hide' : 'show']();
	});

	getOfflineMsg.error = function (err) {
	  console.error('Action getOfflineMsg Error', err);
	};

	exports.default = getOfflineMsg;

/***/ },
/* 185 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _event = __webpack_require__(162);

	var _event2 = _interopRequireDefault(_event);

	var _index = __webpack_require__(6);

	var _index2 = _interopRequireDefault(_index);

	var _plugins = __webpack_require__(167);

	var _plugins2 = _interopRequireDefault(_plugins);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/6.
	 * 获取在线未读消息
	 */
	var Cache = _$BaseRoot.Base.Cache;

	var getNewMsg = new _$BaseRoot.Base.ActionCreator();

	getNewMsg.actionType = 'async';

	getNewMsg.doAsync = function (context, contact) {
	  var uid = _util2.default.getUid(contact);
	  var cache = Cache.get(uid);
	  var messageManager = cache.messageManager;

	  context.param = {
	    cid: contact
	  };
	  context.messageManager = messageManager;

	  return new Promise(function (resolve, reject) {
	    _sdk2.default.getNewMsg(contact).then(function (data) {

	      var list = data && data.msgs;

	      if (!list || !list.length) return resolve();

	      // 超过客户端缓存的限制, 清除所有上屏消息与缓存
	      data.outofcache && messageManager.clear() && (_window2.default.container.innerHTML = '');

	      // 首次上屏为不可信消息 其他都是可信消息
	      messageManager.insert(list, !!cache.isFirstOk, true);

	      if (uid !== _util2.default.getUid(_window2.default.conversationID)) return reject('not current conversation');

	      var els = [],
	          tempDom = messageManager.getTempConvertDOM();

	      if (!tempDom) return resolve();

	      for (var i = 0, l = tempDom.childNodes.length; i < l; i++) {
	        els.push(tempDom.childNodes[i]);
	      }

	      messageManager.append(tempDom);

	      resolve({ list: data, els: els });
	    }).catch(function (err) {
	      reject(err);
	    });
	  });
	};

	getNewMsg.after(function (context, data) {
	  var param = context.param;
	  var cache = Cache.get(_util2.default.getUid(param.cid));

	  !cache.isFirstOk && !cache.messageManager.MsgList.length && _index2.default.getLocalHistoryMsg.action(param);
	  (!cache.isFirstOk || cache.isNetReconnected) && _index2.default.getRemoteHistoryMsg.action(param);
	  cache.isFirstOk && !cache.isNetReconnected && _event2.default.emit(_constants2.default.Event.CONVERSATION_CHANGE_OVER);
	});

	getNewMsg.after(function (context, data) {

	  _window2.default.isBottom && _util2.default.scrollToBottom(_window2.default.container, data ? data.els : null);
	  context.messageManager.renderOver();
	  if (!data) return;

	  var plugin = _plugins2.default.getPlugin('newMsgTip');
	  plugin && plugin[_window2.default.isBottom ? 'hide' : 'show']();
	});

	getNewMsg.error = function (err) {
	  console.error('Action getNewMsg Error', err);
	};

	exports.default = getNewMsg;

/***/ },
/* 186 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Cache = _$BaseRoot.Base.Cache; /**
	                                    * Created by neitherzhu on 2016/12/6.
	                                    * 获取本地历史消息
	                                    */

	var getLocalHistoryMsg = new _$BaseRoot.Base.ActionCreator();

	getLocalHistoryMsg.actionType = 'async';

	getLocalHistoryMsg.before(function (context, param) {
	  !param.msgid && (param.msgid = '-1');
	  !param.msgtime && (param.msgtime = '-1');
	  !param.count && (param.count = _constants2.default.Other.fetchMsgCount);
	});

	getLocalHistoryMsg.doAsync = function (context, param) {
	  var contact = param.cid;
	  var uid = _util2.default.getUid(contact);
	  var cache = Cache.get(uid);
	  var messageManager = cache.messageManager;

	  return new Promise(function (resolve, reject) {
	    _sdk2.default.getLocalHistoryMsg(param).then(function (data) {

	      if (!data || !data.length) return reject('msg is empty!');

	      //let hasNextPage = data.length >= param.count;

	      messageManager.insert(data, false);

	      if (uid !== _util2.default.getUid(_window2.default.conversationID)) return reject('not current user');

	      var els = [];
	      var tempDom = messageManager.getTempConvertDOM();

	      if (!tempDom) return reject();

	      for (var i = 0, l = tempDom.childNodes.length; i < l; i++) {
	        els.push(tempDom.childNodes[i]);
	      }

	      messageManager.prepend(tempDom);

	      resolve({ list: data, els: els });
	    }).catch(function (err) {
	      reject(err);
	    });
	  });
	};

	getLocalHistoryMsg.after(function (context, data) {
	  if (!data) return;

	  _util2.default.scrollToBottom(_window2.default.container, data.els);
	});

	getLocalHistoryMsg.error = function (err) {
	  _util2.default.scrollToBottom(_window2.default.container);
	  console.error('Action getLocalHistoryMsg Error', err);
	};

	exports.default = getLocalHistoryMsg;

/***/ },
/* 187 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$ConvertRoot = __webpack_require__(8);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _event = __webpack_require__(162);

	var _event2 = _interopRequireDefault(_event);

	var _index = __webpack_require__(6);

	var _index2 = _interopRequireDefault(_index);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
	                                                                                                                                                                                                     * Created by neitherzhu on 2016/12/6.
	                                                                                                                                                                                                     * 获取漫游历史消息
	                                                                                                                                                                                                     */


	var Cache = _$BaseRoot.Base.Cache;
	var getRemoteHistoryMsg = new _$BaseRoot.Base.ActionCreator();

	getRemoteHistoryMsg.actionType = 'async';

	getRemoteHistoryMsg.before(function (context, param) {
	  !param.msgid && (param.msgid = '-1');
	  !param.msgtime && (param.msgtime = '-1');
	  !param.count && (param.count = _constants2.default.Other.fetchMsgCount);
	});

	getRemoteHistoryMsg.doAsync = function (context, param) {
	  var contact = param.cid;
	  var uid = _util2.default.getUid(contact);
	  var cache = Cache.get(uid);
	  var isNetReconnected = cache.isNetReconnected;
	  var messageManager = cache.messageManager;

	  context.messageManager = messageManager;
	  return new Promise(function (resolve, reject) {
	    _sdk2.default.getRemoteHistoryMsg(param).then(function (data) {

	      var c = {};
	      !cache.isFirstOk && (c.isFirstOk = true);
	      isNetReconnected && (c.isNetReconnected = false);

	      if (!data || !data.length) {
	        Cache.set(uid, c);
	        messageManager.setCredible(true).clearCredibleInMsgList();
	        return resolve();
	      }

	      var hasNextPage = data.length >= param.count;
	      var needToUpdate = messageManager.checkAndInsert(data, true, isNetReconnected);

	      if (uid !== _util2.default.getUid(_window2.default.conversationID)) {
	        return reject('not current user');
	      }

	      var els = [];

	      !needToUpdate && messageManager.runExtra();
	      if (needToUpdate) {
	        messageManager.render();
	        els = [].concat(_toConsumableArray(_window2.default.container.querySelectorAll('.' + _constants2.default.CLS.MSG_CONTAINER)));
	      }
	      // 如果电线重连过
	      // 如果是群
	      // 需要重新获取没有全部已读的@消息的已读未读人数
	      else if (cache.isNetReconnected && param.cid.type == 2) {
	          var ids = {},
	              items = [];
	          [].concat(_toConsumableArray(_window2.default.container.querySelectorAll('.' + _constants2.default.CLS.AT_MSG))).forEach(function (el) {
	            el = _util2.default.parents(el, _constants2.default.CLS.MSG_CONTAINER);
	            if (el && el.id && !ids[el.id] && !el.classList.contains(_constants2.default.CLS.COMPLETED_AT_MSG)) {
	              ids[el.id] = 1;
	            }
	          });

	          Object.keys(ids).forEach(function (id) {
	            items.push({
	              userid: _window2.default.loginID,
	              msgid: id
	            });
	          });

	          items.length && _$ConvertRoot.Action.getAtMsgReadState.action(param.cid, items);
	        }

	      c.hasNextPage = hasNextPage;

	      Cache.set(uid, c);

	      context.cache = Cache.get(uid);

	      resolve({ list: data, els: els });
	    }).catch(function (err) {
	      messageManager.setCredible(true).clearCredibleInMsgList();

	      var c = {};
	      !cache.isFirstOk && (c.isFirstOk = true);
	      isNetReconnected && (c.isNetReconnected = false);
	      Cache.set(uid, c);

	      _event2.default.emit(_constants2.default.Event.CONVERSATION_CHANGE_OVER);
	      reject(err);
	    });
	  });
	};

	getRemoteHistoryMsg.after(function (context, data) {
	  _event2.default.emit(_constants2.default.Event.CONVERSATION_CHANGE_OVER);
	});

	getRemoteHistoryMsg.after(function (context, data) {

	  _util2.default.scrollToBottom(_window2.default.container, data ? data.els : null);
	  context.messageManager.renderOver();

	  if (context.cache && context.cache.hasNextPage && _window2.default.container.scrollHeight <= _window2.default.container.clientHeight) {
	    _index2.default.getMoreHistoryMsg.action({ cid: _window2.default.conversationID });
	  }
	});

	getRemoteHistoryMsg.error = function (err) {
	  _util2.default.scrollToBottom(_window2.default.container);
	  console.error('Action getRemoteHistoryMsg Error', err);
	};

	exports.default = getRemoteHistoryMsg;

/***/ },
/* 188 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _plugins = __webpack_require__(167);

	var _plugins2 = _interopRequireDefault(_plugins);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Cache = _$BaseRoot.Base.Cache; /**
	                                    * Created by neitherzhu on 2016/12/7.
	                                    * 接收新消息
	                                    */

	var receiveMsg = new _$BaseRoot.Base.ActionCreator();

	receiveMsg.actionType = 'async';

	receiveMsg.doAsync = function (context, contact) {
	  var uid = _util2.default.getUid(contact);
	  var cache = Cache.get(uid);
	  var messageManager = cache.messageManager;

	  context.messageManager = messageManager;
	  return new Promise(function (resolve, reject) {
	    _sdk2.default.getNewMsg(contact).then(function (data) {

	      var list = data && data.msgs;

	      if (!list || !list.length) return resolve();

	      // 超过客户端缓存的限制, 清除所有上屏消息与缓存
	      data.outofcache && messageManager.clear() && (_window2.default.container.innerHTML = '');

	      messageManager.insert(list, !!cache.isFirstOk);

	      if (uid !== _util2.default.getUid(_window2.default.conversationID)) return reject();

	      var els = [],
	          tempDom = messageManager.getTempConvertDOM();

	      if (!tempDom) return resolve();

	      for (var i = 0, l = tempDom.childNodes.length; i < l; i++) {
	        els.push(tempDom.childNodes[i]);
	      }

	      messageManager.append(tempDom);

	      resolve({ list: data, els: els });
	    }).catch(function (err) {
	      reject(err);
	    });
	  });
	};

	receiveMsg.after(function (context, data) {
	  if (!data) return;

	  _window2.default.isBottom && _util2.default.scrollToBottom(_window2.default.container, data.els);

	  context.messageManager.renderOver();

	  var plugin = _plugins2.default.getPlugin('newMsgTip');
	  plugin && plugin[_window2.default.isBottom ? 'hide' : 'show']();
	});

	receiveMsg.error = function (err) {
	  console.error('Action getNewMsg Error', err);
	};

	exports.default = receiveMsg;

/***/ },
/* 189 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _plugins = __webpack_require__(167);

	var _plugins2 = _interopRequireDefault(_plugins);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Cache = _$BaseRoot.Base.Cache; /**
	                                    * Created by neitherzhu on 2016/12/7.
	                                    * 获取自己发送的消息
	                                    */

	var getSentMsg = new _$BaseRoot.Base.ActionCreator();

	getSentMsg.actionType = 'async';

	getSentMsg.doAsync = function (context, contact) {
	  var uid = _util2.default.getUid(contact);
	  var cache = Cache.get(uid);
	  var messageManager = cache.messageManager;

	  context.messageManager = messageManager;
	  return new Promise(function (resolve, reject) {
	    _sdk2.default.getNewMsg(contact).then(function (data) {

	      var list = data && data.msgs;

	      if (!list || !list.length) return resolve();

	      // 超过客户端缓存的限制, 清除所有上屏消息与缓存
	      data.outofcache && messageManager.clear() && (_window2.default.container.innerHTML = '');

	      messageManager.insert(list, true);

	      if (uid !== _util2.default.getUid(_window2.default.conversationID)) return reject();

	      var els = [],
	          tempDom = messageManager.getTempConvertDOM();

	      if (!tempDom) return resolve();

	      for (var i = 0, l = tempDom.childNodes.length; i < l; i++) {
	        els.push(tempDom.childNodes[i]);
	      }

	      messageManager.append(tempDom);

	      resolve({ list: data, els: els });
	    }).catch(function (err) {
	      reject(err);
	    });
	  });
	};

	getSentMsg.after(function (context, data) {
	  if (!data) return;

	  _util2.default.scrollToBottom(_window2.default.container, data.els);

	  context.messageManager.renderOver();
	  var plugin = _plugins2.default.getPlugin('newMsgTip');
	  plugin && plugin.hide();
	});

	getSentMsg.error = function (err) {
	  console.error('Action getNewMsg Error', err);
	};

	exports.default = getSentMsg;

/***/ },
/* 190 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _index = __webpack_require__(6);

	var _index2 = _interopRequireDefault(_index);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _conversationManager = __webpack_require__(163);

	var _conversationManager2 = _interopRequireDefault(_conversationManager);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/8.
	 * 窗口关闭
	 */
	var Cache = _$BaseRoot.Base.Cache;


	var conversationClose = new _$BaseRoot.Base.ActionCreator();
	conversationClose.doSync = function (context, data) {

	  if (data.closeall === 1) {
	    // 全关
	    _index2.default.conversationChange.action();
	    Cache.clear();
	    _window2.default.container.innerHTML = '';
	  } else {
	    // 关闭某个联系对象
	    var uid = _util2.default.getUid(data.cid);
	    var cache = Cache.get(uid);
	    var messageManager = cache.messageManager;

	    Cache.clear(uid);
	    messageManager.clearCache();
	    Cache.set(uid, {
	      messageManager: messageManager
	    });

	    // 只缓存单聊
	    _util2.default.setCidType(data.cid).type === _constants2.default.Other.TYPE.SINGLE && _conversationManager2.default.add(uid);

	    if (uid === _util2.default.getUid(_window2.default.conversationID)) {
	      _index2.default.conversationChange.action();
	      _window2.default.container.innerHTML = '';
	    }
	  }
	};

	exports.default = conversationClose;

/***/ },
/* 191 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _event = __webpack_require__(162);

	var _event2 = _interopRequireDefault(_event);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _plugins = __webpack_require__(167);

	var _plugins2 = _interopRequireDefault(_plugins);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/8.
	 * 断网
	 */
	var netDisconnect = new _$BaseRoot.Base.ActionCreator();

	netDisconnect.doSync = function () {

	  _event2.default.emit(_constants2.default.Event.NET_ERROR, true);
	};

	netDisconnect.after(function () {
	  var scroll = _plugins2.default.getPlugin('scroll');

	  scroll && scroll.disableScroll();
	});

	exports.default = netDisconnect;

/***/ },
/* 192 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _event = __webpack_require__(162);

	var _event2 = _interopRequireDefault(_event);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _index = __webpack_require__(6);

	var _index2 = _interopRequireDefault(_index);

	var _plugins = __webpack_require__(167);

	var _plugins2 = _interopRequireDefault(_plugins);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/8.
	 * 网络重连
	 */
	var Cache = _$BaseRoot.Base.Cache;

	var netReconnect = new _$BaseRoot.Base.ActionCreator();

	netReconnect.before(function () {
	  var scroll = _plugins2.default.getPlugin('scroll');

	  scroll && scroll.enableScroll();
	});

	netReconnect.doSync = function () {

	  Cache.setAll({ isNetReconnected: true });
	  _event2.default.emit(_constants2.default.Event.NET_ERROR, false);
	};

	netReconnect.after(function () {
	  if (!_window2.default.conversationID) return;

	  _index2.default.getOfflineMsg.action(_window2.default.conversationID);
	  _index2.default.getNewMsg.action(_window2.default.conversationID);
	});

	exports.default = netReconnect;

/***/ },
/* 193 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var Cache = _$BaseRoot.Base.Cache; /**
	                                    * Created by neitherzhu on 2016/12/8.
	                                    * 缓存没有触发的事件
	                                    */


	var cacheEvent = new _$BaseRoot.Base.ActionCreator();

	cacheEvent.doSync = function (context, uid, data) {

	  var unResolveEvents = Cache.get(uid).unResolveEvents || [];
	  unResolveEvents.push({
	    event: data.event,
	    data: data
	  });

	  Cache.set(uid, { unResolveEvents: unResolveEvents });
	};

	exports.default = cacheEvent;

/***/ },
/* 194 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _template = __webpack_require__(154);

	var _template2 = _interopRequireDefault(_template);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var enteringStatusChange = new _$BaseRoot.Base.ActionCreator(); /**
	                                                                 * Created by neitherzhu on 2016/12/8.
	                                                                 * 输入状态变更
	                                                                 */


	enteringStatusChange.doSync = function (context, data) {

	  var uid = _util2.default.getUid(data.cid);
	  // 如果不是当前联系对象, 需要缓存?
	  if (uid !== _util2.default.getUid(_window2.default.conversationID)) return;

	  var el = document.getElementById(_constants2.default.EL_ID.ENTERING);

	  if (data.value == 0) {
	    // 输入中
	    el ? el.classList.remove(_constants2.default.CLS.HIDDEN) : document.getElementById(_constants2.default.EL_ID.CONTAINER).parentNode.appendChild(_util2.default.createFragment(_template2.default.entering));
	  } else if (data.value == 1) {
	    // 输入结束
	    el && el.classList.add(_constants2.default.CLS.HIDDEN);
	  }
	};

	exports.default = enteringStatusChange;

/***/ },
/* 195 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$ConvertRoot = __webpack_require__(8);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _template = __webpack_require__(154);

	var _template2 = _interopRequireDefault(_template);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /**
	                                                                                                                                                                                                     * Created by neitherzhu on 2016/12/8.
	                                                                                                                                                                                                     */


	var Cache = _$BaseRoot.Base.Cache;

	var sendMsgStatusChange = new _$BaseRoot.Base.ActionCreator();

	sendMsgStatusChange.doSync = function (context, data) {

	  var msgEl = document.getElementById(data.msgid);

	  if (!msgEl) return;

	  var stateEl = msgEl.querySelector('.' + _constants2.default.CLS.MSG_STATUS_CONTAINER);
	  // 消息发送成功
	  if (data.code === 0) {

	    if (stateEl) {
	      // 方式出现2个菜单
	      if (!stateEl.querySelector('.' + _constants2.default.CLS.MENU_WRAP)) {
	        var tpl = (0, _$JuicerRoot2.default)(_template2.default.menuTrigger, {
	          svrtime: data.svrtime
	        });
	        var menuTrigger = _util2.default.createFragment(tpl);
	        stateEl.parentNode.appendChild(menuTrigger);
	      }
	    }

	    var type = _window2.default.conversationID.type;

	    // 自己发送的实时消息不获取
	    if (type == _constants2.default.Other.TYPE.SINGLE) {
	      // 开启已读未读状态时间比消息时间小的，说明此条消息是需要获取是否已读的状态
	      if (!_window2.default.msgReadOpenTime || _window2.default.msgReadOpenTime <= data.svrtime) {
	        //stateEl.innerHTML = juicer(Template.msgReadStatus, { tpl: Constant.I18N[Constant.LANGUAGE]['AT_MSG_UNREAD'] });

	        _$ConvertRoot.Action.updateMsgReadStatus.action([{
	          msgid: data.msgid,
	          msgtime: data.svrtime,
	          svrtime: data.svrtime,
	          isSelf: true,
	          unread: 1
	        }]);
	      }
	    }
	    // 判断发送成功的消息是否在@消息里面
	    else if ((_window2.default.conversationID.type == _constants2.default.Other.TYPE.TRIBE || _window2.default.conversationID.type == _constants2.default.Other.TYPE.DISCUSSION) && Cache.get('TO_BE_AT_MSG')[data.msgid]) {
	        if (data.subcode === 0) {
	          _$ConvertRoot.Action.getAtMsgReadState.action(data.cid, [{
	            userid: _window2.default.loginID,
	            msgid: data.msgid
	          }]);
	        }
	        // subcode不为0表示群@消息未发送成功
	        else {
	            // 移除@消息的样式
	            [].concat(_toConsumableArray(msgEl.querySelectorAll('.' + _constants2.default.CLS.AT_MSG_WITH_STYLE))).forEach(function (el) {
	              el.classList.remove(_constants2.default.CLS.AT_MSG_WITH_STYLE);
	            });

	            Cache.clearInKey('TO_BE_AT_MSG', data.msgid);
	          }
	      }
	    // 发送成功移除消息样式
	    stateEl && stateEl.classList.remove('J_msgSending');
	  }
	  // 消息发送失败
	  else {
	      if (data.code == 8 && data.subcode == 18874371) return;
	      stateEl && (stateEl.innerHTML = (0, _$JuicerRoot2.default)(_template2.default.errorStatus, { cls: _constants2.default.CLS.RESEND_BTN }));
	    }
	};

	sendMsgStatusChange.after(function (context, data) {
	  if (data.code === 0 && data.svrtime !== '0') {
	    var msg = document.getElementById(data.msgid);
	    if (!msg) return;

	    var trigger = msg.querySelector('.bubble-menu-trigger');

	    if (!trigger) return;

	    trigger.setAttribute('data-svrtime', data.svrtime);
	  }
	});

	exports.default = sendMsgStatusChange;

/***/ },
/* 196 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/8.
	 * 触发缓存的事件
	 */
	var Cache = _$BaseRoot.Base.Cache;

	var fireCacheEvent = new _$BaseRoot.Base.ActionCreator();

	fireCacheEvent.doSync = function () {

	  var uid = _util2.default.getUid(_window2.default.conversationID);
	  var cache = Cache.getExactly(uid);

	  if (!cache) return;

	  var unResolveEvents = cache.unResolveEvents;

	  if (unResolveEvents && unResolveEvents.length) {
	    unResolveEvents.forEach(function (data) {
	      _$IMSDKRoot2.default.fire(data.event, data.data);
	    });

	    Cache.clearInKey(uid, 'unResolveEvents');
	  }
	};

	exports.default = fireCacheEvent;

/***/ },
/* 197 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _sdk = __webpack_require__(138);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Cache = _$BaseRoot.Base.Cache; /**
	                                    * Created by neitherzhu on 2016/12/9.
	                                    * 获取更多历史消息
	                                    */

	var getMoreHistoryMsg = new _$BaseRoot.Base.ActionCreator();

	getMoreHistoryMsg.actionType = 'async';
	getMoreHistoryMsg.pending = false;

	getMoreHistoryMsg.before(function (context, param) {

	  if (this.pending || !param || !param.cid) return false;

	  var cache = Cache.get(_util2.default.getUid(param.cid));

	  if (!cache.hasNextPage) return false;

	  this.pending = true;

	  var i = 0;
	  var firstMsg = _window2.default.container.childNodes[i];

	  while (!firstMsg.tagName || !firstMsg.getAttribute('data-time')) {
	    i++;
	    firstMsg = _window2.default.container.childNodes[i];
	  }

	  if (firstMsg) {
	    param.msgid = firstMsg.id;
	    param.msgtime = firstMsg.getAttribute('data-time');
	  }

	  param.count || (param.count = _constants2.default.Other.fetchMsgCount);
	});

	getMoreHistoryMsg.doAsync = function (context, param) {
	  var contact = param.cid;
	  var uid = _util2.default.getUid(contact);
	  var cache = Cache.get(uid);
	  var messageManager = cache.messageManager;

	  context.messageManager = messageManager;
	  context.msgid = param.msgid;

	  return new Promise(function (resolve, reject) {

	    if (cache.isNetReconnected) {
	      return reject();
	    }

	    _sdk2.default.getRemoteHistoryMsg(param).then(function (data) {

	      if (!data || !data.length) {
	        Cache.set(uid, { hasNextPage: false });
	        return reject('msg is empty!');
	      }

	      var hasNextPage = data.length >= param.count;

	      if (uid !== _util2.default.getUid(_window2.default.conversationID)) return reject();

	      messageManager.insertBefore(data);

	      var els = [];
	      var tempDom = messageManager.getTempConvertDOM();

	      if (!tempDom) return reject();

	      for (var i = 0, l = tempDom.childNodes.length; i < l; i++) {
	        els.push(tempDom.childNodes[i]);
	      }

	      messageManager.prepend(tempDom);

	      Cache.set(uid, {
	        hasNextPage: hasNextPage
	      });

	      resolve({ list: data, els: els });
	    }).catch(function (err) {
	      reject(err);
	    });
	  });
	};

	getMoreHistoryMsg.after(function () {
	  this.pending = false;
	});

	getMoreHistoryMsg.after(function (context, data) {
	  if (!data || !data.list || !data.els) return;

	  _util2.default.scrollToMsg(data.els, context.msgid);

	  context.messageManager.renderOver();
	});

	getMoreHistoryMsg.error = function (err) {
	  this.pending = false;
	  console.error('Action getMoreHistoryMsg Error', err);
	};

	exports.default = getMoreHistoryMsg;

/***/ },
/* 198 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$ConvertRoot = __webpack_require__(8);

	var _index = __webpack_require__(6);

	var _index2 = _interopRequireDefault(_index);

	var _plugins = __webpack_require__(167);

	var _plugins2 = _interopRequireDefault(_plugins);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _constants = __webpack_require__(139);

	var _constants2 = _interopRequireDefault(_constants);

	var _event = __webpack_require__(162);

	var _event2 = _interopRequireDefault(_event);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var start = new _$BaseRoot.Base.ActionCreator(); /**
	                                                  * Created by neitherzhu on 2016/12/7.
	                                                  * 初始化Action
	                                                  */


	start.doSync = function () {
	  _plugins2.default.init({ container: _window2.default.container });
	  _index2.default.getCurrentLoginID.action();
	};

	start.after(function () {
	  var scroll = _plugins2.default.getPlugin('scroll');

	  _event2.default.on('SCROLL_REACH_TOP', function () {
	    _index2.default.getMoreHistoryMsg.action({ cid: _window2.default.conversationID });
	  });

	  _event2.default.on('SCROLLING', function (data) {
	    var isBottom = data.isBottom;
	    var current = _window2.default.conversationID;

	    _window2.default.isBottom = isBottom;

	    if (current) {
	      if (current.type == _constants2.default.Other.TYPE.TRIBE) {
	        // 如果是群, 在滚动时需要去判断是否应该发送已读回执
	        _$ConvertRoot.Action.setAtMsgReadState.action(current);
	      } else if (current.type == _constants2.default.Other.TYPE.SINGLE) {
	        // 如果是单聊
	        _$ConvertRoot.Action.setMsgReadStatus.action(current);
	      }
	    }
	  });

	  _event2.default.on(_constants2.default.Event.CONVERSATION_CHANGE_START, function () {
	    var scroll = _plugins2.default.getPlugin('scroll');

	    scroll && scroll.setSwitching(true);
	  });

	  _event2.default.on(_constants2.default.Event.CONVERSATION_CHANGE_OVER, function () {
	    var scroll = _plugins2.default.getPlugin('scroll');

	    scroll && scroll.setSwitching(false);
	  });
	});

	exports.default = start;

/***/ },
/* 199 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _util = __webpack_require__(153);

	var _util2 = _interopRequireDefault(_util);

	var _window = __webpack_require__(151);

	var _window2 = _interopRequireDefault(_window);

	var _$ConvertRoot = __webpack_require__(8);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2017/2/16.
	 */
	var msgRecall = new _$BaseRoot.Base.ActionCreator();

	msgRecall.doSync = function (context, data) {
	  var el = void 0;
	  data.withdraws.forEach(function (msg) {
	    el = document.getElementById(msg.msgid);
	    if (!el) return;
	    msg.msgtype = 10000;
	    var convert = _$ConvertRoot.Convert.convert('chat', msg, 'msgtype');

	    el.outerHTML = convert.html;

	    _window2.default.isBottom && _util2.default.scrollToBottom(_window2.default.container);

	    // 如果是文件, 并且有获取文件数据的防范,并且是自己发的
	    if (el.classList.contains('file-msg-wrap') && _util2.default.generatorFileMeta && _util2.default.getUid(msg.fromid) == _util2.default.getUid(_window2.default.loginID)) {
	      var fileMsg = el.querySelector('.file-msg');
	      var param = {};
	      param.cid = _util2.default.getCid(_window2.default.conversationID);
	      param.fileInfo = _util2.default.generatorFileMeta(fileMsg);
	      param.fileInfo.msginfo = {
	        msgid: msg.msgid
	      };

	      _$ConvertRoot.SDK.deleteCloudFile(param);
	    }
	  });
	};

	exports.default = msgRecall;

/***/ },
/* 200 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _popupOver = __webpack_require__(176);

	var _popupOver2 = _interopRequireDefault(_popupOver);

	var _messageManager = __webpack_require__(182);

	var _messageManager2 = _interopRequireDefault(_messageManager);

	var _conversationManager = __webpack_require__(163);

	var _conversationManager2 = _interopRequireDefault(_conversationManager);

	var _toast = __webpack_require__(164);

	var _toast2 = _interopRequireDefault(_toast);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2017/1/23.
	 */
	exports.default = {
	  PopupOver: _popupOver2.default,
	  ConversationManager: _conversationManager2.default,
	  MessageManager: _messageManager2.default,
	  Toast: _toast2.default
	};

/***/ },
/* 201 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ },
/* 202 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _constants = __webpack_require__(9);

	var _constants2 = _interopRequireDefault(_constants);

	var _sdk = __webpack_require__(13);

	var _sdk2 = _interopRequireDefault(_sdk);

	var _template = __webpack_require__(15);

	var _template2 = _interopRequireDefault(_template);

	var _convert = __webpack_require__(36);

	var _convert2 = _interopRequireDefault(_convert);

	var _callbacks = __webpack_require__(38);

	var _callbacks2 = _interopRequireDefault(_callbacks);

	var _normalMsgFormater = __webpack_require__(39);

	var _normalMsgFormater2 = _interopRequireDefault(_normalMsgFormater);

	var _defaultParse = __webpack_require__(62);

	var _defaultParse2 = _interopRequireDefault(_defaultParse);

	var _systemMsgFormater = __webpack_require__(66);

	var _systemMsgFormater2 = _interopRequireDefault(_systemMsgFormater);

	var _window = __webpack_require__(14);

	var _window2 = _interopRequireDefault(_window);

	var _actions = __webpack_require__(84);

	var _actions2 = _interopRequireDefault(_actions);

	var _plugins = __webpack_require__(104);

	var _plugins2 = _interopRequireDefault(_plugins);

	__webpack_require__(126);

	__webpack_require__(137);

	function _interopRequireDefault(obj) {
	  return obj && obj.__esModule ? obj : { default: obj };
	}

	exports.default = {
	  Constant: _constants2.default,
	  SDK: _sdk2.default,
	  Template: _template2.default,
	  Convert: _convert2.default,
	  Callbacks: _callbacks2.default,
	  Plugin: _plugins2.default,
	  Action: _actions2.default,
	  MsgFormats: {
	    SingleNormalMsgFormat: _normalMsgFormater2.default,
	    TribeNormalMsgFormat: _normalMsgFormater2.default,
	    SystemFormat: _systemMsgFormater2.default,
	    NormalMsgDefaultParse: _defaultParse2.default
	  },
	  shareWin: function shareWin(w) {
	    _window2.default.sharedWin = w;
	    _plugins2.default.init({ container: _window2.default.sharedWin.container });
	    _actions2.default.start.action();
	  }
	};
	module.exports = exports['default'];

/***/ },
/* 203 */
/***/ function(module, exports) {

	module.exports = "{@if boards.length > 0}\n  <div class=\"board-container {@if boards.length === 1}single{@/if} {@if isFold}fold{@/if}\" id=\"J_BoardContainer\">\n    <div class=\"board-list\">\n      <ul class=\"tab-content\" id=\"J_BoardContent\">\n        {@each boards as board,i}\n          <li class=\"J_boardContentItem{@if i == 0} active{@/if}\" data-id=\"${board.id}\">\n            <img width=\"30\" height=\"30\" src=\"http://wwc.taobaocdn.com/avatar/getAvatar.do?userId=${board.modifiedUserId}&width=160&height=160&type=ww\">\n            <span>${board.modifiedUserNick}:</span>${board.content}\n          </li>\n        {@/each}\n      </ul>\n    </div>\n    <div id=\"J_BoardTab\"></div>\n    <i class=\"iconfont icon-fold J_Fold\" title=\"收起\"></i>\n    {@if totalCount > 5}\n      <a class=\"more J_More\" href=\"javascript:;\">更多></a>\n    {@/if}\n  </div>\n  <i class=\"iconfont icon-tribe-board J_BoardIcon\"></i>\n{@/if}\n";

/***/ },
/* 204 */
/***/ function(module, exports) {

	module.exports = "{@if items.length > 1}\n  <ul class=\"tab\">\n    {@each items as item,i}\n    <li class=\"{@if i == index}${activeCls}{@/if}\"><span class='${tabCls}' data-index=\"${i}\">${Number(i) + 1}</span></li>\n    {@/each}\n  </ul>\n{@/if}\n";

/***/ },
/* 205 */
/***/ function(module, exports) {

	module.exports = "<div class=\"J_msg imui-msg{@if !self} imui-msg-l{@else} imui-msg-r{@/if}{@if cls} ${cls}{@/if}{@if fold} msg-fold{@/if}\"\n     id=\"${msgid}\" data-time=\"${msgtime}\" data-appkey=\"${from.appkey}\"\n     data-nick=\"${from.nick}\" data-numberid=\"${from.numberid}\">\n  {@if avatar}\n  <div class=\"imui-msg-avatar J_avatar_${appkey}${subNick}{@if !self && !cid.nick} J_addAt{@/if}\"\n       style=\"background-image:url(${avatar});background-size:cover;\"></div>\n  {@/if}\n  <div class=\"imui-msg-content\">\n    <div class=\"imui-msg-content-inner\">\n      <div class=\"imui-msg-head\">\n                <span class=\"imui-msg-sender J_display_${subNick}{@if !self && !cid.nick} add-at J_addAt{@/if}\"\n                      title=\"{@if !isSubNick}${from.display}{@else}${from.display} --> ${to.display}{@/if}\">\n            {@if !isSubNick}${from.display}{@else}${from.display} --> ${to.display}{@/if}\n        </span>\n        <span class=\"imui-msg-date\">${msgtime | dateFormatter}</span> {@if fromRobot}<i class=\"robot-icon\"></i>{@/if}\n        {@if search}<span class=\"imui-msg-context J_goContext\" data-msgid=\"${msgid}\" data-msgtime=\"${msgtime}\"></span>{@/if}\n      </div>\n      <div class=\"msg-content-body\">\n        <div class=\"msg-body-html\">$${html}</div>\n        <div class=\"imui-msg-op-wrap\" data-menu=\"${menu}\" data-type=\"${curType}\">\n\n          <div class=\"imui-msg-status\">\n            {@if isFail}\n            <span class=\"status-icon status-error J_resend\"></span> {@else} {@if self && readFlagText} {@if readflag ==\n            1}\n            <span class=\"status-read-done single-msg-read-status\" data-unread=\"0\">${readFlagText}</span> {@/if} {@/if} {@/if}\n          </div>\n          {@if msgstatus === 0 || msgstatus === 1}\n          {@if !isFileEmptyMenu}\n          <div class=\"imui-msg-menu-wrap J_menuWrap menu-hidden\" tabindex=\"0\">\n            {@if isMe}\n            <span\n              class=\"bubble-menu-trigger J_selfBubbleMenuTrigger\"\n              data-svrtime=\"{@if svrtime !== '0'}${svrtime}{@else}${msgtime}{@/if}\"></span> {@else}\n            <span class=\"bubble-menu-trigger J_bubbleMenuTrigger\" data-svrtime=\"${svrtime}\"></span> {@/if}\n          </div>\n          {@/if}\n          {@/if}\n        </div>\n      </div>\n    </div>\n  </div>\n</div>\n";

/***/ },
/* 206 */
/***/ function(module, exports) {

	module.exports = "<div id=\"J_IntelligentReply\" class=\"intelligent-reply\">\n  <i class=\"icon icon-intelligent J_RobotManage\">智</i>\n  <p class=\"content J_Content\">${text}</p>\n  <i class=\"icon icon-close J_Close\"></i>\n  <div class=\"tooltip J_Tooltip\">\n    <p>点击发送，快捷键（AltA）</p>\n    <span class=\"triangle-down\"></span>\n    </div>\n</div>\n";

/***/ },
/* 207 */
/***/ function(module, exports) {

	module.exports = "";

/***/ },
/* 208 */
/***/ function(module, exports) {

	module.exports = "<span class=\"status-read-done single-read single-msg-read-status\" data-unread=\"{@if isread}0{@else}1{@/if}\">${tpl}</span>";

/***/ },
/* 209 */
/***/ function(module, exports) {

	module.exports = "<div class=\"imui-msg-menu-wrap J_menuWrap menu-hidden\" tabindex=\"0\">\n    <span class=\"bubble-menu-trigger J_selfBubbleMenuTrigger\" data-svrtime=\"${svrtime}\"></span>\n</div>";

/***/ },
/* 210 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	__webpack_require__(211);

	__webpack_require__(212);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Constant = _$ChatRoot2.default.Constant;


	Constant.EL_ID.CONTAINER = 'J_msgContainer';
	Constant.CLS.SHOW_MSG_MENU = 'show-msg-menu';
	Constant.CLS.SHOW_READ_STATUS = 'show-read-status';
	//Constant.TEXT_MODE = 'IGNORE';

	// 删除转发菜单
	delete Constant.BUBBLE_MENU.CUSTOM.canForward;
	exports.default = Constant;

/***/ },
/* 211 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Constant = _$ChatRoot2.default.Constant;

	var Event = Constant.Event;

	Event.MSG_MERGE_OPTION_CHANGE = 'im.bizutil.onChatMsgMergeOptionChange';
	Event.MSG_DISPLAY_MODE_CHANGE = 'im.bizutil.onChatMsgDisplayModeChange';

/***/ },
/* 212 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Constant = _$ChatRoot2.default.Constant;

	var SDK = Constant.SDK;

	SDK.GET_MSG_MERGE_OPTION = 'im.bizutil.GetChatMsgMergeOption';
	SDK.GET_MSG_DISPLAY_MODE = 'im.bizutil.GetChatMsgDisplayMode';
	SDK.GET_BOARD = 'jdy.api/wwgroup/notice';
	SDK.OPEN_TRIBE_BOARD = 'im.uiutil.OpenTribeBoard';

/***/ },
/* 213 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var SDK = _$ChatRoot2.default.SDK,
	    Constant = _$ChatRoot2.default.Constant;

	/**
	 * 获取群看板数据
	 * @param param
	 * @returns {*}
	 */

	SDK.getBoardData = function (param) {
	  param.__other = 'get';

	  return _$IMSDKRoot2.default.invoke(Constant.SDK.GET_BOARD, param);
	};

	/**
	 * 打开群看板列表/详情
	 * @param param
	 */
	SDK.openTribeBoard = function (param) {
	  _$IMSDKRoot2.default.invoke(Constant.SDK.OPEN_TRIBE_BOARD, param);
	};

	/**
	 * 获取是否要合并消息
	 * @returns {*}
	 */
	SDK.getMsgMergeStatus = function () {
	  return _$IMSDKRoot2.default.invoke(Constant.SDK.GET_MSG_MERGE_OPTION);
	};

	/**
	 * 获取消息展示模式 0:普通模式 1:气泡模式
	 * @returns {*}
	 */
	SDK.getMsgMode = function () {
	  return _$IMSDKRoot2.default.invoke(Constant.SDK.GET_MSG_DISPLAY_MODE);
	};

	/**
	 * 获取智能机器人回复
	 * @param param
	 * @returns {*}
	 */
	SDK.getIntelligentReply = function (param) {
	  return _$IMSDKRoot2.default.invoke('robot.GetSuggestIntelligentReply', param);
	};

	/**
	 * 打开智能机器人回复的管理页面
	 */
	SDK.openIntelligentManage = function () {
	  _$IMSDKRoot2.default.invoke('robot.OpenRobotManage');
	};
	/**
	 * 移除智能机器人回复
	 * @param param
	 */
	SDK.removeIntelligentReply = function (param) {
	  _$IMSDKRoot2.default.invoke('robot.RemoveSuggestIntelligentReply', param);
	};
	/**
	 * 发送智能机器人回复
	 * @param param
	 */
	SDK.sendIntelligentReply = function (param) {
	  _$IMSDKRoot2.default.invoke('robot.SendSuggestIntelligentReply', param);
	};

	/**
	 * 打开订单详情
	 * @param param
	 */
	SDK.openOrderDetail = function (param) {
	  _$IMSDKRoot2.default.invoke('application.itemToUser', param);
	};

	/**
	 * 买家下单后,提示卖家的猜你喜欢
	 * @param param
	 * @returns {*}
	 */
	SDK.getNewOderInfo = function (param) {
	  return _$IMSDKRoot2.default.invoke('order.GetNewOrderInfo', param);
	};

	/**
	 * 显示右键菜单
	 * @param param
	 * @returns {*}
	 */
	SDK.contextMenu = function (param) {
	  return _$IMSDKRoot2.default.invoke('im.uiutil.ShowContextMenu', param);
	};

	/**
	 * 往输入框中插入@群成员
	 * @param param
	 */
	SDK.insertAtMember = function (param) {
	  _$IMSDKRoot2.default.invoke('im.tribemsg.AtTribeMember', param);
	};

	/**
	 * 获取通用配置项
	 */
	SDK.getCommonConfig = function () {
	  return _$IMSDKRoot2.default.invoke('im.bizutil.GetIMCommonConfig');
	};

/***/ },
/* 214 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	__webpack_require__(215);

	__webpack_require__(218);

	__webpack_require__(220);

	__webpack_require__(221);

	__webpack_require__(222);

/***/ },
/* 215 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	var _template = __webpack_require__(4);

	var _template2 = _interopRequireDefault(_template);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _carousel = __webpack_require__(216);

	var _carousel2 = _interopRequireDefault(_carousel);

	__webpack_require__(217);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/11.
	 * 群看板
	 */
	var Util = _$BaseRoot.Base.Util;
	var SDK = _$ChatRoot2.default.SDK,
	    Event = _$ChatRoot2.default.Event,
	    Plugin = _$ChatRoot2.default.Plugin,
	    Win = _$ChatRoot2.default.Win,
	    Constant = _$ChatRoot2.default.Constant;

	var BOARD_CHANGE_EVENT = 'qn.jindoucloud.wwgroupnotice.change';

	var Board = {
	  init: function init() {

	    this.container = this._createBoardContainer();
	    this.uid = '';
	    this.data = {};

	    this._events();
	    this._bindChange();
	    this.carousel = null;
	  },
	  _createBoardContainer: function _createBoardContainer() {
	    var div = document.createElement('div');
	    div.id = 'J_board';
	    div.className = 'board';

	    document.body.insertBefore(div, document.body.firstChild);

	    return div;
	  },
	  _events: function _events() {
	    var _this = this;

	    var _that = this;

	    if (window.onEventNotify) {
	      var handler = window.onEventNotify;

	      window.onEventNotify = function (sid, name, a, data) {

	        if (data && name == BOARD_CHANGE_EVENT) {
	          _that._changeHandler(JSON.parse(data));
	        }

	        handler.apply(null, Array.prototype.slice.call(arguments));
	      };
	    }

	    Event.on(Constant.Event.CONVERSATION_CHANGE_START, function (data) {
	      if (data && data.type === Constant.Other.TYPE.TRIBE) {
	        _this.getBoardData(Util.getUid(data));
	      } else {
	        _that.carousel && _that.carousel.stopCarousel();
	        _that.container.classList.add('hide');
	      }
	    });

	    this.container.addEventListener('click', function (ev) {
	      var target = ev.target;

	      var Scroll = void 0;

	      if (target.classList.contains('J_Fold')) {

	        _this.boardContainer && _this.boardContainer.classList.add('fold');
	        localStorage.setItem('isFold.' + _this.uid, true);
	        Scroll = Plugin.getPlugin('scroll');
	        Scroll && Scroll.reset();
	      } else if (target.classList.contains('J_BoardIcon')) {

	        _this.boardContainer && _this.boardContainer.classList.remove('fold');
	        localStorage.removeItem('isFold.' + _this.uid);
	        Scroll = Plugin.getPlugin('scroll');
	        Scroll && Scroll.reset();
	      } else if (target.classList.contains('J_More')) {
	        SDK.openTribeBoard({
	          tribeid: Win.conversationID,
	          param: JSON.stringify({ action: 'list' })
	        });
	      } else if (target.classList.contains('J_boardContentItem') || target.parentNode.classList.contains('J_boardContentItem')) {
	        var li = Util.parents(target, 'J_boardContentItem');
	        var id = li.getAttribute('data-id');
	        var board = _this.data[_this.uid].boards && _this.data[_this.uid].boards.filter(function (b) {
	          return id == b.id;
	        })[0];

	        board && SDK.openTribeBoard({
	          tribeid: Win.conversationID,
	          param: JSON.stringify({ action: 'detail', board: board })
	        });
	      }
	    });
	  },
	  _bindChange: function _bindChange() {
	    try {
	      workbench.regEvent(workbench.createSequenceId(), BOARD_CHANGE_EVENT);
	    } catch (e) {}
	  },
	  _changeHandler: function _changeHandler(data) {
	    // 如果变更的不是当前选中的联系对象
	    // 记录下是否需要变更的状态, 决定下次切换的时候是否需要重新获取数据
	    if (data.groupId != this.uid && data.needUpdate) {
	      this.data[this.uid] || (this.data[this.uid] = {});
	      this.data[this.uid].needUpdate = data.needUpdate;
	    } else {
	      this.getBoardData(this.uid);
	    }
	  },
	  getBoardData: function getBoardData(uid) {
	    var _this2 = this;

	    this.uid = uid;

	    SDK.getBoardData({
	      groupId: this.uid,
	      page: 1,
	      pageSize: 5
	    }).then(function (data) {
	      data = data.wwgroup_notice_get_response;

	      var boards = data.currentPageValue;

	      if (!boards || !boards.length) {
	        return _this2.container.innerHTML = '';
	      }

	      _this2.data[uid] || (_this2.data[uid] = {});
	      _this2.data[uid].boards = boards;

	      var html = (0, _$JuicerRoot2.default)(_template2.default.tribeBoard, {
	        isFold: !!localStorage.getItem('isFold.' + uid),
	        boards: boards,
	        totalCount: data.totalCount
	      });

	      _this2.container.innerHTML = html;
	      _this2.container.classList.remove('hide');

	      _this2.boardTab = document.getElementById('J_BoardTab');
	      _this2.boardContainer = document.getElementById('J_BoardContainer');
	      _this2.boardContent = document.getElementById('J_BoardContent');
	      _this2.carousel = null;

	      _this2.carousel = new _carousel2.default(_this2.container, {
	        dur: 6600,
	        content: _this2.boardContent,
	        tab: _this2.boardTab,
	        tabCls: 'J_boardTabItem'
	      });

	      _this2.carousel.render({
	        items: boards
	      });

	      var Scroll = Plugin.getPlugin('scroll');
	      Scroll && Scroll.reset();
	    });
	  }
	};

	Plugin.addPlugin('board', Board);

	exports.default = Board;

/***/ },
/* 216 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }(); /**
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Created by neitherzhu on 2016/12/11.
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * carousel
	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */


	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _template = __webpack_require__(4);

	var _template2 = _interopRequireDefault(_template);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

	var Carousel = function () {
	  function Carousel(container, config) {
	    _classCallCheck(this, Carousel);

	    this.container = container;
	    this.config = Object.assign({
	      index: 0,
	      enterStop: true,
	      activeCls: 'active',
	      tabCls: '',
	      tab: null,
	      content: null,
	      dur: 6000
	    }, config);

	    this.timer = null;
	    this.index = 0;
	    this.count = 0;

	    this.events();
	  }

	  _createClass(Carousel, [{
	    key: 'events',
	    value: function events() {
	      var _this = this;

	      this.container.addEventListener('click', function (ev) {
	        var target = ev.target;

	        if (_this.config.tabCls && target.classList.contains(_this.config.tabCls) && !target.classList.contains(_this.config.activeCls)) {
	          var index = parseInt(target.getAttribute('data-index'));

	          _this.carouseTo(index);
	        }
	      });

	      if (!this.config.enterStop) return;

	      this.container.addEventListener('mouseenter', function (ev) {
	        _this.stopCarousel();
	      });

	      this.container.addEventListener('mouseleave', function (ev) {
	        _this.startCarousel();
	      });
	    }
	  }, {
	    key: 'carouseTo',
	    value: function carouseTo(index) {

	      var percent = 20 * index;
	      var config = this.config;

	      config.content.style.transform = 'translate3d(-' + percent + '%, 0, 0)';
	      var activeEl = config.activeCls && config.tab.querySelector('.' + config.activeCls);
	      activeEl && activeEl.classList.remove(config.activeCls);
	      config.tab.querySelectorAll('.' + config.tabCls)[index].parentNode.classList.add(config.activeCls);
	    }
	  }, {
	    key: 'startCarousel',
	    value: function startCarousel() {
	      var _this2 = this;

	      var index = this.index;

	      this.stopCarousel();

	      if (this.count < 2) return;

	      this.timer = setInterval(function () {
	        index++;

	        if (index == _this2.count) {
	          index = 0;
	        }
	        _this2.index = index;

	        _this2.carouseTo(index);
	      }, this.config.dur);
	    }
	  }, {
	    key: 'stopCarousel',
	    value: function stopCarousel() {
	      if (!this.timer) return;

	      clearInterval(this.timer);
	      this.timer = null;
	    }
	  }, {
	    key: 'reset',
	    value: function reset() {
	      this.index = 0;
	      this.count = 0;
	      this.timer = null;
	    }
	  }, {
	    key: 'render',
	    value: function render(config) {
	      this.stopCarousel();
	      this.reset();
	      if (!config.items || !config.items.length) {
	        this.count = 0;
	        this.config.tab.innerHTML = '';
	      } else {
	        this.count = config.items.length;
	        this.config.tab.innerHTML = (0, _$JuicerRoot2.default)(_template2.default.carousel, Object.assign(this.config, {
	          items: config.items
	        }));

	        this.startCarousel();
	      }
	    }
	  }]);

	  return Carousel;
	}();

	exports.default = Carousel;

/***/ },
/* 217 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ },
/* 218 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	var _template = __webpack_require__(4);

	var _template2 = _interopRequireDefault(_template);

	__webpack_require__(219);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/19.
	 * 半智能客服提示
	 */
	var Util = _$BaseRoot.Base.Util;
	var Plugin = _$ChatRoot2.default.Plugin,
	    SDK = _$ChatRoot2.default.SDK,
	    Constant = _$ChatRoot2.default.Constant,
	    Win = _$ChatRoot2.default.Win,
	    Event = _$ChatRoot2.default.Event;

	var param = Util.getParam(location.search.substring(1));
	var DLG = param.dlguniqname || '';

	Plugin.addPlugin('intelligentReply', {
	  init: function init() {
	    this._events();
	  },

	  _events: function _events() {
	    var _that = this;

	    _$IMSDKRoot2.default.on('im.uiutil.' + DLG + 'onConversationChange', function (data) {
	      // 只有单聊才有需要
	      if (data.cid && data.cid.nick && data.cid.appkey) {
	        _that.getIntelligentReply(data.cid);
	      } else {
	        _that.close();
	      }
	    });

	    _$IMSDKRoot2.default.on('workbench.robot.OnSuggestIntelligentReply', function (data) {
	      if (Util.getUid(data) === Util.getUid(Win.conversationID)) {
	        _that.getIntelligentReply(data);
	      }
	    });
	  },

	  containerEvents: function containerEvents() {

	    if (!this.container) return;

	    var _that = this;

	    this.container.addEventListener('click', function (ev) {
	      var target = ev.target;

	      if (target.classList.contains('J_RobotManage')) {
	        SDK.openIntelligentManage();
	      } else if (target.classList.contains('J_Close')) {
	        SDK.removeIntelligentReply(_that.cid);
	      } else if (target.classList.contains('J_Content')) {
	        SDK.sendIntelligentReply(_that.cid);
	      }
	      //else if(target.classList.contains('J_Tooltip') || target.parentNode.classList.contains('J_Tooltip')) {
	      //  _that.closeTip();
	      //}
	    });
	  },

	  close: function close() {
	    //localStorage.setItem('intelligent.' + Util.getUid(this.cid), true);
	    //this.closeTip();
	    this.closeReply();

	    var Scroll = Plugin.getPlugin('scroll');
	    Scroll && Scroll.reset();

	    Event.emit(Constant.Event.WINDOW_RESIZE);
	  },

	  //closeTip: function() {
	  //  if(!this.tip) return;
	  //
	  //  this.tip.classList.remove('show');
	  //},

	  closeReply: function closeReply() {
	    if (!this.container) return;

	    this.container.classList.add('hide');
	  },

	  render: function render(text) {
	    if (this.container) {
	      this.container.querySelector('.J_Content').innerText = text;
	      this.container.classList.remove('hide');
	    } else {
	      var f = Util.createFragment((0, _$JuicerRoot2.default)(_template2.default.intelligentReply, { text: text }));
	      document.body.insertBefore(f, document.body.lastChild);
	      this.container = document.getElementById('J_IntelligentReply');
	      this.tip = document.querySelector('.J_Tooltip');
	      this.containerEvents();
	    }

	    Event.emit(Constant.Event.WINDOW_RESIZE);
	    //
	    //if(this.cid && !localStorage.getItem('intelligent.' + Util.getUid(this.cid))) {
	    //  this.tip.classList.add('show');
	    //}
	  },

	  getIntelligentReply: function getIntelligentReply(param) {
	    var _that = this;
	    this.cid = param;
	    SDK.getIntelligentReply(param).then(function (data) {
	      if (data.result && data.result.text) {
	        _that.render(data.result.text);
	      } else {
	        _that.close();
	      }
	    }).catch(function (e) {
	      _that.close();
	    });
	  }

	});

/***/ },
/* 219 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ },
/* 220 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	var _template = __webpack_require__(4);

	var _template2 = _interopRequireDefault(_template);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Plugin = _$ChatRoot2.default.Plugin,
	    SDK = _$ChatRoot2.default.SDK,
	    Win = _$ChatRoot2.default.Win; /**
	                                    * Created by neitherzhu on 2016/12/20.
	                                    * 新订单提醒
	                                    */

	var Util = _$BaseRoot.Base.Util;

	var param = Util.getParam(location.search.substring(1));
	var DLG = param.dlguniqname || '';

	Plugin.addPlugin('newOrder', {
	  init: function init(context) {
	    console.log(context.container);
	    this.container = context.container;
	    this._events();
	  },

	  _events: function _events() {
	    var _that = this;

	    _$IMSDKRoot2.default.on('im.uiutil.' + DLG + 'onConversationChange', function (data) {
	      // 只有单聊才有需要
	      if (!data || !data.cid || !data.cid.tribeid) return;

	      _that.getNewOderInfo(data);
	    });

	    _$IMSDKRoot2.default.on('workbench.order.OnNewTradeOrder', function (data) {
	      if (data.nick === Win.conversationID.nick) {
	        _that.getNewOderInfo(Win.conversationID);
	      }
	    });

	    this.container.addEventListener('click', function (ev) {
	      var target = ev.target;

	      if (target.classList.contains('J_openOrderDetail')) {
	        SDK.openOrderDetail({
	          chatNick: Util.getUid(Win.conversationID),
	          tid: target.getAttribute('data-tid')
	        });
	      }
	    });
	  },
	  render: function render(orders) {
	    var html = '';
	    var f = void 0;

	    orders.forEach(function (order) {
	      html += (0, _$JuicerRoot2.default)(_template2.default.systemMsg, { html: '买家在' + new Date(parseInt(order.time) * 1000).__getFormatFullDate() + '下单, <a class="J_openOrderDetail" href="javascript:;" data-tid="' + order.tid + '">猜TA喜欢</a>' });
	    });

	    f = Util.createFragment(html);

	    this.container.appendChild(f);

	    Util.scrollToBottom(this.container);
	  },

	  getNewOderInfo: function getNewOderInfo(param) {
	    var _that = this;
	    SDK.getNewOderInfo(param).then(function (data) {
	      if (data && data.result && data.result.length) {
	        _that.render(data.result);
	      }
	    });
	  }
	});

/***/ },
/* 221 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	var _$BaseRoot = __webpack_require__(3);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2017/1/3.
	 */
	var Plugin = _$ChatRoot2.default.Plugin,
	    SDK = _$ChatRoot2.default.SDK;
	var Util = _$BaseRoot.Base.Util;


	Plugin.addEventPlugin('click', 'J_addAt', function (ev) {
	  var target = ev.target;
	  var parent = Util.parents(target, 'J_msg');

	  if (!parent) return;

	  SDK.insertAtMember({
	    uid: {
	      appkey: parent.getAttribute('data-appkey'),
	      nick: parent.getAttribute('data-nick')
	    }
	  });
	});

/***/ },
/* 222 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _imkitPlugin = __webpack_require__(223);

	var _imkitPlugin2 = _interopRequireDefault(_imkitPlugin);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2017/1/17.
	 */
	var Util = _$BaseRoot.Base.Util;


	var param = Util.getParam(location.search.substring(1));

	var Plugin = _$ChatRoot2.default.Plugin;


	if (Number(param.type) === 0) {
	    Plugin.addPlugin('IntelTips', _imkitPlugin2.default);
	} else {
	    console.log('type: ' + param.type + ', system can\'t init intelligentTips');
	}

/***/ },
/* 223 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _tips = __webpack_require__(224);

	var _tips2 = _interopRequireDefault(_tips);

	__webpack_require__(229);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	//打包需注释
	// const { Win, Action, Constant, Plugin } = Chat;

	//打包需注释
	// window.addEventListener('DOMContentLoaded', function() {
	//   Win.container = document.getElementById(Constant.EL_ID.CONTAINER);
	//   Plugin.addPlugin('tips', tips);
	//   Action.start.action();
	// });

	// import '@ali/im.sdk'; // 全局IMSDK引入， 使用fie babel时请注释

	//打包需注释
	// import Chat from '$ChatRoot';

	exports.default = _tips2.default;
	module.exports = exports['default'];

/***/ },
/* 224 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _tarzanZepto = __webpack_require__(225);

	var _tarzanZepto2 = _interopRequireDefault(_tarzanZepto);

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	var _template = __webpack_require__(226);

	var _template2 = _interopRequireDefault(_template);

	__webpack_require__(228);

	var _index = __webpack_require__(223);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Event = _$ChatRoot2.default.Event,
	    Win = _$ChatRoot2.default.Win,
	    Plugin = _$ChatRoot2.default.Plugin;
	// import debounce from 'lodash.debounce';

	var Util = _$BaseRoot.Base.Util;
	var Log = _$BaseRoot.Base.Log;
	// const goldLog = Log.goldLog;

	exports.default = {
	    bizVariable: {
	        user: "", //登陆者
	        contactUser: "", //会话人
	        invocation: 0, //开关,无回调等情况默认为关闭
	        effect: "1", //收展
	        shortcuts: null,
	        tips: [],
	        loading: 0,
	        canUse: null, //canUse为true时才请求智能提示
	        latestMsg: [],
	        latestReplyMsg: [],
	        hasConflict: false, //是否已经有快捷键冲突
	        firstLoad: true,
	        ifOneShop: null,
	        ifGroup: null,
	        forceShowEmpty: false, //true是强制出现空页面，切换联系人时即使不请求也出空页面
	        linkData: [] //链接消息数组
	    },

	    clearData: function clearData() {
	        this.bizVariable.contactUser = "";
	        this.bizVariable.tips = [];
	        this.bizVariable.loading = 0;
	        this.bizVariable.ifOneShop = null;
	        this.bizVariable.ifGroup = null;
	        document.getElementById("content").innerHTML = "";
	    },
	    init: function init() {
	        this.events();
	        this.setListener();
	        this.bindEvent(); //面板展示是才需要绑定事件，但考虑开关变化推送，故都绑定事件

	        document.body.appendChild(Util.createFragment(_template2.default.tips));
	    },
	    events: function events() {
	        var that = this;
	        function cacheOrDealMsg(msg) {
	            if (typeof msg.msgbody === "string") {
	                msg.msgbody = JSON.parse(msg.msgbody);
	            }
	            that.dealMsg(msg);
	        }
	        Event.on('LINK_MSG', function (msg) {
	            Log.orange('LINK_MSG', msg);
	            //对于magType不是0或者不是1进行特殊处理
	            cacheOrDealMsg(msg);
	        });

	        Event.on('get_remote_history_msg', function (msg) {
	            Log.orange('get_remote_history_msg', msg);
	            cacheOrDealMsg(msg);
	        });
	        Event.on('get_new_msg', function (msg) {
	            Log.orange('get_new_msg', msg);
	            cacheOrDealMsg(msg);
	        });
	        Event.on('receive_msg', function (msg) {
	            Log.orange('receive_msg', msg);
	            cacheOrDealMsg(msg);
	        });
	        Event.on('get_send_msg', function (msg) {
	            Log.orange('get_send_msg', msg);
	            cacheOrDealMsg(msg);
	        });
	        Event.on('conversationChangeStart', function (res) {
	            that.renderTips("openInit");
	            that.clearData();
	            if (!that.bizVariable.user) {
	                that.bizVariable.user = Win.loginID;
	            };
	            that.bizVariable.contactUser = res;
	            console.log('dianxiaomi----------------');
	            that.dealContactUserChanged();
	        });
	    },
	    bindEvent: function bindEvent() {
	        var that = this;

	        (0, _tarzanZepto2.default)('body').on('click', '.row', function (e) {
	            that.sendTip(e.currentTarget.getAttribute('data-index'));
	        });

	        (0, _tarzanZepto2.default)('body').on('click', '#shortcuts-button', function (e) {
	            that.setShortcuts();
	        });
	    },
	    setListener: function setListener() {
	        this.regiInvocationChanged();
	        //面板控制智能辅助打开关闭。
	        this.regiSmartTipSwitch();
	        this.getEffect();
	        this.regiShortcutsChanged();
	        this.regiShortcutsClick();
	        this.regiReciveSmartTipPush();
	    },
	    regiInvocationChanged: function regiInvocationChanged() {
	        var that = this;
	        _$IMSDKRoot2.default.on("workbench.intelligentservice.onSmartTipSwitchChanged", function (res) {
	            that.dealInvocationChanged(res.smartTipSwitch);
	        });
	    },
	    getEffect: function getEffect() {
	        if (typeof localStorage.effectZnts === "string") {
	            this.bizVariable.effect = localStorage.effectZnts;
	        } else {
	            localStorage.effectZnts = "1";
	            this.setEffectChanged("1");
	        }
	    },
	    regiShortcutsChanged: function regiShortcutsChanged() {
	        var that = this;
	        _$IMSDKRoot2.default.on("workbench.intelligentservice.onHotKeyRefresh", function (res) {
	            that.dealShortcutsChanged(res);
	        });
	    },
	    regiShortcutsClick: function regiShortcutsClick() {
	        var that = this;
	        _$IMSDKRoot2.default.on("workbench.intelligentservice.onHotKeySendDown", function (res) {
	            that.dealShortcutsClick(res.action);
	        });
	    },
	    regiReciveSmartTipPush: function regiReciveSmartTipPush() {
	        var that = this;
	        _$IMSDKRoot2.default.on("workbench.intelligentservice.onSmartAssistantRecommend", function (res) {
	            that.setEffectChanged("1");
	            that.dealSmartTipPush(res);
	        });
	    },
	    regiSmartTipSwitch: function regiSmartTipSwitch() {
	        var that = this;
	        var intelligentTips = document.getElementById("intelligent-tips");
	        _$IMSDKRoot2.default.on("workbench.intelligentservice.onSmartAssistantStatus", function (res) {
	            var switcher = res && res.bOpenAssistant ? 1 : 0;
	            that.dealInvocationChanged(switcher);
	        });
	    },
	    dealContactUserChanged: function dealContactUserChanged() {
	        var that = this;
	        if (that.bizVariable.contactUser && that.bizVariable.contactUser.type === 1) {
	            that.bizVariable.ifGroup = false;
	        } else {
	            //如果是群，contactUser返回值为appkey: ""nick: ""
	            that.bizVariable.ifGroup = true;
	        }
	        var userNick = that.bizVariable.user.nick.split(":");
	        var contactUserNick = that.bizVariable.contactUser && that.bizVariable.contactUser.nick ? that.bizVariable.contactUser.nick.split(":") : [];
	        if (userNick[0] === contactUserNick[0]) {
	            that.bizVariable.ifOneShop = true;
	        } else {
	            that.bizVariable.ifOneShop = false;
	        }

	        // 解决与init()与Emit.on的时序问题,把初始化逻辑提前到切换联系人
	        if (this.bizVariable.firstLoad === true) {
	            this.getShortcuts().then(function () {
	                that.getInvocation().then(function (res) {
	                    if (that.bizVariable.invocation === 0) {
	                        that.renderContainer("none");
	                        that.bizVariable.canUse = false;
	                        return;
	                    }
	                    //开关为开PV，UV
	                    Log.goldLog('/qianniuznkf.12.9');
	                    that.getEffect(); //localstorage读取，同步操作
	                    if (that.bizVariable.effect === "0") {
	                        that.renderContainer("close");
	                        that.bizVariable.canUse = false;
	                    } else {
	                        //开关为开且收展为展的PV，UV
	                        Log.goldLog('/qianniuznkf.12.10');
	                        //快捷键降级的情况怎么合适
	                        that.renderContainer("open");
	                        if (!that.bizVariable.ifGroup && !that.bizVariable.ifOneShop) {
	                            that.bizVariable.canUse = true;
	                            //防止canUse为true之前已经接收到消息，所以读一次缓存
	                            that.shouldDealTipsGoten();

	                            //即使已经回复，不发请求但是显示空页面
	                            if (that.bizVariable.forceShowEmpty === true) {
	                                that.renderTips("empty");
	                            }
	                        }
	                    }
	                }, function (res) {
	                    that.renderContainer("none");
	                });
	                that.bizVariable.firstLoad = false;
	            }, function (msg) {
	                Log.orange('getShortcuts', msg);
	                //快捷键拉取失败不去取消息
	                // that.bizVariable.canUse = false;
	            });
	        } else {
	            if (this.dealCanUse()) {
	                this.renderContainer("open");

	                //即使已经回复，不发请求但是显示空页面
	                if (this.bizVariable.forceShowEmpty === true) {
	                    this.renderTips("empty");
	                }
	            }
	            if (this.bizVariable.invocation === 1 && this.bizVariable.effect !== "1" && !this.bizVariable.ifGroup && !this.bizVariable.ifOneShop) {
	                //canUse为false
	                this.renderContainer("close");
	            }
	            if (this.bizVariable.ifGroup || this.bizVariable.ifOneShop) {
	                this.renderContainer("none");
	            }
	        }
	    },


	    //如果所有条件成立，判断是否请求
	    dealCanUse: function dealCanUse() {
	        if (this.bizVariable.invocation === 1 && this.bizVariable.effect === "1" && !this.bizVariable.ifGroup && !this.bizVariable.ifOneShop) {
	            this.bizVariable.canUse = true;
	            //切换联系人，所以读一次缓存
	            this.shouldDealTipsGoten();
	        } else {
	            this.bizVariable.canUse = false;
	        }
	        return this.bizVariable.canUse;
	    },


	    //切换联系人时调用，如果最新的消息来自买家则请求智能提示
	    shouldDealTipsGoten: function shouldDealTipsGoten() {
	        //切换联系人，所以读一次缓存。不应请求是展示空页面
	        this.bizVariable.forceShowEmpty = true;
	        for (var i = 0; i < this.bizVariable.latestMsg.length; i++) {
	            if (this.bizVariable.latestMsg[i].key === this.bizVariable.contactUser.nick) {
	                this.dealTipsGoten(this.bizVariable.latestMsg[i].value);
	            }
	        }
	    },
	    dealInvocationAndEffect: function dealInvocationAndEffect() {
	        if (this.bizVariable.invocation === 0) {
	            this.renderContainer("none");
	        } else {
	            if (this.bizVariable.effect === "0") {
	                this.renderContainer("close");
	            } else {
	                //由于是客户端方法，认为getShortcuts为同步事件且用时极短，不会回调失败。加一层判断保证
	                if (this.bizVariable.shortcuts && this.bizVariable.shortcuts.length > 0) {
	                    this.renderContainer("open");
	                    //启用时即显示空页面
	                    this.renderTips("empty");
	                }
	            }
	        }
	    },
	    dealInvocationChanged: function dealInvocationChanged(invocation) {
	        this.bizVariable.invocation = invocation;
	        this.dealInvocationAndEffect();
	        this.dealCanUse();
	    },
	    dealEffectChanged: function dealEffectChanged(effect) {
	        this.bizVariable.effect = effect;
	        this.dealInvocationAndEffect();
	        this.dealCanUse();
	    },
	    dealShortcutsChanged: function dealShortcutsChanged() {
	        var that = this;
	        this.getShortcuts().then(function () {
	            //如果存在tips则重新渲染
	            if (that.bizVariable.tips.length > 0) {
	                //重置tooltip相关
	                that.bizVariable.hasConflict = false;
	                //影藏tooltip
	                that.renderShortcutsConfilict(99999);

	                that.rederShortcuts(that.bizVariable.tips.length);
	            }
	        }, function (error) {
	            //快捷键拉取失败不去取消息
	            that.bizVariable.canUse = false;
	        });
	    },
	    dealShortcutsClick: function dealShortcutsClick(action) {
	        if (this.bizVariable.shortcuts.length) {
	            for (var i = 0; i < this.bizVariable.shortcuts.length; i++) {
	                if (this.bizVariable.shortcuts[i].hotkey && this.bizVariable.shortcuts[i].action === action && this.bizVariable.shortcuts[i].conflict === false) {
	                    var witch;
	                    switch (action) {
	                        case "sendSmartTipFirst":
	                            witch = 1;
	                            break;
	                        case "sendSmartTipSecond":
	                            witch = 2;
	                            break;
	                        case "sendSmartTipThird":
	                            witch = 3;
	                            break;
	                        default:
	                            break;
	                    }
	                    this.sendTip(witch);
	                }
	            }
	        }
	    },


	    //维护链接消息，避免链接消息被“诈骗”提示冲掉
	    existInLink: function existInLink(msg) {
	        var exist = false;
	        this.bizVariable.linkData.forEach(function (link) {
	            if (msg.msgid === link.msgid) {
	                exist = true;
	            }
	        });
	        if (exist === false) {
	            this.bizVariable.linkData.push(msg);
	        }
	        return exist;
	    },
	    dealMsg: function dealMsg(msg) {
	        if (Util.getUid(msg.fromid) === Util.getUid(this.bizVariable.contactUser)) {
	            // 分别对应普通聊天消息，对方自动回复msg.msgtype === 1 不取
	            // 如果是链接，已经在dealLinkMsg处理了。此处用来防止不提示诈骗的淘宝域名链接的重复请求
	            if ((msg.msgtype === 0 || msg.msgtype === 2) && !this.existInLink(msg)) {
	                if (this.dealLatest(msg, "latestMsg")) {
	                    //if (this.bizVariable.invocation === 1 && this.bizVariable.effect === "1" && this.bizVariable.shortcuts !== null && !this.bizVariable.ifGroup && !this.bizVariable.ifOneShop) {
	                    //以上条件均成立时才立刻请求，否则只加入缓存
	                    if (this.bizVariable.canUse === true) {
	                        this.dealTipsGoten(msg);
	                    }
	                }
	            }
	        }
	        //else弃用考虑到群发等边界情况，但是快切时容易有问题，待验证
	        //c测试账号216:秋酷 --> qn店铺测试账号003:jial此类消息fromid为c测试账号216:秋酷 不应该当做回复处理
	        if (Util.getUid(msg.fromid) === Util.getUid(this.bizVariable.user)) {
	            Log.orange("最新消息为客服消息或其他非卖家消息");
	            //分别对应收到文本消息 群发消息，自己在其他端，机器人消息，云端自动回复
	            if (msg.msgtype === 0 || msg.msgtype === 1 || msg.msgtype === 2 || msg.msgtype === 3 || msg.msgtype === 12 || msg.msgtype === 13) {
	                this.dealLatest(msg, "latestReplyMsg");
	            }
	        }
	    },
	    dealLatest: function dealLatest(msg, type) {
	        //只有开关开启对最后一条请求智能提示
	        if (type === "latestMsg") {
	            var exist = false;
	            var retur = false;
	            for (var i = 0; i < this.bizVariable.latestMsg.length; i++) {
	                if (this.bizVariable.latestMsg[i].key === this.bizVariable.contactUser.nick) {
	                    exist = true;
	                    if (msg !== null && msg.msgtime >= this.bizVariable.latestMsg[i].value.msgtime) {
	                        this.bizVariable.latestMsg[i].value = msg;
	                        retur = true;
	                    } else {
	                        retur = false;
	                    }
	                }
	            }
	            if (exist === false) {
	                retur = true;
	                var obj = {
	                    key: this.bizVariable.contactUser.nick,
	                    value: msg
	                };
	                this.bizVariable.latestMsg.push(obj);
	            }
	            Log.orange("+latestMsg——————————————————————", this.bizVariable.latestMsg);
	            Log.orange("latestReplyMsg——————————————————————", this.bizVariable.latestReplyMsg);
	            return retur;
	        }
	        if (type === "latestReplyMsg") {
	            var exist = false;
	            for (var i = 0; i < this.bizVariable.latestReplyMsg.length; i++) {
	                if (this.bizVariable.latestReplyMsg[i].key === this.bizVariable.contactUser.nick) {
	                    exist = true;
	                    if (msg !== null && msg.msgtime >= this.bizVariable.latestReplyMsg[i].value.msgtime) {
	                        this.bizVariable.latestReplyMsg[i].value = msg;
	                    }
	                }
	            }
	            if (exist === false) {
	                var obj = {
	                    key: this.bizVariable.contactUser.nick,
	                    value: msg
	                };
	                this.bizVariable.latestReplyMsg.push(obj);
	            }
	            Log.orange("latestMsg——————————————————————", this.bizVariable.latestMsg);
	            Log.orange("+latestReplyMsg——————————————————————", this.bizVariable.latestReplyMsg);
	        }
	    },
	    dealTipsGoten: function dealTipsGoten(msg) {
	        var that = this;
	        function dealGetTips(msg, msgResult) {
	            that.renderTips("loading");
	            that.getTips(msg, msgResult).then(function () {
	                if (that.bizVariable.tips.length > 0) {
	                    that.renderTips("content", that.bizVariable.tips);
	                    that.rederShortcuts(that.bizVariable.tips.length);
	                } else {
	                    that.renderTips("openInit");
	                    that.setEffectChanged("0");
	                }
	            }, function (res) {
	                Log.orange("回复失败回调————————", res);
	                that.renderTips("empty");
	            });
	        }
	        var msgResult = "";
	        if (msg && msg.msgbody) {
	            for (var i = 0; i < msg.msgbody.length; i++) {
	                var ele = msg.msgbody[i];
	                // if(ele.type === 0 || ele.type === 1){
	                // 文字链接是0，表情图片是1
	                if (ele.type === 0) {
	                    msgResult += ele.value;
	                }
	            }
	        }
	        if (msgResult === "") {
	            return;
	        } else {
	            var exsit = false;
	            for (var i = 0; i < this.bizVariable.latestReplyMsg.length; i++) {
	                if (this.bizVariable.latestReplyMsg[i].key === this.bizVariable.contactUser.nick) {
	                    exsit = true;
	                    if (msg.msgtime >= this.bizVariable.latestReplyMsg[i].value.msgtime) {
	                        //请求不展示空页面
	                        this.bizVariable.forceShowEmpty = false;
	                        dealGetTips(msg, msgResult);
	                    } else {
	                        //不请求展示空页面
	                        this.bizVariable.forceShowEmpty = true;
	                    }
	                }
	            }
	            if (exsit === false) {
	                dealGetTips(msg, msgResult);
	            }
	        }
	    },
	    getInvocation: function getInvocation() {
	        var that = this;
	        return new Promise(function (resolve, reject) {
	            _$IMSDKRoot2.default.invoke("intelligentservice.GetSmartTipSwitch").then(function (res) {
	                console.log('智能开关接口调用成功：');
	                console.log(res);
	                that.bizVariable.invocation = res.result && res.result.smartTipSwitch;
	                // that.bizVariable.invocation = 1;
	                Log.orange("开关————————", res.result.smartTipSwitch);
	                resolve();
	            }, function (res) {
	                Log.orange("开关拉取失败————————", res);
	                that.bizVariable.invocation = 0;
	                reject(res);
	            });
	        });
	    },
	    getShortcuts: function getShortcuts() {
	        var that = this;
	        return new Promise(function (resolve, reject) {
	            _$IMSDKRoot2.default.invoke("intelligentservice.GetHotKeyList").then(function (res) {
	                that.bizVariable.shortcuts = res.result;
	                Log.orange("快捷键————————", res.result);
	                resolve();
	            }, function (res) {
	                Log.orange("快捷键拉取失败————————", res);
	                that.bizVariable.shortcuts = [];
	                reject();
	            });
	        });
	    },
	    dealSmartTipPush: function dealSmartTipPush(res) {
	        var that = this;
	        that.bizVariable.tips = res.result.recommends;
	        Log.orange("服务端推送推荐内容————————", res.result);
	        if (this.bizVariable.invocation === 1 && this.bizVariable.effect === "1" && !this.bizVariable.ifGroup && !this.bizVariable.ifOneShop) {
	            if (that.bizVariable.tips.length > 0 && this.bizVariable.contactUser && this.bizVariable.contactUser.appkey + this.bizVariable.contactUser.nick === res.result.buyerNick) {
	                that.renderTips("content", that.bizVariable.tips);
	                that.rederShortcuts(that.bizVariable.tips.length);
	            } else {
	                that.renderTips("empty");
	            }
	        }
	    },
	    getTips: function getTips(msg, msgResult) {
	        var that = this;
	        return new Promise(function (resolve, reject) {
	            var param = {
	                userId: 'cntaobao' + that.bizVariable.contactUser.nick,
	                msg: msgResult,
	                msgTime: msg.msgtime,
	                msgId: msg.msgid
	            };
	            _$IMSDKRoot2.default.invoke("intelligentservice.GetSmartTips", param).then(function (res) {
	                if (res) {
	                    that.bizVariable.tips = res.result.recommends;
	                    Log.orange("推荐内容————————", res.result);
	                    resolve();
	                } else {
	                    that.renderTips("empty");
	                }
	            }, function (res) {
	                Log.orange("回复拉取失败————————", res);
	                that.bizVariable.tips = [];
	                reject(res);
	            });
	        });
	    },
	    tempCreator: function tempCreator(tip, i) {
	        var row = document.createElement("div");
	        row.className = "row";
	        row.setAttribute('data-index', i + 1);

	        var word = document.createElement("div");
	        word.className = "word fun-ellipsis";
	        var tipWord = document.createElement("span");
	        tipWord.className = "fun-ellipsis tip-word";

	        tipWord.title = tip.contentForSeller;
	        tipWord.innerHTML = tip.contentForSeller;
	        tipWord.setAttribute('data-text', tip.contentForSeller);

	        var operator = document.createElement("div");
	        operator.className = "operator";
	        var edit = document.createElement("div");
	        edit.className = "edit";
	        // var copy = document.createElement("span");
	        // copy.className = "J_icon-edit-copy icon pointer";
	        // copy.title = "编辑";
	        // copy.innerHTML = "&#xe762;";
	        var send = document.createElement("div");
	        send.className = "send";
	        // edit.appendChild(copy);
	        operator.appendChild(edit);
	        operator.appendChild(send);
	        word.appendChild(tipWord);
	        row.appendChild(word);
	        row.appendChild(operator);
	        return row;
	    },
	    rederShortcuts: function rederShortcuts(length) {
	        var conflictNum = 0;
	        if (this.bizVariable.shortcuts.length > 0) {
	            for (var i = 0; i < length; i++) {
	                // if(reg.test(hotkey)){
	                //单键只有F1-F9
	                if (this.bizVariable.shortcuts[i].hotkey.length > 2) {
	                    var hotkey = "";
	                    conflictNum++;
	                } else {
	                    var hotkey = "（" + this.bizVariable.shortcuts[i].hotkey + "）";
	                }
	                if (this.bizVariable.shortcuts[i].conflict === true) {
	                    document.getElementsByClassName("send")[i].innerHTML = '<div class="conflict pointer"><span class="conflict-send-click" title="发送：' + this.bizVariable.shortcuts[i].hotkey + '">发送</span><span class="conflict-send-hotkey">' + hotkey + '</span></div>';
	                    if (this.bizVariable.hasConflict === false) {
	                        this.bizVariable.hasConflict = true;
	                        this.renderShortcutsConfilict(i);
	                    }
	                } else {
	                    document.getElementsByClassName("send")[i].innerHTML = '<div class="no-conflict pointer"><span class="noconflict-send-click" title="发送：' + this.bizVariable.shortcuts[i].hotkey + '">发送</span><span class="noconflict-send-hotkey">' + hotkey + '</span></div>';
	                }
	            }
	            if (conflictNum === length) {
	                for (var i = 0; i < length; i++) {
	                    document.getElementsByClassName("operator")[i].style.minWidth = "76px";
	                }
	            } else {
	                for (var i = 0; i < length; i++) {
	                    document.getElementsByClassName("operator")[i].style.minWidth = "114px";
	                }
	            }
	        }
	    },
	    renderShortcutsConfilict: function renderShortcutsConfilict(which) {
	        var tooltip = document.getElementById("tooltip");
	        document.getElementById("body").appendChild(tooltip);
	        tooltip.style.display = "inline-block";
	        tooltip.style.position = "fixed";
	        tooltip.style.bottom = -8 + 21 * (2 - which) + "px";
	    },
	    renderRow: function renderRow(tips) {
	        document.getElementById("content").innerHTML = "";
	        for (var i = 0; i < tips.length; i++) {
	            document.getElementById("content").appendChild(this.tempCreator(tips[i], i));
	        }
	    },
	    renderTips: function renderTips(arg, tips) {
	        Log.orange("renderTips", arg);
	        var empty = document.getElementById("empty");
	        var loading = document.getElementById("loading");
	        var content = document.getElementById("content");
	        var header = document.getElementById("header");
	        // header.style.width = (window.outerWidth - 10)+"px";
	        header && (header.style.top = "-38px");
	        switch (arg) {
	            case "openInit":
	            case "empty":
	                empty.style.display = "none";
	                loading.style.display = "none";
	                content.style.display = "none";
	                // header.style.height = "44px";
	                break;
	            case "loading":
	                empty.style.display = "none";
	                loading.style.display = "flex";
	                content.style.display = "none";
	                // header.style.height = "48px";
	                break;
	            case "content":
	                empty.style.display = "none";
	                loading.style.display = "none";
	                content.style.display = "flex";
	                // header.style.height = "48px";
	                this.renderRow(tips);
	                break;
	            default:
	                // header.style.top = "-48px";
	                break;
	        }
	        this.goBottom();
	    },
	    goBottom: function goBottom() {
	        var scroll = Plugin.getPlugin('scroll');
	        scroll && Win.isBottom && scroll.goBottom();
	    },
	    renderContainer: function renderContainer(arg) {
	        Log.orange("renderContainer", arg);
	        var intelligentTips = document.getElementById("intelligent-tips");
	        var openBar = document.getElementById("tab-open");
	        var closeBar = document.getElementById("tab-close");
	        var body = document.getElementById("body");
	        var empty = document.getElementById("empty");
	        var loading = document.getElementById("loading");
	        var content = document.getElementById("content");
	        // var header = document.getElementById("header");
	        switch (arg) {
	            case "none":
	                intelligentTips.style.display = "none";
	                break;
	            case "close":
	                intelligentTips.style.display = "flex";
	                openBar.style.display = "none";
	                closeBar.style.display = "block";
	                loading.style.display = "none";
	                content.style.display = "none";
	                empty.style.display = "none";
	                body.style.display = "none";
	                // header.style.height = "44px";
	                break;
	            case "open":
	                intelligentTips.style.display = "flex";
	                closeBar.style.display = "none";
	                openBar.style.display = "block";
	                body.style.display = "flex";
	                empty.style.display = "none";
	                // header.style.height = "48px";
	                Log.goldLog('/qianniuznkf.12.11');
	                break;
	            default:
	                break;
	        }
	        this.goBottom();
	    },
	    setShortcuts: function setShortcuts() {
	        //呼起热键修改
	        _$IMSDKRoot2.default.invoke("application.setISVHotkey").then(function (res) {});
	    },
	    setEffectChanged: function setEffectChanged(effectZnts) {
	        localStorage.effectZnts = effectZnts;
	        this.dealEffectChanged(localStorage.effectZnts);
	        if (localStorage.effectZnts === "1") {
	            Log.goldLog('/qianniuznkf.12.1');
	        } else {
	            Log.goldLog('/qianniuznkf.12.2');
	        }
	    },
	    sendTip: function sendTip(posi) {
	        if (document.getElementsByClassName("tip-word")[posi - 1] === undefined) {
	            return;
	        }
	        Log.goldLog('/qianniuznkf.12.' + (posi + 2));
	        if (this.bizVariable.tips && this.bizVariable.tips[posi - 1]) {
	            Log.goldLog('/qianniuznkf.12.' + (posi + 2) + '.' + this.bizVariable.tips[posi - 1].id);
	        }
	        var param = {
	            userId: this.bizVariable.contactUser.appkey + this.bizVariable.contactUser.nick,
	            smartTip: document.getElementsByClassName("tip-word")[posi - 1].getAttribute('data-text'),
	            smartTipPos: posi
	        };
	        _$IMSDKRoot2.default.invoke("intelligentservice.SendSmartTipMsg", param).then(function (res) {
	            Log.orange(res);
	        });
	    },
	    editTip: function editTip(posi) {
	        if (document.getElementsByClassName("tip-word")[posi - 1] === undefined) {
	            return;
	        }
	        Log.goldLog('/qianniuznkf.12.' + (posi + 5));
	        var param = {
	            userId: this.bizVariable.contactUser.appkey + this.bizVariable.contactUser.nick,
	            smartTip: document.getElementsByClassName("tip-word")[posi - 1].innerHTML,
	            smartTipPos: posi
	        };
	        _$IMSDKRoot2.default.invoke("intelligentservice.EditSmartTipMsg", param).then(function (res) {
	            Log.orange(res);
	        });
	    }
	};
	module.exports = exports['default'];

/***/ },
/* 225 */
/***/ function(module, exports) {

	var Zepto = (function() {
	  var undefined, key, $, classList, emptyArray = [], concat = emptyArray.concat, filter = emptyArray.filter, slice = emptyArray.slice,
	    document = window.document,
	    elementDisplay = {}, classCache = {},
	    cssNumber = { 'column-count': 1, 'columns': 1, 'font-weight': 1, 'line-height': 1,'opacity': 1, 'z-index': 1, 'zoom': 1 },
	    fragmentRE = /^\s*<(\w+|!)[^>]*>/,
	    singleTagRE = /^<(\w+)\s*\/?>(?:<\/\1>|)$/,
	    tagExpanderRE = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/ig,
	    rootNodeRE = /^(?:body|html)$/i,
	    capitalRE = /([A-Z])/g,

	    // special attributes that should be get/set via method calls
	    methodAttributes = ['val', 'css', 'html', 'text', 'data', 'width', 'height', 'offset'],

	    adjacencyOperators = [ 'after', 'prepend', 'before', 'append' ],
	    table = document.createElement('table'),
	    tableRow = document.createElement('tr'),
	    containers = {
	      'tr': document.createElement('tbody'),
	      'tbody': table, 'thead': table, 'tfoot': table,
	      'td': tableRow, 'th': tableRow,
	      '*': document.createElement('div')
	    },
	    simpleSelectorRE = /^[\w-]*$/,
	    class2type = {},
	    toString = class2type.toString,
	    zepto = {},
	    camelize, uniq,
	    tempParent = document.createElement('div'),
	    propMap = {
	      'tabindex': 'tabIndex',
	      'readonly': 'readOnly',
	      'for': 'htmlFor',
	      'class': 'className',
	      'maxlength': 'maxLength',
	      'cellspacing': 'cellSpacing',
	      'cellpadding': 'cellPadding',
	      'rowspan': 'rowSpan',
	      'colspan': 'colSpan',
	      'usemap': 'useMap',
	      'frameborder': 'frameBorder',
	      'contenteditable': 'contentEditable'
	    },
	    isArray = Array.isArray ||
	      function(object){ return object instanceof Array }

	  zepto.matches = function(element, selector) {
	    if (!selector || !element || element.nodeType !== 1) return false
	    var matchesSelector = element.matches || element.webkitMatchesSelector ||
	                          element.mozMatchesSelector || element.oMatchesSelector ||
	                          element.matchesSelector
	    if (matchesSelector) return matchesSelector.call(element, selector)
	    // fall back to performing a selector:
	    var match, parent = element.parentNode, temp = !parent
	    if (temp) (parent = tempParent).appendChild(element)
	    match = ~zepto.qsa(parent, selector).indexOf(element)
	    temp && tempParent.removeChild(element)
	    return match
	  }

	  function type(obj) {
	    return obj == null ? String(obj) :
	      class2type[toString.call(obj)] || "object"
	  }

	  function isFunction(value) { return type(value) == "function" }
	  function isWindow(obj)     { return obj != null && obj == obj.window }
	  function isDocument(obj)   { return obj != null && obj.nodeType == obj.DOCUMENT_NODE }
	  function isObject(obj)     { return type(obj) == "object" }
	  function isPlainObject(obj) {
	    return isObject(obj) && !isWindow(obj) && Object.getPrototypeOf(obj) == Object.prototype
	  }

	  function likeArray(obj) {
	    var length = !!obj && 'length' in obj && obj.length,
	      type = $.type(obj)

	    return 'function' != type && !isWindow(obj) && (
	      'array' == type || length === 0 ||
	        (typeof length == 'number' && length > 0 && (length - 1) in obj)
	    )
	  }

	  function compact(array) { return filter.call(array, function(item){ return item != null }) }
	  function flatten(array) { return array.length > 0 ? $.fn.concat.apply([], array) : array }
	  camelize = function(str){ return str.replace(/-+(.)?/g, function(match, chr){ return chr ? chr.toUpperCase() : '' }) }
	  function dasherize(str) {
	    return str.replace(/::/g, '/')
	           .replace(/([A-Z]+)([A-Z][a-z])/g, '$1_$2')
	           .replace(/([a-z\d])([A-Z])/g, '$1_$2')
	           .replace(/_/g, '-')
	           .toLowerCase()
	  }
	  uniq = function(array){ return filter.call(array, function(item, idx){ return array.indexOf(item) == idx }) }

	  function classRE(name) {
	    return name in classCache ?
	      classCache[name] : (classCache[name] = new RegExp('(^|\\s)' + name + '(\\s|$)'))
	  }

	  function maybeAddPx(name, value) {
	    return (typeof value == "number" && !cssNumber[dasherize(name)]) ? value + "px" : value
	  }

	  function defaultDisplay(nodeName) {
	    var element, display
	    if (!elementDisplay[nodeName]) {
	      element = document.createElement(nodeName)
	      document.body.appendChild(element)
	      display = getComputedStyle(element, '').getPropertyValue("display")
	      element.parentNode.removeChild(element)
	      display == "none" && (display = "block")
	      elementDisplay[nodeName] = display
	    }
	    return elementDisplay[nodeName]
	  }

	  function children(element) {
	    return 'children' in element ?
	      slice.call(element.children) :
	      $.map(element.childNodes, function(node){ if (node.nodeType == 1) return node })
	  }

	  function Z(dom, selector) {
	    var i, len = dom ? dom.length : 0
	    for (i = 0; i < len; i++) this[i] = dom[i]
	    this.length = len
	    this.selector = selector || ''
	  }

	  // `$.zepto.fragment` takes a html string and an optional tag name
	  // to generate DOM nodes from the given html string.
	  // The generated DOM nodes are returned as an array.
	  // This function can be overridden in plugins for example to make
	  // it compatible with browsers that don't support the DOM fully.
	  zepto.fragment = function(html, name, properties) {
	    var dom, nodes, container

	    // A special case optimization for a single tag
	    if (singleTagRE.test(html)) dom = $(document.createElement(RegExp.$1))

	    if (!dom) {
	      if (html.replace) html = html.replace(tagExpanderRE, "<$1></$2>")
	      if (name === undefined) name = fragmentRE.test(html) && RegExp.$1
	      if (!(name in containers)) name = '*'

	      container = containers[name]
	      container.innerHTML = '' + html
	      dom = $.each(slice.call(container.childNodes), function(){
	        container.removeChild(this)
	      })
	    }

	    if (isPlainObject(properties)) {
	      nodes = $(dom)
	      $.each(properties, function(key, value) {
	        if (methodAttributes.indexOf(key) > -1) nodes[key](value)
	        else nodes.attr(key, value)
	      })
	    }

	    return dom
	  }

	  // `$.zepto.Z` swaps out the prototype of the given `dom` array
	  // of nodes with `$.fn` and thus supplying all the Zepto functions
	  // to the array. This method can be overridden in plugins.
	  zepto.Z = function(dom, selector) {
	    return new Z(dom, selector)
	  }

	  // `$.zepto.isZ` should return `true` if the given object is a Zepto
	  // collection. This method can be overridden in plugins.
	  zepto.isZ = function(object) {
	    return object instanceof zepto.Z
	  }

	  // `$.zepto.init` is Zepto's counterpart to jQuery's `$.fn.init` and
	  // takes a CSS selector and an optional context (and handles various
	  // special cases).
	  // This method can be overridden in plugins.
	  zepto.init = function(selector, context) {
	    var dom
	    // If nothing given, return an empty Zepto collection
	    if (!selector) return zepto.Z()
	    // Optimize for string selectors
	    else if (typeof selector == 'string') {
	      selector = selector.trim()
	      // If it's a html fragment, create nodes from it
	      // Note: In both Chrome 21 and Firefox 15, DOM error 12
	      // is thrown if the fragment doesn't begin with <
	      if (selector[0] == '<' && fragmentRE.test(selector))
	        dom = zepto.fragment(selector, RegExp.$1, context), selector = null
	      // If there's a context, create a collection on that context first, and select
	      // nodes from there
	      else if (context !== undefined) return $(context).find(selector)
	      // If it's a CSS selector, use it to select nodes.
	      else dom = zepto.qsa(document, selector)
	    }
	    // If a function is given, call it when the DOM is ready
	    else if (isFunction(selector)) return $(document).ready(selector)
	    // If a Zepto collection is given, just return it
	    else if (zepto.isZ(selector)) return selector
	    else {
	      // normalize array if an array of nodes is given
	      if (isArray(selector)) dom = compact(selector)
	      // Wrap DOM nodes.
	      else if (isObject(selector))
	        dom = [selector], selector = null
	      // If it's a html fragment, create nodes from it
	      else if (fragmentRE.test(selector))
	        dom = zepto.fragment(selector.trim(), RegExp.$1, context), selector = null
	      // If there's a context, create a collection on that context first, and select
	      // nodes from there
	      else if (context !== undefined) return $(context).find(selector)
	      // And last but no least, if it's a CSS selector, use it to select nodes.
	      else dom = zepto.qsa(document, selector)
	    }
	    // create a new Zepto collection from the nodes found
	    return zepto.Z(dom, selector)
	  }

	  // `$` will be the base `Zepto` object. When calling this
	  // function just call `$.zepto.init, which makes the implementation
	  // details of selecting nodes and creating Zepto collections
	  // patchable in plugins.
	  $ = function(selector, context){
	    return zepto.init(selector, context)
	  }

	  function extend(target, source, deep) {
	    for (key in source)
	      if (deep && (isPlainObject(source[key]) || isArray(source[key]))) {
	        if (isPlainObject(source[key]) && !isPlainObject(target[key]))
	          target[key] = {}
	        if (isArray(source[key]) && !isArray(target[key]))
	          target[key] = []
	        extend(target[key], source[key], deep)
	      }
	      else if (source[key] !== undefined) target[key] = source[key]
	  }

	  // Copy all but undefined properties from one or more
	  // objects to the `target` object.
	  $.extend = function(target){
	    var deep, args = slice.call(arguments, 1)
	    if (typeof target == 'boolean') {
	      deep = target
	      target = args.shift()
	    }
	    args.forEach(function(arg){ extend(target, arg, deep) })
	    return target
	  }

	  // `$.zepto.qsa` is Zepto's CSS selector implementation which
	  // uses `document.querySelectorAll` and optimizes for some special cases, like `#id`.
	  // This method can be overridden in plugins.
	  zepto.qsa = function(element, selector){
	    var found,
	        maybeID = selector[0] == '#',
	        maybeClass = !maybeID && selector[0] == '.',
	        nameOnly = maybeID || maybeClass ? selector.slice(1) : selector, // Ensure that a 1 char tag name still gets checked
	        isSimple = simpleSelectorRE.test(nameOnly)
	    return (element.getElementById && isSimple && maybeID) ? // Safari DocumentFragment doesn't have getElementById
	      ( (found = element.getElementById(nameOnly)) ? [found] : [] ) :
	      (element.nodeType !== 1 && element.nodeType !== 9 && element.nodeType !== 11) ? [] :
	      slice.call(
	        isSimple && !maybeID && element.getElementsByClassName ? // DocumentFragment doesn't have getElementsByClassName/TagName
	          maybeClass ? element.getElementsByClassName(nameOnly) : // If it's simple, it could be a class
	          element.getElementsByTagName(selector) : // Or a tag
	          element.querySelectorAll(selector) // Or it's not simple, and we need to query all
	      )
	  }

	  function filtered(nodes, selector) {
	    return selector == null ? $(nodes) : $(nodes).filter(selector)
	  }

	  $.contains = document.documentElement.contains ?
	    function(parent, node) {
	      return parent !== node && parent.contains(node)
	    } :
	    function(parent, node) {
	      while (node && (node = node.parentNode))
	        if (node === parent) return true
	      return false
	    }

	  function funcArg(context, arg, idx, payload) {
	    return isFunction(arg) ? arg.call(context, idx, payload) : arg
	  }

	  function setAttribute(node, name, value) {
	    value == null ? node.removeAttribute(name) : node.setAttribute(name, value)
	  }

	  // access className property while respecting SVGAnimatedString
	  function className(node, value){
	    var klass = node.className || '',
	        svg   = klass && klass.baseVal !== undefined

	    if (value === undefined) return svg ? klass.baseVal : klass
	    svg ? (klass.baseVal = value) : (node.className = value)
	  }

	  // "true"  => true
	  // "false" => false
	  // "null"  => null
	  // "42"    => 42
	  // "42.5"  => 42.5
	  // "08"    => "08"
	  // JSON    => parse if valid
	  // String  => self
	  function deserializeValue(value) {
	    try {
	      return value ?
	        value == "true" ||
	        ( value == "false" ? false :
	          value == "null" ? null :
	          +value + "" == value ? +value :
	          /^[\[\{]/.test(value) ? $.parseJSON(value) :
	          value )
	        : value
	    } catch(e) {
	      return value
	    }
	  }

	  $.type = type
	  $.isFunction = isFunction
	  $.isWindow = isWindow
	  $.isArray = isArray
	  $.isPlainObject = isPlainObject

	  $.isEmptyObject = function(obj) {
	    var name
	    for (name in obj) return false
	    return true
	  }

	  $.isNumeric = function(val) {
	    var num = Number(val), type = typeof val
	    return val != null && type != 'boolean' &&
	      (type != 'string' || val.length) &&
	      !isNaN(num) && isFinite(num) || false
	  }

	  $.inArray = function(elem, array, i){
	    return emptyArray.indexOf.call(array, elem, i)
	  }

	  $.camelCase = camelize
	  $.trim = function(str) {
	    return str == null ? "" : String.prototype.trim.call(str)
	  }

	  // plugin compatibility
	  $.uuid = 0
	  $.support = { }
	  $.expr = { }
	  $.noop = function() {}

	  $.map = function(elements, callback){
	    var value, values = [], i, key
	    if (likeArray(elements))
	      for (i = 0; i < elements.length; i++) {
	        value = callback(elements[i], i)
	        if (value != null) values.push(value)
	      }
	    else
	      for (key in elements) {
	        value = callback(elements[key], key)
	        if (value != null) values.push(value)
	      }
	    return flatten(values)
	  }

	  $.each = function(elements, callback){
	    var i, key
	    if (likeArray(elements)) {
	      for (i = 0; i < elements.length; i++)
	        if (callback.call(elements[i], i, elements[i]) === false) return elements
	    } else {
	      for (key in elements)
	        if (callback.call(elements[key], key, elements[key]) === false) return elements
	    }

	    return elements
	  }

	  $.grep = function(elements, callback){
	    return filter.call(elements, callback)
	  }

	  if (window.JSON) $.parseJSON = JSON.parse

	  // Populate the class2type map
	  $.each("Boolean Number String Function Array Date RegExp Object Error".split(" "), function(i, name) {
	    class2type[ "[object " + name + "]" ] = name.toLowerCase()
	  })

	  // Define methods that will be available on all
	  // Zepto collections
	  $.fn = {
	    constructor: zepto.Z,
	    length: 0,

	    // Because a collection acts like an array
	    // copy over these useful array functions.
	    forEach: emptyArray.forEach,
	    reduce: emptyArray.reduce,
	    push: emptyArray.push,
	    sort: emptyArray.sort,
	    splice: emptyArray.splice,
	    indexOf: emptyArray.indexOf,
	    concat: function(){
	      var i, value, args = []
	      for (i = 0; i < arguments.length; i++) {
	        value = arguments[i]
	        args[i] = zepto.isZ(value) ? value.toArray() : value
	      }
	      return concat.apply(zepto.isZ(this) ? this.toArray() : this, args)
	    },

	    // `map` and `slice` in the jQuery API work differently
	    // from their array counterparts
	    map: function(fn){
	      return $($.map(this, function(el, i){ return fn.call(el, i, el) }))
	    },
	    slice: function(){
	      return $(slice.apply(this, arguments))
	    },

	    ready: function(callback){
	      // don't use "interactive" on IE <= 10 (it can fired premature)
	      if (document.readyState === "complete" ||
	          (document.readyState !== "loading" && !document.documentElement.doScroll))
	        setTimeout(function(){ callback($) }, 0)
	      else {
	        var handler = function() {
	          document.removeEventListener("DOMContentLoaded", handler, false)
	          window.removeEventListener("load", handler, false)
	          callback($)
	        }
	        document.addEventListener("DOMContentLoaded", handler, false)
	        window.addEventListener("load", handler, false)
	      }
	      return this
	    },
	    get: function(idx){
	      return idx === undefined ? slice.call(this) : this[idx >= 0 ? idx : idx + this.length]
	    },
	    toArray: function(){ return this.get() },
	    size: function(){
	      return this.length
	    },
	    remove: function(){
	      return this.each(function(){
	        if (this.parentNode != null)
	          this.parentNode.removeChild(this)
	      })
	    },
	    each: function(callback){
	      emptyArray.every.call(this, function(el, idx){
	        return callback.call(el, idx, el) !== false
	      })
	      return this
	    },
	    filter: function(selector){
	      if (isFunction(selector)) return this.not(this.not(selector))
	      return $(filter.call(this, function(element){
	        return zepto.matches(element, selector)
	      }))
	    },
	    add: function(selector,context){
	      return $(uniq(this.concat($(selector,context))))
	    },
	    is: function(selector){
	      return this.length > 0 && zepto.matches(this[0], selector)
	    },
	    not: function(selector){
	      var nodes=[]
	      if (isFunction(selector) && selector.call !== undefined)
	        this.each(function(idx){
	          if (!selector.call(this,idx)) nodes.push(this)
	        })
	      else {
	        var excludes = typeof selector == 'string' ? this.filter(selector) :
	          (likeArray(selector) && isFunction(selector.item)) ? slice.call(selector) : $(selector)
	        this.forEach(function(el){
	          if (excludes.indexOf(el) < 0) nodes.push(el)
	        })
	      }
	      return $(nodes)
	    },
	    has: function(selector){
	      return this.filter(function(){
	        return isObject(selector) ?
	          $.contains(this, selector) :
	          $(this).find(selector).size()
	      })
	    },
	    eq: function(idx){
	      return idx === -1 ? this.slice(idx) : this.slice(idx, + idx + 1)
	    },
	    first: function(){
	      var el = this[0]
	      return el && !isObject(el) ? el : $(el)
	    },
	    last: function(){
	      var el = this[this.length - 1]
	      return el && !isObject(el) ? el : $(el)
	    },
	    find: function(selector){
	      var result, $this = this
	      if (!selector) result = $()
	      else if (typeof selector == 'object')
	        result = $(selector).filter(function(){
	          var node = this
	          return emptyArray.some.call($this, function(parent){
	            return $.contains(parent, node)
	          })
	        })
	      else if (this.length == 1) result = $(zepto.qsa(this[0], selector))
	      else result = this.map(function(){ return zepto.qsa(this, selector) })
	      return result
	    },
	    closest: function(selector, context){
	      var nodes = [], collection = typeof selector == 'object' && $(selector)
	      this.each(function(_, node){
	        while (node && !(collection ? collection.indexOf(node) >= 0 : zepto.matches(node, selector)))
	          node = node !== context && !isDocument(node) && node.parentNode
	        if (node && nodes.indexOf(node) < 0) nodes.push(node)
	      })
	      return $(nodes)
	    },
	    parents: function(selector){
	      var ancestors = [], nodes = this
	      while (nodes.length > 0)
	        nodes = $.map(nodes, function(node){
	          if ((node = node.parentNode) && !isDocument(node) && ancestors.indexOf(node) < 0) {
	            ancestors.push(node)
	            return node
	          }
	        })
	      return filtered(ancestors, selector)
	    },
	    parent: function(selector){
	      return filtered(uniq(this.pluck('parentNode')), selector)
	    },
	    children: function(selector){
	      return filtered(this.map(function(){ return children(this) }), selector)
	    },
	    contents: function() {
	      return this.map(function() { return this.contentDocument || slice.call(this.childNodes) })
	    },
	    siblings: function(selector){
	      return filtered(this.map(function(i, el){
	        return filter.call(children(el.parentNode), function(child){ return child!==el })
	      }), selector)
	    },
	    empty: function(){
	      return this.each(function(){ this.innerHTML = '' })
	    },
	    // `pluck` is borrowed from Prototype.js
	    pluck: function(property){
	      return $.map(this, function(el){ return el[property] })
	    },
	    show: function(){
	      return this.each(function(){
	        this.style.display == "none" && (this.style.display = '')
	        if (getComputedStyle(this, '').getPropertyValue("display") == "none")
	          this.style.display = defaultDisplay(this.nodeName)
	      })
	    },
	    replaceWith: function(newContent){
	      return this.before(newContent).remove()
	    },
	    wrap: function(structure){
	      var func = isFunction(structure)
	      if (this[0] && !func)
	        var dom   = $(structure).get(0),
	            clone = dom.parentNode || this.length > 1

	      return this.each(function(index){
	        $(this).wrapAll(
	          func ? structure.call(this, index) :
	            clone ? dom.cloneNode(true) : dom
	        )
	      })
	    },
	    wrapAll: function(structure){
	      if (this[0]) {
	        $(this[0]).before(structure = $(structure))
	        var children
	        // drill down to the inmost element
	        while ((children = structure.children()).length) structure = children.first()
	        $(structure).append(this)
	      }
	      return this
	    },
	    wrapInner: function(structure){
	      var func = isFunction(structure)
	      return this.each(function(index){
	        var self = $(this), contents = self.contents(),
	            dom  = func ? structure.call(this, index) : structure
	        contents.length ? contents.wrapAll(dom) : self.append(dom)
	      })
	    },
	    unwrap: function(){
	      this.parent().each(function(){
	        $(this).replaceWith($(this).children())
	      })
	      return this
	    },
	    clone: function(){
	      return this.map(function(){ return this.cloneNode(true) })
	    },
	    hide: function(){
	      return this.css("display", "none")
	    },
	    toggle: function(setting){
	      return this.each(function(){
	        var el = $(this)
	        ;(setting === undefined ? el.css("display") == "none" : setting) ? el.show() : el.hide()
	      })
	    },
	    prev: function(selector){ return $(this.pluck('previousElementSibling')).filter(selector || '*') },
	    next: function(selector){ return $(this.pluck('nextElementSibling')).filter(selector || '*') },
	    html: function(html){
	      return 0 in arguments ?
	        this.each(function(idx){
	          var originHtml = this.innerHTML
	          $(this).empty().append( funcArg(this, html, idx, originHtml) )
	        }) :
	        (0 in this ? this[0].innerHTML : null)
	    },
	    text: function(text){
	      return 0 in arguments ?
	        this.each(function(idx){
	          var newText = funcArg(this, text, idx, this.textContent)
	          this.textContent = newText == null ? '' : ''+newText
	        }) :
	        (0 in this ? this.pluck('textContent').join("") : null)
	    },
	    attr: function(name, value){
	      var result
	      return (typeof name == 'string' && !(1 in arguments)) ?
	        (0 in this && this[0].nodeType == 1 && (result = this[0].getAttribute(name)) != null ? result : undefined) :
	        this.each(function(idx){
	          if (this.nodeType !== 1) return
	          if (isObject(name)) for (key in name) setAttribute(this, key, name[key])
	          else setAttribute(this, name, funcArg(this, value, idx, this.getAttribute(name)))
	        })
	    },
	    removeAttr: function(name){
	      return this.each(function(){ this.nodeType === 1 && name.split(' ').forEach(function(attribute){
	        setAttribute(this, attribute)
	      }, this)})
	    },
	    prop: function(name, value){
	      name = propMap[name] || name
	      return (1 in arguments) ?
	        this.each(function(idx){
	          this[name] = funcArg(this, value, idx, this[name])
	        }) :
	        (this[0] && this[0][name])
	    },
	    removeProp: function(name){
	      name = propMap[name] || name
	      return this.each(function(){ delete this[name] })
	    },
	    data: function(name, value){
	      var attrName = 'data-' + name.replace(capitalRE, '-$1').toLowerCase()

	      var data = (1 in arguments) ?
	        this.attr(attrName, value) :
	        this.attr(attrName)

	      return data !== null ? deserializeValue(data) : undefined
	    },
	    val: function(value){
	      if (0 in arguments) {
	        if (value == null) value = ""
	        return this.each(function(idx){
	          this.value = funcArg(this, value, idx, this.value)
	        })
	      } else {
	        return this[0] && (this[0].multiple ?
	           $(this[0]).find('option').filter(function(){ return this.selected }).pluck('value') :
	           this[0].value)
	      }
	    },
	    offset: function(coordinates){
	      if (coordinates) return this.each(function(index){
	        var $this = $(this),
	            coords = funcArg(this, coordinates, index, $this.offset()),
	            parentOffset = $this.offsetParent().offset(),
	            props = {
	              top:  coords.top  - parentOffset.top,
	              left: coords.left - parentOffset.left
	            }

	        if ($this.css('position') == 'static') props['position'] = 'relative'
	        $this.css(props)
	      })
	      if (!this.length) return null
	      if (document.documentElement !== this[0] && !$.contains(document.documentElement, this[0]))
	        return {top: 0, left: 0}
	      var obj = this[0].getBoundingClientRect()
	      return {
	        left: obj.left + window.pageXOffset,
	        top: obj.top + window.pageYOffset,
	        width: Math.round(obj.width),
	        height: Math.round(obj.height)
	      }
	    },
	    css: function(property, value){
	      if (arguments.length < 2) {
	        var element = this[0]
	        if (typeof property == 'string') {
	          if (!element) return
	          return element.style[camelize(property)] || getComputedStyle(element, '').getPropertyValue(property)
	        } else if (isArray(property)) {
	          if (!element) return
	          var props = {}
	          var computedStyle = getComputedStyle(element, '')
	          $.each(property, function(_, prop){
	            props[prop] = (element.style[camelize(prop)] || computedStyle.getPropertyValue(prop))
	          })
	          return props
	        }
	      }

	      var css = ''
	      if (type(property) == 'string') {
	        if (!value && value !== 0)
	          this.each(function(){ this.style.removeProperty(dasherize(property)) })
	        else
	          css = dasherize(property) + ":" + maybeAddPx(property, value)
	      } else {
	        for (key in property)
	          if (!property[key] && property[key] !== 0)
	            this.each(function(){ this.style.removeProperty(dasherize(key)) })
	          else
	            css += dasherize(key) + ':' + maybeAddPx(key, property[key]) + ';'
	      }

	      return this.each(function(){ this.style.cssText += ';' + css })
	    },
	    index: function(element){
	      return element ? this.indexOf($(element)[0]) : this.parent().children().indexOf(this[0])
	    },
	    hasClass: function(name){
	      if (!name) return false
	      return emptyArray.some.call(this, function(el){
	        return this.test(className(el))
	      }, classRE(name))
	    },
	    addClass: function(name){
	      if (!name) return this
	      return this.each(function(idx){
	        if (!('className' in this)) return
	        classList = []
	        var cls = className(this), newName = funcArg(this, name, idx, cls)
	        newName.split(/\s+/g).forEach(function(klass){
	          if (!$(this).hasClass(klass)) classList.push(klass)
	        }, this)
	        classList.length && className(this, cls + (cls ? " " : "") + classList.join(" "))
	      })
	    },
	    removeClass: function(name){
	      return this.each(function(idx){
	        if (!('className' in this)) return
	        if (name === undefined) return className(this, '')
	        classList = className(this)
	        funcArg(this, name, idx, classList).split(/\s+/g).forEach(function(klass){
	          classList = classList.replace(classRE(klass), " ")
	        })
	        className(this, classList.trim())
	      })
	    },
	    toggleClass: function(name, when){
	      if (!name) return this
	      return this.each(function(idx){
	        var $this = $(this), names = funcArg(this, name, idx, className(this))
	        names.split(/\s+/g).forEach(function(klass){
	          (when === undefined ? !$this.hasClass(klass) : when) ?
	            $this.addClass(klass) : $this.removeClass(klass)
	        })
	      })
	    },
	    scrollTop: function(value){
	      if (!this.length) return
	      var hasScrollTop = 'scrollTop' in this[0]
	      if (value === undefined) return hasScrollTop ? this[0].scrollTop : this[0].pageYOffset
	      return this.each(hasScrollTop ?
	        function(){ this.scrollTop = value } :
	        function(){ this.scrollTo(this.scrollX, value) })
	    },
	    scrollLeft: function(value){
	      if (!this.length) return
	      var hasScrollLeft = 'scrollLeft' in this[0]
	      if (value === undefined) return hasScrollLeft ? this[0].scrollLeft : this[0].pageXOffset
	      return this.each(hasScrollLeft ?
	        function(){ this.scrollLeft = value } :
	        function(){ this.scrollTo(value, this.scrollY) })
	    },
	    position: function() {
	      if (!this.length) return

	      var elem = this[0],
	        // Get *real* offsetParent
	        offsetParent = this.offsetParent(),
	        // Get correct offsets
	        offset       = this.offset(),
	        parentOffset = rootNodeRE.test(offsetParent[0].nodeName) ? { top: 0, left: 0 } : offsetParent.offset()

	      // Subtract element margins
	      // note: when an element has margin: auto the offsetLeft and marginLeft
	      // are the same in Safari causing offset.left to incorrectly be 0
	      offset.top  -= parseFloat( $(elem).css('margin-top') ) || 0
	      offset.left -= parseFloat( $(elem).css('margin-left') ) || 0

	      // Add offsetParent borders
	      parentOffset.top  += parseFloat( $(offsetParent[0]).css('border-top-width') ) || 0
	      parentOffset.left += parseFloat( $(offsetParent[0]).css('border-left-width') ) || 0

	      // Subtract the two offsets
	      return {
	        top:  offset.top  - parentOffset.top,
	        left: offset.left - parentOffset.left
	      }
	    },
	    offsetParent: function() {
	      return this.map(function(){
	        var parent = this.offsetParent || document.body
	        while (parent && !rootNodeRE.test(parent.nodeName) && $(parent).css("position") == "static")
	          parent = parent.offsetParent
	        return parent
	      })
	    }
	  }

	  // for now
	  $.fn.detach = $.fn.remove

	  // Generate the `width` and `height` functions
	  ;['width', 'height'].forEach(function(dimension){
	    var dimensionProperty =
	      dimension.replace(/./, function(m){ return m[0].toUpperCase() })

	    $.fn[dimension] = function(value){
	      var offset, el = this[0]
	      if (value === undefined) return isWindow(el) ? el['inner' + dimensionProperty] :
	        isDocument(el) ? el.documentElement['scroll' + dimensionProperty] :
	        (offset = this.offset()) && offset[dimension]
	      else return this.each(function(idx){
	        el = $(this)
	        el.css(dimension, funcArg(this, value, idx, el[dimension]()))
	      })
	    }
	  })

	  function traverseNode(node, fun) {
	    fun(node)
	    for (var i = 0, len = node.childNodes.length; i < len; i++)
	      traverseNode(node.childNodes[i], fun)
	  }

	  // Generate the `after`, `prepend`, `before`, `append`,
	  // `insertAfter`, `insertBefore`, `appendTo`, and `prependTo` methods.
	  adjacencyOperators.forEach(function(operator, operatorIndex) {
	    var inside = operatorIndex % 2 //=> prepend, append

	    $.fn[operator] = function(){
	      // arguments can be nodes, arrays of nodes, Zepto objects and HTML strings
	      var argType, nodes = $.map(arguments, function(arg) {
	            var arr = []
	            argType = type(arg)
	            if (argType == "array") {
	              arg.forEach(function(el) {
	                if (el.nodeType !== undefined) return arr.push(el)
	                else if ($.zepto.isZ(el)) return arr = arr.concat(el.get())
	                arr = arr.concat(zepto.fragment(el))
	              })
	              return arr
	            }
	            return argType == "object" || arg == null ?
	              arg : zepto.fragment(arg)
	          }),
	          parent, copyByClone = this.length > 1
	      if (nodes.length < 1) return this

	      return this.each(function(_, target){
	        parent = inside ? target : target.parentNode

	        // convert all methods to a "before" operation
	        target = operatorIndex == 0 ? target.nextSibling :
	                 operatorIndex == 1 ? target.firstChild :
	                 operatorIndex == 2 ? target :
	                 null

	        var parentInDocument = $.contains(document.documentElement, parent)

	        nodes.forEach(function(node){
	          if (copyByClone) node = node.cloneNode(true)
	          else if (!parent) return $(node).remove()

	          parent.insertBefore(node, target)
	          if (parentInDocument) traverseNode(node, function(el){
	            if (el.nodeName != null && el.nodeName.toUpperCase() === 'SCRIPT' &&
	               (!el.type || el.type === 'text/javascript') && !el.src){
	              var target = el.ownerDocument ? el.ownerDocument.defaultView : window
	              target['eval'].call(target, el.innerHTML)
	            }
	          })
	        })
	      })
	    }

	    // after    => insertAfter
	    // prepend  => prependTo
	    // before   => insertBefore
	    // append   => appendTo
	    $.fn[inside ? operator+'To' : 'insert'+(operatorIndex ? 'Before' : 'After')] = function(html){
	      $(html)[operator](this)
	      return this
	    }
	  })

	  zepto.Z.prototype = Z.prototype = $.fn

	  // Export internal API functions in the `$.zepto` namespace
	  zepto.uniq = uniq
	  zepto.deserializeValue = deserializeValue
	  $.zepto = zepto

	  return $
	})()

	window.Zepto = Zepto
	window.$ === undefined && (window.$ = Zepto)

	;(function($){
	  var _zid = 1, undefined,
	      slice = Array.prototype.slice,
	      isFunction = $.isFunction,
	      isString = function(obj){ return typeof obj == 'string' },
	      handlers = {},
	      specialEvents={},
	      focusinSupported = 'onfocusin' in window,
	      focus = { focus: 'focusin', blur: 'focusout' },
	      hover = { mouseenter: 'mouseover', mouseleave: 'mouseout' }

	  specialEvents.click = specialEvents.mousedown = specialEvents.mouseup = specialEvents.mousemove = 'MouseEvents'

	  function zid(element) {
	    return element._zid || (element._zid = _zid++)
	  }
	  function findHandlers(element, event, fn, selector) {
	    event = parse(event)
	    if (event.ns) var matcher = matcherFor(event.ns)
	    return (handlers[zid(element)] || []).filter(function(handler) {
	      return handler
	        && (!event.e  || handler.e == event.e)
	        && (!event.ns || matcher.test(handler.ns))
	        && (!fn       || zid(handler.fn) === zid(fn))
	        && (!selector || handler.sel == selector)
	    })
	  }
	  function parse(event) {
	    var parts = ('' + event).split('.')
	    return {e: parts[0], ns: parts.slice(1).sort().join(' ')}
	  }
	  function matcherFor(ns) {
	    return new RegExp('(?:^| )' + ns.replace(' ', ' .* ?') + '(?: |$)')
	  }

	  function eventCapture(handler, captureSetting) {
	    return handler.del &&
	      (!focusinSupported && (handler.e in focus)) ||
	      !!captureSetting
	  }

	  function realEvent(type) {
	    return hover[type] || (focusinSupported && focus[type]) || type
	  }

	  function add(element, events, fn, data, selector, delegator, capture){
	    var id = zid(element), set = (handlers[id] || (handlers[id] = []))
	    events.split(/\s/).forEach(function(event){
	      if (event == 'ready') return $(document).ready(fn)
	      var handler   = parse(event)
	      handler.fn    = fn
	      handler.sel   = selector
	      // emulate mouseenter, mouseleave
	      if (handler.e in hover) fn = function(e){
	        var related = e.relatedTarget
	        if (!related || (related !== this && !$.contains(this, related)))
	          return handler.fn.apply(this, arguments)
	      }
	      handler.del   = delegator
	      var callback  = delegator || fn
	      handler.proxy = function(e){
	        e = compatible(e)
	        if (e.isImmediatePropagationStopped()) return
	        e.data = data
	        var result = callback.apply(element, e._args == undefined ? [e] : [e].concat(e._args))
	        if (result === false) e.preventDefault(), e.stopPropagation()
	        return result
	      }
	      handler.i = set.length
	      set.push(handler)
	      if ('addEventListener' in element)
	        element.addEventListener(realEvent(handler.e), handler.proxy, eventCapture(handler, capture))
	    })
	  }
	  function remove(element, events, fn, selector, capture){
	    var id = zid(element)
	    ;(events || '').split(/\s/).forEach(function(event){
	      findHandlers(element, event, fn, selector).forEach(function(handler){
	        delete handlers[id][handler.i]
	      if ('removeEventListener' in element)
	        element.removeEventListener(realEvent(handler.e), handler.proxy, eventCapture(handler, capture))
	      })
	    })
	  }

	  $.event = { add: add, remove: remove }

	  $.proxy = function(fn, context) {
	    var args = (2 in arguments) && slice.call(arguments, 2)
	    if (isFunction(fn)) {
	      var proxyFn = function(){ return fn.apply(context, args ? args.concat(slice.call(arguments)) : arguments) }
	      proxyFn._zid = zid(fn)
	      return proxyFn
	    } else if (isString(context)) {
	      if (args) {
	        args.unshift(fn[context], fn)
	        return $.proxy.apply(null, args)
	      } else {
	        return $.proxy(fn[context], fn)
	      }
	    } else {
	      throw new TypeError("expected function")
	    }
	  }

	  $.fn.bind = function(event, data, callback){
	    return this.on(event, data, callback)
	  }
	  $.fn.unbind = function(event, callback){
	    return this.off(event, callback)
	  }
	  $.fn.one = function(event, selector, data, callback){
	    return this.on(event, selector, data, callback, 1)
	  }

	  var returnTrue = function(){return true},
	      returnFalse = function(){return false},
	      ignoreProperties = /^([A-Z]|returnValue$|layer[XY]$|webkitMovement[XY]$)/,
	      eventMethods = {
	        preventDefault: 'isDefaultPrevented',
	        stopImmediatePropagation: 'isImmediatePropagationStopped',
	        stopPropagation: 'isPropagationStopped'
	      }

	  function compatible(event, source) {
	    if (source || !event.isDefaultPrevented) {
	      source || (source = event)

	      $.each(eventMethods, function(name, predicate) {
	        var sourceMethod = source[name]
	        event[name] = function(){
	          this[predicate] = returnTrue
	          return sourceMethod && sourceMethod.apply(source, arguments)
	        }
	        event[predicate] = returnFalse
	      })

	      try {
	        event.timeStamp || (event.timeStamp = Date.now())
	      } catch (ignored) { }

	      if (source.defaultPrevented !== undefined ? source.defaultPrevented :
	          'returnValue' in source ? source.returnValue === false :
	          source.getPreventDefault && source.getPreventDefault())
	        event.isDefaultPrevented = returnTrue
	    }
	    return event
	  }

	  function createProxy(event) {
	    var key, proxy = { originalEvent: event }
	    for (key in event)
	      if (!ignoreProperties.test(key) && event[key] !== undefined) proxy[key] = event[key]

	    return compatible(proxy, event)
	  }

	  $.fn.delegate = function(selector, event, callback){
	    return this.on(event, selector, callback)
	  }
	  $.fn.undelegate = function(selector, event, callback){
	    return this.off(event, selector, callback)
	  }

	  $.fn.live = function(event, callback){
	    $(document.body).delegate(this.selector, event, callback)
	    return this
	  }
	  $.fn.die = function(event, callback){
	    $(document.body).undelegate(this.selector, event, callback)
	    return this
	  }

	  $.fn.on = function(event, selector, data, callback, one){
	    var autoRemove, delegator, $this = this
	    if (event && !isString(event)) {
	      $.each(event, function(type, fn){
	        $this.on(type, selector, data, fn, one)
	      })
	      return $this
	    }

	    if (!isString(selector) && !isFunction(callback) && callback !== false)
	      callback = data, data = selector, selector = undefined
	    if (callback === undefined || data === false)
	      callback = data, data = undefined

	    if (callback === false) callback = returnFalse

	    return $this.each(function(_, element){
	      if (one) autoRemove = function(e){
	        remove(element, e.type, callback)
	        return callback.apply(this, arguments)
	      }

	      if (selector) delegator = function(e){
	        var evt, match = $(e.target).closest(selector, element).get(0)
	        if (match && match !== element) {
	          evt = $.extend(createProxy(e), {currentTarget: match, liveFired: element})
	          return (autoRemove || callback).apply(match, [evt].concat(slice.call(arguments, 1)))
	        }
	      }

	      add(element, event, callback, data, selector, delegator || autoRemove)
	    })
	  }
	  $.fn.off = function(event, selector, callback){
	    var $this = this
	    if (event && !isString(event)) {
	      $.each(event, function(type, fn){
	        $this.off(type, selector, fn)
	      })
	      return $this
	    }

	    if (!isString(selector) && !isFunction(callback) && callback !== false)
	      callback = selector, selector = undefined

	    if (callback === false) callback = returnFalse

	    return $this.each(function(){
	      remove(this, event, callback, selector)
	    })
	  }

	  $.fn.trigger = function(event, args){
	    event = (isString(event) || $.isPlainObject(event)) ? $.Event(event) : compatible(event)
	    event._args = args
	    return this.each(function(){
	      // handle focus(), blur() by calling them directly
	      if (event.type in focus && typeof this[event.type] == "function") this[event.type]()
	      // items in the collection might not be DOM elements
	      else if ('dispatchEvent' in this) this.dispatchEvent(event)
	      else $(this).triggerHandler(event, args)
	    })
	  }

	  // triggers event handlers on current element just as if an event occurred,
	  // doesn't trigger an actual event, doesn't bubble
	  $.fn.triggerHandler = function(event, args){
	    var e, result
	    this.each(function(i, element){
	      e = createProxy(isString(event) ? $.Event(event) : event)
	      e._args = args
	      e.target = element
	      $.each(findHandlers(element, event.type || event), function(i, handler){
	        result = handler.proxy(e)
	        if (e.isImmediatePropagationStopped()) return false
	      })
	    })
	    return result
	  }

	  // shortcut methods for `.bind(event, fn)` for each event type
	  ;('focusin focusout focus blur load resize scroll unload click dblclick '+
	  'mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave '+
	  'change select keydown keypress keyup error').split(' ').forEach(function(event) {
	    $.fn[event] = function(callback) {
	      return (0 in arguments) ?
	        this.bind(event, callback) :
	        this.trigger(event)
	    }
	  })

	  $.Event = function(type, props) {
	    if (!isString(type)) props = type, type = props.type
	    var event = document.createEvent(specialEvents[type] || 'Events'), bubbles = true
	    if (props) for (var name in props) (name == 'bubbles') ? (bubbles = !!props[name]) : (event[name] = props[name])
	    event.initEvent(type, bubbles, true)
	    return compatible(event)
	  }

	})(Zepto)

	;(function($){
	  var jsonpID = +new Date(),
	      document = window.document,
	      key,
	      name,
	      rscript = /<script\b[^<]*(?:(?!<\/script>)<[^<]*)*<\/script>/gi,
	      scriptTypeRE = /^(?:text|application)\/javascript/i,
	      xmlTypeRE = /^(?:text|application)\/xml/i,
	      jsonType = 'application/json',
	      htmlType = 'text/html',
	      blankRE = /^\s*$/,
	      originAnchor = document.createElement('a')

	  originAnchor.href = window.location.href

	  // trigger a custom event and return false if it was cancelled
	  function triggerAndReturn(context, eventName, data) {
	    var event = $.Event(eventName)
	    $(context).trigger(event, data)
	    return !event.isDefaultPrevented()
	  }

	  // trigger an Ajax "global" event
	  function triggerGlobal(settings, context, eventName, data) {
	    if (settings.global) return triggerAndReturn(context || document, eventName, data)
	  }

	  // Number of active Ajax requests
	  $.active = 0

	  function ajaxStart(settings) {
	    if (settings.global && $.active++ === 0) triggerGlobal(settings, null, 'ajaxStart')
	  }
	  function ajaxStop(settings) {
	    if (settings.global && !(--$.active)) triggerGlobal(settings, null, 'ajaxStop')
	  }

	  // triggers an extra global event "ajaxBeforeSend" that's like "ajaxSend" but cancelable
	  function ajaxBeforeSend(xhr, settings) {
	    var context = settings.context
	    if (settings.beforeSend.call(context, xhr, settings) === false ||
	        triggerGlobal(settings, context, 'ajaxBeforeSend', [xhr, settings]) === false)
	      return false

	    triggerGlobal(settings, context, 'ajaxSend', [xhr, settings])
	  }
	  function ajaxSuccess(data, xhr, settings, deferred) {
	    var context = settings.context, status = 'success'
	    settings.success.call(context, data, status, xhr)
	    if (deferred) deferred.resolveWith(context, [data, status, xhr])
	    triggerGlobal(settings, context, 'ajaxSuccess', [xhr, settings, data])
	    ajaxComplete(status, xhr, settings)
	  }
	  // type: "timeout", "error", "abort", "parsererror"
	  function ajaxError(error, type, xhr, settings, deferred) {
	    var context = settings.context
	    settings.error.call(context, xhr, type, error)
	    if (deferred) deferred.rejectWith(context, [xhr, type, error])
	    triggerGlobal(settings, context, 'ajaxError', [xhr, settings, error || type])
	    ajaxComplete(type, xhr, settings)
	  }
	  // status: "success", "notmodified", "error", "timeout", "abort", "parsererror"
	  function ajaxComplete(status, xhr, settings) {
	    var context = settings.context
	    settings.complete.call(context, xhr, status)
	    triggerGlobal(settings, context, 'ajaxComplete', [xhr, settings])
	    ajaxStop(settings)
	  }

	  function ajaxDataFilter(data, type, settings) {
	    if (settings.dataFilter == empty) return data
	    var context = settings.context
	    return settings.dataFilter.call(context, data, type)
	  }

	  // Empty function, used as default callback
	  function empty() {}

	  $.ajaxJSONP = function(options, deferred){
	    if (!('type' in options)) return $.ajax(options)

	    var _callbackName = options.jsonpCallback,
	      callbackName = ($.isFunction(_callbackName) ?
	        _callbackName() : _callbackName) || ('Zepto' + (jsonpID++)),
	      script = document.createElement('script'),
	      originalCallback = window[callbackName],
	      responseData,
	      abort = function(errorType) {
	        $(script).triggerHandler('error', errorType || 'abort')
	      },
	      xhr = { abort: abort }, abortTimeout

	    if (deferred) deferred.promise(xhr)

	    $(script).on('load error', function(e, errorType){
	      clearTimeout(abortTimeout)
	      $(script).off().remove()

	      if (e.type == 'error' || !responseData) {
	        ajaxError(null, errorType || 'error', xhr, options, deferred)
	      } else {
	        ajaxSuccess(responseData[0], xhr, options, deferred)
	      }

	      window[callbackName] = originalCallback
	      if (responseData && $.isFunction(originalCallback))
	        originalCallback(responseData[0])

	      originalCallback = responseData = undefined
	    })

	    if (ajaxBeforeSend(xhr, options) === false) {
	      abort('abort')
	      return xhr
	    }

	    window[callbackName] = function(){
	      responseData = arguments
	    }

	    script.src = options.url.replace(/\?(.+)=\?/, '?$1=' + callbackName)
	    document.head.appendChild(script)

	    if (options.timeout > 0) abortTimeout = setTimeout(function(){
	      abort('timeout')
	    }, options.timeout)

	    return xhr
	  }

	  $.ajaxSettings = {
	    // Default type of request
	    type: 'GET',
	    // Callback that is executed before request
	    beforeSend: empty,
	    // Callback that is executed if the request succeeds
	    success: empty,
	    // Callback that is executed the the server drops error
	    error: empty,
	    // Callback that is executed on request complete (both: error and success)
	    complete: empty,
	    // The context for the callbacks
	    context: null,
	    // Whether to trigger "global" Ajax events
	    global: true,
	    // Transport
	    xhr: function () {
	      return new window.XMLHttpRequest()
	    },
	    // MIME types mapping
	    // IIS returns Javascript as "application/x-javascript"
	    accepts: {
	      script: 'text/javascript, application/javascript, application/x-javascript',
	      json:   jsonType,
	      xml:    'application/xml, text/xml',
	      html:   htmlType,
	      text:   'text/plain'
	    },
	    // Whether the request is to another domain
	    crossDomain: false,
	    // Default timeout
	    timeout: 0,
	    // Whether data should be serialized to string
	    processData: true,
	    // Whether the browser should be allowed to cache GET responses
	    cache: true,
	    //Used to handle the raw response data of XMLHttpRequest.
	    //This is a pre-filtering function to sanitize the response.
	    //The sanitized response should be returned
	    dataFilter: empty
	  }

	  function mimeToDataType(mime) {
	    if (mime) mime = mime.split(';', 2)[0]
	    return mime && ( mime == htmlType ? 'html' :
	      mime == jsonType ? 'json' :
	      scriptTypeRE.test(mime) ? 'script' :
	      xmlTypeRE.test(mime) && 'xml' ) || 'text'
	  }

	  function appendQuery(url, query) {
	    if (query == '') return url
	    return (url + '&' + query).replace(/[&?]{1,2}/, '?')
	  }

	  // serialize payload and append it to the URL for GET requests
	  function serializeData(options) {
	    if (options.processData && options.data && $.type(options.data) != "string")
	      options.data = $.param(options.data, options.traditional)
	    if (options.data && (!options.type || options.type.toUpperCase() == 'GET' || 'jsonp' == options.dataType))
	      options.url = appendQuery(options.url, options.data), options.data = undefined
	  }

	  $.ajax = function(options){
	    var settings = $.extend({}, options || {}),
	        deferred = $.Deferred && $.Deferred(),
	        urlAnchor, hashIndex
	    for (key in $.ajaxSettings) if (settings[key] === undefined) settings[key] = $.ajaxSettings[key]

	    ajaxStart(settings)

	    if (!settings.crossDomain) {
	      urlAnchor = document.createElement('a')
	      urlAnchor.href = settings.url
	      // cleans up URL for .href (IE only), see https://github.com/madrobby/zepto/pull/1049
	      urlAnchor.href = urlAnchor.href
	      settings.crossDomain = (originAnchor.protocol + '//' + originAnchor.host) !== (urlAnchor.protocol + '//' + urlAnchor.host)
	    }

	    if (!settings.url) settings.url = window.location.toString()
	    if ((hashIndex = settings.url.indexOf('#')) > -1) settings.url = settings.url.slice(0, hashIndex)
	    serializeData(settings)

	    var dataType = settings.dataType, hasPlaceholder = /\?.+=\?/.test(settings.url)
	    if (hasPlaceholder) dataType = 'jsonp'

	    if (settings.cache === false || (
	         (!options || options.cache !== true) &&
	         ('script' == dataType || 'jsonp' == dataType)
	        ))
	      settings.url = appendQuery(settings.url, '_=' + Date.now())

	    if ('jsonp' == dataType) {
	      if (!hasPlaceholder)
	        settings.url = appendQuery(settings.url,
	          settings.jsonp ? (settings.jsonp + '=?') : settings.jsonp === false ? '' : 'callback=?')
	      return $.ajaxJSONP(settings, deferred)
	    }

	    var mime = settings.accepts[dataType],
	        headers = { },
	        setHeader = function(name, value) { headers[name.toLowerCase()] = [name, value] },
	        protocol = /^([\w-]+:)\/\//.test(settings.url) ? RegExp.$1 : window.location.protocol,
	        xhr = settings.xhr(),
	        nativeSetHeader = xhr.setRequestHeader,
	        abortTimeout

	    if (deferred) deferred.promise(xhr)

	    if (!settings.crossDomain) setHeader('X-Requested-With', 'XMLHttpRequest')
	    setHeader('Accept', mime || '*/*')
	    if (mime = settings.mimeType || mime) {
	      if (mime.indexOf(',') > -1) mime = mime.split(',', 2)[0]
	      xhr.overrideMimeType && xhr.overrideMimeType(mime)
	    }
	    if (settings.contentType || (settings.contentType !== false && settings.data && settings.type.toUpperCase() != 'GET'))
	      setHeader('Content-Type', settings.contentType || 'application/x-www-form-urlencoded')

	    if (settings.headers) for (name in settings.headers) setHeader(name, settings.headers[name])
	    xhr.setRequestHeader = setHeader

	    xhr.onreadystatechange = function(){
	      if (xhr.readyState == 4) {
	        xhr.onreadystatechange = empty
	        clearTimeout(abortTimeout)
	        var result, error = false
	        if ((xhr.status >= 200 && xhr.status < 300) || xhr.status == 304 || (xhr.status == 0 && protocol == 'file:')) {
	          dataType = dataType || mimeToDataType(settings.mimeType || xhr.getResponseHeader('content-type'))

	          if (xhr.responseType == 'arraybuffer' || xhr.responseType == 'blob')
	            result = xhr.response
	          else {
	            result = xhr.responseText

	            try {
	              // http://perfectionkills.com/global-eval-what-are-the-options/
	              // sanitize response accordingly if data filter callback provided
	              result = ajaxDataFilter(result, dataType, settings)
	              if (dataType == 'script')    (1,eval)(result)
	              else if (dataType == 'xml')  result = xhr.responseXML
	              else if (dataType == 'json') result = blankRE.test(result) ? null : $.parseJSON(result)
	            } catch (e) { error = e }

	            if (error) return ajaxError(error, 'parsererror', xhr, settings, deferred)
	          }

	          ajaxSuccess(result, xhr, settings, deferred)
	        } else {
	          ajaxError(xhr.statusText || null, xhr.status ? 'error' : 'abort', xhr, settings, deferred)
	        }
	      }
	    }

	    if (ajaxBeforeSend(xhr, settings) === false) {
	      xhr.abort()
	      ajaxError(null, 'abort', xhr, settings, deferred)
	      return xhr
	    }

	    var async = 'async' in settings ? settings.async : true
	    xhr.open(settings.type, settings.url, async, settings.username, settings.password)

	    if (settings.xhrFields) for (name in settings.xhrFields) xhr[name] = settings.xhrFields[name]

	    for (name in headers) nativeSetHeader.apply(xhr, headers[name])

	    if (settings.timeout > 0) abortTimeout = setTimeout(function(){
	        xhr.onreadystatechange = empty
	        xhr.abort()
	        ajaxError(null, 'timeout', xhr, settings, deferred)
	      }, settings.timeout)

	    // avoid sending empty string (#319)
	    xhr.send(settings.data ? settings.data : null)
	    return xhr
	  }

	  // handle optional data/success arguments
	  function parseArguments(url, data, success, dataType) {
	    if ($.isFunction(data)) dataType = success, success = data, data = undefined
	    if (!$.isFunction(success)) dataType = success, success = undefined
	    return {
	      url: url
	    , data: data
	    , success: success
	    , dataType: dataType
	    }
	  }

	  $.get = function(/* url, data, success, dataType */){
	    return $.ajax(parseArguments.apply(null, arguments))
	  }

	  $.post = function(/* url, data, success, dataType */){
	    var options = parseArguments.apply(null, arguments)
	    options.type = 'POST'
	    return $.ajax(options)
	  }

	  $.getJSON = function(/* url, data, success */){
	    var options = parseArguments.apply(null, arguments)
	    options.dataType = 'json'
	    return $.ajax(options)
	  }

	  $.fn.load = function(url, data, success){
	    if (!this.length) return this
	    var self = this, parts = url.split(/\s/), selector,
	        options = parseArguments(url, data, success),
	        callback = options.success
	    if (parts.length > 1) options.url = parts[0], selector = parts[1]
	    options.success = function(response){
	      self.html(selector ?
	        $('<div>').html(response.replace(rscript, "")).find(selector)
	        : response)
	      callback && callback.apply(self, arguments)
	    }
	    $.ajax(options)
	    return this
	  }

	  var escape = encodeURIComponent

	  function serialize(params, obj, traditional, scope){
	    var type, array = $.isArray(obj), hash = $.isPlainObject(obj)
	    $.each(obj, function(key, value) {
	      type = $.type(value)
	      if (scope) key = traditional ? scope :
	        scope + '[' + (hash || type == 'object' || type == 'array' ? key : '') + ']'
	      // handle data in serializeArray() format
	      if (!scope && array) params.add(value.name, value.value)
	      // recurse into nested objects
	      else if (type == "array" || (!traditional && type == "object"))
	        serialize(params, value, traditional, key)
	      else params.add(key, value)
	    })
	  }

	  $.param = function(obj, traditional){
	    var params = []
	    params.add = function(key, value) {
	      if ($.isFunction(value)) value = value()
	      if (value == null) value = ""
	      this.push(escape(key) + '=' + escape(value))
	    }
	    serialize(params, obj, traditional)
	    return params.join('&').replace(/%20/g, '+')
	  }
	})(Zepto)

	;(function($, undefined){
	  var prefix = '', eventPrefix,
	    vendors = { Webkit: 'webkit', Moz: '', O: 'o' },
	    testEl = document.createElement('div'),
	    supportedTransforms = /^((translate|rotate|scale)(X|Y|Z|3d)?|matrix(3d)?|perspective|skew(X|Y)?)$/i,
	    transform,
	    transitionProperty, transitionDuration, transitionTiming, transitionDelay,
	    animationName, animationDuration, animationTiming, animationDelay,
	    cssReset = {}

	  function dasherize(str) { return str.replace(/([A-Z])/g, '-$1').toLowerCase() }
	  function normalizeEvent(name) { return eventPrefix ? eventPrefix + name : name.toLowerCase() }

	  if (testEl.style.transform === undefined) $.each(vendors, function(vendor, event){
	    if (testEl.style[vendor + 'TransitionProperty'] !== undefined) {
	      prefix = '-' + vendor.toLowerCase() + '-'
	      eventPrefix = event
	      return false
	    }
	  })

	  transform = prefix + 'transform'
	  cssReset[transitionProperty = prefix + 'transition-property'] =
	  cssReset[transitionDuration = prefix + 'transition-duration'] =
	  cssReset[transitionDelay    = prefix + 'transition-delay'] =
	  cssReset[transitionTiming   = prefix + 'transition-timing-function'] =
	  cssReset[animationName      = prefix + 'animation-name'] =
	  cssReset[animationDuration  = prefix + 'animation-duration'] =
	  cssReset[animationDelay     = prefix + 'animation-delay'] =
	  cssReset[animationTiming    = prefix + 'animation-timing-function'] = ''

	  $.fx = {
	    off: (eventPrefix === undefined && testEl.style.transitionProperty === undefined),
	    speeds: { _default: 400, fast: 200, slow: 600 },
	    cssPrefix: prefix,
	    transitionEnd: normalizeEvent('TransitionEnd'),
	    animationEnd: normalizeEvent('AnimationEnd')
	  }

	  $.fn.animate = function(properties, duration, ease, callback, delay){
	    if ($.isFunction(duration))
	      callback = duration, ease = undefined, duration = undefined
	    if ($.isFunction(ease))
	      callback = ease, ease = undefined
	    if ($.isPlainObject(duration))
	      ease = duration.easing, callback = duration.complete, delay = duration.delay, duration = duration.duration
	    if (duration) duration = (typeof duration == 'number' ? duration :
	                    ($.fx.speeds[duration] || $.fx.speeds._default)) / 1000
	    if (delay) delay = parseFloat(delay) / 1000
	    return this.anim(properties, duration, ease, callback, delay)
	  }

	  $.fn.anim = function(properties, duration, ease, callback, delay){
	    var key, cssValues = {}, cssProperties, transforms = '',
	        that = this, wrappedCallback, endEvent = $.fx.transitionEnd,
	        fired = false

	    if (duration === undefined) duration = $.fx.speeds._default / 1000
	    if (delay === undefined) delay = 0
	    if ($.fx.off) duration = 0

	    if (typeof properties == 'string') {
	      // keyframe animation
	      cssValues[animationName] = properties
	      cssValues[animationDuration] = duration + 's'
	      cssValues[animationDelay] = delay + 's'
	      cssValues[animationTiming] = (ease || 'linear')
	      endEvent = $.fx.animationEnd
	    } else {
	      cssProperties = []
	      // CSS transitions
	      for (key in properties)
	        if (supportedTransforms.test(key)) transforms += key + '(' + properties[key] + ') '
	        else cssValues[key] = properties[key], cssProperties.push(dasherize(key))

	      if (transforms) cssValues[transform] = transforms, cssProperties.push(transform)
	      if (duration > 0 && typeof properties === 'object') {
	        cssValues[transitionProperty] = cssProperties.join(', ')
	        cssValues[transitionDuration] = duration + 's'
	        cssValues[transitionDelay] = delay + 's'
	        cssValues[transitionTiming] = (ease || 'linear')
	      }
	    }

	    wrappedCallback = function(event){
	      if (typeof event !== 'undefined') {
	        if (event.target !== event.currentTarget) return // makes sure the event didn't bubble from "below"
	        $(event.target).unbind(endEvent, wrappedCallback)
	      } else
	        $(this).unbind(endEvent, wrappedCallback) // triggered by setTimeout

	      fired = true
	      $(this).css(cssReset)
	      callback && callback.call(this)
	    }
	    if (duration > 0){
	      this.bind(endEvent, wrappedCallback)
	      // transitionEnd is not always firing on older Android phones
	      // so make sure it gets fired
	      setTimeout(function(){
	        if (fired) return
	        wrappedCallback.call(that)
	      }, ((duration + delay) * 1000) + 25)
	    }

	    // trigger page reflow so new elements can animate
	    this.size() && this.get(0).clientLeft

	    this.css(cssValues)

	    if (duration <= 0) setTimeout(function() {
	      that.each(function(){ wrappedCallback.call(this) })
	    }, 0)

	    return this
	  }

	  testEl = null
	})(Zepto)

	;(function($, undefined){
	  var document = window.document, docElem = document.documentElement,
	    origShow = $.fn.show, origHide = $.fn.hide, origToggle = $.fn.toggle

	  function anim(el, speed, opacity, scale, callback) {
	    if (typeof speed == 'function' && !callback) callback = speed, speed = undefined
	    var props = { opacity: opacity }
	    if (scale) {
	      props.scale = scale
	      el.css($.fx.cssPrefix + 'transform-origin', '0 0')
	    }
	    return el.animate(props, speed, null, callback)
	  }

	  function hide(el, speed, scale, callback) {
	    return anim(el, speed, 0, scale, function(){
	      origHide.call($(this))
	      callback && callback.call(this)
	    })
	  }

	  $.fn.show = function(speed, callback) {
	    origShow.call(this)
	    if (speed === undefined) speed = 0
	    else this.css('opacity', 0)
	    return anim(this, speed, 1, '1,1', callback)
	  }

	  $.fn.hide = function(speed, callback) {
	    if (speed === undefined) return origHide.call(this)
	    else return hide(this, speed, '0,0', callback)
	  }

	  $.fn.toggle = function(speed, callback) {
	    if (speed === undefined || typeof speed == 'boolean')
	      return origToggle.call(this, speed)
	    else return this.each(function(){
	      var el = $(this)
	      el[el.css('display') == 'none' ? 'show' : 'hide'](speed, callback)
	    })
	  }

	  $.fn.fadeTo = function(speed, opacity, callback) {
	    return anim(this, speed, opacity, null, callback)
	  }

	  $.fn.fadeIn = function(speed, callback) {
	    var target = this.css('opacity')
	    if (target > 0) this.css('opacity', 0)
	    else target = 1
	    return origShow.call(this).fadeTo(speed, target, callback)
	  }

	  $.fn.fadeOut = function(speed, callback) {
	    return hide(this, speed, null, callback)
	  }

	  $.fn.fadeToggle = function(speed, callback) {
	    return this.each(function(){
	      var el = $(this)
	      el[
	        (el.css('opacity') == 0 || el.css('display') == 'none') ? 'fadeIn' : 'fadeOut'
	      ](speed, callback)
	    })
	  }

	})(Zepto)

	;(function($){
	  function detect(ua, platform){
	    var os = this.os = {}, browser = this.browser = {},
	      webkit = ua.match(/Web[kK]it[\/]{0,1}([\d.]+)/),
	      android = ua.match(/(Android);?[\s\/]+([\d.]+)?/),
	      osx = !!ua.match(/\(Macintosh\; Intel /),
	      ipad = ua.match(/(iPad).*OS\s([\d_]+)/),
	      ipod = ua.match(/(iPod)(.*OS\s([\d_]+))?/),
	      iphone = !ipad && ua.match(/(iPhone\sOS)\s([\d_]+)/),
	      webos = ua.match(/(webOS|hpwOS)[\s\/]([\d.]+)/),
	      win = /Win\d{2}|Windows/.test(platform),
	      wp = ua.match(/Windows Phone ([\d.]+)/),
	      touchpad = webos && ua.match(/TouchPad/),
	      kindle = ua.match(/Kindle\/([\d.]+)/),
	      silk = ua.match(/Silk\/([\d._]+)/),
	      blackberry = ua.match(/(BlackBerry).*Version\/([\d.]+)/),
	      bb10 = ua.match(/(BB10).*Version\/([\d.]+)/),
	      rimtabletos = ua.match(/(RIM\sTablet\sOS)\s([\d.]+)/),
	      playbook = ua.match(/PlayBook/),
	      chrome = ua.match(/Chrome\/([\d.]+)/) || ua.match(/CriOS\/([\d.]+)/),
	      firefox = ua.match(/Firefox\/([\d.]+)/),
	      firefoxos = ua.match(/\((?:Mobile|Tablet); rv:([\d.]+)\).*Firefox\/[\d.]+/),
	      ie = ua.match(/MSIE\s([\d.]+)/) || ua.match(/Trident\/[\d](?=[^\?]+).*rv:([0-9.].)/),
	      webview = !chrome && ua.match(/(iPhone|iPod|iPad).*AppleWebKit(?!.*Safari)/),
	      safari = webview || ua.match(/Version\/([\d.]+)([^S](Safari)|[^M]*(Mobile)[^S]*(Safari))/)

	    // Todo: clean this up with a better OS/browser seperation:
	    // - discern (more) between multiple browsers on android
	    // - decide if kindle fire in silk mode is android or not
	    // - Firefox on Android doesn't specify the Android version
	    // - possibly devide in os, device and browser hashes

	    if (browser.webkit = !!webkit) browser.version = webkit[1]

	    if (android) os.android = true, os.version = android[2]
	    if (iphone && !ipod) os.ios = os.iphone = true, os.version = iphone[2].replace(/_/g, '.')
	    if (ipad) os.ios = os.ipad = true, os.version = ipad[2].replace(/_/g, '.')
	    if (ipod) os.ios = os.ipod = true, os.version = ipod[3] ? ipod[3].replace(/_/g, '.') : null
	    if (wp) os.wp = true, os.version = wp[1]
	    if (webos) os.webos = true, os.version = webos[2]
	    if (touchpad) os.touchpad = true
	    if (blackberry) os.blackberry = true, os.version = blackberry[2]
	    if (bb10) os.bb10 = true, os.version = bb10[2]
	    if (rimtabletos) os.rimtabletos = true, os.version = rimtabletos[2]
	    if (playbook) browser.playbook = true
	    if (kindle) os.kindle = true, os.version = kindle[1]
	    if (silk) browser.silk = true, browser.version = silk[1]
	    if (!silk && os.android && ua.match(/Kindle Fire/)) browser.silk = true
	    if (chrome) browser.chrome = true, browser.version = chrome[1]
	    if (firefox) browser.firefox = true, browser.version = firefox[1]
	    if (firefoxos) os.firefoxos = true, os.version = firefoxos[1]
	    if (ie) browser.ie = true, browser.version = ie[1]
	    if (safari && (osx || os.ios || win)) {
	      browser.safari = true
	      if (!os.ios) browser.version = safari[1]
	    }
	    if (webview) browser.webview = true

	    os.tablet = !!(ipad || playbook || (android && !ua.match(/Mobile/)) ||
	      (firefox && ua.match(/Tablet/)) || (ie && !ua.match(/Phone/) && ua.match(/Touch/)))
	    os.phone  = !!(!os.tablet && !os.ipod && (android || iphone || webos || blackberry || bb10 ||
	      (chrome && ua.match(/Android/)) || (chrome && ua.match(/CriOS\/([\d.]+)/)) ||
	      (firefox && ua.match(/Mobile/)) || (ie && ua.match(/Touch/))))
	  }

	  detect.call($, navigator.userAgent, navigator.platform)
	  // make available to unit tests
	  $.__detect = detect

	})(Zepto)

	;(function($){
	  var touch = {},
	    touchTimeout, tapTimeout, swipeTimeout, longTapTimeout,
	    longTapDelay = 750,
	    gesture

	  function swipeDirection(x1, x2, y1, y2) {
	    return Math.abs(x1 - x2) >=
	      Math.abs(y1 - y2) ? (x1 - x2 > 0 ? 'Left' : 'Right') : (y1 - y2 > 0 ? 'Up' : 'Down')
	  }

	  function longTap() {
	    longTapTimeout = null
	    if (touch.last) {
	      touch.el.trigger('longTap')
	      touch = {}
	    }
	  }

	  function cancelLongTap() {
	    if (longTapTimeout) clearTimeout(longTapTimeout)
	    longTapTimeout = null
	  }

	  function cancelAll() {
	    if (touchTimeout) clearTimeout(touchTimeout)
	    if (tapTimeout) clearTimeout(tapTimeout)
	    if (swipeTimeout) clearTimeout(swipeTimeout)
	    if (longTapTimeout) clearTimeout(longTapTimeout)
	    touchTimeout = tapTimeout = swipeTimeout = longTapTimeout = null
	    touch = {}
	  }

	  function isPrimaryTouch(event){
	    return (event.pointerType == 'touch' ||
	      event.pointerType == event.MSPOINTER_TYPE_TOUCH)
	      && event.isPrimary
	  }

	  function isPointerEventType(e, type){
	    return (e.type == 'pointer'+type ||
	      e.type.toLowerCase() == 'mspointer'+type)
	  }

	  $(document).ready(function(){
	    var now, delta, deltaX = 0, deltaY = 0, firstTouch, _isPointerType

	    if ('MSGesture' in window) {
	      gesture = new MSGesture()
	      gesture.target = document.body
	    }

	    $(document)
	      .bind('MSGestureEnd', function(e){
	        var swipeDirectionFromVelocity =
	          e.velocityX > 1 ? 'Right' : e.velocityX < -1 ? 'Left' : e.velocityY > 1 ? 'Down' : e.velocityY < -1 ? 'Up' : null
	        if (swipeDirectionFromVelocity) {
	          touch.el.trigger('swipe')
	          touch.el.trigger('swipe'+ swipeDirectionFromVelocity)
	        }
	      })
	      // .on('touchstart MSPointerDown pointerdown', function(e){
	      .on('touchstart', function(e){
	        if((_isPointerType = isPointerEventType(e, 'down')) &&
	          !isPrimaryTouch(e)) return
	        firstTouch = _isPointerType ? e : e.touches[0]
	        if (e.touches && e.touches.length === 1 && touch.x2) {
	          // Clear out touch movement data if we have it sticking around
	          // This can occur if touchcancel doesn't fire due to preventDefault, etc.
	          touch.x2 = undefined
	          touch.y2 = undefined
	        }
	        now = Date.now()
	        delta = now - (touch.last || now)
	        touch.el = $('tagName' in firstTouch.target ?
	          firstTouch.target : firstTouch.target.parentNode)
	        touchTimeout && clearTimeout(touchTimeout)
	        touch.x1 = firstTouch.pageX
	        touch.y1 = firstTouch.pageY
	        if (delta > 0 && delta <= 250) touch.isDoubleTap = true
	        touch.last = now
	        longTapTimeout = setTimeout(longTap, longTapDelay)
	        // adds the current touch contact for IE gesture recognition
	        if (gesture && _isPointerType) gesture.addPointer(e.pointerId)
	      })
	      // .on('touchmove MSPointerMove pointermove', function(e){
	      .on('touchmove', function(e){
	        if((_isPointerType = isPointerEventType(e, 'move')) &&
	          !isPrimaryTouch(e)) return
	        firstTouch = _isPointerType ? e : e.touches[0]
	        cancelLongTap()
	        touch.x2 = firstTouch.pageX
	        touch.y2 = firstTouch.pageY

	        deltaX += Math.abs(touch.x1 - touch.x2)
	        deltaY += Math.abs(touch.y1 - touch.y2)
	      })
	      // .on('touchend MSPointerUp pointerup', function(e){
	      .on('touchend', function(e){
	        if((_isPointerType = isPointerEventType(e, 'up')) &&
	          !isPrimaryTouch(e)) return
	        cancelLongTap()

	        // swipe
	        if ((touch.x2 && Math.abs(touch.x1 - touch.x2) > 30) ||
	            (touch.y2 && Math.abs(touch.y1 - touch.y2) > 30))

	          swipeTimeout = setTimeout(function() {
	            if (touch.el){
	              touch.el.trigger('swipe')
	              touch.el.trigger('swipe' + (swipeDirection(touch.x1, touch.x2, touch.y1, touch.y2)))
	            }
	            touch = {}
	          }, 0)

	        // normal tap
	        else if ('last' in touch)
	          // don't fire tap when delta position changed by more than 30 pixels,
	          // for instance when moving to a point and back to origin
	          if (deltaX < 30 && deltaY < 30) {
	            // delay by one tick so we can cancel the 'tap' event if 'scroll' fires
	            // ('tap' fires before 'scroll')
	            tapTimeout = setTimeout(function() {

	              // trigger universal 'tap' with the option to cancelTouch()
	              // (cancelTouch cancels processing of single vs double taps for faster 'tap' response)
	              var event = $.Event('tap')
	              event.cancelTouch = cancelAll
	              // [by paper] fix -> "TypeError: 'undefined' is not an object (evaluating 'touch.el.trigger'), when double tap
	              if (touch.el) touch.el.trigger(event)

	              // trigger double tap immediately
	              if (touch.isDoubleTap) {
	                if (touch.el) touch.el.trigger('doubleTap')
	                touch = {}
	              }

	              // trigger single tap after 250ms of inactivity
	              else {
	                touchTimeout = setTimeout(function(){
	                  touchTimeout = null
	                  if (touch.el) touch.el.trigger('singleTap')
	                  touch = {}
	                }, 250)
	              }
	            }, 0)
	          } else {
	            touch = {}
	          }
	          deltaX = deltaY = 0

	      })
	      // when the browser window loses focus,
	      // for example when a modal dialog is shown,
	      // cancel all ongoing events
	      .on('touchcancel MSPointerCancel pointercancel', cancelAll)

	    // scrolling the window indicates intention of the user
	    // to scroll, not tap or swipe, so cancel all ongoing events
	    $(window).on('scroll', cancelAll)
	  })

	  ;['swipe', 'swipeLeft', 'swipeRight', 'swipeUp', 'swipeDown',
	    'doubleTap', 'tap', 'singleTap', 'longTap'].forEach(function(eventName){
	    $.fn[eventName] = function(callback){ return this.on(eventName, callback) }
	  })
	})(Zepto)

	;(function($){
	  if ($.os.ios) {
	    var gesture = {}, gestureTimeout

	    function parentIfText(node){
	      return 'tagName' in node ? node : node.parentNode
	    }

	    $(document).bind('gesturestart', function(e){
	      var now = Date.now(), delta = now - (gesture.last || now)
	      gesture.target = parentIfText(e.target)
	      gestureTimeout && clearTimeout(gestureTimeout)
	      gesture.e1 = e.scale
	      gesture.last = now
	    }).bind('gesturechange', function(e){
	      gesture.e2 = e.scale
	    }).bind('gestureend', function(e){
	      if (gesture.e2 > 0) {
	        Math.abs(gesture.e1 - gesture.e2) != 0 && $(gesture.target).trigger('pinch') &&
	          $(gesture.target).trigger('pinch' + (gesture.e1 - gesture.e2 > 0 ? 'In' : 'Out'))
	        gesture.e1 = gesture.e2 = gesture.last = 0
	      } else if ('last' in gesture) {
	        gesture = {}
	      }
	    })

	    ;['pinch', 'pinchIn', 'pinchOut'].forEach(function(m){
	      $.fn[m] = function(callback){ return this.bind(m, callback) }
	    })
	  }
	})(Zepto)
	module.exports = Zepto;

/***/ },
/* 226 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
		value: true
	});

	var _tips = __webpack_require__(227);

	var _tips2 = _interopRequireDefault(_tips);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	exports.default = {
		tips: _tips2.default.trim()
	};
	module.exports = exports['default'];

/***/ },
/* 227 */
/***/ function(module, exports) {

	module.exports = "<div id=\"intelligent-tips\">\n\t<div id=\"header\">\n\t\t<div id=\"header-container\">\n\t\t\t<div id=\"body-bar\">\n\t\t\t\t<img  src=\"./images/left-bar.png\"/>\n\t\t\t</div>\n\t\t\t<div class=\"tab\" id=\"tab-open\">\n\t\t\t\t<img src=\"./images/tab-open.png\"/>\n\t\t\t\t<div class=\"inlib pointer\" id=\"open-bar\"></div>\t\n\t\t\t</div>\t\n\t\t\t<div class=\"tab\" id=\"tab-close\">\n\t\t\t\t<img src=\"./images/tab-close.png\"/>\n\t\t\t\t<div class=\"inlib pointer\" id=\"close-bar\"></div>\n\t\t\t</div>\t\t\t\t\n\t\t</div>\t\n\t</div>\n\t<div id=\"body\">\n\t\t<div id=\"container\">\n\t\t\t<div id=\"empty\">\n\t\t\t\t<span class=\"icon-message2 icon\">&#xe6bc;</span>\n\t\t\t\t<span class=\"word\">当前没有推荐回复</span>\n\t\t\t</div>\t\n\t\t\t<div id=\"loading\">\n\t\t\t\t<span id=\"inner\"><img class=\"icon\" src=\"./images/loading.gif\"/></span>\n\t\t\t</div>\n\t\t\t<div id=\"content\">\n\t\t\t</div>\n\t\t</div>   \t\n\t\t<div id=\"tooltip\"><img class=\"background\" src=\"./images/tooltip.png\"/>\n\t\t    <div class=\"word inlib\"><span>热键冲突，请调整设置。<span class=\"inlib button pointer\" id=\"shortcuts-button\">去设置></span></span>\n\t\t    </div>\n\t\t</div>\t\t\t\t\t\t\t\t\t\n\t</div>\t\n</div>\n\n";

/***/ },
/* 228 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ },
/* 229 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	__webpack_require__(230);

	__webpack_require__(231);

	__webpack_require__(232);

	__webpack_require__(233);

	__webpack_require__(234);

/***/ },
/* 230 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Action = _$ChatRoot2.default.Action,
	    Event = _$ChatRoot2.default.Event;


	Action.getRemoteHistoryMsg.after(function (context, data) {
		console.warn('getRemoteHistoryMsg', data);
		data && data.list && data.list.length && Event.emit('get_remote_history_msg', data.list[data.list.length - 1]);
	});

/***/ },
/* 231 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Action = _$ChatRoot2.default.Action,
	    Event = _$ChatRoot2.default.Event;


	Action.getNewMsg.after(function (context, data) {
		console.warn('getNewMsg', data);
		data && data.list && data.list.msgs && data.list.msgs.length && Event.emit('get_new_msg', data.list.msgs[data.list.msgs.length - 1]);
	});

/***/ },
/* 232 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Action = _$ChatRoot2.default.Action,
	    Event = _$ChatRoot2.default.Event;


	Action.receiveMsg.after(function (context, data) {
		console.warn('receiveMsg', data);
		data && data.list && data.list.msgs && data.list.msgs.length && Event.emit('receive_msg', data.list.msgs[data.list.msgs.length - 1]);
	});

/***/ },
/* 233 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var Action = _$ChatRoot2.default.Action,
	    Event = _$ChatRoot2.default.Event;


	Action.getSentMsg.after(function (context, data) {
		console.warn('getSentMsg', data);
		data && data.list && data.list.msgs && data.list.msgs.length && Event.emit('get_send_msg', data.list.msgs[data.list.msgs.length - 1]);
	});

/***/ },
/* 234 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$ConvertRoot = __webpack_require__(202);

	var _$ConvertRoot2 = _interopRequireDefault(_$ConvertRoot);

	var _$ChatRoot = __webpack_require__(5);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	console.log(_$ConvertRoot2.default);

	var Convert = _$ConvertRoot2.default.Convert;

	var timeout = null;

	Convert.pushInjectNormalFormat(function (msg, result) {
		if (msg && !msg.isSelf && result && result.typeList && result.typeList.length) {
			var len = result.typeList.length;

			for (var i = 0; i < len; i++) {
				if (result.typeList[i].type === 'link') {
					clearTimeout(timeout);
					timeout = setTimeout(function () {
						_$ChatRoot.Event.emit('LINK_MSG', msg);
					}, 100);
				}
			}
		}
	});

/***/ },
/* 235 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	__webpack_require__(236);

	__webpack_require__(238);

	__webpack_require__(239);

	__webpack_require__(240);

	var _getCommonConfig = __webpack_require__(241);

	var _getCommonConfig2 = _interopRequireDefault(_getCommonConfig);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	// 不去更新/显示单聊已读未读消息, 如有需要显示时,去掉一下引用就好了
	// import './getMsgReadStatus';
	// import './updateMsgReadStatus';

	exports.default = {
	  getCommonConfig: _getCommonConfig2.default
	}; /**
	    * Created by neitherzhu on 2016/12/12.
	    */

/***/ },
/* 236 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	var _$JuicerRoot = __webpack_require__(37);

	var _$JuicerRoot2 = _interopRequireDefault(_$JuicerRoot);

	var _$IMSDKRoot = __webpack_require__(2);

	var _$IMSDKRoot2 = _interopRequireDefault(_$IMSDKRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _util = __webpack_require__(237);

	var _util2 = _interopRequireDefault(_util);

	var _index = __webpack_require__(235);

	var _index2 = _interopRequireDefault(_index);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/12.
	 * 绑定事件
	 */
	var Cache = _$BaseRoot.Base.Cache;
	var Action = _$ChatRoot2.default.Action,
	    Win = _$ChatRoot2.default.Win,
	    Constant = _$ChatRoot2.default.Constant,
	    SDK = _$ChatRoot2.default.SDK;


	Action.bindEvents.before(function () {
	    _$JuicerRoot2.default.register('dateFormatter', _util2.default.dateFormatter);
	    _index2.default.getCommonConfig.action();
	});

	Action.bindEvents.before(function () {

	    /**
	     * 漫游成功事件
	     */
	    _$IMSDKRoot2.default.on('ON_AUTO_ROAM_SUCCESS', function () {
	        if (Win.conversationID.type === Constant.Other.TYPE.SINGLE) {
	            console.info('ON_AUTO_ROAM_SUCCESS');
	            var current = Object.assign({}, Win.conversationID);

	            Action.conversationClose.action({
	                cid: current
	            });
	            Action.conversationChange.action(current);
	        }
	    });

	    /**
	     * 收到撤回功能开/关事件
	     */
	    _$IMSDKRoot2.default.on('im.bizutil.onWithdrawEnable', function (data) {
	        Win.container.classList[data.enable == 1 ? 'add' : 'remove'](Constant.CLS.SHOW_MSG_MENU);
	    });

	    /**
	     * 收到显示已读未读功能开/关事件
	     */
	    _$IMSDKRoot2.default.on('im.bizutil.onPeerReadedEnable', function (data) {
	        Win.container.classList[data.enable == 1 ? 'add' : 'remove'](Constant.CLS.SHOW_READ_STATUS);
	    });

	    // 聊天消息合并配置修改事件
	    _$IMSDKRoot2.default.on('im.bizutil.onChatMsgMergeOptionChange', function (data) {
	        var isMerge = Cache.get('settings').isMerge;

	        if (isMerge == data.merge) return;

	        Win.container.classList[data.merge ? 'add' : 'remove']('msg-merge-wrap');

	        Cache.set('settings', { isMerge: data.merge });
	    });

	    // 聊天消息合并配置修改事件
	    _$IMSDKRoot2.default.on('im.bizutil.onChatMsgDisplayModeChange', function (data) {

	        var isBubble = Cache.get('settings').isBubble;

	        if (data.mode === 1 && isBubble) return;

	        Win.container.classList[data.mode == 0 ? 'add' : 'remove']('imui-msg-normal-wrap');
	        Cache.set('settings', { isBubble: data.mode === 1 });
	    });

	    // todo 联系人头像变更

	    // todo 联系人显示名变更


	    // 右键菜单
	    document.body.addEventListener('contextmenu', function (ev) {
	        ev.preventDefault();

	        var target = ev.target;
	        var selection_text = workbench.im.get_selection_text();
	        var type = Win.conversationID.type == Constant.Other.TYPE.SINGLE ? 0 : 2;
	        var uitype = { type: type, jvale: JSON.stringify(Win.conversationID) };
	        var itemType = 0;
	        var jvale = '';
	        var parent = void 0;

	        // 1. 是图片元素
	        // 2. 有src
	        // xx 3. src中不带imemotion,即表情
	        // 4. src不是当前页面的地址
	        // 5. 不是头像
	        var hit_pic = target.tagName.toUpperCase() === 'IMG' && !!target.src && target.src !== location.href && !target.classList.contains('user-avatar');

	        // 点击在user上
	        // 1. 点击的是头像
	        // 2. 点击的是名字
	        if (target.classList.contains('imui-msg-avatar') || target.classList.contains('imui-msg-sender')) {
	            // 获取消息父元素,获得appkey与nick
	            parent = _util2.default.parents(target, 'J_msg');

	            var p = {};
	            var uid = { appkey: parent.getAttribute('data-appkey'),
	                nick: parent.getAttribute('data-nick'),
	                numberid: parent.getAttribute('data-numberid') };

	            // 如果是单聊
	            if (type == 0) {
	                itemType = 1;
	                p.userid = uid;
	            } else {
	                itemType = 3;
	                p.memberid = uid;
	                p.tribeid = Win.conversationID.tribeid;
	            }
	            jvale = JSON.stringify(p);
	        } else if (hit_pic) {
	            // 点在表情上
	            if (target.src.indexOf('pic:imemotion') !== -1) {
	                itemType = 9;
	                jvale = JSON.stringify({
	                    filepath: target.src,
	                    value: target.src,
	                    isurl: 0
	                });
	            }
	            // 点在Emoji上
	            else if (target.src.indexOf('pic:imemoji') !== -1) {
	                    itemType = 10;
	                    jvale = JSON.stringify({
	                        filepath: target.src,
	                        value: target.src,
	                        isurl: 0
	                    });
	                }
	                // 点在图片上
	                else {
	                        itemType = 6;
	                        jvale = JSON.stringify({
	                            filepath: target.src,
	                            fileMD5: target.getAttribute('data-md5'),
	                            filetype: target.getAttribute('data-type'),
	                            isurl: 0
	                        });
	                    }
	        }
	        // 点在语音上
	        else if (target.classList.contains('imui-msg-audio')) {
	                itemType = 7;
	                var doNotShow = Win.container.classList.contains('show-audio-text') || target.parentNode.classList.contains('show-audio-text');
	                jvale = JSON.stringify({
	                    filepath: target.getAttribute('data-path'),
	                    fileMD5: target.getAttribute('data-md5'),
	                    filetype: target.getAttribute('data-type'),
	                    id: target.id,
	                    needShow: !doNotShow,
	                    isurl: 0
	                });
	            }
	            // 点在视频上
	            else if (target.tagName.toUpperCase() === 'VIDEO') {
	                    itemType = 8;
	                    jvale = JSON.stringify({
	                        filepath: target.src,
	                        isurl: 1
	                    });
	                }
	                // 点在链接上
	                else if (target.tagName.toUpperCase() === 'A' && target.classList.contains('imui-msg-link')) {
	                        itemType = 12;
	                        jvale = JSON.stringify({
	                            text: target.innerText,
	                            html: target.innerHTML,
	                            link: target.href
	                        });
	                    }
	                    // 点在宝贝快照上
	                    else if (_util2.default.parents(target, 'im-item-snap')) {
	                            itemType = 11;
	                        }
	                        // 点在消息上
	                        else if (parent = _util2.default.parents(target, 'msg-body-html')) {

	                                parent = _util2.default.parents(target, 'J_msg');

	                                if (type == 0) {
	                                    itemType = 4;
	                                } else {
	                                    itemType = 5;
	                                }

	                                jvale = JSON.stringify({
	                                    cid: Win.conversationID,
	                                    msgid: parent.id
	                                });
	                            }

	        var param = {
	            uitype: uitype,
	            hititem: { type: itemType, jvalue: jvale },
	            hit_x: ev.screenX,
	            hit_y: ev.screenY,
	            selecttext: selection_text,
	            cid: Win.conversationID,
	            time: target.getAttribute('data-time')
	        };

	        SDK.contextMenu(param).then(function (data) {
	            if (!data) return;

	            // 清屏
	            if (data.action == 3) {
	                var _uid = _util2.default.getUid(Win.conversationID);
	                var cache = Cache.get(_uid);

	                if (!cache.messageManager) return;

	                Cache.set(_uid, {
	                    hasNextPage: false
	                });
	                cache.messageManager.clear();

	                Win.container.innerHTML = '';
	            } else if (data.action == 18) {
	                var _jvale = JSON.parse(data.jvalue);
	                var item = JSON.parse(_jvale.hititem.jvalue);
	                var id = item.id;
	                var audio = document.getElementById(id);

	                if (!audio) return;

	                audio.parentNode.classList.add('show-audio-text');
	            }
	        });
	    });
	});

/***/ },
/* 237 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	  value: true
	});

	var _$BaseRoot = __webpack_require__(3);

	var Util = _$BaseRoot.Base.Util; /**
	                                  * Created by neitherzhu on 2017/2/6.
	                                  */

	Util.dateFormatter = function (ms) {
	  ms = parseInt(ms, 10);

	  return new Date(ms).__getFormatFullDate();
	};

	exports.default = Util;

/***/ },
/* 238 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _$ConvertRoot = __webpack_require__(202);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var SINGLE_IMAGE_TOOL_BOX_BTN_LIST = [{
	  text: '添加表情',
	  action: 'im.uiutil.AddAsEmotion',
	  cls: 'emot-icon'
	}, {
	  text: '保存图片',
	  action: 'im.uiutil.PicSaveAs',
	  cls: 'save-icon'
	}, {
	  text: '编辑图片',
	  action: 'im.singlemsg.EditPic2SendMsg',
	  cls: 'edit-icon'
	}]; /**
	     * Created by neitherzhu on 2016/12/14.
	     */
	var Action = _$ChatRoot2.default.Action,
	    Constant = _$ChatRoot2.default.Constant;


	Action.conversationChange.after(function (context, data) {

	  if (data && data.type && data.type === Constant.Other.TYPE.SINGLE) {
	    var imageToolBox = _$ConvertRoot.Plugin.getPlugin('imageToolBox');

	    imageToolBox && imageToolBox.setBtnList(SINGLE_IMAGE_TOOL_BOX_BTN_LIST);
	  }
	});

/***/ },
/* 239 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	var _$BaseRoot = __webpack_require__(3);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/19.
	 */
	var Cache = _$BaseRoot.Base.Cache,
	    Util = _$BaseRoot.Base.Util,
	    Log = _$BaseRoot.Base.Log;
	var Action = _$ChatRoot2.default.Action,
	    SDK = _$ChatRoot2.default.SDK,
	    Win = _$ChatRoot2.default.Win;


	Action.getCurrentLoginID.spliceAfter(1, 0, function (context, data) {
	  var uid = Util.getUid(Win.loginID);

	  window.__WPO && __WPO.setConfig({
	    spmId: 'qn.recent',
	    nick: uid
	  });

	  Log.setNick && Log.setNick(uid);
	});

	Action.getCurrentLoginID.after(function (context, data) {

	  SDK.getMsgMergeStatus().then(function (data) {
	    var isMerge = !!data.result.merge;
	    Cache.set('settings', {
	      isMerge: isMerge
	    });

	    !isMerge && Win.container.classList.remove('msg-merge-wrap');
	  });

	  SDK.getMsgMode().then(function (data) {
	    // 获取消息显示模式配置项
	    var isBubble = data.result.mode == 1;
	    Cache.set('settings', {
	      isBubble: isBubble
	    });

	    isBubble && Win.container.classList.remove('imui-msg-normal-wrap');
	  });
	});

/***/ },
/* 240 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	var _$BaseRoot = __webpack_require__(3);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	/**
	 * Created by neitherzhu on 2016/12/30.
	 */
	var Action = _$ChatRoot2.default.Action,
	    Constant = _$ChatRoot2.default.Constant,
	    Win = _$ChatRoot2.default.Win;


	Action.getMoreHistoryMsg.before(function (context, data) {
	  var div = document.createElement('div');
	  div.className = 'msg-loading';
	  div.id = 'J_msgLoading';

	  Win.container.appendChild(div);
	});

	Action.getMoreHistoryMsg.after(function (context, data) {

	  var loading = document.getElementById('J_msgLoading');
	  loading && loading.parentNode.removeChild(loading);
	});

	var NativeError = Action.getMoreHistoryMsg.error;
	Action.getMoreHistoryMsg.error = function () {
	  var args = Array.prototype.slice.call(arguments);
	  NativeError.apply(Action.getMoreHistoryMsg, args);

	  var loading = document.getElementById('J_msgLoading');
	  loading && loading.parentNode.removeChild(loading);
	};

/***/ },
/* 241 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	Object.defineProperty(exports, "__esModule", {
	    value: true
	});

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	var _$BaseRoot = __webpack_require__(3);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var SDK = _$ChatRoot2.default.SDK,
	    Win = _$ChatRoot2.default.Win,
	    Constant = _$ChatRoot2.default.Constant;

	var getCommonConfig = new _$BaseRoot.Base.ActionCreator();

	getCommonConfig.actionType = 'async';

	getCommonConfig.doAsync = function (context) {
	    return new Promise(function (resolve, reject) {
	        SDK.getCommonConfig().then(function (data) {
	            if (!data || !data.result) return;

	            if (data.result.enable_peerreaded == 1) {
	                Win.container.classList.add(Constant.CLS.SHOW_READ_STATUS);
	            }

	            if (data.result.enable_withdraw === 1) {
	                Win.container.classList.add(Constant.CLS.SHOW_MSG_MENU);
	            }

	            if (data.result.MSG_READ_OPEN_TIME && data.result.MSG_READ_OPEN_TIME !== '0') {
	                Win.msgReadOpenTime = parseInt(data.result.MSG_READ_OPEN_TIME);
	            }
	        });
	    });
	};

	exports.default = getCommonConfig;

/***/ },
/* 242 */
/***/ function(module, exports, __webpack_require__) {

	'use strict';

	var _$ChatRoot = __webpack_require__(5);

	var _$ChatRoot2 = _interopRequireDefault(_$ChatRoot);

	var _$BaseRoot = __webpack_require__(3);

	var _$ConvertRoot = __webpack_require__(202);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

	var singleMsgTypes = _$ConvertRoot.Convert.getMsgTypesByName('chat', 'normalMsg'); /**
	                                                                                    * Created by neitherzhu on 2016/12/15.
	                                                                                    */

	var tribeMsgTypes = _$ConvertRoot.Convert.getMsgTypesByName('tribe', 'normalMsg');
	_$ConvertRoot.Convert.update('chat', singleMsgTypes, 'normalMsg', {
	    Tpl: _$ConvertRoot.Template.normalMsg
	});

	_$ConvertRoot.Convert.update('chat', 1, 'autoReplyMsg', {
	    Tpl: _$ConvertRoot.Template.normalMsg
	});

	_$ConvertRoot.Convert.update('tribe', tribeMsgTypes, 'normalMsg', {
	    Tpl: _$ConvertRoot.Template.normalMsg
	});

	_$ConvertRoot.Convert.pushInjectNormalFormat(function (msg, result) {

	    if (!result) return;

	    result.fold = msg.fold;
	    result.fromRobot = msg.msgtype == 12;

	    if (result.menu) {
	        result.menu = JSON.parse(result.menu);
	        delete result.menu.canForward;
	        result.menu = JSON.stringify(result.menu);
	    }
	});

	_$ConvertRoot.Convert.update('chat', 16, 'facetime', {
	    Tpl: _$ConvertRoot.Template.normalMsg
	});

/***/ },
/* 243 */
/***/ function(module, exports) {

	// removed by extract-text-webpack-plugin

/***/ }
])
});
;
