webpackJsonp([3],[
/* 0 */
/***/ (function(module, exports) {

module.exports = React;

/***/ }),
/* 1 */
/***/ (function(module, exports) {

module.exports = ReactDOM;

/***/ }),
/* 2 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = getURLParameter;

function getURLParameter(name) {
   return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search) || [null, ''])[1].replace(/\+/g, '%20')) || null;
}

/***/ }),
/* 3 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__apimap__ = __webpack_require__(8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__dataFmt__ = __webpack_require__(9);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ali_im_sdk__ = __webpack_require__(7);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__ali_im_sdk___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2__ali_im_sdk__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__alife_reqwest__ = __webpack_require__(11);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__alife_reqwest___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3__alife_reqwest__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__utils_js__ = __webpack_require__(5);
/**
 * adapter.js
 * @desc data request adapter service
 * @author huazhi.chz
 */






var __WPO = window.__WPO;
var ENV = __WEBPACK_IMPORTED_MODULE_0__apimap__["a" /* default */].__ENV;

/**
 * 客户端方法统一入口
 * @param  {string} fn
 * @param  {object}   param
 * @return {Promise}
 */
var nativeInvoke = function nativeInvoke(fn, param) {
    console.log(fn, param);
    return new Promise(function (resolve, reject) {
        var _begin = Date.now();
        __WEBPACK_IMPORTED_MODULE_4__utils_js__["a" /* default */].log.debug('CALL: ' + fn, param);
        __WEBPACK_IMPORTED_MODULE_2__ali_im_sdk___default.a.invoke(fn, param).then(function (result) {
            var _time = Date.now() - _begin;
            __WEBPACK_IMPORTED_MODULE_4__utils_js__["a" /* default */].log.info(fn, result, param, _time);
            resolve(result);
        })['catch'](function (error) {
            var _time = Date.now() - _begin;
            __WEBPACK_IMPORTED_MODULE_4__utils_js__["a" /* default */].log.error(fn, error, param, _time);
            reject(error);
        });
    });
};

// imsdk invoke，返回的数据额外包了一层result
var imsdkInvoke = function imsdkInvoke(fn, param) {
    return nativeInvoke(fn, param).then(function (result) {
        return result.result;
    });
};

var adapter = {
    __native: nativeInvoke,

    /**
     * invoke method
     * @param  {object} config
     * @property {string} config.api
     * @property {*} [config.param] 同config.query, config.data
     * @property {string|function} [config.dataFmt] dataformatter
     * @property {string} [config.method]
     * @property {object} [config.extraSettings] 额外的参数
     * @return {Promise}
     */
    invoke: function invoke(config) {
        config.param = config.param || config.query || config.data || {};
        // 实际接口信息，如果不在api列表，则默认为imsdk接口
        var fn = __WEBPACK_IMPORTED_MODULE_0__apimap__["a" /* default */][config.api] || { type: (config.type || 'imsdk').toUpperCase(), v: config.api };
        // 数据格式化方法
        if (typeof config.dataFmt !== 'function') {
            config.dataFmt = __WEBPACK_IMPORTED_MODULE_1__dataFmt__[config.dataFmt] || function (x) {
                return x;
            };
        }

        var _promise = void 0;
        switch (fn.type) {
            case 'IMSDK':
                _promise = window.workbench ? imsdkInvoke(fn.v, config.param) : Promise.reject('Must in wangwang client!');
                break;
            default:
                _promise = Promise.reject('\u672A\u77E5\u7684api\u7C7B\u578B: ' + fn.type);
                break;
        }
        return _promise.then(function (result) {
            return config.dataFmt(result, config.param);
        });
    }
};

/* harmony default export */ __webpack_exports__["a"] = (adapter);

/***/ }),
/* 4 */,
/* 5 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export toast */
/* unused harmony export log */
/* unused harmony export takeoff */
/* unused harmony export registerCacher */
/* unused harmony export getCache */
/* unused harmony export money */
/* unused harmony export time */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__const__ = __webpack_require__(6);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__ali_sj_util__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__ali_sj_util___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1__ali_sj_util__);
var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/**
 * @file: util.js
 * @desc: biz util
 * @author: huazhi.chz
 *
 */




/**
 * 轻提示
 * @param {object|string} options 如果是string，则为options.text
 * @param {string} [options.text] 提示文字
 * @param {number} [options.during] 持续时间
 * @param {string} [options.type] 提醒类型 WARN|SUCCESS|ERROR
 * @param {number} [during] 持续时间
 * @param {string} [type] 提醒类型 WARN|SUCCESS|ERROR
 */
var toast = function () {
    var TOAST_TYPE = {
        'WARN': 'toast-warn',
        'SUCCESS': 'toast-success',
        'ERROR': 'toast-error'
    };

    var toastTimeout = void 0;

    return function (options, during, type) {
        (typeof options === 'undefined' ? 'undefined' : _typeof(options)) !== 'object' && (options = { text: options });
        typeof during === 'number' && (options.during = during);
        typeof type === 'string' && (options.type = type);
        typeof during === 'string' && (options.type = during);
        var _box = document.querySelector('.x-toast-box.fade-in-down');
        if (!_box) {
            _box = document.createElement('div');
            _box.className = 'x-toast-box qt-layer fade-in-down ' + (TOAST_TYPE[options.type] || TOAST_TYPE['WARN']);
            _box.innerHTML = '<i></i><span class="toast-text">' + options.text + '</span>';
            document.body.appendChild(_box);
        } else {
            var _box$classList;

            clearTimeout(toastTimeout);
            (_box$classList = _box.classList).remove.apply(_box$classList, ['toast-warn', 'toast-success', 'toast-error']);
            _box.classList.add(TOAST_TYPE[options.type] || TOAST_TYPE['WARN']);
            _box.querySelector('.toast-text').innerHTML = options.text;
        }
        toastTimeout = setTimeout(function () {
            _box.classList.remove('fade-in-down');
            _box.classList.add('fade-out-down');
            _box.addEventListener('webkitAnimationEnd', function (e) {
                document.body.removeChild(_box);
            });
        }, options.during || 1800);
    };
}();

// app logger
var log = {
    error: function error() {
        var _console;

        for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
            args[_key] = arguments[_key];
        }

        __WEBPACK_IMPORTED_MODULE_0__const__["a" /* default */].LOG_SETTING.ERROR && (_console = console).log.apply(_console, ['%c[ERROR]', 'font-weight:bold;color:red;'].concat(args));
    },
    warn: function warn() {
        var _console2;

        for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
            args[_key2] = arguments[_key2];
        }

        __WEBPACK_IMPORTED_MODULE_0__const__["a" /* default */].LOG_SETTING.WARN && (_console2 = console).log.apply(_console2, ['%c[WARN]', 'font-weight:bold;color:orange;'].concat(args));
    },
    info: function info() {
        var _console3;

        for (var _len3 = arguments.length, args = Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
            args[_key3] = arguments[_key3];
        }

        __WEBPACK_IMPORTED_MODULE_0__const__["a" /* default */].LOG_SETTING.INFO && (_console3 = console).log.apply(_console3, ['%c[INFO]', 'font-weight:bold;color:#06AFAF;'].concat(args));
    },
    debug: function debug() {
        var _console4;

        for (var _len4 = arguments.length, args = Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
            args[_key4] = arguments[_key4];
        }

        __WEBPACK_IMPORTED_MODULE_0__const__["a" /* default */].LOG_SETTING.DEBUG && (_console4 = console).log.apply(_console4, ['%c[DEBUG]', 'font-weight:bold;color:#999;'].concat(args));
    },
    line: function line() {
        var _console5;

        __WEBPACK_IMPORTED_MODULE_0__const__["a" /* default */].LOG_SETTING.DEBUG && console.log('%c[-----------LINE-----------]', 'font-size:16px;color:magenta;');
        __WEBPACK_IMPORTED_MODULE_0__const__["a" /* default */].LOG_SETTING.DEBUG && (_console5 = console).log.apply(_console5, arguments);
    }
};

/**
 * 脱衣服
 * @param {object} obj
 * @param {string} clothes
 * @return {*}
 * @example
 * util.takeoff(obj, 'a.b.c.d');
 */
var takeoff = function takeoff(obj, clothes) {
    if (!obj || !clothes) return obj;
    clothes = clothes.split('.');
    clothes.some(function (x) {
        obj = obj[x];
        if (!obj) return true;
    });
    return obj;
};

var CACHE = {};

/**
 * 注册一个带缓存和锁的方法
 * @param  {Promise} promise
 * @param  {string} [key]
 * @return {function}
 */
var registerCacher = function registerCacher(promise, key) {
    key = key || __WEBPACK_IMPORTED_MODULE_1__ali_sj_util___default.a.uuid();
    var queue = [];
    var isLocked = false;

    return function (forceUpdate) {
        return new Promise(function (resolve) {
            if (!forceUpdate && CACHE[key]) return resolve(CACHE[key]);
            if (isLocked) {
                log.debug('METHOD LOCKED, PENDING...');
                return queue.push(resolve);
            }

            isLocked = true;
            promise().then(function (result) {
                CACHE[key] = result;
                resolve(CACHE[key]);
                return CACHE[key];
            })['catch'](function (error) {
                resolve(null);
                return null;
            }).then(function (data) {
                isLocked = false;
                queue.forEach(function (r) {
                    return r(data);
                });
                queue.length = 0;
            });
        });
    };
};

var getCache = function getCache(key) {
    return CACHE[key];
};

var money = function money(amount) {
    if (!amount) return 0;
    amount = amount / 100 || 0;
    return amount.toFixed(2);
};

var time = function time(seconds) {
    var h = Math.floor(seconds / 3600); // 小时
    var m = Math.floor((seconds - h * 3600) / 60); // 分钟
    var s = seconds - h * 3600 - m * 60;

    if (h) return h + '\u5C0F\u65F6' + m + '\u5206' + s + '\u79D2';
    if (m) return m + '\u5206' + s + '\u79D2';
    return s + '\u79D2';
};

/* harmony default export */ __webpack_exports__["a"] = (Object.assign({}, __WEBPACK_IMPORTED_MODULE_1__ali_sj_util___default.a, {
    takeoff: takeoff,
    log: log,
    toast: toast,
    registerCacher: registerCacher,
    getCache: getCache,
    money: money,
    time: time
}));

/***/ }),
/* 6 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export ENV */
/* unused harmony export ORIGIN */
/* unused harmony export LOG_SETTING */
/* unused harmony export KEY_CODE */
/* unused harmony export STATUS_MAP */
/* unused harmony export DISPLAY_STATUS */
/* unused harmony export HONGBAO_TYPE */
/* unused harmony export ONE_DAY */
/**
 * index.js
 * @desc constant
 * @author huazhi.chz
 */

var isTest = /local|remote|daily|wapp|debug|((\d+\.){3}\d+)/.test(location.host);
var isDebug = !!localStorage.getItem('WW_DEBUG');
// 0 daily, 1 online
var ENV = isTest && !/(online=1)|(pre=1)/.test(location.search) ? 0 : 1;
// 本地mock域名
var ORIGIN = location.origin || location.protocol + '//' + location.host;

// 日志级别
var LOG_SETTING = {
    ERROR: true,
    WARN: true,
    INFO: isTest || isDebug,
    DEBUG: isTest || isDebug
};

window.DEBUG = isTest || isDebug;

var KEY_CODE = {
    ENTER: 13,
    SHIFT: 16,
    ESC: 27,
    LEFT: 37,
    UP: 38,
    RIGHT: 39,
    DOWN: 40
};

var STATUS_MAP = {
    PENDING: -100, // 加载中
    UNOPEN: 1, // 未打开，可抢
    OPENING: -101, // 打开中
    OPENED: 2, // 已抢到
    EMPTY: 3, // 未抢到，已经抢完了
    EXPIRED: 4, // 已过期
    FAILED: 5, // 打开失败
    FORBIDDEN: 0, // 无权限
    ERROR: -109 // 数据加载失败
};

// 红包本身的状态 1: 已拆分, 2: 可抢, 3: 过期, 4: 抢完
var DISPLAY_STATUS = {
    SPLITED: 1,
    ENABLE: 2,
    EXPIRED: 3,
    EMPTY: 4
};

// 红包类型
var HONGBAO_TYPE = {
    SINGLE: '0', // 个人红包
    GROUP: '1', // 普通群红包
    LUCKY: '2' // 拼手气红包
};

var ONE_DAY = 24 * 60 * 60 * 1000;

/* harmony default export */ __webpack_exports__["a"] = ({
    ENV: ENV,
    ORIGIN: ORIGIN,
    LOG_SETTING: LOG_SETTING,
    KEY_CODE: KEY_CODE,
    ONE_DAY: ONE_DAY,
    STATUS_MAP: STATUS_MAP,
    DISPLAY_STATUS: DISPLAY_STATUS,
    HONGBAO_TYPE: HONGBAO_TYPE
});

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_RESULT__;/**
 * ----------------------------------
 * @file: @ali/im.sdk
 * @desc: 旺旺SDK
 * @license MIT License
 * ----------------------------------
 */

!(function(global, factory) {
    'use strict';
    if (true) {
        !(__WEBPACK_AMD_DEFINE_RESULT__ = function() {
            return factory(global)
        }.call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else if (typeof exports === 'object') {
        module.exports = factory(global);
    } else {
        global.imsdk = factory(global);
    }
})(window, function(global) {
    'use strict';

    // 调试模式
    var IS_DEBUG = (global.location && location.href && /debug=true/i.test(location.href)) || (global.localStorage && !!localStorage.getItem('WW_DEBUG'));

    // 普通日志
    var _log = function() {
        if ((IS_DEBUG || global.DEBUG) && global.console) {
            console.log.apply(console, Array.prototype.slice.apply(arguments));
        }
    };

    // 错误日志
    var _errorLog = function () {
        global.console && console.log.apply(console, Array.prototype.slice.apply(arguments));
    }

    // 是否是在imsdk容器中，非imsdk容器中的部分方法或参数有区别
    var _isInIMSDKClient = /WW_IMSDK/i.test(navigator.userAgent);

    /*--------------------------  TASK  ----------------------------*/

    var TASK_CACHE = {};

    function Task(namespace, config) {
        this.id = workbench.createSequenceId();
        this.namespace = namespace;
        this.config = config || {};
        this.cmd = this.config.cmd;
        this.param = this.config.param || '';

        if (this.param && this.param.__other) {
            this.other = this.param.__other;
            delete this.param.__other;
        }

        TASK_CACHE[this.id] = this;
    }

    Task.prototype = {
        constructor: Task,

        bindCallback: function(name, callback) {
            var that = this;

            this[name] = function(result) {
                clearTimeout(that.timmer);
                callback.call(that, result, that.cmd, that.param);

                // 在当前任务上加一个已销毁的标记，8秒之后再销毁
                that.destroyed = true;
                setTimeout(function () {delete TASK_CACHE[that.id]}, 8000)
            };

            return this;
        },

        success: function(callback) {
            if (!callback || (!typeof callback === 'function')) return this;

            this.bindCallback('onSuccess', callback);

            return this;
        },

        failure: function(callback) {
            if (!callback || (!typeof callback === 'function')) return this;

            this.bindCallback('onFailure', callback);

            return this;
        },

        timeout: function(time) {
            var that = this;
            time = parseInt(time);

            time && (this.timmer = setTimeout(function() {
                that.onFailure && that.onFailure({ret: 'TIMEOUT'});
            }, time));

            return this;
        },

        run: function() {
            var param = this.param;
            if (typeof param !== 'string') {
                try {
                    param = JSON.stringify(param);
                } catch (err) {
                    param = '';
                }
            }

            try {
                if (!this.other) {
                    this.namespace.invoke(this.id, this.cmd, param);
                } else {
                    this.namespace.invoke(this.id, this.cmd, param, this.other);
                }
            } catch (err) {
                _errorLog('%cError in Task.run: ' + this.cmd, 'color:red', err);
            }

            return this;
        },

        request: function (requestMethod) {
            requestMethod = requestMethod || 'CommitHttpRequest';
            var options = {
                url: this.config.url,
                method: this.config.method || 'get',
                param: this.param
            };

            options = JSON.stringify(options);
            try {
                workbench.httprequest.invoke(this.id, requestMethod, options);
            } catch (err) {
                _errorLog('%cError in Task.request: ' + this.config.url, 'color:red', err);
            }
            return this;
        }
    };

    /*--------------------------  SDK  ----------------------------*/

    var SDK = {};

    /**
     * 调用客户端方法
     * @param   {String}      fn              方法名
     * @param   {Object}      config          配置项
     * @param   {Object}      config.param    客户端方法的入参
     * @param   {Function}    config.success  成功的回调
     * @param   {Function}    config.failure  失败的回调
     * @param   {Number}      config.timeout  超时时间
     * @return  {Object}      SDK
     * @example
     * SDK.invoke('util.GetUserNick', {
     *     param: {uid: 'uid'},
     *     success: function() {},
     *     failure: function() {},
     *     timeout: 5000,
     * });
     */
    SDK.invoke = function(fn, config) {
        if (typeof fn !== 'string') {
            return _errorLog('%cError in SDK.invoke: fn must be string', 'color:red', fn);
        }

        fn = fn.split('.');

        var cmd = fn.pop(),
            namespace = workbench;

        try {
            fn.forEach(function(n) {
                namespace = namespace[n];
            });
        } catch (err) {
            return _errorLog('%cError in SDK.invoke', 'color:red', err);
        }

        config = config || {};
        config.cmd = cmd;

        new Task(namespace, config)
            .success(config.success)
            .failure(config.failure)
            .timeout(config.timeout)
            .run();

        return this;
    };

    /**
     * 客户端代理的http请求
     * @param   {object} config
     * @param   {string} config.url
     * @param   {string} [config.method = 'get']
     * @param   {object} [config.param] 入参
     * @param   {string} [requestMethod = 'CommitHttpRequest']
     * @return  {object} SDK
     * @example
     * SDK.ajax({
     *      url: 'http://www.taobao.com/xxxx',
     *      param: {id: 100},
     *      success: function (result) {
     *          // do something...
     *      }
     * }, 'QintaoRequest')
     */
    SDK.ajax = function (config, requestMethod) {
        new Task(null, config)
            .success(config.success)
            .failure(config.failure)
            .timeout(config.timeout)
            .request(requestMethod);

        return this
    };

    // ------------ 事件 -------------------
    var EVENT_CACHE = {};
    var REGISTER_CACHE = {};

    /**
     * 注册事件
     * @param {String|Array}    name   事件名称，多个事件以数组格式
     * @return {Object}         this
     * @example
     * SDK.register('MSG_RECEIVED')
     */
    SDK.register = function (name) {
        if (!name) return this;
        if (typeof name === 'string') name = [name];

        name = name.filter(function (n) {return !REGISTER_CACHE[n]});

        if (!name.length) return this;
        try {
            workbench.im.event_register('', JSON.stringify(name), '');
            name.forEach(function (n) {REGISTER_CACHE[n] = true});
        } catch (err) {
            _errorLog('%cError in SDK.register', 'color:red;', name);
        }

        return this;
    }

    /**
     * 反注册事件
     * @param {String|Array}    [name]  事件名称，多个事件以数组形式
     * @param {Object}          this
     * @example
     * SDK.unregister();
     * SDK.unregister('MSG_RECEIVED');
     */
    SDK.unregister = function (name) {
        if (!name) name = REGISTER_CACHE.slice();
        if (typeof name === 'string') name = [name];

        if (!name.length) return this;
        try {
            workbench.im.event_unregister('', JSON.stringify(name), '');
            name.forEach(function (n) {delete REGISTER_CACHE[n]});
        } catch (err) {
            _errorLog('%cError in SDK.unregister', 'color:red', err);
        }

        return this;
    }

    /**
     * 监听事件
     * @param   {String}      name            事件名称，多个事件名称以,或者空格隔开，命名空间以::分隔
     * @param   {Function}    callback        事件触发回调
     * @return  {Object}      this
     * @example
     * function callbackHandler(data) {
     *     console.log(data);
     * }
     * SDK.on('MSG_RECEIVED', callbackHandler);
     */
    SDK.on = function(name, callback) {
        if (!name || !callback) return this;

        var events = name.split(/,?\s+/);
        var that = this;

        events.forEach(function(event) {
            if (!event) return;
            // 分离出命名空间
            var originEvent = event.split('::').pop();
            if (!originEvent) return;

            if (!EVENT_CACHE[event]) {
                EVENT_CACHE[event] = {};
                EVENT_CACHE[event].callbacks = [];
                EVENT_CACHE[event].handle = function(e) {
                    EVENT_CACHE[event].callbacks.forEach(function(cb) {
                        try {
                            cb.call(this, e.detail);
                        } catch(ex) {
                            console.error('Error in handle ' + event, ex);
                        }
                    });
                };
                document.addEventListener(originEvent, EVENT_CACHE[event].handle, false);
                that.register(originEvent);
            }

            EVENT_CACHE[event].callbacks.push(callback);

        });

        return this;
    };

    /**
     * 取消监听事件
     * @param   {String}      [name]            [可选]事件名称，多个事件名称以,或者空格隔开
     * @param   {Function}    [callback]        [可选]事件触发回调
     * @param   {Boolean}     [canUnregister=true]      [可选]是否可以自行反注册事件，默认为true
     * @return  {Object}      SDK
     * @example
     * SDK.off();
     * SDK.off('MSG_RECEIVED');
     * SDK.off('MSG_RECEIVED', callbackHandler);
     * SDK.off('MSG_RECEIVED', false);
     */
    SDK.off = function(name, callback, canUnregister) {
        var events, originEvent;
        var that = this;

        if (canUnregister === undefined && typeof callback === 'boolean') {
            canUnregister = callback;
            callback = undefined;
        } else if (callback === undefined && typeof name === 'boolean') {
            canUnregister = name;
            name = undefined;
        }
        // 默认为true
        canUnregister = canUnregister !== false;

        if (name) {
            events = name.split(/,?\s+/);

            events.forEach(function(event) {
                if (!event) return;

                originEvent = event.split('::').pop();
                if (!originEvent) return;

                if (!EVENT_CACHE[event]) return;

                var shouldClear = true;
                if (typeof callback === 'function') {
                    EVENT_CACHE[event].callbacks.some(function(cb, i) {
                        if (cb === callback) return EVENT_CACHE[event].callbacks.splice(i, 1), true;
                    });
                    shouldClear = !EVENT_CACHE[event].callbacks.length;
                }

                if (shouldClear) {
                    document.removeEventListener(originEvent, EVENT_CACHE[event].handle);
                    delete EVENT_CACHE[event];
                    // NOTE 有BUG，如果清空的是命名空间的事件，会移除掉另一个事件，所以加了一个canUnregister的选项
                    canUnregister && that.unregister(originEvent);
                }
            });
        } else {
            events = [];
            for (var event in EVENT_CACHE) {
                originEvent = event.split('::').pop();
                events.push(originEvent);
                document.removeEventListener(originEvent, EVENT_CACHE[event].handle);
                delete EVENT_CACHE[event];
            }
            this.unregister(events);
        }

        return this;
    };

    /**
     * 触发某个监听事件
     * @param   {String}      name            事件名称
     * @param   {Object}      data            带给事件绑定回调的数据
     * @return  {Object}      this
     * @example
     * SDK.fire('MSG_RECEIVED', {msgs: []});
     */
    SDK.fire = (function() {
        var that = this;

        // W3C标准
        if (global.CustomEvent) {
            return function(name, data, fromEvent) {
                if (!name) return;
                var event = new CustomEvent(name, {detail: data});
                document.dispatchEvent(event);
                !fromEvent && _log('%cSDK.fire: ' + name, 'color:pink', data);
                return that
            }
        } else {
            return function(name, data, fromEvent) {
                if (!name) return;
                var e = document.createEvent('HTMLEvents');
                e.initEvent(name, false, true);
                e.detail = data;
                document.dispatchEvent(e);
                !fromEvent && _log('%cSDK.fire: ' + name, 'color:pink', data);
                return that
            }
        }
    })();

    SDK.emit = SDK.fire;

    /**
     * 广播
     * @param {string} event
     * @param {*} data
     */
    SDK.broadcast = function(event, data) {
        var param = '';
        try {
            data && (param = JSON.stringify(data));
        } catch(e) {}

        workbench.im.event_notify('', event, param);
    };

    SDK.Binder = Binder;

    /*--------------------------  Binder  ----------------------------*/
    /**
     * 用于更方便的解绑通过Binder绑定的事件
     */
    function Binder() {
        this.bindList = [];
    }

    Binder.prototype = {
        constructor: Binder,

        on: function(name, callback) {
            Array.prototype.push.apply(this.bindList, name.split(/,?\s+/));
            SDK.on(name, callback);

            return this;
        },

        clear: function(name, callback) {
            SDK.off(this.bindList.join(' '));
            this.bindList = [];

            return this;
        }
    }

    /*--------------------------  暴露给客户端的全局函数  ----------------------------*/
    /*----------------------  客户端通过调用这些函数与前端通信  ------------------------*/
    /**
     * SDK.invoke方法的通信函数
     * @param   {String}      sid           随机数，用来找到调用时生成的task
     * @param   {Object}      status        接口调用状态，此状态仅表示接口是否通，与具体的接口返回无关
     * @return  {Object}      response      接口返回的数据
     */
    global.onInvokeNotify = function(sid, status, response) {
        if (!sid) return _log('%cEMPTY sid in onInvokeNotify, status: ' + status, 'color:#aaaaaa', response);
        var task = TASK_CACHE[sid];
        if (!task) return _errorLog('%cWARNGIN: 未找到sid: [' + sid + '] 对应的task!', 'color:#ff9900;font-weight:bold');
        if (task.destroyed) return _errorLog('%cWARNGIN: sid: [' + sid + '] 对应的task已销毁！', 'color:#ff4400;font-weight:bold', task.config.fn);

        try {
            response = (!response || /^\d+$/.test(response)) ? response : JSON.parse(response)
        } catch (e) {}

        if (status === 0) {
            task.onSuccess && task.onSuccess(response);
        } else {
            task.onFailure && task.onFailure(response);
        }
    };

    /**
     * SDK.on方法的通信函数
     * @param   {String}      name          事件名称
     * @return  {Object}      response      事件返回的数据
     */
    global.onEventNotify = function(name, response) {
        try {
            response = (!response || /^\d+$/.test(response)) ? response : JSON.parse(response)
        } catch (e) {}

        _log('%conEventNotify ' + name, 'color:blue;font-weight:bold', response);

        SDK.fire && SDK.fire(name, response, true);
    };

    /*--------------------------  一些调用方式的提升  ----------------------------*/

    // ============== 将方法用Promise重新封装 ================
    SDK._overrideWithPromise = function () {
        if (SDK.__hasOverride) return this;

        var _invoke = SDK.invoke;

        /**
         * 调用客户端方法
         * @param   {String}      fn              方法名
         * @param   {Object}      param           客户端方法的入参
         * @param   {Number}      timeout  超时时间
         * @return  {Object}      promise
         * @example
         * SDK.invoke('util.GetUserNick', {uid: 'uid'}, 5000).then(function(data) {
         *     console.log(data)
         * }).catch(function(error) {
         *     console.log(error);
         * })
         */
        SDK.invoke = function(fn, param, timeout) {
            var _b = Date.now();

            return new Promise(function(resolve, reject) {
                _invoke(fn, {
                    fn: fn,
                    param: param,
                    timeout: timeout,
                    success: function(response) {
                        var _t = Date.now() - _b;
                        global.__WPO && __WPO.retCode(fn, true, _t, 'SUCCESS');
                        resolve(response);
                    },
                    failure: function(error) {
                        var _t = Date.now() - _b;

                        if (typeof error !== 'string') {
                            try {
                                error = JSON.stringify(error);
                            } catch (e) {
                                error += '';
                            }
                        }
                        global.__WPO && __WPO.retCode(fn, true, _t, error.substring(0, 50));
                        reject(error);
                    }
                })
            });
        };

        var _ajax = SDK.ajax;

        SDK.ajaxSetup = {
            // ajax方法返回后，业务层校验规则，仅用于数据打点
            validRule: function (result) {
                return true
            }
        };

        /**
         * 带promise的ajax调用方式
         * @param  {object} config config
         * @property {string} config.url
         * @property {string} [config.method='get']
         * @property {object} [config.param] 入参
         * @property {number} [config.timeout] timeout
         * @property {function} [config.validRule] 校验规则，仅用于数据打点
         * @param  {string} [requestMethod='CommitHttpRequest']
         * @return {Promise}
         * @example
         * SDK.ajax({
         *     url: 'http://abc.com',
         *     param: {id: 1001}
         * }).then(function (result) {
         *     // do something...
         * })
         */
        SDK.ajax = function (config, requestMethod) {
            var _begin = Date.now();
            config.validRule = config.validRule || SDK.ajaxSetup.validRule;

            return new Promise(function (resolve, reject) {
                config.success = function (response) {
                    var _time = Date.now() - _begin;
                    var _flag = 'SUCCESS';
                    try {
                        if (!config.validRule(response)) _flag = 'WARNING'
                    } catch (e) {
                        _flag = 'WARNING'
                    }
                    global.__WPO && __WPO.retCode(config.api || config.apiKey || config.url, true, _time, _flag);
                    resolve(response);
                }
                config.failure = function (error) {
                    var _time = Date.now() - _begin;
                    if (typeof error !== 'string') {
                        try {
                            error = JSON.stringify(error);
                        } catch (e) {
                            error += '';
                        }
                    }
                    global.__WPO && __WPO.retCode(config.api || config.apiKey || config.url, false, _time, error.substring(0, 50));
                    reject(error);
                }
                _ajax(config, requestMethod)
            })
        }

        SDK.__hasOverride = true;
    }

    var _invoke = SDK.invoke;

    if (global.Promise) SDK._overrideWithPromise();

    /**
     * 初始化主题
     */
    SDK.initTheme = function() {
        var less = global.less;
        if (!less) {
            return;
        }
        var titleBarHeight = 31;

        function genPalette(color, count) {
            var i, cl = [], step, pos;
            count = count || 25;
            var hsl = color.toHSL();

            step = (100 / count);
            pos = count - Math.ceil(hsl.l * 100 / step);

            for (i = 0; i < count; i++) {
                if (i == pos) {
                    cl.push(color);
                } else {
                    cl.push(less.tree.functions.hsla(hsl.h, hsl.s, (100 - i * step) / 100, hsl.a));
                }
            }

            return {list: cl, pos: pos};
        }

        function changeTheme(theme) {
            var color = new less.tree.Color(theme.rgb);
            // https://img.alicdn.com/tps/i1/TB10CHwHXXXXXciXXXXb4A9VXXX-1200-900.jpg
            // 前端noschema改造地址过滤
            theme.backgroundImageUrl = theme.backgroundImageUrl.replace(/http:\/\/gtms0\d+/g, '\/\/img');
            var i, len,
                vars = {
                    '@color-base': color.toRGB(),
                    '@theme-background-image': 'url(' + theme.backgroundImageUrl + ')',
                    '@theme-bg-img': 'url(' + theme.backgroundImageUrl + ')',
                    '@theme-bg-url': '"' + theme.backgroundImageUrl + '"',
                    '@theme-bg-x': theme.backgroundPositionX || 'left',
                    '@title-bar-height': titleBarHeight + 'px'
                };

            var list = genPalette(color).list;
            len = list.length;
            for (i = 1; i <= len; i++) {
                vars['@palette-color-' + i] = list[i - 1].toRGB();
            }

            if (less && less.modifyVars) {
                less.globalResetDefaultVars = vars;
                less.modifyVars(vars);
            }
        }

        _invoke('im.uiutil.GetSkinTheme', {
            param: {},
            success: function(rsp) {
                rsp = rsp.result;
                titleBarHeight = Number(rsp.titleBarHeight || 31) || 31;
                changeTheme(rsp);
            }
        });

        SDK.on('im.uiutil.onSkinThemeChange', function(rsp) {
            //rsp = JSON.parse(rsp);
            changeTheme(rsp);
        });
    };

    return SDK;
});


/***/ }),
/* 8 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/**
 * api.js
 * @desc api list
 * @author huazhi.chz
 */

// 当前环境 0 -daily, 1 -线上
var ENV = /local|remote|daily|wapp|debug|((\d+\.){3}\d+)/.test(location.host) && !/online=1/.test(location.search) ? 0 : 1;
// 本地mock域名
var ORIGIN = location.origin || location.protocol + '//' + location.host;

/* harmony default export */ __webpack_exports__["a"] = ({
  __ENV: ENV,

  'pack.summary': { type: 'AJAX', v: '/data/pack.summary.json' },
  'pack.detail': { type: 'AJAX', v: '/data/pack.detail.json' }
});

/***/ }),
/* 9 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony export (immutable) */ __webpack_exports__["noneFmt"] = noneFmt;
/* harmony export (immutable) */ __webpack_exports__["commonResultFmt"] = commonResultFmt;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__utils_js__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__const_js__ = __webpack_require__(6);
/**
 * dataFmt.js
 * @desc data formatter service
 * @author huazhi.chz
 */




function noneFmt(data) {
    return data;
}

// 提取 {success: true, result: [Object]}中的数据
function commonResultFmt(data) {
    return data.result || {};
}

/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_RESULT__;/**
 * @file:   工具类方法集合
 * @author: Pluto <huazhi.chz@alibaba-inc.com>
 * @create: 2016/01/13
 * ******************************************************
 *      _ _   _ ____ _____   ____   ___    ___ _____
 *     | | | | / ___|_   _| |  _ \ / _ \  |_ _|_   _|
 *  _  | | | | \___ \ | |   | | | | | | |  | |  | |
 * | |_| | |_| |___) || |   | |_| | |_| |  | |  | |
 *  \___/ \___/|____/ |_|   |____/ \___/  |___| |_|
 *
 * ******************************************************
 */

!(function (global, factory) {
    'use strict';
    if (true) {
        !(__WEBPACK_AMD_DEFINE_RESULT__ = function () {
            return factory(global);
        }.call(exports, __webpack_require__, exports, module),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__));
    } else if (typeof exports === 'object') {
        module.exports = factory(global);
    } else {
        global.util = factory(global);
    }

})(typeof window !== 'undefined' ? window : this, function (window) {

    'use strict';

    /**
     * 解析URL search
     * @param  {string}  [str]      要解析的字符串
     * @param  {Boolean} [isDecode] 是否decode
     * @return {object}
     */
    var parseParam = function (str, isDecode) {
        str = str || window.location.search;
        isDecode = isDecode === undefined ? true : isDecode;
        var ary = str.split(/[?&]/), result = {}, n, tmp;
        for (var i = 0, j = ary.length; i < j; i++) {
            n = ary[i];
            if (!n) continue;
            tmp = n.split('=');
            result[tmp[0]] = (isDecode && !!tmp[1]) ? decodeURIComponent(tmp[1]) : tmp[1];
        }
        return result;
    };

    /**
     * 封装后的解析JSON方法
     * 增加对long类型数字的处理，防止损失精度
     * @param {string|object} json 需要解析的json字符串
     * @param {boolean} [needObj=false] 如果入参为空，是否仍然返回对象，默认返回null
     * @param {boolean} [fixedNumber] 是否要修复长数字精度问题
     * @return {object}
     */
    var parseJSON = function () {
        var reg = /(?!\\?"[\w\d-]+\\?":\s?)(\d{15,30})(?=\s?(,|}))/g;

        return function (json, needObj, fixedNumber) {
            if (typeof json === 'boolean') return json; // 特殊处理
            if (typeof json === 'object') return json; // 要注意的是 typeof null === 'object'
            if (!json) return needObj ? {} : null;
            try {
                fixedNumber && (json = json.replace(reg, '\"$1\"')); // 修复前端对数字的精度问题
                json = JSON.parse(json);
            } catch (e) {
                window.console && console.log('%cERROR: in parseJSON', 'color:red;', json);
                json = needObj ? {} : null;
            }
            return json;
        }
    }();

    /**
     * 解析cookie
     * @return {object}
     */
    var parseCookie = function () {
        var cookieStr = window.document ? document.cookie : '';
        var cookieAry = cookieStr.split(/\s?;\s?/);
        var cookieMap = {};
        cookieAry.forEach(function (x) {
            var i = x.indexOf('=');
            if (i >= 0) {
                cookieMap[x.substring(0, i)] = x.substring(i + 1);
            }
        });
        return cookieMap
    };

    /**
     * deep clone object
     * @param  {object} obj
     * @param {*} isDeep 如果是false，则是浅clone
     * @return {object}
     */
    var clone = function () {
        var _clone = function (obj, isDeep) {
            var tmp, k, item;
            if (typeof obj !== 'object') return obj;
            // 默认是deep clone
            isDeep = isDeep !== false;

            if (Array.isArray(obj)) {
                tmp = [];
                obj.forEach(function (n) {
                    tmp.push((isDeep && n && typeof n === 'object') ? _clone(n) : n)
                })
                return tmp
            } else {
                tmp = {};
                for (k in obj) {
                    if (obj.hasOwnProperty(k)) {
                        item = obj[k];
                        tmp[k] = (isDeep && item && typeof item === 'object') ? _clone(item) : item
                    }
                }
                return tmp
            }
        }

        return _clone
    }();

    /**
     * 获取到指定大小的图片
     * 如果不是CDN图片,则返回原图
     * @param {object|string} o options {number w, number h, boolean xz, string src} 如果传字符串,则表示src
     * @property {string} o.src
     * @property {boolean} o.clear 是否清除后缀
     * @param {number} [w] width
     * @param {number} [h] height = width
     * @return {string}
     * @see //img.alicdn.com/L1/8/381/imgsrc_config.lua
     * @example
     * imgXZ('//img.alicdn.com/tps/xxx', 72)
     */
    var imgXZ = function () {
        var _CDN_REG = /_(?!\.jpg$)((\d+x\d+(xz)?)|m|b|s|sum|summ|summ2|search)?(co0)?([qQ]\d{2})?(s\d{2,3})?g?\.jpg$/;
        var _CDN_HOST = /[\w\d\-]+\.(alicdn|taobaocdn|tbcdn)\.(com|cn)/;

        return function (o, w, h) {
            typeof o === 'string' && (o = {src: o});
            typeof o === 'object' && o.url && (o.src = o.url); // 兼容老版本
            w && (o.w = w);
            h && (o.h = h);
            o.w = o.w || 580;
            o.h = o.h || o.w;
            o.xz !== false && (o.xz = true);
            var suffix = '_' + o.w + 'x' + o.h + (o.xz ? 'xz' : '') + '.jpg';
            if (_CDN_HOST.test(o.src)) {
                o.src = o.src.replace(/^http:\/\//, 'https://');
                o.src = o.src.replace(_CDN_HOST, 'img.alicdn.com');
                o.src = o.src.replace(/_\.webp$/, '');
                o.src = o.src.replace(_CDN_REG, '');
                return o.clear ? o.src : (o.src + suffix)
            } else {
                return o.src;
            }
        }
    }();

    var TIMEZONE_OFFSET = Date.prototype.getTimezoneOffset.call(new Date) * 60 * 1000;
    var ONE_DAY = 24 * 3600 * 1000;

    /**
    * 获取今天零点的时间
    * @param {number|Date} d
    * @return {Date}
    */
    var getZeroTime = function (d) {
        d = d ? new Date(d) : new Date();
        return new Date(d - ((d - TIMEZONE_OFFSET) % ONE_DAY));
    }

    /**
    * 返回格式化时间json串
    * @param {number|Date} timestamp
    * @param {string} [fmtStr] 如果有此参数，则返回格式化的字符串
    * Y >> year, M >> month, d >> date, H >> hours, m >> minutes, s >> seconds
    * @return {object|string}
    */
    var _date = function (timestamp, fmtStr) {
        if (timestamp === undefined || timestamp === null) return fmtStr ? '' : {};
        var _date, now, zero, fromZero, isToday, yearStr, dateStr, timeStr;
        _date = new Date(isNaN(+timestamp) ? timestamp : +timestamp);   // 目标时间
        now = Date.now();       // 当前时间
        zero = now - ((now - TIMEZONE_OFFSET) % ONE_DAY);   // 今天零点
        fromZero = _date - zero;    // 距离今天零点的毫秒数
        isToday = 0 < fromZero && fromZero < ONE_DAY;   // 是否是今天

        var O = {
            Y: (_date.getFullYear() + '').substring(2),
            M: _date.getMonth() + 1,
            d: _date.getDate(),
            H: _date.getHours(),
            m: _date.getMinutes(),
            s: _date.getSeconds()
        };

        O.YY = _date.getFullYear();
        O.MM = O.M >= 10 ? O.M : ('0' + O.M);
        O.dd = O.d >= 10 ? O.d : ('0' + O.d);
        O.HH = O.H >= 10 ? O.H : ('0' + O.H);
        O.mm = O.m >= 10 ? O.m : ('0' + O.m);
        O.ss = O.s >= 10 ? O.s : ('0' + O.s);

        if (fmtStr) {
            return fmtStr.replace(/[YMdHms]{1,2}/g, function (x) {
                return O[x] || ''
            });
        }

        yearStr = O.YY + '-' + O.MM + '-' + O.dd;
        dateStr = O.MM + '-' + O.dd;
        timeStr = O.HH + ':' + O.mm;

        return {
            timestamp: +_date,
            yearStr: yearStr,
            dateStr: dateStr,
            timeStr: timeStr,
            today: isToday
        }
    };

    /**
     * localStorage 存储
     */
    var _localStorage = function () {
        var _local = window.localStorage || {},
            _expiredReg = /(?:\"_{1,2}expired\"\:)(\d{13})(?:\})$/;

        /**
         * 清除过期数据
         */
        var clearExpired = function () {
            var now = +new Date();
            for (var k in _local) {
                if (_local.hasOwnProperty(k)) {
                    var v = _local.getItem(k);
                    v && (v = v.match(_expiredReg));
                    v && (v = v[1] - 0);
                    v && v < now && _local.removeItem(k);
                }
            }
        };

        /**
         * 增加或修改数据，如果有expired，则将数据套在data中
         * @param {string|number} k
         * @param {*} v
         * @param {number} [expired]
         * @update 增加try catch，防止数据量溢出
         */
        var setItem = function (k, v, expired) {
            expired === undefined && (expired = +new Date() + 365 * 24 * 3600 * 1000); // 数据默认存储一年
            v = {data: v, __expired: expired};
            try {
                v = JSON.stringify(v)
            } catch (e) {
                v = Object.prototype.toString.call(v);
            }
            try {
                _local.setItem(k, v)
            } catch (e) {
                // 这里可能是localStorage过大导致无法添加
            }
        };

        /**
         * 获取数据，如果数据过期，则返回null，并且清除数据
         * @param {string} k
         * @return {*}
         */
        var getItem = function (k) {
            var v = _local.getItem(k);
            v = parseJSON(v);
            // 老版本兼容，去掉老版本的数据
            if (v && v._expired && !v.__expired) {
                v = null;
                _local.removeItem(k);
            }
            if (v && typeof v === 'object' && v.__expired) { // typeof null === 'object'!!!
                v = v.__expired < +new Date() ? null : v.data;
                v === null && _local.removeItem(k)
            }
            return v
        };

        // 每次初始化的时候都清除一次数据
        clearExpired();

        return {
            setItem: setItem,
            getItem: getItem,
            clear: _local.clear,
            removeItem: _local.removeItem,
            clearExpired: clearExpired
        }
    }();

    /**
     * 黄金令箭打点
     * @param  {string} key    多个点以逗号隔开
     * @param  {object} [params] 参数
     * @example util.goldLog('wwxb.1.2', {level: 1})
     */
    var goldLog = function () {
        var goldLogHold = Date.now();
        var _nk_ = parseCookie()['_nk_'] || '';
        if (_nk_) _nk_ = 'cntaobao' + _nk_;


        return function (key, params) {
            if (!key) return false;
            params = params || {};
            if (/,/.test(key)) {
                key = key.split(/\s?,\s?/);
                return key.forEach(function (_key) {
                    goldLog(_key, params)
                });
            }
            key = key.replace(/^\//, '');
            var paramStr = '',
                hold = '__log_' + goldLogHold++,
                img = window[hold] = new Image(),
                glue = /\?/.test(key) ? '&' : '?',
                k;
            for (k in params) {
                paramStr += ('&' + k + '=' + params[k])
            }
            if (!params.nick) {
                paramStr += ('&nick=' + _nk_);
            }
            img.onload = img.onerror = function () {
                delete window[hold]
            };
            img.src = 'https://gm.mmstat.com/' + key + glue + 'cache=' + hold + paramStr;
        }
    }();

    // ------------------ combo -----------------
    var util = {
        parseParam: parseParam,
        parseJSON: parseJSON,
        parseCookie: parseCookie,
        clone: clone,
        imgXZ: imgXZ,
        date: _date,
        getZeroTime: getZeroTime,
        local: _localStorage,
        goldLog: goldLog,

        /**
         * Return a random integer between min and max (inclusive).
         * @param {number} min
         * @param {number} [max]
         * @return {number}
         */
        random: function (min, max) {
            if (max === undefined) {
                max = min;
                min = 0;
            }
            return min + Math.floor(Math.random() * (max - min + 1));
        },

        /**
         * 创建一个uuid
         * @return {string}
         */
        uuid: function () {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
                var r = Math.random() * 16 | 0;
                var v = c == 'x' ? r : r & 0x3 | 0x8;
                return v.toString(16).toUpperCase();
            })
        }

    }

    return util;
});


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

var __WEBPACK_AMD_DEFINE_FACTORY__, __WEBPACK_AMD_DEFINE_RESULT__;/*!
  * Reqwest! A general purpose XHR connection manager
  * license MIT (c) Dustin Diaz 2015
  * https://github.com/ded/reqwest
  * 
  */

!function (name, context, definition) {
  if (typeof module != 'undefined' && module.exports) module.exports = definition()
  else if (true) !(__WEBPACK_AMD_DEFINE_FACTORY__ = (definition),
				__WEBPACK_AMD_DEFINE_RESULT__ = (typeof __WEBPACK_AMD_DEFINE_FACTORY__ === 'function' ?
				(__WEBPACK_AMD_DEFINE_FACTORY__.call(exports, __webpack_require__, exports, module)) :
				__WEBPACK_AMD_DEFINE_FACTORY__),
				__WEBPACK_AMD_DEFINE_RESULT__ !== undefined && (module.exports = __WEBPACK_AMD_DEFINE_RESULT__))
  else context[name] = definition()
}('reqwest', this, function () {

  var context = this

  if ('window' in context) {
    var doc = document
      , byTag = 'getElementsByTagName'
      , head = doc[byTag]('head')[0]
  } else {
    var XHR2
    try {
      XHR2 = __webpack_require__(12)
    } catch (ex) {
      throw new Error('Peer dependency `xhr2` required! Please npm install xhr2')
    }
  }


  var httpsRe = /^http/
    , protocolRe = /(^\w+):\/\//
    , twoHundo = /^(20\d|1223)$/ //http://stackoverflow.com/questions/10046972/msie-returns-status-code-of-1223-for-ajax-request
    , readyState = 'readyState'
    , contentType = 'Content-Type'
    , requestedWith = 'X-Requested-With'
    , uniqid = 0
    , callbackPrefix = 'reqwest_' + (+new Date())
    , lastValue // data stored by the most recent JSONP callback
    , xmlHttpRequest = 'XMLHttpRequest'
    , xDomainRequest = 'XDomainRequest'
    , noop = function () {}

    , isArray = typeof Array.isArray == 'function'
        ? Array.isArray
        : function (a) {
            return a instanceof Array
          }

    , defaultHeaders = {
          'contentType': 'application/x-www-form-urlencoded'
        , 'requestedWith': xmlHttpRequest
        , 'accept': {
              '*':  'text/javascript, text/html, application/xml, text/xml, */*'
            , 'xml':  'application/xml, text/xml'
            , 'html': 'text/html'
            , 'text': 'text/plain'
            , 'json': 'application/json, text/javascript'
            , 'js':   'application/javascript, text/javascript'
          }
      }

    , xhr = function(o) {
        // is it x-domain
        if (o['crossOrigin'] === true) {
          var xhr = context[xmlHttpRequest] ? new XMLHttpRequest() : null
          if (xhr && 'withCredentials' in xhr) {
            return xhr
          } else if (context[xDomainRequest]) {
            return new XDomainRequest()
          } else {
            throw new Error('Browser does not support cross-origin requests')
          }
        } else if (context[xmlHttpRequest]) {
          return new XMLHttpRequest()
        } else if (XHR2) {
          return new XHR2()
        } else {
          return new ActiveXObject('Microsoft.XMLHTTP')
        }
      }
    , globalSetupOptions = {
        dataFilter: function (data) {
          return data
        }
      }

  function succeed(r) {
    var protocol = protocolRe.exec(r.url)
    protocol = (protocol && protocol[1]) || context.location.protocol
    return httpsRe.test(protocol) ? twoHundo.test(r.request.status) : !!r.request.response
  }

  function handleReadyState(r, success, error) {
    return function () {
      // use _aborted to mitigate against IE err c00c023f
      // (can't read props on aborted request objects)
      if (r._aborted) return error(r.request)
      if (r._timedOut) return error(r.request, 'Request is aborted: timeout')
      if (r.request && r.request[readyState] == 4) {
        r.request.onreadystatechange = noop
        if (succeed(r)) success(r.request)
        else
          error(r.request)
      }
    }
  }

  function setHeaders(http, o) {
    var headers = o['headers'] || {}
      , h

    headers['Accept'] = headers['Accept']
      || defaultHeaders['accept'][o['type']]
      || defaultHeaders['accept']['*']

    var isAFormData = typeof FormData !== 'undefined' && (o['data'] instanceof FormData);
    // breaks cross-origin requests with legacy browsers
    if (!o['crossOrigin'] && !headers[requestedWith]) headers[requestedWith] = defaultHeaders['requestedWith']
    if (!headers[contentType] && !isAFormData) headers[contentType] = o['contentType'] || defaultHeaders['contentType']
    for (h in headers)
      headers.hasOwnProperty(h) && 'setRequestHeader' in http && http.setRequestHeader(h, headers[h])
  }

  function setCredentials(http, o) {
    if (typeof o['withCredentials'] !== 'undefined' && typeof http.withCredentials !== 'undefined') {
      http.withCredentials = !!o['withCredentials']
    }
  }

  function generalCallback(data) {
    lastValue = data
  }

  function urlappend (url, s) {
    return url + (/\?/.test(url) ? '&' : '?') + s
  }

  function handleJsonp(o, fn, err, url) {
    var reqId = uniqid++
      , cbkey = o['jsonpCallback'] || 'callback' // the 'callback' key
      , cbval = o['jsonpCallbackName'] || reqwest.getcallbackPrefix(reqId)
      , cbreg = new RegExp('((^|\\?|&)' + cbkey + ')=([^&]+)')
      , match = url.match(cbreg)
      , script = doc.createElement('script')
      , loaded = 0
      , isIE10 = navigator.userAgent.indexOf('MSIE 10.0') !== -1

    if (match) {
      if (match[3] === '?') {
        url = url.replace(cbreg, '$1=' + cbval) // wildcard callback func name
      } else {
        cbval = match[3] // provided callback func name
      }
    } else {
      url = urlappend(url, cbkey + '=' + cbval) // no callback details, add 'em
    }

    context[cbval] = generalCallback

    script.type = 'text/javascript'
    script.src = url
    script.async = true
    if (typeof script.onreadystatechange !== 'undefined' && !isIE10) {
      // need this for IE due to out-of-order onreadystatechange(), binding script
      // execution to an event listener gives us control over when the script
      // is executed. See http://jaubourg.net/2010/07/loading-script-as-onclick-handler-of.html
      script.htmlFor = script.id = '_reqwest_' + reqId
    }

    script.onload = script.onreadystatechange = function () {
      if ((script[readyState] && script[readyState] !== 'complete' && script[readyState] !== 'loaded') || loaded) {
        return false
      }
      script.onload = script.onreadystatechange = null
      script.onclick && script.onclick()
      // Call the user callback with the last value stored and clean up values and scripts.
      fn(lastValue)
      lastValue = undefined
      head.removeChild(script)
      loaded = 1
    }

    // update by huazhi.chz
    script.onerror = function (e) {
        err({}, 'Request is failed: 404 or timeout', {});
        lastValue = undefined
        head.removeChild(script)
        loaded = 1
    }

    // Add the script to the DOM head
    head.appendChild(script)

    // Enable JSONP timeout
    return {
      abort: function () {
        script.onload = script.onreadystatechange = null
        err({}, 'Request is aborted: timeout', {})
        lastValue = undefined
        head.removeChild(script)
        loaded = 1
      }
    }
  }

  function getRequest(fn, err) {
    var o = this.o
      , method = (o['method'] || 'GET').toUpperCase()
      , url = typeof o === 'string' ? o : o['url']
      // convert non-string objects to query-string form unless o['processData'] is false
      , data = (o['processData'] !== false && o['data'] && typeof o['data'] !== 'string')
        ? reqwest.toQueryString(o['data'])
        : (o['data'] || null)
      , http
      , sendWait = false

    // if we're working on a GET request and we have data then we should append
    // query string to end of URL and not post data
    if ((o['type'] == 'jsonp' || method == 'GET') && data) {
      url = urlappend(url, data)
      data = null
    }

    if (o['type'] == 'jsonp') return handleJsonp(o, fn, err, url)

    // get the xhr from the factory if passed
    // if the factory returns null, fall-back to ours
    http = (o.xhr && o.xhr(o)) || xhr(o)

    http.open(method, url, o['async'] === false ? false : true)
    setHeaders(http, o)
    setCredentials(http, o)
    if (context[xDomainRequest] && http instanceof context[xDomainRequest]) {
        http.onload = fn
        http.onerror = err
        // NOTE: see
        // http://social.msdn.microsoft.com/Forums/en-US/iewebdevelopment/thread/30ef3add-767c-4436-b8a9-f1ca19b4812e
        http.onprogress = function() {}
        sendWait = true
    } else {
      http.onreadystatechange = handleReadyState(this, fn, err)
    }
    o['before'] && o['before'](http)
    if (sendWait) {
      setTimeout(function () {
        http.send(data)
      }, 200)
    } else {
      http.send(data)
    }
    return http
  }

  function Reqwest(o, fn) {
    this.o = o
    this.fn = fn

    init.apply(this, arguments)
  }

  function setType(header) {
    // json, javascript, text/plain, text/html, xml
    if (header === null) return undefined; //In case of no content-type.
    if (header.match('json')) return 'json'
    if (header.match('javascript')) return 'js'
    if (header.match('text')) return 'html'
    if (header.match('xml')) return 'xml'
  }

  function init(o, fn) {

    this.url = typeof o == 'string' ? o : o['url']
    this.timeout = null

    // whether request has been fulfilled for purpose
    // of tracking the Promises
    this._fulfilled = false
    // success handlers
    this._successHandler = function(){}
    this._fulfillmentHandlers = []
    // error handlers
    this._errorHandlers = []
    // complete (both success and fail) handlers
    this._completeHandlers = []
    this._erred = false
    this._responseArgs = {}

    var self = this

    fn = fn || function () {}

    if (o['timeout']) {
      this.timeout = setTimeout(function () {
        timedOut()
      }, o['timeout'])
    }

    if (o['success']) {
      this._successHandler = function () {
        o['success'].apply(o, arguments)
      }
    }

    if (o['error']) {
      this._errorHandlers.push(function () {
        o['error'].apply(o, arguments)
      })
    }

    if (o['complete']) {
      this._completeHandlers.push(function () {
        o['complete'].apply(o, arguments)
      })
    }

    function complete (resp) {
      o['timeout'] && clearTimeout(self.timeout)
      self.timeout = null
      while (self._completeHandlers.length > 0) {
        self._completeHandlers.shift()(resp)
      }
    }

    function success (resp) {
      // MARK huazhi.chz
      if (resp === undefined || resp === null) return error('ERROR', 'Error in handle response data');
      
      var type = o['type'] || resp && setType(resp.getResponseHeader('Content-Type')) // resp can be undefined in IE
      resp = (type !== 'jsonp') ? self.request : resp
      // use global data filter on response text
      var filteredResponse = globalSetupOptions.dataFilter(resp.responseText, type)
        , r = filteredResponse
      try {
        resp.responseText = r
      } catch (e) {
        // can't assign this in IE<=8, just ignore
      }
      if (r) {
        switch (type) {
        case 'json':
          try {
            resp = context.JSON ? context.JSON.parse(r) : eval('(' + r + ')')
          } catch (err) {
            return error(resp, 'Could not parse JSON in response', err)
          }
          break
        case 'js':
          resp = eval(r)
          break
        case 'html':
          resp = r
          break
        case 'xml':
          resp = resp.responseXML
              && resp.responseXML.parseError // IE trololo
              && resp.responseXML.parseError.errorCode
              && resp.responseXML.parseError.reason
            ? null
            : resp.responseXML
          break
        }
      }

      self._responseArgs.resp = resp
      self._fulfilled = true
      fn(resp)
      self._successHandler(resp)
      while (self._fulfillmentHandlers.length > 0) {
        resp = self._fulfillmentHandlers.shift()(resp)
      }

      complete(resp)
    }

    function timedOut() {
      self._timedOut = true
      self.request.abort()
    }

    function error(resp, msg, t) {
      resp = self.request
      self._responseArgs.resp = resp
      self._responseArgs.msg = msg
      self._responseArgs.t = t
      self._erred = true
      while (self._errorHandlers.length > 0) {
        self._errorHandlers.shift()(resp, msg, t)
      }
      complete(resp)
    }

    this.request = getRequest.call(this, success, error)
  }

  Reqwest.prototype = {
    abort: function () {
      this._aborted = true
      this.request.abort()
    }

  , retry: function () {
      init.call(this, this.o, this.fn)
    }

    /**
     * Small deviation from the Promises A CommonJs specification
     * http://wiki.commonjs.org/wiki/Promises/A
     */

    /**
     * `then` will execute upon successful requests
     */
  , then: function (success, fail) {
      success = success || function () {}
      fail = fail || function () {}
      if (this._fulfilled) {
        this._responseArgs.resp = success(this._responseArgs.resp)
      } else if (this._erred) {
        fail(this._responseArgs.resp, this._responseArgs.msg, this._responseArgs.t)
      } else {
        this._fulfillmentHandlers.push(success)
        this._errorHandlers.push(fail)
      }
      return this
    }

    /**
     * `always` will execute whether the request succeeds or fails
     */
  , always: function (fn) {
      if (this._fulfilled || this._erred) {
        fn(this._responseArgs.resp)
      } else {
        this._completeHandlers.push(fn)
      }
      return this
    }

    /**
     * `fail` will execute when the request fails
     */
  , fail: function (fn) {
      if (this._erred) {
        fn(this._responseArgs.resp, this._responseArgs.msg, this._responseArgs.t)
      } else {
        this._errorHandlers.push(fn)
      }
      return this
    }
  , 'catch': function (fn) {
      return this.fail(fn)
    }
  }

  function reqwest(o, fn) {
    return new Reqwest(o, fn)
  }

  // normalize newline variants according to spec -> CRLF
  function normalize(s) {
    return s ? s.replace(/\r?\n/g, '\r\n') : ''
  }

  function serial(el, cb) {
    var n = el.name
      , t = el.tagName.toLowerCase()
      , optCb = function (o) {
          // IE gives value="" even where there is no value attribute
          // 'specified' ref: http://www.w3.org/TR/DOM-Level-3-Core/core.html#ID-862529273
          if (o && !o['disabled'])
            cb(n, normalize(o['attributes']['value'] && o['attributes']['value']['specified'] ? o['value'] : o['text']))
        }
      , ch, ra, val, i

    // don't serialize elements that are disabled or without a name
    if (el.disabled || !n) return

    switch (t) {
    case 'input':
      if (!/reset|button|image|file/i.test(el.type)) {
        ch = /checkbox/i.test(el.type)
        ra = /radio/i.test(el.type)
        val = el.value
        // WebKit gives us "" instead of "on" if a checkbox has no value, so correct it here
        ;(!(ch || ra) || el.checked) && cb(n, normalize(ch && val === '' ? 'on' : val))
      }
      break
    case 'textarea':
      cb(n, normalize(el.value))
      break
    case 'select':
      if (el.type.toLowerCase() === 'select-one') {
        optCb(el.selectedIndex >= 0 ? el.options[el.selectedIndex] : null)
      } else {
        for (i = 0; el.length && i < el.length; i++) {
          el.options[i].selected && optCb(el.options[i])
        }
      }
      break
    }
  }

  // collect up all form elements found from the passed argument elements all
  // the way down to child elements; pass a '<form>' or form fields.
  // called with 'this'=callback to use for serial() on each element
  function eachFormElement() {
    var cb = this
      , e, i
      , serializeSubtags = function (e, tags) {
          var i, j, fa
          for (i = 0; i < tags.length; i++) {
            fa = e[byTag](tags[i])
            for (j = 0; j < fa.length; j++) serial(fa[j], cb)
          }
        }

    for (i = 0; i < arguments.length; i++) {
      e = arguments[i]
      if (/input|select|textarea/i.test(e.tagName)) serial(e, cb)
      serializeSubtags(e, [ 'input', 'select', 'textarea' ])
    }
  }

  // standard query string style serialization
  function serializeQueryString() {
    return reqwest.toQueryString(reqwest.serializeArray.apply(null, arguments))
  }

  // { 'name': 'value', ... } style serialization
  function serializeHash() {
    var hash = {}
    eachFormElement.apply(function (name, value) {
      if (name in hash) {
        hash[name] && !isArray(hash[name]) && (hash[name] = [hash[name]])
        hash[name].push(value)
      } else hash[name] = value
    }, arguments)
    return hash
  }

  // [ { name: 'name', value: 'value' }, ... ] style serialization
  reqwest.serializeArray = function () {
    var arr = []
    eachFormElement.apply(function (name, value) {
      arr.push({name: name, value: value})
    }, arguments)
    return arr
  }

  reqwest.serialize = function () {
    if (arguments.length === 0) return ''
    var opt, fn
      , args = Array.prototype.slice.call(arguments, 0)

    opt = args.pop()
    opt && opt.nodeType && args.push(opt) && (opt = null)
    opt && (opt = opt.type)

    if (opt == 'map') fn = serializeHash
    else if (opt == 'array') fn = reqwest.serializeArray
    else fn = serializeQueryString

    return fn.apply(null, args)
  }

  reqwest.toQueryString = function (o, trad) {
    var prefix, i
      , traditional = trad || false
      , s = []
      , enc = encodeURIComponent
      , add = function (key, value) {
          // If value is a function, invoke it and return its value
          value = ('function' === typeof value) ? value() : (value == null ? '' : value)
          s[s.length] = enc(key) + '=' + enc(value)
        }
    // If an array was passed in, assume that it is an array of form elements.
    if (isArray(o)) {
      for (i = 0; o && i < o.length; i++) add(o[i]['name'], o[i]['value'])
    } else {
      // If traditional, encode the "old" way (the way 1.3.2 or older
      // did it), otherwise encode params recursively.
      for (prefix in o) {
        if (o.hasOwnProperty(prefix)) buildParams(prefix, o[prefix], traditional, add)
      }
    }

    // spaces should be + according to spec
    return s.join('&').replace(/%20/g, '+')
  }

  function buildParams(prefix, obj, traditional, add) {
    var name, i, v
      , rbracket = /\[\]$/

    if (isArray(obj)) {
      // Serialize array item.
      for (i = 0; obj && i < obj.length; i++) {
        v = obj[i]
        if (traditional || rbracket.test(prefix)) {
          // Treat each array item as a scalar.
          add(prefix, v)
        } else {
          buildParams(prefix + '[' + (typeof v === 'object' ? i : '') + ']', v, traditional, add)
        }
      }
    } else if (obj && obj.toString() === '[object Object]') {
      // Serialize object item.
      for (name in obj) {
        buildParams(prefix + '[' + name + ']', obj[name], traditional, add)
      }

    } else {
      // Serialize scalar item.
      add(prefix, obj)
    }
  }

  reqwest.getcallbackPrefix = function () {
    return callbackPrefix
  }

  // jQuery and Zepto compatibility, differences can be remapped here so you can call
  // .ajax.compat(options, callback)
  reqwest.compat = function (o, fn) {
    if (o) {
      o['type'] && (o['method'] = o['type']) && delete o['type']
      o['dataType'] && (o['type'] = o['dataType'])
      o['jsonpCallback'] && (o['jsonpCallbackName'] = o['jsonpCallback']) && delete o['jsonpCallback']
      o['jsonp'] && (o['jsonpCallback'] = o['jsonp'])
    }
    return new Reqwest(o, fn)
  }

  reqwest.ajaxSetup = function (options) {
    options = options || {}
    for (var k in options) {
      globalSetupOptions[k] = options[k]
    }
  }

  return reqwest
});


/***/ }),
/* 12 */
/***/ (function(module, exports) {

/* (ignored) */

/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

!function(e,t){ true?module.exports=t():"function"==typeof define&&define.amd?define([],t):"object"==typeof exports?exports.iframeCom=t():e.iframeCom=t()}(this,function(){return function(e){function t(r){if(n[r])return n[r].exports;var o=n[r]={i:r,l:!1,exports:{}};return e[r].call(o.exports,o,o.exports,t),o.l=!0,o.exports}var n={};return t.m=e,t.c=n,t.i=function(e){return e},t.d=function(e,n,r){t.o(e,n)||Object.defineProperty(e,n,{configurable:!1,enumerable:!0,get:r})},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},t.p="",t(t.s=0)}([function(e,t,n){"use strict";var r=window,o=r.parent,u={};r.addEventListener("message",function(e){var t=e.data;u.hasOwnProperty(t.__target__)&&u[t.__target__].call(null,t)}),e.exports={send:function(e){var t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};t.__target__=e,o.postMessage(t,"*")},receive:function(e,t){u[e]=t}}}])});

/***/ }),
/* 14 */,
/* 15 */,
/* 16 */,
/* 17 */,
/* 18 */,
/* 19 */,
/* 20 */,
/* 21 */,
/* 22 */,
/* 23 */,
/* 24 */,
/* 25 */,
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(27);


/***/ }),
/* 27 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
Object.defineProperty(__webpack_exports__, "__esModule", { value: true });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0_react___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0_react__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react_dom__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1_react_dom___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_1_react_dom__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__index_scss__ = __webpack_require__(28);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__index_scss___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_2__index_scss__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_iframe_com__ = __webpack_require__(13);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3_iframe_com___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_3_iframe_com__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4_utils_invoke_js__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5_utils_index__ = __webpack_require__(3);


function _defaults(obj, defaults) { var keys = Object.getOwnPropertyNames(defaults); for (var i = 0; i < keys.length; i++) { var key = keys[i]; var value = Object.getOwnPropertyDescriptor(defaults, key); if (value && value.configurable && obj[key] === undefined) { Object.defineProperty(obj, key, value); } } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults(subClass, superClass); }








// 获取群组id
var tribeid = Object(__WEBPACK_IMPORTED_MODULE_4_utils_invoke_js__["a" /* getURLParameter */])('tribeid');

var Iframes = function (_React$Component) {
  _inherits(Iframes, _React$Component);

  function Iframes(props) {
    _classCallCheck(this, Iframes);

    var _this = _possibleConstructorReturn(this, _React$Component.call(this, props));

    _this.state = {
      showPopUp: false,
      data: [],
      url: ''
    };
    return _this;
  }

  Iframes.prototype.componentDidMount = function componentDidMount() {
    var _self = this;
    __WEBPACK_IMPORTED_MODULE_3_iframe_com___default.a.receive('submit', function (data) {
      location.href = history.go(-1);
    });
  };

  Iframes.prototype.render = function render() {

    return __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(
      'div',
      { className: 'help-page' },
      __WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement('iframe', { src: 'http://h5.m.taobao.com/app/chatting/www/password_set/index.html?app=qn&groupId=' + tribeid,
        className: 'iframeBox',
        sandbox: 'allow-same-origin allow-top-navigation allow-modals allow-forms allow-scripts',
        frameBorder: '0'
      })
    );
  };

  return Iframes;
}(__WEBPACK_IMPORTED_MODULE_0_react___default.a.Component);

__WEBPACK_IMPORTED_MODULE_1_react_dom___default.a.render(__WEBPACK_IMPORTED_MODULE_0_react___default.a.createElement(Iframes, null), document.getElementById('container'));

/***/ }),
/* 28 */
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ })
],[26]);