//
//  MBSketchFileParser.h
//  MockingBotSketchPlugin
//
//  Created by modao on 2017/10/10.
//  Copyright © 2017年 MockingBot. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MBSketchFileParser;
@protocol MBSketchFileParserDelegate <NSObject>

@optional
-(void)sketchFileParser:(MBSketchFileParser* _Nonnull)parser
           encountError:(NSError* _Nonnull)error;
-(void)sketchFileParser:(MBSketchFileParser*  _Nonnull)parser
      parsePreviewImage:(NSImage* _Nullable)image;
-(void)sketchFileParser:(MBSketchFileParser * _Nonnull)parser
              parsePage:(NSData* _Nullable)pageInfo;
-(void)sketchFileParser:(MBSketchFileParser * _Nonnull)parser
             parseImage:(NSImage* _Nullable)image;
-(void)sketchFileParser:(MBSketchFileParser * _Nonnull)parser
              parseUser:(NSData* _Nullable)userJSON;
-(void)sketchFileParser:(MBSketchFileParser * _Nonnull)parser
          parseDocument:(NSData* _Nullable)documentJSON;
-(void)sketchFileParser:(MBSketchFileParser * _Nonnull)parser
              parseMeta:(NSData* _Nullable)metaJSON;
-(void)sketchFileParser:(MBSketchFileParser * _Nonnull)parser
             totalCount:(NSUInteger)totalCount
     completedUnitCount:(NSUInteger)completeCount;

@end

@interface MBSketchFileParser : NSObject

@property(nonatomic,weak, nullable)id<MBSketchFileParserDelegate> delegate;
@property(nonatomic, assign, readonly, getter=isFinished)BOOL finished;

-(void)parseSketchFile:(NSString* _Nonnull)path;

@end
