//
//  MockingBotSketchPlugin.h
//  MockingBotSketchPlugin
//
//  Created by Perry Poon on 20/10/2016.
//  Copyright © 2016 MockingBot. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "MBPlaygroundHelper.h"

//! Project version number for MockingBotSketchPlugin.
FOUNDATION_EXPORT double MockingBotSketchPluginVersionNumber;

//! Project version string for MockingBotSketchPlugin.
FOUNDATION_EXPORT const unsigned char MockingBotSketchPluginVersionString[];

// In this header, you should import all the public headers of your framework using statements like #import <MockingBotSketchPlugin/PublicHeader.h>

@protocol MockingBotSketchPluginDelegate <NSObject>

@required
- (void)requestSuccessHandler:(NSDictionary *)json;
- (void)requestFailureHandler:(NSDictionary *)error;
- (void)uploadArtboards:(NSMutableArray *)artboards
              toProject:(NSString *)projectCID;

@end

@interface MockingBotSketchPlugin : NSObject

@property (nonatomic, assign, getter=isProcessing) BOOL processing;
@property (nonatomic, weak) id<MockingBotSketchPluginDelegate> delegate;
@property (nonatomic, strong)NSWindowController* rootController;
@property (nonatomic, class)MockingBotSketchPlugin* shared;
    
+ (instancetype)initializeWithArtboardInfo:(NSDictionary*)context;

@end
