local assets =
{
    Asset("ANIM", "anim/sandhill.zip")
}

local function ongustblowawayfn(inst)
    if not inst.components.inventoryitem or not inst.components.inventoryitem.owner then 
        inst:RemoveComponent("inventoryitem")
        inst:RemoveComponent("inspectable")
        inst.SoundEmitter:PlaySound("dontstarve/common/dust_blowaway")
        inst.AnimState:PlayAnimation("disappear")
        inst:ListenForEvent("animover", function() inst:Remove() end)
    end 
end

-- sand --

local function MakeEquippable(inst)

    local onequip = function(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_poop", "swap_poop")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end

    local onunequip = function(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end

    local onthrown = function(inst, thrower, pt)

        inst:AddTag("thrown")
        inst.AnimState:SetBank("monkey_projectile")
        inst.AnimState:SetBuild("monkey_projectile")
        inst.AnimState:PlayAnimation("idle", true)

        inst.Physics:SetFriction(.2)

        inst.GroundTask = inst:DoPeriodicTask(FRAMES, function()
            local pos = inst:GetPosition()
            if pos.y > 0.1 then

               local ground = GetWorld()
               local original_tile_type = ground.Map:GetTileAtPoint(pt.x, pt.y, pt.z)
               local x, y = ground.Map:GetTileCoordsAtPoint(pt.x, pt.y, pt.z)

               GetWorld().Flooding:SetIsPositionBlocked(pt.x,0,pt.z, false, false)

                if original_tile_type == GROUND.BEACH then
                   if x and y then
                      ground.Map:SetTile(x,y, GROUND.OCEAN_SHALLOW)
                      ground.Map:RebuildLayer( GROUND.OCEAN_SHALLOW, x, y )
                   end
                   local minimap = TheSim:FindFirstEntityWithTag("minimap")
                   if minimap then
                      minimap.MiniMap:RebuildLayer( GROUND.OCEAN_SHALLOW, x, y )
                   end
                else
                   if x and y then
                      ground.Map:SetTile(x,y, GROUND.BEACH)
                      ground.Map:RebuildLayer( GROUND.BEACH, x, y )
                   end
                   local minimap = TheSim:FindFirstEntityWithTag("minimap")
                   if minimap then
                      minimap.MiniMap:RebuildLayer( GROUND.BEACH, x, y )
                   end
                end
                
                inst:Remove()
            end
        end)
    end

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    inst.components.equippable.equipstack = true

    inst:AddComponent("throwable")
    inst.components.throwable.onthrown = onthrown

    inst:AddComponent("reticule")
    inst.components.reticule.targetfn = function() 
        return inst.components.throwable:GetThrowPoint()
    end
    inst.components.reticule.ease = true
end


-- end sand --

local function sandfn(Sim)
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)

    anim:SetBuild( "sandhill" )
    anim:SetBank( "sandhill" )
    anim:PlayAnimation("idle")

    inst:AddComponent("inspectable")
    -----------------
    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
    ----------------------
    
    inst:AddComponent("inventoryitem")

    inst:AddComponent("blowinwindgust")
    inst.components.blowinwindgust:SetWindSpeedThreshold(TUNING.SAND_WINDBLOWN_SPEED)
    inst.components.blowinwindgust:SetDestroyChance(TUNING.SAND_WINDBLOWN_FALL_CHANCE)
    inst.components.blowinwindgust:SetDestroyFn(ongustblowawayfn)
    inst.components.blowinwindgust:Start()



    ---------------------        

    if GetPlayer() then
        MakeEquippable(inst)
    end
    
    return inst
end

return Prefab( "common/inventory/sand", sandfn, assets)
