/*prettydiff.com topcoms:true,insize:4,inchar:" ",vertical:true */
/*jshint laxbreak: true*/
/*global ace, define, global, module*/
/***********************************************************************
 csspretty is written by Austin Cheney on 7 Aug 2014.  Anybody may use
 this code without permission so long as this comment exists verbatim in
 each instance of its use.

 http://mailmarkup.org/
 http://prettydiff.com/
 **********************************************************************/
/*
 This application beautifies CSS code as well as SCSS (Sass) and LESS
 variants. This application was written with extension in mind using the
 same array based architecture used for the markuppretty and jspretty
 libraries.  The architecture focuses on separation of roles.  The first
 area of the application reads the code and writes an array of tokens.
 The second area is the algorithm that determines what white space and
 indentation should be applied.  The final area is a report on the
 analysis of the code.
 -----------------------------------------------------------------------
 */
(function () {
    "use strict";
    var csspretty = function csspretty_(options) {
        var token      = [],
            types      = [],
            lines      = [],
            depth      = [],
            begin      = [],
            uri        = [],
            colors     = [],
            output     = "",
            endline    = false,
            objsortop  = false,
            verticalop = false,
            colorNames = {
                aliceblue           : 0.9288006825347457,
                antiquewhite        : 0.8464695170775405,
                aqua                : 0.7874,
                aquamarine          : 0.8078549208338043,
                azure               : 0.9726526495416643,
                beige               : 0.8988459998705021,
                bisque              : 0.8073232737297876,
                black               : 0,
                blanchedalmond      : 0.8508443960815607,
                blue                : 0.0722,
                blueviolet          : 0.12622014321946043,
                brown               : 0.09822428787651079,
                burlywood           : 0.5155984453389335,
                cadetblue           : 0.29424681085422044,
                chartreuse          : 0.7603202590262282,
                chocolate           : 0.23898526114557292,
                coral               : 0.3701793087292368,
                cornflowerblue      : 0.30318641994179363,
                cornsilk            : 0.9356211037296492,
                crimson             : 0.16042199953025577,
                cyan                : 0.7874,
                darkblue            : 0.018640801980939217,
                darkcyan            : 0.2032931783904645,
                darkgoldenrod       : 0.27264703559992554,
                darkgray            : 0.39675523072562674,
                darkgreen           : 0.09114342904757505,
                darkgrey            : 0.39675523072562674,
                darkkhaki           : 0.45747326349994155,
                darkmagenta         : 0.07353047651207048,
                darkolivegreen      : 0.12651920884889156,
                darkorange          : 0.40016167026523863,
                darkorchid          : 0.1341314217485677,
                darkred             : 0.05488967453113126,
                darksalmon          : 0.4054147156338075,
                darkseagreen        : 0.43789249325969054,
                darkslateblue       : 0.06579284622798763,
                darkslategray       : 0.06760815192804355,
                darkslategrey       : 0.06760815192804355,
                darkturquoise       : 0.4874606277449034,
                darkviolet          : 0.10999048339343433,
                deeppink            : 0.2386689582827583,
                deepskyblue         : 0.444816033955754,
                dimgray             : 0.14126329114027164,
                dimgrey             : 0.14126329114027164,
                dodgerblue          : 0.2744253699145608,
                firebrick           : 0.10724525535015225,
                floralwhite         : 0.9592248482500424,
                forestgreen         : 0.18920812076002244,
                fuchsia             : 0.2848,
                gainsboro           : 0.7156935005064806,
                ghostwhite          : 0.9431126188632283,
                gold                : 0.6986087742815887,
                goldenrod           : 0.41919977809568404,
                gray                : 0.21586050011389915,
                green               : 0.15438342968146068,
                greenyellow         : 0.8060947261145331,
                grey                : 0.21586050011389915,
                honeydew            : 0.9633653555478173,
                hotpink             : 0.3465843816971475,
                indianred           : 0.21406134963884,
                indigo              : 0.031075614863369846,
                ivory               : 0.9907127060061531,
                khaki               : 0.7701234339412052,
                lavendar            : 0.8031875051452125,
                lavendarblush       : 0.9017274863104644,
                lawngreen           : 0.7390589312496334,
                lemonchiffon        : 0.9403899224562171,
                lightblue           : 0.6370914128080659,
                lightcoral          : 0.35522120733134843,
                lightcyan           : 0.9458729349482863,
                lightgoldenrodyellow: 0.9334835101829635,
                lightgray           : 0.651405637419824,
                lightgreen          : 0.6909197995686475,
                lightgrey           : 0.651405637419824,
                lightpink           : 0.5856615273489745,
                lightsalmon         : 0.47806752252059587,
                lightseagreen       : 0.3505014511704197,
                lightskyblue        : 0.5619563761833096,
                lightslategray      : 0.23830165007286924,
                lightslategrey      : 0.23830165007286924,
                lightyellow         : 0.9816181839288161,
                lime                : 0.7152,
                limegreen           : 0.44571042246097864,
                linen               : 0.8835734098437936,
                magenta             : 0.2848,
                maroon              : 0.04589194232421496,
                mediumaquamarine    : 0.4938970331080111,
                mediumblue          : 0.04407778021232784,
                mediumorchid        : 0.21639251153773428,
                mediumpurple        : 0.22905858091648004,
                mediumseagreen      : 0.34393112338131226,
                mediumslateblue     : 0.20284629471622434,
                mediumspringgreen   : 0.7070430819418444,
                mediumturquois      : 0.5133827926447991,
                mediumvioletred     : 0.14371899849357186,
                midnightblue        : 0.020717866350860484,
                mintcream           : 0.9783460494758793,
                mistyrose           : 0.8218304785918541,
                moccasin            : 0.8008300099156694,
                navajowhite         : 0.7651968234278562,
                navy                : 0.015585128108223519,
                oldlace             : 0.9190063340554899,
                olive               : 0.20027537200567563,
                olivedrab           : 0.2259315095192918,
                orange              : 0.48170267036309605,
                orangered           : 0.2551624375341641,
                orchid              : 0.3134880676143873,
                palegoldenrod       : 0.7879264788761452,
                palegreen           : 0.7793675900635259,
                paleturquoise       : 0.764360779217138,
                palevioletred       : 0.2875499411788909,
                papayawhip          : 0.8779710019983541,
                peachpuff           : 0.7490558987825108,
                peru                : 0.3011307487793569,
                pink                : 0.6327107070246611,
                plum                : 0.4573422158796909,
                powderblue          : 0.6825458650060524,
                purple              : 0.061477070432438476,
                red                 : 0.2126,
                rosyblue            : 0.3231945764940708,
                royalblue           : 0.16663210743188323,
                saddlebrown         : 0.09792228502052071,
                salmon              : 0.3697724152759545,
                sandybrown          : 0.46628543696283414,
                seagreen            : 0.1973419970627483,
                seashell            : 0.927378622069223,
                sienna              : 0.13697631337097677,
                silver              : 0.527115125705813,
                skyblue             : 0.5529166851818412,
                slateblue           : 0.14784278062136097,
                slategray           : 0.20896704076536138,
                slategrey           : 0.20896704076536138,
                slightsteelblue     : 0.5398388828466575,
                snow                : 0.9653334183484877,
                springgreen         : 0.7305230606852947,
                steelblue           : 0.20562642207624846,
                tan                 : 0.48237604163921527,
                teal                : 0.1699685577896842,
                thistle             : 0.5681840109373312,
                tomato              : 0.3063861271941505,
                turquoise           : 0.5895536427577983,
                violet              : 0.40315452986676303,
                wheat               : 0.7490970282048214,
                white               : 1,
                whitesmoke          : 0.913098651793419,
                yellow              : 0.9278,
                yellowgreen         : 0.5076295720870697
            },
            stats      = {
                braces    : 0,
                colon     : 0,
                comments  : {
                    chars: 0,
                    count: 0
                },
                properties: {
                    chars: 0,
                    count: 0
                },
                selectors : {
                    chars: 0,
                    count: 0
                },
                semi      : 0,
                space     : 0,
                values    : {
                    chars: 0,
                    count: 0
                },
                variables : {
                    chars: 0,
                    count: 0
                }
            },
            lf         = (options.crlf === true || options.crlf === "true")
                ? "\r\n"
                : "\n";
        (function csspretty__options() {
            objsortop      = (options.objsort === true || options.objsort === "true" || options.objsort === "all" || options.objsort === "css");
            verticalop     = (options.compressedcss === false && (options.vertical === true || options.vertical === "true" || options.vertical === "all" || options.vertical === "css"));
            options.source = (typeof options.source === "string" && options.source.length > 0)
                ? options
                    .source
                    .replace(/\r\n?/g, "\n") + " "
                : "Error: no source code supplied to csspretty!";
        }());
        if (typeof options.source !== "string" || options.source === "" || (/^(\s+)$/).test(options.source) === true) {
            if (options.nodeasync === true) {
                return [options.source, "Error: no source supplied to csspretty."];
            }
            if (global.prettydiff.meta === undefined) {
                global.prettydiff.meta = {};
            }
            global.prettydiff.meta.error = options.source;
            return options.source;
        }
        (function csspretty__tokenize() {
            var a          = 0,
                b          = options
                    .source
                    .split(""),
                len        = options.source.length,
                ltype      = "",
                itemsize   = 0,
                space      = "",
                endtest    = false,
                struct     = [0],
                mapper     = [],
                structval  = "root",
                nosort     = [],
                esctest    = function csspretty__tokenize_esctest(xx) {
                    var yy = xx;
                    do {
                        xx -= 1;
                    } while (xx > 0 && b[xx] === "\\");
                    if ((yy - xx) % 2 === 0) {
                        return true;
                    }
                    return false;
                },
                // Since I am already identifying value types this is a good place to do some
                // quick analysis and clean up on certain value conditions. These things are
                // being corrected:
                //  * fractional values missing a leading 0 are    provided a leading 0
                //  * 0 values with a dimension indicator    (px, em) have the dimension
                // indicator    removed
                //  * eliminate unnecessary leading 0s
                //  * url values that are not quoted are wrapped    in double quote characters
                //  * color values are set to lowercase and    reduced from 6 to 3 digits if
                // appropriate
                value = function csspretty__tokenize_item_value(val, font) {
                    var x         = val.split(""),
                        leng      = x.length,
                        cc        = 0,
                        dd        = 0,
                        items     = [],
                        block     = "",
                        values    = [],
                        qchar     = "",
                        qreg      = {},
                        colorPush = function csspretty__tokenize_item_value_colorPush(value) {
                            var vl = value.toLowerCase();
                            if ((/^(#[0-9a-f]{3,6})$/).test(vl) === true) {
                                colors.push(value);
                            } else if ((/^(rgba?\()/).test(vl) === true) {
                                colors.push(value);
                            } else if (colorNames[vl] !== undefined) {
                                colors.push(value);
                            }
                            return value;
                        };
                    if (options.quoteConvert === "double") {
                        qchar = "\"";
                    } else if (options.quoteConvert === "single") {
                        qchar = "'";
                    }
                    // this loop identifies containment so that tokens/sub-tokens are correctly taken
                    for (cc = 0; cc < leng; cc += 1) {
                        items.push(x[cc]);
                        if (block === "") {
                            if (x[cc] === "\"") {
                                block = "\"";
                                dd    += 1;
                            } else if (x[cc] === "'") {
                                block = "'";
                                dd    += 1;
                            } else if (x[cc] === "(") {
                                block = ")";
                                dd    += 1;
                            } else if (x[cc] === "[") {
                                block = "]";
                                dd    += 1;
                            }
                        } else if ((x[cc] === "(" && block === ")") || (x[cc] === "[" && block === "]")) {
                            dd += 1;
                        } else if (x[cc] === block) {
                            dd -= 1;
                            if (dd === 0) {
                                block = "";
                            }
                        }
                        if (block === "" && x[cc] === " ") {
                            items.pop();
                            values.push(colorPush(items.join("")));
                            items = [];
                        }
                    }
                    values.push(colorPush(items.join("")));
                    leng = values.length;
                    //This is where the rules mentioned above are applied
                    for (cc = 0; cc < leng; cc += 1) {
                        if (options.noleadzero === false && (/^(\.\d)/).test(values[cc]) === true) {
                            values[cc] = "0" + values[cc];
                        } else if (options.noleadzero === true && (/^(0+\.)/).test(values[cc])) {
                            values[cc] = values[cc].replace(/^(0+\.)/, ".");
                        } else if ((/^(0+([a-z]{2,3}|%))$/).test(values[cc]) === true) {
                            values[cc] = "0";
                        } else if ((/^(0+)/).test(values[cc]) === true) {
                            values[cc] = values[cc].replace(/0+/, "0");
                            if ((/\d/).test(values[cc].charAt(1)) === true) {
                                values[cc] = values[cc].substr(1);
                            }
                        } else if ((/^url\((?!\$)/).test(values[cc]) === true && values[cc].charAt(values[cc].length - 1) === ")") {
                            block = values[cc].charAt(values[cc].indexOf("url(") + 4);
                            if (block !== "@" && block !== "{" && block !== "<") {
                                if (qchar === "") {
                                    values[cc] = values[cc]
                                        .replace(/url\(\s*('|")?/, "url(\"")
                                        .replace(/(('|")?\s*\))$/, "\")");
                                } else {
                                    values[cc] = values[cc]
                                        .replace(/url\(\s*('|")?/, "url(" + qchar)
                                        .replace(/(('|")?\s*\))$/, qchar + ")");
                                }
                            }
                        } else if (font === true) {
                            if (qchar === "'") {
                                values[cc] = values[cc].replace(/"/g, "'");
                            } else {
                                values[cc] = values[cc].replace(/'/g, "\"");
                            }
                        } else if (font === false && qchar !== "" && ((qchar === "\"" && values[cc].charAt(0) === "'" && values[cc].charAt(values[cc].length - 1) === "'") || (qchar === "'" && values[cc].charAt(0) === "\"" && values[cc].charAt(values[cc].length - 1) === "\""))) {
                            qreg       = new RegExp(qchar, "g");
                            values[cc] = qchar + values[cc]
                                .slice(1, values[cc].length - 1)
                                .replace(qreg, "\\" + qchar) + qchar;
                        }
                    }
                    return values.join(" ");
                },
                //map location of empty lines for beautification
                spacer     = function csspretty__tokenize_space(end) {
                    var slen  = space
                            .split(lf)
                            .length - 1,
                        val   = 0;
                    if (token.length === 0 && slen > 0) {
                        slen += 1;
                    }
                    if (slen > 0 && options.preserve > 0) {
                        if (slen > options.preserve) {
                            val = options.preserve + 1;
                        } else {
                            val = slen;
                        }
                    } else if (space.length > 1) {
                        val = 1;
                    } else if (slen === 0 && types[types.length - 1] === "comment" && types[types.length - 2] !== "comment") {
                        types[types.length - 1] = "comment-inline";
                    }
                    if (slen > 1 && end === true && options.preserve > 0) {
                        endline = true;
                        space   = "";
                        return val;
                    }
                    space = "";
                    return val;
                },
                //sort parsed properties intelligently
                objSort    = function csspretty__tokenize_objSort() {
                    var cc        = 0,
                        dd        = 0,
                        ee        = 0,
                        startlen  = token.length - 1,
                        end       = startlen,
                        keys      = [],
                        keylen    = 0,
                        keyend    = 0,
                        start     = 0,
                        sort      = function csspretty__tokenize_objSort_sort(x, y) {
                            var xx = x[0],
                                yy = y[0];
                            if (types[xx] === "comment" || types[xx] === "comment-inline") {
                                do {
                                    xx += 1;
                                } while (xx < startlen && (types[xx] === "comment" || types[xx] === "comment-inline"));
                            }
                            if (types[yy] === "comment" || types[yy] === "comment-inline") {
                                do {
                                    yy += 1;
                                } while (yy < startlen && (types[yy] === "comment" || types[yy] === "comment-inline"));
                            }
                            if (types[xx] < types[yy]) {
                                return -1;
                            }
                            if (types[xx] === types[yy] && token[xx].toLowerCase() < token[yy].toLowerCase()) {
                                return -1;
                            }
                            return 1;
                        },
                        semiTest  = true,
                        pairToken = [],
                        pairTypes = [],
                        pairLines = [],
                        pairDepth = [],
                        pairBegin = [];
                    if (types[end] === "comment" || types[end] === "comment-inline") {
                        do {
                            end -= 1;
                        } while (end > 0 && (types[end] === "comment" || types[end] === "comment-inline"));
                    }
                    for (cc = startlen; cc > -1; cc -= 1) {
                        if (types[cc] === "end") {
                            dd += 1;
                        }
                        if (types[cc] === "start") {
                            dd -= 1;
                        }
                        if (dd === 0) {
                            if ((types[cc] === "property" || types[cc] === "selector" || types[cc] === "propvar") && types[cc - 1] !== "property" && types[cc - 1] !== "selector") {
                                start = cc;
                                if (types[end + 1] === "comment-inline") {
                                    end += 1;
                                }
                                if (types[start - 1] === "comment") {
                                    do {
                                        start -= 1;
                                    } while (start > -1 && types[start - 1] === "comment");
                                }
                                keys.push([
                                    start,
                                    end + 1,
                                    false
                                ]);
                                end = start - 1;
                            }
                        }
                        if (dd < 0 && cc < startlen) {
                            if (keys.length > 1 && (types[cc - 1] === "selector" || types[cc - 1] === "propvar" || (types[cc - 2] ===  "propvar" && types[cc - 1] === "value") || token[cc - 1] === "=" || token[cc - 1] === ":" || token[cc - 1] === "[" || token[cc - 1] === "{" || (token[cc - 1] === "," && structval !== "map") || cc === 0)) {
                                if (structval === "map" && token[token.length - 1] !== ",") {
                                    token.push(",");
                                    types.push("semi");
                                    lines.push(0);
                                    depth.push(depth[depth.length - 1]);
                                    begin.push(begin[begin.length - 1]);
                                    keys[0][1] += 1;
                                }
                                keys.sort(sort);
                                keylen   = keys.length;
                                semiTest = false;
                                for (dd = 0; dd < keylen; dd += 1) {
                                    keyend = keys[dd][1];
                                    for (ee = keys[dd][0]; ee < keyend; ee += 1) {
                                        pairToken.push(token[ee]);
                                        pairTypes.push(types[ee]);
                                        pairLines.push(lines[ee]);
                                        pairDepth.push(depth[ee]);
                                        pairBegin.push(begin[ee]);
                                        if ((token[ee] === ";" && structval === "block") || (token[ee] === "," && structval === "map") || token[ee] === "}") {
                                            semiTest = true;
                                        } else if ((structval === "block" && token[ee] !== ";") && (structval === "map" && token[ee] !== ",") && token[ee] !== "}" && types[ee] !== "comment" && types[ee] !== "comment-inline") {
                                            semiTest = false;
                                        }
                                    }
                                    if (semiTest === false) {
                                        ee = pairTypes.length - 1;
                                        if (pairTypes[ee] === "comment" || pairTypes[ee] === "comment-inline") {
                                            do {
                                                ee -= 1;
                                            } while (ee > 0 && (pairTypes[ee] === "comment" || pairTypes[ee] === "comment-inline"));
                                        }
                                        ee += 1;
                                        if (structval === "map") {
                                            pairToken.splice(ee, 0, ",");
                                        } else {
                                            pairToken.splice(ee, 0, ";");
                                        }
                                        pairTypes.splice(ee, 0, "semi");
                                        pairDepth.splice(ee, 0, pairDepth[ee]);
                                        pairBegin.splice(ee, 0, pairBegin[ee]);
                                        if (pairLines[ee - 1] > 0) {
                                            pairLines[ee - 1] = 0;
                                            pairLines.splice(ee, 0, 1);
                                        } else {
                                            pairLines.splice(ee, 0, 0);
                                        }
                                    }
                                }
                                ee = pairTypes.length - 1;
                                if (pairTypes[ee] === "comment" || pairTypes[ee] === "comment-inline") {
                                    do {
                                        ee -= 1;
                                    } while (ee > 0 && (pairTypes[ee] === "comment" || pairTypes[ee] === "comment-inline"));
                                }
                                keylen = token.length - (cc + 1);
                                token.splice(cc + 1, keylen);
                                types.splice(cc + 1, keylen);
                                lines.splice(cc + 1, keylen);
                                depth.splice(cc + 1, keylen);
                                begin.splice(cc + 1, keylen);
                                token = token.concat(pairToken);
                                types = types.concat(pairTypes);
                                lines = lines.concat(pairLines);
                                depth = depth.concat(pairDepth);
                                begin = begin.concat(pairBegin);
                                if (structval === "map") {
                                    cc = token.length - 1;
                                    if (types[cc].indexOf("comment") === 0) {
                                        do {
                                            cc -= 1;
                                        } while (types[cc].indexOf("comment") === 0);
                                    }
                                    if (token[cc] === ",") {
                                        token.splice(cc, 1);
                                        types.splice(cc, 1);
                                        lines.splice(cc, 1);
                                        depth.splice(cc, 1);
                                        begin.splice(cc, 1);
                                    }
                                }
                            }
                            return;
                        }
                    }
                },
                //the generic token builder
                buildtoken = function csspretty__tokenize_build() {
                    var aa    = 0,
                        bb    = 0,
                        out   = [],
                        block = [],
                        outy  = "",
                        mappy = 0,
                        comma = (token.length > 0 && token[token.length - 1].charAt(token[token.length - 1].length - 1) === ","),
                        linev = spacer(false);
                    //this loop accounts for grouping mechanisms
                    for (aa = a; aa < len; aa += 1) {
                        out.push(b[aa]);
                        if (b[aa - 1] !== "\\" || esctest(aa) === false) {
                            if (b[aa] === "\"" && block[block.length - 1] !== "'") {
                                if (block[block.length - 1] === "\"") {
                                    block.pop();
                                } else {
                                    block.push("\"");
                                }
                            } else if (b[aa] === "'" && block[block.length - 1] !== "\"") {
                                if (block[block.length - 1] === "'") {
                                    block.pop();
                                } else {
                                    block.push("'");
                                }
                            } else if (block[block.length - 1] !== "\"" && block[block.length - 1] !== "'") {
                                if (b[aa] === "(") {
                                    mappy += 1;
                                    block.push(")");
                                } else if (b[aa] === "[") {
                                    block.push("]");
                                } else if (b[aa] === "#" && b[aa + 1] === "{") {
                                    block.push("}");
                                } else if (b[aa] === block[block.length - 1]) {
                                    block.pop();
                                }
                            }
                        }
                        if (structval === "map" && block.length === 0 && (b[aa + 1] === "," || b[aa + 1] === ")")) {
                            if (b[aa + 1] === ")" && token[token.length - 1] === "(") {
                                token.pop();
                                types.pop();
                                lines.pop();
                                depth.pop();
                                begin.pop();
                                struct.pop();
                                structval = depth[depth.length - 1];
                                out = ["("];
                                aa = a - 1;
                            } else {
                                break;
                            }
                        }
                        if (b[aa + 1] === ":") {
                            bb = aa;
                            if ((/\s/).test(b[bb]) === true) {
                                do {
                                    bb -= 1;
                                } while ((/\s/).test(b[bb]) === true);
                            }
                            outy = b
                                .slice(bb - 6, bb + 1)
                                .join("");
                            if (outy.indexOf("filter") === outy.length - 6 || outy.indexOf("progid") === outy.length - 6) {
                                outy = "filter";
                            }
                        }
                        if (block.length === 0 && ((b[aa + 1] === ";" && esctest(aa + 1) === false) || (b[aa + 1] === ":" && b[aa] !== ":" && b[aa + 2] !== ":" && outy !== "filter" && outy !== "progid") || b[aa + 1] === "}" || b[aa + 1] === "{" || (b[aa + 1] === "/" && (b[aa + 2] === "*" || b[aa + 2] === "/")))) {
                            bb = out.length - 1;
                            if ((/\s/).test(out[bb]) === true) {
                                do {
                                    bb -= 1;
                                    aa -= 1;
                                    out.pop();
                                } while ((/\s/).test(out[bb]) === true);
                            }
                            break;
                        }
                        if (out[0] === "@" && block.length === 0 && (b[aa + 1] === "\"" || b[aa + 2] === "'")) {
                            break;
                        }
                    }
                    a        = aa;
                    itemsize = out.length;
                    if (structval === "map" && out[0] === "(") {
                        mapper[mapper.length - 1] -= 1;
                    }
                    if (comma === true && structval !== "map" && types[types.length - 1] !== "comment" && types[types.length - 1] !== "comment-inline") {
                        token[token.length - 1] = token[token.length - 1] + out
                            .join("")
                            .replace(/\s+/g, " ")
                            .replace(/^\s/, "")
                            .replace(/\s$/, "");
                        return;
                    }
                    token.push(out.join("").replace(/\s+/g, " ").replace(/^\s/, "").replace(/\s$/, ""));
                    begin.push(struct[struct.length - 1]);
                    depth.push(structval);
                    lines.push(linev);
                    if (token[token.length - 1].indexOf("extend(") === 0) {
                        ltype = "pseudo";
                        types.push("pseudo");
                    } else if ("\"'".indexOf(token[token.length - 1].charAt(0)) > -1 && types[types.length - 1] === "propvar") {
                        ltype = "item";
                        types.push("value");
                    } else if (out[0] === "@" || out[0] === "$") {
                        if (types[types.length - 1] === "colon" && (types[types.length - 2] === "property" || types[types.length - 2] === "propvar")) {
                            ltype = "value";
                            types.push("value");
                        } else {
                            ltype = "propvar";
                            types.push("propvar");
                            outy = token[token.length - 1];
                            aa   = outy.indexOf("(");
                            if (outy.charAt(outy.length - 1) === ")" && aa > 0) {
                                outy = outy.slice(aa + 1, outy.length - 1);
                                token[token.length - 1] = token[token.length - 1].slice(0, aa + 1) + value(outy, false) + ")";
                            }
                        }
                    } else {
                        ltype = "item";
                        types.push("item");
                    }
                },
                // Some tokens receive a generic type named 'item' because their type is unknown
                // until we know the following syntax.  This function replaces the type 'item'
                // with something more specific.
                item       = function csspretty__tokenize_item(type) {
                    var aa    = types.length,
                        bb    = 0,
                        coms  = [],
                        tokel = (token.length > 1)
                            ? token[token.length - 2]
                            : "",
                        toked = tokel.slice(tokel.length - 2);
                    //backtrack through immediately prior comments to find the correct token
                    if (ltype === "comment" || ltype === "comment-inline") {
                        do {
                            aa    -= 1;
                            ltype = types[aa];
                            coms.push(token[aa]);
                        } while (aa > 0 && (ltype === "comment" || ltype === "comment-inline"));
                    } else {
                        aa -= 1;
                    }
                    //if the last non-comment type is 'item' then id it
                    if (ltype === "item" && types[aa].indexOf("external") < 0) {
                        if (type === "start") {
                            stats.selectors.count += 1;
                            stats.selectors.chars += itemsize;
                            if (types[aa - 1] !== "comment" && types[aa - 1] !== "comment-inline" && types[aa - 1] !== "end" && types[aa - 1] !== "start" && types[aa - 1] !== "semi" && types[aa - 1] !== undefined && types[aa - 1].indexOf("external") < 0) {
                                (function csspretty__tokenize_item_selparts() {
                                    var parts = [],
                                        cc    = aa,
                                        dd    = 0;
                                    do {
                                        parts.push(token[cc]);
                                        if (lines[cc] > 0 && token[cc] === ":" && token[cc - 1] !== ":") {
                                            parts.push(" ");
                                        } else if (token[cc] !== ":") {
                                            parts.push(" ");
                                        }
                                        cc -= 1;
                                    } while (cc > -1 && types[cc] !== "comment" && types[cc] !== "comment-inline" && types[cc] !== "end" && types[cc] !== "start" && types[cc] !== "semi" && types[cc] !== undefined);
                                    parts.reverse();
                                    cc += 1;
                                    dd = aa - cc;
                                    token.splice(cc, dd);
                                    types.splice(cc, dd);
                                    lines.splice(cc, dd);
                                    depth.splice(cc, dd);
                                    begin.splice(cc, dd);
                                    aa        -= dd;
                                    token[aa] = parts
                                        .join("")
                                        .replace(/:\u0020/g, ":")
                                        .replace(/(\s*,\s*)/g, ",");
                                }());
                            } else {
                                token[aa] = token[aa].replace(/(\s*,\s*)/g, ",");
                            }
                            if (options.compressedcss === true) {
                                token[aa] = token[aa]
                                    .replace(/\s*&/, " &")
                                    .replace(/\s*>\s*/g, ">")
                                    .replace(/:\s+/g, ":")
                                    .replace(/^(\s+)/, "")
                                    .replace(/(\s+)$/, "");
                            } else {
                                token[aa] = token[aa]
                                    .replace(/\s*&/, " &")
                                    .replace(/\s*>\s*/g, " > ")
                                    .replace(/:\s+/g, ": ")
                                    .replace(/^(\s+)/, "")
                                    .replace(/(\s+)$/, "");
                            }
                            (function csspretty__tokenize_item_selectorsort() {
                                var y    = 0,
                                    slen = token[aa].length,
                                    z    = "",
                                    mark = 0,
                                    list = [];
                                for (y = 0; y < slen; y += 1) {
                                    if (z === "" && token[aa].charAt(y) === ",") {
                                        list.push(token[aa].slice(mark, y));
                                        mark = y + 1;
                                    } else if (token[aa].charAt(y) === "\"" || token[aa].charAt(y) === "'" || token[aa].charAt(y) === "(" || token[aa].charAt(y) === "{") {
                                        z = token[aa].charAt(y);
                                    } else if (token[aa].charAt(y) === z && (z === "\"" || z === "''")) {
                                        z = "";
                                    } else if (token[aa].charAt(y) === ")" && z === "(") {
                                        z = "";
                                    } else if (token[aa].charAt(y) === "}" && z === "{") {
                                        z = "";
                                    }
                                }
                                list.push(token[aa].slice(mark, y));
                                list.sort();
                                token[aa] = list.join(",");
                            }());
                            types[aa] = "selector";
                            ltype     = "selector";
                        } else if (type === "end") {
                            types[aa] = "value";
                            ltype     = "value";
                            if (options.mode !== "diff") {
                                token[aa] = token[aa].replace(/\s*!\s+important/, " !important");
                                if (options.quoteConvert !== "none" && (token[aa - 2] === "font" || token[aa - 2] === "font-family")) {
                                    token[aa] = value(token[aa], true);
                                } else {
                                    token[aa] = value(token[aa], false);
                                }
                            }
                            //take comments out until the 'item' is found and then put the comments back
                            if (options.mode === "beautify" || options.mode === "parse" || (options.mode === "diff" && options.diffcomments === true)) {
                                if (token[token.length - 2] === "{") {
                                    types[types.length - 1] = "propvar";
                                    stats.values.count      -= 1;
                                    stats.values.chars      -= itemsize;
                                    stats.variables.count   += 1;
                                    stats.variables.chars   += itemsize;
                                } else if (structval === "block") {
                                    if (coms.length > 0 && ltype !== "semi" && ltype !== "end" && ltype !== "start") {
                                        aa = coms.length - 1;
                                        do {
                                            token.pop();
                                            types.pop();
                                            lines.pop();
                                            depth.pop();
                                            begin.pop();
                                            aa -= 1;
                                        } while (aa > 0);
                                        if (options.mode === "diff") {
                                            token.push("x;");
                                        } else {
                                            token.push(";");
                                        }
                                        depth.push(structval);
                                        begin.push(struct[struct.length - 1]);
                                        types.push("semi");
                                        lines.push(spacer(false));
                                        bb = coms.length - 1;
                                        do {
                                            token.push(coms[aa]);
                                            if (coms[aa].indexOf("//") === 0 && lines[lines.length - 1] === 0) {
                                                types.push("comment-inline");
                                            } else {
                                                types.push("comment");
                                            }
                                            depth.push(structval);
                                            begin.push(struct[struct.length - 1]);
                                            lines.push(0);
                                            aa += 1;
                                        } while (aa < bb);
                                    } else {
                                        if (options.mode === "diff") {
                                            token.push("x;");
                                        } else {
                                            token.push(";");
                                        }
                                        depth.push(structval);
                                        begin.push(struct[struct.length - 1]);
                                        types.push("semi");
                                        lines.push(spacer(false));
                                    }
                                }
                            }
                            stats.values.count += 1;
                            stats.values.chars += itemsize;
                        } else if (type === "semi") {
                            if (types[aa - 1] === "colon") {
                                stats.values.count += 1;
                                stats.values.chars += itemsize;
                                types[aa]          = "value";
                                ltype              = "value";
                                if (options.mode !== "diff") {
                                    token[aa] = token[aa].replace(/\s*!\s+important/, " !important");
                                    if (options.quoteConvert !== "none" && (token[aa - 2] === "font" || token[aa - 2] === "font-family")) {
                                        token[aa] = value(token[aa], true);
                                    } else {
                                        token[aa] = value(token[aa], false);
                                    }
                                }
                            } else {
                                //properties without values are considered variables
                                if (types[aa] !== "value") {
                                    if (types[aa] === "item" && types[aa - 1] === "value" && (toked === "}}" || toked === "?>" || toked === "->" || toked === "%}" || toked === "%>")) {
                                        if (isNaN(token[token.length - 1]) === true) {
                                            token[token.length - 2] = tokel + token.pop();
                                        } else {
                                            token[token.length - 2] = tokel + " " + token.pop();
                                        }
                                        types.pop();
                                        return;
                                    }
                                    types[aa] = "propvar";
                                    ltype     = "propvar";
                                }
                                if (token[aa].indexOf("\"") > 0 && token[aa].indexOf("\"")==token[aa].lastIndexOf("\"")) {
                                    bb        = token[aa].indexOf("\"");
                                    a         = a - (token[aa].length - bb);
                                    token[aa] = token[aa].slice(0, bb);
                                    buildtoken();
                                } else if (token[aa].indexOf("'") > 0 && token[aa].indexOf("\"")==token[aa].lastIndexOf("'")) {
                                    bb        = token[aa].indexOf("'");
                                    a         = a - (token[aa].length - bb);
                                    token[aa] = token[aa].slice(0, bb);
                                    buildtoken();
                                } else if ((/\s/).test(token[aa]) === true) {
                                    bb        = token[aa]
                                        .replace(/\s/, " ")
                                        .indexOf(" ");
                                    if (bb < token[aa].indexOf("(") && bb < token[aa].indexOf("[")) {
                                        a         = a - (token[aa].length - bb);
                                        token[aa] = token[aa].slice(0, bb);
                                        buildtoken();
                                    }
                                }
                                stats.variables.count += 1;
                                stats.variables.chars += itemsize;
                            }
                        } else if (type === "colon") {
                            types[aa]              = "property";
                            ltype                  = "property";
                            stats.properties.count += 1;
                            stats.properties.chars += itemsize;
                        } else if (token[aa].charAt(0) === "@" && ((types[aa - 2] !== "propvar" && types[aa - 2] !== "property") || types[aa - 1] === "semi")) {
                            types[aa] = "propvar";
                            ltype     = "propvar";
                        }
                    }
                },
                external   = function csspretty__tokenize_external(open, end) {
                    var store  = [],
                        quote  = "",
                        name   = "",
                        endlen = 0,
                        start  = open.length,
                        linev  = spacer(false),
                        exit   = function csspretty__tokenize_external_exit(typename) {
                            var endtype = types[types.length - 2];
                            if (ltype === "item") {
                                if (endtype === "colon") {
                                    types[types.length - 1] = "value";
                                } else {
                                    item(endtype);
                                }
                            }
                            types.push(typename);
                        };
                    nosort[nosort.length - 1] = true;
                    for (a = a; a < len; a += 1) {
                        store.push(b[a]);
                        if (quote === "") {
                            if (b[a] === "\"") {
                                quote = "\"";
                            } else if (b[a] === "'") {
                                quote = "'";
                            } else if (b[a] === "/") {
                                if (b[a + 1] === "/") {
                                    quote = "/";
                                } else if (b[a + 1] === "*") {
                                    quote = "*";
                                }
                            } else if (b[a + 1] === end.charAt(0)) {
                                do {
                                    endlen += 1;
                                    a      += 1;
                                    store.push(b[a]);
                                } while (a < len && endlen < end.length && b[a + 1] === end.charAt(endlen));
                                if (endlen === end.length) {
                                    quote = store.join("");
                                    if ((/\s/).test(quote.charAt(start)) === true) {
                                        do {
                                            start += 1;
                                        } while ((/\s/).test(quote.charAt(start)) === true);
                                    }
                                    endlen = start;
                                    do {
                                        endlen += 1;
                                    } while (endlen < end.length && (/\s/).test(quote.charAt(endlen)) === false);
                                    if (endlen === quote.length) {
                                        endlen -= end.length;
                                    }
                                    if (open === "{%") {
                                        if (quote.indexOf("{%-") === 0) {
                                            quote = quote
                                                .replace(/^(\{%-\s*)/, "{%- ")
                                                .replace(/(\s*-%\})$/, " -%}");
                                            name  = quote.slice(4);
                                        } else {
                                            quote = quote
                                                .replace(/^(\{%\s*)/, "{% ")
                                                .replace(/(\s*%\})$/, " %}");
                                            name  = quote.slice(3);
                                        }
                                    }
                                    if (open === "{{") {
                                        quote = quote
                                            .replace(/^(\{\{\s+)/, "{{")
                                            .replace(/(\s+\}\})$/, "}}");
                                    }
                                    if (ltype === "item" && types[types.length - 2] === "colon" && (types[types.length - 3] === "property" || types[types.length - 3] === "propvar")) {
                                        ltype = "value";
                                        types[types.length - 1] = "value";
                                        if (isNaN(token[token.length - 1]) === true && token[token.length - 1].charAt(token[token.length - 1].length - 1) !== ")") {
                                            token[token.length - 1] = token[token.length - 1] + quote;
                                        } else {
                                            token[token.length - 1] = token[token.length - 1] + " " + quote;
                                        }
                                        return;
                                    }
                                    lines.push(linev);
                                    token.push(quote);
                                    begin.push(struct[struct.length - 1]);
                                    depth.push(structval);
                                    if (open === "{%") {
                                        name = name.slice(0, name.indexOf(" "));
                                        if (name.indexOf("(") > 0) {
                                            name = name.slice(0, name.indexOf("("));
                                        }
                                        store = [
                                            "autoescape",
                                            "block",
                                            "capture",
                                            "case",
                                            "comment",
                                            "embed",
                                            "filter",
                                            "for",
                                            "form",
                                            "if",
                                            "macro",
                                            "paginate",
                                            "raw",
                                            "sandbox",
                                            "spaceless",
                                            "tablerow",
                                            "unless",
                                            "verbatim"
                                        ];
                                        if (name === "else" || name === "elseif" || name === "when" || name === "elif") {
                                            return exit("external_else");
                                        }
                                        for (endlen = store.length - 1; endlen > -1; endlen -= 1) {
                                            if (name === store[endlen]) {
                                                return exit("external_start");
                                            }
                                            if (name === "end" + store[endlen]) {
                                                return exit("external_end");
                                            }
                                        }
                                    } else if (open === "{{") {
                                        name   = quote.slice(2);
                                        endlen = name.length;
                                        start  = 0;
                                        do {
                                            start += 1;
                                        } while (start < endlen && (/\s/).test(name.charAt(start)) === false && name.charAt(start) !== "(");
                                        name = name.slice(0, start);
                                        if (name.charAt(name.length - 2) === "}") {
                                            name = name.slice(0, name.length - 2);
                                        }
                                        if (name === "end") {
                                            return exit("external_end");
                                        }
                                        if (name === "block" || name === "define" || name === "form" || name === "if" || name === "range" || name === "with") {
                                            return exit("external_start");
                                        }
                                    }
                                    return exit("external");
                                }
                                endlen = 0;
                            }
                        } else if (quote === b[a]) {
                            if (quote === "\"" || quote === "'") {
                                quote = "";
                            } else if (quote === "/" && (b[a] === "\r" || b[a] === "\n")) {
                                quote = "";
                            } else if (quote === "*" && b[a + 1] === "/") {
                                quote = "";
                            }
                        }
                    }
                },
                //finds comments include those JS looking '//' comments
                comment    = function csspretty__tokenize_comment(inline) {
                    var aa        = 0,
                        bb        = 0,
                        out       = [b[a]],
                        type      = "comment",
                        extra     = "",
                        spareType = [],
                        spareToke = [],
                        spareLine = [],
                        spareBegn = [],
                        spareDept = [],
                        linev     = spacer(false);
                    type = (inline === true && linev === 0)
                        ? "comment-inline"
                        : "comment";
                    for (aa = a + 1; aa < len; aa += 1) {
                        out.push(b[aa]);
                        if ((inline === false && b[aa - 1] === "*" && b[aa] === "/") || (inline === true && (b[aa + 1] === "\n" || b[aa + 1] === "\r"))) {
                            break;
                        }
                    }
                    if (ltype === "item") {
                        bb = aa;
                        do {
                            bb += 1;
                            if (b[bb] === "/") {
                                if (b[bb + 1] === "*" || b[bb + 1] === "/") {
                                    extra = b[bb + 1];
                                } else if (b[bb - 1] === "*" && extra === "*") {
                                    extra = "";
                                    bb    += 1;
                                }
                            } else if ((b[bb] === "\n" || b[bb] === "\r") && extra === "/") {
                                extra = "";
                                bb    += 1;
                            }
                        } while (bb < len && ((extra === "" && (/\s/).test(b[bb]) === true) || extra !== ""));
                        if (b[bb] === "{") {
                            item("start");
                        } else if (b[bb] === "}") {
                            item("end");
                        } else if (b[bb] === ";") {
                            item("semi");
                        } else if (b[bb] === ":") {
                            item("colon");
                        } else {
                            item();
                        }
                    }
                    a                    = aa;
                    stats.comments.count += 1;
                    stats.comments.chars += out.length;
                    if (options.mode === "minify") {
                        out.push(lf);
                    }
                    if (options.mode === "beautify" || options.mode === "parse" || (options.mode === "diff" && options.diffcomments === true) || (options.mode === "minify" && options.topcoms === true)) {
                        if (token.length > 0 && (ltype === "selector" || ltype === "propvar") && types[types.length - 1] !== "comment" && types[types.length - 1] !== "comment-inline") {
                            spareToke.push(token[token.length - 1]);
                            token.pop();
                            types.pop();
                            lines.pop();
                            begin.pop();
                            depth.pop();
                            begin.push(struct[struct.length - 1]);
                            depth.push(structval);
                            token.push(out.join(""));
                            types.push(type);
                            lines.push(linev);
                            begin.push(struct[struct.length - 1]);
                            depth.push(structval);
                            token.push(spareToke[0]);
                            if (ltype === "propvar") {
                                types.push("propvar");
                            } else {
                                types.push("selector");
                            }
                            lines.push(0);
                        } else if (ltype === "colon" || ltype === "property" || ltype === "value" || ltype === "propvar") {
                            do {
                                spareToke.push(token[token.length - 1]);
                                spareType.push(types[types.length - 1]);
                                spareLine.push(lines[lines.length - 1]);
                                spareDept.push(depth[depth.length - 1]);
                                spareBegn.push(begin[begin.length - 1]);
                                token.pop();
                                types.pop();
                                lines.pop();
                                depth.pop();
                                begin.pop();
                            } while (types.length > 1 && types[types.length - 1] !== "semi" && types[types.length - 1] !== "start");
                            token.push(out.join(""));
                            types.push(type);
                            lines.push(linev);
                            depth.push(structval);
                            begin.push(struct[struct.length - 1]);
                            do {
                                token.push(spareToke[spareToke.length - 1]);
                                types.push(spareType[spareType.length - 1]);
                                lines.push(spareLine[spareLine.length - 1]);
                                depth.push(spareDept[spareDept.length - 1]);
                                begin.push(spareBegn[spareBegn.length - 1]);
                                spareToke.pop();
                                spareType.pop();
                                spareLine.pop();
                                spareDept.pop();
                                spareBegn.pop();
                            } while (spareToke.length > 0);
                        } else {
                            ltype = type;
                            types.push(type);
                            token.push(out.join(""));
                            lines.push(linev);
                            depth.push(structval);
                            begin.push(struct[struct.length - 1]);
                        }
                    }
                },
                //do fancy things to property types like: sorting, consolidating, and padding
                properties = function csspretty__tokenize_properties() {
                    var aa    = 0,
                        bb    = 1,
                        cc    = 0,
                        dd    = 0,
                        p     = [],
                        set   = [
                            []
                        ],
                        next  = 0,
                        stoke = [],
                        stype = [],
                        sline = [],
                        sdept = [],
                        sbegn = [];
                    //identify properties and build out prop/val sets
                    for (aa = token.length - 1; aa > -1; aa -= 1) {
                        if (types[aa] === "start") {
                            bb -= 1;
                            if (bb === 0) {
                                next = aa;
                                set.pop();
                                for (aa = set.length - 1; aa > -1; aa -= 1) {
                                    set[aa].reverse();
                                }
                                break;
                            }
                        }
                        if (types[aa] === "end") {
                            bb += 1;
                        }
                        if (bb === 1 && (types[aa] === "property" || (types[aa] === "propvar" && types[aa + 1] === "colon")) && options.mode === "beautify") {
                            p.push(aa);
                        }
                        set[set.length - 1].push(aa);
                        if (bb === 1 && (types[aa - 1] === "comment" || types[aa - 1] === "comment-inline" || types[aa - 1] === "semi" || types[aa - 1] === "end" || types[aa - 1] === "start") && types[aa] !== "start" && types[aa] !== "end") {
                            set.push([]);
                        }
                    }
                    //this reverse fixes the order of consecutive comments
                    set.reverse();
                    p.reverse();

                    //consolidate margin and padding
                    (function csspretty__tokenize_properties_propcheck() {
                        var leng      = set.length,
                            fourcount = function csspretty__tokenize_properties_propcheck_fourcount(name) {
                                var test      = [
                                        false, false, false, false
                                    ],
                                    val       = [
                                        "0", "0", "0", "0"
                                    ],
                                    zero      = (/^(0+([a-z]+|%))/),
                                    start     = aa,
                                    yy        = -1,
                                    zz        = 0,
                                    valsplit  = [],
                                    store     = function csspretty__tokenize_properties_propcheck_fourcount_store(side) {
                                        yy         += 1;
                                        val[side]  = token[set[aa][2]];
                                        test[side] = true;
                                        if (start < 0) {
                                            start = aa;
                                        }
                                    };
                                for (aa = aa; aa < leng; aa += 1) {
                                    if (token[set[aa][2]] !== undefined && token[set[aa][0]].indexOf(name) === 0) {
                                        if (token[set[aa][0]] === name || token[set[aa][0]].indexOf(name + " ") === 0) {
                                            yy       += 1;
                                            valsplit = token[set[aa][2]].split(" ");
                                            if (valsplit.length === 1) {
                                                val = [
                                                    token[set[aa][2]],
                                                    token[set[aa][2]],
                                                    token[set[aa][2]],
                                                    token[set[aa][2]]
                                                ];
                                            } else if (valsplit.length === 2) {
                                                val = [valsplit[0], valsplit[1], valsplit[0], valsplit[1]];
                                            } else if (valsplit.length === 3) {
                                                val = [valsplit[0], valsplit[1], valsplit[2], valsplit[1]];
                                            } else if (valsplit.length === 4) {
                                                val = [valsplit[0], valsplit[1], valsplit[2], valsplit[3]];
                                            } else {
                                                return;
                                            }
                                            test = [true, true, true, true];
                                        } else if (token[set[aa][0]].indexOf(name + "-bottom") === 0) {
                                            store(2);
                                        } else if (token[set[aa][0]].indexOf(name + "-left") === 0) {
                                            store(3);
                                        } else if (token[set[aa][0]].indexOf(name + "-right") === 0) {
                                            store(1);
                                        } else if (token[set[aa][0]].indexOf(name + "-top") === 0) {
                                            store(0);
                                        }
                                    }
                                    if (set[aa + 1] === undefined || token[set[aa + 1][0]].indexOf(name) < 0 || aa === leng - 1) {
                                        if (test[0] === true && test[1] === true && test[2] === true && test[3] === true) {
                                            set.splice(start + 1, yy);
                                            leng -= yy;
                                            aa   -= yy;
                                            zz   = 0;
                                            bb   = p.length;
                                            do {
                                                if (p[zz] === set[start][0]) {
                                                    break;
                                                }
                                                zz += 1;
                                            } while (zz < bb);
                                            if (zz < bb) {
                                                p.splice(zz + 1, yy);
                                            }
                                            token[set[start][0]] = name;
                                            if (zero.test(val[0]) === true) {
                                                val[0] = "0";
                                            }
                                            if (zero.test(val[1]) === true) {
                                                val[1] = "0";
                                            }
                                            if (zero.test(val[2]) === true) {
                                                val[2] = "0";
                                            }
                                            if (zero.test(val[3]) === true) {
                                                val[3] = "0";
                                            }
                                            if (val[1] === val[3]) {
                                                val.pop();
                                                if (val[0] === val[2]) {
                                                    val.pop();
                                                    if (val[0] === val[1]) {
                                                        val.pop();
                                                    }
                                                }
                                            }
                                            token[set[start][2]] = val.join(" ");
                                            if (token[set[start][2]].indexOf("!important") > 0) {
                                                token[set[start][2]] = token[set[start][2]].replace(/\s!important/g, "") + " !important";
                                            }
                                            if (options.mode === "beautify" && verticalop === true) {
                                                if (token[set[start][0]].charAt(token[set[start][0]].length - 1) === " ") {
                                                    yy = token[set[start][0]].length - name.length;
                                                    do {
                                                        name = name + " ";
                                                        yy   -= 1;
                                                    } while (yy > 0);
                                                }
                                            }
                                        }
                                        break;
                                    }
                                }
                            };
                        for (aa = 0; aa < leng; aa += 1) {
                            if (types[set[aa][0]] === "property") {
                                if (token[set[aa][0]].indexOf("margin") === 0) {
                                    fourcount("margin");
                                }
                                if (token[set[aa][0]].indexOf("padding") === 0) {
                                    fourcount("padding");
                                }
                            }
                        }
                    }());

                    //pad out those property names so that the colons are vertically aligned
                    if (verticalop === true) {
                        bb = 0;
                        for (aa = p.length - 1; aa > -1; aa -= 1) {
                            if (token[p[aa]].length > bb && token[p[aa]] !== "filter" && token[p[aa]] !== "progid") {
                                bb = token[p[aa]].length;
                            }
                        }
                        for (aa = p.length - 1; aa > -1; aa -= 1) {
                            cc = bb - token[p[aa]].length;
                            if (cc > 0 && token[p[aa]] !== "filter" && token[p[aa]] !== "progid") {
                                do {
                                    token[p[aa]] = token[p[aa]] + " ";
                                    cc           -= 1;
                                } while (cc > 0);
                            }
                        }
                        if (endtest === false) {
                            return;
                        }
                    }

                    bb = set.length;
                    for (aa = 0; aa < bb; aa += 1) {
                        dd = set[aa].length;
                        for (cc = 0; cc < dd; cc += 1) {
                            stoke.push(token[set[aa][cc]]);
                            stype.push(types[set[aa][cc]]);
                            sline.push(lines[set[aa][cc]]);
                            sdept.push(depth[set[aa][cc]]);
                            sbegn.push(begin[set[aa][cc]]);
                        }
                    }
                    //replace a block's data with sorted analyzed data
                    token.splice(next + 1, token.length - next - 1);
                    types.splice(next + 1, types.length - next - 1);
                    lines.splice(next + 1, lines.length - next - 1);
                    depth.splice(next + 1, depth.length - next - 1);
                    begin.splice(next + 1, begin.length - next - 1);
                    token = token.concat(stoke);
                    types = types.concat(stype);
                    lines = lines.concat(sline);
                    depth = depth.concat(sdept);
                    begin = begin.concat(sbegn);
                };
            //token building loop
            for (a = 0; a < len; a += 1) {
                if (ltype !== "comment" && ltype !== "comment-inline" && ltype !== "" && options.topcoms === true) {
                    options.topcoms = false;
                }
                if ((/\s/).test(b[a]) === true) {
                    stats.space += 1;
                    space       += b[a];
                } else if (b[a] === "/" && b[a + 1] === "*") {
                    comment(false);
                } else if (b[a] === "/" && b[a + 1] === "/") {
                    comment(true);
                } else if (b[a] === "<" && b[a + 1] === "?" && b[a + 2] === "p" && b[a + 3] === "h" && b[a + 4] === "p") {
                    //php
                    external("<?php", "?>");
                } else if (b[a] === "<" && b[a + 1] === "%") {
                    //asp
                    external("<%", "%>");
                } else if (b[a] === "{" && b[a + 1] === "%") {
                    //asp
                    external("{%", "%}");
                } else if (b[a] === "{" && b[a + 1] === "{" && b[a + 2] === "{") {
                    //mustache
                    external("{{{", "}}}");
                } else if (b[a] === "{" && b[a + 1] === "{") {
                    //handlebars
                    external("{{", "}}");
                } else if (b[a] === "<" && b[a + 1] === "!" && b[a + 2] === "-" && b[a + 3] === "-" && b[a + 4] === "#") {
                    //ssi
                    external("<!--#", "-->");
                } else if (b[a] === "{" || (b[a] === "(" && token[token.length - 1] === ":" && types[types.length - 2] === "propvar")) {
                    if (b[a] === "{" && token[token.length - 2] === ":") {
                        types[types.length - 1] = "pseudo";
                    }
                    item("start");
                    struct.push(token.length);
                    ltype = "start";
                    types.push("start");
                    token.push(b[a]);
                    begin.push(token.length);
                    if (b[a] === "(") {
                        structval = "map";
                        depth.push("map");
                        mapper.push(0);
                    } else {
                        structval = "block";
                        depth.push("block");
                    }
                    nosort.push(false);
                    lines.push(spacer(false));
                    stats.braces += 1;
                } else if (b[a] === "}" || (b[a] === ")" && structval === "map" && mapper[mapper.length - 1] === 0)) {
                    endtest = true;
                    if (b[a] === "}" && types[types.length - 1] === "item" && token[token.length - 2] === "{" && token[token.length - 3] !== undefined && token[token.length - 3].charAt(token[token.length - 3].length - 1) === "@") {
                        token[token.length - 3] = token[token.length - 3] + "{" + token[token.length - 1] + "}";
                        token.pop();
                        token.pop();
                        types.pop();
                        types.pop();
                        lines.pop();
                        lines.pop();
                        depth.pop();
                        depth.pop();
                        begin.pop();
                        begin.pop();
                    } else {
                        if (b[a] === ")") {
                            mapper.pop();
                        } else if (b[a] === "}" && ltype === "value" && token[token.length - 1] !== ";") {
                            token.push(";");
                            types.push("semi");
                            lines.push(0);
                            depth.push("block");
                            begin.push(begin[begin.length - 1]);
                        }
                        item("end");
                        if (options.mode !== "diff") {
                            properties();
                        }
                        ltype = "end";
                        if (objsortop === true && nosort[nosort.length - 1] === false) {
                            objSort();
                        }
                        nosort.pop();
                        types.push("end");
                        token.push(b[a]);
                        lines.push(spacer(false));
                        depth.push(structval);
                        begin.push(struct[struct.length - 1]);
                        stats.braces += 1;
                    }
                    struct.pop();
                    if (token[struct[struct.length - 1]] === "{") {
                        structval = "block";
                    } else if (token[struct[struct.length - 1]] === "(") {
                        structval = "map";
                    } else {
                        structval = "root";
                    }
                } else if (b[a] === ";" || (b[a] === "," && structval === "map")) {
                    item("semi");
                    if (types[types.length - 1] !== "semi" && types[types.length - 1] !== "start" && esctest(a) === false) {
                        ltype = "semi";
                        types.push("semi");
                        token.push(b[a]);
                        lines.push(spacer(false));
                        depth.push(structval);
                        begin.push(begin[begin.length - 1]);
                    }
                    stats.semi += 1;
                    space      = "";
                } else if (b[a] === ":" && types[types.length - 1] !== "end") {
                    item("colon");
                    types.push("colon");
                    token.push(":");
                    if ((/\s/).test(b[a - 1]) === true) {
                        lines.push(1);
                    } else {
                        lines.push(0);
                    }
                    ltype       = "colon";
                    stats.colon += 1;
                    space       = "";
                } else {
                    if (structval === "map" && b[a] === "(") {
                        mapper[mapper.length - 1] += 1;
                    }
                    buildtoken();
                }
            }
            if (endtest === false && verticalop === true) {
                properties();
            }
        }());

        if (options.mode === "parse") {
            return (function csspretty__parse() {
                var a      = 0,
                    c      = token.length,
                    record = [],
                    def    = {
                        token: "string - The parsed code tokens",
                        types: "string - Data types of the tokens: colon, comment, comment-inline, end, external, external_else, external_end, external_start, item, propvar, pseudo, selector, semi, start, value",
                        lines: "number - Whether the token is preceeded any space and/or line breaks in the original code source",
                        depth: "string - Type of current structure",
                        begin: "number - Index where current structure begins"
                    };
                if (options.parseFormat === "sequential") {
                    for (a = 0; a < c; a += 1) {
                        record.push([token[a], types[a], lines[a], depth[a], begin[a]]);
                    }
                    if (options.nodeasync === true) {
                        return [{
                            data      : record,
                            definition: def
                        }, ""];
                    }
                    return {
                        data      : record,
                        definition: def
                    };
                }
                if (options.parseFormat === "htmltable") {
                    return (function csspretty__parse_html() {
                        var report = [],
                            aa = 0,
                            len = 0;
                        report.push("<table summary='CSS parse table'><thead><tr><th>index</th>");
                        report.push("<th>token</th>");
                        report.push("<th>types</th>");
                        report.push("<th>lines</th>");
                        report.push("<th>depth</th>");
                        report.push("<th>begin</th>");
                        report.push("</tr></thead><tbody>");
                        len = token.length;
                        for (aa = 0; aa < len; aa += 1) {
                            report.push("<tr><td>");
                            report.push(aa);
                            report.push("</td><td>");
                            report.push(token[aa].replace(/&/g, "&amp;").replace(/>/g, "&gt;").replace(/</g, "&lt;"));
                            report.push("</td><td>");
                            report.push(types[aa]);
                            report.push("</td><td>");
                            report.push(lines[aa]);
                            report.push("</td><td>");
                            report.push(depth[aa]);
                            report.push("</td><td>");
                            report.push(begin[aa]);
                            report.push("</td></tr>");
                        }
                        report.push("</tbody></table>");
                        if (options.nodeasync === true) {
                            return [{
                                data      : report.join(""),
                                definition: def
                            }, ""];
                        }
                        return {
                            data      : report.join(""),
                            definition: def
                        };
                    }());
                }
                if (options.nodeasync === true) {
                    return [{
                        data      : {
                            token: token,
                            types: types,
                            lines: lines,
                            depth: depth,
                            begin: begin
                        },
                        definition: def
                    }, ""];
                }
                return {
                    data      : {
                        token: token,
                        types: types,
                        lines: lines,
                        depth: depth,
                        begin: begin
                    },
                    definition: def
                };
            }());
        }

        //analysis
        if (options.mode === "analysis") {
            return (function csspretty__summary() {
                var summ  = [],
                    inl   = options.source.length,
                    out   = output.length,
                    uris  = uri.length,
                    uric  = 0,
                    a     = 0,
                    b     = 0,
                    color = [];
                (function csspretty_summary_colorNormalize() {
                    var aa = 0,
                        bb = 0,
                        cc = colors.length;
                    colors.sort();
                    color.push(colors[0]);
                    for (aa = 0; aa < cc; aa += 1) {
                        if (colors[aa] !== color[bb]) {
                            color.push(colors[aa]);
                            bb += 1;
                        }
                    }
                }());
                summ.push("<div class='report' id='cssreport'><p><strong>Number of HTTP requests:</strong> " +
                        "<em>");
                summ.push(uris);
                summ.push("</em></p><table class='analysis' id='css-parts' summary='Component counts and si" +
                        "zes'><caption>Component counts and sizes</caption><thead><tr><th>Type Name</th><" +
                        "th>Quantity</th><th>Character Size</th></tr></thead><tbody><tr><th>curly braces<" +
                        "/th><td>");
                summ.push(stats.braces);
                summ.push("</td><td>");
                summ.push(stats.braces);
                summ.push("</td></tr><tr><th>colon</th><td>");
                summ.push(stats.colon);
                summ.push("</td><td>");
                summ.push(stats.colon);
                summ.push("</td></tr><tr><th>comments</th><td>");
                summ.push(stats.comments.count);
                summ.push("</td><td>");
                summ.push(stats.comments.chars);
                summ.push("</td></tr><tr><th>properties</th><td>");
                summ.push(stats.properties.count);
                summ.push("</td><td>");
                summ.push(stats.properties.chars);
                summ.push("</td></tr><tr><th>selectors</th><td>");
                summ.push(stats.selectors.count);
                summ.push("</td><td>");
                summ.push(stats.selectors.chars);
                summ.push("</td></tr><tr><th>semicolons</th><td>");
                summ.push(stats.semi);
                summ.push("</td><td>");
                summ.push(stats.semi);
                summ.push("</td></tr><tr><th>white space</th><td>");
                summ.push(stats.space);
                summ.push("</td><td>");
                summ.push(stats.space);
                summ.push("</td></tr><tr><th>values</th><td>");
                summ.push(stats.values.count);
                summ.push("</td><td>");
                summ.push(stats.values.chars);
                summ.push("</td></tr><tr><th>variables</th><td>");
                summ.push(stats.variables.count);
                summ.push("</td><td>");
                summ.push(stats.variables.chars);
                summ.push("</td></tr></tbody></table><table class='analysis' id='css-size' summary='CSS cha" +
                        "racter size change'><caption>CSS character size change</caption><tbody><tr><th>I" +
                        "nput</th><td>");
                summ.push(inl);
                summ.push("</td></tr><tr><th>Output</th><td>");
                summ.push(out);
                summ.push("</td></tr><tr><th>");
                if (out > inl) {
                    summ.push("Increase</th><td>");
                    summ.push(out - inl);
                    summ.push("</td></tr><tr><th>Percent Change</th><td>");
                    a = (((out - inl) / out) * 100);
                    summ.push(a.toFixed(2));
                } else {
                    summ.push("Decrease</th><td>");
                    summ.push(inl - out);
                    summ.push("</td></tr><tr><th>Percent Change</th><td>");
                    a = (((inl - out) / inl) * 100);
                    summ.push(a.toFixed(2));
                }
                summ.push("%</td></tr></tbody></table><table class='analysis' id='css-uri' summary='A list " +
                        "of HTTP requests'><caption>A List of HTTP Requests</caption><thead><tr><th>Quant" +
                        "ity</th><th>URI</th></tr></thead><tbody>");
                for (a = 0; a < uris; a += 1) {
                    uric = 1;
                    for (b = a + 1; b < uris; b += 1) {
                        if (uri[a] === uri[b]) {
                            uric += 1;
                            uri.splice(b, 1);
                            uris -= 1;
                        }
                    }
                    summ.push("<tr><td>");
                    summ.push(uric);
                    summ.push("</td><td>");
                    summ.push(uri[a].replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt;"));
                    summ.push("</td></tr>");
                }
                summ.push("</tbody></table>");
                summ.push("</div><span class='clear'></span>");
                if (color.length === 0) {
                    summ.push("<h4>0 colors were identified in the provided code.</h4>");
                } else {
                    summ.push("<h4>These ");
                    summ.push(color.length);
                    if (color.length > 1) {
                        summ.push(" different");
                    }
                    summ.push(" color");
                    if (color.length > 1) {
                        summ.push("s");
                    }
                    summ.push(" were identified in the provided code:</h4><p>");
                    summ.push(color.join(", "));
                    summ.push("</p>");
                    if (options.accessibility === true) {
                        (function csspretty__summary_colorConvert() {
                            var vl        = "",
                                bb        = color.length,
                                aa        = 0,
                                luminance = function csspretty__summary_colorConvert_luminance(rgb) {
                                    var convert = function csspretty__summary_colorConvert_luminance_convert(x) {
                                        if (x === 0) {
                                            return 0;
                                        }
                                        x = (x / 255);
                                        if ((x * 100000) <= 3928) {
                                            return ((x * 100) / 1292) * 10000;
                                        }
                                        x *= 100000;
                                        return Math.pow(((x + 5500) / 105500), 2.4) * 10000;
                                    };
                                    return ((2126 * convert(rgb[0])) + (7152 * convert(rgb[1])) + (722 * convert(rgb[2]))) / 100000000;
                                },
                                hexToDec  = function csspretty__summary_colorConvert_hexToDec(val) {
                                    var str = val
                                            .slice(1)
                                            .split(""),
                                        rgb = [],
                                        num = [],
                                        aaa = 0,
                                        bbb = str.length;
                                    for (aaa = 0; aaa < bbb; aaa += 1) {
                                        if (str[aaa] === "a") {
                                            num.push(10);
                                        } else if (str[aaa] === "b") {
                                            num.push(11);
                                        } else if (str[aaa] === "c") {
                                            num.push(12);
                                        } else if (str[aaa] === "d") {
                                            num.push(13);
                                        } else if (str[aaa] === "e") {
                                            num.push(14);
                                        } else if (str[aaa] === "f") {
                                            num.push(15);
                                        } else {
                                            num.push(Number(str[aaa]));
                                        }
                                    }
                                    if (bbb === 3) {
                                        rgb.push((num[0] * 16) + num[0]);
                                        rgb.push((num[1] * 16) + num[1]);
                                        rgb.push((num[2] * 16) + num[2]);
                                    } else {
                                        rgb.push((num[0] * 16) + num[1]);
                                        rgb.push((num[2] * 16) + num[3]);
                                        rgb.push((num[4] * 16) + num[5]);
                                    }
                                    return luminance(rgb);
                                },
                                rgbToDec  = function csspretty__summary_colorConvert_rgbToDec(val) {
                                    var rgb  = [],
                                        rgbs = [],
                                        rr   = 0;
                                    if (vl.charAt(3) === "a") {
                                        vl   = vl
                                            .slice(5, vl.length - 1)
                                            .replace(/\s+/g, "");
                                        rgbs = vl.split(",");
                                        rgbs.pop();
                                    } else {
                                        vl   = vl
                                            .slice(4, vl.length - 1)
                                            .replace(/\s+/g, "");
                                        rgbs = vl.split(",");
                                    }
                                    do {
                                        if ((/^([0-9a-f]{2})$/).test(rgbs[rr]) === false) {
                                            if (rgbs[rr].charAt(rgbs[rr].length - 1) === "%") {
                                                vl = rgbs[rr].slice(0, rgbs[rr].length - 1);
                                                if (isNaN(vl) === true) {
                                                    return val;
                                                }
                                                rgb.push(Number(vl));
                                                if (rgb[rr] < 0) {
                                                    rgb[rr] = 0;
                                                } else if (rgb[rr] > 100) {
                                                    rgb[rr] = 100;
                                                }
                                                rgb[rr] = Math.round(2.55 * rgb[rr]);
                                            } else {
                                                if (isNaN(rgbs[rr]) === true) {
                                                    return val;
                                                }
                                                rgb.push(Number(rgbs[rr]));
                                                if (rgb[rr] < 0) {
                                                    rgb[rr] = 0;
                                                } else if (rgb[rr] > 255) {
                                                    rgb[rr] = 255;
                                                }
                                                rgb[rr] = Math.round(rgb[rr]);
                                            }
                                        }
                                        rr += 1;
                                    } while (rr < 3);
                                    return luminance(rgb);
                                };
                            colors = [];
                            for (aa = 0; aa < bb; aa += 1) {
                                if (color[aa] === undefined) {
                                    break;
                                }
                                vl = color[aa].toLowerCase();
                                if ((/^(#[0-9a-f]{3,6})$/).test(vl) === true) {
                                    colors.push(hexToDec(vl.slice(1)));
                                } else if ((/^(rgba?\()/).test(vl) === true) {
                                    colors.push(rgbToDec(vl));
                                } else if (colorNames[vl] !== undefined) {
                                    colors.push(colorNames[vl]);
                                }
                            }
                        }());
                    }
                }
                if (options.nodeasync === true) {
                    return [summ.join(""), ""];
                }
                return summ.join("");
            }());
        }

        //beautification
        if (options.mode !== "minify") {
            output = (function csspretty__beautify() {
                var a        = 0,
                    len      = token.length,
                    build    = [],
                    indent   = options.inlevel,
                    mixin    = false,
                    //a single unit of indentation
                    tab      = (function csspretty__beautify_tab() {
                        var aa = 0,
                            bb = [];
                        for (aa = 0; aa < options.insize; aa += 1) {
                            bb.push(options.inchar);
                        }
                        return bb.join("");
                    }()),
                    //new lines plus indentation
                    nl       = function csspretty__beautify_nl(tabs) {
                        var aa = 0;
                        if (build[build.length - 1] === tab) {
                            do {
                                build.pop();
                            } while (build[build.length - 1] === tab);
                        }
                        build.push(lf);
                        for (aa = 0; aa < tabs; aa += 1) {
                            build.push(tab);
                        }
                    },
                    //breaks selector lists onto newlines
                    selector = function csspretty__beautify_selector(item) {
                        var aa    = 0,
                            bb    = 0,
                            cc    = 0,
                            block = "",
                            items = [],
                            leng  = item.length;
                        if (options.compressedcss === true && (/\)\s*when\s*\(/).test(item) === true) {
                            item = item.replace(/\)\s*when\s*\(/, ")" + lf + (function csspretty__beautify_selector_whenTab() {
                                var wtab = "",
                                    aaa  = indent + 1;
                                do {
                                    wtab += tab;
                                    aaa  -= 1;
                                } while (aaa > 0);
                                return wtab;
                            }()) + "when (");
                        }
                        for (aa = 0; aa < leng; aa += 1) {
                            if (block === "") {
                                if (item.charAt(aa) === "\"") {
                                    block = "\"";
                                    bb    += 1;
                                } else if (item.charAt(aa) === "'") {
                                    block = "'";
                                    bb    += 1;
                                } else if (item.charAt(aa) === "(") {
                                    block = ")";
                                    bb    += 1;
                                } else if (item.charAt(aa) === "[") {
                                    block = "]";
                                    bb    += 1;
                                }
                            } else if ((item.charAt(aa) === "(" && block === ")") || (item.charAt(aa) === "[" && block === "]")) {
                                bb += 1;
                            } else if (item.charAt(aa) === block) {
                                bb -= 1;
                                if (bb === 0) {
                                    block = "";
                                }
                            }
                            if (block === "" && item.charAt(aa) === ",") {
                                items.push(item.substring(cc, aa + 1));
                                cc = aa + 1;
                            }
                        }
                        if (cc > 0) {
                            items.push(item.substr(cc));
                        }
                        leng = items.length;
                        if (leng === 0) {
                            items.push(item);
                        }
                        if (options.selectorlist === true) {
                            build.push(items.join(" "));
                        } else {
                            build.push(items[0].replace(/,(\s*)/g, ", ").replace(/(,\u0020)$/, ","));
                            for (aa = 1; aa < leng; aa += 1) {
                                nl(indent);
                                build.push(items[aa].replace(/,(\s*)/g, ", ").replace(/(,\u0020)$/, ","));
                            }
                        }
                        if (options.compressedcss === false) {
                            build.push(" ");
                        }
                    };
                if (options.inlevel > 0) {
                    a = options.inlevel;
                    do {
                        a -= 1;
                        build.push(tab);
                    } while (a > 0);
                }

                //beautification loop
                for (a = 0; a < len; a += 1) {
                    if (lines[a] > 1 && options.compressedcss === false && (types[a] === "start" || types[a] === "end" || types[a] === "selector" || types[a] === "comment" || types[a] === "property" || types[a] === "propvar" || types[a].indexOf("external") > -1)) {
                        if (options.cssinsertlines === true && types[a] === "selector" && types[a - 1] !== "comment") {
                            lines[a] -= 1;
                        }
                        if (build[build.length - 1] === tab) {
                            do {
                                build.pop();
                            } while (build[build.length - 1] === tab);
                        }
                        if (lines[a] > 1) {
                            if (lines[a] > 2) {
                                do {
                                    lines[a] -= 1;
                                    build.push(lf);
                                } while (lines[a] > 2);
                            }
                            nl(indent);
                        }
                    }
                    if (types[a] === "start") {
                        if (types[a - 1] === "propvar" && options.compressedcss === false) {
                            build.push(" ");
                        }
                        if (a > 0 && token[a - 1].charAt(token[a - 1].length - 1) === "#") {
                            build.push(token[a]);
                        } else {
                            if (options.braces === true) {
                                if (build[build.length - 1] === " ") {
                                    build.pop();
                                }
                                nl(indent);
                            } else if (types[a - 1] === "colon") {
                                build.push(" ");
                            }
                            build.push(token[a]);
                            indent += 1;
                            if (types[a + 1] !== "end" && (options.compressedcss === false || (options.compressedcss === true && types[a + 1] === "start")) && (types[a + 1] !== "selector" || options.cssinsertlines === false)) {
                                nl(indent);
                            }
                        }
                    } else if (types[a] === "end") {
                        if (mixin === true) {
                            mixin = false;
                            build.push(token[a]);
                            build.push(" ");
                        } else {
                            indent -= 1;
                            if (types[a - 1] !== "start" && options.compressedcss === false) {
                                nl(indent);
                            }
                            build.push(token[a]);
                            if (options.compressedcss === true && types[a + 1] === "end") {
                                nl(indent - 1);
                            } else if (options.cssinsertlines === true && types[a + 1] === "selector" && lines[a] < 2 && token[a - 1] !== "{") {
                                build.push(lf);
                            } else if (types[a + 1] !== "end" && types[a + 1] !== "semi" && types[a + 1] !== "comment") {
                                nl(indent);
                            }
                        }
                    } else if (types[a] === "semi") {
                        if (token[a] !== "x;" && (options.compressedcss === false || (options.compressedcss === true && types[a + 1] !== "end"))) {
                            build.push(token[a]);
                        }
                        if (types[a + 1] === "comment-inline") {
                            build.push(" ");
                        } else if (types[a + 1] !== "end" && types[a + 1] !== "comment" && options.compressedcss === false) {
                            if (options.cssinsertlines === true && types[a + 1] === "selector") {
                                build.push(lf);
                            } else if (lines[a + 1] > 0 || (types[a + 1] !== undefined && types[a + 1].indexOf("external") < 0)) {
                                nl(indent);
                            }
                        }
                    } else if (types[a] === "selector") {
                        if (a > 0 && types[a - 1] !== "comment" && (options.cssinsertlines === true || (options.compressedcss === true && (types[a - 1] === "start" || types[a - 1] === "semi")))) {
                            nl(indent);
                        }
                        if (token[a].charAt(token[a].length - 1) === "#") {
                            build.push(token[a]);
                            mixin = true;
                        } else if (token[a].indexOf(",") > -1) {
                            selector(token[a]);
                        } else {
                            if (token[a].charAt(0) === ":" && token[a - 1] === "}" && build[build.length - 1] === " ") {
                                build.pop();
                            }
                            build.push(token[a]);
                            if (options.compressedcss === false) {
                                build.push(" ");
                            }
                        }
                    } else if ((types[a] === "comment" || types[a] === "comment-inline") && types[a - 1] !== "colon" && types[a - 1] !== "property") {
                        if (types[a - 1] === "value" && types[a] === "comment-inline") {
                            build.push(" ");
                        }
                        if (a > 0 && options.compressedcss === true && types[a] === "comment" && types[a - 1] !== "comment") {
                            build.push(lf);
                            nl(indent);
                        } else if (a > 0 && types[a - 1] !== "start" && types[a] !== "comment-inline") {
                            nl(indent);
                        }
                        build.push(token[a]);
                        if (types[a + 1] !== "end" && types[a + 1] !== "comment") {
                            nl(indent);
                        }
                    } else {
                        if (types[a - 1] !== "semi" && options.compressedcss === false && (mixin === false || token[a - 1] === ":") && token[a - 2] !== "filter" && token[a - 2] !== "progid") {
                            if (types[a] === "value" || (types[a].indexOf("external") > -1 && types[a - 1] === "colon")) {
                                build.push(" ");
                            }
                        } else if (options.compressedcss === true && (types[a] === "value" || types[a] === "propvar")) {
                            token[a] = token[a].replace(/(\s*,\s*)/g, ",");
                        }
                        if (types[a] === "external_start") {
                            indent += 1;
                        } else if (types[a] === "external_end") {
                            indent -= 1;
                            if (build[build.length - 1] === tab) {
                                build.pop();
                            }
                        } else if (types[a] === "external_else" && build[build.length - 1] === tab) {
                            build.pop();
                        }
                        build.push(token[a]);
                        if (types[a].indexOf("external") > -1 && types[a + 1] !== "semi") {
                            if ((types[a + 1] !== undefined && types[a + 1].indexOf("external") > -1) || (lines[a + 1] === 1 && types[a + 1] !== "end") || lines[a + 1] > 1) {
                                nl(indent);
                            }
                        }
                    }
                }
                if (options.preserve > 0 && (lines[lines.length - 1] > 0 || endline === true)) {
                    return build
                        .join("")
                        .replace(/(\s+)$/, lf);
                }
                return build
                    .join("")
                    .replace(/(\s+)$/, "");
            }());
        } else {
            output = token
                .join("")
                .replace(/;\}/g, "}");
        }
        if (options.nodeasync === true) {
            return [output, ""];
        }
        return output;
    };
    if (typeof module === "object" && typeof module.parent === "object") {
        //commonjs and nodejs support
        module.exports = csspretty;
    } else if ((typeof define === "object" || typeof define === "function") && (typeof ace !== "object" || ace.prettydiffid === undefined)) {
        //requirejs support
        define(function requirejs(require, module) {
            module.exports = csspretty;
            //worthless if block to appease RequireJS and JSLint
            if (typeof require === "number") {
                return require;
            }
            return function requirejs_csspretty_module(x) {
                return csspretty(x);
            };
        });
    } else {
        global.prettydiff.csspretty = csspretty;
    }
}());
