/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import com.aptana.theme.ThemePlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.text.revisions.RevisionPainter;
import org.eclipse.jface.internal.text.source.DiffPainter;
import org.eclipse.jface.text.revisions.IRevisionListener;
import org.eclipse.jface.text.revisions.IRevisionRulerColumn;
import org.eclipse.jface.text.revisions.IRevisionRulerColumnExtension;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.CommonLineNumberRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class CommonLineNumberChangeRulerColumn
extends CommonLineNumberRulerColumn
implements IChangeRulerColumn,
IRevisionRulerColumn,
IRevisionRulerColumnExtension {
    private IAnnotationModel fAnnotationModel;
    private boolean fCharacterDisplay;
    private final RevisionPainter fRevisionPainter;
    private final DiffPainter fDiffPainter;
    private boolean fShowNumbers = false;
    private static final Color DARK_NUMBER_COLOR = new Color((Device)Display.getDefault(), 185, 168, 0);
    private static final String DARK_COLOR = "255,255,204";
    private static final Color MID_NUMBER_COLOR = new Color((Device)Display.getDefault(), 213, 175, 108);
    private static final String MID_COLOR = "255,250,232";
    private static final Color LIGHT_NUMBER_COLOR = new Color((Device)Display.getDefault(), 213, 198, 150);
    private static final String LIGHT_COLOR = "255,252,244";

    public CommonLineNumberChangeRulerColumn(ISharedTextColors sharedColors) {
        Assert.isNotNull((Object)sharedColors);
        this.fRevisionPainter = new RevisionPainter((IVerticalRulerColumn)this, sharedColors);
        this.fDiffPainter = new DiffPainter((IVerticalRulerColumn)this, sharedColors);
    }

    @Override
    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        Control control = super.createControl(parentRuler, parentControl);
        this.fRevisionPainter.setParentRuler(parentRuler);
        this.fDiffPainter.setParentRuler(parentRuler);
        return control;
    }

    public int getLineOfLastMouseButtonActivity() {
        return this.getParentRuler().getLineOfLastMouseButtonActivity();
    }

    public int toDocumentLineNumber(int y_coordinate) {
        return this.getParentRuler().toDocumentLineNumber(y_coordinate);
    }

    @Override
    public void setModel(IAnnotationModel model) {
        this.setAnnotationModel(model);
        this.fRevisionPainter.setModel(model);
        this.fDiffPainter.setModel(model);
        this.updateNumberOfDigits();
        this.computeIndentations();
        this.layout(true);
        this.doPostRedraw();
    }

    private void setAnnotationModel(IAnnotationModel model) {
        if (this.fAnnotationModel != model) {
            this.fAnnotationModel = model;
        }
    }

    public void setDisplayMode(boolean characterMode) {
        if (characterMode != this.fCharacterDisplay) {
            this.fCharacterDisplay = characterMode;
            this.updateNumberOfDigits();
            this.computeIndentations();
            this.layout(true);
        }
    }

    public IAnnotationModel getModel() {
        return this.fAnnotationModel;
    }

    @Override
    protected String createDisplayString(int line) {
        StringBuffer buffer = new StringBuffer();
        if (this.fShowNumbers) {
            buffer.append(super.createDisplayString(line));
        }
        if (this.fCharacterDisplay && this.getModel() != null) {
            buffer.append(this.fDiffPainter.getDisplayCharacter(line));
        }
        return buffer.toString();
    }

    @Override
    protected int computeNumberOfDigits() {
        int digits = this.fCharacterDisplay && this.getModel() != null ? (this.fShowNumbers ? super.computeNumberOfDigits() + 1 : 1) : (this.fShowNumbers ? super.computeNumberOfDigits() : 0);
        if (this.fRevisionPainter.hasInformation()) {
            digits += this.fRevisionPainter.getRequiredWidth();
        }
        return digits;
    }

    public void addVerticalRulerListener(IVerticalRulerListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeVerticalRulerListener(IVerticalRulerListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    void doPaint(GC gc, ILineRange visibleLines) {
        Color foreground = gc.getForeground();
        if (visibleLines != null) {
            if (this.fRevisionPainter.hasInformation()) {
                this.fRevisionPainter.paint(gc, visibleLines);
            } else if (this.fDiffPainter.hasInformation()) {
                this.fDiffPainter.paint(gc, visibleLines);
            }
        }
        gc.setForeground(foreground);
        if (this.fShowNumbers || this.fCharacterDisplay) {
            super.doPaint(gc, visibleLines);
        }
    }

    public IAnnotationHover getHover() {
        int activeLine = this.getParentRuler().getLineOfLastMouseButtonActivity();
        if (this.fRevisionPainter.hasHover(activeLine)) {
            return this.fRevisionPainter.getHover();
        }
        if (this.fDiffPainter.hasHover(activeLine)) {
            return this.fDiffPainter.getHover();
        }
        return null;
    }

    public void setHover(IAnnotationHover hover) {
        this.fRevisionPainter.setHover(hover);
        this.fDiffPainter.setHover(hover);
    }

    @Override
    public void setBackground(Color background) {
        super.setBackground(background);
        this.fRevisionPainter.setBackground(background);
        this.fDiffPainter.setBackground(background);
    }

    private String getCurrentThemeColor() {
        Color backGroudColor = ThemePlugin.getDefault().getThemeManager().getCurrentTheme().getBackgroundColor();
        String rgb = String.valueOf(backGroudColor.getRed()) + "," + backGroudColor.getGreen() + "," + backGroudColor.getBlue();
        return rgb;
    }

    public void setAddedColor(Color addedColor) {
        if (this.getCurrentThemeColor().equals(DARK_COLOR)) {
            this.fDiffPainter.setAddedColor(DARK_NUMBER_COLOR);
        } else if (this.getCurrentThemeColor().equals(MID_COLOR)) {
            this.fDiffPainter.setAddedColor(MID_NUMBER_COLOR);
        } else if (this.getCurrentThemeColor().equals(LIGHT_COLOR)) {
            this.fDiffPainter.setAddedColor(LIGHT_NUMBER_COLOR);
        } else {
            this.fDiffPainter.setAddedColor(addedColor);
        }
    }

    public void setChangedColor(Color changedColor) {
        if (this.getCurrentThemeColor().equals(DARK_COLOR)) {
            this.fDiffPainter.setChangedColor(DARK_NUMBER_COLOR);
        } else if (this.getCurrentThemeColor().equals(MID_COLOR)) {
            this.fDiffPainter.setChangedColor(MID_NUMBER_COLOR);
        } else if (this.getCurrentThemeColor().equals(LIGHT_COLOR)) {
            this.fDiffPainter.setChangedColor(LIGHT_NUMBER_COLOR);
        } else {
            this.fDiffPainter.setChangedColor(changedColor);
        }
    }

    public void setDeletedColor(Color deletedColor) {
        if (this.getCurrentThemeColor().equals(DARK_COLOR)) {
            this.fDiffPainter.setDeletedColor(DARK_NUMBER_COLOR);
        } else if (this.getCurrentThemeColor().equals(MID_COLOR)) {
            this.fDiffPainter.setDeletedColor(MID_NUMBER_COLOR);
        } else if (this.getCurrentThemeColor().equals(LIGHT_COLOR)) {
            this.fDiffPainter.setDeletedColor(LIGHT_NUMBER_COLOR);
        } else {
            this.fDiffPainter.setDeletedColor(deletedColor);
        }
    }

    public void setRevisionInformation(RevisionInformation info) {
        this.fRevisionPainter.setRevisionInformation(info);
        this.updateNumberOfDigits();
        this.computeIndentations();
        this.layout(true);
        this.doPostRedraw();
    }

    public ISelectionProvider getRevisionSelectionProvider() {
        return this.fRevisionPainter.getRevisionSelectionProvider();
    }

    public void setRevisionRenderingMode(IRevisionRulerColumnExtension.RenderingMode renderingMode) {
        this.fRevisionPainter.setRenderingMode(renderingMode);
    }

    public void showLineNumbers(boolean showNumbers) {
        if (this.fShowNumbers != showNumbers) {
            this.fShowNumbers = showNumbers;
            this.updateNumberOfDigits();
            this.computeIndentations();
            this.layout(true);
        }
    }

    @Override
    public int getWidth() {
        int width = super.getWidth();
        return width > 0 ? width : 8;
    }

    public boolean isShowingLineNumbers() {
        return this.fShowNumbers;
    }

    public boolean isShowingRevisionInformation() {
        return this.fRevisionPainter.hasInformation();
    }

    public boolean isShowingChangeInformation() {
        return this.fDiffPainter.hasInformation();
    }

    public void showRevisionAuthor(boolean show) {
        this.fRevisionPainter.showRevisionAuthor(show);
        this.updateNumberOfDigits();
        this.computeIndentations();
        this.layout(true);
        this.doPostRedraw();
    }

    public void showRevisionId(boolean show) {
        this.fRevisionPainter.showRevisionId(show);
        this.updateNumberOfDigits();
        this.computeIndentations();
        this.layout(true);
        this.doPostRedraw();
    }

    public void addRevisionListener(IRevisionListener listener) {
        this.fRevisionPainter.addRevisionListener(listener);
    }

    public void removeRevisionListener(IRevisionListener listener) {
        this.fRevisionPainter.removeRevisionListener(listener);
    }

    @Override
    protected void handleDispose() {
        this.fRevisionPainter.setParentRuler(null);
        this.fRevisionPainter.setModel(null);
        this.fDiffPainter.setParentRuler(null);
        this.fDiffPainter.setModel(null);
        super.handleDispose();
    }
}

