/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.ruby.RubyEditorPlugin;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.jrubyparser.CompatVersion;
import org.jrubyparser.IRubyWarnings;
import org.jrubyparser.Parser;
import org.jrubyparser.lexer.Lexer;
import org.jrubyparser.lexer.LexerSource;
import org.jrubyparser.lexer.SyntaxException;
import org.jrubyparser.parser.ParserConfiguration;
import org.jrubyparser.parser.ParserResult;
import org.jrubyparser.parser.ParserSupport;

public class RubyTokenScanner
implements ITokenScanner {
    public static final int COMMA = 44;
    public static final int COLON = 58;
    public static final int ASSIGNMENT = 61;
    public static final int QUESTION = 63;
    public static final int NEWLINE = 10;
    public static final int CHARACTER = 128;
    static final int MIN_KEYWORD = 257;
    static final int MAX_KEYWORD = 305;
    public static final int SPACE = 32;
    private static final int LBRACK = 91;
    public static final int SEMICOLON = 59;
    private Lexer lexer = new Lexer();
    private LexerSource lexerSource;
    private ParserSupport parserSupport = new ParserSupport();
    private int fTokenLength;
    private int fOffset;
    private boolean isInSymbol;
    private boolean inAlias;
    private ParserResult result;
    private int origOffset;
    private int origLength;
    private String fContents;
    private BufferedReader reader;

    public RubyTokenScanner() {
        ParserConfiguration config = new ParserConfiguration(0, CompatVersion.RUBY1_8);
        this.parserSupport.setConfiguration(config);
        this.result = new ParserResult();
        this.parserSupport.setResult(this.result);
        this.lexer.setParserSupport(this.parserSupport);
        this.lexer.setWarnings((IRubyWarnings)new Parser.NullWarnings());
    }

    public int getTokenLength() {
        return this.fTokenLength;
    }

    public int getTokenOffset() {
        return this.fOffset;
    }

    public IToken nextToken() {
        this.fOffset = this.getOffset();
        this.fTokenLength = 0;
        Token returnValue = new Token((Object)306);
        boolean isEOF = false;
        try {
            boolean bl = isEOF = !this.lexer.advance();
            if (isEOF) {
                returnValue = Token.EOF;
            } else {
                this.fTokenLength = this.getOffset() - this.fOffset;
                returnValue = this.token(this.lexer.token());
            }
        }
        catch (SyntaxException syntaxException) {
            if (this.lexerSource.getOffset() - this.origLength == 0) {
                return Token.EOF;
            }
            this.fTokenLength = this.getOffset() - this.fOffset;
            return this.token(256);
        }
        catch (NumberFormatException numberFormatException) {
            this.fTokenLength = this.getOffset() - this.fOffset;
            return returnValue;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)RubyEditorPlugin.getDefault(), (Throwable)e);
        }
        return returnValue;
    }

    private int getOffset() {
        return this.lexerSource.getOffset() + this.origOffset;
    }

    private IToken token(int i) {
        if (this.isInSymbol) {
            if (this.isSymbolTerminator(i)) {
                this.isInSymbol = false;
                if (this.shouldReturnDefault(i)) {
                    return new Token((Object)i);
                }
            }
            return new Token((Object)364);
        }
        if (i == 298) {
            this.inAlias = true;
        }
        if (i == 58 && this.inAlias) {
            this.isInSymbol = true;
            this.inAlias = false;
            return new Token((Object)364);
        }
        switch (i) {
            case 91: {
                return new Token((Object)343);
            }
            case 364: {
                if (this.looksLikeTertiaryConditionalWithNoSpaces()) {
                    return new Token((Object)335);
                }
                this.isInSymbol = true;
                return new Token((Object)364);
            }
            case 308: 
            case 376: {
                return new Token((Object)308);
            }
            case 378: 
            case 379: {
                if (this.fOffset - this.origOffset + 1 < this.fContents.length() && this.fContents.charAt(this.fOffset - this.origOffset + 1) == '?') {
                    return new Token((Object)128);
                }
                return new Token((Object)i);
            }
        }
        return new Token((Object)i);
    }

    private boolean looksLikeTertiaryConditionalWithNoSpaces() {
        if (this.fTokenLength > 1) {
            return false;
        }
        int index = this.fOffset - this.origOffset - 1;
        if (index < 0) {
            return false;
        }
        try {
            char c = this.fContents.charAt(index);
            return !Character.isWhitespace(c) && Character.isUnicodeIdentifierPart(c);
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    private boolean shouldReturnDefault(int i) {
        switch (i) {
            case 10: 
            case 44: 
            case 338: 
            case 341: 
            case 382: {
                return true;
            }
        }
        return false;
    }

    private boolean isSymbolTerminator(int i) {
        if (this.isRealKeyword(i)) {
            return true;
        }
        switch (i) {
            case 10: 
            case 44: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 331: 
            case 332: 
            case 333: 
            case 338: 
            case 341: 
            case 348: 
            case 349: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 360: 
            case 363: 
            case 382: {
                return true;
            }
        }
        return false;
    }

    private boolean isRealKeyword(int i) {
        return i >= 257 && i <= 305;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.reset();
        ParserConfiguration config = new ParserConfiguration(0, CompatVersion.BOTH);
        try {
            this.fContents = document.get(offset, length);
        }
        catch (BadLocationException badLocationException) {
            this.fContents = "";
        }
        this.reader = new BufferedReader(new StringReader(this.fContents));
        this.lexerSource = LexerSource.getSource((String)"filename", (Reader)this.reader, (ParserConfiguration)config);
        this.lexer.setSource(this.lexerSource);
        if (offset > 0) {
            try {
                ITypedRegion region = document.getPartition(offset - 1);
                if ("__rb_string_double".equals(region.getType()) || "__rb_string_single".equals(region.getType()) || "__rb_regular_expression".equals(region.getType()) || "__rb_command".equals(region.getType())) {
                    this.lexer.setLexState(Lexer.LexState.EXPR_END);
                }
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)RubyEditorPlugin.getDefault(), (String)("Unable to get previous partition at offset: " + offset), (Throwable)e);
            }
        }
        this.origOffset = offset;
        this.origLength = length;
    }

    protected void reset() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {}
        }
        this.lexer.reset();
        this.lexer.setState(Lexer.LexState.EXPR_BEG);
        this.lexer.setPreserveSpaces(true);
        this.parserSupport.initTopLocalVariables();
        this.isInSymbol = false;
        this.inAlias = false;
    }

    String getSource(int offset, int length) {
        if (this.fContents == null || offset < 0 || offset + length > this.fContents.length()) {
            return null;
        }
        return new String(this.fContents.substring(offset, offset + length));
    }
}

