/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.outline.CommonOutlineItem;
import com.aptana.editor.common.text.reconciler.IFoldingComputer;
import com.aptana.editor.ruby.RubyEditorPlugin;
import com.aptana.editor.ruby.RubySourceViewerConfiguration;
import com.aptana.editor.ruby.internal.text.RubyFoldingComputer;
import com.aptana.editor.ruby.outline.RubyOutlineContentProvider;
import com.aptana.editor.ruby.outline.RubyOutlineLabelProvider;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.ruby.core.IImportContainer;
import com.aptana.ruby.core.IRubyMethod;
import com.aptana.ruby.core.IRubyType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class RubySourceEditor
extends AbstractThemeableEditor {
    private static final char[] PAIR_MATCHING_CHARS = new char[]{'(', ')', '{', '}', '[', ']', '`', '`', '\'', '\'', '\"', '\"', '|', '|', '\u201c', '\u201d', '\u2018', '\u2019'};
    private Map<Annotation, Position> fTagPairOccurrences;
    private boolean fIncludeBlocks;

    protected void initializeEditor() {
        super.initializeEditor();
        this.setPreferenceStore(RubySourceEditor.getChainedPreferenceStore());
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new RubySourceViewerConfiguration(this.getPreferenceStore(), this));
        this.setDocumentProvider(RubyEditorPlugin.getDefault().getRubyDocumentProvider());
    }

    public static IPreferenceStore getChainedPreferenceStore() {
        return new ChainedPreferenceStore(new IPreferenceStore[]{RubyEditorPlugin.getDefault().getPreferenceStore(), CommonEditorPlugin.getDefault().getPreferenceStore(), EditorsPlugin.getDefault().getPreferenceStore()});
    }

    public char[] getPairMatchingCharacters() {
        return PAIR_MATCHING_CHARS;
    }

    public ITreeContentProvider getOutlineContentProvider() {
        return new RubyOutlineContentProvider();
    }

    public ILabelProvider getOutlineLabelProvider() {
        return new RubyOutlineLabelProvider();
    }

    protected void setSelectedElement(IRange element) {
        IParseNode node;
        if (element instanceof CommonOutlineItem && (node = ((CommonOutlineItem)element).getReferenceNode()) instanceof IImportContainer) {
            this.setHighlightRange(element.getStartingOffset(), element.getLength(), true);
            return;
        }
        super.setSelectedElement(element);
    }

    protected void selectionChanged() {
        super.selectionChanged();
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection.isEmpty()) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        this.updateOccurrences(textSelection);
    }

    protected Object getOutlineElementAt(int caret) {
        this.fIncludeBlocks = false;
        Object obj = super.getOutlineElementAt(caret);
        this.fIncludeBlocks = true;
        return obj;
    }

    protected IParseNode getASTNodeAt(int offset) {
        IParseRootNode root = this.getAST();
        if (root == null) {
            return null;
        }
        IParseNode node = root.getNodeAtOffset(offset);
        if (!this.fIncludeBlocks && node != null && node.getNodeType() == 4) {
            node = node.getParent();
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    private void updateOccurrences(ITextSelection textSelection) {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider == null) {
            return;
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.getEditorInput());
        if (annotationModel == null) {
            return;
        }
        int offset = textSelection.getOffset();
        IParseNode currentNode = this.getASTNodeAt(offset);
        if (this.fTagPairOccurrences != null) {
            for (Position pos : this.fTagPairOccurrences.values()) {
                if (!pos.includes(offset)) continue;
                return;
            }
            for (Annotation a : this.fTagPairOccurrences.keySet()) {
                annotationModel.removeAnnotation(a);
            }
            this.fTagPairOccurrences = null;
        }
        HashMap<Annotation, Position> occurrences = new HashMap<Annotation, Position>();
        ArrayList<Position> positions = new ArrayList<Position>();
        if (currentNode != null) {
            if (currentNode instanceof IRubyType) {
                int n = currentNode.getEndingOffset();
                int startOffset = currentNode.getStartingOffset();
                int length = 5;
                IRubyType type = (IRubyType)currentNode;
                if (type.isModule()) {
                    length = 6;
                }
                if (offset <= n && offset >= n - 2 || offset >= startOffset && offset <= startOffset + length) {
                    positions.add(new Position(startOffset, length));
                    positions.add(new Position(n - 2, 3));
                }
            } else if (currentNode instanceof IRubyMethod) {
                int n = currentNode.getEndingOffset();
                int startOffset = currentNode.getStartingOffset();
                if (offset <= n && offset >= n - 2 || offset >= startOffset && offset <= startOffset + 3) {
                    positions.add(new Position(startOffset, 3));
                    positions.add(new Position(n - 2, 3));
                }
            } else if (currentNode.getNodeType() == 4) {
                void var8_11;
                IDocument document;
                int n = currentNode.getEndingOffset();
                if (n >= (document = this.getSourceViewer().getDocument()).getLength()) {
                    --var8_11;
                }
                int endText = 97;
                try {
                    endText = document.getChar((int)var8_11);
                }
                catch (BadLocationException e) {
                    IdeLog.logError((Plugin)RubyEditorPlugin.getDefault(), (String)("Unable to get text at end of block, end offset: " + (int)var8_11), (Throwable)e);
                }
                if (endText == 100) {
                    int startOffset = currentNode.getStartingOffset();
                    if (offset <= var8_11 && offset >= var8_11 - 2 || offset >= startOffset && offset <= startOffset + 3) {
                        positions.add(new Position(startOffset, 2));
                        positions.add(new Position((int)(var8_11 - 2), 3));
                    }
                }
            }
        }
        if (!positions.isEmpty()) {
            for (Position position : positions) {
                occurrences.put(new Annotation("com.aptana.ruby.blockPair.occurrences", false, null), position);
            }
            for (Map.Entry entry : occurrences.entrySet()) {
                annotationModel.addAnnotation((Annotation)entry.getKey(), (Position)entry.getValue());
            }
            this.fTagPairOccurrences = occurrences;
        } else {
            this.fTagPairOccurrences = null;
        }
    }

    protected IPreferenceStore getPluginPreferenceStore() {
        return RubyEditorPlugin.getDefault().getPreferenceStore();
    }

    public IFoldingComputer createFoldingComputer(IDocument document) {
        return new RubyFoldingComputer(this, document);
    }

    public String getContentType() {
        return "com.aptana.contenttype.ruby";
    }
}

