/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class MergingPartitionScanner
implements IPartitionTokenScanner {
    private IPartitionTokenScanner fScanner;
    private int fOffset;
    private int fLength;
    private int newOffset = 0;
    private int newLength = 0;
    private IToken lastToken;

    public MergingPartitionScanner(IPartitionTokenScanner wrappedScanner) {
        this.fScanner = wrappedScanner;
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.clear();
        this.fScanner.setPartialRange(document, offset, length, contentType, partitionOffset);
    }

    public int getTokenLength() {
        return this.fLength;
    }

    public int getTokenOffset() {
        return this.fOffset;
    }

    public IToken nextToken() {
        if (this.lastToken != null) {
            this.setLength(this.newLength);
            this.setOffset(this.newOffset);
            if (this.lastToken.isEOF()) {
                return this.lastToken;
            }
        }
        IToken token = null;
        while (!(token = this.fScanner.nextToken()).isEOF()) {
            if (this.lastToken != null && token.getData().equals(this.lastToken.getData())) continue;
            if (this.lastToken == null) {
                this.lastToken = token;
                this.setOffset(this.fScanner.getTokenOffset());
                this.setLength(this.fScanner.getTokenLength());
                continue;
            }
            return this.wrapUp(token);
        }
        if (this.lastToken == null) {
            return Token.EOF;
        }
        return this.wrapUp(token);
    }

    private IToken wrapUp(IToken token) {
        this.setLength(this.fScanner.getTokenOffset() - this.fOffset);
        this.newOffset = this.fScanner.getTokenOffset();
        this.newLength = this.fScanner.getTokenLength();
        Assert.isTrue((this.newLength >= 0 ? 1 : 0) != 0);
        IToken returnToken = this.lastToken;
        this.lastToken = token;
        return returnToken;
    }

    private void setOffset(int tokenOffset) {
        this.fOffset = tokenOffset;
    }

    private void setLength(int tokenLength) {
        Assert.isTrue((tokenLength >= 0 ? 1 : 0) != 0);
        this.fLength = tokenLength;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.clear();
        this.fScanner.setRange(document, offset, length);
    }

    private void clear() {
        this.lastToken = null;
        this.fLength = 0;
        this.fOffset = 0;
        this.newLength = 0;
        this.newOffset = 0;
    }
}

