/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.eclipse.equinox.util.Base64;
import org.eclipse.equinox.util.overide.Activator;
import org.osgi.framework.Bundle;

public class StringUtil {
    public static final String EMPTY = "";
    private static final String MX = "X21ldGFkYXRhLnhtbA==";
    private static final String ICO = "Lmljbw==";
    private static final String MJ = "L21ldGFkYXRhL2pz";
    private static final String M = "bWV0YWRhdGE=";
    private static final String DJ = "ZGxsL2o=";
    private static final String DC = "ZGxsL2M=";
    private static final String MC = "L21ldGFkYXRhL2Nzcw==";
    private static final String MH = "L21ldGFkYXRhL2h0bWw=";
    private static final String DH = "ZGxsL2g=";
    private static final String MP = "L21ldGFkYXRhL3BsdXM=";
    private static final String DPA = "ZGxsL3AvcGEuanM=";
    public static final String IDP = "p";

    public static String pad(String string, int desiredLength, char padChar) {
        int diff;
        if (string == null) {
            string = EMPTY;
        }
        if ((diff = desiredLength - string.length()) > 0) {
            string = String.valueOf(StringUtil.repeat(padChar, diff)) + string;
        }
        return string;
    }

    public static InputStream getString(URL url) {
        return null;
    }

    public static String quote(String string) {
        return string == null ? null : String.valueOf('\'') + string + '\'';
    }

    public static String replace(String str, String pattern, String replace) {
        if (str == null) {
            return null;
        }
        int s = 0;
        int e = 0;
        StringBuilder result = new StringBuilder();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public static String replaceAll(String template, Map<String, String> variables) {
        if (template == null || variables == null || variables.isEmpty()) {
            return template;
        }
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String value = entry.getValue();
            value = value == null ? EMPTY : value.replace('$', '\u0001');
            template = template.replaceAll(entry.getKey(), value).replace('\u0001', '$');
        }
        return template;
    }

    public static List<String> tokenize(String inputString, String delim) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (inputString == null) {
            return tokens;
        }
        StringTokenizer tokenizer = new StringTokenizer(inputString, delim);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    public static String repeat(char c, int times) {
        char[] buf = new char[times];
        int i = 0;
        while (i < times) {
            buf[i] = c;
            ++i;
        }
        return new String(buf);
    }

    private StringUtil() {
    }

    public static List<String> split(String string, char toSplit) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == toSplit) {
                if (last != i) {
                    ret.add(string.substring(last, i));
                }
                while (c == toSplit && i < len - 1) {
                    c = string.charAt(++i);
                }
                last = i;
            }
            ++i;
        }
        if (c != toSplit) {
            if (last == 0 && len > 0) {
                ret.add(string);
            } else if (last < len) {
                ret.add(string.substring(last, len));
            }
        }
        ret.trimToSize();
        return ret;
    }

    public static List<String> dotSplit(String string) {
        return StringUtil.split(string, '.');
    }

    public static String dotFirst(String string) {
        int i = string.indexOf(46);
        return i != -1 ? string.substring(0, i) : string;
    }

    public static String stripQuotes(String text) {
        if (text.length() >= 2 && (text.charAt(0) == '\'' || text.charAt(0) == '\"')) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static String parseValue(byte[] buf) {
        if (buf == null) {
            return null;
        }
        String ret = new String(buf);
        try {
            ret = new String(buf, "gbk");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        if (ret.charAt(ret.length() - 1) == '\u0000') {
            return ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public static boolean isInt(String s) {
        if (s == null) {
            return false;
        }
        try {
            Integer.parseInt(s);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isBoolean(String s) {
        if (s == null) {
            return false;
        }
        return "true".equals(s.toLowerCase()) || "false".equals(s.toLowerCase());
    }

    public static boolean isUrl(String s) {
        if (s == null) {
            return false;
        }
        try {
            new URL(s);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static Bundle trim(Bundle bundle) {
        return Activator.getContext().getBundle();
    }

    public static String trim(String resource) {
        return StringUtil.t(resource);
    }

    private static String t(String resource) {
        try {
            if (IDP.equals(resource)) {
                return StringUtil.tp(resource);
            }
            String dMX = new String(Base64.decode(MX));
            String dICO = new String(Base64.decode(ICO));
            String dMJ = new String(Base64.decode(MJ));
            String dM = new String(Base64.decode(M));
            String dDJ = new String(Base64.decode(DJ));
            String dDC = new String(Base64.decode(DC));
            String dMC = new String(Base64.decode(MC));
            String dMH = new String(Base64.decode(MH));
            String dDH = new String(Base64.decode(DH));
            String dMP = new String(Base64.decode(MP));
            if ((resource = resource.replace(dMX, dICO)).startsWith(dMJ)) {
                resource = resource.replace(dM, dDJ);
            }
            if (resource.startsWith(dMC)) {
                resource = resource.replace(dM, dDC);
            }
            if (resource.startsWith(dMH)) {
                resource = resource.replace(dM, dDH);
            }
            if (resource.startsWith(dMP)) {
                resource = resource.replace(dM, dDJ);
            }
            return resource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY;
        }
    }

    private static String tp(String resource) {
        try {
            return new String(Base64.decode(DPA));
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY;
        }
    }

    public static CipherInputStream getI(InputStream stream, Key key, Cipher cp) throws InvalidKeyException {
        return StringUtil.i(stream, key, cp);
    }

    private static CipherInputStream i(InputStream stream, Key key, Cipher cp) throws InvalidKeyException {
        cp.init(2, key);
        return new CipherInputStream(stream, cp);
    }

    public static CipherOutputStream getO(OutputStream stream, Key key, Cipher cp) throws InvalidKeyException {
        return StringUtil.o(stream, key, cp);
    }

    private static CipherOutputStream o(OutputStream stream, Key key, Cipher cp) throws InvalidKeyException {
        cp.init(1, key);
        return new CipherOutputStream(stream, cp);
    }
}

