/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.dynamicpage.php;

import com.aptana.editor.common.text.rules.QueuedTokenScanner;
import com.aptana.editor.epl.BufferedDocumentScanner;
import com.pandora.editor.dynamicpage.php.PHPTokenMapperFactory;
import com.pandora.editor.dynamicpage.php.PHPTokenType;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class FastPHPStringTokenScanner
extends QueuedTokenScanner {
    private static final IToken TOKEN_BEGIN_QUOTE = FastPHPStringTokenScanner.getToken(PHPTokenType.PUNCTUATION_STRING_BEGIN);
    private static final IToken TOKEN_END_QUOTE = FastPHPStringTokenScanner.getToken(PHPTokenType.PUNCTUATION_STRING_END);
    private static final IToken TOKEN_ESCAPE_CHARACTER = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.CHARACTER_ESCAPE);
    private static final IToken TOKEN_VARIABLE_OTHER = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.VARIABLE_OTHER);
    private static final IToken TOKEN_VARIABLE_GLOBAL = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.VARIABLE_OTHER_GLOBAL);
    private static final IToken TOKEN_VARIABLE_OTHER_PUNCTUATION = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.VARIABLE_OTHER, PHPTokenType.VARIABLE_PUNCTUATION);
    private static final IToken TOKEN_VARIABLE_GLOBAL_PUNCTUATION = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.VARIABLE_OTHER_GLOBAL, PHPTokenType.VARIABLE_PUNCTUATION);
    private static final IToken TOKEN_NUMERIC = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.NUMERIC);
    private static final IToken TOKEN_CLASS_OPERATOR = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.CLASS_OPERATOR);
    private static final IToken TOKEN_ARRAY_BEGIN = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.PUNCTUATION_LBRACKET);
    private static final IToken TOKEN_ARRAY_END = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.PUNCTUATION_RBRACKET);
    private static final IToken TOKEN_VARIABLE_PUNCTUATION = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.VARIABLE_PUNCTUATION);
    private static final IToken TOKEN_FUNCTION_PUNCTUATION = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.FUNCTION_PUNCTUATION);
    private static final IToken TOKEN_STATIC_PUNCTUATION = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.STATIC_PUNCTUATION);
    private static final IToken TOKEN_SINGLE_QUOTED = FastPHPStringTokenScanner.getToken(PHPTokenType.STRING_SINGLE);
    private static final IToken TOKEN_BEGIN_QUOTE_INNER = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.VARIABLE_OTHER, PHPTokenType.STRING_DOUBLE, PHPTokenType.PUNCTUATION_STRING_BEGIN);
    private static final IToken TOKEN_END_QUOTE_INNER = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.VARIABLE_OTHER, PHPTokenType.STRING_DOUBLE, PHPTokenType.PUNCTUATION_STRING_END);
    private static final IToken TOKEN_DOUBLE_QUOTED_INNER = FastPHPStringTokenScanner.getToken(PHPTokenType.META_STRING_CONTENTS_DOUBLE, PHPTokenType.VARIABLE_OTHER, PHPTokenType.STRING_DOUBLE, PHPTokenType.META_STRING_CONTENTS_DOUBLE);
    private final IToken fDefaultToken;
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(100);

    public FastPHPStringTokenScanner(IToken defaultToken) {
        this.fDefaultToken = defaultToken;
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.fScanner.setRange(document, offset, length);
        if (this.fScanner.read() == 34) {
            this.queueToken(TOKEN_BEGIN_QUOTE, this.fScanner.getOffset() - 1, 1);
        } else {
            this.fScanner.unread();
        }
    }

    public IToken nextToken() {
        IToken token = super.nextToken();
        if (!token.isEOF()) {
            return token;
        }
        this.resumeTokenScan();
        return super.nextToken();
    }

    private void resumeTokenScan() {
        int startOffset = this.fScanner.getOffset();
        int ch = this.fScanner.read();
        switch (ch) {
            case 92: {
                this.readEscape(startOffset);
                break;
            }
            case 36: {
                this.fScanner.unread();
                this.readSimpleVariable(startOffset);
                break;
            }
            case 123: {
                ch = this.fScanner.read();
                if (ch == 36) {
                    this.fScanner.unread();
                    this.readComplexVariable(startOffset);
                    break;
                }
                if (ch == -1) break;
                this.fScanner.unread();
                this.readDefault(startOffset);
                break;
            }
            case 34: {
                if (this.fScanner.read() == -1) {
                    this.queueToken(TOKEN_END_QUOTE, startOffset, 1);
                    break;
                }
                this.fScanner.unread();
                this.readDefault(startOffset);
                break;
            }
            case -1: {
                break;
            }
            default: {
                this.readDefault(startOffset);
            }
        }
    }

    private void readDefault(int offset) {
        int ch = this.fScanner.read();
        while (ch != 92 && ch != 36 && ch != 123 && ch != 34 && ch != -1) {
            ch = this.fScanner.read();
        }
        if (ch != -1) {
            this.fScanner.unread();
        }
        this.queueToken(this.fDefaultToken, offset, this.fScanner.getOffset() - offset);
    }

    private void readEscape(int offset) {
        int ch = this.fScanner.read();
        int count = 2;
        int radix = 8;
        switch (ch) {
            case 34: 
            case 36: 
            case 92: 
            case 102: 
            case 110: 
            case 114: 
            case 116: 
            case 118: {
                break;
            }
            case 120: {
                ch = this.fScanner.read();
                count = 1;
                radix = 16;
            }
            default: {
                while (Character.digit(ch, radix) >= 0 && count > 0) {
                    ch = this.fScanner.read();
                    --count;
                }
                if (Character.digit(ch, radix) >= 0 || ch == -1) break;
                this.fScanner.unread();
            }
        }
        this.queueToken(TOKEN_ESCAPE_CHARACTER, offset, this.fScanner.getOffset() - offset);
    }

    /*
     * Unable to fully structure code
     */
    private void readSimpleVariable(int offset) {
        ch = this.fScanner.read();
        unread = 0;
        if (ch == 36 && (ch = this.fScanner.read()) != -1) {
            ++unread;
        }
        if (Character.isLetter(ch) || ch == 95) {
            name = new StringBuilder();
            name.append('$').append((char)ch);
            ch = this.fScanner.read();
            while (Character.isLetterOrDigit(ch) || ch == 95) {
                name.append((char)ch);
                ch = this.fScanner.read();
            }
            if (ch != -1) {
                this.fScanner.unread();
            }
            v0 = token = PHPTokenMapperFactory.GLOBALS.contains(name.toString()) != false ? FastPHPStringTokenScanner.TOKEN_VARIABLE_GLOBAL : FastPHPStringTokenScanner.TOKEN_VARIABLE_OTHER;
            if (unread != 0) {
                this.queueToken(token == FastPHPStringTokenScanner.TOKEN_VARIABLE_GLOBAL ? FastPHPStringTokenScanner.TOKEN_VARIABLE_GLOBAL_PUNCTUATION : FastPHPStringTokenScanner.TOKEN_VARIABLE_OTHER_PUNCTUATION, offset, 1);
                ++offset;
            }
            this.queueToken(token, offset, this.fScanner.getOffset() - offset);
            this.readVariableOperator(this.fScanner.getOffset());
            return;
        }
        if (ch != 123) ** GOTO lbl30
        this.queueToken(FastPHPStringTokenScanner.TOKEN_VARIABLE_PUNCTUATION, offset, this.fScanner.getOffset() - offset);
        this.readLiteral(this.fScanner.getOffset());
        this.readDefaultUntil('}', FastPHPStringTokenScanner.TOKEN_VARIABLE_PUNCTUATION, this.fScanner.getOffset());
        return;
lbl-1000:
        // 1 sources

        {
            this.fScanner.unread();
lbl30:
            // 2 sources

            ** while (unread-- > 0)
        }
lbl31:
        // 1 sources

        this.readDefault(offset);
    }

    private void readComplexVariable(int offset) {
        this.queueToken(TOKEN_VARIABLE_PUNCTUATION, offset, this.fScanner.getOffset() - offset);
        offset = this.fScanner.getOffset();
        Assert.isTrue((this.fScanner.read() == 36 ? 1 : 0) != 0);
        int ch = this.fScanner.read();
        if (Character.isLetter(ch) || ch == 95) {
            StringBuilder name = new StringBuilder();
            name.append('$').append((char)ch);
            ch = this.fScanner.read();
            while (Character.isLetterOrDigit(ch) || ch == 95) {
                name.append((char)ch);
                ch = this.fScanner.read();
            }
            if (ch != -1) {
                this.fScanner.unread();
            }
            IToken token = PHPTokenMapperFactory.GLOBALS.contains(name.toString()) ? TOKEN_VARIABLE_GLOBAL : TOKEN_VARIABLE_OTHER;
            this.queueToken(token == TOKEN_VARIABLE_GLOBAL ? TOKEN_VARIABLE_GLOBAL_PUNCTUATION : TOKEN_VARIABLE_OTHER_PUNCTUATION, offset, 1);
            this.queueToken(token, offset + 1, this.fScanner.getOffset() - offset - 1);
            this.readVariableOperator(this.fScanner.getOffset());
        } else if (ch == 123) {
            this.queueToken(TOKEN_VARIABLE_PUNCTUATION, offset, this.fScanner.getOffset() - offset);
            this.readLiteral(this.fScanner.getOffset());
            this.readDefaultUntil('}', TOKEN_VARIABLE_PUNCTUATION, this.fScanner.getOffset());
        }
        this.readDefaultUntil('}', TOKEN_VARIABLE_PUNCTUATION, this.fScanner.getOffset());
    }

    private void readVariableOperator(int offset) {
        int unread = 1;
        int ch = this.fScanner.read();
        if (ch == 45) {
            ch = this.fScanner.read();
            ++unread;
            if (ch == 62) {
                this.queueToken(TOKEN_CLASS_OPERATOR, offset, this.fScanner.getOffset() - offset);
                this.readSimpleVariable(this.fScanner.getOffset());
                this.readVariableOperator(this.fScanner.getOffset());
                unread = 0;
            }
        } else if (ch == 91) {
            this.queueToken(TOKEN_ARRAY_BEGIN, offset, this.fScanner.getOffset() - offset);
            offset = this.fScanner.getOffset();
            ch = this.fScanner.read();
            if (ch == 36) {
                this.readSimpleVariable(offset);
            } else if (Character.isDigit(ch)) {
                this.readNumeric(offset);
            } else if (Character.isLetter(ch)) {
                this.readLiteral(offset);
            } else if (ch == 39) {
                this.readSingleQuotedString(offset);
            } else if (ch == 34) {
                this.readDoubleQuotedString(offset);
            }
            offset = this.fScanner.getOffset();
            ch = this.fScanner.read();
            if (ch == 93) {
                this.queueToken(TOKEN_ARRAY_END, offset, this.fScanner.getOffset() - offset);
                this.readVariableOperator(this.fScanner.getOffset());
                unread = 0;
            }
        } else if (ch == 40 || ch == 41) {
            this.queueToken(TOKEN_FUNCTION_PUNCTUATION, offset, this.fScanner.getOffset() - offset);
            this.readVariableOperator(this.fScanner.getOffset());
            this.readDefaultUntil(')', TOKEN_FUNCTION_PUNCTUATION, this.fScanner.getOffset());
            unread = 0;
        } else if (ch == 58) {
            ch = this.fScanner.read();
            ++unread;
            if (ch == 58) {
                this.queueToken(TOKEN_STATIC_PUNCTUATION, offset, this.fScanner.getOffset() - offset);
                this.readSimpleVariable(this.fScanner.getOffset());
                unread = 0;
            }
        }
        if (unread == 0) {
            this.readVariableOperator(this.fScanner.getOffset());
        }
        while (ch != -1 && unread-- > 0) {
            this.fScanner.unread();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readDefaultUntil(char target, IToken token, int offset) {
        block4: {
            block3: {
                ch = this.fScanner.read();
                unread = 1;
                while (ch != target && ch != -1) {
                    ch = this.fScanner.read();
                    ++unread;
                }
                if (ch != target) break block3;
                length = this.fScanner.getOffset() - offset - 1;
                if (length > 0) {
                    this.queueToken(this.fDefaultToken, offset, length);
                }
                offset = this.fScanner.getOffset() - 1;
                this.queueToken(token, offset, this.fScanner.getOffset() - offset);
                break block4;
            }
            if (ch != -1) ** GOTO lbl19
            if (true) ** GOTO lbl19
            do {
                this.fScanner.unread();
lbl19:
                // 3 sources

                v0 = --unread;
                --unread;
            } while (v0 > 0);
        }
    }

    private void readNumeric(int offset) {
        int ch = this.fScanner.read();
        while (Character.isDigit(ch)) {
            ch = this.fScanner.read();
        }
        if (ch != -1) {
            this.fScanner.unread();
        }
        this.queueToken(TOKEN_NUMERIC, offset, this.fScanner.getOffset() - offset);
    }

    private void readLiteral(int offset) {
        int ch = this.fScanner.read();
        while (Character.isLetterOrDigit(ch) || ch == 95) {
            ch = this.fScanner.read();
        }
        if (ch != -1) {
            this.fScanner.unread();
        }
        if (ch == 36) {
            this.readSimpleVariable(offset);
        } else {
            this.queueToken(TOKEN_VARIABLE_OTHER, offset, this.fScanner.getOffset() - offset);
            this.readVariableOperator(this.fScanner.getOffset());
        }
    }

    private void readSingleQuotedString(int offset) {
        int ch = this.fScanner.read();
        while (ch != 39 && ch != -1) {
            ch = this.fScanner.read();
        }
        this.queueToken(TOKEN_SINGLE_QUOTED, offset, this.fScanner.getOffset() - offset);
    }

    private void readDoubleQuotedString(int offset) {
        int firstOffset = offset;
        int firstLength = this.fScanner.getOffset() - offset;
        offset = this.fScanner.getOffset();
        int ch = this.fScanner.read();
        while (ch != 34 && ch != -1) {
            ch = this.fScanner.read();
        }
        if (ch == -1) {
            return;
        }
        this.queueToken(TOKEN_BEGIN_QUOTE_INNER, firstOffset, firstLength);
        this.queueToken(TOKEN_DOUBLE_QUOTED_INNER, offset, this.fScanner.getOffset() - 1 - offset);
        this.queueToken(TOKEN_END_QUOTE_INNER, this.fScanner.getOffset() - 1, 1);
    }

    private static IToken getToken(PHPTokenType ... type) {
        StringBuilder sb = new StringBuilder();
        PHPTokenType[] pHPTokenTypeArray = type;
        int n = type.length;
        int n2 = 0;
        while (n2 < n) {
            PHPTokenType i = pHPTokenTypeArray[n2];
            sb.append(i.toString()).append(' ');
            ++n2;
        }
        return new Token((Object)sb.toString().trim());
    }
}

