/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.dynamicpage.contentassist;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.contentassist.StringValueCompletionProposal;
import com.aptana.editor.html.contentassist.HTMLContentAssistProcessor;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.pandora.editor.dynamicpage.Bundle;
import com.pandora.editor.dynamicpage.DynamicPagesEditorPlugin;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

public class SPContentAssistProcessor
extends CommonContentAssistProcessor {
    public static final Image JS_PROPERTY = DynamicPagesEditorPlugin.imageDescriptorFromPlugin((String)"com.aptana.editor.js", (String)"/icons/assistant/js_property.png").createImage();
    private static final String ACTIVATION_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ.";

    public SPContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        IDocument document = viewer.getDocument();
        HashSet<String> resultStr = new HashSet<String>();
        resultStr.addAll(Bundle.getCompletions(this.editor.getContentType()));
        HashSet<StringValueCompletionProposal> results = new HashSet<StringValueCompletionProposal>();
        StringBuilder prefix = this.getPrefix(offset, document);
        String prefixStr = prefix.reverse().toString();
        try {
            ITypedRegion region = document.getPartition(0);
            while (region != null) {
                String type = region.getType();
                if (StringUtil.isNotEmpty((String)type) && type.startsWith("__sp_") && !type.startsWith("__sp_comment") && !type.startsWith("__sp_string")) {
                    String text = document.get(region.getOffset(), region.getLength());
                    this.processWordText(text, resultStr, prefixStr);
                }
                region = document.getPartition(region.getOffset() + region.getLength() + 1);
            }
        }
        catch (BadLocationException badLocationException) {}
        Range replaceRange = new Range(offset - prefixStr.length(), offset - 1);
        for (String str : resultStr) {
            StringValueCompletionProposal proposal = new StringValueCompletionProposal(str, (IRange)replaceRange, JS_PROPERTY, null);
            proposal.setIsItalics(true);
            proposal.setCompletionProposalType(CompletionProposalType.NUMBER);
            results.add(proposal);
        }
        return results.toArray(new ICompletionProposal[results.size()]);
    }

    protected StringBuilder getPrefix(int offset, IDocument document) {
        StringBuilder prefix = new StringBuilder();
        int currentOffset = offset - 1;
        while (currentOffset >= 0) {
            try {
                char c = document.getChar(currentOffset);
                if (!Character.isJavaIdentifierPart(c)) break;
                prefix.append(c);
            }
            catch (BadLocationException badLocationException) {
                break;
            }
            --currentOffset;
        }
        return prefix;
    }

    public boolean isValidIdentifier(char c, int keyCode) {
        return ACTIVATION_CHARACTERS.contains(String.valueOf(c));
    }

    public boolean isValidActivationCharacter(char c, int keyCode) {
        return ACTIVATION_CHARACTERS.contains(String.valueOf(c));
    }

    public boolean isValidAutoActivationLocation(char c, int keyCode, IDocument document, int offset) {
        return ACTIVATION_CHARACTERS.contains(String.valueOf(c));
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return ACTIVATION_CHARACTERS.toCharArray();
    }

    protected String getPreferenceNodeQualifier() {
        return "com.pandora.editor.jsp";
    }

    public boolean isEnableEmmet(IDocument document, int offset) {
        try {
            if (document.getPartition(offset).getType().startsWith("__sp_")) {
                return false;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return new HTMLContentAssistProcessor(this.editor).isEnableEmmet(document, offset);
    }

    private void processWordText(String text, Set<String> results, String prefixStr) {
        if (StringUtil.isBlank((String)text)) {
            return;
        }
        try {
            int index = 0;
            StringBuilder sBuilder = new StringBuilder();
            do {
                char c;
                if (Character.isJavaIdentifierPart(c = text.charAt(index))) {
                    sBuilder.append(c);
                    continue;
                }
                String string = sBuilder.toString();
                if (StringUtil.isNotEmpty((String)string) && Character.isJavaIdentifierStart(string.charAt(0)) && sBuilder.toString().startsWith(prefixStr) && !sBuilder.toString().equals(prefixStr)) {
                    results.add(sBuilder.toString());
                }
                sBuilder.delete(0, sBuilder.length());
            } while (++index < text.length());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

