/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.editor.dynamicpage;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.google.gson.Gson;
import com.pandora.editor.dynamicpage.Completion;
import com.pandora.editor.dynamicpage.DynamicPagesEditorPlugin;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.Plugin;

public class Bundle {
    private static Map<String, Set<String>> completions = null;

    public static void initCompletions(File completionFile) {
        if (completions == null) {
            completions = new HashMap<String, Set<String>>();
        }
        try {
            if (completionFile.exists() && completionFile.isFile()) {
                Gson gson = new Gson();
                String json = FileUtils.readFileToString((File)completionFile);
                Completion cp = (Completion)gson.fromJson(json, Completion.class);
                if (cp == null) {
                    return;
                }
                if (completions.containsKey(cp.getScope())) {
                    completions.get(cp.getScope()).addAll(Arrays.asList(cp.getCompletions()));
                } else {
                    HashSet<String> cps = new HashSet<String>();
                    cps.addAll(Arrays.asList(cp.getCompletions()));
                    completions.put(cp.getScope(), cps);
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)DynamicPagesEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    public static Set<String> getCompletions(String scope) {
        HashSet<String> result = new HashSet<String>();
        if (completions == null) {
            return result;
        }
        if (StringUtil.isEmpty((String)scope)) {
            for (Set<String> cps : completions.values()) {
                result.addAll(cps);
            }
        } else {
            Set<String> cps = completions.get(scope);
            if (cps != null) {
                result.addAll(cps);
            }
        }
        return result;
    }
}

