/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.model.RemoteQueriedElement;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryTreeContentManager;
import org.eclipse.equinox.internal.p2.ui.viewers.IDeferredQueryTreeListener;
import org.eclipse.equinox.internal.p2.ui.viewers.IInputChangeListener;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class DeferredQueryContentProvider
extends ProvElementContentProvider {
    DeferredQueryTreeContentManager manager;
    Object currentInput;
    HashMap<Object, Object> alreadyQueried = new HashMap();
    HashSet<Object> queryCompleted = new HashSet();
    AbstractTreeViewer viewer = null;
    ListenerList listeners = new ListenerList();
    boolean synchronous = false;

    public void addListener(IInputChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IInputChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        super.inputChanged(v, oldInput, newInput);
        if (this.manager != null) {
            this.manager.cancel(oldInput);
        }
        if (v instanceof AbstractTreeViewer) {
            this.manager = new DeferredQueryTreeContentManager((AbstractTreeViewer)v, this);
            this.viewer = (AbstractTreeViewer)v;
            this.manager.setListener(new IDeferredQueryTreeListener(){

                public void fetchingDeferredChildren(Object parent, Object placeholder) {
                    DeferredQueryContentProvider.this.alreadyQueried.put(parent, placeholder);
                }

                public void finishedFetchingDeferredChildren(Object parent, Object placeholder) {
                    DeferredQueryContentProvider.this.queryCompleted.add(parent);
                }
            });
        } else {
            this.viewer = null;
        }
        this.alreadyQueried = new HashMap();
        this.queryCompleted = new HashSet();
        this.currentInput = newInput;
        Object[] inputListeners = this.listeners.getListeners();
        int i = 0;
        while (i < inputListeners.length) {
            ((IInputChangeListener)inputListeners[i]).inputChanged(v, oldInput, newInput);
            ++i;
        }
    }

    public Object[] getElements(Object input) {
        Object[] result = null;
        result = input instanceof QueriedElement ? this.getChildren(input, false) : super.getElements(input);
        if (result != null && result.length > 0) {
            ArrayList<Object> resultList = new ArrayList<Object>(Arrays.asList(result));
            int i = 0;
            block0: while (i < resultList.size()) {
                Object object = resultList.get(i);
                IInstallableUnit iu = ProvUI.getAdapter(object, IInstallableUnit.class);
                if (iu != null) {
                    if (iu.getId().equals("io.hbuilder.www")) {
                        Object[] tmps;
                        Object[] objectArray = tmps = this.getChildren(object, false);
                        int n = tmps.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object tmp = objectArray[n2];
                            iu = ProvUI.getAdapter(tmp, IInstallableUnit.class);
                            if (iu != null && iu.getId().equals("com.aptana.feature.rcp.feature.group")) {
                                resultList.add(i + 1, tmp);
                                break block0;
                            }
                            ++n2;
                        }
                        break;
                    }
                    if (iu.getId().equals("com.aptana.feature.rcp.feature.group")) {
                        resultList.remove(object);
                        break;
                    }
                }
                ++i;
            }
            result = resultList.toArray(new Object[resultList.size()]);
        }
        return result;
    }

    public void dispose() {
        super.dispose();
        if (this.manager != null) {
            this.manager.cancel(this.currentInput);
        }
    }

    public boolean hasChildren(Object element) {
        boolean result = false;
        result = this.manager != null ? (this.manager.isDeferredAdapter(element) ? this.manager.mayHaveChildren(element) : super.hasChildren(element)) : super.hasChildren(element);
        return result;
    }

    public Object[] getChildren(Object parent) {
        return this.getChildren(parent, true);
    }

    public Object[] getChildren(Object parent, boolean filter) {
        IInstallableUnit iu;
        Object[] result = null;
        if (parent instanceof RemoteQueriedElement) {
            RemoteQueriedElement element = (RemoteQueriedElement)parent;
            if (element.hasQueryable()) {
                result = element.getChildren(element);
            } else if (this.manager != null && !this.synchronous) {
                result = this.manager.getChildren(parent);
            }
        } else {
            result = super.getChildren(parent);
        }
        if (filter && result != null && result.length > 0 && (iu = ProvUI.getAdapter(parent, IInstallableUnit.class)) != null) {
            ArrayList<Object> resultList = new ArrayList<Object>(Arrays.asList(result));
            if (iu.getId().equals("io.hbuilder.www")) {
                for (Object e : resultList) {
                    iu = ProvUI.getAdapter(e, IInstallableUnit.class);
                    if (iu == null || !iu.getId().equals("com.aptana.feature.rcp.feature.group")) continue;
                    resultList.remove(e);
                    break;
                }
            }
            result = resultList.toArray(new Object[resultList.size()]);
        }
        return result;
    }

    public void setSynchronous(boolean sync) {
        if (sync && this.manager != null) {
            this.manager.cancel(this.currentInput);
        }
        this.synchronous = sync;
    }

    public boolean getSynchronous() {
        return this.synchronous;
    }
}

