/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.browser;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptorWorkingCopy;
import org.eclipse.ui.internal.browser.Messages;
import org.eclipse.ui.internal.browser.SWTUtil;
import org.eclipse.ui.internal.browser.WebBrowserUtil;

public class BrowserDescriptorDialog
extends Dialog {
    protected IBrowserDescriptorWorkingCopy browser;
    protected boolean isEdit;
    protected Button newPageCheckbox;
    protected Button clearHistoryCheckbox;
    protected Button browseButton;
    protected Text browserNameTextfield;
    protected Text browserLocationTextfield;
    protected Text browserParametersTextfield;
    private Button okButton;

    public BrowserDescriptorDialog(Shell parentShell, IBrowserDescriptorWorkingCopy browser) {
        super(parentShell);
        this.browser = browser;
        this.isEdit = true;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public BrowserDescriptorDialog(Shell parentShell) {
        super(parentShell);
        this.browser = BrowserManager.getInstance().createExternalWebBrowser();
        this.isEdit = false;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.isEdit) {
            shell.setText(Messages.editExternalBrowser);
        } else {
            shell.setText(Messages.createBrowser);
        }
    }

    protected Text createText(Composite comp, String txt, final StringModifyListener listener, boolean multiLine) {
        int style = 2048;
        if (multiLine) {
            style = 2626;
        }
        final Text text = new Text(comp, style);
        if (txt != null) {
            text.setText(txt);
        }
        GridData data = new GridData(4, 0x1000000, true, false);
        data.widthHint = 450;
        if (multiLine) {
            data.verticalAlignment = 4;
            data.grabExcessVerticalSpace = true;
        }
        GC gc = new GC((Drawable)text);
        FontMetrics fm = gc.getFontMetrics();
        int hHint = 8 * fm.getHeight();
        gc.dispose();
        text.setSize(text.computeSize(-1, hHint));
        text.setLayoutData((Object)data);
        if (listener != null) {
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    listener.valueChanged(text.getText());
                }
            });
        }
        return text;
    }

    protected Control createDialogArea(Composite parent) {
        Font font = parent.getFont();
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 3;
        composite.setFont(font);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.browser.browser_preference_page_dialog_context");
        SWTUtil.createLabel(composite, Messages.name).setFont(font);
        this.browserNameTextfield = this.createText(composite, this.browser.getName(), new StringModifyListener(){

            public void valueChanged(String s) {
                BrowserDescriptorDialog.this.browser.setName(s);
                BrowserDescriptorDialog.this.validateFields();
            }
        }, false);
        this.browserNameTextfield.setFont(font);
        new Label(composite, 0);
        SWTUtil.createLabel(composite, Messages.location).setFont(font);
        this.browserLocationTextfield = this.createText(composite, this.browser.getLocation(), new StringModifyListener(){

            public void valueChanged(String s) {
                BrowserDescriptorDialog.this.browser.setLocation(s);
                BrowserDescriptorDialog.this.validateFields();
            }
        }, false);
        this.browserLocationTextfield.setFont(font);
        this.browseButton = SWTUtil.createButton(composite, Messages.browse);
        this.browseButton.setFont(font);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(BrowserDescriptorDialog.this.getShell(), 4096);
                dialog.setText(Messages.browseMessage);
                String fname = BrowserDescriptorDialog.this.browserLocationTextfield.getText();
                dialog.setFileName(fname);
                fname = dialog.open();
                if (fname != null) {
                    BrowserDescriptorDialog.this.browserLocationTextfield.setText(fname);
                }
            }
        });
        SWTUtil.createLabel(composite, Messages.parameters).setFont(font);
        this.browserParametersTextfield = this.createText(composite, this.browser.getParameters(), new StringModifyListener(){

            public void valueChanged(String s) {
                BrowserDescriptorDialog.this.browser.setParameters(s);
            }
        }, true);
        this.browserParametersTextfield.setFont(font);
        new Label(composite, 0);
        new Label(composite, 0);
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(NLS.bind((String)Messages.parametersMessage, (Object)"%URL%"));
        urlLabel.setFont(font);
        return composite;
    }

    protected void okPressed() {
        try {
            File file = new File(this.browser.getLocation());
            if (!file.exists() && !WebBrowserUtil.openConfirm(String.valueOf(Messages.locationInvalid) + "\u662f\u5426\u4fdd\u5b58?")) {
                return;
            }
        }
        catch (Exception e) {
            WebBrowserUtil.openError(Messages.locationInvalid);
            return;
        }
        this.browser.save();
        super.okPressed();
    }

    private void setOKButtonEnabled(boolean curIsEnabled) {
        if (this.okButton == null) {
            this.okButton = this.getButton(0);
        }
        if (this.okButton != null) {
            this.okButton.setEnabled(curIsEnabled);
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonControl = super.createButtonBar(parent);
        this.validateFields();
        return buttonControl;
    }

    protected void validateFields() {
        String location;
        boolean valid = true;
        String name = this.browserNameTextfield.getText();
        if (name == null || name.trim().length() < 1) {
            valid = false;
        }
        if ((location = this.browserLocationTextfield.getText()) == null || location.trim().length() < 1) {
            valid = false;
        }
        this.setOKButtonEnabled(valid);
    }

    static interface StringModifyListener {
        public void valueChanged(String var1);
    }
}

