/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.viewer;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.scripting.snippets.ExpandSnippetVerifyKeyListener;
import com.aptana.editor.common.scripting.snippets.SnippetsContentAssistant;
import com.aptana.editor.common.viewer.CopyLineTransfer;
import com.aptana.formatter.IScriptFormatterFactory;
import com.aptana.formatter.ScriptFormatterManager;
import com.aptana.formatter.preferences.PreferencesLookupDelegate;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.internal.text.SelectionProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.texteditor.ITextEditor;

public class CommonProjectionViewer
extends ProjectionViewer
implements IAdaptable,
IEclipsePreferences.IPreferenceChangeListener {
    private static final int RULER_EDITOR_GAP = 0;
    protected ExpandSnippetVerifyKeyListener fKeyListener;
    protected IContentAssistant fSnippetContentAssistant;
    protected IEclipsePreferences fPreferenceStore;
    private Map<Class, Object> adapters = new HashMap<Class, Object>();

    public CommonProjectionViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
    }

    protected Layout createLayout() {
        return new SourceViewer.RulerLayout((SourceViewer)this, 0);
    }

    protected void handleDispose() {
        try {
            try {
                Field f = TextViewer.class.getDeclaredField("fWidgetCommand");
                if (f != null) {
                    f.setAccessible(true);
                    f.set((Object)this, null);
                }
            }
            catch (Throwable throwable) {
                super.handleDispose();
            }
        }
        finally {
            super.handleDispose();
        }
    }

    public IFormattingContext createFormattingContext() {
        IFormattingContext context;
        block6: {
            context = super.createFormattingContext();
            try {
                QualifiedContentType contentType = CommonEditorPlugin.getDefault().getDocumentScopeManager().getContentType(this.getDocument(), 0);
                if (contentType == null || contentType.getPartCount() <= 0) break block6;
                String[] stringArray = contentType.getParts();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IScriptFormatterFactory factory;
                    String ct = stringArray[n2];
                    String mainContentType = ct;
                    if (mainContentType.startsWith("com.aptana.contenttype.html") || mainContentType.startsWith("source.jsp") || mainContentType.startsWith("com.pandora.contenttype.html")) {
                        mainContentType = "com.aptana.contenttype.html";
                    }
                    if ((factory = ScriptFormatterManager.getSelected((String)mainContentType)) != null) {
                        factory.setMainContentType(contentType.getParts()[0]);
                        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
                        if (textEditor != null) {
                            IResource file = (IResource)textEditor.getEditorInput().getAdapter(IResource.class);
                            context.setProperty((Object)"formatting.context.formatterId", (Object)factory.getId());
                            IProject project = file != null ? file.getProject() : null;
                            Map preferences = factory.retrievePreferences(new PreferencesLookupDelegate(project));
                            context.setProperty((Object)"formatting.context.preferences", (Object)preferences);
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return context;
    }

    public void addAdapter(Class adapter, Object adapterObject) {
        if (adapter != null && adapterObject != null) {
            this.adapters.put(adapter, adapterObject);
        }
    }

    public void removeAdapter(Class adapter) {
        if (adapter != null) {
            this.adapters.remove(adapter);
        }
    }

    public Object getAdapter(Class adapter) {
        if (this.adapters.containsKey(adapter)) {
            return this.adapters.get(adapter);
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void configure(SourceViewerConfiguration configuration) {
        super.configure(configuration);
        this.fSnippetContentAssistant = new SnippetsContentAssistant();
        this.fSnippetContentAssistant.install((ITextViewer)this);
        this.fPreferenceStore = EclipseUtil.instanceScope().getNode("com.aptana.editor.common");
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
            this.setSnippetProcessorEnablement();
        }
    }

    public void unconfigure() {
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        if (this.fKeyListener != null) {
            this.removeVerifyKeyListener(this.fKeyListener);
            this.fKeyListener = null;
        }
        if (this.fSnippetContentAssistant != null) {
            this.fSnippetContentAssistant.uninstall();
            this.fSnippetContentAssistant = null;
        }
        super.unconfigure();
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if ("CONTENT_ASSIST_DELAY".equals(event.getKey())) {
            this.setSnippetProcessorEnablement();
        }
    }

    private void setSnippetProcessorEnablement() {
        if (this.fPreferenceStore == null || this.fKeyListener == null) {
            return;
        }
        int delay = this.fPreferenceStore.getInt("CONTENT_ASSIST_DELAY", 200);
        this.fKeyListener.setEnabled(delay >= 0);
    }

    public void doOperation(int operation) {
        StyledText textWidget = this.getTextWidget();
        if (textWidget == null) {
            return;
        }
        if (operation == 3) {
            ITextSelection selection;
            if (this.redraws() && (selection = this.copyToClipboard(textWidget, true)).getLength() > 0) {
                Point range = textWidget.getSelectionRange();
                this.fireSelectionChanged(range.x, range.y);
            }
            return;
        }
        if (operation == 4) {
            if (this.redraws()) {
                this.copyToClipboard(textWidget, false);
            }
        } else if (operation == 5) {
            boolean isPasted;
            block19: {
                isPasted = false;
                Clipboard clipboard = null;
                try {
                    try {
                        IRegion region;
                        String lineText;
                        TextTransfer plainTextTransfer = TextTransfer.getInstance();
                        clipboard = new Clipboard(textWidget.getDisplay());
                        Object object = clipboard.getContents((Transfer)plainTextTransfer, 1);
                        Boolean copyLine = (Boolean)clipboard.getContents((Transfer)CopyLineTransfer.getInstance(), 1);
                        String text = "";
                        if (object != null) {
                            text = (String)object;
                        }
                        IDocument document = this.getDocument();
                        ITextSelection selection = (ITextSelection)this.getSelection();
                        if (copyLine != null && copyLine.booleanValue() && (lineText = document.get((region = document.getLineInformationOfOffset(selection.getOffset())).getOffset(), region.getLength())) != null && lineText.length() > 0) {
                            text = String.valueOf(text) + "\r\n";
                            document.replace(region.getOffset(), 0, text);
                            isPasted = true;
                            int sOffset = selection.getOffset() + text.length();
                            textWidget.setSelection(sOffset, sOffset + selection.getLength());
                        }
                        clipboard.dispose();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (clipboard != null && !clipboard.isDisposed()) {
                            clipboard.dispose();
                        }
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    if (clipboard != null && !clipboard.isDisposed()) {
                        clipboard.dispose();
                    }
                    throw throwable;
                }
                if (clipboard != null && !clipboard.isDisposed()) {
                    clipboard.dispose();
                }
            }
            if (!isPasted) {
                super.doOperation(operation);
            }
        } else {
            super.doOperation(operation);
        }
    }

    public boolean canDoOperation(int operation) {
        StyledText textWidget = this.getTextWidget();
        if (textWidget == null) {
            return false;
        }
        switch (operation) {
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return super.canDoOperation(operation);
    }

    private ITextSelection copyToClipboard(StyledText textWidget, boolean delete) {
        ITextSelection oldSelection = (ITextSelection)this.getSelection();
        ITextSelection selection = this.computeSelection(oldSelection);
        if (selection.getLength() == 0) {
            this.copyMarkedRegion(delete);
        } else {
            this.copyToClipboard(selection, oldSelection.getLength() == 0, delete, textWidget);
        }
        return selection;
    }

    private ITextSelection computeSelection(ITextSelection selection) {
        block6: {
            try {
                IDocument document = this.getDocument();
                IRegion region = document.getLineInformationOfOffset(selection.getOffset());
                if (selection.getLength() != 0) {
                    int length;
                    int offset = selection.getOffset();
                    if (offset + (length = selection.getLength()) < region.getOffset() + region.getLength() || !this.isProjectionMode()) break block6;
                    ProjectionAnnotationModel projectionAnnotationModel = this.getProjectionAnnotationModel();
                    Iterator iterator = projectionAnnotationModel.getAnnotationIterator(offset, length, true, true);
                    while (iterator.hasNext()) {
                        Position position;
                        ProjectionAnnotation annotation = (ProjectionAnnotation)iterator.next();
                        if (!annotation.isCollapsed() || (position = projectionAnnotationModel.getPosition((Annotation)annotation)) == null || !position.overlapsWith(offset, length)) continue;
                        String closeText = document.get(position.getOffset(), position.getLength());
                        closeText = closeText.trim();
                        int slength = -1;
                        slength = offset + length > position.getOffset() + closeText.length() ? length : closeText.length() + position.getOffset() - offset;
                        selection = new TextSelection(document, offset, slength);
                        break block6;
                    }
                    break block6;
                }
                if (region.getLength() == 0) break block6;
                int offset = region.getOffset();
                selection = new TextSelection(document, offset, region.getLength());
                int length = region.getLength();
                if (!this.isProjectionMode()) break block6;
                ProjectionAnnotationModel projectionAnnotationModel = this.getProjectionAnnotationModel();
                Iterator iterator = projectionAnnotationModel.getAnnotationIterator(offset, length, true, true);
                while (iterator.hasNext()) {
                    Position position;
                    ProjectionAnnotation annotation = (ProjectionAnnotation)iterator.next();
                    if (!annotation.isCollapsed() || (position = projectionAnnotationModel.getPosition((Annotation)annotation)) == null || !position.overlapsWith(offset, length)) continue;
                    String closeText = document.get(position.getOffset(), position.getLength());
                    closeText = closeText.trim();
                    if (position.getOffset() > offset) {
                        closeText = String.valueOf(document.get(offset, position.getOffset() - offset)) + closeText;
                    }
                    selection = new TextSelection(document, offset, closeText.length());
                    break;
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return selection;
    }

    private void copyToClipboard(ITextSelection selection, boolean copyLine, boolean delete, StyledText textWidget) {
        String copyText = selection.getText();
        if (copyText == null) {
            textWidget.copy();
        }
        if (copyText != null && copyText.equals(textWidget.getSelectionText())) {
            textWidget.copy();
        } else if (copyText != null) {
            Clipboard clipboard = new Clipboard(textWidget.getDisplay());
            try {
                Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
                Object[] data = new Object[]{copyText};
                if (copyLine) {
                    dataTypes = new Transfer[]{TextTransfer.getInstance(), CopyLineTransfer.getInstance()};
                    data = new Object[]{copyText, true};
                }
                try {
                    clipboard.setContents(data, dataTypes);
                }
                catch (SWTError e) {
                    if (e.code != 2002) {
                        throw e;
                    }
                    clipboard.dispose();
                    return;
                }
            }
            finally {
                clipboard.dispose();
            }
        }
        if (delete) {
            try {
                new SelectionProcessor((ITextViewer)this).doDelete((ISelection)selection);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    protected void updateTextListeners(TextViewer.WidgetCommand cmd) {
        try {
            super.updateTextListeners(cmd);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        cmd.text = null;
    }
}

