/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.rules;

import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;

public abstract class QueuedTokenScanner
implements ITokenScanner {
    private final Queue<Entry> queue = new LinkedList<Entry>();
    private Entry current;

    protected QueuedTokenScanner() {
    }

    public final void queueToken(IToken token, int offset, int length) {
        this.queue.add(new Entry(token, offset, length));
    }

    public void setRange(IDocument document, int offset, int length) {
        this.queue.clear();
    }

    public IToken nextToken() {
        this.current = this.queue.poll();
        if (this.current != null) {
            return this.current.token;
        }
        return Token.EOF;
    }

    public final int getTokenOffset() {
        return this.current != null ? this.current.offset : 0;
    }

    public final int getTokenLength() {
        return this.current != null ? this.current.length : 0;
    }

    private static class Entry {
        private IToken token;
        private final int offset;
        private final int length;

        public Entry(IToken token, int offset, int length) {
            this.token = token;
            this.offset = offset;
            this.length = length;
        }
    }
}

