/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.rules;

import java.util.regex.Pattern;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;

public class EntityRule
extends SingleLineRule {
    private static final Pattern ENTITY_PATTERN = Pattern.compile("^&([a-zA-Z0-9]+|#[0-9]+|#x[0-9a-fA-F]+);\\z");

    public EntityRule(IToken token) {
        super("&", ";", token);
    }

    protected IToken doEvaluate(ICharacterScanner scanner, boolean resume) {
        int column = scanner.getColumn();
        IToken token = super.doEvaluate(scanner, resume);
        if (token.isUndefined()) {
            return token;
        }
        int read = scanner.getColumn() - column;
        int i = 0;
        while (i < read) {
            scanner.unread();
            ++i;
        }
        StringBuilder builder = new StringBuilder();
        int i2 = 0;
        while (i2 < read) {
            builder.append((char)scanner.read());
            ++i2;
        }
        String word = builder.toString();
        if (word.length() > 2 && ENTITY_PATTERN.matcher(word).find()) {
            return token;
        }
        int i3 = 0;
        while (i3 < read) {
            scanner.unread();
            ++i3;
        }
        return Token.UNDEFINED;
    }
}

