/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.rules;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.IExtendedPartitioner;
import com.aptana.editor.common.IPartitionerSwitchStrategy;
import com.aptana.editor.common.text.rules.IResumableRule;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.SingleTagRule;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.Token;

public final class CompositePartitionScanner
extends RuleBasedPartitionScanner {
    public static final String START_SWITCH_TAG = "__common_start_switch_tag";
    public static final String END_SWITCH_TAG = "__common_end_switch_tag";
    public static final String[] SWITCHING_CONTENT_TYPES = new String[]{"__common_start_switch_tag", "__common_end_switch_tag"};
    private final boolean traceEnabled = IdeLog.isTraceEnabled((Plugin)CommonEditorPlugin.getDefault(), (String)"com.aptana.editor.common/debug/partitioner");
    private ISubPartitionScanner defaultPartitionScanner;
    private ISubPartitionScanner primaryPartitionScanner;
    private ISubPartitionScanner currentPartitionScanner;
    private IPredicateRule[][] switchRules;
    private IExtendedPartitioner partitioner;
    private boolean hasSwitch;
    private boolean hasResume;
    private DefaultTokenState defaultTokenState;

    public CompositePartitionScanner(ISubPartitionScanner defaultPartitionScanner, ISubPartitionScanner primaryPartitionScanner, IPartitionerSwitchStrategy partitionerSwitchStrategy) {
        this.defaultPartitionScanner = defaultPartitionScanner;
        this.primaryPartitionScanner = primaryPartitionScanner;
        defaultPartitionScanner.initCharacterScanner((ICharacterScanner)this, partitionerSwitchStrategy.getDefaultSwitchStrategy());
        primaryPartitionScanner.initCharacterScanner((ICharacterScanner)this, partitionerSwitchStrategy.getPrimarySwitchStrategy());
        String[][] pairs = partitionerSwitchStrategy.getSwitchTagPairs();
        this.switchRules = new IPredicateRule[pairs.length][];
        int i = 0;
        while (i < pairs.length) {
            this.switchRules[i] = new IPredicateRule[]{new SingleTagRule(pairs[i][0], (IToken)new Token((Object)START_SWITCH_TAG)), new SingleTagRule(pairs[i][1], (IToken)new Token((Object)END_SWITCH_TAG))};
            ++i;
        }
        this.currentPartitionScanner = defaultPartitionScanner;
        this.setDefaultReturnToken((IToken)new Token((Object)"__dftl_partition_content_type"));
    }

    public void setPartitioner(IExtendedPartitioner partitioner) {
        this.partitioner = partitioner;
    }

    public void setPredicateRules(IPredicateRule[] rules) {
        throw new UnsupportedOperationException("unsupported method");
    }

    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.defaultTokenState = null;
        this.hasResume = false;
        CompositePartitionScanner.resetRules(this.defaultPartitionScanner.getRules());
        CompositePartitionScanner.resetRules(this.primaryPartitionScanner.getRules());
        this.currentPartitionScanner = this.defaultPartitionScanner;
        this.currentPartitionScanner.setLastToken((IToken)new Token((Object)contentType));
        if ("__dftl_partition_content_type".equals(contentType) && this.partitioner != null) {
            TypedPosition partition = this.partitioner.findClosestPosition(offset);
            if (partition != null && partition.overlapsWith(offset, length)) {
                partition = this.partitioner.findClosestPosition(offset - 1);
            }
            if (partition != null) {
                String type = partition.getType();
                if (this.primaryPartitionScanner.hasContentType(type)) {
                    this.currentPartitionScanner = this.primaryPartitionScanner;
                } else if (START_SWITCH_TAG.equals(type)) {
                    this.hasSwitch = true;
                }
                this.currentPartitionScanner.setLastToken((IToken)new Token((Object)type));
            }
        } else if (this.primaryPartitionScanner.hasContentType(contentType)) {
            this.currentPartitionScanner = this.primaryPartitionScanner;
        }
        super.setPartialRange(document, offset, length, contentType, partitionOffset);
    }

    private static void resetRules(IPredicateRule[] rules) {
        IPredicateRule[] iPredicateRuleArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            IPredicateRule rule = iPredicateRuleArray[n2];
            if (rule instanceof IResumableRule) {
                ((IResumableRule)rule).resetRule();
            }
            ++n2;
        }
    }

    public int getTokenOffset() {
        if (this.defaultTokenState != null && this.defaultTokenState.hasToken()) {
            return this.defaultTokenState.offset;
        }
        return super.getTokenOffset();
    }

    public int getTokenLength() {
        if (this.defaultTokenState != null && this.defaultTokenState.hasToken()) {
            return this.defaultTokenState.length;
        }
        return super.getTokenLength();
    }

    public int getColumn() {
        if (this.defaultTokenState != null && this.defaultTokenState.hasToken()) {
            return this.defaultTokenState.column;
        }
        return super.getColumn();
    }

    public IToken nextToken() {
        if (this.defaultTokenState != null && this.defaultTokenState.hasToken()) {
            IToken token = this.defaultTokenState.token;
            this.defaultTokenState = null;
            if (this.traceEnabled) {
                this.trace(MessageFormat.format("> {0} {1}:{2}", token.getData(), this.getTokenOffset(), this.getTokenLength()));
            }
            return token;
        }
        if (this.fContentType == null || this.hasSwitch) {
            return this.baseNextToken();
        }
        IToken token = this.doResumeContentType();
        if (token != null) {
            return token;
        }
        return this.baseNextToken();
    }

    private IToken doResumeContentType() {
        boolean doResetRules;
        if (this.fContentType == null) {
            return null;
        }
        this.fColumn = -1;
        boolean resume = this.fPartitionOffset > -1 && this.fPartitionOffset < this.fOffset;
        int n = this.fTokenOffset = resume ? this.fPartitionOffset : this.fOffset;
        if (this.hasResume) {
            resume = true;
            this.hasResume = false;
        }
        block0: do {
            doResetRules = false;
            IPredicateRule[] iPredicateRuleArray = this.currentPartitionScanner.getRules();
            int n2 = iPredicateRuleArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IPredicateRule rule = iPredicateRuleArray[n3];
                IToken token = rule.getSuccessToken();
                if (this.fContentType.equals(token.getData())) {
                    token = rule.evaluate(this.currentPartitionScanner.getCharacterScanner(), resume);
                    if (!token.isUndefined() && this.fOffset != this.fTokenOffset) {
                        this.fContentType = null;
                        this.currentPartitionScanner.setLastToken(token);
                        this.currentPartitionScanner.doResetRules();
                        return this.returnToken(token);
                    }
                    doResetRules = this.currentPartitionScanner.doResetRules();
                    if (doResetRules) continue block0;
                    if (this.hasSwitchingSequence()) {
                        this.fContentType = null;
                        return this.getDefaultToken();
                    }
                }
                ++n3;
            }
        } while (doResetRules);
        this.fContentType = null;
        if (resume && this.fPartitionOffset >= 0) {
            this.fOffset = this.fPartitionOffset;
            this.fPartitionOffset = -1;
        }
        return null;
    }

    private IToken baseNextToken() {
        this.fPartitionOffset = -1;
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        if (this.hasSwitch) {
            this.hasSwitch = false;
            boolean toPrimary = this.currentPartitionScanner == this.defaultPartitionScanner;
            int i = 0;
            while (i < this.switchRules.length) {
                IToken token = this.switchRules[i][toPrimary ? 0 : 1].evaluate((ICharacterScanner)this);
                if (!token.isUndefined()) {
                    this.currentPartitionScanner = toPrimary ? this.primaryPartitionScanner : this.defaultPartitionScanner;
                    IToken lastToken = this.currentPartitionScanner.getLastToken();
                    if (lastToken != null && lastToken.getData() instanceof String) {
                        this.fContentType = (String)lastToken.getData();
                        this.hasResume = true;
                    }
                    return this.returnToken(token);
                }
                ++i;
            }
        } else {
            boolean doResetRules;
            block1: do {
                doResetRules = false;
                IPredicateRule[] iPredicateRuleArray = this.currentPartitionScanner.getRules();
                int n = iPredicateRuleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPredicateRule rule = iPredicateRuleArray[n2];
                    IToken token = rule.evaluate(this.currentPartitionScanner.getCharacterScanner());
                    if (!token.isUndefined()) {
                        this.currentPartitionScanner.setLastToken(token);
                        this.currentPartitionScanner.doResetRules();
                        return this.returnToken(token);
                    }
                    doResetRules = this.currentPartitionScanner.doResetRules();
                    if (doResetRules) {
                        IToken resumeToken = this.currentPartitionScanner.getResumeToken();
                        if (resumeToken == null || !(resumeToken.getData() instanceof String)) continue block1;
                        this.fContentType = (String)resumeToken.getData();
                        this.hasResume = true;
                        token = this.doResumeContentType();
                        if (token == null) continue block1;
                        return token;
                    }
                    if (this.hasSwitchingSequence()) {
                        return this.getDefaultToken();
                    }
                    ++n2;
                }
            } while (doResetRules);
        }
        if (this.read() == -1) {
            return this.returnToken(Token.EOF);
        }
        this.currentPartitionScanner.setLastToken(null);
        return this.getDefaultToken();
    }

    private IToken getDefaultToken() {
        if (this.defaultTokenState == null) {
            this.defaultTokenState = new DefaultTokenState(this.currentPartitionScanner.getDefaultToken());
        }
        return this.fDefaultReturnToken;
    }

    private IToken returnToken(IToken token) {
        if (this.defaultTokenState != null) {
            if (this.defaultTokenState.saveToken(token)) {
                token = this.defaultTokenState.defaultToken;
            } else {
                this.defaultTokenState = null;
            }
        }
        if (this.traceEnabled) {
            this.trace(MessageFormat.format("> {0} {1}:{2}", token.getData(), this.getTokenOffset(), this.getTokenLength()));
        }
        return token;
    }

    private void trace(String string) {
        IdeLog.logTrace((Plugin)CommonEditorPlugin.getDefault(), (String)string);
    }

    private boolean hasSwitchingSequence() {
        if (this.currentPartitionScanner.foundSequence()) {
            this.hasSwitch = true;
            return true;
        }
        return false;
    }

    private class DefaultTokenState {
        private int offset;
        private int length;
        private int column;
        private IToken defaultToken;
        private IToken token;

        public DefaultTokenState(IToken defaultToken) {
            this.defaultToken = defaultToken;
            this.offset = CompositePartitionScanner.this.fTokenOffset;
            this.column = CompositePartitionScanner.this.getColumn();
        }

        public boolean saveToken(IToken token) {
            this.length = CompositePartitionScanner.this.fTokenOffset - this.offset;
            if (this.length == 0) {
                return false;
            }
            this.token = token;
            return true;
        }

        public boolean hasToken() {
            return this.token != null;
        }
    }
}

