/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.reconciler;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.LazyProxyDocumentProvider;
import com.aptana.editor.common.Regions;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.ui.util.UIUtils;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class CommonPresentationReconciler
extends PresentationReconciler {
    private boolean profile = Profile.STARTUP;
    private int iterationPartitionLimit = 4000;
    private int backgroundReconcileDelay = 2000;
    private int iterationDelay = 50;
    private int minimalVisibleLength = 2000;
    private ITextViewer textViewer;
    private Regions delayedRegions = new Regions();
    private IRegion viewerVisibleRegion;
    private Job job;
    private int jobNum;
    private AbstractThemeableEditor fEditor;
    long fLastModificationStamp = -1L;
    Job computePartitioningJob = null;

    public CommonPresentationReconciler(AbstractThemeableEditor editor) {
        this.fEditor = editor;
    }

    public void install(ITextViewer viewer) {
        super.install(viewer);
        this.delayedRegions.clear();
        this.textViewer = viewer;
        this.iterationPartitionLimit = Integer.getInteger("studio.reconcilerIterationPartitionLimit", this.iterationPartitionLimit);
        this.backgroundReconcileDelay = Integer.getInteger("studio.reconcilerBackgroundDelay", this.backgroundReconcileDelay);
        this.iterationDelay = Integer.getInteger("studio.reconcilerIterationDelay", this.iterationDelay);
        this.minimalVisibleLength = Integer.getInteger("studio.reconcilerMinimalVisibleLength", this.minimalVisibleLength);
        if (IdeLog.isTraceEnabled((Plugin)CommonEditorPlugin.getDefault(), (String)"com.aptana.editor.common/debug/presentation")) {
            IdeLog.logTrace((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Reconciling process set for partition limit of {0} partitions, background delay of {1}ms, iteration delay of {2}ms, and minimal visible length of {3} lines", this.iterationPartitionLimit, this.backgroundReconcileDelay, this.iterationDelay, this.minimalVisibleLength), (String)"com.aptana.editor.common/debug/presentation");
        }
    }

    public void uninstall() {
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        this.jobNum = 0;
        this.delayedRegions.clear();
        this.textViewer = null;
        super.uninstall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TextPresentation createPresentation(IRegion damage, IDocument document) {
        boolean isFullDamage;
        boolean bl = isFullDamage = damage.getOffset() == 0 && damage.getLength() == document.getLength();
        if (isFullDamage) {
            try {
                document.removePositionCategory("scopes");
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
        if (IdeLog.isInfoEnabled((Plugin)CommonEditorPlugin.getDefault(), (String)"com.aptana.editor.common/debug/presentation")) {
            IdeLog.logInfo((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Initiating presentation reconciling for region at offset {0}, length {1} in document of length {2}", damage.getOffset(), damage.getLength(), document.getLength()), (String)"com.aptana.editor.common/debug/presentation");
        }
        Regions regions = this.delayedRegions;
        synchronized (regions) {
            this.delayedRegions.append(damage);
        }
        NullProgressMonitor monitor = new NullProgressMonitor();
        boolean isLazy = this.fEditor != null && this.fEditor.getDocumentProvider() instanceof LazyProxyDocumentProvider;
        try {
            LazyProxyDocumentProvider proxy;
            if (isLazy && !(proxy = (LazyProxyDocumentProvider)this.fEditor.getDocumentProvider()).hasConnected()) {
                return null;
            }
            TextPresentation textPresentation = this.createPresentation(this.nextDamagedRegion(), document, (IProgressMonitor)monitor);
            return textPresentation;
        }
        catch (Exception exception) {
            if (!monitor.isCanceled()) {
                TextPresentation textPresentation = this.createPresentation(this.nextDamagedRegion(), document, (IProgressMonitor)monitor);
                return textPresentation;
            }
            return null;
        }
        finally {
            this.triggerDelayedCreatePresentation(isFullDamage, isLazy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected TextPresentation createPresentation(IRegion damage, IDocument document, IProgressMonitor monitor) {
        if (this.profile) {
            Profile.logEnter((String)"hbuilder.createPresentation");
        }
        try {
            int damageOffset = damage.getOffset();
            int damageLength = damage.getLength();
            if (damageOffset + damageLength > document.getLength()) {
                int adjustedLength = document.getLength() - damageOffset;
                Regions regions = this.delayedRegions;
                synchronized (regions) {
                    this.delayedRegions.remove(new IRegion[]{new Region(document.getLength(), damageLength - adjustedLength)});
                }
                if (adjustedLength <= 0) {
                    return null;
                }
                damageLength = adjustedLength;
            }
            TextPresentation presentation = new TextPresentation(damage, this.iterationPartitionLimit * 5);
            ITypedRegion[] partitioning = TextUtilities.computePartitioning((IDocument)document, (String)this.getDocumentPartitioning(), (int)damageOffset, (int)damageLength, (boolean)false);
            if (partitioning.length == 0) {
                return presentation;
            }
            int limit = Math.min(this.iterationPartitionLimit, partitioning.length);
            int processingLength = partitioning[limit - 1].getOffset() + partitioning[limit - 1].getLength() - damageOffset;
            if (EclipseUtil.showSystemJobs()) {
                monitor.subTask(MessageFormat.format("processing region at offset {0}, length {1} in document of length {2}", damageOffset, processingLength, document.getLength()));
            }
            int i = 0;
            while (true) {
                if (i >= limit) {
                    Regions regions = this.delayedRegions;
                    synchronized (regions) {
                        this.delayedRegions.remove(new IRegion[]{new Region(damageOffset, processingLength)});
                        if (limit < partitioning.length) {
                            int offset = partitioning[limit].getOffset();
                            this.delayedRegions.append(new IRegion[]{new Region(offset, damageOffset + damageLength - offset)});
                        }
                        break;
                    }
                }
                ITypedRegion r = partitioning[i];
                IPresentationRepairer repairer = this.getRepairer(r.getType());
                if (monitor.isCanceled()) {
                    return null;
                }
                if (repairer != null) {
                    repairer.createPresentation(presentation, r);
                }
                monitor.worked(r.getLength());
                ++i;
            }
            if (this.profile) {
                Profile.logExit((String)"hbuilder.createPresentation");
            }
            return presentation;
        }
        catch (BadLocationException badLocationException) {
            if (this.profile) {
                Profile.logExit((String)"hbuilder.createPresentation");
            }
            return null;
        }
    }

    protected Theme getCurrentTheme() {
        return ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDamage(IRegion damage, IDocument document, IProgressMonitor monitor) {
        if (damage != null && damage.getLength() > 0) {
            final TextPresentation[] presentation = new TextPresentation[1];
            if (document.getNumberOfLines() < 4000 && document.getLength() < 131072) {
                Object object = CommonPresentationReconciler.getLockObject(document);
                synchronized (object) {
                    presentation[0] = this.createPresentation(damage, document, monitor);
                }
            } else {
                presentation[0] = this.createPresentation(damage, document, monitor);
            }
            if (presentation[0] != null) {
                UIUtils.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ITextViewer viewer = CommonPresentationReconciler.this.textViewer;
                            if (viewer != null) {
                                StyledText widget = viewer.getTextWidget();
                                if (widget != null && !widget.isDisposed()) {
                                    viewer.changeTextPresentation(presentation[0], true);
                                }
                                int topOffset = viewer.getTopIndexStartOffset();
                                int length = viewer.getBottomIndexEndOffset() - topOffset;
                                CommonPresentationReconciler.this.viewerVisibleRegion = (IRegion)new Region(topOffset, Math.max(length, CommonPresentationReconciler.this.minimalVisibleLength));
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
    }

    private synchronized void triggerDelayedCreatePresentation(boolean full, final boolean isLazy) {
        if (isLazy && this.computePartitioningJob == null) {
            this.computePartitioningJob = new Job("Compute Partitioning"){

                protected IStatus run(IProgressMonitor monitor) {
                    CommonPresentationReconciler.this.doLazyDocumentProviderConnect();
                    return Status.OK_STATUS;
                }
            };
            this.computePartitioningJob.setSystem(true);
            this.computePartitioningJob.schedule();
        }
        if (this.job != null) {
            this.job.cancel();
        } else {
            this.job = new Job("Delayed Presentation Reconciler"){

                protected IStatus run(IProgressMonitor monitor) {
                    IDocument document;
                    int priority = Thread.currentThread().getPriority();
                    Thread.currentThread().setPriority(1);
                    IDocument iDocument = document = CommonPresentationReconciler.this.textViewer != null ? CommonPresentationReconciler.this.textViewer.getDocument() : null;
                    if (document == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (isLazy && CommonPresentationReconciler.this.computePartitioningJob != null) {
                        try {
                            CommonPresentationReconciler.this.computePartitioningJob.join();
                        }
                        catch (InterruptedException e) {
                            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                        }
                    }
                    monitor.beginTask("Reconciling document", document.getLength());
                    try {
                        while (CommonPresentationReconciler.this.textViewer != null && !monitor.isCanceled()) {
                            IRegion damage = CommonPresentationReconciler.this.nextDamagedRegion();
                            if (damage != null && !monitor.isCanceled() && CommonPresentationReconciler.this.textViewer != null) {
                                CommonPresentationReconciler.this.processDamage(damage, CommonPresentationReconciler.this.textViewer.getDocument(), monitor);
                                try {
                                    Thread.sleep(CommonPresentationReconciler.this.iterationDelay);
                                    continue;
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                    }
                    monitor.done();
                    Thread.currentThread().setPriority(priority);
                    return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                }
            };
            this.job.setPriority(50);
            this.job.setSystem(true);
        }
        if (this.job != null && !this.delayedRegions.isEmpty()) {
            this.job.schedule((long)this.backgroundReconcileDelay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRegion nextDamagedRegion() {
        if (this.viewerVisibleRegion == null && this.textViewer != null) {
            UIUtils.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ITextViewer viewer = CommonPresentationReconciler.this.textViewer;
                    if (viewer == null) {
                        return;
                    }
                    int topOffset = viewer.getTopIndexStartOffset();
                    int length = viewer.getBottomIndexEndOffset() - topOffset;
                    CommonPresentationReconciler.this.viewerVisibleRegion = (IRegion)new Region(topOffset, Math.max(length, CommonPresentationReconciler.this.minimalVisibleLength));
                }
            });
        }
        Regions regions = this.delayedRegions;
        synchronized (regions) {
            block7: {
                if (!this.delayedRegions.isEmpty()) break block7;
                return null;
            }
            if (this.viewerVisibleRegion != null) {
                IRegion visible = this.delayedRegions.overlap(this.viewerVisibleRegion);
                this.viewerVisibleRegion = null;
                if (visible != null) {
                    return visible;
                }
            }
            return this.delayedRegions.iterator().next();
        }
    }

    public void doLazyDocumentProviderConnect() {
        LazyProxyDocumentProvider lazy;
        IDocumentProvider provider = this.fEditor.getDocumentProvider();
        if (provider instanceof LazyProxyDocumentProvider && (lazy = (LazyProxyDocumentProvider)provider) != null) {
            lazy.doConnect(this.fEditor);
        }
    }

    private static Object getLockObject(Object object) {
        Object lock;
        if (object instanceof ISynchronizable && (lock = ((ISynchronizable)object).getLockObject()) != null) {
            return lock;
        }
        return object;
    }
}

