/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.outline.PathResolverProvider;
import com.aptana.editor.common.resolver.IPathResolver;
import com.aptana.editor.common.text.hyperlink.URIHyperlink;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlinkDetector;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class HyperlinkDetector
extends URLHyperlinkDetector {
    private static Pattern URL_METHOD_PATTERN = null;

    static {
        String urlReg = "url\\s*\\(([^)]*)\\)";
        URL_METHOD_PATTERN = Pattern.compile(urlReg);
    }

    public static void main(String[] args) {
        Matcher matcher = URL_METHOD_PATTERN.matcher("url(:ljlk/ada\u98de\u6d12\u5730\u65b9d.sjd) akjhkjhkakd;:adhk url(ad/adsf.kpg)");
        while (matcher.find()) {
            System.out.println(matcher.group(1));
        }
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String value;
        String line;
        IRegion lineInfo;
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        Object[] result = null;
        int offset = region.getOffset();
        IRegion hyperLinkRegion = region;
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
            value = document.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        int relativeOffset = region.getOffset() - lineInfo.getOffset();
        try {
            int beforeIndex = -1;
            int quote = 34;
            int i = relativeOffset - 1;
            while (i >= 0) {
                if (line.charAt(i) == '\'') {
                    quote = 39;
                    beforeIndex = i;
                    break;
                }
                if (line.charAt(i) == '\"') {
                    quote = 34;
                    beforeIndex = i;
                    break;
                }
                --i;
            }
            int afterIndex = line.indexOf(quote, beforeIndex + 1);
            if (afterIndex != -1 && beforeIndex != -1) {
                value = line.substring(beforeIndex + 1, afterIndex);
                hyperLinkRegion = new Region(lineInfo.getOffset() + beforeIndex + 1, value.length());
            }
        }
        catch (Exception exception) {}
        Matcher matcher = URL_METHOD_PATTERN.matcher(line);
        while (matcher.find()) {
            int startOffset = matcher.start(1);
            int endOffset = matcher.end(1);
            if (startOffset > relativeOffset || endOffset < relativeOffset) continue;
            value = matcher.group(1);
            hyperLinkRegion = new Region(lineInfo.getOffset() + startOffset, value.length());
            break;
        }
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        IEditorPart part = (IEditorPart)this.getAdapter(IEditorPart.class);
        if (part == null) {
            return null;
        }
        IEditorInput input = part.getEditorInput();
        IPathResolver resolver = PathResolverProvider.getResolver(input);
        try {
            File uriFile;
            URI uri = null;
            URI valueUri = null;
            try {
                valueUri = value.startsWith("//") ? URI.create("http:" + value) : URI.create(value);
                if (valueUri != null && valueUri.getScheme() == null) {
                    uri = resolver.resolveURI(value);
                }
            }
            catch (Exception exception) {}
            if (uri != null && (uriFile = new File(uri)).exists()) {
                return new IHyperlink[]{new URIHyperlink(hyperLinkRegion, uri)};
            }
            if (valueUri != null) {
                result = new IHyperlink[]{new URLHyperlink(hyperLinkRegion, valueUri.toString())};
            }
        }
        catch (Exception e) {
            IdeLog.logInfo((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Failed to resolve ''{0}'' as hyperlink url", value), (Throwable)e, (String)"com.aptana.editor.common/debug");
        }
        if (ArrayUtil.isEmpty((Object[])result) && ArrayUtil.isEmpty((Object[])(result = super.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks)))) {
            return null;
        }
        ArrayList<URIHyperlink> ours = new ArrayList<URIHyperlink>(result.length);
        Object[] objectArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            Object link = objectArray[n2];
            URLHyperlink hyperlink = (URLHyperlink)link;
            try {
                URIHyperlink wrapped = new URIHyperlink(hyperlink);
                ours.add(wrapped);
            }
            catch (URISyntaxException use) {
                IdeLog.logInfo((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Failed to resolve URI: {0}", hyperlink.getURLString()), (Throwable)use, (String)"com.aptana.editor.common/debug");
            }
            catch (MalformedURLException mue) {
                IdeLog.logInfo((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Failed to resolve URI: {0}", hyperlink.getURLString()), (Throwable)mue, (String)"com.aptana.editor.common/debug");
            }
            ++n2;
        }
        if (ours.isEmpty()) {
            return null;
        }
        return ours.toArray(new IHyperlink[ours.size()]);
    }
}

