/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.text;

import com.aptana.core.util.StringUtil;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public abstract class CommonAutoIndentStrategy
implements IAutoEditStrategy {
    protected static final String SPACE = " ";
    protected static final char COMMENT_CHAR = '*';
    protected static final String DOCUMENTATION_START = "/**";
    protected static final String COMMENT_END = "*/";
    protected static final String COMMENT_START = "/*";
    private String fContentType;
    private SourceViewerConfiguration fViewerConfiguration;
    private ISourceViewer fSourceViewer;
    private IPreferenceStore fPrefStore;

    protected CommonAutoIndentStrategy(String contentType, SourceViewerConfiguration configuration, ISourceViewer sourceViewer, IPreferenceStore prefStore) {
        this.fContentType = contentType;
        this.fViewerConfiguration = configuration;
        this.fSourceViewer = sourceViewer;
        this.fPrefStore = prefStore;
    }

    protected SourceViewerConfiguration getSourceViewerConfiguration() {
        return this.fViewerConfiguration;
    }

    protected ISourceViewer getSourceViewer() {
        return this.fSourceViewer;
    }

    public int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    protected void autoIndentAfterNewLine(IDocument d, DocumentCommand c, boolean change) {
        String text = this.getAutoIndentAfterNewLine(d, c, change);
        c.text = text == null ? "" : String.valueOf(c.text) + text;
    }

    protected abstract boolean autoIndent(IDocument var1, DocumentCommand var2);

    public String getAutoIndentAfterNewLine(IDocument d, DocumentCommand c) {
        return this.getAutoIndentAfterNewLine(d, c, true);
    }

    public String getAutoIndentAfterNewLine(IDocument d, DocumentCommand c, boolean change) {
        if (c.offset == -1 || d.getLength() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        try {
            IRegion info = d.getLineInformationOfOffset(c.offset);
            int start = info.getOffset();
            int end = this.findEndOfWhiteSpace(d, start, c.offset);
            String indent = "";
            char c1 = d.getChar(end);
            if (end > start) {
                indent = d.get(start, end - start);
            }
            buf.append(indent);
            String line = d.get(info.getOffset(), info.getLength());
            int lineOffset = c.offset - info.getOffset();
            String upToOffset = line.substring(0, lineOffset);
            String trimmedUpToOffset = upToOffset.trim();
            if (change && c1 == '*' && !trimmedUpToOffset.startsWith(COMMENT_END) && upToOffset.lastIndexOf(COMMENT_END) <= upToOffset.lastIndexOf(COMMENT_START) && this.isComment(c.offset)) {
                buf.append('*');
                if (d.getChar(c.offset) != '/') {
                    buf.append(' ');
                }
            } else if (change && trimmedUpToOffset.startsWith(COMMENT_START) && !upToOffset.contains(COMMENT_END)) {
                String commentIndent = SPACE;
                String restOfLine = line.substring(lineOffset);
                String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
                if (trimmedUpToOffset.startsWith(DOCUMENTATION_START)) {
                    this.handleScriptDoc(d, c, buf, commentIndent, lineDelimiter);
                } else if (!StringUtil.startsWith((String)restOfLine, (char)'*')) {
                    buf.append(commentIndent).append('*').append(SPACE);
                } else {
                    buf.append(commentIndent);
                }
                if (restOfLine.contains(COMMENT_END)) {
                    return buf.toString();
                }
                if (this.checkNextLineForComment(d, c)) {
                    return buf.toString();
                }
                String toEnd = " */";
                if (change) {
                    d.replace(c.offset, 0, String.valueOf(lineDelimiter) + indent + toEnd);
                }
            } else if (change && (trimmedUpToOffset.endsWith(COMMENT_START) || trimmedUpToOffset.endsWith(DOCUMENTATION_START))) {
                int index = line.lastIndexOf(COMMENT_START);
                String restOfLine = line.substring(0, index);
                String commentIndent = StringUtil.pad((String)"", (int)(restOfLine.length() - indent.length() + 1), (char)' ');
                String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
                if (trimmedUpToOffset.endsWith(DOCUMENTATION_START)) {
                    this.handleScriptDoc(d, c, buf, commentIndent, lineDelimiter);
                } else {
                    buf.append(commentIndent).append('*').append(SPACE);
                }
                if (this.checkNextLineForComment(d, c)) {
                    return buf.toString();
                }
                String toEnd = String.valueOf(commentIndent) + COMMENT_END;
                d.replace(c.offset, 0, String.valueOf(lineDelimiter) + indent + toEnd);
            } else if (change && buf.length() != 0 && upToOffset.endsWith(COMMENT_END) && buf.charAt(buf.length() - 1) == ' ') {
                buf.deleteCharAt(buf.length() - 1);
            }
        }
        catch (BadLocationException badLocationException) {}
        return buf.toString();
    }

    protected boolean checkNextLineForComment(IDocument document, DocumentCommand command) {
        try {
            int line = document.getLineOfOffset(command.offset);
            IRegion nextLineInfo = document.getLineInformation(line + 1);
            String nextLine = document.get(nextLineInfo.getOffset(), nextLineInfo.getLength()).trim();
            return StringUtil.startsWith((String)nextLine, (char)'*') && !StringUtil.startsWith((String)nextLine, (String)COMMENT_END) || nextLine.endsWith(COMMENT_END);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected void handleScriptDoc(IDocument document, DocumentCommand command, StringBuilder buf, String commentIndent, String lineDelimiter) {
        String indent = buf.toString();
        buf.append(commentIndent).append('*').append(SPACE);
        command.shiftsCaret = false;
        command.caretOffset = command.offset + buf.length() + 2;
        List<String> list = this.getAdditionalComments(document, command);
        if (list != null && list.size() > 0) {
            buf.append(lineDelimiter).append(indent).append(commentIndent).append('*').append(SPACE);
            buf.append(StringUtil.join((String)(String.valueOf(lineDelimiter) + indent + commentIndent + '*' + SPACE), list));
        }
    }

    protected List<String> getAdditionalComments(IDocument d, DocumentCommand c) {
        return null;
    }

    protected boolean isComment(int offset) {
        if ("__dftl_partition_content_type".equals(this.fContentType)) {
            return false;
        }
        return this.fContentType.contains("_comment");
    }

    protected String getIndentationString(IDocument d, int offset, int end) {
        int indentStringWidth;
        char[] indentChars;
        String lineIndent = "";
        try {
            lineIndent = d.get(offset, end - offset);
        }
        catch (BadLocationException badLocationException) {}
        if (lineIndent.equals("")) {
            return lineIndent;
        }
        int indentSize = 0;
        int tabWidth = Math.max(1, this.getTabWidth());
        char[] cArray = indentChars = lineIndent.toCharArray();
        int n = indentChars.length;
        int n2 = 0;
        while (n2 < n) {
            char e = cArray[n2];
            indentSize = e == '\t' ? (indentSize += tabWidth - indentSize % tabWidth) : ++indentSize;
            ++n2;
        }
        String indentCharStr = this.getIndentCharString();
        int n3 = indentStringWidth = indentCharStr.equals("\t") ? tabWidth : indentCharStr.length();
        if (indentStringWidth == 0) {
            return "";
        }
        String indentation = "";
        int indentCount = indentSize / indentStringWidth;
        int i = 0;
        while (i < indentCount) {
            indentation = String.valueOf(indentation) + indentCharStr;
            ++i;
        }
        int spaceCount = indentSize % indentStringWidth;
        int i2 = 0;
        while (i2 < spaceCount) {
            indentation = String.valueOf(indentation) + SPACE;
            ++i2;
        }
        return indentation;
    }

    protected int getTabWidth() {
        return this.fViewerConfiguration.getTabWidth(this.fSourceViewer);
    }

    protected String getIndentCharString() {
        String[] indents = this.fViewerConfiguration.getIndentPrefixes(this.fSourceViewer, this.fContentType);
        boolean hasIndents = indents != null && indents.length > 0;
        return hasIndents ? indents[0] : "\t";
    }

    protected static boolean isLineDelimiter(IDocument d, String text) {
        String[] delimiters = d.getLegalLineDelimiters();
        if (delimiters == null) {
            return false;
        }
        return TextUtilities.equals((String[])delimiters, (String)text) > -1;
    }

    protected boolean shouldAutoIndent() {
        if (this.fPrefStore != null) {
            return this.fPrefStore.getBoolean("com.aptana.editor.common.autoIndent");
        }
        return true;
    }
}

