/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.scripting.snippets;

import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.snippets.Messages;
import com.aptana.editor.common.scripting.snippets.SnippetsCompletionProcessor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SnippetsContentAssistant
extends ContentAssistant {
    static final int MAX_HEIGHT = "win32".equals(Platform.getOS()) ? 12 : 14;
    private IContentAssistProcessor contentAssistProcessor;

    public SnippetsContentAssistant() {
        this.enableAutoActivation(false);
        this.enablePrefixCompletion(true);
        this.enableAutoInsert(true);
        this.enableColoredLabels(true);
        this.setRestoreCompletionProposalSize(CommonEditorPlugin.getDefault().getDialogSettings());
        this.setStatusLineVisible(true);
        this.setStatusMessage(Messages.SnippetsContentAssistant_MSG_SelectNthSnippet);
        this.setInformationControlCreator((IInformationControlCreator)new DefaultInformationControlCreator());
    }

    public IContentAssistProcessor getContentAssistProcessor(String contentType) {
        if (this.contentAssistProcessor == null) {
            this.contentAssistProcessor = new SnippetsCompletionProcessor();
        }
        return this.contentAssistProcessor;
    }

    protected void possibleCompletionsClosed() {
        super.possibleCompletionsClosed();
        if (this.contentAssistProcessor != null) {
            ((SnippetsCompletionProcessor)this.contentAssistProcessor).possibleCompletionsClosed();
        }
    }

    private static class DefaultInformationControlCreator
    extends AbstractReusableInformationControlCreator {
        private DefaultInformationControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell shell) {
            DefaultInformationControl defaultInformationControl = new DefaultInformationControl(shell, new StringInformationPresenter()){
                private Font maxHeightTextFont;

                protected void createContent(Composite parent) {
                    Control[] children;
                    super.createContent(parent);
                    Control[] controlArray = children = parent.getChildren();
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (control instanceof StyledText) {
                            StyledText styledText = (StyledText)control;
                            Font textFont = JFaceResources.getFont((String)"org.eclipse.jface.textfont");
                            FontData[] textFontData = textFont.getFontData();
                            if (textFontData[0].getHeight() > MAX_HEIGHT) {
                                if (this.maxHeightTextFont == null) {
                                    this.maxHeightTextFont = new Font(textFont.getDevice(), textFontData[0].getName(), MAX_HEIGHT, textFontData[0].getStyle());
                                }
                                styledText.setFont(this.maxHeightTextFont);
                            } else {
                                styledText.setFont(textFont);
                            }
                        }
                        ++n2;
                    }
                }

                public void dispose() {
                    if (this.maxHeightTextFont != null) {
                        if (!this.maxHeightTextFont.isDisposed()) {
                            this.maxHeightTextFont.dispose();
                        }
                        this.maxHeightTextFont = null;
                    }
                    super.dispose();
                }
            };
            return defaultInformationControl;
        }
    }

    private static class StringInformationPresenter
    implements DefaultInformationControl.IInformationPresenter {
        private StringInformationPresenter() {
        }

        public String updatePresentation(Display display, String hoverInfo, TextPresentation presentation, int maxWidth, int maxHeight) {
            return hoverInfo;
        }
    }
}

