/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.scripting.snippets;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.IDocumentScopeManager;
import com.aptana.editor.common.scripting.snippets.SnippetsCompletionProcessor;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.TriggerType;
import com.aptana.scripting.model.filters.AndFilter;
import com.aptana.scripting.model.filters.HasTriggerFilter;
import com.aptana.scripting.model.filters.IModelFilter;
import com.aptana.scripting.model.filters.ScopeFilter;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.ITextEditorExtension2;

public class ExpandSnippetVerifyKeyListener
implements VerifyKeyListener {
    private final ITextEditor textEditor;
    private final ITextViewer textViewer;
    private final IDocument document;
    private final boolean canModifyEditor;
    private final IContentAssistant contentAssistant;
    private boolean enableSnippetProposals = true;

    public ExpandSnippetVerifyKeyListener(ITextEditor textEditor, ITextViewer viewer, IContentAssistant contentAssistant) {
        this.textEditor = textEditor;
        this.canModifyEditor = this.canModifyEditor(textEditor);
        this.textViewer = viewer;
        this.contentAssistant = contentAssistant;
        this.document = textEditor != null ? textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput()) : null;
    }

    public void verifyKey(VerifyEvent event) {
        if (!(this.textViewer != null && this.document != null && this.contentAssistant != null && this.canModifyEditor && event.doit && event.character == '\t' && this.enableSnippetProposals)) {
            return;
        }
        if (LinkedModeModel.hasInstalledModel((IDocument)this.document)) {
            return;
        }
        ITextSelection selection = this.getSelection();
        if (selection.getLength() == 0) {
            try {
                int caretOffset;
                List<CommandElement> commandsFromScope;
                char previousChar = this.document.getChar(selection.getOffset() - 1);
                if (!Character.isWhitespace(previousChar) && !CollectionsUtil.isEmpty(commandsFromScope = this.getSnippetsInScope(caretOffset = this.textViewer.getTextWidget().getCaretOffset()))) {
                    String prefix = SnippetsCompletionProcessor.extractPrefixFromDocument(this.document, caretOffset);
                    while (prefix != null && prefix.length() > 0) {
                        if (this.hasMatchingSnippet(prefix, commandsFromScope)) {
                            this.contentAssistant.showPossibleCompletions();
                            event.doit = false;
                            return;
                        }
                        prefix = SnippetsCompletionProcessor.narrowPrefix(prefix);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                return;
            }
        }
    }

    protected List<CommandElement> getSnippetsInScope(int caretOffset) {
        String scope = this.getScope(this.textViewer, caretOffset);
        AndFilter filter = new AndFilter(new IModelFilter[]{new ScopeFilter(scope), new HasTriggerFilter()});
        return this.getBundleManager().getExecutableCommands((IModelFilter)filter);
    }

    protected ITextSelection getSelection() {
        if (this.textEditor == null || this.textEditor.getSelectionProvider() == null) {
            return TextSelection.emptySelection();
        }
        return (ITextSelection)this.textEditor.getSelectionProvider().getSelection();
    }

    protected BundleManager getBundleManager() {
        return BundleManager.getInstance();
    }

    protected boolean hasMatchingSnippet(String prefix, List<CommandElement> commandsFromScope) {
        for (CommandElement commandElement : commandsFromScope) {
            Object[] triggers = commandElement.getTriggerTypeValues(TriggerType.PREFIX);
            if (ArrayUtil.isEmpty((Object[])triggers)) continue;
            Object[] objectArray = triggers;
            int n = triggers.length;
            int n2 = 0;
            while (n2 < n) {
                Object trigger = objectArray[n2];
                if (ObjectUtil.areEqual((Object)prefix, (Object)trigger)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void setEnabled(boolean enabled) {
        this.enableSnippetProposals = enabled;
    }

    public boolean isEnabled() {
        return this.enableSnippetProposals;
    }

    private boolean canModifyEditor(ITextEditor editor) {
        if (editor instanceof ITextEditorExtension2) {
            return ((ITextEditorExtension2)editor).isEditorInputModifiable();
        }
        if (editor instanceof ITextEditorExtension) {
            return !((ITextEditorExtension)editor).isEditorInputReadOnly();
        }
        if (editor != null) {
            return editor.isEditable();
        }
        return false;
    }

    private String getScope(ITextViewer viewer, int offset) {
        String scope = "";
        try {
            scope = this.getDocumentScopeManager().getScopeAtOffset(viewer, offset);
        }
        catch (BadLocationException badLocationException) {}
        return scope;
    }

    protected IDocumentScopeManager getDocumentScopeManager() {
        return CommonEditorPlugin.getDefault().getDocumentScopeManager();
    }
}

