/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.scripting.commands;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class EnvironmentDialog
extends Dialog {
    private Map<String, String> environment = new TreeMap<String, String>();
    private Color oddRowColor;

    protected EnvironmentDialog(Shell shell, Map<String, String> environment) {
        super(shell);
        this.environment.putAll(environment);
        this.environment.putAll(new ProcessBuilder("").environment());
    }

    public boolean close() {
        boolean close = super.close();
        if (this.oddRowColor != null) {
            this.oddRowColor.dispose();
            this.oddRowColor = null;
        }
        return close;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new FillLayout());
        Table table = new Table(composite, 100352);
        TableColumn nameColumn = new TableColumn(table, 0);
        TableColumn valueColumn = new TableColumn(table, 0);
        for (String name : this.environment.keySet()) {
            String value = this.environment.get(name);
            TableItem item = new TableItem(table, 0);
            item.setText(new String[]{name, value});
        }
        table.setSelection(0);
        table.deselectAll();
        if (this.oddRowColor == null) {
            this.oddRowColor = new Color((Device)parent.getDisplay(), 240, 240, 250);
        }
        TableItem[] items = table.getItems();
        int i = 0;
        while (i < items.length) {
            if (i % 2 == 0) {
                items[i].setBackground(this.oddRowColor);
            }
            ++i;
        }
        nameColumn.pack();
        valueColumn.pack();
        return composite;
    }
}

