/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.scripting.commands;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.commands.Messages;
import com.aptana.editor.common.scripting.commands.Utilities;
import com.aptana.editor.common.scripting.snippets.SnippetsCompletionProcessor;
import com.aptana.scripting.ScriptLogger;
import com.aptana.scripting.ScriptUtils;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.InputType;
import com.aptana.scripting.model.InvocationType;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.BreakIterator;
import java.text.MessageFormat;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class CommandExecutionUtils {
    private static final String NEW_DOCUMENT_TITLE = "Untitled.txt";
    private static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    private static final String HTML_FILE_EXTENSION = ".html";
    public static final FilterInputProvider EOF = new StringInputProvider();
    private static final long DELAY = 10000L;
    static final String DEFAULT_CONSOLE_NAME = Messages.CommandExecutionUtils_DefaultConsoleName;
    public static final FilterOutputConsumer DISCARD = new PrintStreamOutputConsumer();
    public static final FilterOutputConsumer TO_SYSOUT = new PrintStreamOutputConsumer(System.out);
    public static final FilterOutputConsumer TO_SYSERR = new PrintStreamOutputConsumer(System.err);
    private static Map<String, IOConsole> nameToMessageConsole = new WeakHashMap<String, IOConsole>();

    public static CommandResult executeCommand(CommandElement command, InvocationType invocationType, ITextEditor textEditor) {
        Object adapter;
        ITextViewer textViewer = null;
        if (textEditor != null && (adapter = textEditor.getAdapter(ITextOperationTarget.class)) instanceof ITextViewer) {
            textViewer = (ITextViewer)adapter;
        }
        return CommandExecutionUtils.executeCommand(command, invocationType, textViewer, textEditor);
    }

    public static CommandResult executeCommand(CommandElement command, InvocationType invocationType, ITextViewer textViewer, ITextEditor textEditor) {
        InputType selected = InputType.UNDEFINED;
        InputType[] inputTypes = command.getInputTypes();
        if (inputTypes == null || inputTypes.length == 0) {
            inputTypes = new InputType[]{InputType.UNDEFINED};
        }
        FilterInputProvider filterInputProvider = null;
        if (textViewer != null) {
            InputType[] inputTypeArray = inputTypes;
            int n = inputTypes.length;
            int n2 = 0;
            while (n2 < n) {
                InputType inputType = inputTypeArray[n2];
                try {
                    filterInputProvider = CommandExecutionUtils.getInputProvider(textViewer, command, inputType);
                    if (filterInputProvider != null) {
                        selected = inputType;
                        break;
                    }
                }
                catch (BadLocationException e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                }
                ++n2;
            }
        }
        if (filterInputProvider == null) {
            filterInputProvider = EOF;
            selected = inputTypes[0];
        }
        long start = System.currentTimeMillis();
        CommandContext commandContext = command.createCommandContext();
        IdeLog.logInfo((Plugin)CorePlugin.getDefault(), (String)("command.createCommandContext(): " + (System.currentTimeMillis() - start)));
        start = System.currentTimeMillis();
        commandContext.setInputStream(filterInputProvider.getInputStream());
        commandContext.put("input_type", (Object)selected.getName());
        commandContext.put("invoked_via", (Object)invocationType.getName());
        CommandResult commandResult = command.execute(commandContext);
        IdeLog.logInfo((Plugin)CorePlugin.getDefault(), (String)("command.execute: " + (System.currentTimeMillis() - start)));
        start = System.currentTimeMillis();
        return commandResult;
    }

    protected static FilterInputProvider getInputProvider(ITextViewer textWidget, CommandElement command, InputType inputType) throws BadLocationException {
        Point selectionRange = textWidget.getSelectedRange();
        switch (inputType) {
            case UNDEFINED: 
            case NONE: {
                return EOF;
            }
            case SELECTION: {
                if (selectionRange.y == 0) {
                    return null;
                }
                IRegion selectedRegion = CommandExecutionUtils.getSelectedRegion(textWidget);
                return new StringInputProvider(textWidget.getDocument().get(selectedRegion.getOffset(), selectedRegion.getLength()));
            }
            case SELECTED_LINES: {
                if (selectionRange.y == 0) {
                    return null;
                }
                IRegion region = CommandExecutionUtils.getSelectedLinesRegion(textWidget);
                return new StringInputProvider(textWidget.getDocument().get(region.getOffset(), region.getLength()));
            }
            case DOCUMENT: {
                return new StringInputProvider(textWidget.getDocument().get());
            }
            case LEFT_CHAR: {
                if (CommandExecutionUtils.getCaretOffset(textWidget) < 1) {
                    return null;
                }
                return new StringInputProvider(textWidget.getDocument().get(CommandExecutionUtils.getCaretOffset(textWidget) - 1, 1));
            }
            case RIGHT_CHAR: {
                if (CommandExecutionUtils.getCaretOffset(textWidget) < CommandExecutionUtils.getEndOffset(textWidget)) {
                    return new StringInputProvider(textWidget.getDocument().get(CommandExecutionUtils.getCaretOffset(textWidget), 1));
                }
                return null;
            }
            case CLIPBOARD: {
                String contents = CommandExecutionUtils.getClipboardContents();
                if (contents == null || contents.trim().length() == 0) {
                    return null;
                }
                return new StringInputProvider(contents);
            }
            case LINE: {
                return new StringInputProvider(CommandExecutionUtils.getCurrentLineText(textWidget));
            }
            case WORD: {
                String currentWord = CommandExecutionUtils.findWord(textWidget);
                if (currentWord == null || currentWord.trim().length() == 0) {
                    return null;
                }
                return new StringInputProvider(currentWord);
            }
            case INPUT_FROM_CONSOLE: {
                return new EclipseConsoleInputProvider(DEFAULT_CONSOLE_NAME);
            }
            case INPUT_FROM_FILE: {
                return new FileInputProvider(command.getInputPath());
            }
        }
        return null;
    }

    private static String getCurrentLineText(ITextViewer textWidget) throws BadLocationException {
        IRegion region = CommandExecutionUtils.getCurrentLineRegion(textWidget);
        return textWidget.getDocument().get(region.getOffset(), region.getLength());
    }

    public static void processCommandResult(CommandElement command, CommandResult commandResult, ITextEditor textEditor) {
        Object adapter;
        ITextViewer textViewer = null;
        if (textEditor != null && (adapter = textEditor.getAdapter(ITextOperationTarget.class)) instanceof ITextViewer) {
            textViewer = (ITextViewer)adapter;
        }
        CommandExecutionUtils.processCommandResult(command, commandResult, textViewer);
    }

    public static void processCommandResult(CommandElement command, CommandResult commandResult, ITextViewer textViewer) {
        if (commandResult == null) {
            return;
        }
        if (!commandResult.executedSuccessfully()) {
            CommandExecutionUtils.outputToConsole(commandResult);
            return;
        }
        switch (commandResult.getOutputType()) {
            case UNDEFINED: 
            case DISCARD: {
                break;
            }
            case SHOW_AS_HTML: {
                CommandExecutionUtils.showAsHTML(command, commandResult);
                break;
            }
            case CREATE_NEW_DOCUMENT: {
                CommandExecutionUtils.createNewDocument(commandResult);
                break;
            }
            case COPY_TO_CLIPBOARD: {
                CommandExecutionUtils.copyToClipboard(commandResult);
                break;
            }
            case OUTPUT_TO_CONSOLE: {
                CommandExecutionUtils.outputToConsole(commandResult);
                break;
            }
            case OUTPUT_TO_FILE: {
                CommandExecutionUtils.outputToFile(commandResult);
            }
        }
        if (textViewer == null) {
            return;
        }
        try {
            int caretOffset = CommandExecutionUtils.getCaretOffset(textViewer);
            switch (commandResult.getOutputType()) {
                case REPLACE_SELECTION: {
                    if (commandResult.getInputType() == InputType.DOCUMENT) {
                        CommandExecutionUtils.replaceDocument(textViewer, commandResult);
                        break;
                    }
                    if (commandResult.getInputType() == InputType.LINE) {
                        CommandExecutionUtils.replaceLine(textViewer, commandResult);
                        break;
                    }
                    if (commandResult.getInputType() == InputType.WORD) {
                        CommandExecutionUtils.replaceWord(textViewer, commandResult);
                        break;
                    }
                    IRegion region = CommandExecutionUtils.getSelectedRegion(textViewer);
                    if (commandResult.getInputType() == InputType.RIGHT_CHAR) {
                        region = new Region(caretOffset, 1);
                    } else if (commandResult.getInputType() == InputType.LEFT_CHAR) {
                        region = new Region(caretOffset - 1, 1);
                    } else if (commandResult.getInputType() == InputType.SELECTED_LINES) {
                        region = CommandExecutionUtils.getSelectedLinesRegion(textViewer);
                    }
                    CommandExecutionUtils.replaceTextRange(textViewer, region, commandResult.getOutputString());
                    break;
                }
                case REPLACE_SELECTED_LINES: {
                    IRegion selectedLines = CommandExecutionUtils.getSelectedLinesRegion(textViewer);
                    CommandExecutionUtils.replaceTextRange(textViewer, selectedLines, commandResult.getOutputString());
                    break;
                }
                case REPLACE_LINE: {
                    CommandExecutionUtils.replaceLine(textViewer, commandResult);
                    break;
                }
                case REPLACE_WORD: {
                    CommandExecutionUtils.replaceWord(textViewer, commandResult);
                    break;
                }
                case REPLACE_DOCUMENT: {
                    CommandExecutionUtils.replaceDocument(textViewer, commandResult);
                    break;
                }
                case INSERT_AS_TEXT: {
                    IRegion region;
                    int offsetToInsert = caretOffset;
                    if (commandResult.getInputType() == InputType.SELECTION) {
                        region = CommandExecutionUtils.getSelectedRegion(textViewer);
                        offsetToInsert = region.getOffset() + region.getLength();
                    } else if (commandResult.getInputType() == InputType.SELECTED_LINES) {
                        region = CommandExecutionUtils.getSelectedLinesRegion(textViewer);
                        offsetToInsert = region.getOffset() + region.getLength();
                    } else if (commandResult.getInputType() == InputType.LINE) {
                        region = CommandExecutionUtils.getCurrentLineRegion(textViewer);
                        offsetToInsert = region.getOffset() + region.getLength();
                    } else if (commandResult.getInputType() == InputType.WORD) {
                        region = CommandExecutionUtils.findWordRegion(textViewer);
                        offsetToInsert = region.getOffset() + region.getLength();
                    } else if (commandResult.getInputType() == InputType.RIGHT_CHAR) {
                        offsetToInsert = caretOffset + 1;
                    } else if (commandResult.getInputType() == InputType.DOCUMENT) {
                        offsetToInsert = CommandExecutionUtils.getEndOffset(textViewer);
                    }
                    String outputString = commandResult.getOutputString();
                    CommandExecutionUtils.replaceTextRange(textViewer, offsetToInsert, 0, outputString);
                    CommandExecutionUtils.setCaretOffset(textViewer, caretOffset + outputString.length());
                    break;
                }
                case INSERT_AS_SNIPPET: {
                    Region region = new Region(caretOffset, 0);
                    if (commandResult.getInputType() == InputType.SELECTION) {
                        region = CommandExecutionUtils.getSelectedRegion(textViewer);
                    } else if (commandResult.getInputType() == InputType.SELECTED_LINES) {
                        region = CommandExecutionUtils.getSelectedLinesRegion(textViewer);
                    } else if (commandResult.getInputType() == InputType.DOCUMENT) {
                        region = new Region(0, CommandExecutionUtils.getEndOffset(textViewer));
                    } else if (commandResult.getInputType() == InputType.LINE) {
                        region = CommandExecutionUtils.getCurrentLineRegion(textViewer);
                    } else if (commandResult.getInputType() == InputType.WORD) {
                        region = CommandExecutionUtils.findWordRegion(textViewer);
                    } else if (commandResult.getInputType() == InputType.RIGHT_CHAR) {
                        region = new Region(caretOffset, 1);
                    } else if (commandResult.getInputType() == InputType.LEFT_CHAR) {
                        region = new Region(caretOffset - 1, 1);
                    }
                    SnippetsCompletionProcessor.insertAsTemplate(textViewer, (IRegion)region, commandResult.getOutputString(), commandResult.getCommand());
                    break;
                }
                case SHOW_AS_TOOLTIP: {
                    CommandExecutionUtils.showAsTooltip(commandResult, textViewer, caretOffset);
                }
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    private static void setCaretOffset(ITextViewer textViewer, int docOffset) {
        if (textViewer instanceof ITextViewerExtension5) {
            docOffset = ((ITextViewerExtension5)textViewer).modelOffset2WidgetOffset(docOffset);
        }
        textViewer.getTextWidget().setCaretOffset(docOffset);
    }

    private static void replaceTextRange(ITextViewer textViewer, IRegion region, String text) throws BadLocationException {
        CommandExecutionUtils.replaceTextRange(textViewer, region.getOffset(), region.getLength(), text);
    }

    private static void replaceTextRange(ITextViewer textViewer, int offset, int length, String text) throws BadLocationException {
        textViewer.getDocument().replace(offset, length, text);
    }

    private static int getEndOffset(ITextViewer textViewer) {
        return textViewer.getDocument().getLength();
    }

    private static int getCaretOffset(ITextViewer textViewer) {
        StyledText textWidget = textViewer.getTextWidget();
        int caretOffset = textWidget.getCaretOffset();
        if (textViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)textViewer;
            return extension.widgetOffset2ModelOffset(caretOffset);
        }
        return caretOffset;
    }

    protected static void replaceWord(ITextViewer textWidget, CommandResult commandResult) throws BadLocationException {
        IRegion wordRegion = CommandExecutionUtils.findWordRegion(textWidget);
        CommandExecutionUtils.replaceTextRange(textWidget, wordRegion, commandResult.getOutputString());
    }

    private static IRegion getSelectedLinesRegion(ITextViewer textWidget) throws BadLocationException {
        Point selectionRange = textWidget.getSelectedRange();
        int startLine = textWidget.getDocument().getLineOfOffset(selectionRange.x);
        int endLine = textWidget.getDocument().getLineOfOffset(selectionRange.x + selectionRange.y);
        int startOffset = textWidget.getDocument().getLineOffset(startLine);
        IRegion endRegion = textWidget.getDocument().getLineInformation(endLine);
        int endOffset = endRegion.getOffset() + endRegion.getLength();
        return new Region(startOffset, endOffset - startOffset);
    }

    private static IRegion getSelectedRegion(ITextViewer textWidget) {
        return new Region(textWidget.getSelectedRange().x, textWidget.getSelectedRange().y);
    }

    protected static IRegion getCurrentLineRegion(ITextViewer textWidget) throws BadLocationException {
        int caretOffset = CommandExecutionUtils.getCaretOffset(textWidget);
        int lineAtCaret = textWidget.getDocument().getLineOfOffset(caretOffset);
        return textWidget.getDocument().getLineInformation(lineAtCaret);
    }

    protected static void replaceDocument(ITextViewer textWidget, CommandResult commandResult) {
        textWidget.getDocument().set(commandResult.getOutputString());
    }

    protected static void replaceLine(ITextViewer textWidget, CommandResult commandResult) throws BadLocationException {
        IRegion region = CommandExecutionUtils.getCurrentLineRegion(textWidget);
        String output = commandResult.getOutputString();
        CommandExecutionUtils.replaceTextRange(textWidget, region, output);
        CommandExecutionUtils.setCaretOffset(textWidget, region.getOffset() + output.length());
    }

    private static void outputToConsole(CommandResult commandResult) {
        String errorString;
        String outputString = commandResult.getOutputString();
        if (outputString != null) {
            ScriptLogger.print((String)outputString);
        }
        if ((errorString = commandResult.getErrorString()) != null) {
            ScriptLogger.printError((String)errorString);
        }
    }

    private static void outputToFile(CommandResult commandResult) {
        block14: {
            FileWriter writer = null;
            String path = commandResult.getCommand().getOutputPath();
            try {
                try {
                    writer = new FileWriter(path);
                    writer.write(commandResult.getOutputString());
                }
                catch (IOException e) {
                    String message = MessageFormat.format(Messages.CommandExecutionUtils_Unable_To_Write_To_Output_File, path);
                    ScriptUtils.logErrorWithStackTrace((String)message, (Exception)e);
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static void copyToClipboard(CommandResult commandResult) {
        CommandExecutionUtils.copyToClipboard(commandResult.getOutputString());
    }

    public static void copyToClipboard(String contents) {
        CommandExecutionUtils.getClipboard().setContents(new Object[]{contents}, new Transfer[]{TextTransfer.getInstance()});
    }

    private static String getClipboardContents() {
        return (String)CommandExecutionUtils.getClipboard().getContents((Transfer)TextTransfer.getInstance());
    }

    protected static Clipboard getClipboard() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return new Clipboard(display);
    }

    private static void createNewDocument(CommandResult commandResult) {
        File file = Utilities.getFile();
        IEditorInput input = Utilities.createFileEditorInput(file, NEW_DOCUMENT_TITLE);
        try {
            IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(input, DEFAULT_TEXT_EDITOR_ID);
            if (!(part instanceof ITextEditor)) {
                return;
            }
            ITextEditor openedTextEditor = (ITextEditor)part;
            IDocumentProvider dp = openedTextEditor.getDocumentProvider();
            if (dp == null) {
                return;
            }
            IDocument doc = dp.getDocument((Object)openedTextEditor.getEditorInput());
            if (doc == null) {
                return;
            }
            try {
                String fileContents = commandResult.getOutputString();
                if (fileContents != null) {
                    doc.replace(0, 0, fileContents);
                }
            }
            catch (BadLocationException e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    private static void showAsTooltip(CommandResult commandResult, ITextViewer textViewer, int caretOffset) {
        String output = commandResult.getOutputString();
        if (output == null || output.trim().length() == 0) {
            return;
        }
        DefaultInformationControl tooltip = new DefaultInformationControl(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), NLS.bind((String)Messages.CommandExecutionUtils_ClickToFocusTypeEscapeToDismissWhenFocused, (Object)10L), null){

            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (visible) {
                    Shell shell = this.getShell();
                    final UIJob hideJob = new UIJob("Hide tooltip"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            if (this.isVisible()) {
                                this.setVisible(false);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    hideJob.setPriority(10);
                    EclipseUtil.setSystemForJob((Job)hideJob);
                    hideJob.schedule(10000L);
                    shell.addShellListener((ShellListener)new ShellAdapter(){

                        public void shellDeactivated(ShellEvent e) {
                            this.setVisible(false);
                        }

                        public void shellActivated(ShellEvent e) {
                            hideJob.cancel();
                        }
                    });
                }
            }
        };
        tooltip.setInformation(output);
        Point p = tooltip.computeSizeHint();
        tooltip.setSize(p.x, p.y);
        StyledText textWidget = textViewer.getTextWidget();
        caretOffset = textWidget.getCaretOffset();
        Point locationAtOffset = textWidget.getLocationAtOffset(caretOffset);
        Rectangle bounds = textWidget.getClientArea();
        if (bounds.contains(locationAtOffset)) {
            locationAtOffset = textWidget.toDisplay(locationAtOffset.x, locationAtOffset.y + textWidget.getLineHeight(caretOffset) + 2);
        } else if (locationAtOffset.y > bounds.y && locationAtOffset.y < bounds.y + bounds.height) {
            locationAtOffset = textWidget.toDisplay(bounds.x + 2, locationAtOffset.y + textWidget.getLineHeight(caretOffset) + 2);
        } else {
            int topIndex = textWidget.getTopIndex();
            int offsetAtLine = textWidget.getOffsetAtLine(topIndex);
            locationAtOffset = textWidget.getLocationAtOffset(offsetAtLine);
            locationAtOffset = textWidget.toDisplay(locationAtOffset.x + 2, locationAtOffset.y + textWidget.getLineHeight(caretOffset) + 2);
        }
        tooltip.setLocation(locationAtOffset);
        tooltip.setVisible(true);
    }

    private static void showAsHTML(CommandElement command, CommandResult commandResult) {
        String output = commandResult.getOutputString();
        if (output == null || output.trim().length() == 0) {
            return;
        }
        File tempHmtlFile = null;
        try {
            tempHmtlFile = File.createTempFile("com.aptana.editor.common", HTML_FILE_EXTENSION);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)Messages.CommandExecutionUtils_CouldNotCreateTemporaryFile, (Throwable)e);
        }
        if (tempHmtlFile != null) {
            tempHmtlFile.deleteOnExit();
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(tempHmtlFile);
            }
            catch (FileNotFoundException e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
            if (pw != null) {
                pw.println(output);
                pw.flush();
                pw.close();
                IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    URL url = tempHmtlFile.toURI().toURL();
                    if (support.isInternalWebBrowserAvailable()) {
                        support.createBrowser(46, "", null, command.getDisplayName()).openURL(url);
                    } else {
                        support.getExternalBrowser().openURL(url);
                    }
                }
                catch (PartInitException e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                }
                catch (MalformedURLException e) {
                    IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                }
            }
        }
    }

    private static String findWord(ITextViewer textWidget) throws BadLocationException {
        IRegion region = CommandExecutionUtils.findWordRegion(textWidget);
        return textWidget.getDocument().get(region.getOffset(), region.getLength());
    }

    private static IRegion findWordRegion(ITextViewer textWidget) throws BadLocationException {
        int caretOffset = CommandExecutionUtils.getCaretOffset(textWidget);
        int lineAtCaret = textWidget.getDocument().getLineOfOffset(caretOffset);
        IRegion lineInfo = textWidget.getDocument().getLineInformation(lineAtCaret);
        String currentLine = textWidget.getDocument().get(lineInfo.getOffset(), lineInfo.getLength());
        int lineOffset = textWidget.getDocument().getLineOffset(lineAtCaret);
        int offsetInLine = caretOffset - lineOffset;
        IRegion region = CommandExecutionUtils.findWordRegion(currentLine, offsetInLine);
        return new Region(region.getOffset() + lineOffset, region.getLength());
    }

    protected static IRegion findWordRegion(String line, int offset) {
        int end;
        BreakIterator breakIter = BreakIterator.getWordInstance();
        breakIter.setText(line);
        int start = breakIter.preceding(offset);
        if (start == -1) {
            start = 0;
        }
        if ((end = breakIter.following(offset)) == -1) {
            end = line.length();
        }
        if (breakIter.isBoundary(offset)) {
            if (end - offset > offset - start) {
                start = offset;
            } else {
                end = offset;
            }
        }
        if (end == start) {
            return new Region(start, 0);
        }
        return new Region(start, end - start);
    }

    private static IOConsole getMessageConsole(String name) {
        IOConsole messageConsole = nameToMessageConsole.get(name);
        if (messageConsole == null) {
            messageConsole = new IOConsole(name, null, null, true);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
            nameToMessageConsole.put(name, messageConsole);
        }
        return messageConsole;
    }

    public static class EclipseConsoleInputProvider
    implements FilterInputProvider {
        private final String consoleName;

        public EclipseConsoleInputProvider() {
            this(DEFAULT_CONSOLE_NAME);
        }

        public EclipseConsoleInputProvider(String consoleName) {
            this.consoleName = consoleName;
        }

        @Override
        public InputStream getInputStream() {
            IOConsole messageConsole = CommandExecutionUtils.getMessageConsole(this.consoleName);
            messageConsole.activate();
            return messageConsole.getInputStream();
        }
    }

    public static class EclipseConsolePrintStreamOutputConsumer
    implements FilterOutputConsumer {
        private final String consoleName;
        private final boolean isStdErr;

        public EclipseConsolePrintStreamOutputConsumer() {
            this(DEFAULT_CONSOLE_NAME, false);
        }

        public EclipseConsolePrintStreamOutputConsumer(String consoleName) {
            this(consoleName, false);
        }

        public EclipseConsolePrintStreamOutputConsumer(boolean err) {
            this(DEFAULT_CONSOLE_NAME, err);
        }

        public EclipseConsolePrintStreamOutputConsumer(String consoleName, boolean isStdErr) {
            this.consoleName = consoleName;
            this.isStdErr = isStdErr;
        }

        @Override
        public void consume(InputStream outputStream) {
            IOConsole messageConsole = CommandExecutionUtils.getMessageConsole(this.consoleName);
            messageConsole.activate();
            MessageConsoleWriter messageConsoleWriter = new MessageConsoleWriter(messageConsole, outputStream, this.isStdErr);
            new Thread(messageConsoleWriter).start();
        }
    }

    public static class FileInputProvider
    implements FilterInputProvider {
        private final String path;

        public FileInputProvider(String path) {
            this.path = path;
        }

        @Override
        public InputStream getInputStream() {
            FileInputStream result = null;
            try {
                result = new FileInputStream(this.path);
            }
            catch (FileNotFoundException e) {
                String message = MessageFormat.format(Messages.CommandExecutionUtils_Input_File_Does_Not_Exist, this.path);
                ScriptUtils.logErrorWithStackTrace((String)message, (Exception)e);
            }
            return result;
        }
    }

    public static interface FilterInputProvider {
        public InputStream getInputStream();
    }

    public static interface FilterOutputConsumer {
        public void consume(InputStream var1);
    }

    private static class MessageConsoleWriter
    implements Runnable {
        private final IOConsole messageConsole;
        private final InputStream from;
        private final boolean isStdErr;

        private MessageConsoleWriter(IOConsole messageConsole, InputStream from, boolean isStdErr) {
            this.messageConsole = messageConsole;
            this.from = from;
            this.isStdErr = isStdErr;
        }

        @Override
        public void run() {
            block12: {
                IOConsoleOutputStream newOutputStream = this.messageConsole.newOutputStream();
                PrintWriter printWriter = new PrintWriter((OutputStream)newOutputStream);
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.from));
                String output = null;
                try {
                    try {
                        while ((output = reader.readLine()) != null) {
                            printWriter.println(output);
                            printWriter.flush();
                        }
                    }
                    catch (IOException e) {
                        IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (String)"Failed to read output.", (Throwable)e);
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                        printWriter.flush();
                        printWriter.close();
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    printWriter.flush();
                    printWriter.close();
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                printWriter.flush();
                printWriter.close();
            }
        }
    }

    public static class PrintStreamOutputConsumer
    implements FilterOutputConsumer {
        private PrintStream printStream;

        public PrintStreamOutputConsumer() {
        }

        public PrintStreamOutputConsumer(PrintStream printStream) {
            this.printStream = printStream;
        }

        public PrintStream getPrintStream() {
            return this.printStream;
        }

        protected void setPrintStream(PrintStream printStream) {
            this.printStream = printStream;
        }

        @Override
        public void consume(final InputStream outputStream) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    block12: {
                        BufferedReader br = new BufferedReader(new InputStreamReader(outputStream));
                        String line = null;
                        try {
                            try {
                                while ((line = br.readLine()) != null) {
                                    if (PrintStreamOutputConsumer.this.printStream == null) continue;
                                    PrintStreamOutputConsumer.this.printStream.println(line);
                                    PrintStreamOutputConsumer.this.printStream.flush();
                                }
                            }
                            catch (IOException iOException) {
                                PrintStreamOutputConsumer.this.printStream.close();
                                try {
                                    outputStream.close();
                                }
                                catch (IOException iOException2) {}
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            PrintStreamOutputConsumer.this.printStream.close();
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        PrintStreamOutputConsumer.this.printStream.close();
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }).start();
        }
    }

    public static class StringInputProvider
    implements FilterInputProvider {
        private final String string;

        public StringInputProvider() {
            this("");
        }

        public StringInputProvider(String string) {
            this.string = string;
        }

        @Override
        public InputStream getInputStream() {
            try {
                return new ByteArrayInputStream(this.string.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new StringBufferInputStream(this.string);
            }
        }
    }

    public static class StringOutputConsumer
    implements FilterOutputConsumer {
        private BlockingQueue<String> outputQueue;

        public StringOutputConsumer() {
            this(new ArrayBlockingQueue<String>(1));
        }

        public StringOutputConsumer(BlockingQueue<String> outputQueue) {
            this.outputQueue = outputQueue;
        }

        @Override
        public void consume(final InputStream outputStream) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    block12: {
                        StringBuilder stringBuilder = new StringBuilder();
                        BufferedReader br = new BufferedReader(new InputStreamReader(outputStream));
                        String line = null;
                        try {
                            try {
                                while ((line = br.readLine()) != null) {
                                    stringBuilder.append(String.valueOf(line) + "\n");
                                }
                            }
                            catch (IOException iOException) {
                                StringOutputConsumer.this.outputQueue.add(stringBuilder.toString());
                                try {
                                    outputStream.close();
                                }
                                catch (IOException iOException2) {}
                                break block12;
                            }
                        }
                        catch (Throwable throwable) {
                            StringOutputConsumer.this.outputQueue.add(stringBuilder.toString());
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                            throw throwable;
                        }
                        StringOutputConsumer.this.outputQueue.add(stringBuilder.toString());
                        try {
                            outputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }).start();
        }

        public String getOutput() throws InterruptedException {
            return this.outputQueue.take();
        }
    }
}

