/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.preferences;

import com.aptana.core.CoreStrings;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.contentassist.ContentAssistant;
import com.aptana.editor.common.contentassist.UserAgentFilterType;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.common.preferences.Messages;
import com.aptana.ui.preferences.AptanaPreferencePage;
import com.aptana.ui.preferences.PropertyAndPreferenceFieldEditorPage;
import com.pandora.core.utils.PlatformUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.service.prefs.BackingStoreException;

public class ContentAssistPreferencePage
extends PropertyAndPreferenceFieldEditorPage {
    private static final String PREFERENCE_PAGE_ID = "com.aptana.editor.common.contentAssistPreferencePage";
    private static final String PROPERTY_PAGE_ID = "com.aptana.editor.common.contentAssistPropertyPage";
    private List<FieldEditor> fields = new ArrayList<FieldEditor>();
    private Combo natureCombo;
    private String activeNatureID;
    private CheckboxTableViewer categoryViewer;
    private SortedMap<String, String> natureIDsByName;
    private Map<String, UserAgentManager.UserAgent[]> userAgentsByNatureID;
    private BooleanFieldEditor px2remEnable;
    private Composite px2remGroup;
    private IntegerFieldEditor px2remProportion;
    private IntegerFieldEditor px2remDecimalLength;

    public ContentAssistPreferencePage() {
        super(1);
        this.setPreferenceStore(CommonEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.ContentAssistPreferencePage_ContentAssistPreferencePageDescription);
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Composite uaGroup = AptanaPreferencePage.createGroup((Composite)parent, (String)Messages.ContentAssistPreferencePage_UserAgentGroupLabel);
        this.createUserAgentGroupContent(uaGroup);
        this.createPx2RemGroupContent(parent);
        if (!this.isProjectPreferencePage()) {
            Composite pGroup = AptanaPreferencePage.createGroup((Composite)parent, (String)Messages.ContentAssistPreferencePage_ProposalsGroupLabel);
            this.createProposalGroupContent(pGroup);
        }
    }

    protected void createFilterSelector(Composite parent) {
        ComboFieldEditor fieldEditor = new ComboFieldEditor("CONTENT_ASSIST_USER_AGENT_FILTER_TYPE", Messages.ContentAssistPreferencePage_ProposalFilterTypeLabel, (String[][])new String[][]{{Messages.ContentAssistPreferencePage_NoFilterLabel, UserAgentFilterType.NO_FILTER.getText()}, {Messages.ContentAssistPreferencePage_OneOrMoreFilterLabel, UserAgentFilterType.ONE_OR_MORE.getText()}, {Messages.ContentAssistPreferencePage_AllFilterLabel, UserAgentFilterType.ALL.getText()}}, parent);
        this.addField((FieldEditor)fieldEditor);
        fieldEditor.setEnabled(!this.isProjectPreferencePage(), parent);
    }

    protected void createNatureSelector(Composite parent) {
        SortedMap<String, String> natureMap = this.getNatureMap();
        Label label = new Label(parent, 16384);
        label.setFont(parent.getFont());
        label.setText(Messages.ContentAssistPreferencePage_NatureComboLabel);
        this.natureCombo = new Combo(parent, 8);
        this.natureCombo.setFont(parent.getFont());
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        gd.horizontalAlignment = 4;
        this.natureCombo.setLayoutData((Object)gd);
        boolean isProjectPreference = this.isProjectPreferencePage();
        Object primaryProjectNature = null;
        if (isProjectPreference) {
            try {
                Object[] aptanaNatures = ResourceUtil.getAptanaNatures((IProjectDescription)this.getProject().getDescription());
                if (!ArrayUtil.isEmpty((Object[])aptanaNatures)) {
                    primaryProjectNature = aptanaNatures[0];
                }
            }
            catch (CoreException coreException) {}
        }
        for (Map.Entry<String, String> entry : natureMap.entrySet()) {
            if (primaryProjectNature != null) {
                if (!((String)primaryProjectNature).equals(entry.getValue())) continue;
                this.natureCombo.add(entry.getKey());
                break;
            }
            this.natureCombo.add(entry.getKey());
        }
        this.natureCombo.select(0);
        this.activeNatureID = (String)natureMap.get(this.natureCombo.getText());
        this.natureCombo.setEnabled(!isProjectPreference);
        if (!isProjectPreference) {
            this.natureCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    ContentAssistPreferencePage.this.userAgentsByNatureID.put(ContentAssistPreferencePage.this.activeNatureID, ContentAssistPreferencePage.this.getSelectedUserAgents());
                    ContentAssistPreferencePage.this.activeNatureID = (String)ContentAssistPreferencePage.this.getNatureMap().get(ContentAssistPreferencePage.this.natureCombo.getText());
                    ContentAssistPreferencePage.this.updateUserAgentSelection();
                }
            });
        }
    }

    protected void createProposalGroupContent(Composite parent) {
        this.addField((FieldEditor)new BooleanFieldEditor("SELECT_CONTENT_ASSIST_BY_NUMBER", "\u4ec5ALT+\u6570\u5b57\u9009\u62e9\u4ee3\u7801\u63d0\u793a", parent));
        this.addField((FieldEditor)new BooleanFieldEditor("CONTENT_ASSIST_AUTO_INSERT", Messages.EditorsPreferencePage_Content_Assist_Auto_Insert, parent));
        this.addField((FieldEditor)new ComboFieldEditor("CONTENT_ASSIST_DELAY", Messages.EditorsPreferencePage_Content_Assist_Auto_Display, (String[][])new String[][]{{Messages.EditorsPreferencePage_Instant, Integer.toString(0)}, {Messages.EditorsPreferencePage_DefaultDelay, Integer.toString(200)}, {Messages.EditorsPreferencePage_Content_Assist_Short_Delay, Integer.toString(1000)}, {CoreStrings.OFF, String.valueOf(-1)}}, parent));
        this.addField((FieldEditor)new ComboFieldEditor("com.aptana.editor.common.contentAssistHover", Messages.EditorsPreferencePage_Content_Assist_Hover, (String[][])new String[][]{{CoreStrings.ON, Boolean.toString(true)}, {CoreStrings.OFF, Boolean.toString(false)}}, parent));
        this.addField((FieldEditor)new IntegerFieldEditor("SPEC_FILE_NUMBER", "\u6587\u4ef6\u63d0\u793a\u6700\u5927\u6570", parent));
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object b;
        super.propertyChange(event);
        Object object = event.getSource();
        if (object instanceof BooleanFieldEditor) {
            BooleanFieldEditor booleanFieldEditor = (BooleanFieldEditor)object;
            String preferenceName = booleanFieldEditor.getPreferenceName();
            if (StringUtil.isBlank((String)preferenceName)) {
                return;
            }
            b = event.getNewValue();
            if (b instanceof Boolean) {
                boolean result = (Boolean)b;
                if (preferenceName.equals("CONTENT_ASSIST_AUTO_INSERT")) {
                    ContentAssistant.fIsAutoInserting = result;
                } else if (preferenceName.equals("SELECT_CONTENT_ASSIST_BY_NUMBER")) {
                    ContentAssistant.fSelectContentAssistantByALTNumber = result;
                }
            }
        }
        if (object instanceof IntegerFieldEditor) {
            IntegerFieldEditor stringFieldEditor = (IntegerFieldEditor)object;
            String pName = stringFieldEditor.getPreferenceName();
            if (StringUtil.isBlank((String)pName)) {
                return;
            }
            if (pName.equals("SPEC_FILE_NUMBER") && (b = event.getNewValue()) instanceof String) {
                try {
                    String result = (String)b;
                    result = result.trim();
                    int n = Integer.valueOf(result);
                    ContentAssistant.setSPEC_FILE_MAX_COUNT((int)n);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected void createUserAgentButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 0).grab(true, false).create());
        Button enableAll = new Button(composite, 8);
        enableAll.setFont(parent.getFont());
        enableAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContentAssistPreferencePage.this.categoryViewer.setCheckedElements((Object[])UserAgentManager.getInstance().getAllUserAgents());
            }
        });
        enableAll.setText(Messages.UserAgentPreferencePage_Select_All);
        this.setButtonLayoutData(enableAll);
        Button disableAll = new Button(composite, 8);
        disableAll.setFont(parent.getFont());
        disableAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContentAssistPreferencePage.this.categoryViewer.setCheckedElements(new Object[0]);
            }
        });
        disableAll.setText(Messages.UserAgentPreferencePage_Select_None);
        this.setButtonLayoutData(disableAll);
    }

    protected void createUserAgentGroupContent(Composite parent) {
        this.createNatureSelector(parent);
        this.createUserAgentTable(parent);
        this.createUserAgentButtons(parent);
        this.createFilterSelector(parent);
        UserAgentManager manager = UserAgentManager.getInstance();
        this.userAgentsByNatureID = new HashMap<String, UserAgentManager.UserAgent[]>();
        if (this.isProjectPreferencePage()) {
            try {
                IProject project = this.getProject();
                Object[] aptanaNatures = ResourceUtil.getAptanaNatures((IProjectDescription)project.getDescription());
                if (!ArrayUtil.isEmpty((Object[])aptanaNatures)) {
                    this.userAgentsByNatureID.put((String)aptanaNatures[0], manager.getActiveUserAgents(project));
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
        } else {
            for (String natureID : ResourceUtil.getAptanaNaturesMap().values()) {
                this.userAgentsByNatureID.put(natureID, manager.getActiveUserAgents(natureID));
            }
        }
        this.updateUserAgentSelection();
    }

    protected void createPx2RemGroupContent(Composite parent) {
        this.px2remGroup = AptanaPreferencePage.createGroup((Composite)parent, (String)"px\u81ea\u52a8\u8f6crem\u8bbe\u7f6e");
        this.px2remEnable = new BooleanFieldEditor("com.aptana.editor.common.px2remEnable", "\u542f\u52a8px\u8f6crem\u63d0\u793a", this.px2remGroup);
        ((GridData)this.px2remEnable.getDescriptionControl((Composite)this.px2remGroup).getLayoutData()).horizontalSpan = 2;
        this.fields.add((FieldEditor)this.px2remEnable);
        this.px2remProportion = new IntegerFieldEditor("com.aptana.editor.common.px2remProportion", "px\u8f6crem\u6bd4\u4f8b", this.px2remGroup);
        this.px2remProportion.setEmptyStringAllowed(false);
        this.fields.add((FieldEditor)this.px2remProportion);
        this.px2remDecimalLength = new IntegerFieldEditor("com.aptana.editor.common.px2remDecimalLength", "rem\u5c0f\u6570\u90e8\u5206\u4fdd\u7559\u957f\u5ea6", this.px2remGroup);
        this.fields.add((FieldEditor)this.px2remDecimalLength);
        ((Button)this.px2remEnable.getDescriptionControl(this.px2remGroup)).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ContentAssistPreferencePage.this.updatePx2RemSelection();
            }
        });
    }

    protected void initialize() {
        super.initialize();
        IPreferenceStore store = CommonEditorPlugin.getDefault().getPreferenceStore();
        if (this.isProjectPreferencePage()) {
            store = new ChainedPreferenceStore(new IPreferenceStore[]{new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.getProject()), "com.aptana.editor.common", ""), store});
        }
        for (FieldEditor field : this.fields) {
            field.setPage((DialogPage)this);
            field.setPreferenceStore(store);
            field.load();
        }
        this.updatePx2RemSelection();
    }

    protected void createUserAgentTable(Composite parent) {
        Label label = new Label(parent, 64);
        label.setText(Messages.UserAgentPreferencePage_Select_User_Agents);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 0).grab(true, true).create());
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 0).hint(400, (int)(120.0 * PlatformUtil.getDPIScale())).grab(true, true).create());
        Table table = new Table(composite, 2084);
        table.setFont(parent.getFont());
        this.categoryViewer = new CheckboxTableViewer(table);
        this.categoryViewer.getControl().setFont(parent.getFont());
        this.categoryViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.categoryViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        CategoryLabelProvider categoryLabelProvider = new CategoryLabelProvider(true);
        this.categoryViewer.setLabelProvider((IBaseLabelProvider)categoryLabelProvider);
        this.categoryViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof UserAgentManager.UserAgent && e2 instanceof UserAgentManager.UserAgent) {
                    UserAgentManager.UserAgent ua1 = (UserAgentManager.UserAgent)e1;
                    UserAgentManager.UserAgent ua2 = (UserAgentManager.UserAgent)e2;
                    String uaName1 = StringUtil.getStringValue((Object)ua1.name);
                    String uaName2 = StringUtil.getStringValue((Object)ua2.name);
                    return uaName1.compareToIgnoreCase(uaName2);
                }
                return super.compare(viewer, e1, e2);
            }
        });
        this.categoryViewer.setInput((Object)UserAgentManager.getInstance().getAllUserAgents());
    }

    protected SortedMap<String, String> getNatureMap() {
        if (this.natureIDsByName == null) {
            this.natureIDsByName = new TreeMap<String, String>(ResourceUtil.getAptanaNaturesMap());
        }
        return this.natureIDsByName;
    }

    protected UserAgentManager.UserAgent[] getSelectedUserAgents() {
        Object[] elements = this.categoryViewer.getCheckedElements();
        UserAgentManager.UserAgent[] userAgents = new UserAgentManager.UserAgent[elements.length];
        int i = 0;
        while (i < elements.length) {
            userAgents[i] = (UserAgentManager.UserAgent)elements[i];
            ++i;
        }
        return userAgents;
    }

    protected void performDefaults() {
        this.userAgentsByNatureID = new HashMap<String, UserAgentManager.UserAgent[]>();
        UserAgentManager manager = UserAgentManager.getInstance();
        for (String natureID : ResourceUtil.getAptanaNaturesMap().values()) {
            this.userAgentsByNatureID.put(natureID, manager.getDefaultUserAgents(natureID));
        }
        this.updateUserAgentSelection();
        IPreferenceStore store = CommonEditorPlugin.getDefault().getPreferenceStore();
        for (FieldEditor field : this.fields) {
            field.setPreferenceStore(store);
            field.loadDefault();
        }
        this.updatePx2RemSelection();
        super.performDefaults();
    }

    public boolean performOk() {
        this.userAgentsByNatureID.put(this.activeNatureID, this.getSelectedUserAgents());
        UserAgentManager manager = UserAgentManager.getInstance();
        IProject project = this.getProject();
        if (project == null) {
            for (Map.Entry<String, UserAgentManager.UserAgent[]> entry : this.userAgentsByNatureID.entrySet()) {
                String natureID = entry.getKey();
                UserAgentManager.UserAgent[] userAgents = entry.getValue();
                String[] userAgentIDs = new String[userAgents.length];
                int i = 0;
                while (i < userAgents.length) {
                    userAgentIDs[i] = userAgents[i].ID;
                    ++i;
                }
                manager.setActiveUserAgents(natureID, userAgentIDs);
                manager.savePreference();
            }
            IPreferenceStore store = CommonEditorPlugin.getDefault().getPreferenceStore();
            for (FieldEditor field : this.fields) {
                field.setPreferenceStore(store);
                field.store();
            }
            if (store instanceof IPersistentPreferenceStore) {
                try {
                    ((IPersistentPreferenceStore)store).save();
                }
                catch (IOException iOException) {}
            }
        } else if (this.useProjectSettings()) {
            if (this.activeNatureID != null && !CollectionsUtil.isEmpty(this.userAgentsByNatureID)) {
                UserAgentManager.UserAgent[] userAgents = this.userAgentsByNatureID.get(this.activeNatureID);
                String[] userAgentIDs = new String[userAgents.length];
                int i = 0;
                while (i < userAgents.length) {
                    userAgentIDs[i] = userAgents[i].ID;
                    ++i;
                }
                manager.savePreference(project, CollectionsUtil.newTypedMap(String.class, String[].class, (Object[])new Object[]{this.activeNatureID, userAgentIDs}));
            } else {
                IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)"ContentAssist preferences - Did not save. Expected to have a valid Aptana nature");
            }
            ScopedPreferenceStore store = new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.getProject()), "com.aptana.editor.common");
            for (FieldEditor field : this.fields) {
                field.setPreferenceStore((IPreferenceStore)store);
                field.store();
            }
            try {
                store.save();
            }
            catch (IOException iOException) {}
        } else {
            manager.clearPreferences(project);
            IEclipsePreferences preferences = new ProjectScope(project).getNode("com.aptana.editor.common");
            preferences.remove("com.aptana.editor.common.px2remEnable");
            preferences.remove("com.aptana.editor.common.px2remProportion");
            preferences.remove("com.aptana.editor.common.px2remDecimalLength");
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
        return super.performOk();
    }

    private void updateUserAgentSelection() {
        String name = this.natureCombo.getText();
        String natureID = (String)this.natureIDsByName.get(name);
        Object[] userAgents = this.userAgentsByNatureID.get(natureID);
        this.categoryViewer.setCheckedElements(userAgents != null ? userAgents : UserAgentManager.NO_USER_AGENTS);
    }

    private void updatePx2RemSelection() {
        if (this.px2remEnable != null && this.px2remGroup.isEnabled()) {
            boolean enable = this.px2remEnable.getBooleanValue();
            this.px2remProportion.setEnabled(enable, this.px2remGroup);
            this.px2remDecimalLength.setEnabled(enable, this.px2remGroup);
        }
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences node = scope.getNode("com.aptana.editor.common");
        if (node != null) {
            return node.get("selectUserAgents", null) != null;
        }
        return false;
    }

    protected String getPreferencePageId() {
        return PREFERENCE_PAGE_ID;
    }

    protected Set<String> getNatureIDs() {
        return new HashSet<String>(ResourceUtil.getAptanaNaturesMap().values());
    }

    protected String getPropertyPageId() {
        return PROPERTY_PAGE_ID;
    }

    private class CategoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public CategoryLabelProvider(boolean decorate) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return UserAgentManager.getInstance().getImage(((UserAgentManager.UserAgent)element).enabledIconPath);
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((UserAgentManager.UserAgent)element).name;
        }
    }
}

