/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.parsing;

import java.io.CharArrayReader;
import java.io.IOException;

public class FlexScannerCharArrayReader
extends CharArrayReader {
    private int skipStart = -1;
    private int skipEnd = -1;
    private int end;

    public FlexScannerCharArrayReader(char[] buf, int offset, int length, int skipStart, int skipEnd) {
        super(buf, offset, length);
        if (skipStart >= 0) {
            this.count = buf.length;
            this.pos = offset < skipStart ? offset : offset + (skipEnd - skipStart);
            this.end = offset + length;
            if (this.end > skipStart) {
                this.end += skipEnd - skipStart;
            }
            if (this.end > this.count || skipStart > skipEnd) {
                throw new IllegalArgumentException();
            }
            this.skipStart = skipStart;
            this.skipEnd = skipEnd;
            this.buf = buf;
            this.markedPos = this.pos;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.skipStart < 0) {
            return super.read();
        }
        if (this.pos >= this.end) {
            return -1;
        }
        if (this.pos >= this.skipStart && this.pos < this.skipEnd) {
            this.pos = this.skipEnd;
        }
        return super.read();
    }

    @Override
    public int read(char[] b, int off, int len) throws IOException {
        if (this.skipStart < 0) {
            return super.read(b, off, len);
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int getEnd = this.pos + len;
        if (this.skipStart < getEnd) {
            getEnd += this.skipEnd - this.skipStart;
        }
        if (this.end < getEnd) {
            len -= getEnd - this.end;
            getEnd = this.end;
        }
        if (len <= 0) {
            return 0;
        }
        if (this.skipStart >= getEnd || this.skipEnd <= this.pos) {
            return super.read(b, off, len);
        }
        if (this.skipStart <= this.pos && this.skipEnd > this.pos) {
            this.pos = this.skipEnd;
            return super.read(b, off, len);
        }
        int readLength = this.skipStart - this.pos;
        System.arraycopy(this.buf, this.pos, b, off, readLength);
        System.arraycopy(this.buf, this.skipEnd, b, off + readLength, len - readLength);
        this.pos = getEnd;
        return len;
    }

    @Override
    public void close() {
        super.close();
    }
}

