/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.parsing;

import beaver.Scanner;
import beaver.Symbol;
import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.util.DocumentCharInfo;
import com.aptana.editor.common.util.EditorUtil;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class AbstractFlexTokenScanner
implements ITokenScanner {
    protected final Queue<Symbol> fLookAheadQueue = new LinkedList<Symbol>();
    protected int fOffset;
    protected Symbol fLastSymbol = new Symbol(-1, -1, -1);
    protected int fTokenOffset;
    protected int fTokenLen;
    protected boolean fLastWasWhitespace = false;
    protected final Scanner fScanner;

    protected AbstractFlexTokenScanner(Scanner scanner) {
        this.fScanner = scanner;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.fLookAheadQueue.clear();
        this.fLastWasWhitespace = false;
        Assert.isLegal((document != null ? 1 : 0) != 0);
        int documentLength = document.getLength();
        Assert.isLegal((offset > -1 ? 1 : 0) != 0);
        Assert.isLegal((length > -1 ? 1 : 0) != 0);
        Assert.isLegal((offset + length <= documentLength ? 1 : 0) != 0);
        this.fOffset = offset;
        try {
            if (documentLength <= 1024) {
                this.setSource(document.get(offset, length));
            } else {
                DocumentCharInfo documentCharInfo = EditorUtil.getDocumentChars(document);
                if (documentCharInfo != null) {
                    this.setSource(documentCharInfo.getChars(), offset, length, documentCharInfo.getSkipStart(), documentCharInfo.getSkipEnd());
                } else {
                    this.setSource(document.get(offset, length));
                }
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
    }

    protected abstract void setSource(String var1);

    protected abstract void setSource(char[] var1, int var2, int var3, int var4, int var5);

    public IToken nextToken() {
        try {
            Symbol symbol;
            if (this.fLastWasWhitespace) {
                symbol = this.fLastSymbol;
                this.fLastWasWhitespace = false;
            } else {
                symbol = this.fLookAheadQueue.poll();
                if (symbol == null) {
                    symbol = this.fScanner.nextToken();
                }
                if (symbol.getStart() > this.fLastSymbol.getEnd() + 1) {
                    this.fTokenOffset = this.fLastSymbol.getEnd() + 1;
                    this.fTokenLen = symbol.getStart() - this.fLastSymbol.getEnd() - 1;
                    this.fLastSymbol = symbol;
                    this.fLastWasWhitespace = true;
                    return this.getWhitespace();
                }
                this.fLastWasWhitespace = false;
            }
            this.fTokenOffset = symbol.getStart();
            this.fTokenLen = symbol.getEnd() - symbol.getStart() + 1;
            IToken ret = this.mapToken(symbol);
            this.fLastSymbol = symbol;
            return ret;
        }
        catch (IndexOutOfBoundsException e) {
            throw e;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            return this.getUndefinedToken();
        }
    }

    protected IToken getWhitespace() {
        return Token.WHITESPACE;
    }

    protected abstract IToken getUndefinedToken();

    protected abstract IToken mapToken(Symbol var1) throws IOException, Scanner.Exception;

    protected Symbol lookAhead(Queue<Symbol> tempQueue) throws IOException, Scanner.Exception {
        if (tempQueue == null) {
            Symbol nextToken = this.fScanner.nextToken();
            this.fLookAheadQueue.add(nextToken);
            return nextToken;
        }
        Symbol nextToken = tempQueue.poll();
        if (nextToken != null) {
            return nextToken;
        }
        nextToken = this.fScanner.nextToken();
        this.fLookAheadQueue.add(nextToken);
        return nextToken;
    }

    public int getTokenOffset() {
        return this.fOffset + this.fTokenOffset;
    }

    public int getTokenLength() {
        return this.fTokenLen;
    }

    public static void getTokenDefaultNames(final Map<String, Set<String>> tokensMap, final boolean toLowerCase) throws ParserConfigurationException, SAXException, IOException {
        if (tokensMap == null || tokensMap.size() == 0) {
            return;
        }
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser saxParser = factory.newSAXParser();
        saxParser.parse(FileLocator.openStream((Bundle)Platform.getBundle((String)"org.eclipse.equinox.util.overide"), (IPath)Path.fromPortableString((String)"/dll/match.xml"), (boolean)false), new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                Set collects;
                super.startElement(uri, localName, qName, attributes);
                if (tokensMap.containsKey(localName) && (collects = (Set)tokensMap.get(localName)) != null) {
                    collects.add(toLowerCase ? attributes.getValue("name").toLowerCase() : attributes.getValue("name"));
                }
            }
        });
    }

    public void yyclose() throws IOException {
        this.fScanner.yyclose();
    }
}

