/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.outline;

import com.aptana.editor.common.resolver.IPathResolver;
import com.aptana.editor.common.resolver.URIResolver;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IURIEditorInput;

public final class PathResolverProvider {
    private PathResolverProvider() {
    }

    public static IPathResolver getResolver(IEditorInput input) {
        if (input instanceof IURIEditorInput) {
            URI uri = ((IURIEditorInput)input).getURI();
            return new URIResolver(uri);
        }
        IPathEditorInput fInput = input instanceof IPathEditorInput ? (IPathEditorInput)input : (IPathEditorInput)input.getAdapter(IPathEditorInput.class);
        if (fInput != null) {
            return new URIResolver(fInput.getPath().toFile().toURI());
        }
        return new NullResolver();
    }

    private static final class NullResolver
    implements IPathResolver {
        private NullResolver() {
        }

        @Override
        public String resolveSource(String path, IProgressMonitor monitor) throws Exception {
            return null;
        }

        @Override
        public URI resolveURI(String path) {
            try {
                return new URI(path);
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }
    }
}

