/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.scripting;

import com.aptana.scripting.ScriptUtils;
import com.aptana.scripting.model.CommandContext;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.ContextContributor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.jruby.Ruby;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class EditorContextContributor
implements ContextContributor {
    private static final String EDITOR_PROPERTY_NAME = "editor";
    private static final String EDITOR_RUBY_CLASS = "Editor";
    private IEditorPart _editor;

    private Display getDisplay() {
        Display result = Display.getCurrent();
        if (result == null) {
            result = Display.getDefault();
        }
        return result;
    }

    private boolean onUIThread() {
        return this.getDisplay() != null;
    }

    private IEditorPart getActiveEditor() {
        UIJob job = new UIJob("Get active editor"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    IWorkbenchPage page;
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    if (window != null && (page = window.getActivePage()) != null) {
                        EditorContextContributor.this._editor = page.getActiveEditor();
                    }
                }
                catch (IllegalStateException illegalStateException) {}
                return Status.OK_STATUS;
            }
        };
        if (this.onUIThread()) {
            job.runInUIThread((IProgressMonitor)new NullProgressMonitor());
        } else {
            try {
                job.schedule();
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        IEditorPart result = this._editor;
        this._editor = null;
        return result;
    }

    public void modifyContext(CommandElement command, CommandContext context) {
        IEditorPart editor = this.getActiveEditor();
        if (editor != null && command != null) {
            Ruby runtime = command.getRuntime();
            if (runtime != null) {
                IRubyObject rubyInstance = ScriptUtils.instantiateClass((Ruby)runtime, (String)"Ruble", (String)EDITOR_RUBY_CLASS, (IRubyObject[])new IRubyObject[]{JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)editor)});
                context.put(EDITOR_PROPERTY_NAME, (Object)rubyInstance);
            } else {
                context.put(EDITOR_PROPERTY_NAME, null);
            }
        }
    }
}

