/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.scripting;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.scripting.commands.CommandExecutionUtils;
import com.aptana.editor.common.scripting.commands.TextEditorUtils;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.CommandElement;
import com.aptana.scripting.model.CommandResult;
import com.aptana.scripting.model.InvocationType;
import com.aptana.scripting.model.SnippetElement;
import com.aptana.scripting.model.filters.IModelFilter;
import com.aptana.scripting.model.filters.ScopeFilter;
import com.aptana.scripting.ui.ICommandElementsProvider;
import com.aptana.scripting.ui.KeyBindingUtil;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.ITextEditor;

public class CommandElementsProvider
implements ICommandElementsProvider {
    private final ITextEditor textEditor;
    private final ITextViewer textViewer;

    public CommandElementsProvider(ITextEditor textEditor, ITextViewer textViewer) {
        this.textEditor = textEditor;
        this.textViewer = textViewer;
    }

    public void execute(CommandElement commandElement) {
        CommandResult commandResult = CommandExecutionUtils.executeCommand(commandElement, InvocationType.KEY_BINDING, this.textViewer, this.textEditor);
        CommandExecutionUtils.processCommandResult(commandElement, commandResult, this.textEditor);
    }

    public List<CommandElement> getCommandElements(KeySequence keySequence) {
        LinkedList<CommandElement> commandElements = new LinkedList<CommandElement>();
        int caretOffset = TextEditorUtils.getCaretOffset(this.textEditor);
        try {
            String contentTypeAtOffset = CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset(this.textViewer, caretOffset);
            ScopeFilter filter = new ScopeFilter(contentTypeAtOffset);
            List commandsFromScope = BundleManager.getInstance().getExecutableCommands((IModelFilter)filter);
            block2: for (CommandElement commandElement : commandsFromScope) {
                KeySequence[] commandElementKeySequences;
                if (commandElement instanceof SnippetElement) continue;
                KeySequence[] keySequenceArray = commandElementKeySequences = KeyBindingUtil.getKeySequences((CommandElement)commandElement);
                int n = commandElementKeySequences.length;
                int n2 = 0;
                while (n2 < n) {
                    KeySequence commandElementKeySequence = keySequenceArray[n2];
                    if (keySequence.equals((Object)commandElementKeySequence)) {
                        commandElements.add(commandElement);
                        continue block2;
                    }
                    ++n2;
                }
            }
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return commandElements;
    }

    public Point getCommandElementsPopupLocation() {
        Object control = this.textEditor.getAdapter(Control.class);
        if (control instanceof StyledText) {
            StyledText textWidget = (StyledText)control;
            int caretOffset = textWidget.getCaretOffset();
            Point locationAtOffset = textWidget.getLocationAtOffset(caretOffset);
            locationAtOffset = textWidget.toDisplay(locationAtOffset.x, locationAtOffset.y + textWidget.getLineHeight(caretOffset) + 2);
            return locationAtOffset;
        }
        return null;
    }
}

