/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.peer;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.internal.peer.CharacterPairMatcher;
import com.aptana.editor.common.internal.peer.ExitPolicy;
import com.aptana.scope.IScopeSelector;
import com.aptana.scope.ScopeSelector;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.SmartTypingPairsElement;
import com.aptana.scripting.model.filters.IModelFilter;
import com.aptana.scripting.model.filters.ScopeFilter;
import com.aptana.ui.epl.UIEplPlugin;
import io.emmet.eclipse.TabKeyHandler;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class PeerCharacterCloser
implements VerifyKeyListener,
ILinkedModeListener {
    public static final char[] CONTENTASSISTANT_CHARS = new char[]{'\u201c', '\u201d', '\u2018', '\u2019', '\u300a', '\u3002', '\uffe5'};
    private AbstractThemeableEditor editor;
    private ITextViewer textViewer;
    private final String CATEGORY = this.toString();
    private IPositionUpdater fUpdater = new ExclusivePositionUpdater(this.CATEGORY);
    private Stack<BracketLevel> fBracketLevelStack = new Stack();
    private char[] pairs = new char[]{'\"', '\"', '(', ')', '{', '}', '[', ']', '\'', '\''};
    private boolean autoInsertEnabled = true;
    private boolean autoWrapEnabled = true;
    private static final HashMap<String, String> PUNCTUATION_MAP = new HashMap();

    static {
        PUNCTUATION_MAP.put("\uff1a", ":");
        PUNCTUATION_MAP.put("\u201c", "\"");
        PUNCTUATION_MAP.put("\u201d", "\"");
        PUNCTUATION_MAP.put("\uff1b", ";");
        PUNCTUATION_MAP.put("\u2018", "'");
        PUNCTUATION_MAP.put("\u2019", "'");
        PUNCTUATION_MAP.put("\uff0c", ",");
        PUNCTUATION_MAP.put("\u300a", "<");
        PUNCTUATION_MAP.put("\u3002", ".");
        PUNCTUATION_MAP.put("\u300b", ">");
        PUNCTUATION_MAP.put("\u3001", "/");
        PUNCTUATION_MAP.put("\uff1f", "?");
        PUNCTUATION_MAP.put("\u3010", "[");
        PUNCTUATION_MAP.put("\u3011", "]");
        PUNCTUATION_MAP.put("\u00b7", "`");
        PUNCTUATION_MAP.put("\uff01", "!");
        PUNCTUATION_MAP.put("\uffe5", "$");
        PUNCTUATION_MAP.put("\uff08", "(");
        PUNCTUATION_MAP.put("\uff09", ")");
    }

    public PeerCharacterCloser(AbstractThemeableEditor editor, ITextViewer textViewer) {
        this.editor = editor;
        this.textViewer = textViewer;
    }

    public void install() {
        this.textViewer.getTextWidget().addVerifyKeyListener((VerifyKeyListener)this);
    }

    public void verifyKey(VerifyEvent event) {
        char character;
        int length;
        int offset;
        IDocument document;
        block10: {
            if (!event.doit || !this.isAutoInsertEnabled() || this.isModifierKey(event.keyCode)) {
                return;
            }
            document = this.textViewer.getDocument();
            Point selection = this.textViewer.getSelectedRange();
            offset = selection.x;
            length = selection.y;
            character = event.character;
            if (this.isChinesePunctuation(character)) {
                try {
                    String k;
                    String s;
                    if (!this.editor.isEnableTransformChinesePunctuation(offset, character) || !StringUtil.isNotBlank((String)(s = PUNCTUATION_MAP.get(k = String.valueOf(character)))) || this.isAutoInsertCharacter(character = s.charAt(0))) break block10;
                    try {
                        if (k.equals("\uff09") || k.equals("\u3011")) {
                            Position[] positions;
                            Position[] positionArray = positions = document.getPositions(this.CATEGORY);
                            int n = positions.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String c;
                                Position position = positionArray[n2];
                                if (position != null && position.getOffset() == offset && s.equals(c = document.get(position.getOffset(), position.getLength()))) {
                                    event.doit = false;
                                    this.textViewer.setSelectedRange(offset + 1, 0);
                                    return;
                                }
                                ++n2;
                            }
                        }
                    }
                    catch (Exception exception) {}
                    document.replace(offset, length, k);
                    document.replace(offset, 1, s);
                    this.textViewer.setSelectedRange(offset + 1, 0);
                    event.doit = false;
                    this.reshowContentAssistant(event, document, offset, character);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (this.isKeyCharacter(character)) {
            this.processPeerCharater(event, document, offset, length, character);
        }
    }

    public void processPeerCharater(VerifyEvent event, IDocument document, int offset, int length, char character) {
        try {
            char nextChar;
            if (length == 1 && (this.isReplaceBeforeCharacter(document.get(offset, length)) || this.isReplaceAfterCharacter(document.get(offset, length))) && this.isAutoWrapEnabled()) {
                this.replaceSelection(event, document, offset, length, character);
                return;
            }
            if (!this.isAutoInsertCharacter(character)) {
                return;
            }
            if (length > 0 && this.isAutoWrapEnabled()) {
                this.wrapSelection(event, document, offset, length, character);
                return;
            }
            if (document.getLength() > offset && Character.isJavaIdentifierPart(nextChar = document.getChar(offset))) {
                return;
            }
            if (this.isUnclosedPair(event, document, offset, character)) {
                return;
            }
            char closingCharacter = this.getPeerCharacter(character);
            if (this.unpairedClose(character, closingCharacter, document, offset)) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(character);
            buffer.append(closingCharacter);
            if (offset == document.getLength()) {
                String delim = null;
                if (document instanceof IDocumentExtension4) {
                    delim = ((IDocumentExtension4)document).getDefaultLineDelimiter();
                }
                if (delim == null) {
                    delim = System.getProperty("line.separator", "\r\n");
                }
                buffer.append(delim);
            }
            document.replace(offset, length, String.valueOf(event.character));
            document.replace(offset, 1, buffer.toString());
            BracketLevel level = new BracketLevel();
            this.fBracketLevelStack.push(level);
            LinkedPositionGroup group = new LinkedPositionGroup();
            group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
            LinkedModeModel model = new LinkedModeModel();
            model.addLinkingListener((ILinkedModeListener)this);
            model.addGroup(group);
            model.forceInstall();
            if (this.fBracketLevelStack.size() == 1) {
                document.addPositionCategory(this.CATEGORY);
                document.addPositionUpdater(this.fUpdater);
            }
            level.fFirstPosition = new Position(offset, 1);
            level.fSecondPosition = new Position(offset + 1, 1);
            document.addPosition(this.CATEGORY, level.fFirstPosition);
            document.addPosition(this.CATEGORY, level.fSecondPosition);
            level.fUI = new EditorLinkedModeUI(model, this.textViewer);
            level.fUI.setSimpleMode(true);
            level.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(this.textViewer, closingCharacter, PeerCharacterCloser.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
            level.fUI.setExitPosition(this.textViewer, offset + 2, 0, Integer.MAX_VALUE);
            level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
            level.fUI.enter();
            TabKeyHandler.uninstall((AbstractTextEditor)this.editor);
            TabKeyHandler.install((ITextEditor)this.editor);
            IRegion newSelection = level.fUI.getSelectedRegion();
            this.textViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
            event.doit = false;
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        catch (BadPositionCategoryException e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        this.reshowContentAssistant(event, document, offset, character);
    }

    protected void reshowContentAssistant(VerifyEvent event, IDocument document, int offset, char character) {
        final ITextViewer viewer = this.textViewer;
        if (this.isContentassistantChar(document, offset, event.character)) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (((ITextOperationTarget)viewer).canDoOperation(13)) {
                        UIEplPlugin.setReShowContentAssistant((ITextViewer)viewer, (boolean)true);
                        ((ITextOperationTarget)viewer).doOperation(13);
                        UIEplPlugin.setReShowContentAssistant((ITextViewer)viewer, (boolean)false);
                    }
                }
            });
        }
    }

    private boolean isContentassistantChar(IDocument document, int offset, char character) {
        int i = 0;
        while (i < CONTENTASSISTANT_CHARS.length) {
            if (CONTENTASSISTANT_CHARS[i] == character) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isModifierKey(int keyCode) {
        switch (keyCode) {
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 27: 
            case 127: 
            case 65536: 
            case 131072: 
            case 262144: 
            case 0x400000: 
            case 0x1000001: 
            case 0x1000002: 
            case 0x1000003: 
            case 0x1000004: {
                return true;
            }
        }
        return false;
    }

    protected List<Character> getPairs(String scope) {
        ScopeFilter filter = new ScopeFilter(scope);
        List pairs = BundleManager.getInstance().getPairs((IModelFilter)filter);
        if (pairs == null || pairs.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<IScopeSelector, SmartTypingPairsElement> map = new HashMap<IScopeSelector, SmartTypingPairsElement>();
        for (SmartTypingPairsElement pe : pairs) {
            IScopeSelector ss = pe.getScopeSelector();
            if (ss == null) continue;
            map.put(ss, pe);
        }
        IScopeSelector bestMatch = ScopeSelector.bestMatch(map.keySet(), (String)scope);
        SmartTypingPairsElement yay = (SmartTypingPairsElement)map.get(bestMatch);
        if (yay == null) {
            return Collections.emptyList();
        }
        return yay.getPairs();
    }

    protected String getScopeAtOffset(IDocument document, int offset) throws BadLocationException {
        if (this.textViewer == null) {
            return CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset(document, offset);
        }
        return CommonEditorPlugin.getDefault().getDocumentScopeManager().getScopeAtOffset(this.textViewer, offset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean unpairedClose(char openingChar, char closingCharacter, IDocument document, int offset) {
        try {
            ITypedRegion[] partitions;
            String partition = document.getContentType(offset);
            int index = partition.indexOf(95, 2);
            String prefix = partition.substring(0, index);
            int stackLevel = 0;
            ITypedRegion[] iTypedRegionArray = partitions = this.computePartitioning(document, 0, document.getLength());
            int n = partitions.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedRegion part = iTypedRegionArray[n2];
                if (!part.getType().contains("_comment") && !part.getType().contains("_string") && part.getType().startsWith(prefix)) {
                    char c;
                    int i;
                    int start = part.getOffset();
                    int end = start + part.getLength();
                    if (offset > start) {
                        String before;
                        int beforeEnd = end;
                        if (offset < end) {
                            beforeEnd = offset;
                        }
                        if ((before = document.get(start, beforeEnd - start)).trim().length() != 0) {
                            i = 0;
                            while (i < before.length()) {
                                c = before.charAt(i);
                                if (c == openingChar && openingChar == closingCharacter) {
                                    ++stackLevel;
                                    stackLevel %= 2;
                                } else if (c == openingChar) {
                                    ++stackLevel;
                                } else if (c == closingCharacter) {
                                    --stackLevel;
                                }
                                ++i;
                            }
                        }
                    }
                    if (offset < end) {
                        int startAfter = start;
                        if (offset > start) {
                            startAfter = offset;
                        }
                        String after = document.get(startAfter, end - startAfter);
                        i = 0;
                        while (i < after.length()) {
                            c = after.charAt(i);
                            if (c == openingChar && openingChar == closingCharacter) {
                                ++stackLevel;
                                stackLevel %= 2;
                            } else if (c == openingChar) {
                                ++stackLevel;
                            } else if (c == closingCharacter && --stackLevel < 0) {
                                return true;
                            }
                            ++i;
                        }
                    }
                }
                ++n2;
            }
            return stackLevel != 0;
        }
        catch (Exception e) {
            IdeLog.logWarning((Plugin)CommonEditorPlugin.getDefault(), (String)MessageFormat.format("Failed to determine if we have an unclosed pair. Open: ''{0}'', close: ''{1}'', offset: {2}", Character.valueOf(openingChar), Character.valueOf(closingCharacter), offset), (Throwable)e);
            return false;
        }
    }

    protected ITypedRegion[] computePartitioning(IDocument document, int offset, int length) throws BadLocationException {
        return document.computePartitioning(offset, length);
    }

    private boolean isUnclosedPair(VerifyEvent event, IDocument document, int offset, char character) throws BadLocationException {
        String contentType = document.getContentType(offset);
        if (StringUtil.isNotBlank((String)contentType) && contentType.contains("_string_")) {
            return true;
        }
        char closingCharacter = this.getPeerCharacter(character);
        if (closingCharacter != character) {
            return false;
        }
        char c = character;
        int beginning = 0;
        if (document instanceof IDocumentExtension3) {
            try {
                IDocumentExtension3 ext = (IDocumentExtension3)document;
                ITypedRegion region = this.getPartition(ext, "__dftl_partitioning", offset, false);
                beginning = region.getOffset();
            }
            catch (BadPartitioningException badPartitioningException) {}
        }
        String previous = document.get(beginning, offset - beginning);
        boolean open = false;
        int index = -1;
        while ((index = previous.indexOf(c, index + 1)) != -1) {
            open = !open;
            c = open ? closingCharacter : character;
        }
        return open;
    }

    protected ITypedRegion getPartition(IDocumentExtension3 ext, String defaultPartitioning, int offset, boolean b) throws BadLocationException, BadPartitioningException {
        return ext.getPartition(defaultPartitioning, offset, b);
    }

    private static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private void wrapSelection(VerifyEvent event, IDocument document, int offset, int length, char character) throws BadLocationException {
        char key = character;
        char closingCharacter = this.getPeerCharacter(key);
        StringBuffer buffer = new StringBuffer();
        buffer.append(key);
        buffer.append(document.get(offset, length));
        buffer.append(closingCharacter);
        document.replace(offset, length, String.valueOf(event.character));
        document.replace(offset, 1, buffer.toString());
        this.textViewer.setSelectedRange(offset + 1, length);
        event.doit = false;
        this.reshowContentAssistant(event, document, offset, character);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void replaceSelection(VerifyEvent event, IDocument document, int offset, int length, char character) throws BadLocationException {
        char key = character;
        String keyCharacter = String.valueOf(key);
        CharacterPairMatcher characterPairMatcher = new CharacterPairMatcher(this.pairs);
        IRegion region = characterPairMatcher.match(document, offset);
        if (region == null) return;
        if (this.isReplaceBeforeCharacter(keyCharacter) && region.getOffset() == offset) {
            document.replace(region.getOffset(), 1, String.valueOf(event.character));
            document.replace(region.getOffset() + region.getLength() - 1, 1, String.valueOf(this.getPeerCharacter(key)));
            event.doit = false;
            return;
        } else {
            if (!this.isReplaceAfterCharacter(keyCharacter) || region.getOffset() + region.getLength() - 1 != offset) return;
            document.replace(region.getOffset() + region.getLength() - 1, 1, String.valueOf(event.character));
            document.replace(region.getOffset(), 1, String.valueOf(this.getBeforeCharacter(key)));
            event.doit = false;
        }
    }

    private char getPeerCharacter(char character) {
        int i = 0;
        while (i < this.pairs.length) {
            if (this.pairs[i] == character) {
                return this.pairs[i + 1];
            }
            i += 2;
        }
        return character;
    }

    private char getBeforeCharacter(char character) {
        int i = 1;
        while (i < this.pairs.length) {
            if (this.pairs[i] == character) {
                return this.pairs[i - 1];
            }
            i += 2;
        }
        return character;
    }

    public boolean isKeyCharacter(char character) {
        int i = 0;
        while (i < this.pairs.length) {
            if (this.pairs[i] == character) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isChinesePunctuation(char character) {
        char[] chinesePunctuation = this.editor.getChinesePunctuationCharacters();
        if (chinesePunctuation == null) {
            return false;
        }
        int i = 0;
        while (i < chinesePunctuation.length) {
            if (chinesePunctuation[i] == character) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isAutoInsertCharacter(char character) {
        int i = 0;
        while (i < this.pairs.length) {
            if (this.pairs[i] == character) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private boolean isReplaceBeforeCharacter(String character) {
        int i = 0;
        while (i < this.pairs.length) {
            if (String.valueOf(this.pairs[i]).equals(character)) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private boolean isReplaceAfterCharacter(String character) {
        int i = 1;
        while (i < this.pairs.length) {
            if (String.valueOf(this.pairs[i]).equals(character)) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public boolean isAutoInsertEnabled() {
        return this.autoInsertEnabled;
    }

    public void setAutoInsertEnabled(boolean autoInsertEnabled) {
        this.autoInsertEnabled = autoInsertEnabled;
    }

    public boolean isAutoWrapEnabled() {
        return this.autoWrapEnabled;
    }

    public void setAutoWrapEnabled(boolean autoWrapEnabled) {
        this.autoWrapEnabled = autoWrapEnabled;
    }

    public void left(LinkedModeModel environment, int flags) {
        final BracketLevel level = this.fBracketLevelStack.pop();
        if (flags != 8) {
            return;
        }
        final IDocument document = this.textViewer.getDocument();
        if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                public void perform(IDocument d, IDocumentListener owner) {
                    if ((level.fFirstPosition.isDeleted || level.fFirstPosition.length == 0) && !level.fSecondPosition.isDeleted && level.fSecondPosition.offset == level.fFirstPosition.offset) {
                        try {
                            document.replace(level.fSecondPosition.offset, level.fSecondPosition.length, null);
                        }
                        catch (BadLocationException e) {
                            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                        }
                    }
                    if (PeerCharacterCloser.this.fBracketLevelStack.size() == 0) {
                        document.removePositionUpdater(PeerCharacterCloser.this.fUpdater);
                        try {
                            document.removePositionCategory(PeerCharacterCloser.this.CATEGORY);
                        }
                        catch (BadPositionCategoryException e) {
                            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                        }
                    }
                }
            });
        }
    }

    public void suspend(LinkedModeModel environment) {
    }

    public void resume(LinkedModeModel environment, int flags) {
    }

    static class BracketLevel {
        LinkedModeUI fUI;
        Position fFirstPosition;
        Position fSecondPosition;

        BracketLevel() {
        }
    }

    private static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
    }
}

