/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.commands;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.ui.util.UIUtils;
import com.pandora.core.auth.UserAuth;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorPart;

public class RemarkActionKeyCommandHandler
implements IHandler {
    private static IDocument _document = null;
    private static final String SPACE = " ";
    private static final char COMMENT_CHAR = '*';
    private static final String DOCUMENTATION_START = "/**";
    private static final String COMMENT_END = "*/";

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            int offset;
            AbstractThemeableEditor editor;
            String comment;
            String commentString = "";
            IEditorPart activeEditor = UIUtils.getActiveEditor();
            if (activeEditor instanceof AbstractThemeableEditor && StringUtil.isNotBlank((String)(comment = this.getAutoIndentAfterNewLine(_document = (editor = (AbstractThemeableEditor)activeEditor).getDocumentProvider().getDocument((Object)editor.getEditorInput()), offset = editor.getCaretOffset())))) {
                commentString = String.valueOf(commentString) + comment + "\r\n";
                IRegion info = _document.getLineInformationOfOffset(offset);
                int start = info.getOffset();
                _document.replace(start, 0, commentString);
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    protected String getAutoIndentAfterNewLine(IDocument d, int offset) {
        String indent;
        StringBuilder buf;
        block9: {
            String line;
            block8: {
                if (offset == -1 || d.getLength() == 0) {
                    return "";
                }
                buf = new StringBuilder();
                try {
                    IRegion info = d.getLineInformationOfOffset(offset);
                    int start = info.getOffset();
                    int end = this.findEndOfWhiteSpace(d, start, offset);
                    indent = "";
                    if (end > start) {
                        indent = d.get(start, end - start);
                    }
                    buf.append(indent);
                    ITypedRegion region = d.getPartition(offset);
                    if (region.getType().contains("html")) {
                        return buf.toString();
                    }
                    line = d.get(info.getOffset(), info.getLength());
                    if (!StringUtil.isBlank((String)line)) break block8;
                    return "";
                }
                catch (BadLocationException badLocationException) {}
            }
            if (!line.trim().startsWith("//") && !line.trim().startsWith("/*") && !line.trim().startsWith("*")) break block9;
            return "";
        }
        String commentIndent = "";
        String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
        buf.append(commentIndent).append(DOCUMENTATION_START).append(lineDelimiter);
        this.handleScriptDoc(d, offset, buf, commentIndent, lineDelimiter, indent);
        if (this.checkNextLineForComment(d, offset)) {
            return buf.toString();
        }
        buf.append(lineDelimiter).append(indent).append(SPACE).append(COMMENT_END);
        return buf.toString();
    }

    protected boolean checkNextLineForComment(IDocument document, int offset) {
        try {
            IRegion nextLineInfo = document.getLineInformationOfOffset(offset + 1);
            String nextLine = document.get(nextLineInfo.getOffset(), nextLineInfo.getLength()).trim();
            return StringUtil.startsWith((String)nextLine, (char)'*') && !StringUtil.startsWith((String)nextLine, (String)COMMENT_END) || nextLine.endsWith(COMMENT_END);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected void handleScriptDoc(IDocument document, int offset, StringBuilder buf, String commentIndent, String lineDelimiter, String indent) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Calendar cal = Calendar.getInstance();
            buf.append(indent).append(commentIndent).append(SPACE).append('*').append(SPACE).append("@\u4f5c\u8005\uff1a" + UserAuth.getUsername());
            buf.append(String.valueOf(lineDelimiter) + indent + commentIndent).append(SPACE).append('*').append(SPACE).append("@\u65f6\u95f4\uff1a" + sdf.format(cal.getTime()));
            this.AddScriptParaDoc(document, offset, buf, lineDelimiter, indent, commentIndent);
            buf.append(String.valueOf(lineDelimiter) + indent + commentIndent).append(SPACE).append('*').append(SPACE).append("@\u63cf\u8ff0\uff1a ");
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void AddScriptParaDoc(IDocument d, int offset, StringBuilder buf, String lineDelimiter, String indent, String commentIndent) throws BadLocationException {
        int lineNum = d.getLineOfOffset(offset);
        IRegion info1 = d.getLineInformation(lineNum);
        String lineString = d.get(info1.getOffset(), info1.getLength());
        boolean hasText = true;
        while (hasText) {
            if (StringUtil.isBlank((String)lineString.trim())) {
                info1 = d.getLineInformation(++lineNum);
                lineString = d.get(info1.getOffset(), info1.getLength()).trim();
                continue;
            }
            hasText = false;
            break;
        }
        String paraString = "";
        if (lineString.indexOf("function") > 0) {
            lineString = lineString.substring(lineString.indexOf("function"));
            int sIndex = lineString.indexOf("(");
            int eIndex = lineString.indexOf(")");
            if (sIndex > 0 && eIndex > 0) {
                paraString = lineString.substring(sIndex + 1, eIndex).trim();
            }
        }
        if (StringUtil.isNotBlank((String)paraString)) {
            String[] paras;
            String[] stringArray = paras = paraString.split(",");
            int n = paras.length;
            int n2 = 0;
            while (n2 < n) {
                String para = stringArray[n2];
                buf.append(String.valueOf(lineDelimiter) + indent + commentIndent).append(SPACE).append('*').append(SPACE).append("@param ").append(String.valueOf(para.trim()) + ":");
                ++n2;
            }
        }
    }

    protected int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

