/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.commands;

import com.aptana.editor.common.AbstractThemeableEditor;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class LinkedModelEditorActionKeyCommandHandler
extends AbstractHandler {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (!(editor instanceof AbstractThemeableEditor)) return null;
            AbstractThemeableEditor abstractThemeableEditor = (AbstractThemeableEditor)editor;
            IDocument document = abstractThemeableEditor.getDocument();
            boolean isInstalled = LinkedModeModel.hasInstalledModel((IDocument)document);
            if (!isInstalled) {
                abstractThemeableEditor.addLinkedModelPosition(false);
                return null;
            }
            LinkedPositionGroup linkedPositionGroup = abstractThemeableEditor.getfLinkedPositionGroup();
            LinkedPosition[] linkedPositions = linkedPositionGroup.getPositions();
            if (linkedPositions == null) return null;
            if (linkedPositions.length < 1) {
                return null;
            }
            ISelection selection = abstractThemeableEditor.getSelectionProvider().getSelection();
            boolean isIncluded = false;
            String wholeString = "";
            int caretPos = 0;
            if (selection instanceof ITextSelection) {
                ITextSelection textSelection = (ITextSelection)selection;
                int offset = textSelection.getOffset();
                LinkedPosition[] linkedPositionArray = linkedPositions;
                int n = linkedPositions.length;
                int n2 = 0;
                while (n2 < n) {
                    LinkedPosition linkedPosition = linkedPositionArray[n2];
                    if (linkedPosition.includes(offset)) {
                        isIncluded = true;
                        break;
                    }
                    ++n2;
                }
                caretPos = textSelection.getOffset();
                int startPos = abstractThemeableEditor.getStartPos(caretPos, document);
                int endPos = abstractThemeableEditor.getEndtPos(caretPos, document);
                if (endPos != startPos) {
                    ++startPos;
                } else if (caretPos > 0) {
                    startPos = abstractThemeableEditor.getStartPos(caretPos - 1, document);
                    endPos = abstractThemeableEditor.getEndtPos(caretPos - 1, document);
                    startPos = endPos != startPos ? ++startPos : (endPos = caretPos);
                } else {
                    startPos = endPos = caretPos;
                }
                wholeString = document.get(startPos, endPos - startPos);
            }
            if (!isIncluded) {
                abstractThemeableEditor.addLinkedModelPosition(false);
                return null;
            }
            String findString = linkedPositions[0].getContent();
            boolean isWholeWord = findString.equals(wholeString);
            FindReplaceDocumentAdapter findReplaceDocumentAdapter = new FindReplaceDocumentAdapter(document);
            IRegion region = findReplaceDocumentAdapter.find(linkedPositions[linkedPositions.length - 1].getOffset() + linkedPositions[linkedPositions.length - 1].getLength(), findString, true, false, isWholeWord, false);
            if (region == null) {
                region = findReplaceDocumentAdapter.find(0, findString, true, false, isWholeWord, false);
            }
            if (region == null) {
                return null;
            }
            String fContent = document.get(region.getOffset(), region.getLength());
            if ((region = this.getSearchContent(findString, isWholeWord, findReplaceDocumentAdapter, region, fContent, document)) == null) {
                return null;
            }
            abstractThemeableEditor.addLinkedModelUI(document, region.getOffset(), region.getOffset() + region.getLength(), false, false, caretPos);
            return null;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return null;
    }

    private IRegion getSearchContent(String findString, boolean isWholeWord, FindReplaceDocumentAdapter findReplaceDocumentAdapter, IRegion region, String fContent, IDocument document) throws BadLocationException {
        if (region != null && !fContent.equals(findString)) {
            if ((region = findReplaceDocumentAdapter.find(region.getOffset() + region.getLength(), findString, true, false, isWholeWord, false)) == null) {
                return null;
            }
            fContent = document.get(region.getOffset(), region.getLength());
            return this.getSearchContent(findString, isWholeWord, findReplaceDocumentAdapter, region, fContent, document);
        }
        return region;
    }
}

