/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.internal.commands;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.text.RubyRegexpAutoIndentStrategy;
import com.aptana.editor.common.viewer.CommonProjectionViewer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IContentFormatterExtension;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class CopyAndFormatActionKeyCommandHandler
extends AbstractHandler {
    private int replaceOffset = -1;
    private int replaceLength = -1;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.replaceOffset = -1;
        this.replaceLength = -1;
        Clipboard clipboard = null;
        try {
            TextTransfer plainTextTransfer;
            IEditorPart editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            if (editorPart == null) {
                return null;
            }
            AbstractThemeableEditor activeEditor = null;
            if (editorPart instanceof AbstractThemeableEditor) {
                activeEditor = (AbstractThemeableEditor)editorPart;
            }
            if (activeEditor == null) {
                return null;
            }
            ISourceViewer sourceViewer = activeEditor.getISourceViewer();
            clipboard = new Clipboard(sourceViewer.getTextWidget().getDisplay());
            Object object = clipboard.getContents((Transfer)(plainTextTransfer = TextTransfer.getInstance()), 1);
            if (object == null) {
                return null;
            }
            ITextSelection selection = (ITextSelection)sourceViewer.getSelectionProvider().getSelection();
            if (selection == null) {
                return null;
            }
            try {
                this.replaceOffset = selection.getOffset();
                this.replaceLength = selection.getLength();
                String text = object.toString();
                IDocument document = sourceViewer.getDocument();
                text = this.getAutoIndentContent(sourceViewer, selection, text, document, activeEditor);
                document.replace(this.replaceOffset, this.replaceLength, text);
                int sOffset = this.replaceOffset + text.length();
                sourceViewer.getTextWidget().setSelection(sOffset, sOffset);
                clipboard.dispose();
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            }
        }
        finally {
            if (clipboard != null && !clipboard.isDisposed()) {
                clipboard.dispose();
            }
        }
        return null;
    }

    public String getAutoIndentContent(ISourceViewer sourceViewer, ITextSelection selection, String text, IDocument document, AbstractThemeableEditor activeEditor) throws BadLocationException {
        try {
            int offset = selection.getOffset();
            IRegion lineRegion = document.getLineInformationOfOffset(offset);
            int lineOffset = lineRegion.getOffset();
            String lineContent = document.get(lineOffset, lineRegion.getLength());
            boolean needFormat = false;
            String prefix = lineContent.substring(0, offset - lineOffset);
            if (StringUtil.isBlank((String)lineContent.trim())) {
                needFormat = true;
                this.replaceOffset = lineOffset;
                this.replaceLength = lineRegion.getLength();
            } else if (StringUtil.isBlank((String)prefix.trim())) {
                needFormat = true;
                this.replaceOffset = lineOffset;
                this.replaceLength = prefix.length() + selection.getLength();
            }
            if (needFormat) {
                SourceViewerConfiguration sourceViewerConfiguration = activeEditor.getISourceViewerConfiguration();
                IAutoEditStrategy[] autoEditStrategys = sourceViewerConfiguration.getAutoEditStrategies(sourceViewer, document.getContentType(offset));
                if (autoEditStrategys == null || autoEditStrategys.length == 0 || !(autoEditStrategys[0] instanceof RubyRegexpAutoIndentStrategy)) {
                    return text;
                }
                RubyRegexpAutoIndentStrategy autoEditStrategy = (RubyRegexpAutoIndentStrategy)autoEditStrategys[0];
                int startLine = selection.getStartLine();
                DocumentCommand cmd = new DocumentCommand(){};
                if (startLine == 0) {
                    cmd.offset = 0;
                } else {
                    IRegion info = document.getLineInformation(startLine - 1);
                    while (info.getOffset() > 0 && (info.getLength() == 0 || StringUtil.isBlank((String)document.get(info.getOffset(), info.getLength())))) {
                        info = document.getLineInformationOfOffset(info.getOffset() - 1);
                    }
                    cmd.offset = info.getOffset() + info.getLength();
                }
                cmd.text = "\r\n";
                cmd.caretOffset = -1;
                autoEditStrategy.customizeDocumentCommand(document, cmd, false);
                if (cmd.text == null || cmd.text.length() < 2) {
                    return text;
                }
                String expectedIndents = cmd.text.substring(2, cmd.text.length());
                IContentFormatter contentFormatter = sourceViewerConfiguration.getContentFormatter(sourceViewer);
                if (sourceViewer instanceof CommonProjectionViewer) {
                    CommonProjectionViewer commonProjectionViewer = (CommonProjectionViewer)sourceViewer;
                    IFormattingContext context = commonProjectionViewer.createFormattingContext();
                    context.setProperty((Object)"formatting.context.document", (Object)Boolean.TRUE);
                    if (contentFormatter instanceof IContentFormatterExtension) {
                        IContentFormatterExtension extension = (IContentFormatterExtension)contentFormatter;
                        Document d = new Document(text.trim());
                        extension.format((IDocument)d, context);
                        int lines = d.getNumberOfLines();
                        IRegion lineR = null;
                        StringBuffer sb = new StringBuffer();
                        if (prefix != null && prefix.length() > 0 && expectedIndents.startsWith(prefix)) {
                            sb.append(expectedIndents.substring(prefix.length()));
                            this.replaceOffset = selection.getOffset();
                            this.replaceLength = selection.getLength();
                        } else {
                            sb.append(expectedIndents);
                        }
                        int i = 0;
                        while (i < lines) {
                            lineR = d.getLineInformation(i);
                            sb.append(d.get(lineR.getOffset(), lineR.getLength()));
                            if (i != lines - 1) {
                                sb.append("\r\n");
                                sb.append(expectedIndents);
                            }
                            ++i;
                        }
                        text = sb.toString();
                    }
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return text;
    }
}

