/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.extensions;

import com.aptana.editor.findbar.api.FindBarDecoratorFactory;
import com.aptana.editor.findbar.api.IFindBarDecorated;
import com.aptana.editor.findbar.api.IFindBarDecorator;
import java.lang.ref.WeakReference;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.texteditor.ITextEditor;

public class FindBarEditorExtension {
    private WeakReference<ITextEditor> fEditor;
    private IFindBarDecorated fFindBarDecorated;
    private IFindBarDecorator fFindBarDecorator;

    public FindBarEditorExtension(IAdaptable editor) {
        ITextEditor textEditor;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else {
            textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
            if (textEditor == null) {
                throw new AssertionError((Object)"The editor passed must either be an ITextEditor or provide adaptation to it.");
            }
        }
        this.fEditor = new WeakReference<ITextEditor>(textEditor);
    }

    public Composite createFindBarComposite(Composite parent) {
        Composite findBarComposite = this.getFindBarDecorator().createFindBarComposite(parent);
        return findBarComposite;
    }

    public void createFindBar(ISourceViewer sourceViewer) {
        this.getFindBarDecorator().createFindBar(sourceViewer);
    }

    public void createFindBarActions() {
        this.getFindBarDecorator().installActions();
    }

    public void activateContexts(String[] contextIds) {
        this.getFindBarDecorator().activateContexts(contextIds);
    }

    public Object getFindBarDecoratorAdapter(Class adapter) {
        if (IFindBarDecorated.class.equals((Object)adapter)) {
            return this.getFindBarDecorated();
        }
        return null;
    }

    IFindBarDecorated getFindBarDecorated() {
        if (this.fFindBarDecorated == null) {
            this.fFindBarDecorated = new IFindBarDecorated(){

                public IFindBarDecorator getFindBarDecorator() {
                    return FindBarEditorExtension.this.getFindBarDecorator();
                }
            };
        }
        return this.fFindBarDecorated;
    }

    private IFindBarDecorator getFindBarDecorator() {
        if (this.fFindBarDecorator == null) {
            this.fFindBarDecorator = FindBarDecoratorFactory.createFindBarDecorator((ITextEditor)((ITextEditor)this.fEditor.get()));
        }
        return this.fFindBarDecorator;
    }

    public void dispose() {
        this.fFindBarDecorated = null;
        if (this.fFindBarDecorator != null) {
            this.fFindBarDecorator.dispose();
        }
        this.fFindBarDecorator = null;
        if (this.fEditor != null) {
            this.fEditor.clear();
            this.fEditor = null;
        }
    }
}

