/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.CommonEditorPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.ResourceAction;

public class ValitationManagerAction
extends ResourceAction
implements IUpdate {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private String fAddLabel;

    public ValitationManagerAction(ResourceBundle bundle, String prefix, ITextEditor editor, IVerticalRulerInfo ruler) {
        super(bundle, prefix);
        this.fRuler = ruler;
        this.fTextEditor = editor;
        this.fAddLabel = "\u8bed\u6cd5\u9a8c\u8bc1\u5668\u8bbe\u7f6e(&V)...";
    }

    public void update() {
        this.setText(this.fAddLabel);
    }

    public void run() {
        String id = "com.aptana.editor.common.ValidationPreferencePage";
        PreferenceDialog p = PreferencesUtil.createPreferenceDialogOn((Shell)Display.getCurrent().getActiveShell(), (String)id, (String[])new String[]{id}, null);
        p.open();
    }

    protected List<IMarker> getMarkers() {
        ArrayList<IMarker> markers = new ArrayList<IMarker>();
        IResource resource = this.getResource();
        IDocument document = this.getDocument();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (resource != null && model != null && resource.exists()) {
            try {
                IMarker[] errorMarkers = resource.findMarkers("org.eclipse.ui.workbench.texteditor.error", true, 0);
                IMarker[] warningMarkers = resource.findMarkers("org.eclipse.ui.workbench.texteditor.warning", true, 0);
                List<Object> allMarkers = new ArrayList();
                if (errorMarkers == null || errorMarkers.length == 0) {
                    allMarkers = Arrays.asList(errorMarkers);
                }
                if (warningMarkers == null || warningMarkers.length == 0) {
                    allMarkers.addAll(Arrays.asList(warningMarkers));
                }
                if (allMarkers != null) {
                    int i = 0;
                    while (i < allMarkers.size()) {
                        if (this.includesRulerLine(model.getMarkerPosition((IMarker)allMarkers.get(i)), document)) {
                            markers.add((IMarker)allMarkers.get(i));
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException x) {
                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)x);
            }
        }
        return markers;
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    private boolean markersUserEditable(List<IMarker> markers) {
        Iterator<IMarker> iter = markers.iterator();
        while (iter.hasNext()) {
            if (this.isUserEditable(iter.next())) continue;
            return false;
        }
        return true;
    }

    private boolean isUserEditable(IMarker marker) {
        return marker != null && marker.exists() && marker.getAttribute("userEditable", true);
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected IResource getResource() {
        IEditorInput input = this.fTextEditor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null) {
            resource = (IResource)input.getAdapter(IResource.class);
        }
        return resource;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    protected IVerticalRuler getVerticalRuler() {
        if (this.fRuler instanceof IVerticalRuler) {
            return (IVerticalRuler)this.fRuler;
        }
        return null;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }
}

