/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.actions;

import com.aptana.buildpath.core.BuildPathCorePlugin;
import com.aptana.core.build.BuildRemoteParticipant;
import com.aptana.core.build.IBuildParticipant;
import com.aptana.core.build.IProblem;
import com.aptana.core.build.ReconcileContext;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.ICommonAnnotationModel;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.index.core.build.BuildContext;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParseResult;
import com.aptana.parsing.ParseState;
import com.aptana.parsing.ast.IParseError;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.ui.util.StatusLineUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ValidatorHandler
extends AbstractHandler {
    private Job validatorJob;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
            this.validateEditor(editor);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
        }
        return null;
    }

    public void validateEditor(IEditorPart editorPart) {
        if (editorPart != null) {
            AbstractThemeableEditor abstractThemeableEditor = null;
            if (editorPart instanceof AbstractThemeableEditor) {
                abstractThemeableEditor = (AbstractThemeableEditor)editorPart;
            } else if (editorPart.getAdapter(AbstractThemeableEditor.class) != null) {
                abstractThemeableEditor = (AbstractThemeableEditor)editorPart.getAdapter(AbstractThemeableEditor.class);
            }
            final AbstractThemeableEditor editor = abstractThemeableEditor;
            editor.setOpenManualValidator(true);
            Job job = new Job("\u8fd0\u884c\u9a8c\u8bc1\u5668"){

                protected IStatus run(IProgressMonitor monitor) {
                    block23: {
                        try {
                            BuildContext context = ValidatorHandler.this.createContext(editor);
                            context.setOpenManualValidator(true);
                            try {
                                StatusLineUtils.showStatusMessage((String)("\u6b63\u5728\u9a8c\u8bc1\u6587\u6863" + editor.getEditorInput().getName() + "\u8bed\u6cd5\u3002"), (long)5000L);
                            }
                            catch (Exception e) {
                                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                            }
                            List buildParticipants = ValidatorHandler.filterParticipants(editor.getEditorInput().getName());
                            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(buildParticipants.size() * 30 + 5));
                            buildParticipants = BuildRemoteParticipant.getInstance().buildFile(buildParticipants, context, sub);
                            for (IBuildParticipant buildParticipant : buildParticipants) {
                                if (monitor.isCanceled()) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                buildParticipant.buildStarting(context.getProject(), CommonEditorPlugin.VALIDATOR_BUILD_TYPE, (IProgressMonitor)sub.newChild(20));
                                buildParticipant.buildFile(context, (IProgressMonitor)sub.newChild(5));
                                buildParticipant.buildEnding((IProgressMonitor)sub.newChild(5));
                            }
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            try {
                                if (ValidatorHandler.this.getFile((IEditorPart)editor) != null) {
                                    ValidatorHandler.this.updateMarkers(context, (IProgressMonitor)sub.newChild(5));
                                    break block23;
                                }
                                ValidatorHandler.this.reportProblems(context, editor, (IProgressMonitor)sub.newChild(5));
                            }
                            catch (Exception e) {
                                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                            }
                        }
                        finally {
                            try {
                                StatusLineUtils.showStatusMessage((String)"\u8bed\u6cd5\u9a8c\u8bc1\u5b8c\u6bd5\u3002", (long)5000L);
                            }
                            catch (Exception e) {
                                IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
                            }
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
            if (this.validatorJob != null) {
                try {
                    this.validatorJob.cancel();
                }
                catch (Exception exception) {}
            }
            job.schedule();
            this.validatorJob = job;
        }
    }

    protected BuildContext createContext(final AbstractThemeableEditor editor) {
        if (editor == null) {
            return null;
        }
        IDocument fDocument = editor.getDocument();
        IFile file = this.getFile((IEditorPart)editor);
        if (file != null) {
            return new ReconcileContext(editor.getContentType(), file, fDocument.get()){

                public IParseRootNode getAST() throws CoreException {
                    ParseState parseState = this.getParseState();
                    if (parseState == null) {
                        parseState = new ParseState(this.getContents());
                    }
                    parseState.setBuildType(IBuildParticipant.BuildType.BUILD.toString());
                    return this.getAST((IParseState)parseState).getRootNode();
                }

                public String getContentType() throws CoreException {
                    Object[] types = this.getContentTypes();
                    if (ArrayUtil.isEmpty((Object[])types)) {
                        return null;
                    }
                    return types[0].getId();
                }

                public Collection<IParseError> getParseErrors() {
                    ParseResult pr;
                    if (editor != null && (pr = editor.getParseResult()) != null && !CollectionsUtil.isEmpty((Collection)pr.getErrors())) {
                        return pr.getErrors();
                    }
                    return super.getParseErrors();
                }
            };
        }
        return new ReconcileContext(editor.getContentType(), EditorUtil.getURI((IEditorPart)editor), fDocument.get()){

            public IParseRootNode getAST() throws CoreException {
                ParseState parseState = this.getParseState();
                if (parseState == null) {
                    parseState = new ParseState(this.getContents());
                }
                parseState.setBuildType(IBuildParticipant.BuildType.BUILD.toString());
                return this.getAST((IParseState)parseState).getRootNode();
            }

            public String getContentType() throws CoreException {
                Object[] types = this.getContentTypes();
                if (ArrayUtil.isEmpty((Object[])types)) {
                    return null;
                }
                return types[0].getId();
            }

            public Collection<IParseError> getParseErrors() {
                ParseResult pr;
                if (editor != null && (pr = editor.getParseResult()) != null && !CollectionsUtil.isEmpty((Collection)pr.getErrors())) {
                    return pr.getErrors();
                }
                return super.getParseErrors();
            }
        };
    }

    protected IFile getFile(IEditorPart editor) {
        IEditorInput editorInput;
        if (editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return fileEditorInput.getFile();
        }
        return null;
    }

    private void reportProblems(BuildContext context, AbstractThemeableEditor editor, IProgressMonitor monitor) {
        if (editor == null) {
            return;
        }
        IDocumentProvider docProvider = editor.getDocumentProvider();
        if (docProvider == null) {
            return;
        }
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput == null) {
            return;
        }
        IAnnotationModel model = docProvider.getAnnotationModel((Object)editorInput);
        if (!(model instanceof ICommonAnnotationModel)) {
            return;
        }
        ICommonAnnotationModel caModel = (ICommonAnnotationModel)model;
        caModel.reportProblems(context.getProblems(), monitor);
    }

    private void updateMarkers(BuildContext context, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        IFile file = context.getFile();
        Map itemsByType = context.getProblems();
        if (CollectionsUtil.isEmpty((Map)itemsByType)) {
            return;
        }
        this.updateMarkers(file, itemsByType, monitor);
    }

    public void updateMarkers(IFile file, Map<String, Collection<IProblem>> itemsByType, IProgressMonitor monitor) {
        if (monitor.isCanceled() || !file.exists()) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(itemsByType.size() * 10));
        for (String markerType : itemsByType.keySet()) {
            try {
                if (sub.isCanceled()) break;
                Collection<IProblem> newItems = itemsByType.get(markerType);
                file.deleteMarkers(markerType, false, 2);
                sub.worked(1);
                this.addMarkers(newItems, markerType, file, (IProgressMonitor)sub.newChild(9));
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)BuildPathCorePlugin.getDefault(), (Throwable)e);
            }
        }
        sub.done();
    }

    private void addMarkers(Collection<IProblem> items, String markerType, IFile file, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled() || CollectionsUtil.isEmpty(items)) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(items.size() * 2));
        for (IProblem item : items) {
            if (sub.isCanceled()) break;
            IMarker marker = file.createMarker(markerType);
            sub.worked(1);
            marker.setAttributes(item.createMarkerAttributes());
            sub.worked(1);
        }
        sub.done();
    }

    public static List<IBuildParticipant> filterParticipants(String name) {
        if (name != null) {
            ArrayList<IBuildParticipant> result = new ArrayList<IBuildParticipant>();
            IContentType[] contentTypes = Platform.getContentTypeManager().findContentTypesFor(name);
            if (contentTypes != null && contentTypes.length > 0) {
                IContentType[] iContentTypeArray = contentTypes;
                int n = contentTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IContentType contentType = iContentTypeArray[n2];
                    List buildParticipants = BuildPathCorePlugin.getDefault().getBuildParticipantManager().getBuildParticipants(contentType.getId());
                    if (buildParticipants != null) {
                        for (IBuildParticipant buildParticipant : buildParticipants) {
                            if (buildParticipant.isRequired() || !buildParticipant.isLazy()) continue;
                            result.add(buildParticipant);
                        }
                    }
                    ++n2;
                }
            }
            return result;
        }
        return null;
    }
}

