/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.common.actions;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.text.RubyRegexpAutoIndentStrategy;
import com.pandora.core.utils.StringUtil;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.internal.texteditor.CompoundEditExitStrategy;
import org.eclipse.ui.internal.texteditor.ICompoundEditListener;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class CustomMoveLineAction
extends TextEditorAction {
    private final boolean fUpwards;
    private ITextViewer fTextViewer;
    private AbstractThemeableEditor editor;
    private final CompoundEditExitStrategy fStrategy;
    private boolean fAddDelimiter;
    private boolean fEditInProgress = false;
    private Pattern startPattern = Pattern.compile("^(\\)|\\}|\\]|(\\-\\->)|(\\*\\*/)|(</[\\w|\\-]+)).*");
    private Pattern endPattern = Pattern.compile(".*(\\(|\\{|\\[|>|(<\\!\\-\\-))$");
    private Pattern endHtmlPattern = Pattern.compile(".*</[\\w|\\-]+\\s*>$");

    public CustomMoveLineAction(ResourceBundle bundle, String prefix, AbstractThemeableEditor editor, ITextViewer textViewer, boolean upwards) {
        super(bundle, prefix, (ITextEditor)editor);
        this.fTextViewer = textViewer;
        this.editor = editor;
        this.fUpwards = upwards;
        String[] commandIds = new String[]{"org.eclipse.ui.edit.text.moveLineUp", "org.eclipse.ui.edit.text.moveLineDown"};
        this.fStrategy = new CompoundEditExitStrategy(commandIds);
        this.fStrategy.addCompoundListener(new ICompoundEditListener(){

            public void endCompoundEdit() {
                CustomMoveLineAction.this.endCompoundEdit();
            }
        });
        this.update();
    }

    private void beginCompoundEdit() {
        ITextEditor editor = this.getTextEditor();
        if (this.fEditInProgress || this.fTextViewer == null || editor == null) {
            return;
        }
        this.fEditInProgress = true;
        this.fStrategy.arm(this.fTextViewer);
        IRewriteTarget target = (IRewriteTarget)editor.getAdapter(IRewriteTarget.class);
        if (target != null) {
            target.beginCompoundChange();
        }
    }

    private boolean containedByVisibleRegion(ITextSelection selection, ITextViewer viewer) {
        block7: {
            int visEnd;
            IDocument document;
            int max;
            block8: {
                int visOffset;
                IRegion visible;
                block5: {
                    int min;
                    block6: {
                        min = selection.getOffset();
                        max = min + selection.getLength();
                        document = viewer.getDocument();
                        visible = viewer instanceof ITextViewerExtension5 ? ((ITextViewerExtension5)viewer).getModelCoverage() : viewer.getVisibleRegion();
                        visOffset = visible.getOffset();
                        try {
                            if (visOffset <= min) break block5;
                            if (document.getLineOfOffset(visOffset) == selection.getStartLine()) break block6;
                            return false;
                        }
                        catch (BadLocationException badLocationException) {
                            return false;
                        }
                    }
                    if (this.isWhitespace(document.get(min, visOffset - min))) break block5;
                    this.showStatus();
                    return false;
                }
                visEnd = visOffset + visible.getLength();
                if (visEnd >= max) break block7;
                if (document.getLineOfOffset(visEnd) == selection.getEndLine()) break block8;
                return false;
            }
            if (this.isWhitespace(document.get(visEnd, max - visEnd))) break block7;
            this.showStatus();
            return false;
        }
        return true;
    }

    private void endCompoundEdit() {
        ITextEditor editor = this.getTextEditor();
        if (!this.fEditInProgress || editor == null) {
            return;
        }
        IRewriteTarget target = (IRewriteTarget)editor.getAdapter(IRewriteTarget.class);
        if (target != null) {
            target.endCompoundChange();
        }
        this.fEditInProgress = false;
    }

    private ITextSelection getMovingSelection(IDocument document, ITextSelection selection, ITextViewer viewer) throws BadLocationException {
        int low = document.getLineOffset(selection.getStartLine());
        int endLine = selection.getEndLine();
        int high = document.getLineOffset(endLine) + document.getLineLength(endLine);
        String delim = document.getLineDelimiter(endLine);
        if (delim != null) {
            high -= delim.length();
        }
        this.fAddDelimiter = delim != null && document.getLineLength(endLine) == delim.length();
        return new TextSelection(document, low, high - low);
    }

    private ITextSelection getSkippedLine(IDocument document, ITextSelection selection) {
        int skippedLineN;
        int n = skippedLineN = this.fUpwards ? selection.getStartLine() - 1 : selection.getEndLine() + 1;
        if (skippedLineN > document.getNumberOfLines() || skippedLineN < 0 || skippedLineN == document.getNumberOfLines()) {
            return null;
        }
        try {
            IRegion line = document.getLineInformation(skippedLineN);
            return new TextSelection(document, line.getOffset(), line.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private boolean isWhitespace(String string) {
        return string == null ? true : string.trim().length() == 0;
    }

    public void runWithEvent(Event event) {
        if (this.fTextViewer == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        IDocument document = this.fTextViewer.getDocument();
        if (document == null) {
            return;
        }
        StyledText widget = this.fTextViewer.getTextWidget();
        if (widget == null) {
            return;
        }
        ITextSelection sel = (ITextSelection)this.fTextViewer.getSelectionProvider().getSelection();
        if (sel.isEmpty()) {
            return;
        }
        ITextSelection skippedLine = this.getSkippedLine(document, sel);
        if (skippedLine == null) {
            return;
        }
        try {
            int deviation;
            int offset;
            String insertion;
            int insertionLength;
            String delim;
            ITextSelection movingArea = this.getMovingSelection(document, sel, this.fTextViewer);
            if (!this.containedByVisibleRegion(movingArea, this.fTextViewer) || !this.containedByVisibleRegion(skippedLine, this.fTextViewer)) {
                return;
            }
            String moving = movingArea.getText();
            String skipped = skippedLine.getText();
            if (moving == null || skipped == null || document.getLength() == 0) {
                return;
            }
            String indentedMoving = this.autoIndent(document, skippedLine, movingArea, skipped, moving);
            if (this.fUpwards) {
                delim = document.getLineDelimiter(skippedLine.getEndLine());
                Assert.isNotNull((Object)delim);
                insertionLength = moving.length() + delim.length() + skipped.length();
                insertion = String.valueOf(indentedMoving) + delim + skipped;
                offset = skippedLine.getOffset();
                deviation = -skippedLine.getLength() - delim.length();
            } else {
                delim = document.getLineDelimiter(movingArea.getEndLine());
                Assert.isNotNull((Object)delim);
                insertionLength = skipped.length() + delim.length() + moving.length();
                insertion = String.valueOf(skipped) + delim + indentedMoving;
                offset = movingArea.getOffset();
                deviation = skipped.length() + delim.length();
            }
            this.beginCompoundEdit();
            document.replace(offset, insertionLength, insertion);
            int selOffset = movingArea.getOffset() + deviation;
            int selLength = indentedMoving.length() + (this.fAddDelimiter ? delim.length() : 0);
            if (!(this.fTextViewer instanceof ITextViewerExtension5)) {
                selLength = Math.min(selLength, this.fTextViewer.getVisibleRegion().getOffset() + this.fTextViewer.getVisibleRegion().getLength() - selOffset);
            }
            this.selectAndReveal(this.fTextViewer, selOffset, selLength);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
    }

    private String autoIndent(IDocument document, ITextSelection skippedLine, ITextSelection movingArea, String skipped, String moving) throws BadLocationException {
        String indentedMoving = moving;
        try {
            if (movingArea.getLength() > 1000 || StringUtil.isBlank((String)skipped)) {
                return indentedMoving;
            }
            int startLine = movingArea.getStartLine();
            IRegion startLineInfo = null;
            IRegion endLineInfo = null;
            HashSet<Integer> emptyLines = new HashSet<Integer>();
            int line = movingArea.getStartLine();
            while (line <= movingArea.getEndLine()) {
                String lineText;
                IRegion info = document.getLineInformation(line);
                String string = lineText = info.getLength() == 0 ? "" : document.get(info.getOffset(), info.getLength());
                if (StringUtil.isNotBlank((String)lineText)) {
                    if (startLineInfo == null) {
                        startLineInfo = info;
                        startLine = line;
                    }
                    endLineInfo = info;
                } else {
                    emptyLines.add(line);
                }
                ++line;
            }
            if (startLineInfo == null) {
                return indentedMoving;
            }
            IAutoEditStrategy[] autoEditStrategys = this.editor.getISourceViewerConfiguration().getAutoEditStrategies(this.editor.getISourceViewer(), document.getContentType(skippedLine.getOffset()));
            if (autoEditStrategys == null || autoEditStrategys.length == 0 || !(autoEditStrategys[0] instanceof RubyRegexpAutoIndentStrategy)) {
                return indentedMoving;
            }
            RubyRegexpAutoIndentStrategy autoEditStrategy = (RubyRegexpAutoIndentStrategy)autoEditStrategys[0];
            DocumentCommand cmd = new DocumentCommand(){};
            if (this.fUpwards) {
                if (skippedLine.getStartLine() == 0) {
                    cmd.offset = 0;
                } else {
                    IRegion info = document.getLineInformation(skippedLine.getStartLine() - 1);
                    while (info.getOffset() > 0 && (info.getLength() == 0 || StringUtil.isBlank((String)document.get(info.getOffset(), info.getLength())))) {
                        info = document.getLineInformationOfOffset(info.getOffset() - 1);
                    }
                    cmd.offset = info.getOffset() + info.getLength();
                }
            } else {
                cmd.offset = skippedLine.getOffset() + skippedLine.getLength();
            }
            cmd.text = "\r\n";
            cmd.caretOffset = -1;
            autoEditStrategy.customizeDocumentCommand(document, cmd, false);
            if (cmd.text == null || cmd.text.length() < 2) {
                return indentedMoving;
            }
            String startText = document.get(startLineInfo.getOffset(), startLineInfo.getLength());
            String startTextTrim = startText.trim();
            boolean startMatch = this.startPattern.matcher(startTextTrim).matches();
            boolean endMatch = this.endPattern.matcher(startTextTrim).matches() && !this.endHtmlPattern.matcher(startTextTrim).matches();
            boolean enableIndent = !startMatch && !endMatch;
            String expectedIndents = cmd.text.substring(2, cmd.text.length());
            if (enableIndent && movingArea.getStartLine() == movingArea.getEndLine()) {
                indentedMoving = String.valueOf(expectedIndents) + indentedMoving.replaceAll("^\\s+", "");
            } else if (enableIndent || endMatch && !startMatch) {
                String endTextTrim = document.get(endLineInfo.getOffset(), endLineInfo.getLength()).trim();
                if (enableIndent || endMatch && !startMatch && this.startPattern.matcher(endTextTrim).matches() && !this.endPattern.matcher(endTextTrim).matches()) {
                    IRegion info;
                    int line2;
                    String startLineIndents = this.getLineIndents(autoEditStrategy, document, startLineInfo);
                    StringBuilder buffer = new StringBuilder();
                    if (movingArea.getStartLine() < startLine) {
                        line2 = movingArea.getStartLine();
                        while (line2 < startLine) {
                            info = document.getLineInformation(line2);
                            buffer.append(document.get(info.getOffset(), info.getLength())).append(document.getLineDelimiter(line2));
                            ++line2;
                        }
                    }
                    buffer.append(expectedIndents).append(startText.substring(startLineIndents.length())).append(document.getLineDelimiter(startLine));
                    line2 = startLine + 1;
                    while (line2 <= movingArea.getEndLine()) {
                        info = document.getLineInformation(line2);
                        String lineText = document.get(info.getOffset(), info.getLength());
                        if (emptyLines.contains(line2)) {
                            buffer.append(lineText);
                        } else {
                            if (!lineText.startsWith(startLineIndents)) {
                                buffer.setLength(0);
                                break;
                            }
                            buffer.append(expectedIndents).append(lineText.substring(startLineIndents.length()));
                        }
                        if (line2 != movingArea.getEndLine()) {
                            buffer.append(document.getLineDelimiter(line2));
                        }
                        ++line2;
                    }
                    if (buffer.length() > 0) {
                        indentedMoving = buffer.toString();
                    }
                }
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CommonEditorPlugin.getDefault(), (Throwable)e);
            indentedMoving = moving;
        }
        return indentedMoving;
    }

    private String getLineIndents(RubyRegexpAutoIndentStrategy autoEditStrategy, IDocument document, IRegion lineRegion) throws BadLocationException {
        int start = lineRegion.getOffset();
        int end = autoEditStrategy.findEndOfWhiteSpace(document, start, start + lineRegion.getLength());
        String currentIndents = "";
        if (end > start) {
            currentIndents = document.get(start, end - start);
        }
        return currentIndents;
    }

    private void selectAndReveal(ITextViewer viewer, int offset, int length) {
        viewer.setSelectedRange(offset + length, -length);
        StyledText st = viewer.getTextWidget();
        if (st != null) {
            st.showSelection();
        }
    }

    private void showStatus() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        IEditorStatusLine status = (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class);
        if (status == null) {
            return;
        }
        status.setMessage(false, "Move not possible - Uncheck \"Show Source of Selected Element Only\" to see the entire document", null);
    }

    public void setEditor(ITextEditor editor) {
        ITextEditor currentEditor = this.getTextEditor();
        if (currentEditor != editor && currentEditor != null && editor != null) {
            this.fTextViewer = editor instanceof AbstractTextEditor ? ((AbstractThemeableEditor)editor).getISourceViewer() : null;
        }
        super.setEditor(editor);
    }

    public void update() {
        super.update();
        if (this.isEnabled()) {
            this.setEnabled(this.canModifyEditor() && this.fTextViewer != null);
        }
    }
}

